package org.usfirst.frc.team589.robot.subsystems;

import org.usfirst.frc.team589.robot.RobotMap;

import edu.wpi.first.wpilibj.Compressor;
import edu.wpi.first.wpilibj.DoubleSolenoid;
import edu.wpi.first.wpilibj.DoubleSolenoid.Value;
import edu.wpi.first.wpilibj.command.Subsystem;

public class Pneumatics extends Subsystem{

	private Compressor compressor;
	private DoubleSolenoid solenoid;
	private boolean extended;
	public Pneumatics(){
		compressor = new Compressor(RobotMap.COMPRESSOR_PORT);
		solenoid = new DoubleSolenoid(RobotMap.EXTEND_PORT,RobotMap.RETRACT_PORT);
		extended = false;
	}
	
	public void extend(){
		if(!extended){
			solenoid.set(Value.kForward);
		}
		extended = true;
	}
	
	public void retract(){
		if(extended){
			solenoid.set(Value.kReverse);
		}
		extended = false;
	}
	
	public boolean isExtended(){
		return extended;
	}
	
	public void compress(){
		if((compressor.getPressureSwitchValue())&&(!compressor.enabled())){
			compressor.start();
		}
		else if(!compressor.getPressureSwitchValue()){
			compressor.stop();
		}
	}
	
	@Override
	protected void initDefaultCommand() {
		// TODO Auto-generated method stub
		
	}

}
