package org.usfirst.frc.team589.robot.subsystems;

import org.usfirst.frc.team589.robot.RobotMap;

import edu.wpi.first.wpilibj.CANTalon;
import edu.wpi.first.wpilibj.command.Subsystem;

public class Drive extends Subsystem{

	private CANTalon m1 = new CANTalon(RobotMap.LEFT_MOTOR);
	private CANTalon m2 = new CANTalon(RobotMap.RIGHT_MOTOR);
	@Override
	protected void initDefaultCommand() {
		// TODO Auto-generated method stub
		
	}
	
	public CANTalon getRight(){
		return m2;
	}
	
	public CANTalon getLeft(){
		return m1;
	}
	
	public void setLeft(double speed){
		m1.set(speed);
	}
	
	public void setRight(double speed){
		m2.set(speed);
	}
	
	public double getLeftDistance(){
		return m1.getEncPosition()*RobotMap.DIST_PER_PULSE;
	}
	
	public double getRightDistance(){
		return m2.getEncPosition()*RobotMap.DIST_PER_PULSE;
	}
	
	public void stop(){
		m1.set(0);
		m2.set(0);
	}
	
	public void resetEncoders(){
		m1.setEncPosition(0);
		m2.setEncPosition(0);
	}

}
