package org.usfirst.frc.team589.robot.commands;

import org.usfirst.frc.team589.robot.Robot;

import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;

public class TurnAutonomous extends Command{

	boolean boolEnd = false;
	double Speed, Deg;
	public TurnAutonomous(double deg, double speed){

		if(deg>0){
			Speed = speed;
			Deg = deg;
		}else if(deg<0){
			Speed = -speed;
			Deg = -deg;
		}
	}
	
	@Override
	protected void initialize() {
		System.out.println("turn");
		Robot.ahrs.reset();
		
		Robot.drive.setLeft(-Speed);
		Robot.drive.setRight(-Speed);
		
		boolEnd = false;
	}

	@Override
	protected void execute() {
		
		if(Math.abs(Robot.ahrs.getYaw())>Deg-5-Deg/50){
			Robot.drive.stop();
			boolEnd = true;
		}
	}

	@Override
	protected boolean isFinished() {
		// TODO Auto-generated method stub
		return boolEnd;
	}

	@Override
	protected void end() {
		// TODO Auto-generated method stub
		Robot.drive.stop();
	}

	@Override
	protected void interrupted() {
		// TODO Auto-generated method stub
		Robot.drive.stop();
	}
}
