package org.usfirst.frc.team589.robot.commands;

import org.usfirst.frc.team589.robot.Robot;

public class RobotAutonomous {
	
	private final double diameterJinx = 10.16, gearchangeJinx = (28/22), encoderJinx = 512, motordirectionJinx = 1;
	private final double diameterMelman = 35.56, gearchangeMelman = (60/10), encoderMelman = 512, motordirectionMelman = 1;
	private final double diameterNew = 35.56, gearchangeNew = (60/10), encoderNew = 8192, motordirectionNew = -1;
	private double wheeldiameter, gearchange, encoder ,motordirection;
	
	public RobotAutonomous(String robot){
		if (robot == "jinx"){wheeldiameter = diameterJinx; gearchange = gearchangeJinx; encoder = encoderJinx; motordirection = motordirectionJinx;}
		else if (robot == "melman"){wheeldiameter = diameterMelman; gearchange = gearchangeMelman; encoder = encoderMelman; motordirection = motordirectionMelman;}
		else if (robot == "new"){wheeldiameter = diameterNew; gearchange = gearchangeNew; encoder = encoderNew; motordirection = motordirectionNew;}
	}
	public RobotAutonomous(){
		wheeldiameter = diameterNew; gearchange = gearchangeNew; encoder = encoderNew; motordirection = motordirectionNew;
	}
	
	public void driveMeters(double meter, double speed){
		int encpos1 = Robot.drive.getLeft().getEncPosition();
		
		speed = speed * motordirection;
		
		if (meter < 0){
			meter = -meter;
			speed = -speed;
		}
		
		int encodersteps = (int)(((((meter*100)/(wheeldiameter*Math.PI))*encoder)*gearchange));
		
		Robot.drive.setLeft(speed);
		Robot.drive.setRight(-speed);
		
		while (true){
			if (Math.abs(Robot.drive.getLeft().getEncPosition()-encpos1)>=encodersteps){
				Robot.drive.stop();
				break;
			}
		}
		System.out.println("robot drove");
	}
	
	public void turnDegrees(double degrees, double speed){
		System.out.println("started turning");
		Robot.ahrs.reset();
		speed = speed * motordirection;
		
		if(degrees<0){
			speed = -speed;
			degrees = -degrees;
		}
		
		
		
		Robot.drive.setLeft(speed);
		Robot.drive.setRight(speed);
		
		int time = 0;
		
		while (true){
//		for(int x=0;x<50000;x++)
//		{
			time++;
			System.out.println("turning" + time);
//			if(time%100 == 0){
//				System.out.println("turning" + time);
//			}
			if(Math.abs(Robot.ahrs.getYaw())>=degrees){
				Robot.drive.stop();
				System.out.println("stopped turning");
				break;
			}
//			Thread.sleep(100);
		}
		System.out.println("robot turned");
		Robot.ahrs.reset();
	}
}


