package org.usfirst.frc.team589.robot.commands;

import org.usfirst.frc.team589.robot.Robot;

import edu.wpi.first.wpilibj.command.Command;

public class DriveAutonomous extends Command {
	
	private final double diameterJinx = 10.16, gearchangeJinx = (28/22);
	private final double diameterMalman = 35.56, gearchangeMalman = (60/10);
	private final double diameterNew = 35.56, gearchangeNew = (60/10);
	private boolean boolEnd = false;
	private int encpos1, encpos2, encodersteps;
	private double wheeldiameter, gearchange, speed, meter;

    public DriveAutonomous(String robot, double meter, double speed) {
		this.meter = meter;
		this.speed = speed;
		if (robot == "jinx"){wheeldiameter = diameterJinx;gearchange = gearchangeJinx;}
		else if (robot == "melman"){wheeldiameter = diameterMalman;gearchange = gearchangeMalman;}
		else if (robot == "new"){wheeldiameter = diameterNew;gearchange = gearchangeNew;}
    }
    
	@Override
    protected void initialize() {
		System.out.println("drive");

		encpos1 = Robot.drive.getLeft().getEncPosition();
		encpos2 = Robot.drive.getRight().getEncPosition();
		
		if (meter < 0){
			meter = -meter;
			speed = -speed;
		}
		
		//meter = meter - 0.28;
		encodersteps = (int)(((((meter*100)/(wheeldiameter*Math.PI))*512)*gearchange));
		
		Robot.drive.setLeft(speed);
		Robot.drive.setRight(-speed);
		while (true){
			if (Math.abs(Robot.drive.getLeft().getEncPosition()-encpos1)>=encodersteps){
				Robot.drive.stop();
				break;
			}
		}
		
    }
	
	@Override
    protected void execute() {
		boolEnd=true;
    }
	
	@Override
	protected boolean isFinished() {
        return boolEnd;
    }
	
	@Override
    protected void end() {
		Robot.drive.stop();
    }
	
	@Override
    protected void interrupted() {
		Robot.drive.stop();
    }
}
