
package org.usfirst.frc.team589.robot;

import org.usfirst.frc.team589.robot.commands.Autonomous;
import org.usfirst.frc.team589.robot.commands.DriveAutonomous;
import org.usfirst.frc.team589.robot.commands.DriveController;
import org.usfirst.frc.team589.robot.commands.RobotAutonomous;
import org.usfirst.frc.team589.robot.commands.TurnAutonomous;
import org.usfirst.frc.team589.robot.subsystems.Camera;
import org.usfirst.frc.team589.robot.subsystems.Drive;
import org.usfirst.frc.team589.robot.subsystems.Pneumatics;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.IterativeRobot;
import edu.wpi.first.wpilibj.Joystick;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.SPI;

//import org.usfirst.frc.team589.robot.commands.ExampleCommand;
//import org.usfirst.frc.team589.robot.subsystems.ExampleSubsystem;

import edu.wpi.first.wpilibj.smartdashboard.SendableChooser;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;

import com.kauailabs.navx.frc.*;

/**
 * The VM is configured to automatically run this class, and to call the
 * functions corresponding to each mode, as described in the IterativeRobot
 * documentation. If you change the name of this class or the package after
 * creating this project, you must also update the manifest file in the resource
 * directory.
 */
public class Robot extends IterativeRobot {

	//public static final ExampleSubsystem exampleSubsystem = new ExampleSubsystem();
	public static OI oi;
	//Camera camera;
	public static Drive drive = new Drive();
	public static Pneumatics pneumatics = new Pneumatics();
	public static double pos;
	public static DriveController driveController;
	
	public static Joystick j1;
	public static Joystick j2;
	
	public static RobotAutonomous Melman;
	
	public static AHRS ahrs;

    Command autonomousCommand;
    SendableChooser chooser;

    /**
     * This function is run when the robot is first started up and should be
     * used for any initialization code.
     */
    public void robotInit() {
    	//camera = new Camera();
    	j1 = new Joystick(RobotMap.LEFT_JOYSTICK);
    	j2 = new Joystick(RobotMap.RIGHT_JOYSTICK);
    	
		oi = new OI();
        chooser = new SendableChooser();
        //chooser.addDefault("Default Auto", new ExampleCommand());
//        chooser.addObject("My Auto", new MyAutoCommand());
        SmartDashboard.putData("Auto mode", chooser);
        try{
        	ahrs = new AHRS(SPI.Port.kMXP);
        }catch(RuntimeException ex){
        	DriverStation.reportError("Error instantiating navX MXP: "+ex.getMessage(),true);
        }
        Melman = new RobotAutonomous("melman");
        
    }
	
	/**
     * This function is called once each time the robot enters Disabled mode.
     * You can use it to reset any subsystem information you want to clear when
	 * the robot is disabled.
     */
    public void disabledInit(){
    	ahrs.reset();
    }
	
	public void disabledPeriodic() {
		Scheduler.getInstance().run();
	}

	/**
	 * This autonomous (along with the chooser code above) shows how to select between different autonomous modes
	 * using the dashboard. The sendable chooser code works with the Java SmartDashboard. If you prefer the LabVIEW
	 * Dashboard, remove all of the chooser code and uncomment the getString code to get the auto name from the text box
	 * below the Gyro
	 *
	 * You can add additional auto modes by adding additional commands to the chooser code above (like the commented example)
	 * or additional comparisons to the switch structure below with additional strings & commands.
	 */
    public void autonomousInit() {
    	ahrs.reset();
    	
    	Melman.driveMeters(1.5, 0.5);
    	Melman.turnDegrees(-90, 0.5);
    	Melman.driveMeters(1, 0.5);
    	Melman.turnDegrees(135, 0.5);
    	Melman.driveMeters(1, 0.5);
    	Melman.turnDegrees(-45, 0.5);
    	Melman.driveMeters(0.5, 0.5);
    	Melman.turnDegrees(-90, 0.5);
    	Melman.driveMeters(1, 0.5);


    	
    	
        autonomousCommand = (Command) chooser.getSelected();
        //autonomousCommand = new DriveAutonomous("melman", 3 ,0.5);
        autonomousCommand = new Autonomous();
        
		/* String autoSelected = SmartDashboard.getString("Auto Selector", "Default");
		switch(autoSelected) {
		case "My Auto":
			autonomousCommand = new MyAutoCommand();
			break;
		case "Default Auto":
		default:
			autonomousCommand = new ExampleCommand();
			break;
		} */
    	
    	// schedule the autonomous command (example)
        if (autonomousCommand != null) autonomousCommand.start();
    }

    /**
     * This function is called periodically during autonomous
     */
    public void autonomousPeriodic() {
        Scheduler.getInstance().run();
    }

    public void teleopInit() {
		// This makes sure that the autonomous stops running when
        // teleop starts running. If you want the autonomous to 
        // continue until interrupted by another command, remove
        // this line or comment it out.
        if (autonomousCommand != null) autonomousCommand.cancel();
        driveController = new DriveController();
        driveController.start();
    }

    /**
     * This function is called periodically during operator control
     */
    public void teleopPeriodic() {
    	//camera.update();
        Scheduler.getInstance().run();
    }
    
    /**
     * This function is called periodically during test mode
     */
    public void testPeriodic() {
        LiveWindow.run();
    }
}
