/*
 * Decompiled with CFR 0.152.
 */
package com.kauailabs.navx.frc;

import com.kauailabs.navx.AHRSProtocol;
import com.kauailabs.navx.frc.IRegisterIO;
import edu.wpi.first.wpilibj.SPI;
import edu.wpi.first.wpilibj.Timer;

class RegisterIO_SPI
implements IRegisterIO {
    SPI port;
    int bitrate;
    static final int DEFAULT_SPI_BITRATE_HZ = 500000;

    public RegisterIO_SPI(SPI spi_port) {
        this.port = spi_port;
        this.bitrate = 500000;
    }

    public RegisterIO_SPI(SPI spi_port, int bitrate) {
        this.port = spi_port;
        this.bitrate = bitrate;
    }

    @Override
    public boolean init() {
        this.port.setClockRate(this.bitrate);
        this.port.setMSBFirst();
        this.port.setSampleDataOnFalling();
        this.port.setClockActiveLow();
        this.port.setChipSelectActiveLow();
        return true;
    }

    @Override
    public boolean write(byte address, byte value) {
        byte[] cmd;
        cmd = new byte[]{(byte)(address | 0xFFFFFF80), value, AHRSProtocol.getCRC(cmd, 2)};
        return this.port.write(cmd, cmd.length) == cmd.length;
    }

    @Override
    public boolean read(byte first_address, byte[] buffer) {
        byte[] cmd;
        cmd = new byte[]{first_address, (byte)buffer.length, AHRSProtocol.getCRC(cmd, 2)};
        if (this.port.write(cmd, cmd.length) != cmd.length) {
            return false;
        }
        Timer.delay((double)0.001);
        byte[] received_data = new byte[buffer.length + 1];
        if (this.port.read(true, received_data, received_data.length) != received_data.length) {
            return false;
        }
        byte crc = AHRSProtocol.getCRC(received_data, received_data.length - 1);
        if (crc != received_data[received_data.length - 1]) {
            return false;
        }
        System.arraycopy(received_data, 0, buffer, 0, received_data.length - 1);
        return true;
    }

    @Override
    public boolean shutdown() {
        return true;
    }
}

