/*
 * Decompiled with CFR 0.152.
 */
package com.kauailabs.navx.frc;

class ContinuousAngleTracker {
    private float last_angle = 0.0f;
    private double last_rate = 0.0;
    private int zero_crossing_count = 0;

    public void nextAngle(float newAngle) {
        float adjusted_last_angle = this.last_angle < 0.0f ? this.last_angle + 360.0f : this.last_angle;
        float adjusted_curr_angle = newAngle < 0.0f ? newAngle + 360.0f : newAngle;
        float delta_angle = adjusted_curr_angle - adjusted_last_angle;
        this.last_rate = delta_angle;
        int angle_last_direction = 0;
        if (adjusted_curr_angle < adjusted_last_angle) {
            angle_last_direction = delta_angle < -180.0f ? -1 : 1;
        } else if (adjusted_curr_angle > adjusted_last_angle) {
            angle_last_direction = delta_angle > 180.0f ? -1 : 1;
        }
        if (angle_last_direction < 0) {
            if (adjusted_curr_angle < 0.0f && adjusted_last_angle >= 0.0f) {
                --this.zero_crossing_count;
            }
        } else if (angle_last_direction > 0 && adjusted_curr_angle >= 0.0f && adjusted_last_angle < 0.0f) {
            ++this.zero_crossing_count;
        }
        this.last_angle = newAngle;
    }

    public double getAngle() {
        double accumulated_angle = (double)this.zero_crossing_count * 360.0;
        double curr_angle = this.last_angle;
        if (curr_angle < 0.0) {
            curr_angle += 360.0;
        }
        return accumulated_angle += curr_angle;
    }

    public double getRate() {
        return this.last_rate;
    }
}

