/*
 * Decompiled with CFR 0.152.
 */
package org.usfirst.frc.team589.robot.subsystems;

import edu.wpi.first.wpilibj.Compressor;
import edu.wpi.first.wpilibj.DoubleSolenoid;
import edu.wpi.first.wpilibj.command.Subsystem;
import org.usfirst.frc.team589.robot.RobotMap;

public class Pneumatics
extends Subsystem {
    private Compressor compressor = new Compressor(RobotMap.COMPRESSOR_PORT);
    private DoubleSolenoid solenoid = new DoubleSolenoid(RobotMap.EXTEND_PORT, RobotMap.RETRACT_PORT);
    private boolean extended = false;

    public void extend() {
        if (!this.extended) {
            this.solenoid.set(DoubleSolenoid.Value.kForward);
        }
        this.extended = true;
    }

    public void retract() {
        if (this.extended) {
            this.solenoid.set(DoubleSolenoid.Value.kReverse);
        }
        this.extended = false;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void compress() {
        if (this.compressor.getPressureSwitchValue() && !this.compressor.enabled()) {
            this.compressor.start();
        } else if (!this.compressor.getPressureSwitchValue()) {
            this.compressor.stop();
        }
    }

    @Override
    protected void initDefaultCommand() {
    }
}

