/*
 * Decompiled with CFR 0.152.
 */
package org.usfirst.frc.team589.robot.commands;

import org.usfirst.frc.team589.robot.Robot;

public class RobotAutonomous {
    private final double diameterJinx = 10.16;
    private final double gearchangeJinx = 1.0;
    private final double encoderJinx = 512.0;
    private final double motordirectionJinx = 1.0;
    private final double diameterMelman = 35.56;
    private final double gearchangeMelman = 6.0;
    private final double encoderMelman = 512.0;
    private final double motordirectionMelman = 1.0;
    private final double diameterNew = 35.56;
    private final double gearchangeNew = 6.0;
    private final double encoderNew = 8192.0;
    private final double motordirectionNew = -1.0;
    private double wheeldiameter;
    private double gearchange;
    private double encoder;
    private double motordirection;

    public RobotAutonomous(String robot) {
        if (robot == "jinx") {
            this.wheeldiameter = 10.16;
            this.gearchange = 1.0;
            this.encoder = 512.0;
            this.motordirection = 1.0;
        } else if (robot == "melman") {
            this.wheeldiameter = 35.56;
            this.gearchange = 6.0;
            this.encoder = 512.0;
            this.motordirection = 1.0;
        } else if (robot == "new") {
            this.wheeldiameter = 35.56;
            this.gearchange = 6.0;
            this.encoder = 8192.0;
            this.motordirection = -1.0;
        }
    }

    public RobotAutonomous() {
        this.wheeldiameter = 35.56;
        this.gearchange = 6.0;
        this.encoder = 8192.0;
        this.motordirection = -1.0;
    }

    public void driveMeters(double meter, double speed) {
        int encpos1 = Robot.drive.getLeft().getEncPosition();
        speed *= this.motordirection;
        if (meter < 0.0) {
            meter = -meter;
            speed = -speed;
        }
        int encodersteps = (int)(meter * 100.0 / (this.wheeldiameter * Math.PI) * this.encoder * this.gearchange);
        Robot.drive.setLeft(speed);
        Robot.drive.setRight(-speed);
        while (Math.abs(Robot.drive.getLeft().getEncPosition() - encpos1) < encodersteps) {
        }
        Robot.drive.stop();
        System.out.println("robot drove");
    }

    public void turnDegrees(double degrees, double speed) {
        System.out.println("started turning");
        Robot.ahrs.reset();
        speed *= this.motordirection;
        if (degrees < 0.0) {
            speed = -speed;
            degrees = -degrees;
        }
        Robot.drive.setLeft(speed);
        Robot.drive.setRight(speed);
        int time = 0;
        do {
            System.out.println("turning" + ++time);
        } while (!((double)Math.abs(Robot.ahrs.getYaw()) >= degrees));
        Robot.drive.stop();
        System.out.println("stopped turning");
        System.out.println("robot turned");
        Robot.ahrs.reset();
    }
}

