/*
 * Decompiled with CFR 0.152.
 */
package org.usfirst.frc.team589.robot.commands;

import edu.wpi.first.wpilibj.command.Command;
import org.usfirst.frc.team589.robot.Robot;

public class DriveAutonomous
extends Command {
    private final double diameterJinx = 10.16;
    private final double gearchangeJinx = 1.0;
    private final double diameterMalman = 35.56;
    private final double gearchangeMalman = 6.0;
    private final double diameterNew = 35.56;
    private final double gearchangeNew = 6.0;
    private boolean boolEnd = false;
    private int encpos1;
    private int encpos2;
    private int encodersteps;
    private double wheeldiameter;
    private double gearchange;
    private double speed;
    private double meter;

    public DriveAutonomous(String robot, double meter, double speed) {
        this.meter = meter;
        this.speed = speed;
        if (robot == "jinx") {
            this.wheeldiameter = 10.16;
            this.gearchange = 1.0;
        } else if (robot == "melman") {
            this.wheeldiameter = 35.56;
            this.gearchange = 6.0;
        } else if (robot == "new") {
            this.wheeldiameter = 35.56;
            this.gearchange = 6.0;
        }
    }

    @Override
    protected void initialize() {
        System.out.println("drive");
        this.encpos1 = Robot.drive.getLeft().getEncPosition();
        this.encpos2 = Robot.drive.getRight().getEncPosition();
        if (this.meter < 0.0) {
            this.meter = -this.meter;
            this.speed = -this.speed;
        }
        this.encodersteps = (int)(this.meter * 100.0 / (this.wheeldiameter * Math.PI) * 512.0 * this.gearchange);
        Robot.drive.setLeft(this.speed);
        Robot.drive.setRight(-this.speed);
        while (Math.abs(Robot.drive.getLeft().getEncPosition() - this.encpos1) < this.encodersteps) {
        }
        Robot.drive.stop();
    }

    @Override
    protected void execute() {
        this.boolEnd = true;
    }

    @Override
    protected boolean isFinished() {
        return this.boolEnd;
    }

    @Override
    protected void end() {
        Robot.drive.stop();
    }

    @Override
    protected void interrupted() {
        Robot.drive.stop();
    }
}

