/*
 * Decompiled with CFR 0.152.
 */
package org.usfirst.frc.team589.robot;

import com.kauailabs.navx.frc.AHRS;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.IterativeRobot;
import edu.wpi.first.wpilibj.Joystick;
import edu.wpi.first.wpilibj.SPI;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.smartdashboard.SendableChooser;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import org.usfirst.frc.team589.robot.OI;
import org.usfirst.frc.team589.robot.RobotMap;
import org.usfirst.frc.team589.robot.commands.Autonomous;
import org.usfirst.frc.team589.robot.commands.DriveController;
import org.usfirst.frc.team589.robot.commands.RobotAutonomous;
import org.usfirst.frc.team589.robot.subsystems.Drive;
import org.usfirst.frc.team589.robot.subsystems.Pneumatics;

public class Robot
extends IterativeRobot {
    public static OI oi;
    public static Drive drive;
    public static Pneumatics pneumatics;
    public static double pos;
    public static DriveController driveController;
    public static Joystick j1;
    public static Joystick j2;
    public static RobotAutonomous Melman;
    public static AHRS ahrs;
    Command autonomousCommand;
    SendableChooser chooser;

    @Override
    public void robotInit() {
        j1 = new Joystick(RobotMap.LEFT_JOYSTICK);
        j2 = new Joystick(RobotMap.RIGHT_JOYSTICK);
        oi = new OI();
        this.chooser = new SendableChooser();
        SmartDashboard.putData("Auto mode", this.chooser);
        try {
            ahrs = new AHRS(SPI.Port.kMXP);
        }
        catch (RuntimeException ex) {
            DriverStation.reportError("Error instantiating navX MXP: " + ex.getMessage(), true);
        }
        Melman = new RobotAutonomous("melman");
    }

    @Override
    public void disabledInit() {
        ahrs.reset();
    }

    @Override
    public void disabledPeriodic() {
        Scheduler.getInstance().run();
    }

    @Override
    public void autonomousInit() {
        ahrs.reset();
        Melman.driveMeters(1.5, 0.5);
        Melman.turnDegrees(-90.0, 0.5);
        Melman.driveMeters(1.0, 0.5);
        Melman.turnDegrees(135.0, 0.5);
        Melman.driveMeters(1.0, 0.5);
        Melman.turnDegrees(-45.0, 0.5);
        Melman.driveMeters(0.5, 0.5);
        Melman.turnDegrees(-90.0, 0.5);
        Melman.driveMeters(1.0, 0.5);
        this.autonomousCommand = (Command)this.chooser.getSelected();
        this.autonomousCommand = new Autonomous();
        if (this.autonomousCommand != null) {
            this.autonomousCommand.start();
        }
    }

    @Override
    public void autonomousPeriodic() {
        Scheduler.getInstance().run();
    }

    @Override
    public void teleopInit() {
        if (this.autonomousCommand != null) {
            this.autonomousCommand.cancel();
        }
        driveController = new DriveController();
        driveController.start();
    }

    @Override
    public void teleopPeriodic() {
        Scheduler.getInstance().run();
    }

    @Override
    public void testPeriodic() {
        LiveWindow.run();
    }

    static {
        drive = new Drive();
        pneumatics = new Pneumatics();
    }
}

