/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.vision;

import com.ni.vision.NIVision;
import com.ni.vision.VisionException;
import edu.wpi.first.wpilibj.Timer;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class USBCamera {
    public static String kDefaultCameraName = "cam0";
    private static String ATTR_VIDEO_MODE = "AcquisitionAttributes::VideoMode";
    private static String ATTR_WB_MODE = "CameraAttributes::WhiteBalance::Mode";
    private static String ATTR_WB_VALUE = "CameraAttributes::WhiteBalance::Value";
    private static String ATTR_EX_MODE = "CameraAttributes::Exposure::Mode";
    private static String ATTR_EX_VALUE = "CameraAttributes::Exposure::Value";
    private static String ATTR_BR_MODE = "CameraAttributes::Brightness::Mode";
    private static String ATTR_BR_VALUE = "CameraAttributes::Brightness::Value";
    private Pattern m_reMode = Pattern.compile("(?<width>[0-9]+)\\s*x\\s*(?<height>[0-9]+)\\s+(?<format>.*?)\\s+(?<fps>[0-9.]+)\\s*fps");
    private String m_name = kDefaultCameraName;
    private int m_id = -1;
    private boolean m_active = false;
    private boolean m_useJpeg = true;
    private int m_width = 320;
    private int m_height = 240;
    private int m_fps = 30;
    private String m_whiteBalance = "auto";
    private int m_whiteBalanceValue = -1;
    private String m_exposure = "auto";
    private int m_exposureValue = -1;
    private int m_brightness = 50;
    private boolean m_needSettingsUpdate = true;

    public USBCamera() {
        this.openCamera();
    }

    public USBCamera(String name) {
        this.m_name = name;
        this.openCamera();
    }

    public synchronized void openCamera() {
        if (this.m_id != -1) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                this.m_id = NIVision.IMAQdxOpenCamera(this.m_name, NIVision.IMAQdxCameraControlMode.CameraControlModeController);
                break;
            }
            catch (VisionException e) {
                if (i == 2) {
                    throw e;
                }
                Timer.delay(2.0);
                continue;
            }
        }
    }

    public synchronized void closeCamera() {
        if (this.m_id == -1) {
            return;
        }
        NIVision.IMAQdxCloseCamera(this.m_id);
        this.m_id = -1;
    }

    public synchronized void startCapture() {
        if (this.m_id == -1 || this.m_active) {
            return;
        }
        NIVision.IMAQdxConfigureGrab(this.m_id);
        NIVision.IMAQdxStartAcquisition(this.m_id);
        this.m_active = true;
    }

    public synchronized void stopCapture() {
        if (this.m_id == -1 || !this.m_active) {
            return;
        }
        NIVision.IMAQdxStopAcquisition(this.m_id);
        NIVision.IMAQdxUnconfigureAcquisition(this.m_id);
        this.m_active = false;
    }

    public synchronized void updateSettings() {
        boolean wasActive = this.m_active;
        if (wasActive) {
            this.stopCapture();
        }
        if (this.m_id != -1) {
            this.closeCamera();
        }
        this.openCamera();
        NIVision.dxEnumerateVideoModesResult enumerated = NIVision.IMAQdxEnumerateVideoModes(this.m_id);
        NIVision.IMAQdxEnumItem foundMode = null;
        int foundFps = 1000;
        for (NIVision.IMAQdxEnumItem mode : enumerated.videoModeArray) {
            boolean isJpeg;
            double fps;
            Matcher m = this.m_reMode.matcher(mode.Name);
            if (!m.matches() || Integer.parseInt(m.group("width")) != this.m_width || Integer.parseInt(m.group("height")) != this.m_height || (fps = Double.parseDouble(m.group("fps"))) < (double)this.m_fps || fps > (double)foundFps) continue;
            String format = m.group("format");
            boolean bl = isJpeg = format.equals("jpeg") || format.equals("JPEG");
            if (this.m_useJpeg && !isJpeg || !this.m_useJpeg && isJpeg) continue;
            foundMode = mode;
            foundFps = (int)fps;
        }
        if (foundMode != null) {
            System.out.println("found mode " + foundMode.Value + ": " + foundMode.Name);
            if (foundMode.Value != enumerated.currentMode) {
                NIVision.IMAQdxSetAttributeU32(this.m_id, ATTR_VIDEO_MODE, foundMode.Value);
            }
        }
        if (this.m_whiteBalance == "auto") {
            NIVision.IMAQdxSetAttributeString(this.m_id, ATTR_WB_MODE, "Auto");
        } else {
            NIVision.IMAQdxSetAttributeString(this.m_id, ATTR_WB_MODE, "Manual");
            if (this.m_whiteBalanceValue != -1) {
                NIVision.IMAQdxSetAttributeI64(this.m_id, ATTR_WB_VALUE, this.m_whiteBalanceValue);
            }
        }
        if (this.m_exposure == "auto") {
            NIVision.IMAQdxSetAttributeString(this.m_id, ATTR_EX_MODE, "AutoAperaturePriority");
        } else {
            NIVision.IMAQdxSetAttributeString(this.m_id, ATTR_EX_MODE, "Manual");
            if (this.m_exposureValue != -1) {
                long minv = NIVision.IMAQdxGetAttributeMinimumI64(this.m_id, ATTR_EX_VALUE);
                long maxv = NIVision.IMAQdxGetAttributeMaximumI64(this.m_id, ATTR_EX_VALUE);
                long val = minv + (long)((double)(maxv - minv) * ((double)this.m_exposureValue / 100.0));
                NIVision.IMAQdxSetAttributeI64(this.m_id, ATTR_EX_VALUE, val);
            }
        }
        NIVision.IMAQdxSetAttributeString(this.m_id, ATTR_BR_MODE, "Manual");
        long minv = NIVision.IMAQdxGetAttributeMinimumI64(this.m_id, ATTR_BR_VALUE);
        long maxv = NIVision.IMAQdxGetAttributeMaximumI64(this.m_id, ATTR_BR_VALUE);
        long val = minv + (long)((double)(maxv - minv) * ((double)this.m_brightness / 100.0));
        NIVision.IMAQdxSetAttributeI64(this.m_id, ATTR_BR_VALUE, val);
        if (wasActive) {
            this.startCapture();
        }
    }

    public synchronized void setFPS(int fps) {
        if (fps != this.m_fps) {
            this.m_needSettingsUpdate = true;
            this.m_fps = fps;
        }
    }

    public synchronized void setSize(int width, int height) {
        if (width != this.m_width || height != this.m_height) {
            this.m_needSettingsUpdate = true;
            this.m_width = width;
            this.m_height = height;
        }
    }

    public synchronized void setBrightness(int brightness) {
        this.m_brightness = brightness > 100 ? 100 : (brightness < 0 ? 0 : brightness);
        this.m_needSettingsUpdate = true;
    }

    public synchronized int getBrightness() {
        return this.m_brightness;
    }

    public synchronized void setWhiteBalanceAuto() {
        this.m_whiteBalance = "auto";
        this.m_whiteBalanceValue = -1;
        this.m_needSettingsUpdate = true;
    }

    public synchronized void setWhiteBalanceHoldCurrent() {
        this.m_whiteBalance = "manual";
        this.m_whiteBalanceValue = -1;
        this.m_needSettingsUpdate = true;
    }

    public synchronized void setWhiteBalanceManual(int value) {
        this.m_whiteBalance = "manual";
        this.m_whiteBalanceValue = value;
        this.m_needSettingsUpdate = true;
    }

    public synchronized void setExposureAuto() {
        this.m_exposure = "auto";
        this.m_exposureValue = -1;
        this.m_needSettingsUpdate = true;
    }

    public synchronized void setExposureHoldCurrent() {
        this.m_exposure = "manual";
        this.m_exposureValue = -1;
        this.m_needSettingsUpdate = true;
    }

    public synchronized void setExposureManual(int value) {
        this.m_exposure = "manual";
        this.m_exposureValue = value > 100 ? 100 : (value < 0 ? 0 : value);
        this.m_needSettingsUpdate = true;
    }

    public synchronized void getImage(NIVision.Image image) {
        if (this.m_needSettingsUpdate || this.m_useJpeg) {
            this.m_needSettingsUpdate = false;
            this.m_useJpeg = false;
            this.updateSettings();
        }
        NIVision.IMAQdxGrab(this.m_id, image, 1);
    }

    public synchronized void getImageData(ByteBuffer data) {
        if (this.m_needSettingsUpdate || !this.m_useJpeg) {
            this.m_needSettingsUpdate = false;
            this.m_useJpeg = true;
            this.updateSettings();
        }
        NIVision.IMAQdxGetImageData(this.m_id, data, NIVision.IMAQdxBufferNumberMode.BufferNumberModeLast, 0);
        data.limit(data.capacity() - 1);
        data.limit(USBCamera.getJpegSize(data));
    }

    private static int getJpegSize(ByteBuffer data) {
        if (data.get(0) != -1 || data.get(1) != -40) {
            throw new VisionException("invalid image");
        }
        int pos = 2;
        try {
            block2: while (true) {
                int len;
                byte b;
                if ((b = data.get(pos)) != -1) {
                    throw new VisionException("invalid image at pos " + pos + " (" + data.get(pos) + ")");
                }
                b = data.get(pos + 1);
                if (b == 1 || b >= -48 && b <= -41) {
                    pos += 2;
                    continue;
                }
                if (b == -39) {
                    return pos + 2;
                }
                if (b == -40) {
                    throw new VisionException("invalid image");
                }
                if (b == -38) {
                    len = (data.get(pos + 2) & 0xFF) << 8 | data.get(pos + 3) & 0xFF;
                    pos += len + 2;
                    while (true) {
                        if (data.get(pos) == -1 && data.get(pos + 1) != 0 && (data.get(pos + 1) < -48 || data.get(pos + 1) > -41)) continue block2;
                        ++pos;
                    }
                }
                len = (data.get(pos + 2) & 0xFF) << 8 | data.get(pos + 3) & 0xFF;
                pos += len + 2;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new VisionException("invalid image: could not find jpeg end " + ex.getMessage());
        }
    }

    public class WhiteBalance {
        public static final int kFixedIndoor = 3000;
        public static final int kFixedOutdoor1 = 4000;
        public static final int kFixedOutdoor2 = 5000;
        public static final int kFixedFluorescent1 = 5100;
        public static final int kFixedFlourescent2 = 5200;
    }
}

