/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.vision;

import com.ni.vision.NIVision;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.image.ColorImage;
import edu.wpi.first.wpilibj.image.HSLImage;
import edu.wpi.first.wpilibj.image.NIVisionException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;

public class AxisCamera {
    private static final String[] kWhiteBalanceStrings = new String[]{"auto", "hold", "fixed_outdoor1", "fixed_outdoor2", "fixed_indoor", "fixed_fluor1", "fixed_fluor2"};
    private static final String[] kExposureControlStrings = new String[]{"auto", "hold", "flickerfree50", "flickerfree60"};
    private static final String[] kResolutionStrings = new String[]{"640x480", "480x360", "320x240", "240x180", "176x144", "160x120"};
    private static final String[] kRotationStrings = new String[]{"0", "180"};
    private static final int kImageBufferAllocationIncrement = 1000;
    private String m_cameraHost;
    private Socket m_cameraSocket;
    private ByteBuffer m_imageData = ByteBuffer.allocate(5000);
    private final Object m_imageDataLock = new Object();
    private boolean m_freshImage = false;
    private int m_brightness = 50;
    private WhiteBalance m_whiteBalance = WhiteBalance.kAutomatic;
    private int m_colorLevel = 50;
    private ExposureControl m_exposureControl = ExposureControl.kAutomatic;
    private int m_exposurePriority = 50;
    private int m_maxFPS = 0;
    private Resolution m_resolution = Resolution.k640x480;
    private int m_compression = 50;
    private Rotation m_rotation = Rotation.k0;
    private final Object m_parametersLock = new Object();
    private boolean m_parametersDirty = true;
    private boolean m_streamDirty = true;
    private boolean m_done = false;
    private Thread m_captureThread = new Thread(new Runnable(){

        @Override
        public void run() {
            int consecutiveErrors = 0;
            while (!AxisCamera.this.m_done) {
                block3: {
                    String requestString = "GET /mjpg/video.mjpg HTTP/1.1\nUser-Agent: HTTPStreamClient\nConnection: Keep-Alive\nCache-Control: no-cache\nAuthorization: Basic RlJDOkZSQw==\n\n";
                    try {
                        AxisCamera.this.m_cameraSocket = AxisCamera.this.createCameraSocket(requestString);
                        AxisCamera.this.readImagesFromCamera();
                        consecutiveErrors = 0;
                    }
                    catch (IOException e) {
                        if (++consecutiveErrors <= 5) break block3;
                        e.printStackTrace();
                    }
                }
                Timer.delay(0.5);
            }
        }
    });

    public AxisCamera(String cameraHost) {
        this.m_cameraHost = cameraHost;
        this.m_captureThread.start();
    }

    public boolean isFreshImage() {
        return this.m_freshImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getImage(NIVision.Image image) {
        if (this.m_imageData.limit() == 0) {
            return false;
        }
        Object object = this.m_imageDataLock;
        synchronized (object) {
            NIVision.Priv_ReadJPEGString_C(image, this.m_imageData.array());
        }
        this.m_freshImage = false;
        return true;
    }

    public boolean getImage(ColorImage image) {
        return this.getImage(image.image);
    }

    public HSLImage getImage() throws NIVisionException {
        HSLImage image = new HSLImage();
        this.getImage(image);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBrightness(int brightness) {
        if (brightness < 0 || brightness > 100) {
            throw new IllegalArgumentException("Brightness must be from 0 to 100");
        }
        Object object = this.m_parametersLock;
        synchronized (object) {
            if (this.m_brightness != brightness) {
                this.m_brightness = brightness;
                this.m_parametersDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBrightness() {
        Object object = this.m_parametersLock;
        synchronized (object) {
            return this.m_brightness;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeWhiteBalance(WhiteBalance whiteBalance) {
        Object object = this.m_parametersLock;
        synchronized (object) {
            if (this.m_whiteBalance != whiteBalance) {
                this.m_whiteBalance = whiteBalance;
                this.m_parametersDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WhiteBalance getWhiteBalance() {
        Object object = this.m_parametersLock;
        synchronized (object) {
            return this.m_whiteBalance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeColorLevel(int colorLevel) {
        if (colorLevel < 0 || colorLevel > 100) {
            throw new IllegalArgumentException("Color level must be from 0 to 100");
        }
        Object object = this.m_parametersLock;
        synchronized (object) {
            if (this.m_colorLevel != colorLevel) {
                this.m_colorLevel = colorLevel;
                this.m_parametersDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColorLevel() {
        Object object = this.m_parametersLock;
        synchronized (object) {
            return this.m_colorLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExposureControl(ExposureControl exposureControl) {
        Object object = this.m_parametersLock;
        synchronized (object) {
            if (this.m_exposureControl != exposureControl) {
                this.m_exposureControl = exposureControl;
                this.m_parametersDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExposureControl getExposureControl() {
        Object object = this.m_parametersLock;
        synchronized (object) {
            return this.m_exposureControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExposurePriority(int exposurePriority) {
        if (exposurePriority != 0 && exposurePriority != 50 && exposurePriority != 100) {
            throw new IllegalArgumentException("Exposure priority must be 0, 50, or 100");
        }
        Object object = this.m_parametersLock;
        synchronized (object) {
            if (this.m_exposurePriority != exposurePriority) {
                this.m_exposurePriority = exposurePriority;
                this.m_parametersDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExposurePriority() {
        Object object = this.m_parametersLock;
        synchronized (object) {
            return this.m_exposurePriority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMaxFPS(int maxFPS) {
        Object object = this.m_parametersLock;
        synchronized (object) {
            if (this.m_maxFPS != maxFPS) {
                this.m_maxFPS = maxFPS;
                this.m_parametersDirty = true;
                this.m_streamDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxFPS() {
        Object object = this.m_parametersLock;
        synchronized (object) {
            return this.m_maxFPS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResolution(Resolution resolution) {
        Object object = this.m_parametersLock;
        synchronized (object) {
            if (this.m_resolution != resolution) {
                this.m_resolution = resolution;
                this.m_parametersDirty = true;
                this.m_streamDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution getResolution() {
        Object object = this.m_parametersLock;
        synchronized (object) {
            return this.m_resolution;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCompression(int compression) {
        if (compression < 0 || compression > 100) {
            throw new IllegalArgumentException("Compression must be from 0 to 100");
        }
        Object object = this.m_parametersLock;
        synchronized (object) {
            if (this.m_compression != compression) {
                this.m_compression = compression;
                this.m_parametersDirty = true;
                this.m_streamDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCompression() {
        Object object = this.m_parametersLock;
        synchronized (object) {
            return this.m_compression;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRotation(Rotation rotation) {
        Object object = this.m_parametersLock;
        synchronized (object) {
            if (this.m_rotation != rotation) {
                this.m_rotation = rotation;
                this.m_parametersDirty = true;
                this.m_streamDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rotation getRotation() {
        Object object = this.m_parametersLock;
        synchronized (object) {
            return this.m_rotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImagesFromCamera() throws IOException {
        DataInputStream cameraInputStream = new DataInputStream(this.m_cameraSocket.getInputStream());
        while (!this.m_done) {
            String line = cameraInputStream.readLine();
            if (!line.startsWith("Content-Length: ")) continue;
            int contentLength = Integer.valueOf(line.substring(16));
            cameraInputStream.readLine();
            byte[] data = new byte[contentLength -= 4];
            cameraInputStream.readFully(data);
            Object object = this.m_imageDataLock;
            synchronized (object) {
                if (this.m_imageData.capacity() < data.length) {
                    this.m_imageData = ByteBuffer.allocate(data.length + 1000);
                }
                this.m_imageData.clear();
                this.m_imageData.limit(contentLength);
                this.m_imageData.put(data);
                this.m_freshImage = true;
            }
            if (this.writeParameters()) break;
            cameraInputStream.readLine();
            cameraInputStream.readLine();
        }
        this.m_cameraSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeParameters() {
        if (this.m_parametersDirty) {
            String request = "GET /axis-cgi/admin/param.cgi?action=update";
            Object object = this.m_parametersLock;
            synchronized (object) {
                request = request + "&ImageSource.I0.Sensor.Brightness=" + this.m_brightness;
                request = request + "&ImageSource.I0.Sensor.WhiteBalance=" + kWhiteBalanceStrings[this.m_whiteBalance.ordinal()];
                request = request + "&ImageSource.I0.Sensor.ColorLevel=" + this.m_colorLevel;
                request = request + "&ImageSource.I0.Sensor.Exposure=" + kExposureControlStrings[this.m_exposureControl.ordinal()];
                request = request + "&ImageSource.I0.Sensor.ExposurePriority=" + this.m_exposurePriority;
                request = request + "&Image.I0.Stream.FPS=" + this.m_maxFPS;
                request = request + "&Image.I0.Appearance.Resolution=" + kResolutionStrings[this.m_resolution.ordinal()];
                request = request + "&Image.I0.Appearance.Compression=" + this.m_compression;
                request = request + "&Image.I0.Appearance.Rotation=" + kRotationStrings[this.m_rotation.ordinal()];
            }
            request = request + " HTTP/1.1\n";
            request = request + "User-Agent: HTTPStreamClient\n";
            request = request + "Connection: Keep-Alive\n";
            request = request + "Cache-Control: no-cache\n";
            request = request + "Authorization: Basic RlJDOkZSQw==\n\n";
            try {
                Socket socket = this.createCameraSocket(request);
                socket.close();
                this.m_parametersDirty = false;
                if (this.m_streamDirty) {
                    this.m_streamDirty = false;
                    return true;
                }
                return false;
            }
            catch (IOException | NullPointerException e) {
                return false;
            }
        }
        return false;
    }

    private Socket createCameraSocket(String requestString) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(this.m_cameraHost, 80), 5000);
        OutputStream socketOutputStream = socket.getOutputStream();
        socketOutputStream.write(requestString.getBytes());
        return socket;
    }

    public String toString() {
        return "AxisCamera{FreshImage=" + this.isFreshImage() + ", Brightness=" + this.getBrightness() + ", WhiteBalance=" + (Object)((Object)this.getWhiteBalance()) + ", ColorLevel=" + this.getColorLevel() + ", ExposureControl=" + (Object)((Object)this.getExposureControl()) + ", ExposurePriority=" + this.getExposurePriority() + ", MaxFPS=" + this.getMaxFPS() + ", Resolution=" + (Object)((Object)this.getResolution()) + ", Compression=" + this.getCompression() + ", Rotation=" + (Object)((Object)this.getRotation()) + '}';
    }

    public static enum Rotation {
        k0,
        k180;

    }

    public static enum Resolution {
        k640x480,
        k480x360,
        k320x240,
        k240x180,
        k176x144,
        k160x120;

    }

    public static enum ExposureControl {
        kAutomatic,
        kHold,
        kFlickerFree50Hz,
        kFlickerFree60Hz;

    }

    public static enum WhiteBalance {
        kAutomatic,
        kHold,
        kFixedOutdoor1,
        kFixedOutdoor2,
        kFixedIndoor,
        kFixedFluorescent1,
        kFixedFluorescent2;

    }
}

