/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.internal;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.Utility;

public class HardwareTimer
implements Timer.StaticInterface {
    @Override
    public void delay(double seconds) {
        try {
            Thread.sleep((long)(seconds * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public double getFPGATimestamp() {
        return (double)Utility.getFPGATime() / 1000000.0;
    }

    @Override
    public double getMatchTime() {
        return DriverStation.getInstance().getMatchTime();
    }

    @Override
    public Timer.Interface newTimer() {
        return new TimerImpl();
    }

    class TimerImpl
    implements Timer.Interface {
        private long m_startTime;
        private double m_accumulatedTime;
        private boolean m_running;

        public TimerImpl() {
            this.reset();
        }

        private long getMsClock() {
            return Utility.getFPGATime() / 1000L;
        }

        @Override
        public synchronized double get() {
            if (this.m_running) {
                return ((double)(this.getMsClock() - this.m_startTime) + this.m_accumulatedTime) / 1000.0;
            }
            return this.m_accumulatedTime;
        }

        @Override
        public synchronized void reset() {
            this.m_accumulatedTime = 0.0;
            this.m_startTime = this.getMsClock();
        }

        @Override
        public synchronized void start() {
            this.m_startTime = this.getMsClock();
            this.m_running = true;
        }

        @Override
        public synchronized void stop() {
            double temp;
            this.m_accumulatedTime = temp = this.get();
            this.m_running = false;
        }

        @Override
        public synchronized boolean hasPeriodPassed(double period) {
            if (this.get() > period) {
                this.m_startTime = (long)((double)this.m_startTime + period * 1000.0);
                return true;
            }
            return false;
        }
    }
}

