/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import com.ni.vision.NIVision;
import edu.wpi.first.wpilibj.image.NIVisionException;

public abstract class ImageBase {
    public final NIVision.Image image;
    static final int DEFAULT_BORDER_SIZE = 3;

    ImageBase(NIVision.ImageType type) throws NIVisionException {
        this.image = NIVision.imaqCreateImage(type, 3);
    }

    ImageBase(ImageBase sourceImage) {
        this.image = sourceImage.image;
    }

    public void write(String fileName) throws NIVisionException {
        NIVision.RGBValue value = new NIVision.RGBValue();
        NIVision.imaqWriteFile(this.image, fileName, value);
        value.free();
    }

    public void free() throws NIVisionException {
        this.image.free();
    }

    public int getHeight() throws NIVisionException {
        return NIVision.imaqGetImageSize((NIVision.Image)this.image).height;
    }

    public int getWidth() throws NIVisionException {
        return NIVision.imaqGetImageSize((NIVision.Image)this.image).width;
    }
}

