/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.filters;

import edu.wpi.first.wpilibj.CircularBuffer;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.filters.Filter;

public class LinearDigitalFilter
extends Filter {
    private CircularBuffer m_inputs;
    private CircularBuffer m_outputs;
    private double[] m_inputGains;
    private double[] m_outputGains;

    public LinearDigitalFilter(PIDSource source, double[] ffGains, double[] fbGains) {
        super(source);
        this.m_inputs = new CircularBuffer(ffGains.length);
        this.m_outputs = new CircularBuffer(fbGains.length);
        this.m_inputGains = ffGains;
        this.m_outputGains = fbGains;
    }

    public static LinearDigitalFilter singlePoleIIR(PIDSource source, double timeConstant, double period) {
        double gain = Math.exp(-period / timeConstant);
        double[] ffGains = new double[]{1.0 - gain};
        double[] fbGains = new double[]{-gain};
        return new LinearDigitalFilter(source, ffGains, fbGains);
    }

    public static LinearDigitalFilter highPass(PIDSource source, double timeConstant, double period) {
        double gain = Math.exp(-period / timeConstant);
        double[] ffGains = new double[]{gain, -gain};
        double[] fbGains = new double[]{-gain};
        return new LinearDigitalFilter(source, ffGains, fbGains);
    }

    public static LinearDigitalFilter movingAverage(PIDSource source, int taps) {
        if (taps <= 0) {
            throw new IllegalArgumentException("Number of taps was not at least 1");
        }
        double[] ffGains = new double[taps];
        for (int i = 0; i < ffGains.length; ++i) {
            ffGains[i] = 1.0 / (double)taps;
        }
        double[] fbGains = new double[]{};
        return new LinearDigitalFilter(source, ffGains, fbGains);
    }

    @Override
    public double get() {
        int i;
        double retVal = 0.0;
        for (i = 0; i < this.m_inputGains.length; ++i) {
            retVal += this.m_inputs.get(i) * this.m_inputGains[i];
        }
        for (i = 0; i < this.m_outputGains.length; ++i) {
            retVal -= this.m_outputs.get(i) * this.m_outputGains[i];
        }
        return retVal;
    }

    @Override
    public void reset() {
        this.m_inputs.reset();
        this.m_outputs.reset();
    }

    @Override
    public double pidGet() {
        int i;
        double retVal = 0.0;
        this.m_inputs.pushFront(this.pidGetSource());
        for (i = 0; i < this.m_inputGains.length; ++i) {
            retVal += this.m_inputs.get(i) * this.m_inputGains[i];
        }
        for (i = 0; i < this.m_outputGains.length; ++i) {
            retVal -= this.m_outputs.get(i) * this.m_outputGains[i];
        }
        this.m_outputs.pushFront(retVal);
        return retVal;
    }
}

