/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Subsystem;
import java.util.Enumeration;
import java.util.Vector;

public class CommandGroup
extends Command {
    Vector m_commands = new Vector();
    Vector m_children = new Vector();
    int m_currentCommandIndex = -1;

    public CommandGroup() {
    }

    public CommandGroup(String name) {
        super(name);
    }

    public final synchronized void addSequential(Command command) {
        this.validate("Can not add new command to command group");
        if (command == null) {
            throw new IllegalArgumentException("Given null command");
        }
        command.setParent(this);
        this.m_commands.addElement(new Entry(command, 0));
        Enumeration e = command.getRequirements();
        while (e.hasMoreElements()) {
            this.requires((Subsystem)e.nextElement());
        }
    }

    public final synchronized void addSequential(Command command, double timeout) {
        this.validate("Can not add new command to command group");
        if (command == null) {
            throw new IllegalArgumentException("Given null command");
        }
        if (timeout < 0.0) {
            throw new IllegalArgumentException("Can not be given a negative timeout");
        }
        command.setParent(this);
        this.m_commands.addElement(new Entry(command, 0, timeout));
        Enumeration e = command.getRequirements();
        while (e.hasMoreElements()) {
            this.requires((Subsystem)e.nextElement());
        }
    }

    public final synchronized void addParallel(Command command) {
        this.validate("Can not add new command to command group");
        if (command == null) {
            throw new NullPointerException("Given null command");
        }
        command.setParent(this);
        this.m_commands.addElement(new Entry(command, 2));
        Enumeration e = command.getRequirements();
        while (e.hasMoreElements()) {
            this.requires((Subsystem)e.nextElement());
        }
    }

    public final synchronized void addParallel(Command command, double timeout) {
        this.validate("Can not add new command to command group");
        if (command == null) {
            throw new NullPointerException("Given null command");
        }
        if (timeout < 0.0) {
            throw new IllegalArgumentException("Can not be given a negative timeout");
        }
        command.setParent(this);
        this.m_commands.addElement(new Entry(command, 2, timeout));
        Enumeration e = command.getRequirements();
        while (e.hasMoreElements()) {
            this.requires((Subsystem)e.nextElement());
        }
    }

    @Override
    void _initialize() {
        this.m_currentCommandIndex = -1;
    }

    @Override
    void _execute() {
        Entry entry = null;
        Command cmd = null;
        boolean firstRun = false;
        if (this.m_currentCommandIndex == -1) {
            firstRun = true;
            this.m_currentCommandIndex = 0;
        }
        while (this.m_currentCommandIndex < this.m_commands.size()) {
            if (cmd != null) {
                if (entry.isTimedOut()) {
                    cmd._cancel();
                }
                if (cmd.run()) break;
                cmd.removed();
                ++this.m_currentCommandIndex;
                firstRun = true;
                cmd = null;
                continue;
            }
            entry = (Entry)this.m_commands.elementAt(this.m_currentCommandIndex);
            cmd = null;
            switch (entry.state) {
                case 0: {
                    cmd = entry.command;
                    if (firstRun) {
                        cmd.startRunning();
                        this.cancelConflicts(cmd);
                    }
                    firstRun = false;
                    break;
                }
                case 1: {
                    ++this.m_currentCommandIndex;
                    entry.command.start();
                    break;
                }
                case 2: {
                    ++this.m_currentCommandIndex;
                    this.cancelConflicts(entry.command);
                    entry.command.startRunning();
                    this.m_children.addElement(entry);
                }
            }
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            entry = (Entry)this.m_children.elementAt(i);
            Command child = entry.command;
            if (entry.isTimedOut()) {
                child._cancel();
            }
            if (child.run()) continue;
            child.removed();
            this.m_children.removeElementAt(i--);
        }
    }

    @Override
    void _end() {
        if (this.m_currentCommandIndex != -1 && this.m_currentCommandIndex < this.m_commands.size()) {
            Command cmd = ((Entry)this.m_commands.elementAt((int)this.m_currentCommandIndex)).command;
            cmd._cancel();
            cmd.removed();
        }
        Enumeration children = this.m_children.elements();
        while (children.hasMoreElements()) {
            Command cmd = ((Entry)children.nextElement()).command;
            cmd._cancel();
            cmd.removed();
        }
        this.m_children.removeAllElements();
    }

    @Override
    void _interrupted() {
        this._end();
    }

    @Override
    protected boolean isFinished() {
        return this.m_currentCommandIndex >= this.m_commands.size() && this.m_children.isEmpty();
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected void execute() {
    }

    @Override
    protected void end() {
    }

    @Override
    protected void interrupted() {
    }

    @Override
    public synchronized boolean isInterruptible() {
        Command cmd;
        if (!super.isInterruptible()) {
            return false;
        }
        if (this.m_currentCommandIndex != -1 && this.m_currentCommandIndex < this.m_commands.size() && !(cmd = ((Entry)this.m_commands.elementAt((int)this.m_currentCommandIndex)).command).isInterruptible()) {
            return false;
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            if (((Entry)this.m_children.elementAt((int)i)).command.isInterruptible()) continue;
            return false;
        }
        return true;
    }

    private void cancelConflicts(Command command) {
        block0: for (int i = 0; i < this.m_children.size(); ++i) {
            Command child = ((Entry)this.m_children.elementAt((int)i)).command;
            Enumeration requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                Object requirement = requirements.nextElement();
                if (!child.doesRequire((Subsystem)requirement)) continue;
                child._cancel();
                child.removed();
                this.m_children.removeElementAt(i--);
                continue block0;
            }
        }
    }

    private static class Entry {
        private static final int IN_SEQUENCE = 0;
        private static final int BRANCH_PEER = 1;
        private static final int BRANCH_CHILD = 2;
        Command command;
        int state;
        double timeout;

        Entry(Command command, int state) {
            this.command = command;
            this.state = state;
            this.timeout = -1.0;
        }

        Entry(Command command, int state, double timeout) {
            this.command = command;
            this.state = state;
            this.timeout = timeout;
        }

        boolean isTimedOut() {
            if (this.timeout == -1.0) {
                return false;
            }
            double time = this.command.timeSinceInitialized();
            return time == 0.0 ? false : time >= this.timeout;
        }
    }
}

