/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.NamedSendable;
import edu.wpi.first.wpilibj.RobotState;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.command.CommandGroup;
import edu.wpi.first.wpilibj.command.IllegalUseOfCommandException;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.command.Set;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public abstract class Command
implements NamedSendable {
    private String m_name;
    private double m_startTime = -1.0;
    private double m_timeout = -1.0;
    private boolean m_initialized = false;
    private Set m_requirements;
    private boolean m_running = false;
    private boolean m_interruptible = true;
    private boolean m_canceled = false;
    private boolean m_locked = false;
    private boolean m_runWhenDisabled = false;
    private CommandGroup m_parent;
    private static Enumeration emptyEnumeration = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    private ITableListener listener = new ITableListener(){

        @Override
        public void valueChanged(ITable table, String key, Object value, boolean isNew) {
            if (((Boolean)value).booleanValue()) {
                Command.this.start();
            } else {
                Command.this.cancel();
            }
        }
    };
    private ITable table;

    public Command() {
        this.m_name = this.getClass().getName();
        this.m_name = this.m_name.substring(this.m_name.lastIndexOf(46) + 1);
    }

    public Command(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        this.m_name = name;
    }

    public Command(double timeout) {
        this();
        if (timeout < 0.0) {
            throw new IllegalArgumentException("Timeout must not be negative.  Given:" + timeout);
        }
        this.m_timeout = timeout;
    }

    public Command(String name, double timeout) {
        this(name);
        if (timeout < 0.0) {
            throw new IllegalArgumentException("Timeout must not be negative.  Given:" + timeout);
        }
        this.m_timeout = timeout;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    protected final synchronized void setTimeout(double seconds) {
        if (seconds < 0.0) {
            throw new IllegalArgumentException("Seconds must be positive.  Given:" + seconds);
        }
        this.m_timeout = seconds;
    }

    public final synchronized double timeSinceInitialized() {
        return this.m_startTime < 0.0 ? 0.0 : Timer.getFPGATimestamp() - this.m_startTime;
    }

    protected synchronized void requires(Subsystem subsystem) {
        this.validate("Can not add new requirement to command");
        if (subsystem != null) {
            if (this.m_requirements == null) {
                this.m_requirements = new Set();
            }
        } else {
            throw new IllegalArgumentException("Subsystem must not be null.");
        }
        this.m_requirements.add(subsystem);
    }

    synchronized void removed() {
        if (this.m_initialized) {
            if (this.isCanceled()) {
                this.interrupted();
                this._interrupted();
            } else {
                this.end();
                this._end();
            }
        }
        this.m_initialized = false;
        this.m_canceled = false;
        this.m_running = false;
        if (this.table != null) {
            this.table.putBoolean("running", false);
        }
    }

    synchronized boolean run() {
        if (!this.m_runWhenDisabled && this.m_parent == null && RobotState.isDisabled()) {
            this.cancel();
        }
        if (this.isCanceled()) {
            return false;
        }
        if (!this.m_initialized) {
            this.m_initialized = true;
            this.startTiming();
            this._initialize();
            this.initialize();
        }
        this._execute();
        this.execute();
        return !this.isFinished();
    }

    protected abstract void initialize();

    void _initialize() {
    }

    protected abstract void execute();

    void _execute() {
    }

    protected abstract boolean isFinished();

    protected abstract void end();

    void _end() {
    }

    protected abstract void interrupted();

    void _interrupted() {
    }

    private void startTiming() {
        this.m_startTime = Timer.getFPGATimestamp();
    }

    protected synchronized boolean isTimedOut() {
        return this.m_timeout != -1.0 && this.timeSinceInitialized() >= this.m_timeout;
    }

    synchronized Enumeration getRequirements() {
        return this.m_requirements == null ? emptyEnumeration : this.m_requirements.getElements();
    }

    synchronized void lockChanges() {
        this.m_locked = true;
    }

    synchronized void validate(String message) {
        if (this.m_locked) {
            throw new IllegalUseOfCommandException(message + " after being started or being added to a command group");
        }
    }

    synchronized void setParent(CommandGroup parent) {
        if (this.m_parent != null) {
            throw new IllegalUseOfCommandException("Can not give command to a command group after already being put in a command group");
        }
        this.lockChanges();
        this.m_parent = parent;
        if (this.table != null) {
            this.table.putBoolean("isParented", true);
        }
    }

    public synchronized void start() {
        this.lockChanges();
        if (this.m_parent != null) {
            throw new IllegalUseOfCommandException("Can not start a command that is a part of a command group");
        }
        Scheduler.getInstance().add(this);
    }

    synchronized void startRunning() {
        this.m_running = true;
        this.m_startTime = -1.0;
        if (this.table != null) {
            this.table.putBoolean("running", true);
        }
    }

    public synchronized boolean isRunning() {
        return this.m_running;
    }

    public synchronized void cancel() {
        if (this.m_parent != null) {
            throw new IllegalUseOfCommandException("Can not manually cancel a command in a command group");
        }
        this._cancel();
    }

    synchronized void _cancel() {
        if (this.isRunning()) {
            this.m_canceled = true;
        }
    }

    public synchronized boolean isCanceled() {
        return this.m_canceled;
    }

    public synchronized boolean isInterruptible() {
        return this.m_interruptible;
    }

    protected synchronized void setInterruptible(boolean interruptible) {
        this.m_interruptible = interruptible;
    }

    public synchronized boolean doesRequire(Subsystem system) {
        return this.m_requirements != null && this.m_requirements.contains(system);
    }

    public synchronized CommandGroup getGroup() {
        return this.m_parent;
    }

    public void setRunWhenDisabled(boolean run) {
        this.m_runWhenDisabled = run;
    }

    public boolean willRunWhenDisabled() {
        return this.m_runWhenDisabled;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getSmartDashboardType() {
        return "Command";
    }

    @Override
    public void initTable(ITable table) {
        if (this.table != null) {
            this.table.removeTableListener(this.listener);
        }
        this.table = table;
        if (table != null) {
            table.putString("name", this.getName());
            table.putBoolean("running", this.isRunning());
            table.putBoolean("isParented", this.m_parent != null);
            table.addTableListener("running", this.listener, false);
        }
    }

    @Override
    public ITable getTable() {
        return this.table;
    }
}

