/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.util.BaseSystemNotInitializedException;

public class Timer {
    private static StaticInterface impl;
    private final Interface timer;

    public static void SetImplementation(StaticInterface ti) {
        impl = ti;
    }

    public static double getFPGATimestamp() {
        if (impl != null) {
            return impl.getFPGATimestamp();
        }
        throw new BaseSystemNotInitializedException(StaticInterface.class, Timer.class);
    }

    public static double getMatchTime() {
        if (impl != null) {
            return impl.getMatchTime();
        }
        throw new BaseSystemNotInitializedException(StaticInterface.class, Timer.class);
    }

    public static void delay(double seconds) {
        if (impl == null) {
            throw new BaseSystemNotInitializedException(StaticInterface.class, Timer.class);
        }
        impl.delay(seconds);
    }

    public Timer() {
        if (impl == null) {
            throw new BaseSystemNotInitializedException(StaticInterface.class, Timer.class);
        }
        this.timer = impl.newTimer();
    }

    public double get() {
        return this.timer.get();
    }

    public void reset() {
        this.timer.reset();
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    public boolean hasPeriodPassed(double period) {
        return this.timer.hasPeriodPassed(period);
    }

    public static interface Interface {
        public double get();

        public void reset();

        public void start();

        public void stop();

        public boolean hasPeriodPassed(double var1);
    }

    public static interface StaticInterface {
        public double getFPGATimestamp();

        public double getMatchTime();

        public void delay(double var1);

        public Interface newTimer();
    }
}

