/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SolenoidBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.SolenoidJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class Solenoid
extends SolenoidBase
implements LiveWindowSendable {
    private int m_channel;
    private long m_solenoid_port;
    private ITable m_table;
    private ITableListener m_table_listener;

    private synchronized void initSolenoid() {
        Solenoid.checkSolenoidModule(this.m_moduleNumber);
        Solenoid.checkSolenoidChannel(this.m_channel);
        try {
            m_allocated.allocate(this.m_moduleNumber * 8 + this.m_channel);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Solenoid channel " + this.m_channel + " on module " + this.m_moduleNumber + " is already allocated");
        }
        long port = SolenoidJNI.getPortWithModule((byte)this.m_moduleNumber, (byte)this.m_channel);
        this.m_solenoid_port = SolenoidJNI.initializeSolenoidPort(port);
        LiveWindow.addActuator("Solenoid", this.m_moduleNumber, this.m_channel, this);
        UsageReporting.report(34, this.m_channel, this.m_moduleNumber);
    }

    public Solenoid(int channel) {
        super(Solenoid.getDefaultSolenoidModule());
        this.m_channel = channel;
        this.initSolenoid();
    }

    public Solenoid(int moduleNumber, int channel) {
        super(moduleNumber);
        this.m_channel = channel;
        this.initSolenoid();
    }

    @Override
    public synchronized void free() {
        m_allocated.free(this.m_moduleNumber * 8 + this.m_channel);
        SolenoidJNI.freeSolenoidPort(this.m_solenoid_port);
        this.m_solenoid_port = 0L;
        super.free();
    }

    public void set(boolean on) {
        byte value = (byte)(on ? 255 : 0);
        byte mask = (byte)(1 << this.m_channel);
        this.set(value, mask);
    }

    public boolean get() {
        int value = this.getAll() & 1 << this.m_channel;
        return value != 0;
    }

    public boolean isBlackListed() {
        int value = this.getPCMSolenoidBlackList() & 1 << this.m_channel;
        return value != 0;
    }

    @Override
    public String getSmartDashboardType() {
        return "Solenoid";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putBoolean("Value", this.get());
        }
    }

    @Override
    public void startLiveWindowMode() {
        this.set(false);
        this.m_table_listener = new ITableListener(){

            @Override
            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                Solenoid.this.set((Boolean)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.set(false);
        this.m_table.removeTableListener(this.m_table_listener);
    }
}

