/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.SerialPortJNI;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class SerialPort {
    private byte m_port;

    public SerialPort(int baudRate, Port port, int dataBits, Parity parity, StopBits stopBits) {
        this.m_port = (byte)port.getValue();
        SerialPortJNI.serialInitializePort(this.m_port);
        SerialPortJNI.serialSetBaudRate(this.m_port, baudRate);
        SerialPortJNI.serialSetDataBits(this.m_port, (byte)dataBits);
        SerialPortJNI.serialSetParity(this.m_port, (byte)parity.value);
        SerialPortJNI.serialSetStopBits(this.m_port, (byte)stopBits.value);
        this.setReadBufferSize(1);
        this.setTimeout(5.0);
        this.setWriteBufferMode(WriteBufferMode.kFlushOnAccess);
        this.disableTermination();
        UsageReporting.report(32, 0);
    }

    public SerialPort(int baudRate, Port port, int dataBits, Parity parity) {
        this(baudRate, port, dataBits, parity, StopBits.kOne);
    }

    public SerialPort(int baudRate, Port port, int dataBits) {
        this(baudRate, port, dataBits, Parity.kNone, StopBits.kOne);
    }

    public SerialPort(int baudRate, Port port) {
        this(baudRate, port, 8, Parity.kNone, StopBits.kOne);
    }

    public void free() {
        SerialPortJNI.serialClose(this.m_port);
    }

    public void setFlowControl(FlowControl flowControl) {
        SerialPortJNI.serialSetFlowControl(this.m_port, (byte)flowControl.value);
    }

    public void enableTermination(char terminator) {
        SerialPortJNI.serialEnableTermination(this.m_port, terminator);
    }

    public void enableTermination() {
        this.enableTermination('\n');
    }

    public void disableTermination() {
        SerialPortJNI.serialDisableTermination(this.m_port);
    }

    public int getBytesReceived() {
        return SerialPortJNI.serialGetBytesRecieved(this.m_port);
    }

    public String readString() {
        return this.readString(this.getBytesReceived());
    }

    public String readString(int count) {
        byte[] out = this.read(count);
        try {
            return new String(out, 0, out.length, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return new String();
        }
    }

    public byte[] read(int count) {
        ByteBuffer dataReceivedBuffer = ByteBuffer.allocateDirect(count);
        int gotten = SerialPortJNI.serialRead(this.m_port, dataReceivedBuffer, count);
        byte[] retVal = new byte[gotten];
        dataReceivedBuffer.get(retVal);
        return retVal;
    }

    public int write(byte[] buffer, int count) {
        ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(count);
        dataToSendBuffer.put(buffer, 0, count);
        return SerialPortJNI.serialWrite(this.m_port, dataToSendBuffer, count);
    }

    public int writeString(String data) {
        return this.write(data.getBytes(), data.length());
    }

    public void setTimeout(double timeout) {
        SerialPortJNI.serialSetTimeout(this.m_port, (float)timeout);
    }

    public void setReadBufferSize(int size) {
        SerialPortJNI.serialSetReadBufferSize(this.m_port, size);
    }

    public void setWriteBufferSize(int size) {
        SerialPortJNI.serialSetWriteBufferSize(this.m_port, size);
    }

    public void setWriteBufferMode(WriteBufferMode mode) {
        SerialPortJNI.serialSetWriteMode(this.m_port, (byte)mode.value);
    }

    public void flush() {
        SerialPortJNI.serialFlush(this.m_port);
    }

    public void reset() {
        SerialPortJNI.serialClear(this.m_port);
    }

    public static class WriteBufferMode {
        public final int value;
        static final int kFlushOnAccess_val = 1;
        static final int kFlushWhenFull_val = 2;
        public static final WriteBufferMode kFlushOnAccess = new WriteBufferMode(1);
        public static final WriteBufferMode kFlushWhenFull = new WriteBufferMode(2);

        private WriteBufferMode(int value) {
            this.value = value;
        }
    }

    public static class FlowControl {
        public final int value;
        static final int kNone_val = 0;
        static final int kXonXoff_val = 1;
        static final int kRtsCts_val = 2;
        static final int kDtrDsr_val = 4;
        public static final FlowControl kNone = new FlowControl(0);
        public static final FlowControl kXonXoff = new FlowControl(1);
        public static final FlowControl kRtsCts = new FlowControl(2);
        public static final FlowControl kDtrDsr = new FlowControl(4);

        private FlowControl(int value) {
            this.value = value;
        }
    }

    public static class StopBits {
        public final int value;
        static final int kOne_val = 10;
        static final int kOnePointFive_val = 15;
        static final int kTwo_val = 20;
        public static final StopBits kOne = new StopBits(10);
        public static final StopBits kOnePointFive = new StopBits(15);
        public static final StopBits kTwo = new StopBits(20);

        private StopBits(int value) {
            this.value = value;
        }
    }

    public static class Parity {
        public final int value;
        static final int kNone_val = 0;
        static final int kOdd_val = 1;
        static final int kEven_val = 2;
        static final int kMark_val = 3;
        static final int kSpace_val = 4;
        public static final Parity kNone = new Parity(0);
        public static final Parity kOdd = new Parity(1);
        public static final Parity kEven = new Parity(2);
        public static final Parity kMark = new Parity(3);
        public static final Parity kSpace = new Parity(4);

        private Parity(int value) {
            this.value = value;
        }
    }

    public static enum Port {
        kOnboard(0),
        kMXP(1),
        kUSB(2);

        private int value;

        private Port(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

