/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

public abstract class SensorBase {
    public static final int kSystemClockTicksPerMicrosecond = 40;
    public static final int kDigitalChannels = 26;
    public static final int kAnalogInputChannels = 8;
    public static final int kAnalogOutputChannels = 2;
    public static final int kSolenoidChannels = 8;
    public static final int kSolenoidModules = 2;
    public static final int kPwmChannels = 20;
    public static final int kRelayChannels = 4;
    public static final int kPDPChannels = 16;
    public static final int kPDPModules = 63;
    private static int m_defaultSolenoidModule = 0;

    public static void setDefaultSolenoidModule(int moduleNumber) {
        SensorBase.checkSolenoidModule(moduleNumber);
        m_defaultSolenoidModule = moduleNumber;
    }

    protected static void checkSolenoidModule(int moduleNumber) {
    }

    protected static void checkDigitalChannel(int channel) {
        if (channel < 0 || channel >= 26) {
            throw new IndexOutOfBoundsException("Requested digital channel number is out of range.");
        }
    }

    protected static void checkRelayChannel(int channel) {
        if (channel < 0 || channel >= 4) {
            throw new IndexOutOfBoundsException("Requested relay channel number is out of range.");
        }
    }

    protected static void checkPWMChannel(int channel) {
        if (channel < 0 || channel >= 20) {
            throw new IndexOutOfBoundsException("Requested PWM channel number is out of range.");
        }
    }

    protected static void checkAnalogInputChannel(int channel) {
        if (channel < 0 || channel >= 8) {
            throw new IndexOutOfBoundsException("Requested analog input channel number is out of range.");
        }
    }

    protected static void checkAnalogOutputChannel(int channel) {
        if (channel < 0 || channel >= 2) {
            throw new IndexOutOfBoundsException("Requested analog output channel number is out of range.");
        }
    }

    protected static void checkSolenoidChannel(int channel) {
        if (channel < 0 || channel >= 8) {
            throw new IndexOutOfBoundsException("Requested solenoid channel number is out of range.");
        }
    }

    protected static void checkPDPChannel(int channel) {
        if (channel < 0 || channel >= 16) {
            throw new IndexOutOfBoundsException("Requested PDP channel number is out of range.");
        }
    }

    protected static void checkPDPModule(int module) {
        if (module < 0 || module > 63) {
            throw new IndexOutOfBoundsException("Requested PDP module number is out of range.");
        }
    }

    public static int getDefaultSolenoidModule() {
        return m_defaultSolenoidModule;
    }

    public void free() {
    }
}

