/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PWM;
import edu.wpi.first.wpilibj.SafePWM;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;

public class SD540
extends SafePWM
implements SpeedController {
    private boolean isInverted = false;

    protected void initSD540() {
        this.setBounds(2.05, 1.55, 1.5, 1.44, 0.94);
        this.setPeriodMultiplier(PWM.PeriodMultiplier.k1X);
        this.setRaw(this.m_centerPwm);
        this.setZeroLatch();
        LiveWindow.addActuator("SD540", this.getChannel(), (LiveWindowSendable)this);
        UsageReporting.report(56, this.getChannel());
    }

    public SD540(int channel) {
        super(channel);
        this.initSD540();
    }

    @Override
    public void set(double speed, byte syncGroup) {
        this.setSpeed(this.isInverted ? -speed : speed);
        this.Feed();
    }

    @Override
    public void set(double speed) {
        this.setSpeed(this.isInverted ? -speed : speed);
        this.Feed();
    }

    @Override
    public void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
    }

    @Override
    public boolean getInverted() {
        return this.isInverted;
    }

    @Override
    public double get() {
        return this.getSpeed();
    }

    @Override
    public void pidWrite(double output) {
        this.set(output);
    }
}

