/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;
import java.util.Vector;

public class Preferences {
    private static final String TABLE_NAME = "Preferences";
    private static Preferences instance;
    private NetworkTable table;
    private final ITableListener listener = new ITableListener(){

        @Override
        public void valueChanged(ITable table, String key, Object value, boolean isNew) {
        }

        @Override
        public void valueChangedEx(ITable table, String key, Object value, int flags) {
            table.setPersistent(key);
        }
    };

    public static synchronized Preferences getInstance() {
        if (instance == null) {
            instance = new Preferences();
        }
        return instance;
    }

    private Preferences() {
        this.table = NetworkTable.getTable(TABLE_NAME);
        this.table.addTableListenerEx(this.listener, 5);
        UsageReporting.report(28, 0);
    }

    public Vector getKeys() {
        Vector<String> keys = new Vector<String>();
        for (String key : this.table.getKeys()) {
            keys.add(key);
        }
        return keys;
    }

    public void putString(String key, String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.table.putString(key, value);
        this.table.setPersistent(key);
    }

    public void putInt(String key, int value) {
        this.table.putNumber(key, value);
        this.table.setPersistent(key);
    }

    public void putDouble(String key, double value) {
        this.table.putNumber(key, value);
        this.table.setPersistent(key);
    }

    public void putFloat(String key, float value) {
        this.table.putNumber(key, value);
        this.table.setPersistent(key);
    }

    public void putBoolean(String key, boolean value) {
        this.table.putBoolean(key, value);
        this.table.setPersistent(key);
    }

    public void putLong(String key, long value) {
        this.table.putNumber(key, value);
        this.table.setPersistent(key);
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }

    public void remove(String key) {
        this.table.delete(key);
    }

    public String getString(String key, String backup) {
        return this.table.getString(key, backup);
    }

    public int getInt(String key, int backup) {
        try {
            return (int)this.table.getNumber(key);
        }
        catch (TableKeyNotDefinedException e) {
            return backup;
        }
    }

    public double getDouble(String key, double backup) {
        return this.table.getDouble(key, backup);
    }

    public boolean getBoolean(String key, boolean backup) {
        return this.table.getBoolean(key, backup);
    }

    public float getFloat(String key, float backup) {
        try {
            return (float)this.table.getNumber(key);
        }
        catch (TableKeyNotDefinedException e) {
            return backup;
        }
    }

    public long getLong(String key, long backup) {
        try {
            return (long)this.table.getNumber(key);
        }
        catch (TableKeyNotDefinedException e) {
            return backup;
        }
    }

    public void save() {
    }
}

