/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.PDPJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class PowerDistributionPanel
extends SensorBase
implements LiveWindowSendable {
    int m_module;
    private ITable m_table;

    public PowerDistributionPanel(int module) {
        this.m_module = module;
        PowerDistributionPanel.checkPDPModule(this.m_module);
        PDPJNI.initializePDP(this.m_module);
    }

    public PowerDistributionPanel() {
        this(0);
    }

    public double getVoltage() {
        return PDPJNI.getPDPVoltage(this.m_module);
    }

    public double getTemperature() {
        return PDPJNI.getPDPTemperature(this.m_module);
    }

    public double getCurrent(int channel) {
        double current = PDPJNI.getPDPChannelCurrent((byte)channel, this.m_module);
        PowerDistributionPanel.checkPDPChannel(channel);
        return current;
    }

    public double getTotalCurrent() {
        return PDPJNI.getPDPTotalCurrent(this.m_module);
    }

    public double getTotalPower() {
        return PDPJNI.getPDPTotalPower(this.m_module);
    }

    public double getTotalEnergy() {
        return PDPJNI.getPDPTotalEnergy(this.m_module);
    }

    public void resetTotalEnergy() {
        PDPJNI.resetPDPTotalEnergy(this.m_module);
    }

    public void clearStickyFaults() {
        PDPJNI.clearPDPStickyFaults(this.m_module);
    }

    @Override
    public String getSmartDashboardType() {
        return "PowerDistributionPanel";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Chan0", this.getCurrent(0));
            this.m_table.putNumber("Chan1", this.getCurrent(1));
            this.m_table.putNumber("Chan2", this.getCurrent(2));
            this.m_table.putNumber("Chan3", this.getCurrent(3));
            this.m_table.putNumber("Chan4", this.getCurrent(4));
            this.m_table.putNumber("Chan5", this.getCurrent(5));
            this.m_table.putNumber("Chan6", this.getCurrent(6));
            this.m_table.putNumber("Chan7", this.getCurrent(7));
            this.m_table.putNumber("Chan8", this.getCurrent(8));
            this.m_table.putNumber("Chan9", this.getCurrent(9));
            this.m_table.putNumber("Chan10", this.getCurrent(10));
            this.m_table.putNumber("Chan11", this.getCurrent(11));
            this.m_table.putNumber("Chan12", this.getCurrent(12));
            this.m_table.putNumber("Chan13", this.getCurrent(13));
            this.m_table.putNumber("Chan14", this.getCurrent(14));
            this.m_table.putNumber("Chan15", this.getCurrent(15));
            this.m_table.putNumber("Voltage", this.getVoltage());
            this.m_table.putNumber("TotalCurrent", this.getTotalCurrent());
        }
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

