/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Controller;
import edu.wpi.first.wpilibj.HLUsageReporting;
import edu.wpi.first.wpilibj.PIDInterface;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.util.BoundaryException;
import java.util.LinkedList;
import java.util.TimerTask;

public class PIDController
implements PIDInterface,
LiveWindowSendable,
Controller {
    public static final double kDefaultPeriod = 0.05;
    private static int instances = 0;
    private double m_P;
    private double m_I;
    private double m_D;
    private double m_F;
    private double m_maximumOutput = 1.0;
    private double m_minimumOutput = -1.0;
    private double m_maximumInput = 0.0;
    private double m_minimumInput = 0.0;
    private boolean m_continuous = false;
    private boolean m_enabled = false;
    private double m_prevError = 0.0;
    private double m_totalError = 0.0;
    private Tolerance m_tolerance;
    private int m_bufLength = 1;
    private LinkedList<Double> m_buf;
    private double m_bufTotal = 0.0;
    private double m_setpoint = 0.0;
    private double m_prevSetpoint = 0.0;
    private double m_error = 0.0;
    private double m_result = 0.0;
    private double m_period = 0.05;
    protected PIDSource m_pidInput;
    protected PIDOutput m_pidOutput;
    java.util.Timer m_controlLoop;
    Timer m_setpointTimer;
    private boolean m_freed = false;
    private boolean m_usingPercentTolerance;
    private final ITableListener listener = new ITableListener(){

        @Override
        public void valueChanged(ITable table, String key, Object value, boolean isNew) {
            if (key.equals("p") || key.equals("i") || key.equals("d") || key.equals("f")) {
                if (PIDController.this.getP() != table.getNumber("p", 0.0) || PIDController.this.getI() != table.getNumber("i", 0.0) || PIDController.this.getD() != table.getNumber("d", 0.0) || PIDController.this.getF() != table.getNumber("f", 0.0)) {
                    PIDController.this.setPID(table.getNumber("p", 0.0), table.getNumber("i", 0.0), table.getNumber("d", 0.0), table.getNumber("f", 0.0));
                }
            } else if (key.equals("setpoint")) {
                if (PIDController.this.getSetpoint() != ((Double)value).doubleValue()) {
                    PIDController.this.setSetpoint((Double)value);
                }
            } else if (key.equals("enabled") && PIDController.this.isEnable() != ((Boolean)value).booleanValue()) {
                if (((Boolean)value).booleanValue()) {
                    PIDController.this.enable();
                } else {
                    PIDController.this.disable();
                }
            }
        }
    };
    private ITable table;

    public PIDController(double Kp, double Ki, double Kd, double Kf, PIDSource source, PIDOutput output, double period) {
        if (source == null) {
            throw new NullPointerException("Null PIDSource was given");
        }
        if (output == null) {
            throw new NullPointerException("Null PIDOutput was given");
        }
        this.m_controlLoop = new java.util.Timer();
        this.m_setpointTimer = new Timer();
        this.m_setpointTimer.start();
        this.m_P = Kp;
        this.m_I = Ki;
        this.m_D = Kd;
        this.m_F = Kf;
        this.m_pidInput = source;
        this.m_pidOutput = output;
        this.m_period = period;
        this.m_controlLoop.schedule((TimerTask)new PIDTask(this), 0L, (long)(this.m_period * 1000.0));
        HLUsageReporting.reportPIDController(++instances);
        this.m_tolerance = new NullTolerance();
        this.m_buf = new LinkedList();
    }

    public PIDController(double Kp, double Ki, double Kd, PIDSource source, PIDOutput output, double period) {
        this(Kp, Ki, Kd, 0.0, source, output, period);
    }

    public PIDController(double Kp, double Ki, double Kd, PIDSource source, PIDOutput output) {
        this(Kp, Ki, Kd, source, output, 0.05);
    }

    public PIDController(double Kp, double Ki, double Kd, double Kf, PIDSource source, PIDOutput output) {
        this(Kp, Ki, Kd, Kf, source, output, 0.05);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        this.m_controlLoop.cancel();
        PIDController pIDController = this;
        synchronized (pIDController) {
            this.m_freed = true;
            this.m_pidOutput = null;
            this.m_pidInput = null;
            this.m_controlLoop = null;
        }
        if (this.table != null) {
            this.table.removeTableListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculate() {
        PIDSource pidInput;
        boolean enabled;
        PIDController pIDController = this;
        synchronized (pIDController) {
            if (this.m_pidInput == null) {
                return;
            }
            if (this.m_pidOutput == null) {
                return;
            }
            enabled = this.m_enabled;
            pidInput = this.m_pidInput;
        }
        if (enabled) {
            double result;
            double input;
            PIDOutput pidOutput = null;
            PIDController pIDController2 = this;
            synchronized (pIDController2) {
                input = pidInput.pidGet();
            }
            pIDController2 = this;
            synchronized (pIDController2) {
                this.m_error = this.m_setpoint - input;
                if (this.m_continuous && Math.abs(this.m_error) > (this.m_maximumInput - this.m_minimumInput) / 2.0) {
                    this.m_error = this.m_error > 0.0 ? this.m_error - this.m_maximumInput + this.m_minimumInput : this.m_error + this.m_maximumInput - this.m_minimumInput;
                }
                if (this.m_pidInput.getPIDSourceType().equals((Object)PIDSourceType.kRate)) {
                    if (this.m_P != 0.0) {
                        double potentialPGain = (this.m_totalError + this.m_error) * this.m_P;
                        this.m_totalError = potentialPGain < this.m_maximumOutput ? (potentialPGain > this.m_minimumOutput ? (this.m_totalError += this.m_error) : this.m_minimumOutput / this.m_P) : this.m_maximumOutput / this.m_P;
                        this.m_result = this.m_P * this.m_totalError + this.m_D * this.m_error + this.calculateFeedForward();
                    }
                } else {
                    if (this.m_I != 0.0) {
                        double potentialIGain = (this.m_totalError + this.m_error) * this.m_I;
                        this.m_totalError = potentialIGain < this.m_maximumOutput ? (potentialIGain > this.m_minimumOutput ? (this.m_totalError += this.m_error) : this.m_minimumOutput / this.m_I) : this.m_maximumOutput / this.m_I;
                    }
                    this.m_result = this.m_P * this.m_error + this.m_I * this.m_totalError + this.m_D * (this.m_error - this.m_prevError) + this.calculateFeedForward();
                }
                this.m_prevError = this.m_error;
                if (this.m_result > this.m_maximumOutput) {
                    this.m_result = this.m_maximumOutput;
                } else if (this.m_result < this.m_minimumOutput) {
                    this.m_result = this.m_minimumOutput;
                }
                pidOutput = this.m_pidOutput;
                result = this.m_result;
                this.m_buf.push(this.m_error);
                this.m_bufTotal += this.m_error;
                if (this.m_buf.size() > this.m_bufLength) {
                    this.m_bufTotal -= this.m_buf.pop().doubleValue();
                }
            }
            pidOutput.pidWrite(result);
        }
    }

    protected double calculateFeedForward() {
        if (this.m_pidInput.getPIDSourceType().equals((Object)PIDSourceType.kRate)) {
            return this.m_F * this.getSetpoint();
        }
        double temp = this.m_F * this.getDeltaSetpoint();
        this.m_prevSetpoint = this.m_setpoint;
        this.m_setpointTimer.reset();
        return temp;
    }

    @Override
    public synchronized void setPID(double p, double i, double d) {
        this.m_P = p;
        this.m_I = i;
        this.m_D = d;
        if (this.table != null) {
            this.table.putNumber("p", p);
            this.table.putNumber("i", i);
            this.table.putNumber("d", d);
        }
    }

    public synchronized void setPID(double p, double i, double d, double f) {
        this.m_P = p;
        this.m_I = i;
        this.m_D = d;
        this.m_F = f;
        if (this.table != null) {
            this.table.putNumber("p", p);
            this.table.putNumber("i", i);
            this.table.putNumber("d", d);
            this.table.putNumber("f", f);
        }
    }

    @Override
    public synchronized double getP() {
        return this.m_P;
    }

    @Override
    public synchronized double getI() {
        return this.m_I;
    }

    @Override
    public synchronized double getD() {
        return this.m_D;
    }

    public synchronized double getF() {
        return this.m_F;
    }

    public synchronized double get() {
        return this.m_result;
    }

    public synchronized void setContinuous(boolean continuous) {
        this.m_continuous = continuous;
    }

    public synchronized void setContinuous() {
        this.setContinuous(true);
    }

    public synchronized void setInputRange(double minimumInput, double maximumInput) {
        if (minimumInput > maximumInput) {
            throw new BoundaryException("Lower bound is greater than upper bound");
        }
        this.m_minimumInput = minimumInput;
        this.m_maximumInput = maximumInput;
        this.setSetpoint(this.m_setpoint);
    }

    public synchronized void setOutputRange(double minimumOutput, double maximumOutput) {
        if (minimumOutput > maximumOutput) {
            throw new BoundaryException("Lower bound is greater than upper bound");
        }
        this.m_minimumOutput = minimumOutput;
        this.m_maximumOutput = maximumOutput;
    }

    @Override
    public synchronized void setSetpoint(double setpoint) {
        this.m_setpoint = this.m_maximumInput > this.m_minimumInput ? (setpoint > this.m_maximumInput ? this.m_maximumInput : (setpoint < this.m_minimumInput ? this.m_minimumInput : setpoint)) : setpoint;
        this.m_buf.clear();
        if (this.table != null) {
            this.table.putNumber("setpoint", this.m_setpoint);
        }
    }

    @Override
    public synchronized double getSetpoint() {
        return this.m_setpoint;
    }

    public synchronized double getDeltaSetpoint() {
        return (this.m_setpoint - this.m_prevSetpoint) / this.m_setpointTimer.get();
    }

    @Override
    public synchronized double getError() {
        return this.getSetpoint() - this.m_pidInput.pidGet();
    }

    void setPIDSourceType(PIDSourceType pidSource) {
        this.m_pidInput.setPIDSourceType(pidSource);
    }

    PIDSourceType getPIDSourceType() {
        return this.m_pidInput.getPIDSourceType();
    }

    public synchronized double getAvgError() {
        double avgError = 0.0;
        if (this.m_buf.size() != 0) {
            avgError = this.m_bufTotal / (double)this.m_buf.size();
        }
        return avgError;
    }

    private synchronized boolean isAvgErrorValid() {
        return this.m_buf.size() != 0;
    }

    @Deprecated
    public synchronized void setTolerance(double percent) {
        this.m_tolerance = new PercentageTolerance(percent);
    }

    public void setTolerance(Tolerance tolerance) {
        this.m_tolerance = tolerance;
    }

    public synchronized void setAbsoluteTolerance(double absvalue) {
        this.m_tolerance = new AbsoluteTolerance(absvalue);
    }

    public synchronized void setPercentTolerance(double percentage) {
        this.m_tolerance = new PercentageTolerance(percentage);
    }

    public synchronized void setToleranceBuffer(int bufLength) {
        this.m_bufLength = bufLength;
        while (this.m_buf.size() > bufLength) {
            this.m_bufTotal -= this.m_buf.pop().doubleValue();
        }
    }

    public synchronized boolean onTarget() {
        return this.m_tolerance.onTarget();
    }

    @Override
    public synchronized void enable() {
        this.m_enabled = true;
        if (this.table != null) {
            this.table.putBoolean("enabled", true);
        }
    }

    @Override
    public synchronized void disable() {
        this.m_pidOutput.pidWrite(0.0);
        this.m_enabled = false;
        if (this.table != null) {
            this.table.putBoolean("enabled", false);
        }
    }

    @Deprecated
    public synchronized boolean isEnable() {
        return this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public synchronized void reset() {
        this.disable();
        this.m_prevError = 0.0;
        this.m_totalError = 0.0;
        this.m_result = 0.0;
    }

    @Override
    public String getSmartDashboardType() {
        return "PIDController";
    }

    @Override
    public void initTable(ITable table) {
        if (this.table != null) {
            this.table.removeTableListener(this.listener);
        }
        this.table = table;
        if (table != null) {
            table.putNumber("p", this.getP());
            table.putNumber("i", this.getI());
            table.putNumber("d", this.getD());
            table.putNumber("f", this.getF());
            table.putNumber("setpoint", this.getSetpoint());
            table.putBoolean("enabled", this.isEnable());
            table.addTableListener(this.listener, false);
        }
    }

    @Override
    public ITable getTable() {
        return this.table;
    }

    @Override
    public void updateTable() {
    }

    @Override
    public void startLiveWindowMode() {
        this.disable();
    }

    @Override
    public void stopLiveWindowMode() {
    }

    private class PIDTask
    extends TimerTask {
        private PIDController m_controller;

        public PIDTask(PIDController controller) {
            if (controller == null) {
                throw new NullPointerException("Given PIDController was null");
            }
            this.m_controller = controller;
        }

        @Override
        public void run() {
            this.m_controller.calculate();
        }
    }

    public class AbsoluteTolerance
    implements Tolerance {
        double value;

        AbsoluteTolerance(double value) {
            this.value = value;
        }

        @Override
        public boolean onTarget() {
            return PIDController.this.isAvgErrorValid() && Math.abs(PIDController.this.getAvgError()) < this.value;
        }
    }

    public class PercentageTolerance
    implements Tolerance {
        double percentage;

        PercentageTolerance(double value) {
            this.percentage = value;
        }

        @Override
        public boolean onTarget() {
            return PIDController.this.isAvgErrorValid() && Math.abs(PIDController.this.getAvgError()) < this.percentage / 100.0 * (PIDController.this.m_maximumInput - PIDController.this.m_minimumInput);
        }
    }

    public class NullTolerance
    implements Tolerance {
        @Override
        public boolean onTarget() {
            throw new RuntimeException("No tolerance value set when calling onTarget().");
        }
    }

    public static interface Tolerance {
        public boolean onTarget();
    }
}

