/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.RobotState;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.FRCNetworkCommunicationsLibrary;
import edu.wpi.first.wpilibj.communication.HALAllianceStationID;
import edu.wpi.first.wpilibj.communication.HALControlWord;
import edu.wpi.first.wpilibj.hal.HALUtil;
import edu.wpi.first.wpilibj.hal.PowerJNI;
import java.nio.ByteBuffer;

public class DriverStation
implements RobotState.Interface {
    public static final int kJoystickPorts = 6;
    private static final double JOYSTICK_UNPLUGGED_MESSAGE_INTERVAL = 1.0;
    private double m_nextMessageTime = 0.0;
    private static DriverStation instance = new DriverStation();
    private short[][] m_joystickAxes = new short[6][FRCNetworkCommunicationsLibrary.kMaxJoystickAxes];
    private short[][] m_joystickPOVs = new short[6][FRCNetworkCommunicationsLibrary.kMaxJoystickPOVs];
    private HALJoystickButtons[] m_joystickButtons = new HALJoystickButtons[6];
    private int[] m_joystickIsXbox = new int[6];
    private int[] m_joystickType = new int[6];
    private String[] m_joystickName = new String[6];
    private int[][] m_joystickAxisType = new int[6][FRCNetworkCommunicationsLibrary.kMaxJoystickAxes];
    private Thread m_thread;
    private final Object m_dataSem = new Object();
    private volatile boolean m_thread_keepalive = true;
    private boolean m_userInDisabled = false;
    private boolean m_userInAutonomous = false;
    private boolean m_userInTeleop = false;
    private boolean m_userInTest = false;
    private boolean m_newControlData;
    private final long m_packetDataAvailableMutex;
    private final long m_packetDataAvailableSem;

    public static DriverStation getInstance() {
        return instance;
    }

    protected DriverStation() {
        for (int i = 0; i < 6; ++i) {
            this.m_joystickButtons[i] = new HALJoystickButtons();
        }
        this.m_packetDataAvailableMutex = HALUtil.initializeMutexNormal();
        this.m_packetDataAvailableSem = HALUtil.initializeMultiWait();
        FRCNetworkCommunicationsLibrary.setNewDataSem(this.m_packetDataAvailableSem);
        this.m_thread = new Thread((Runnable)new DriverStationTask(this), "FRCDriverStation");
        this.m_thread.setPriority(7);
        this.m_thread.start();
    }

    public void release() {
        this.m_thread_keepalive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void task() {
        int safetyCounter = 0;
        while (this.m_thread_keepalive) {
            HALUtil.takeMultiWait(this.m_packetDataAvailableSem, this.m_packetDataAvailableMutex);
            Object object = this;
            synchronized (object) {
                this.getData();
            }
            object = this.m_dataSem;
            synchronized (object) {
                this.m_dataSem.notifyAll();
            }
            if (++safetyCounter >= 4) {
                MotorSafetyHelper.checkMotors();
                safetyCounter = 0;
            }
            if (this.m_userInDisabled) {
                FRCNetworkCommunicationsLibrary.FRCNetworkCommunicationObserveUserProgramDisabled();
            }
            if (this.m_userInAutonomous) {
                FRCNetworkCommunicationsLibrary.FRCNetworkCommunicationObserveUserProgramAutonomous();
            }
            if (this.m_userInTeleop) {
                FRCNetworkCommunicationsLibrary.FRCNetworkCommunicationObserveUserProgramTeleop();
            }
            if (!this.m_userInTest) continue;
            FRCNetworkCommunicationsLibrary.FRCNetworkCommunicationObserveUserProgramTest();
        }
    }

    public void waitForData() {
        this.waitForData(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForData(long timeout) {
        Object object = this.m_dataSem;
        synchronized (object) {
            try {
                this.m_dataSem.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected synchronized void getData() {
        for (byte stick = 0; stick < 6; stick = (byte)(stick + 1)) {
            this.m_joystickAxes[stick] = FRCNetworkCommunicationsLibrary.HALGetJoystickAxes(stick);
            this.m_joystickPOVs[stick] = FRCNetworkCommunicationsLibrary.HALGetJoystickPOVs(stick);
            ByteBuffer countBuffer = ByteBuffer.allocateDirect(1);
            this.m_joystickButtons[stick].buttons = FRCNetworkCommunicationsLibrary.HALGetJoystickButtons(stick, countBuffer);
            this.m_joystickButtons[stick].count = countBuffer.get();
        }
        this.m_newControlData = true;
    }

    public double getBatteryVoltage() {
        return PowerJNI.getVinVoltage();
    }

    private void reportJoystickUnpluggedError(String message) {
        double currentTime = Timer.getFPGATimestamp();
        if (currentTime > this.m_nextMessageTime) {
            DriverStation.reportError(message, false);
            this.m_nextMessageTime = currentTime + 1.0;
        }
    }

    public synchronized double getStickAxis(int stick, int axis) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        if (axis < 0 || axis >= FRCNetworkCommunicationsLibrary.kMaxJoystickAxes) {
            throw new RuntimeException("Joystick axis is out of range");
        }
        if (axis >= this.m_joystickAxes[stick].length) {
            this.reportJoystickUnpluggedError("WARNING: Joystick axis " + axis + " on port " + stick + " not available, check if controller is plugged in\n");
            return 0.0;
        }
        byte value = (byte)this.m_joystickAxes[stick][axis];
        if (value < 0) {
            return (double)value / 128.0;
        }
        return (double)value / 127.0;
    }

    public synchronized int getStickAxisCount(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        return this.m_joystickAxes[stick].length;
    }

    public synchronized int getStickPOV(int stick, int pov) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        if (pov < 0 || pov >= FRCNetworkCommunicationsLibrary.kMaxJoystickPOVs) {
            throw new RuntimeException("Joystick POV is out of range");
        }
        if (pov >= this.m_joystickPOVs[stick].length) {
            this.reportJoystickUnpluggedError("WARNING: Joystick POV " + pov + " on port " + stick + " not available, check if controller is plugged in\n");
            return -1;
        }
        return this.m_joystickPOVs[stick][pov];
    }

    public synchronized int getStickPOVCount(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        return this.m_joystickPOVs[stick].length;
    }

    public synchronized int getStickButtons(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-3");
        }
        return this.m_joystickButtons[stick].buttons;
    }

    public synchronized boolean getStickButton(int stick, byte button) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-3");
        }
        if (button > this.m_joystickButtons[stick].count) {
            this.reportJoystickUnpluggedError("WARNING: Joystick Button " + button + " on port " + stick + " not available, check if controller is plugged in\n");
            return false;
        }
        if (button <= 0) {
            this.reportJoystickUnpluggedError("ERROR: Button indexes begin at 1 in WPILib for C++ and Java\n");
            return false;
        }
        return (1 << button - 1 & this.m_joystickButtons[stick].buttons) != 0;
    }

    public synchronized int getStickButtonCount(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        return this.m_joystickButtons[stick].count;
    }

    public synchronized boolean getJoystickIsXbox(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        if (1 > this.m_joystickButtons[stick].count && 1 > this.m_joystickAxes[stick].length) {
            this.reportJoystickUnpluggedError("WARNING: Joystick on port " + stick + " not available, check if controller is plugged in\n");
            return false;
        }
        boolean retVal = false;
        if (FRCNetworkCommunicationsLibrary.HALGetJoystickIsXbox((byte)stick) == 1) {
            retVal = true;
        }
        return retVal;
    }

    public synchronized int getJoystickType(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        if (1 > this.m_joystickButtons[stick].count && 1 > this.m_joystickAxes[stick].length) {
            this.reportJoystickUnpluggedError("WARNING: Joystick on port " + stick + " not available, check if controller is plugged in\n");
            return -1;
        }
        return FRCNetworkCommunicationsLibrary.HALGetJoystickType((byte)stick);
    }

    public synchronized String getJoystickName(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        if (1 > this.m_joystickButtons[stick].count && 1 > this.m_joystickAxes[stick].length) {
            this.reportJoystickUnpluggedError("WARNING: Joystick on port " + stick + " not available, check if controller is plugged in\n");
            return "";
        }
        return FRCNetworkCommunicationsLibrary.HALGetJoystickName((byte)stick);
    }

    @Override
    public boolean isEnabled() {
        HALControlWord controlWord = FRCNetworkCommunicationsLibrary.HALGetControlWord();
        return controlWord.getEnabled() && controlWord.getDSAttached();
    }

    @Override
    public boolean isDisabled() {
        return !this.isEnabled();
    }

    @Override
    public boolean isAutonomous() {
        HALControlWord controlWord = FRCNetworkCommunicationsLibrary.HALGetControlWord();
        return controlWord.getAutonomous();
    }

    @Override
    public boolean isTest() {
        HALControlWord controlWord = FRCNetworkCommunicationsLibrary.HALGetControlWord();
        return controlWord.getTest();
    }

    @Override
    public boolean isOperatorControl() {
        return !this.isAutonomous() && !this.isTest();
    }

    public boolean isSysActive() {
        return FRCNetworkCommunicationsLibrary.HALGetSystemActive();
    }

    public boolean isBrownedOut() {
        return FRCNetworkCommunicationsLibrary.HALGetBrownedOut();
    }

    public synchronized boolean isNewControlData() {
        boolean result = this.m_newControlData;
        this.m_newControlData = false;
        return result;
    }

    public Alliance getAlliance() {
        HALAllianceStationID allianceStationID = FRCNetworkCommunicationsLibrary.HALGetAllianceStation();
        if (allianceStationID == null) {
            return Alliance.Invalid;
        }
        switch (allianceStationID) {
            case Red1: 
            case Red2: 
            case Red3: {
                return Alliance.Red;
            }
            case Blue1: 
            case Blue2: 
            case Blue3: {
                return Alliance.Blue;
            }
        }
        return Alliance.Invalid;
    }

    public int getLocation() {
        HALAllianceStationID allianceStationID = FRCNetworkCommunicationsLibrary.HALGetAllianceStation();
        if (allianceStationID == null) {
            return 0;
        }
        switch (allianceStationID) {
            case Red1: 
            case Blue1: {
                return 1;
            }
            case Red2: 
            case Blue2: {
                return 2;
            }
            case Red3: 
            case Blue3: {
                return 3;
            }
        }
        return 0;
    }

    public boolean isFMSAttached() {
        HALControlWord controlWord = FRCNetworkCommunicationsLibrary.HALGetControlWord();
        return controlWord.getFMSAttached();
    }

    public boolean isDSAttached() {
        HALControlWord controlWord = FRCNetworkCommunicationsLibrary.HALGetControlWord();
        return controlWord.getDSAttached();
    }

    public double getMatchTime() {
        return FRCNetworkCommunicationsLibrary.HALGetMatchTime();
    }

    public static void reportError(String error, boolean printTrace) {
        String errorString = error;
        if (printTrace) {
            errorString = errorString + " at ";
            StackTraceElement[] traces = Thread.currentThread().getStackTrace();
            for (int i = 2; i < traces.length; ++i) {
                errorString = errorString + traces[i].toString() + "\n";
            }
        }
        System.err.println(errorString);
        HALControlWord controlWord = FRCNetworkCommunicationsLibrary.HALGetControlWord();
        if (controlWord.getDSAttached()) {
            FRCNetworkCommunicationsLibrary.HALSetErrorData(errorString);
        }
    }

    public void InDisabled(boolean entering) {
        this.m_userInDisabled = entering;
    }

    public void InAutonomous(boolean entering) {
        this.m_userInAutonomous = entering;
    }

    public void InOperatorControl(boolean entering) {
        this.m_userInTeleop = entering;
    }

    public void InTest(boolean entering) {
        this.m_userInTest = entering;
    }

    private static class DriverStationTask
    implements Runnable {
        private DriverStation m_ds;

        DriverStationTask(DriverStation ds) {
            this.m_ds = ds;
        }

        @Override
        public void run() {
            this.m_ds.task();
        }
    }

    public static enum Alliance {
        Red,
        Blue,
        Invalid;

    }

    private class HALJoystickButtons {
        public int buttons;
        public byte count;

        private HALJoystickButtons() {
        }
    }
}

