/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogTrigger;
import edu.wpi.first.wpilibj.AnalogTriggerOutput;
import edu.wpi.first.wpilibj.CounterBase;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.CounterJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.util.BoundaryException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Counter
extends SensorBase
implements CounterBase,
LiveWindowSendable,
PIDSource {
    protected DigitalSource m_upSource;
    protected DigitalSource m_downSource;
    private boolean m_allocatedUpSource;
    private boolean m_allocatedDownSource;
    private long m_counter;
    private int m_index;
    private PIDSourceType m_pidSource;
    private double m_distancePerPulse;
    private ITable m_table;

    private void initCounter(Mode mode) {
        ByteBuffer index = ByteBuffer.allocateDirect(4);
        index.order(ByteOrder.LITTLE_ENDIAN);
        this.m_counter = CounterJNI.initializeCounter(mode.value, index.asIntBuffer());
        this.m_index = index.asIntBuffer().get(0);
        this.m_allocatedUpSource = false;
        this.m_allocatedDownSource = false;
        this.m_upSource = null;
        this.m_downSource = null;
        this.setMaxPeriod(0.5);
        UsageReporting.report(11, this.m_index, mode.value);
    }

    public Counter() {
        this.initCounter(Mode.kTwoPulse);
    }

    public Counter(DigitalSource source) {
        if (source == null) {
            throw new NullPointerException("Digital Source given was null");
        }
        this.initCounter(Mode.kTwoPulse);
        this.setUpSource(source);
    }

    public Counter(int channel) {
        this.initCounter(Mode.kTwoPulse);
        this.setUpSource(channel);
    }

    public Counter(CounterBase.EncodingType encodingType, DigitalSource upSource, DigitalSource downSource, boolean inverted) {
        this.initCounter(Mode.kExternalDirection);
        if (encodingType != CounterBase.EncodingType.k1X && encodingType != CounterBase.EncodingType.k2X) {
            throw new RuntimeException("Counters only support 1X and 2X quadreature decoding!");
        }
        if (upSource == null) {
            throw new NullPointerException("Up Source given was null");
        }
        this.setUpSource(upSource);
        if (downSource == null) {
            throw new NullPointerException("Down Source given was null");
        }
        this.setDownSource(downSource);
        if (encodingType == null) {
            throw new NullPointerException("Encoding type given was null");
        }
        if (encodingType == CounterBase.EncodingType.k1X) {
            this.setUpSourceEdge(true, false);
            CounterJNI.setCounterAverageSize(this.m_counter, 1);
        } else {
            this.setUpSourceEdge(true, true);
            CounterJNI.setCounterAverageSize(this.m_counter, 2);
        }
        this.setDownSourceEdge(inverted, true);
    }

    public Counter(AnalogTrigger trigger) {
        if (trigger == null) {
            throw new NullPointerException("The Analog Trigger given was null");
        }
        this.initCounter(Mode.kTwoPulse);
        this.setUpSource(trigger.createOutput(AnalogTriggerOutput.AnalogTriggerType.kState));
    }

    @Override
    public void free() {
        this.setUpdateWhenEmpty(true);
        this.clearUpSource();
        this.clearDownSource();
        CounterJNI.freeCounter(this.m_counter);
        this.m_upSource = null;
        this.m_downSource = null;
        this.m_counter = 0L;
    }

    public int getFPGAIndex() {
        return this.m_index;
    }

    public void setUpSource(int channel) {
        this.setUpSource(new DigitalInput(channel));
        this.m_allocatedUpSource = true;
    }

    public void setUpSource(DigitalSource source) {
        if (this.m_upSource != null && this.m_allocatedUpSource) {
            this.m_upSource.free();
            this.m_allocatedUpSource = false;
        }
        this.m_upSource = source;
        CounterJNI.setCounterUpSource(this.m_counter, source.getChannelForRouting(), source.getAnalogTriggerForRouting());
    }

    public void setUpSource(AnalogTrigger analogTrigger, AnalogTriggerOutput.AnalogTriggerType triggerType) {
        if (analogTrigger == null) {
            throw new NullPointerException("Analog Trigger given was null");
        }
        if (triggerType == null) {
            throw new NullPointerException("Analog Trigger Type given was null");
        }
        this.setUpSource(analogTrigger.createOutput(triggerType));
        this.m_allocatedUpSource = true;
    }

    public void setUpSourceEdge(boolean risingEdge, boolean fallingEdge) {
        if (this.m_upSource == null) {
            throw new RuntimeException("Up Source must be set before setting the edge!");
        }
        CounterJNI.setCounterUpSourceEdge(this.m_counter, risingEdge, fallingEdge);
    }

    public void clearUpSource() {
        if (this.m_upSource != null && this.m_allocatedUpSource) {
            this.m_upSource.free();
            this.m_allocatedUpSource = false;
        }
        this.m_upSource = null;
        CounterJNI.clearCounterUpSource(this.m_counter);
    }

    public void setDownSource(int channel) {
        this.setDownSource(new DigitalInput(channel));
        this.m_allocatedDownSource = true;
    }

    public void setDownSource(DigitalSource source) {
        if (source == null) {
            throw new NullPointerException("The Digital Source given was null");
        }
        if (this.m_downSource != null && this.m_allocatedDownSource) {
            this.m_downSource.free();
            this.m_allocatedDownSource = false;
        }
        CounterJNI.setCounterDownSource(this.m_counter, source.getChannelForRouting(), source.getAnalogTriggerForRouting());
        this.m_downSource = source;
    }

    public void setDownSource(AnalogTrigger analogTrigger, AnalogTriggerOutput.AnalogTriggerType triggerType) {
        if (analogTrigger == null) {
            throw new NullPointerException("Analog Trigger given was null");
        }
        if (triggerType == null) {
            throw new NullPointerException("Analog Trigger Type given was null");
        }
        this.setDownSource(analogTrigger.createOutput(triggerType));
        this.m_allocatedDownSource = true;
    }

    public void setDownSourceEdge(boolean risingEdge, boolean fallingEdge) {
        if (this.m_downSource == null) {
            throw new RuntimeException(" Down Source must be set before setting the edge!");
        }
        CounterJNI.setCounterDownSourceEdge(this.m_counter, risingEdge, fallingEdge);
    }

    public void clearDownSource() {
        if (this.m_downSource != null && this.m_allocatedDownSource) {
            this.m_downSource.free();
            this.m_allocatedDownSource = false;
        }
        this.m_downSource = null;
        CounterJNI.clearCounterDownSource(this.m_counter);
    }

    public void setUpDownCounterMode() {
        CounterJNI.setCounterUpDownMode(this.m_counter);
    }

    public void setExternalDirectionMode() {
        CounterJNI.setCounterExternalDirectionMode(this.m_counter);
    }

    public void setSemiPeriodMode(boolean highSemiPeriod) {
        CounterJNI.setCounterSemiPeriodMode(this.m_counter, highSemiPeriod);
    }

    public void setPulseLengthMode(double threshold) {
        CounterJNI.setCounterPulseLengthMode(this.m_counter, threshold);
    }

    @Override
    public int get() {
        return CounterJNI.getCounter(this.m_counter);
    }

    public double getDistance() {
        return (double)this.get() * this.m_distancePerPulse;
    }

    @Override
    public void reset() {
        CounterJNI.resetCounter(this.m_counter);
    }

    @Override
    public void setMaxPeriod(double maxPeriod) {
        CounterJNI.setCounterMaxPeriod(this.m_counter, maxPeriod);
    }

    public void setUpdateWhenEmpty(boolean enabled) {
        CounterJNI.setCounterUpdateWhenEmpty(this.m_counter, enabled);
    }

    @Override
    public boolean getStopped() {
        return CounterJNI.getCounterStopped(this.m_counter);
    }

    @Override
    public boolean getDirection() {
        return CounterJNI.getCounterDirection(this.m_counter);
    }

    public void setReverseDirection(boolean reverseDirection) {
        CounterJNI.setCounterReverseDirection(this.m_counter, reverseDirection);
    }

    @Override
    public double getPeriod() {
        return CounterJNI.getCounterPeriod(this.m_counter);
    }

    public double getRate() {
        return this.m_distancePerPulse / this.getPeriod();
    }

    public void setSamplesToAverage(int samplesToAverage) {
        CounterJNI.setCounterSamplesToAverage(this.m_counter, samplesToAverage);
    }

    public int getSamplesToAverage() {
        return CounterJNI.getCounterSamplesToAverage(this.m_counter);
    }

    public void setDistancePerPulse(double distancePerPulse) {
        this.m_distancePerPulse = distancePerPulse;
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        if (pidSource == null) {
            throw new NullPointerException("PID Source Parameter given was null");
        }
        BoundaryException.assertWithinBounds(pidSource.value, 0.0, 1.0);
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        switch (this.m_pidSource) {
            case kDisplacement: {
                return this.getDistance();
            }
            case kRate: {
                return this.getRate();
            }
        }
        return 0.0;
    }

    @Override
    public String getSmartDashboardType() {
        return "Counter";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.get());
        }
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }

    public static enum Mode {
        kTwoPulse(0),
        kSemiperiod(1),
        kPulseLength(2),
        kExternalDirection(3);

        public final int value;

        private Mode(int value) {
            this.value = value;
        }
    }
}

