/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import com.ni.vision.NIVision;
import com.ni.vision.VisionException;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.vision.USBCamera;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

public class CameraServer {
    private static final int kPort = 1180;
    private static final byte[] kMagicNumber = new byte[]{1, 0, 0, 0};
    private static final int kSize640x480 = 0;
    private static final int kSize320x240 = 1;
    private static final int kSize160x120 = 2;
    private static final int kHardwareCompression = -1;
    private static final String kDefaultCameraName = "cam1";
    private static final int kMaxImageSize = 200000;
    private static CameraServer server;
    private Thread serverThread;
    private int m_quality = 50;
    private boolean m_autoCaptureStarted;
    private boolean m_hwClient = true;
    private USBCamera m_camera = null;
    private CameraData m_imageData = null;
    private Deque<ByteBuffer> m_imageDataPool = new ArrayDeque<ByteBuffer>(3);

    public static CameraServer getInstance() {
        if (server == null) {
            server = new CameraServer();
        }
        return server;
    }

    private CameraServer() {
        for (int i = 0; i < 3; ++i) {
            this.m_imageDataPool.addLast(ByteBuffer.allocateDirect(200000));
        }
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CameraServer.this.serve();
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.serverThread.setName("CameraServer Send Thread");
        this.serverThread.start();
    }

    private synchronized void setImageData(NIVision.RawData data, int start) {
        if (this.m_imageData != null && this.m_imageData.data != null) {
            this.m_imageData.data.free();
            if (this.m_imageData.data.getBuffer() != null) {
                this.m_imageDataPool.addLast(this.m_imageData.data.getBuffer());
            }
            this.m_imageData = null;
        }
        this.m_imageData = new CameraData(data, start);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(NIVision.Image image) {
        int index;
        boolean hwClient;
        NIVision.RawData data = NIVision.imaqFlatten(image, NIVision.FlattenType.FLATTEN_IMAGE, NIVision.CompressionType.COMPRESSION_JPEG, 10 * this.m_quality);
        ByteBuffer buffer = data.getBuffer();
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            hwClient = this.m_hwClient;
        }
        if (hwClient) {
            for (index = 0; index < buffer.limit() - 1 && ((buffer.get(index) & 0xFF) != 255 || (buffer.get(index + 1) & 0xFF) != 216); ++index) {
            }
        }
        if (buffer.limit() - index - 1 <= 2) {
            throw new VisionException("data size of flattened image is less than 2. Try another camera! ");
        }
        this.setImageData(data, index);
    }

    public void startAutomaticCapture() {
        this.startAutomaticCapture(USBCamera.kDefaultCameraName);
    }

    public void startAutomaticCapture(String cameraName) {
        try {
            USBCamera camera = new USBCamera(cameraName);
            camera.openCamera();
            this.startAutomaticCapture(camera);
        }
        catch (VisionException ex) {
            DriverStation.reportError("Error when starting the camera: " + cameraName + " " + ex.getMessage(), true);
        }
    }

    public synchronized void startAutomaticCapture(USBCamera camera) {
        if (this.m_autoCaptureStarted) {
            return;
        }
        this.m_autoCaptureStarted = true;
        this.m_camera = camera;
        this.m_camera.startCapture();
        Thread captureThread = new Thread(new Runnable(){

            @Override
            public void run() {
                CameraServer.this.capture();
            }
        });
        captureThread.setName("Camera Capture Thread");
        captureThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void capture() {
        NIVision.Image frame = NIVision.imaqCreateImage(NIVision.ImageType.IMAGE_RGB, 0);
        while (true) {
            boolean hwClient;
            ByteBuffer dataBuffer = null;
            CameraServer cameraServer = this;
            synchronized (cameraServer) {
                hwClient = this.m_hwClient;
                if (hwClient) {
                    dataBuffer = this.m_imageDataPool.removeLast();
                }
            }
            try {
                if (hwClient && dataBuffer != null) {
                    dataBuffer.limit(dataBuffer.capacity() - 1);
                    this.m_camera.getImageData(dataBuffer);
                    this.setImageData(new NIVision.RawData(dataBuffer), 0);
                    continue;
                }
                this.m_camera.getImage(frame);
                this.setImage(frame);
            }
            catch (VisionException ex) {
                DriverStation.reportError("Error when getting image from the camera: " + ex.getMessage(), true);
                if (dataBuffer == null) continue;
                CameraServer cameraServer2 = this;
                synchronized (cameraServer2) {
                    this.m_imageDataPool.addLast(dataBuffer);
                    Timer.delay(0.1);
                }
            }
        }
    }

    public synchronized boolean isAutoCaptureStarted() {
        return this.m_autoCaptureStarted;
    }

    public synchronized void setSize(int size) {
        if (this.m_camera == null) {
            return;
        }
        switch (size) {
            case 0: {
                this.m_camera.setSize(640, 480);
                break;
            }
            case 1: {
                this.m_camera.setSize(320, 240);
                break;
            }
            case 2: {
                this.m_camera.setSize(160, 120);
            }
        }
    }

    public synchronized void setQuality(int quality) {
        this.m_quality = quality > 100 ? 100 : (quality < 0 ? 0 : quality);
    }

    public synchronized int getQuality() {
        return this.m_quality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serve() throws IOException, InterruptedException {
        ServerSocket socket = new ServerSocket();
        socket.setReuseAddress(true);
        InetSocketAddress address = new InetSocketAddress(1180);
        socket.bind(address);
        while (true) {
            try {
                block18: while (true) {
                    CameraData imageData;
                    Socket s = socket.accept();
                    DataInputStream is = new DataInputStream(s.getInputStream());
                    DataOutputStream os = new DataOutputStream(s.getOutputStream());
                    int fps = is.readInt();
                    int compression = is.readInt();
                    int size = is.readInt();
                    if (compression != -1) {
                        DriverStation.reportError("Choose \"USB Camera HW\" on the dashboard", false);
                        s.close();
                        continue;
                    }
                    CameraServer cameraServer = this;
                    synchronized (cameraServer) {
                        System.out.println("Camera not yet ready, awaiting image");
                        if (this.m_camera == null) {
                            this.wait();
                        }
                        boolean bl = this.m_hwClient = compression == -1;
                        if (!this.m_hwClient) {
                            this.setQuality(100 - compression);
                        } else if (this.m_camera != null) {
                            this.m_camera.setFPS(fps);
                        }
                        this.setSize(size);
                    }
                    long period = (long)(1000.0 / (1.0 * (double)fps));
                    while (true) {
                        long t0 = System.currentTimeMillis();
                        imageData = null;
                        CameraServer cameraServer2 = this;
                        synchronized (cameraServer2) {
                            this.wait();
                            imageData = this.m_imageData;
                            this.m_imageData = null;
                            if (imageData == null) continue;
                        }
                        imageData.data.getBuffer().position(imageData.start);
                        byte[] imageArray = new byte[imageData.data.getBuffer().remaining()];
                        imageData.data.getBuffer().get(imageArray, 0, imageData.data.getBuffer().remaining());
                        try {
                            os.write(kMagicNumber);
                            os.writeInt(imageArray.length);
                            os.write(imageArray);
                            os.flush();
                            long dt = System.currentTimeMillis() - t0;
                            if (dt >= period) continue;
                            Thread.sleep(period - dt);
                        }
                        catch (IOException | UnsupportedOperationException ex) {
                            DriverStation.reportError(ex.getMessage(), true);
                            continue block18;
                        }
                    }
                    finally {
                        imageData.data.free();
                        if (imageData.data.getBuffer() == null) continue;
                        CameraServer cameraServer3 = this;
                        synchronized (cameraServer3) {
                            this.m_imageDataPool.addLast(imageData.data.getBuffer());
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                DriverStation.reportError(ex.getMessage(), true);
                continue;
            }
            break;
        }
    }

    private class CameraData {
        NIVision.RawData data;
        int start;

        public CameraData(NIVision.RawData d, int s) {
            this.data = d;
            this.start = s;
        }
    }
}

