/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.CANSpeedController;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.can.CANJNI;
import edu.wpi.first.wpilibj.can.CANMessageNotFoundException;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CANJaguar
implements MotorSafety,
PIDOutput,
CANSpeedController {
    public static final int kMaxMessageDataSize = 8;
    public static final int kControllerRate = 1000;
    public static final double kApproxBusVoltage = 12.0;
    private MotorSafetyHelper m_safetyHelper;
    private static final Resource allocated = new Resource(63);
    private static final int kFullMessageIDMask = 536870848;
    private static final int kSendMessagePeriod = 20;
    public static final EncoderTag kEncoder = new EncoderTag();
    public static final QuadEncoderTag kQuadEncoder = new QuadEncoderTag();
    public static final PotentiometerTag kPotentiometer = new PotentiometerTag();
    private boolean isInverted = false;
    public static final int kCurrentFault = 1;
    public static final int kTemperatureFault = 2;
    public static final int kBusVoltageFault = 4;
    public static final int kGateDriverFault = 8;
    public static final int kForwardLimit = 1;
    public static final int kReverseLimit = 2;
    byte m_deviceNumber;
    double m_value = 0.0;
    JaguarControlMode m_controlMode;
    int m_speedReference = 255;
    int m_positionReference = 255;
    double m_p = 0.0;
    double m_i = 0.0;
    double m_d = 0.0;
    NeutralMode m_neutralMode = NeutralMode.Jumper;
    short m_encoderCodesPerRev = 0;
    short m_potentiometerTurns = 0;
    LimitMode m_limitMode = LimitMode.SwitchInputsOnly;
    double m_forwardLimit = 0.0;
    double m_reverseLimit = 0.0;
    double m_maxOutputVoltage = 12.0;
    double m_voltageRampRate = 0.0;
    float m_faultTime = 0.0f;
    boolean m_controlModeVerified = true;
    boolean m_speedRefVerified = true;
    boolean m_posRefVerified = true;
    boolean m_pVerified = true;
    boolean m_iVerified = true;
    boolean m_dVerified = true;
    boolean m_neutralModeVerified = true;
    boolean m_encoderCodesPerRevVerified = true;
    boolean m_potentiometerTurnsVerified = true;
    boolean m_forwardLimitVerified = true;
    boolean m_reverseLimitVerified = true;
    boolean m_limitModeVerified = true;
    boolean m_maxOutputVoltageVerified = true;
    boolean m_voltageRampRateVerified = true;
    boolean m_faultTimeVerified = true;
    double m_busVoltage = 0.0;
    double m_outputVoltage = 0.0;
    double m_outputCurrent = 0.0;
    double m_temperature = 0.0;
    double m_position = 0.0;
    double m_speed = 0.0;
    byte m_limits = 0;
    short m_faults = 0;
    int m_firmwareVersion = 0;
    byte m_hardwareVersion = 0;
    boolean m_receivedStatusMessage0 = false;
    boolean m_receivedStatusMessage1 = false;
    boolean m_receivedStatusMessage2 = false;
    static final int kReceiveStatusAttempts = 50;
    boolean m_controlEnabled = true;
    private ITable m_table = null;
    private ITableListener m_table_listener = null;

    public CANJaguar(int deviceNumber) {
        try {
            allocated.allocate(deviceNumber - 1);
        }
        catch (CheckedAllocationException e1) {
            throw new AllocationException("CANJaguar device " + e1.getMessage() + "(increment index by one)");
        }
        this.m_deviceNumber = (byte)deviceNumber;
        this.m_controlMode = JaguarControlMode.PercentVbus;
        this.m_safetyHelper = new MotorSafetyHelper(this);
        boolean receivedFirmwareVersion = false;
        byte[] data = new byte[8];
        this.requestMessage(-2147483136);
        this.requestMessage(520225088);
        for (int i = 0; i < 50; ++i) {
            Timer.delay(0.001);
            this.setupPeriodicStatus();
            this.updatePeriodicStatus();
            if (!receivedFirmwareVersion) {
                try {
                    this.getMessage(512, 0x1FFFFFFF, data);
                    this.m_firmwareVersion = CANJaguar.unpackINT32(data);
                    receivedFirmwareVersion = true;
                }
                catch (CANMessageNotFoundException cANMessageNotFoundException) {
                    // empty catch block
                }
            }
            if (this.m_receivedStatusMessage0 && this.m_receivedStatusMessage1 && this.m_receivedStatusMessage2 && receivedFirmwareVersion) break;
        }
        if (!(this.m_receivedStatusMessage0 && this.m_receivedStatusMessage1 && this.m_receivedStatusMessage2 && receivedFirmwareVersion)) {
            this.free();
            throw new CANMessageNotFoundException();
        }
        try {
            this.getMessage(520225088, 0x1FFFFFFF, data);
            this.m_hardwareVersion = data[0];
        }
        catch (CANMessageNotFoundException e) {
            this.m_hardwareVersion = 0;
        }
        if (this.m_firmwareVersion >= 3330 || this.m_firmwareVersion < 108) {
            if (this.m_firmwareVersion < 3330) {
                DriverStation.reportError("Jag " + this.m_deviceNumber + " firmware " + this.m_firmwareVersion + " is too old (must be at least version 108 of the FIRST approved firmware)", false);
            } else {
                DriverStation.reportError("Jag" + this.m_deviceNumber + " firmware " + this.m_firmwareVersion + " is not FIRST approved (must be at least version 108 of the FIRST approved firmware)", false);
            }
            return;
        }
    }

    public void free() {
        int messageID;
        allocated.free(this.m_deviceNumber - 1);
        this.m_safetyHelper = null;
        switch (this.m_controlMode) {
            case PercentVbus: {
                messageID = this.m_deviceNumber | 0x2020140;
                break;
            }
            case Speed: {
                messageID = this.m_deviceNumber | 0x2020600;
                break;
            }
            case Position: {
                messageID = this.m_deviceNumber | 0x2020E00;
                break;
            }
            case Current: {
                messageID = this.m_deviceNumber | 0x20211C0;
                break;
            }
            case Voltage: {
                messageID = this.m_deviceNumber | 0x2020980;
                break;
            }
            default: {
                return;
            }
        }
        CANJNI.FRCNetworkCommunicationCANSessionMuxSendMessage(messageID, null, -1);
        this.configMaxOutputVoltage(12.0);
    }

    int getDeviceNumber() {
        return this.m_deviceNumber;
    }

    @Override
    public double get() {
        return this.m_value;
    }

    @Override
    public double getSetpoint() {
        return this.get();
    }

    @Override
    public double getError() {
        return this.get() - this.getPosition();
    }

    @Override
    public void set(double outputValue, byte syncGroup) {
        byte[] data = new byte[8];
        if (this.m_controlEnabled) {
            byte dataSize;
            int messageID;
            switch (this.m_controlMode) {
                case PercentVbus: {
                    messageID = 33685824;
                    dataSize = CANJaguar.packPercentage(data, this.isInverted ? -outputValue : outputValue);
                    break;
                }
                case Speed: {
                    messageID = 0x2020600;
                    dataSize = CANJaguar.packFXP16_16(data, this.isInverted ? -outputValue : outputValue);
                    break;
                }
                case Position: {
                    messageID = 0x2020E00;
                    dataSize = CANJaguar.packFXP16_16(data, outputValue);
                    break;
                }
                case Current: {
                    messageID = 33690048;
                    dataSize = CANJaguar.packFXP8_8(data, outputValue);
                    break;
                }
                case Voltage: {
                    messageID = 33687936;
                    dataSize = CANJaguar.packFXP8_8(data, this.isInverted ? -outputValue : outputValue);
                    break;
                }
                default: {
                    return;
                }
            }
            if (syncGroup != 0) {
                byte by = dataSize;
                dataSize = (byte)(dataSize + 1);
                data[by] = syncGroup;
            }
            this.sendMessage(messageID, data, dataSize, 20);
            if (this.m_safetyHelper != null) {
                this.m_safetyHelper.feed();
            }
        }
        this.m_value = outputValue;
        this.verify();
    }

    @Override
    public void set(double value) {
        this.set(value, (byte)0);
    }

    @Override
    public void setSetpoint(double value) {
        this.set(value);
    }

    @Override
    public void reset() {
        this.set(this.m_value);
        this.disableControl();
    }

    @Override
    public void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
    }

    @Override
    public boolean getInverted() {
        return this.isInverted;
    }

    protected void verify() {
        byte[] data;
        block105: {
            data = new byte[8];
            try {
                boolean powerCycled;
                this.getMessage(33691136, 0x1FFFFFFF, data);
                boolean bl = powerCycled = data[0] != 0;
                if (powerCycled) {
                    int[] messages;
                    data[0] = 1;
                    this.sendMessage(33691136, data, 1);
                    this.m_controlModeVerified = false;
                    this.m_speedRefVerified = false;
                    this.m_posRefVerified = false;
                    this.m_neutralModeVerified = false;
                    this.m_encoderCodesPerRevVerified = false;
                    this.m_potentiometerTurnsVerified = false;
                    this.m_forwardLimitVerified = false;
                    this.m_reverseLimitVerified = false;
                    this.m_limitModeVerified = false;
                    this.m_maxOutputVoltageVerified = false;
                    this.m_faultTimeVerified = false;
                    if (this.m_controlMode == JaguarControlMode.PercentVbus || this.m_controlMode == JaguarControlMode.Voltage) {
                        this.m_voltageRampRateVerified = false;
                    } else {
                        this.m_pVerified = false;
                        this.m_iVerified = false;
                        this.m_dVerified = false;
                    }
                    this.m_receivedStatusMessage0 = false;
                    this.m_receivedStatusMessage1 = false;
                    this.m_receivedStatusMessage2 = false;
                    for (int message : messages = new int[]{33686912, 33688960, 33686720, 0x2020CC0, 33689792, 0x2020500, 0x2020D00, 0x2021100, 33686848, 33688896, 33689920, 33692736, 33692800, 33692864, 33692928, 33693056, 33693120, 0x20200C0, 0x2020900, 33693184, 33692992}) {
                        try {
                            this.getMessage(message, 0x1FFFFFFF, data);
                        }
                        catch (CANMessageNotFoundException cANMessageNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (CANMessageNotFoundException e) {
                this.requestMessage(33691136);
            }
            if (!this.m_controlModeVerified && this.m_controlEnabled) {
                try {
                    this.getMessage(33691200, 0x1FFFFFFF, data);
                    JaguarControlMode mode = JaguarControlMode.values()[data[0]];
                    if (this.m_controlMode == mode) {
                        this.m_controlModeVerified = true;
                    } else {
                        this.enableControl();
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33691200);
                }
            }
            if (!this.m_speedRefVerified) {
                try {
                    this.getMessage(33686912, 0x1FFFFFFF, data);
                    byte speedRef = data[0];
                    if (this.m_speedReference == speedRef) {
                        this.m_speedRefVerified = true;
                    } else {
                        this.setSpeedReference(this.m_speedReference);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33686912);
                }
            }
            if (!this.m_posRefVerified) {
                try {
                    this.getMessage(33688960, 0x1FFFFFFF, data);
                    byte posRef = data[0];
                    if (this.m_positionReference == posRef) {
                        this.m_posRefVerified = true;
                    } else {
                        this.setPositionReference(this.m_positionReference);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33688960);
                }
            }
            if (!this.m_pVerified) {
                int message = 0;
                switch (this.m_controlMode) {
                    case Speed: {
                        message = 33686720;
                        break;
                    }
                    case Position: {
                        message = 0x2020CC0;
                        break;
                    }
                    case Current: {
                        message = 33689792;
                        break;
                    }
                }
                try {
                    this.getMessage(message, 0x1FFFFFFF, data);
                    double p = CANJaguar.unpackFXP16_16(data);
                    if (this.FXP16_EQ(this.m_p, p)) {
                        this.m_pVerified = true;
                    } else {
                        this.setP(this.m_p);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(message);
                }
            }
            if (!this.m_iVerified) {
                int message = 0;
                switch (this.m_controlMode) {
                    case Speed: {
                        message = 0x2020500;
                        break;
                    }
                    case Position: {
                        message = 0x2020D00;
                        break;
                    }
                    case Current: {
                        message = 0x2021100;
                        break;
                    }
                }
                try {
                    this.getMessage(message, 0x1FFFFFFF, data);
                    double i = CANJaguar.unpackFXP16_16(data);
                    if (this.FXP16_EQ(this.m_i, i)) {
                        this.m_iVerified = true;
                    } else {
                        this.setI(this.m_i);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(message);
                }
            }
            if (!this.m_dVerified) {
                int message = 0;
                switch (this.m_controlMode) {
                    case Speed: {
                        message = 33686848;
                        break;
                    }
                    case Position: {
                        message = 33688896;
                        break;
                    }
                    case Current: {
                        message = 33689920;
                        break;
                    }
                }
                try {
                    this.getMessage(message, 0x1FFFFFFF, data);
                    double d = CANJaguar.unpackFXP16_16(data);
                    if (this.FXP16_EQ(this.m_d, d)) {
                        this.m_dVerified = true;
                    } else {
                        this.setD(this.m_d);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(message);
                }
            }
            if (!this.m_neutralModeVerified) {
                try {
                    this.getMessage(33692864, 0x1FFFFFFF, data);
                    NeutralMode mode = NeutralMode.valueOf(data[0]);
                    if (mode == this.m_neutralMode) {
                        this.m_neutralModeVerified = true;
                    } else {
                        this.configNeutralMode(this.m_neutralMode);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33692864);
                }
            }
            if (!this.m_encoderCodesPerRevVerified) {
                try {
                    this.getMessage(33692736, 0x1FFFFFFF, data);
                    short codes = CANJaguar.unpackINT16(data);
                    if (codes == this.m_encoderCodesPerRev) {
                        this.m_encoderCodesPerRevVerified = true;
                    } else {
                        this.configEncoderCodesPerRev(this.m_encoderCodesPerRev);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33692736);
                }
            }
            if (!this.m_potentiometerTurnsVerified) {
                try {
                    this.getMessage(33692800, 0x1FFFFFFF, data);
                    short turns = CANJaguar.unpackINT16(data);
                    if (turns == this.m_potentiometerTurns) {
                        this.m_potentiometerTurnsVerified = true;
                    } else {
                        this.configPotentiometerTurns(this.m_potentiometerTurns);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33692800);
                }
            }
            if (!this.m_limitModeVerified) {
                try {
                    this.getMessage(33692928, 0x1FFFFFFF, data);
                    LimitMode mode = LimitMode.valueOf(data[0]);
                    if (mode == this.m_limitMode) {
                        this.m_limitModeVerified = true;
                    } else {
                        this.configLimitMode(this.m_limitMode);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33692928);
                }
            }
            if (!this.m_forwardLimitVerified) {
                try {
                    this.getMessage(33692992, 0x1FFFFFFF, data);
                    double limit = CANJaguar.unpackFXP16_16(data);
                    if (this.FXP16_EQ(limit, this.m_forwardLimit)) {
                        this.m_forwardLimitVerified = true;
                    } else {
                        this.configForwardLimit(this.m_forwardLimit);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33692992);
                }
            }
            if (!this.m_reverseLimitVerified) {
                try {
                    this.getMessage(33693056, 0x1FFFFFFF, data);
                    double limit = CANJaguar.unpackFXP16_16(data);
                    if (this.FXP16_EQ(limit, this.m_reverseLimit)) {
                        this.m_reverseLimitVerified = true;
                    } else {
                        this.configReverseLimit(this.m_reverseLimit);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33693056);
                }
            }
            if (!this.m_maxOutputVoltageVerified) {
                try {
                    this.getMessage(33693120, 0x1FFFFFFF, data);
                    double voltage = CANJaguar.unpackFXP8_8(data);
                    if (Math.abs(voltage - this.m_maxOutputVoltage) < 0.1) {
                        this.m_maxOutputVoltageVerified = true;
                    } else {
                        this.configMaxOutputVoltage(this.m_maxOutputVoltage);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(33693120);
                }
            }
            if (!this.m_voltageRampRateVerified) {
                if (this.m_controlMode == JaguarControlMode.PercentVbus) {
                    try {
                        this.getMessage(0x20200C0, 0x1FFFFFFF, data);
                        double rate = CANJaguar.unpackPercentage(data);
                        if (this.FXP16_EQ(rate, this.m_voltageRampRate)) {
                            this.m_voltageRampRateVerified = true;
                            break block105;
                        }
                        this.setVoltageRampRate(this.m_voltageRampRate);
                    }
                    catch (CANMessageNotFoundException e) {
                        this.requestMessage(0x20200C0);
                    }
                }
            } else if (this.m_controlMode == JaguarControlMode.Voltage) {
                try {
                    this.getMessage(0x2020900, 0x1FFFFFFF, data);
                    double rate = CANJaguar.unpackFXP8_8(data);
                    if (this.FXP8_EQ(rate, this.m_voltageRampRate)) {
                        this.m_voltageRampRateVerified = true;
                    } else {
                        this.setVoltageRampRate(this.m_voltageRampRate);
                    }
                }
                catch (CANMessageNotFoundException e) {
                    this.requestMessage(0x2020900);
                }
            }
        }
        if (!this.m_faultTimeVerified) {
            try {
                this.getMessage(33693184, 0x1FFFFFFF, data);
                short faultTime = CANJaguar.unpackINT16(data);
                if ((int)((double)this.m_faultTime * 1000.0) == faultTime) {
                    this.m_faultTimeVerified = true;
                } else {
                    this.configFaultTime(this.m_faultTime);
                }
            }
            catch (CANMessageNotFoundException e) {
                this.requestMessage(33693184);
            }
        }
        if (!(this.m_receivedStatusMessage0 && this.m_receivedStatusMessage1 && this.m_receivedStatusMessage2)) {
            this.setupPeriodicStatus();
            this.getTemperature();
            this.getPosition();
            this.getFaults();
        }
    }

    @Override
    @Deprecated
    public void disable() {
        this.disableControl();
    }

    @Override
    public void enable() {
        this.enableControl();
    }

    @Override
    public void pidWrite(double output) {
        if (this.m_controlMode != JaguarControlMode.PercentVbus) {
            throw new IllegalStateException("PID only supported in PercentVbus mode");
        }
        this.set(output);
    }

    private void setSpeedReference(int reference) {
        this.sendMessage(33686912, new byte[]{(byte)reference}, 1);
        this.m_speedReference = reference;
        this.m_speedRefVerified = false;
    }

    private void setPositionReference(int reference) {
        this.sendMessage(33688960, new byte[]{(byte)reference}, 1);
        this.m_positionReference = reference;
        this.m_posRefVerified = false;
    }

    @Override
    public void setP(double p) {
        byte[] data = new byte[8];
        byte dataSize = CANJaguar.packFXP16_16(data, p);
        switch (this.m_controlMode) {
            case Speed: {
                this.sendMessage(33686720, data, dataSize);
                break;
            }
            case Position: {
                this.sendMessage(0x2020CC0, data, dataSize);
                break;
            }
            case Current: {
                this.sendMessage(33689792, data, dataSize);
                break;
            }
            default: {
                throw new IllegalStateException("PID constants only apply in Speed, Position, and Current mode");
            }
        }
        this.m_p = p;
        this.m_pVerified = false;
    }

    @Override
    public void setI(double i) {
        byte[] data = new byte[8];
        byte dataSize = CANJaguar.packFXP16_16(data, i);
        switch (this.m_controlMode) {
            case Speed: {
                this.sendMessage(0x2020500, data, dataSize);
                break;
            }
            case Position: {
                this.sendMessage(0x2020D00, data, dataSize);
                break;
            }
            case Current: {
                this.sendMessage(0x2021100, data, dataSize);
                break;
            }
            default: {
                throw new IllegalStateException("PID constants only apply in Speed, Position, and Current mode");
            }
        }
        this.m_i = i;
        this.m_iVerified = false;
    }

    @Override
    public void setD(double d) {
        byte[] data = new byte[8];
        byte dataSize = CANJaguar.packFXP16_16(data, d);
        switch (this.m_controlMode) {
            case Speed: {
                this.sendMessage(33686848, data, dataSize);
                break;
            }
            case Position: {
                this.sendMessage(33688896, data, dataSize);
                break;
            }
            case Current: {
                this.sendMessage(33689920, data, dataSize);
                break;
            }
            default: {
                throw new IllegalStateException("PID constants only apply in Speed, Position, and Current mode");
            }
        }
        this.m_d = d;
        this.m_dVerified = false;
    }

    @Override
    public void setPID(double p, double i, double d) {
        this.setP(p);
        this.setI(i);
        this.setD(d);
    }

    @Override
    public double getP() {
        if (this.m_controlMode.equals(JaguarControlMode.PercentVbus) || this.m_controlMode.equals(JaguarControlMode.Voltage)) {
            throw new IllegalStateException("PID does not apply in Percent or Voltage control modes");
        }
        return this.m_p;
    }

    @Override
    public double getI() {
        if (this.m_controlMode.equals(JaguarControlMode.PercentVbus) || this.m_controlMode.equals(JaguarControlMode.Voltage)) {
            throw new IllegalStateException("PID does not apply in Percent or Voltage control modes");
        }
        return this.m_i;
    }

    @Override
    public double getD() {
        if (this.m_controlMode.equals(JaguarControlMode.PercentVbus) || this.m_controlMode.equals(JaguarControlMode.Voltage)) {
            throw new IllegalStateException("PID does not apply in Percent or Voltage control modes");
        }
        return this.m_d;
    }

    public void enableControl(double encoderInitialPosition) {
        switch (this.m_controlMode) {
            case PercentVbus: {
                this.sendMessage(0x2020100, new byte[0], 0);
                break;
            }
            case Speed: {
                this.sendMessage(33686976, new byte[0], 0);
                break;
            }
            case Position: {
                byte[] data = new byte[8];
                byte dataSize = CANJaguar.packFXP16_16(data, encoderInitialPosition);
                this.sendMessage(33689024, data, dataSize);
                break;
            }
            case Current: {
                this.sendMessage(33689984, new byte[0], 0);
                break;
            }
            case Voltage: {
                this.sendMessage(33687872, new byte[0], 0);
            }
        }
        this.m_controlEnabled = true;
    }

    public void enableControl() {
        this.enableControl(0.0);
    }

    @Override
    public boolean isEnabled() {
        return this.m_controlEnabled;
    }

    public void disableControl() {
        this.sendMessage(0x2020040, new byte[0], 0);
        this.sendMessage(0x2020440, new byte[0], 0);
        this.sendMessage(33688640, new byte[0], 0);
        this.sendMessage(33689664, new byte[0], 0);
        this.sendMessage(33687616, new byte[0], 0);
        this.sendMessage(33685824, new byte[0], 0, -1);
        this.sendMessage(0x2020600, new byte[0], 0, -1);
        this.sendMessage(0x2020E00, new byte[0], 0, -1);
        this.sendMessage(33690048, new byte[0], 0, -1);
        this.sendMessage(33687936, new byte[0], 0, -1);
        this.m_controlEnabled = false;
    }

    public void setPercentMode() {
        this.changeControlMode(JaguarControlMode.PercentVbus);
        this.setPositionReference(255);
        this.setSpeedReference(255);
    }

    public void setPercentMode(EncoderTag tag, int codesPerRev) {
        this.changeControlMode(JaguarControlMode.PercentVbus);
        this.setPositionReference(255);
        this.setSpeedReference(0);
        this.configEncoderCodesPerRev(codesPerRev);
    }

    public void setPercentMode(QuadEncoderTag tag, int codesPerRev) {
        this.changeControlMode(JaguarControlMode.PercentVbus);
        this.setPositionReference(0);
        this.setSpeedReference(3);
        this.configEncoderCodesPerRev(codesPerRev);
    }

    public void setPercentMode(PotentiometerTag tag) {
        this.changeControlMode(JaguarControlMode.PercentVbus);
        this.setPositionReference(1);
        this.setSpeedReference(255);
        this.configPotentiometerTurns(1);
    }

    public void setCurrentMode(double p, double i, double d) {
        this.changeControlMode(JaguarControlMode.Current);
        this.setPositionReference(255);
        this.setSpeedReference(255);
        this.setPID(p, i, d);
    }

    public void setCurrentMode(EncoderTag tag, int codesPerRev, double p, double i, double d) {
        this.changeControlMode(JaguarControlMode.Current);
        this.setPositionReference(255);
        this.setSpeedReference(255);
        this.configEncoderCodesPerRev(codesPerRev);
        this.setPID(p, i, d);
    }

    public void setCurrentMode(QuadEncoderTag tag, int codesPerRev, double p, double i, double d) {
        this.changeControlMode(JaguarControlMode.Current);
        this.setPositionReference(0);
        this.setSpeedReference(3);
        this.configEncoderCodesPerRev(codesPerRev);
        this.setPID(p, i, d);
    }

    public void setCurrentMode(PotentiometerTag tag, double p, double i, double d) {
        this.changeControlMode(JaguarControlMode.Current);
        this.setPositionReference(1);
        this.setSpeedReference(255);
        this.configPotentiometerTurns(1);
        this.setPID(p, i, d);
    }

    public void setSpeedMode(EncoderTag tag, int codesPerRev, double p, double i, double d) {
        this.changeControlMode(JaguarControlMode.Speed);
        this.setPositionReference(255);
        this.setSpeedReference(0);
        this.configEncoderCodesPerRev(codesPerRev);
        this.setPID(p, i, d);
    }

    public void setSpeedMode(QuadEncoderTag tag, int codesPerRev, double p, double i, double d) {
        this.changeControlMode(JaguarControlMode.Speed);
        this.setPositionReference(0);
        this.setSpeedReference(3);
        this.configEncoderCodesPerRev(codesPerRev);
        this.setPID(p, i, d);
    }

    public void setPositionMode(QuadEncoderTag tag, int codesPerRev, double p, double i, double d) {
        this.changeControlMode(JaguarControlMode.Position);
        this.setPositionReference(0);
        this.configEncoderCodesPerRev(codesPerRev);
        this.setPID(p, i, d);
    }

    public void setPositionMode(PotentiometerTag tag, double p, double i, double d) {
        this.changeControlMode(JaguarControlMode.Position);
        this.setPositionReference(1);
        this.configPotentiometerTurns(1);
        this.setPID(p, i, d);
    }

    public void setVoltageMode() {
        this.changeControlMode(JaguarControlMode.Voltage);
        this.setPositionReference(255);
        this.setSpeedReference(255);
    }

    public void setVoltageMode(EncoderTag tag, int codesPerRev) {
        this.changeControlMode(JaguarControlMode.Voltage);
        this.setPositionReference(255);
        this.setSpeedReference(0);
        this.configEncoderCodesPerRev(codesPerRev);
    }

    public void setVoltageMode(QuadEncoderTag tag, int codesPerRev) {
        this.changeControlMode(JaguarControlMode.Voltage);
        this.setPositionReference(0);
        this.setSpeedReference(3);
        this.configEncoderCodesPerRev(codesPerRev);
    }

    public void setVoltageMode(PotentiometerTag tag) {
        this.changeControlMode(JaguarControlMode.Voltage);
        this.setPositionReference(1);
        this.setSpeedReference(255);
        this.configPotentiometerTurns(1);
    }

    private void changeControlMode(JaguarControlMode controlMode) {
        this.disableControl();
        this.m_controlMode = controlMode;
        this.m_controlModeVerified = false;
    }

    @Override
    public JaguarControlMode getControlMode() {
        return this.m_controlMode;
    }

    @Override
    public void setControlMode(int mode) {
        this.changeControlMode(JaguarControlMode.values()[mode]);
    }

    @Override
    public double getBusVoltage() {
        this.updatePeriodicStatus();
        return this.m_busVoltage;
    }

    @Override
    public double getOutputVoltage() {
        this.updatePeriodicStatus();
        return this.m_outputVoltage;
    }

    @Override
    public double getOutputCurrent() {
        this.updatePeriodicStatus();
        return this.m_outputCurrent;
    }

    @Override
    public double getTemperature() {
        this.updatePeriodicStatus();
        return this.m_temperature;
    }

    @Override
    public double getPosition() {
        this.updatePeriodicStatus();
        return this.m_position;
    }

    @Override
    public double getSpeed() {
        this.updatePeriodicStatus();
        return this.m_speed;
    }

    public boolean getForwardLimitOK() {
        this.updatePeriodicStatus();
        return (this.m_limits & 1) != 0;
    }

    public boolean getReverseLimitOK() {
        this.updatePeriodicStatus();
        return (this.m_limits & 2) != 0;
    }

    public short getFaults() {
        this.updatePeriodicStatus();
        return this.m_faults;
    }

    @Override
    public void setVoltageRampRate(double rampRate) {
        int message;
        byte dataSize;
        byte[] data = new byte[8];
        switch (this.m_controlMode) {
            case PercentVbus: {
                dataSize = CANJaguar.packPercentage(data, rampRate / (this.m_maxOutputVoltage * 1000.0));
                message = 0x20200C0;
                break;
            }
            case Voltage: {
                dataSize = CANJaguar.packFXP8_8(data, rampRate / 1000.0);
                message = 0x2020900;
                break;
            }
            default: {
                throw new IllegalStateException("Voltage ramp rate only applies in Percentage and Voltage modes");
            }
        }
        this.sendMessage(message, data, dataSize);
    }

    public int getFirmwareVersion() {
        return this.m_firmwareVersion;
    }

    public byte getHardwareVersion() {
        return this.m_hardwareVersion;
    }

    public void configNeutralMode(NeutralMode mode) {
        this.sendMessage(33692864, new byte[]{mode.value}, 1);
        this.m_neutralMode = mode;
        this.m_neutralModeVerified = false;
    }

    public void configEncoderCodesPerRev(int codesPerRev) {
        byte[] data = new byte[8];
        byte dataSize = CANJaguar.packINT16(data, (short)codesPerRev);
        this.sendMessage(33692736, data, dataSize);
        this.m_encoderCodesPerRev = (short)codesPerRev;
        this.m_encoderCodesPerRevVerified = false;
    }

    public void configPotentiometerTurns(int turns) {
        byte[] data = new byte[8];
        byte dataSize = CANJaguar.packINT16(data, (short)turns);
        this.sendMessage(33692800, data, dataSize);
        this.m_potentiometerTurns = (short)turns;
        this.m_potentiometerTurnsVerified = false;
    }

    public void configSoftPositionLimits(double forwardLimitPosition, double reverseLimitPosition) {
        this.configLimitMode(LimitMode.SoftPositionLimits);
        this.configForwardLimit(forwardLimitPosition);
        this.configReverseLimit(reverseLimitPosition);
    }

    public void disableSoftPositionLimits() {
        this.configLimitMode(LimitMode.SwitchInputsOnly);
    }

    public void configLimitMode(LimitMode mode) {
        this.sendMessage(33692928, new byte[]{mode.value}, 1);
    }

    public void configForwardLimit(double forwardLimitPosition) {
        byte[] data = new byte[8];
        int dataSize = CANJaguar.packFXP16_16(data, forwardLimitPosition);
        data[dataSize++] = 1;
        this.sendMessage(33692992, data, dataSize);
        this.m_forwardLimit = forwardLimitPosition;
        this.m_forwardLimitVerified = false;
    }

    public void configReverseLimit(double reverseLimitPosition) {
        byte[] data = new byte[8];
        int dataSize = CANJaguar.packFXP16_16(data, reverseLimitPosition);
        data[dataSize++] = 1;
        this.sendMessage(33693056, data, dataSize);
        this.m_reverseLimit = reverseLimitPosition;
        this.m_reverseLimitVerified = false;
    }

    public void configMaxOutputVoltage(double voltage) {
        byte[] data = new byte[8];
        byte dataSize = CANJaguar.packFXP8_8(data, voltage);
        this.sendMessage(33693120, data, dataSize);
        this.m_maxOutputVoltage = voltage;
        this.m_maxOutputVoltageVerified = false;
    }

    public void configFaultTime(float faultTime) {
        byte[] data = new byte[8];
        if (faultTime < 0.5f) {
            faultTime = 0.5f;
        } else if (faultTime > 3.0f) {
            faultTime = 3.0f;
        }
        byte dataSize = CANJaguar.packINT16(data, (short)((double)faultTime * 1000.0));
        this.sendMessage(33693184, data, dataSize);
        this.m_faultTime = faultTime;
        this.m_faultTimeVerified = false;
    }

    static void sendMessageHelper(int messageID, byte[] data, int dataSize, int period) throws CANMessageNotFoundException {
        ByteBuffer buffer;
        int[] kTrustedMessages = new int[]{0x2020100, 33685824, 33686976, 0x2020600, 33687872, 33687936, 33689024, 0x2020E00, 33689984, 33690048};
        for (int i = 0; i < kTrustedMessages.length; i = (int)((byte)(i + 1))) {
            if ((0x1FFFFFC0 & messageID) != kTrustedMessages[i]) continue;
            if (dataSize > 6) {
                throw new RuntimeException("CAN message has too much data.");
            }
            ByteBuffer trustedBuffer = ByteBuffer.allocateDirect(dataSize + 2);
            trustedBuffer.put(0, (byte)0);
            trustedBuffer.put(1, (byte)0);
            for (int j = 0; j < dataSize; j = (int)((byte)(j + 1))) {
                trustedBuffer.put(j + 2, data[j]);
            }
            CANJNI.FRCNetworkCommunicationCANSessionMuxSendMessage(messageID, trustedBuffer, period);
            return;
        }
        if (data != null) {
            buffer = ByteBuffer.allocateDirect(dataSize);
            for (int i = 0; i < dataSize; i = (int)((byte)(i + 1))) {
                buffer.put(i, data[i]);
            }
        } else {
            buffer = null;
        }
        CANJNI.FRCNetworkCommunicationCANSessionMuxSendMessage(messageID, buffer, period);
    }

    protected void sendMessage(int messageID, byte[] data, int dataSize, int period) {
        CANJaguar.sendMessageHelper(messageID | this.m_deviceNumber, data, dataSize, period);
    }

    protected void sendMessage(int messageID, byte[] data, int dataSize) {
        this.sendMessage(messageID, data, dataSize, 0);
    }

    protected void requestMessage(int messageID, int period) {
        CANJaguar.sendMessageHelper(messageID | this.m_deviceNumber, null, 0, period);
    }

    protected void requestMessage(int messageID) {
        this.requestMessage(messageID, 0);
    }

    protected void getMessage(int messageID, int messageMask, byte[] data) throws CANMessageNotFoundException {
        messageID |= this.m_deviceNumber;
        ByteBuffer targetedMessageID = ByteBuffer.allocateDirect(4);
        targetedMessageID.order(ByteOrder.LITTLE_ENDIAN);
        targetedMessageID.asIntBuffer().put(0, messageID &= 0x1FFFFFFF);
        ByteBuffer timeStamp = ByteBuffer.allocateDirect(4);
        ByteBuffer dataBuffer = CANJNI.FRCNetworkCommunicationCANSessionMuxReceiveMessage(targetedMessageID.asIntBuffer(), messageMask, timeStamp);
        if (data != null) {
            for (int i = 0; i < dataBuffer.capacity(); ++i) {
                data[i] = dataBuffer.get(i);
            }
        }
    }

    protected void setupPeriodicStatus() {
        byte[] data = new byte[8];
        byte[] kMessage0Data = new byte[]{3, 4, 1, 2, 5, 6, 7, 8};
        byte[] kMessage1Data = new byte[]{9, 10, 11, 12, 13, 14, 15, 16};
        byte[] kMessage2Data = new byte[]{18, 19, 0, 0, 0, 0, 0, 0};
        int dataSize = CANJaguar.packINT16(data, (short)20);
        this.sendMessage(33691648, data, dataSize);
        this.sendMessage(33691712, data, dataSize);
        this.sendMessage(33691776, data, dataSize);
        dataSize = 8;
        this.sendMessage(33691904, kMessage0Data, dataSize);
        this.sendMessage(33691968, kMessage1Data, dataSize);
        this.sendMessage(33692032, kMessage2Data, dataSize);
    }

    protected void updatePeriodicStatus() {
        byte[] data = new byte[8];
        try {
            this.getMessage(33692160, 0x1FFFFFFF, data);
            this.m_busVoltage = CANJaguar.unpackFXP8_8(new byte[]{data[0], data[1]});
            this.m_outputVoltage = CANJaguar.unpackPercentage(new byte[]{data[2], data[3]}) * this.m_busVoltage;
            this.m_outputCurrent = CANJaguar.unpackFXP8_8(new byte[]{data[4], data[5]});
            this.m_temperature = CANJaguar.unpackFXP8_8(new byte[]{data[6], data[7]});
            this.m_receivedStatusMessage0 = true;
        }
        catch (CANMessageNotFoundException cANMessageNotFoundException) {
            // empty catch block
        }
        try {
            this.getMessage(33692224, 0x1FFFFFFF, data);
            this.m_position = CANJaguar.unpackFXP16_16(new byte[]{data[0], data[1], data[2], data[3]});
            this.m_speed = CANJaguar.unpackFXP16_16(new byte[]{data[4], data[5], data[6], data[7]});
            this.m_receivedStatusMessage1 = true;
        }
        catch (CANMessageNotFoundException cANMessageNotFoundException) {
            // empty catch block
        }
        try {
            this.getMessage(33692288, 0x1FFFFFFF, data);
            this.m_limits = data[0];
            this.m_faults = data[1];
            this.m_receivedStatusMessage2 = true;
        }
        catch (CANMessageNotFoundException cANMessageNotFoundException) {
            // empty catch block
        }
    }

    public static void updateSyncGroup(byte syncGroup) {
        byte[] data = new byte[8];
        data[0] = syncGroup;
        CANJaguar.sendMessageHelper(384, data, 1, 0);
    }

    private static final void swap16(int x, byte[] buffer) {
        buffer[0] = (byte)(x & 0xFF);
        buffer[1] = (byte)(x >> 8 & 0xFF);
    }

    private static final void swap32(int x, byte[] buffer) {
        buffer[0] = (byte)(x & 0xFF);
        buffer[1] = (byte)(x >> 8 & 0xFF);
        buffer[2] = (byte)(x >> 16 & 0xFF);
        buffer[3] = (byte)(x >> 24 & 0xFF);
    }

    private static final byte packPercentage(byte[] buffer, double value) {
        if (value < -1.0) {
            value = -1.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        short intValue = (short)(value * 32767.0);
        CANJaguar.swap16(intValue, buffer);
        return 2;
    }

    private static final byte packFXP8_8(byte[] buffer, double value) {
        short intValue = (short)(value * 256.0);
        CANJaguar.swap16(intValue, buffer);
        return 2;
    }

    private static final byte packFXP16_16(byte[] buffer, double value) {
        int intValue = (int)(value * 65536.0);
        CANJaguar.swap32(intValue, buffer);
        return 4;
    }

    private static final byte packINT16(byte[] buffer, short value) {
        CANJaguar.swap16(value, buffer);
        return 2;
    }

    private static final byte packINT32(byte[] buffer, int value) {
        CANJaguar.swap32(value, buffer);
        return 4;
    }

    private static final short unpack16(byte[] buffer, int offset) {
        return (short)(buffer[offset] & 0xFF | (short)(buffer[offset + 1] << 8) & 0xFF00);
    }

    private static final int unpack32(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF | buffer[offset + 1] << 8 & 0xFF00 | buffer[offset + 2] << 16 & 0xFF0000 | buffer[offset + 3] << 24 & 0xFF000000;
    }

    private static final double unpackPercentage(byte[] buffer) {
        return (double)CANJaguar.unpack16(buffer, 0) / 32767.0;
    }

    private static final double unpackFXP8_8(byte[] buffer) {
        return (double)CANJaguar.unpack16(buffer, 0) / 256.0;
    }

    private static final double unpackFXP16_16(byte[] buffer) {
        return (double)CANJaguar.unpack32(buffer, 0) / 65536.0;
    }

    private static final short unpackINT16(byte[] buffer) {
        return CANJaguar.unpack16(buffer, 0);
    }

    private static final int unpackINT32(byte[] buffer) {
        return CANJaguar.unpack32(buffer, 0);
    }

    public boolean FXP8_EQ(double a, double b) {
        return (int)(a * 256.0) == (int)(b * 256.0);
    }

    public boolean FXP16_EQ(double a, double b) {
        return (int)(a * 65536.0) == (int)(b * 65536.0);
    }

    @Override
    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    @Override
    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    @Override
    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    @Override
    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    @Override
    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    @Override
    public String getDescription() {
        return "CANJaguar ID " + this.m_deviceNumber;
    }

    public int getDeviceID() {
        return this.m_deviceNumber;
    }

    @Override
    @Deprecated
    public void stopMotor() {
        this.disableControl();
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        CANSpeedController.super.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
        this.set(0.0);
        this.m_table_listener = this.createTableListener();
        this.m_table.addTableListener(this.m_table_listener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.set(0.0);
        this.m_table.removeTableListener(this.m_table_listener);
    }

    public static enum LimitMode {
        SwitchInputsOnly(0),
        SoftPositionLimits(1);

        public byte value;

        public static LimitMode valueOf(byte value) {
            for (LimitMode mode : LimitMode.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private LimitMode(byte value) {
            this.value = value;
        }
    }

    public static enum NeutralMode {
        Jumper(0),
        Brake(1),
        Coast(2);

        public byte value;

        public static NeutralMode valueOf(byte value) {
            for (NeutralMode mode : NeutralMode.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private NeutralMode(byte value) {
            this.value = value;
        }
    }

    public static enum JaguarControlMode implements CANSpeedController.ControlMode
    {
        PercentVbus,
        Current,
        Speed,
        Position,
        Voltage;


        @Override
        public boolean isPID() {
            return this == Current || this == Speed || this == Position;
        }

        @Override
        public int getValue() {
            return this.ordinal();
        }
    }

    private static class PotentiometerTag {
        private PotentiometerTag() {
        }
    }

    private static class QuadEncoderTag {
        private QuadEncoderTag() {
        }
    }

    private static class EncoderTag {
        private EncoderTag() {
        }
    }
}

