/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogInput;
import edu.wpi.first.wpilibj.ControllerPower;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.interfaces.Potentiometer;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class AnalogPotentiometer
implements Potentiometer,
LiveWindowSendable {
    private double m_fullRange;
    private double m_offset;
    private AnalogInput m_analog_input;
    private boolean m_init_analog_input;
    protected PIDSourceType m_pidSource = PIDSourceType.kDisplacement;
    private ITable m_table;

    private void initPot(AnalogInput input, double fullRange, double offset) {
        this.m_fullRange = fullRange;
        this.m_offset = offset;
        this.m_analog_input = input;
    }

    public AnalogPotentiometer(int channel, double fullRange, double offset) {
        AnalogInput input = new AnalogInput(channel);
        this.m_init_analog_input = true;
        this.initPot(input, fullRange, offset);
    }

    public AnalogPotentiometer(AnalogInput input, double fullRange, double offset) {
        this.m_init_analog_input = false;
        this.initPot(input, fullRange, offset);
    }

    public AnalogPotentiometer(int channel, double scale) {
        this(channel, scale, 0.0);
    }

    public AnalogPotentiometer(AnalogInput input, double scale) {
        this(input, scale, 0.0);
    }

    public AnalogPotentiometer(int channel) {
        this(channel, 1.0, 0.0);
    }

    public AnalogPotentiometer(AnalogInput input) {
        this(input, 1.0, 0.0);
    }

    @Override
    public double get() {
        return this.m_analog_input.getVoltage() / ControllerPower.getVoltage5V() * this.m_fullRange + this.m_offset;
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        if (!pidSource.equals((Object)PIDSourceType.kDisplacement)) {
            throw new IllegalArgumentException("Only displacement PID is allowed for potentiometers.");
        }
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        return this.get();
    }

    @Override
    public String getSmartDashboardType() {
        return "Analog Input";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.get());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    public void free() {
        if (this.m_init_analog_input) {
            this.m_analog_input.free();
            this.m_analog_input = null;
            this.m_init_analog_input = false;
        }
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

