/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AccumulatorResult;
import edu.wpi.first.wpilibj.AnalogInput;
import edu.wpi.first.wpilibj.GyroBase;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.interfaces.Gyro;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;

public class AnalogGyro
extends GyroBase
implements Gyro,
PIDSource,
LiveWindowSendable {
    static final int kOversampleBits = 10;
    static final int kAverageBits = 0;
    static final double kSamplesPerSecond = 50.0;
    static final double kCalibrationSampleTime = 5.0;
    static final double kDefaultVoltsPerDegreePerSecond = 0.007;
    protected AnalogInput m_analog;
    double m_voltsPerDegreePerSecond;
    double m_offset;
    int m_center;
    boolean m_channelAllocated = false;
    AccumulatorResult result;
    private PIDSourceType m_pidSource;

    public void initGyro() {
        this.result = new AccumulatorResult();
        this.m_voltsPerDegreePerSecond = 0.007;
        this.m_analog.setAverageBits(0);
        this.m_analog.setOversampleBits(10);
        double sampleRate = 51200.0;
        AnalogInput.setGlobalSampleRate(sampleRate);
        Timer.delay(0.1);
        this.setDeadband(0.0);
        this.setPIDSourceType(PIDSourceType.kDisplacement);
        UsageReporting.report(20, this.m_analog.getChannel());
        LiveWindow.addSensor("AnalogGyro", this.m_analog.getChannel(), (LiveWindowSendable)this);
    }

    @Override
    public void calibrate() {
        this.m_analog.initAccumulator();
        this.m_analog.resetAccumulator();
        Timer.delay(5.0);
        this.m_analog.getAccumulatorOutput(this.result);
        this.m_center = (int)((double)this.result.value / (double)this.result.count + 0.5);
        this.m_offset = (double)this.result.value / (double)this.result.count - (double)this.m_center;
        this.m_analog.setAccumulatorCenter(this.m_center);
        this.m_analog.resetAccumulator();
    }

    public AnalogGyro(int channel) {
        this(new AnalogInput(channel));
        this.m_channelAllocated = true;
    }

    public AnalogGyro(AnalogInput channel) {
        this.m_analog = channel;
        if (this.m_analog == null) {
            throw new NullPointerException("AnalogInput supplied to Gyro constructor is null");
        }
        this.initGyro();
        this.calibrate();
    }

    public AnalogGyro(int channel, int center, double offset) {
        this(new AnalogInput(channel), center, offset);
        this.m_channelAllocated = true;
    }

    public AnalogGyro(AnalogInput channel, int center, double offset) {
        this.m_analog = channel;
        if (this.m_analog == null) {
            throw new NullPointerException("AnalogInput supplied to Gyro constructor is null");
        }
        this.initGyro();
        this.m_offset = offset;
        this.m_center = center;
        this.m_analog.setAccumulatorCenter(this.m_center);
        this.m_analog.resetAccumulator();
    }

    @Override
    public void reset() {
        if (this.m_analog != null) {
            this.m_analog.resetAccumulator();
        }
    }

    @Override
    public void free() {
        if (this.m_analog != null && this.m_channelAllocated) {
            this.m_analog.free();
        }
        this.m_analog = null;
    }

    @Override
    public double getAngle() {
        if (this.m_analog == null) {
            return 0.0;
        }
        this.m_analog.getAccumulatorOutput(this.result);
        long value = this.result.value - (long)((double)this.result.count * this.m_offset);
        double scaledValue = (double)value * 1.0E-9 * (double)this.m_analog.getLSBWeight() * (double)(1 << this.m_analog.getAverageBits()) / (AnalogInput.getGlobalSampleRate() * this.m_voltsPerDegreePerSecond);
        return scaledValue;
    }

    @Override
    public double getRate() {
        if (this.m_analog == null) {
            return 0.0;
        }
        return ((double)this.m_analog.getAverageValue() - ((double)this.m_center + this.m_offset)) * 1.0E-9 * (double)this.m_analog.getLSBWeight() / ((double)(1 << this.m_analog.getOversampleBits()) * this.m_voltsPerDegreePerSecond);
    }

    public double getOffset() {
        return this.m_offset;
    }

    public int getCenter() {
        return this.m_center;
    }

    public void setSensitivity(double voltsPerDegreePerSecond) {
        this.m_voltsPerDegreePerSecond = voltsPerDegreePerSecond;
    }

    void setDeadband(double volts) {
        int deadband = (int)(volts * 1.0E9 / (double)this.m_analog.getLSBWeight() * (double)(1 << this.m_analog.getOversampleBits()));
        this.m_analog.setAccumulatorDeadband(deadband);
    }
}

