/*
 * Decompiled with CFR 0.152.
 */
package com.ni.vision;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NIVision {
    private static Constructor<?> constructDirectByteBuffer;
    private static Field bufferAddressField;
    public static final boolean DEFAULT_SHOW_COORDINATES = true;
    public static final int DEFAULT_MAX_ICONS_PER_LINE = 4;
    public static final boolean DEFAULT_BMP_COMPRESS = false;
    public static final int DEFAULT_PNG_QUALITY = 750;
    public static final int DEFAULT_JPEG_QUALITY = 750;
    public static final int ALL_CONTOURS = -1;
    public static final int ALL_WINDOWS = -1;
    public static final int SHIFT = 1;
    public static final int ALT = 2;
    public static final int CTRL = 4;
    public static final int CAPS_LOCK = 8;
    public static final int MODAL_DIALOG = -1;
    public static final int USE_DEFAULT_QUALITY = -1;
    public static final int ALL_SAMPLES = -1;
    public static final int ALL_OBJECTS = -1;
    public static final int ALL_CHARACTERS = -1;
    public static final byte[] ANY_CHARACTER;
    public static final byte[] ALPHABETIC;
    public static final byte[] ALPHANUMERIC;
    public static final byte[] UPPERCASE_LETTERS;
    public static final byte[] LOWERCASE_LETTERS;
    public static final byte[] DECIMAL_DIGITS;
    public static final byte[] HEXADECIMAL_DIGITS;
    public static final byte[] PATTERN;
    public static final byte[] FORCE_SPACE;
    public static final Rect NO_RECT;
    public static final RotatedRect NO_ROTATED_RECT;
    public static final Point NO_POINT;
    public static final PointFloat NO_POINT_FLOAT;
    public static final PointFloat NO_OFFSET;
    public static final RGBValue RGB_TRANSPARENT;
    public static final RGBValue RGB_RED;
    public static final RGBValue RGB_BLUE;
    public static final RGBValue RGB_GREEN;
    public static final RGBValue RGB_YELLOW;
    public static final RGBValue RGB_WHITE;
    public static final RGBValue RGB_BLACK;
    public static final int IMAQDX_MAX_API_STRING_LENGTH = 512;

    private NIVision() {
    }

    private static native void imaqDispose(long var0);

    private static ByteBuffer newDirectByteBuffer(long addr, int cap) {
        try {
            return ((ByteBuffer)constructDirectByteBuffer.newInstance(addr, cap)).order(ByteOrder.nativeOrder());
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static long getByteBufferAddress(ByteBuffer bb) {
        try {
            return bufferAddressField.getLong(bb);
        }
        catch (IllegalAccessException e) {
            return 0L;
        }
    }

    public static ByteBuffer sliceByteBuffer(ByteBuffer bb, int offset, int size) {
        int pos = bb.position();
        int lim = bb.limit();
        bb.position(offset);
        bb.limit(offset + size);
        ByteBuffer new_bb = bb.slice().order(ByteOrder.nativeOrder());
        bb.position(pos);
        bb.limit(lim);
        return new_bb;
    }

    public static ByteBuffer getBytes(ByteBuffer bb, byte[] dst, int offset, int size) {
        int pos = bb.position();
        bb.position(offset);
        bb.get(dst, 0, size);
        bb.position(pos);
        return bb;
    }

    public static ByteBuffer putBytes(ByteBuffer bb, byte[] src, int offset, int size) {
        int pos = bb.position();
        bb.position(offset);
        bb.put(src, 0, size);
        bb.position(pos);
        return bb;
    }

    private static long getPointer(ByteBuffer bb, int offset) {
        return bb.getInt(offset);
    }

    private static void putPointer(ByteBuffer bb, int offset, long address) {
        bb.putInt(offset, (int)address);
    }

    private static void putPointer(ByteBuffer bb, int offset, ByteBuffer buf) {
        if (buf == null) {
            bb.putInt(offset, 0);
        } else {
            bb.putInt(offset, (int)NIVision.getByteBufferAddress(buf));
        }
    }

    private static void putPointer(ByteBuffer bb, int offset, DisposedStruct struct) {
        if (struct == null) {
            bb.putInt(offset, 0);
        } else {
            bb.putInt(offset, (int)struct.getAddress());
        }
    }

    private static void putPointer(ByteBuffer bb, int offset, OpaqueStruct struct) {
        if (struct == null) {
            bb.putInt(offset, 0);
        } else {
            bb.putInt(offset, (int)struct.getAddress());
        }
    }

    public static void imaqAnd(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqAnd(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqAnd(long var0, long var2, long var4);

    public static void imaqCompare(Image dest, Image source, Image compareImage, ComparisonFunction compare) {
        NIVision._imaqCompare(dest.getAddress(), source.getAddress(), compareImage.getAddress(), compare.getValue());
    }

    private static native void _imaqCompare(long var0, long var2, long var4, int var6);

    public static void imaqLogicalDifference(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqLogicalDifference(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqLogicalDifference(long var0, long var2, long var4);

    public static void imaqNand(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqNand(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqNand(long var0, long var2, long var4);

    public static void imaqNor(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqNor(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqNor(long var0, long var2, long var4);

    public static void imaqOr(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqOr(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqOr(long var0, long var2, long var4);

    public static void imaqXnor(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqXnor(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqXnor(long var0, long var2, long var4);

    public static void imaqXor(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqXor(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqXor(long var0, long var2, long var4);

    public static int imaqCountParticles(Image image, int connectivity8) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqCountParticles(image.getAddress(), connectivity8, rv_addr + 0L);
        int numParticles = rv_buf.getInt(0);
        return numParticles;
    }

    private static native void _imaqCountParticles(long var0, int var2, long var3);

    public static double imaqMeasureParticle(Image image, int particleNumber, int calibrated, MeasurementType measurement) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqMeasureParticle(image.getAddress(), particleNumber, calibrated, measurement.getValue(), rv_addr + 0L);
        double value = rv_buf.getDouble(0);
        return value;
    }

    private static native void _imaqMeasureParticle(long var0, int var2, int var3, int var4, long var5);

    public static MeasureParticlesReport imaqMeasureParticles(Image image, MeasureParticlesCalibrationMode calibrationMode, MeasurementType[] measurements) {
        int numMeasurements = measurements.length;
        ByteBuffer measurements_buf = null;
        measurements_buf = ByteBuffer.allocateDirect(measurements.length * 4).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < measurements.length) {
            if (measurements != null) {
                measurements_buf.putInt(off, measurements[i].getValue());
            }
            ++i;
            off += 4;
        }
        long jn_rv = NIVision._imaqMeasureParticles(image.getAddress(), calibrationMode.getValue(), NIVision.getByteBufferAddress(measurements_buf), numMeasurements);
        return new MeasureParticlesReport(jn_rv, true);
    }

    private static native long _imaqMeasureParticles(long var0, int var2, long var3, int var5);

    public static int imaqParticleFilter4(Image dest, Image source, ParticleFilterCriteria2[] criteria, ParticleFilterOptions2 options, ROI roi) {
        int criteriaCount = criteria.length;
        ByteBuffer criteria_buf = null;
        criteria_buf = ByteBuffer.allocateDirect(criteria.length * 20).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < criteria.length) {
            criteria[i].setBuffer(criteria_buf, off);
            criteria[i].write();
            ++i;
            off += 20;
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqParticleFilter4(dest.getAddress(), source.getAddress(), NIVision.getByteBufferAddress(criteria_buf), criteriaCount, options.getAddress(), roi == null ? 0L : roi.getAddress(), rv_addr + 0L);
        int numParticles = rv_buf.getInt(0);
        return numParticles;
    }

    private static native void _imaqParticleFilter4(long var0, long var2, long var4, int var6, long var7, long var9, long var11);

    public static void imaqConvexHull(Image dest, Image source, int connectivity8) {
        NIVision._imaqConvexHull(dest.getAddress(), source.getAddress(), connectivity8);
    }

    private static native void _imaqConvexHull(long var0, long var2, int var4);

    public static void imaqDanielssonDistance(Image dest, Image source) {
        NIVision._imaqDanielssonDistance(dest.getAddress(), source.getAddress());
    }

    private static native void _imaqDanielssonDistance(long var0, long var2);

    public static void imaqFillHoles(Image dest, Image source, int connectivity8) {
        NIVision._imaqFillHoles(dest.getAddress(), source.getAddress(), connectivity8);
    }

    private static native void _imaqFillHoles(long var0, long var2, int var4);

    public static FindCirclesResult imaqFindCircles(Image dest, Image source, float minRadius, float maxRadius) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqFindCircles(dest.getAddress(), source.getAddress(), minRadius, maxRadius, rv_addr + 0L);
        FindCirclesResult rv = new FindCirclesResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqFindCircles(long var0, long var2, float var4, float var5, long var6);

    public static int imaqLabel2(Image dest, Image source, int connectivity8) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqLabel2(dest.getAddress(), source.getAddress(), connectivity8, rv_addr + 0L);
        int particleCount = rv_buf.getInt(0);
        return particleCount;
    }

    private static native void _imaqLabel2(long var0, long var2, int var4, long var5);

    public static void imaqMorphology(Image dest, Image source, MorphologyMethod method, StructuringElement structuringElement) {
        NIVision._imaqMorphology(dest.getAddress(), source.getAddress(), method.getValue(), structuringElement == null ? 0L : structuringElement.getAddress());
    }

    private static native void _imaqMorphology(long var0, long var2, int var4, long var5);

    public static void imaqRejectBorder(Image dest, Image source, int connectivity8) {
        NIVision._imaqRejectBorder(dest.getAddress(), source.getAddress(), connectivity8);
    }

    private static native void _imaqRejectBorder(long var0, long var2, int var4);

    public static void imaqSegmentation(Image dest, Image source) {
        NIVision._imaqSegmentation(dest.getAddress(), source.getAddress());
    }

    private static native void _imaqSegmentation(long var0, long var2);

    public static void imaqSeparation(Image dest, Image source, int erosions, StructuringElement structuringElement) {
        NIVision._imaqSeparation(dest.getAddress(), source.getAddress(), erosions, structuringElement == null ? 0L : structuringElement.getAddress());
    }

    private static native void _imaqSeparation(long var0, long var2, int var4, long var5);

    public static void imaqSimpleDistance(Image dest, Image source, StructuringElement structuringElement) {
        NIVision._imaqSimpleDistance(dest.getAddress(), source.getAddress(), structuringElement == null ? 0L : structuringElement.getAddress());
    }

    private static native void _imaqSimpleDistance(long var0, long var2, long var4);

    public static void imaqSizeFilter(Image dest, Image source, int connectivity8, int erosions, SizeType keepSize, StructuringElement structuringElement) {
        NIVision._imaqSizeFilter(dest.getAddress(), source.getAddress(), connectivity8, erosions, keepSize.getValue(), structuringElement == null ? 0L : structuringElement.getAddress());
    }

    private static native void _imaqSizeFilter(long var0, long var2, int var4, int var5, int var6, long var7);

    public static void imaqSkeleton(Image dest, Image source, SkeletonMethod method) {
        NIVision._imaqSkeleton(dest.getAddress(), source.getAddress(), method.getValue());
    }

    private static native void _imaqSkeleton(long var0, long var2, int var4);

    public static void imaqAbsoluteDifference(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqAbsoluteDifference(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqAbsoluteDifference(long var0, long var2, long var4);

    public static void imaqAdd(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqAdd(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqAdd(long var0, long var2, long var4);

    public static void imaqAverage(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqAverage(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqAverage(long var0, long var2, long var4);

    public static void imaqDivide2(Image dest, Image sourceA, Image sourceB, RoundingMode roundingMode) {
        NIVision._imaqDivide2(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress(), roundingMode.getValue());
    }

    private static native void _imaqDivide2(long var0, long var2, long var4, int var6);

    public static void imaqMax(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqMax(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqMax(long var0, long var2, long var4);

    public static void imaqMin(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqMin(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqMin(long var0, long var2, long var4);

    public static void imaqModulo(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqModulo(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqModulo(long var0, long var2, long var4);

    public static void imaqMulDiv(Image dest, Image sourceA, Image sourceB, float value) {
        NIVision._imaqMulDiv(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress(), value);
    }

    private static native void _imaqMulDiv(long var0, long var2, long var4, float var6);

    public static void imaqMultiply(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqMultiply(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqMultiply(long var0, long var2, long var4);

    public static void imaqSubtract(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqSubtract(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqSubtract(long var0, long var2, long var4);

    public static CaliperToolResult imaqCaliperTool(Image image, Point[] points, EdgeOptions edgeOptions, CaliperOptions caliperOptions) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqCaliperTool(image.getAddress(), NIVision.getByteBufferAddress(points_buf), numPoints, edgeOptions.getAddress(), caliperOptions.getAddress(), rv_addr + 0L);
        CaliperToolResult rv = new CaliperToolResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqCaliperTool(long var0, long var2, int var4, long var5, long var7, long var9);

    public static ConcentricRake2Result imaqConcentricRake2(Image image, ROI roi, ConcentricRakeDirection direction, EdgeProcess process, int stepSize) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqConcentricRake2(image.getAddress(), roi.getAddress(), direction.getValue(), process.getValue(), stepSize, rv_addr + 0L);
        ConcentricRake2Result rv = new ConcentricRake2Result(rv_buf);
        rv.val = new ConcentricRakeReport2(jn_rv, true);
        return rv;
    }

    private static native long _imaqConcentricRake2(long var0, long var2, int var4, int var5, int var6, long var7);

    public static DetectExtremesResult imaqDetectExtremes(double[] pixels, DetectionMode mode, DetectExtremesOptions options) {
        int numPixels = pixels.length;
        ByteBuffer pixels_buf = null;
        pixels_buf = ByteBuffer.allocateDirect(pixels.length * 8).order(ByteOrder.nativeOrder());
        pixels_buf.asDoubleBuffer().put(pixels).rewind();
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqDetectExtremes(NIVision.getByteBufferAddress(pixels_buf), numPixels, mode.getValue(), options.getAddress(), rv_addr + 0L);
        DetectExtremesResult rv = new DetectExtremesResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqDetectExtremes(long var0, int var2, int var3, long var4, long var6);

    public static double imaqDetectRotation(Image referenceImage, Image testImage, PointFloat referenceCenter, PointFloat testCenter, int radius, float precision) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqDetectRotation(referenceImage.getAddress(), testImage.getAddress(), referenceCenter.getAddress(), testCenter.getAddress(), radius, precision, rv_addr + 0L);
        double angle = rv_buf.getDouble(0);
        return angle;
    }

    private static native void _imaqDetectRotation(long var0, long var2, long var4, long var6, int var8, float var9, long var10);

    public static EdgeTool4Result imaqEdgeTool4(Image image, ROI roi, EdgeProcess processType, int reverseDirection) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqEdgeTool4(image.getAddress(), roi.getAddress(), processType.getValue(), rv_addr + 0L, reverseDirection);
        EdgeTool4Result rv = new EdgeTool4Result(rv_buf);
        rv.val = new EdgeReport2(jn_rv, true);
        return rv;
    }

    private static native long _imaqEdgeTool4(long var0, long var2, int var4, long var5, int var7);

    public static FindEdgeReport imaqFindEdge2(Image image, ROI roi, CoordinateSystem baseSystem, CoordinateSystem newSystem, FindEdgeOptions2 findEdgeOptions, StraightEdgeOptions straightEdgeOptions) {
        long jn_rv = NIVision._imaqFindEdge2(image.getAddress(), roi.getAddress(), baseSystem.getAddress(), newSystem.getAddress(), findEdgeOptions.getAddress(), straightEdgeOptions.getAddress());
        return new FindEdgeReport(jn_rv, true);
    }

    private static native long _imaqFindEdge2(long var0, long var2, long var4, long var6, long var8, long var10);

    public static FindTransformRect2Result imaqFindTransformRect2(Image image, ROI roi, FindTransformMode mode, FindTransformRectOptions2 findTransformOptions, StraightEdgeOptions straightEdgeOptions) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(24).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqFindTransformRect2(image.getAddress(), roi.getAddress(), mode.getValue(), rv_addr + 0L, rv_addr + 8L, findTransformOptions.getAddress(), straightEdgeOptions.getAddress(), rv_addr + 16L);
        FindTransformRect2Result rv = new FindTransformRect2Result(rv_buf);
        return rv;
    }

    private static native void _imaqFindTransformRect2(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13);

    public static FindTransformRects2Result imaqFindTransformRects2(Image image, ROI primaryROI, ROI secondaryROI, FindTransformMode mode, FindTransformRectsOptions2 findTransformOptions, StraightEdgeOptions primaryStraightEdgeOptions, StraightEdgeOptions secondaryStraightEdgeOptions) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(24).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqFindTransformRects2(image.getAddress(), primaryROI.getAddress(), secondaryROI.getAddress(), mode.getValue(), rv_addr + 0L, rv_addr + 8L, findTransformOptions.getAddress(), primaryStraightEdgeOptions.getAddress(), secondaryStraightEdgeOptions.getAddress(), rv_addr + 16L);
        FindTransformRects2Result rv = new FindTransformRects2Result(rv_buf);
        return rv;
    }

    private static native void _imaqFindTransformRects2(long var0, long var2, long var4, int var6, long var7, long var9, long var11, long var13, long var15, long var17);

    public static float imaqLineGaugeTool2(Image image, Point start, Point end, LineGaugeMethod method, EdgeOptions edgeOptions, CoordinateTransform2 transform) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqLineGaugeTool2(image.getAddress(), start.getAddress(), end.getAddress(), method.getValue(), edgeOptions.getAddress(), transform.getAddress(), rv_addr + 0L);
        float distance = rv_buf.getFloat(0);
        return distance;
    }

    private static native void _imaqLineGaugeTool2(long var0, long var2, long var4, int var6, long var7, long var9, long var11);

    public static Rake2Result imaqRake2(Image image, ROI roi, RakeDirection direction, EdgeProcess process, int stepSize) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqRake2(image.getAddress(), roi.getAddress(), direction.getValue(), process.getValue(), stepSize, rv_addr + 0L);
        Rake2Result rv = new Rake2Result(rv_buf);
        rv.val = new RakeReport2(jn_rv, true);
        return rv;
    }

    private static native long _imaqRake2(long var0, long var2, int var4, int var5, int var6, long var7);

    public static SimpleEdgeResult imaqSimpleEdge(Image image, Point[] points, SimpleEdgeOptions options) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqSimpleEdge(image.getAddress(), NIVision.getByteBufferAddress(points_buf), numPoints, options.getAddress(), rv_addr + 0L);
        SimpleEdgeResult rv = new SimpleEdgeResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqSimpleEdge(long var0, long var2, int var4, long var5, long var7);

    public static Spoke2Result imaqSpoke2(Image image, ROI roi, SpokeDirection direction, EdgeProcess process, int stepSize) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqSpoke2(image.getAddress(), roi.getAddress(), direction.getValue(), process.getValue(), stepSize, rv_addr + 0L);
        Spoke2Result rv = new Spoke2Result(rv_buf);
        rv.val = new SpokeReport2(jn_rv, true);
        return rv;
    }

    private static native long _imaqSpoke2(long var0, long var2, int var4, int var5, int var6, long var7);

    public static StraightEdgeReport2 imaqStraightEdge(Image image, ROI roi, SearchDirection searchDirection, EdgeOptions2 edgeOptions, StraightEdgeOptions straightEdgeOptions) {
        long jn_rv = NIVision._imaqStraightEdge(image.getAddress(), roi.getAddress(), searchDirection.getValue(), edgeOptions.getAddress(), straightEdgeOptions.getAddress());
        return new StraightEdgeReport2(jn_rv, true);
    }

    private static native long _imaqStraightEdge(long var0, long var2, int var4, long var5, long var7);

    public static StraightEdgeReport2 imaqStraightEdge2(Image image, ROI roi, SearchDirection searchDirection, EdgeOptions2 edgeOptions, StraightEdgeOptions straightEdgeOptions, int optimizedMode) {
        long jn_rv = NIVision._imaqStraightEdge2(image.getAddress(), roi.getAddress(), searchDirection.getValue(), edgeOptions.getAddress(), straightEdgeOptions.getAddress(), optimizedMode);
        return new StraightEdgeReport2(jn_rv, true);
    }

    private static native long _imaqStraightEdge2(long var0, long var2, int var4, long var5, long var7, int var9);

    public static void imaqCannyEdgeFilter(Image dest, Image source, CannyOptions options) {
        NIVision._imaqCannyEdgeFilter(dest.getAddress(), source.getAddress(), options == null ? 0L : options.getAddress());
    }

    private static native void _imaqCannyEdgeFilter(long var0, long var2, long var4);

    public static void imaqCorrelate(Image dest, Image source, Image templateImage, Rect rect) {
        NIVision._imaqCorrelate(dest.getAddress(), source.getAddress(), templateImage.getAddress(), rect.getAddress());
    }

    private static native void _imaqCorrelate(long var0, long var2, long var4, long var6);

    public static void imaqEdgeFilter(Image dest, Image source, OutlineMethod method, Image mask) {
        NIVision._imaqEdgeFilter(dest.getAddress(), source.getAddress(), method.getValue(), mask == null ? 0L : mask.getAddress());
    }

    private static native void _imaqEdgeFilter(long var0, long var2, int var4, long var5);

    public static void imaqLowPass(Image dest, Image source, int width, int height, float tolerance, Image mask) {
        NIVision._imaqLowPass(dest.getAddress(), source.getAddress(), width, height, tolerance, mask == null ? 0L : mask.getAddress());
    }

    private static native void _imaqLowPass(long var0, long var2, int var4, int var5, float var6, long var7);

    public static void imaqMedianFilter(Image dest, Image source, int width, int height, Image mask) {
        NIVision._imaqMedianFilter(dest.getAddress(), source.getAddress(), width, height, mask == null ? 0L : mask.getAddress());
    }

    private static native void _imaqMedianFilter(long var0, long var2, int var4, int var5, long var6);

    public static void imaqNthOrderFilter(Image dest, Image source, int width, int height, int n, Image mask) {
        NIVision._imaqNthOrderFilter(dest.getAddress(), source.getAddress(), width, height, n, mask == null ? 0L : mask.getAddress());
    }

    private static native void _imaqNthOrderFilter(long var0, long var2, int var4, int var5, int var6, long var7);

    public static void imaqDrawLineOnImage(Image dest, Image source, DrawMode mode, Point start, Point end, float newPixelValue) {
        NIVision._imaqDrawLineOnImage(dest.getAddress(), source.getAddress(), mode.getValue(), start.getAddress(), end.getAddress(), newPixelValue);
    }

    private static native void _imaqDrawLineOnImage(long var0, long var2, int var4, long var5, long var7, float var9);

    public static void imaqDrawShapeOnImage(Image dest, Image source, Rect rect, DrawMode mode, ShapeMode shape, float newPixelValue) {
        NIVision._imaqDrawShapeOnImage(dest.getAddress(), source.getAddress(), rect.getAddress(), mode.getValue(), shape.getValue(), newPixelValue);
    }

    private static native void _imaqDrawShapeOnImage(long var0, long var2, long var4, int var6, int var7, float var8);

    public static void imaqInterlaceCombine(Image frame, Image odd, Image even) {
        NIVision._imaqInterlaceCombine(frame.getAddress(), odd.getAddress(), even.getAddress());
    }

    private static native void _imaqInterlaceCombine(long var0, long var2, long var4);

    public static void imaqInterlaceSeparate(Image frame, Image odd, Image even) {
        NIVision._imaqInterlaceSeparate(frame.getAddress(), odd == null ? 0L : odd.getAddress(), even == null ? 0L : even.getAddress());
    }

    private static native void _imaqInterlaceSeparate(long var0, long var2, long var4);

    public static EnumerateCustomKeysResult imaqEnumerateCustomKeys(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqEnumerateCustomKeys(image.getAddress(), rv_addr + 0L);
        EnumerateCustomKeysResult rv = new EnumerateCustomKeysResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqEnumerateCustomKeys(long var0, long var2);

    public static int imaqGetBitDepth(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetBitDepth(image.getAddress(), rv_addr + 0L);
        int bitDepth = rv_buf.getInt(0);
        return bitDepth;
    }

    private static native void _imaqGetBitDepth(long var0, long var2);

    public static int imaqGetBytesPerPixel(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetBytesPerPixel(image.getAddress(), rv_addr + 0L);
        int byteCount = rv_buf.getInt(0);
        return byteCount;
    }

    private static native void _imaqGetBytesPerPixel(long var0, long var2);

    public static ImageInfo imaqGetImageInfo(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetImageInfo(image.getAddress(), rv_addr + 0L);
        ImageInfo info = new ImageInfo(rv_buf, 0);
        info.read();
        return info;
    }

    private static native void _imaqGetImageInfo(long var0, long var2);

    public static GetImageSizeResult imaqGetImageSize(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetImageSize(image.getAddress(), rv_addr + 0L, rv_addr + 8L);
        GetImageSizeResult rv = new GetImageSizeResult(rv_buf);
        return rv;
    }

    private static native void _imaqGetImageSize(long var0, long var2, long var4);

    public static ImageType imaqGetImageType(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetImageType(image.getAddress(), rv_addr + 0L);
        ImageType type = ImageType.fromValue(rv_buf.getInt(0));
        return type;
    }

    private static native void _imaqGetImageType(long var0, long var2);

    public static Point imaqGetMaskOffset(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetMaskOffset(image.getAddress(), rv_addr + 0L);
        Point offset = new Point(rv_buf, 0);
        offset.read();
        return offset;
    }

    private static native void _imaqGetMaskOffset(long var0, long var2);

    public static int imaqGetVisionInfoTypes(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetVisionInfoTypes(image.getAddress(), rv_addr + 0L);
        int present = rv_buf.getInt(0);
        return present;
    }

    private static native void _imaqGetVisionInfoTypes(long var0, long var2);

    public static int imaqIsImageEmpty(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqIsImageEmpty(image.getAddress(), rv_addr + 0L);
        int empty = rv_buf.getInt(0);
        return empty;
    }

    private static native void _imaqIsImageEmpty(long var0, long var2);

    public static RawData imaqReadCustomData(Image image, String key) {
        ByteBuffer key_buf = null;
        if (key != null) {
            byte[] key_bytes;
            try {
                key_bytes = key.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                key_bytes = new byte[]{};
            }
            key_buf = ByteBuffer.allocateDirect(key_bytes.length + 1);
            NIVision.putBytes(key_buf, key_bytes, 0, key_bytes.length).put(key_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqReadCustomData(image.getAddress(), key == null ? 0L : NIVision.getByteBufferAddress(key_buf), rv_addr + 0L);
        int size = rv_buf.getInt(0);
        RawData val = new RawData(jn_rv, false, size);
        return val;
    }

    private static native long _imaqReadCustomData(long var0, long var2, long var4);

    public static void imaqRemoveCustomData(Image image, String key) {
        ByteBuffer key_buf = null;
        if (key != null) {
            byte[] key_bytes;
            try {
                key_bytes = key.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                key_bytes = new byte[]{};
            }
            key_buf = ByteBuffer.allocateDirect(key_bytes.length + 1);
            NIVision.putBytes(key_buf, key_bytes, 0, key_bytes.length).put(key_bytes.length, (byte)0);
        }
        NIVision._imaqRemoveCustomData(image.getAddress(), key == null ? 0L : NIVision.getByteBufferAddress(key_buf));
    }

    private static native void _imaqRemoveCustomData(long var0, long var2);

    public static void imaqRemoveVisionInfo2(Image image, int info) {
        NIVision._imaqRemoveVisionInfo2(image.getAddress(), info);
    }

    private static native void _imaqRemoveVisionInfo2(long var0, int var2);

    public static void imaqSetBitDepth(Image image, int bitDepth) {
        NIVision._imaqSetBitDepth(image.getAddress(), bitDepth);
    }

    private static native void _imaqSetBitDepth(long var0, int var2);

    public static void imaqSetImageSize(Image image, int width, int height) {
        NIVision._imaqSetImageSize(image.getAddress(), width, height);
    }

    private static native void _imaqSetImageSize(long var0, int var2, int var3);

    public static void imaqSetMaskOffset(Image image, Point offset) {
        NIVision._imaqSetMaskOffset(image.getAddress(), offset.getAddress());
    }

    private static native void _imaqSetMaskOffset(long var0, long var2);

    public static void imaqWriteCustomData(Image image, String key, RawData data, int size) {
        ByteBuffer key_buf = null;
        if (key != null) {
            byte[] key_bytes;
            try {
                key_bytes = key.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                key_bytes = new byte[]{};
            }
            key_buf = ByteBuffer.allocateDirect(key_bytes.length + 1);
            NIVision.putBytes(key_buf, key_bytes, 0, key_bytes.length).put(key_bytes.length, (byte)0);
        }
        NIVision._imaqWriteCustomData(image.getAddress(), key == null ? 0L : NIVision.getByteBufferAddress(key_buf), data.getAddress(), size);
    }

    private static native void _imaqWriteCustomData(long var0, long var2, long var4, int var6);

    public static void imaqCopyRect(Image dest, Image source, Rect rect, Point destLoc) {
        NIVision._imaqCopyRect(dest.getAddress(), source.getAddress(), rect.getAddress(), destLoc.getAddress());
    }

    private static native void _imaqCopyRect(long var0, long var2, long var4, long var6);

    public static void imaqDuplicate(Image dest, Image source) {
        NIVision._imaqDuplicate(dest.getAddress(), source.getAddress());
    }

    private static native void _imaqDuplicate(long var0, long var2);

    public static RawData imaqFlatten(Image image, FlattenType type, CompressionType compression, int quality) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqFlatten(image.getAddress(), type.getValue(), compression.getValue(), quality, rv_addr + 0L);
        int size = rv_buf.getInt(0);
        RawData val = new RawData(jn_rv, true, size);
        return val;
    }

    private static native long _imaqFlatten(long var0, int var2, int var3, int var4, long var5);

    public static void imaqFlip(Image dest, Image source, FlipAxis axis) {
        NIVision._imaqFlip(dest.getAddress(), source.getAddress(), axis.getValue());
    }

    private static native void _imaqFlip(long var0, long var2, int var4);

    public static void imaqMask(Image dest, Image source, Image mask) {
        NIVision._imaqMask(dest.getAddress(), source.getAddress(), mask.getAddress());
    }

    private static native void _imaqMask(long var0, long var2, long var4);

    public static void imaqResample(Image dest, Image source, int newWidth, int newHeight, InterpolationMethod method, Rect rect) {
        NIVision._imaqResample(dest.getAddress(), source.getAddress(), newWidth, newHeight, method.getValue(), rect.getAddress());
    }

    private static native void _imaqResample(long var0, long var2, int var4, int var5, int var6, long var7);

    public static void imaqScale(Image dest, Image source, int xScale, int yScale, ScalingMode scaleMode, Rect rect) {
        NIVision._imaqScale(dest.getAddress(), source.getAddress(), xScale, yScale, scaleMode.getValue(), rect.getAddress());
    }

    private static native void _imaqScale(long var0, long var2, int var4, int var5, int var6, long var7);

    public static void imaqTranspose(Image dest, Image source) {
        NIVision._imaqTranspose(dest.getAddress(), source.getAddress());
    }

    private static native void _imaqTranspose(long var0, long var2);

    public static void imaqUnflatten(Image image, RawData data, int size) {
        NIVision._imaqUnflatten(image.getAddress(), data.getAddress(), size);
    }

    private static native void _imaqUnflatten(long var0, long var2, int var4);

    public static void imaqUnwrapImage(Image dest, Image source, Annulus annulus, RectOrientation orientation, InterpolationMethod method) {
        NIVision._imaqUnwrapImage(dest.getAddress(), source.getAddress(), annulus.getAddress(), orientation.getValue(), method.getValue());
    }

    private static native void _imaqUnwrapImage(long var0, long var2, long var4, int var6, int var7);

    public static void imaqView3D(Image dest, Image source, View3DOptions options) {
        NIVision._imaqView3D(dest.getAddress(), source.getAddress(), options.getAddress());
    }

    private static native void _imaqView3D(long var0, long var2, long var4);

    public static GetFileInfoResult imaqGetFileInfo(String fileName) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(48).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetFileInfo(fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), rv_addr + 0L, rv_addr + 8L, rv_addr + 16L, rv_addr + 24L, rv_addr + 32L, rv_addr + 40L);
        GetFileInfoResult rv = new GetFileInfoResult(rv_buf);
        return rv;
    }

    private static native void _imaqGetFileInfo(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static void imaqReadFile(Image image, String fileName) {
        byte[] fileName_bytes;
        try {
            fileName_bytes = fileName.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            fileName_bytes = new byte[]{};
        }
        ByteBuffer fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
        NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        NIVision._imaqReadFile(image.getAddress(), NIVision.getByteBufferAddress(fileName_buf), 0L, 0L);
    }

    private static native void _imaqReadFile(long var0, long var2, long var4, long var6);

    public static ReadVisionFileResult imaqReadVisionFile(Image image, String fileName) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqReadVisionFile(image.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), rv_addr + 0L, rv_addr + 8L);
        ReadVisionFileResult rv = new ReadVisionFileResult(rv_buf);
        return rv;
    }

    private static native void _imaqReadVisionFile(long var0, long var2, long var4, long var6);

    public static void imaqWriteBMPFile(Image image, String fileName, int compress, RGBValue colorTable) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        NIVision._imaqWriteBMPFile(image.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), compress, colorTable == null ? 0L : colorTable.getAddress());
    }

    private static native void _imaqWriteBMPFile(long var0, long var2, int var4, long var5);

    public static void imaqWriteFile(Image image, String fileName, RGBValue colorTable) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        NIVision._imaqWriteFile(image.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), colorTable == null ? 0L : colorTable.getAddress());
    }

    private static native void _imaqWriteFile(long var0, long var2, long var4);

    public static void imaqWriteJPEGFile(Image image, String fileName, int quality, RawData colorTable) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        NIVision._imaqWriteJPEGFile(image.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), quality, colorTable == null ? 0L : colorTable.getAddress());
    }

    private static native void _imaqWriteJPEGFile(long var0, long var2, int var4, long var5);

    public static void imaqWritePNGFile2(Image image, String fileName, int compressionSpeed, RGBValue colorTable, int useBitDepth) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        NIVision._imaqWritePNGFile2(image.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), compressionSpeed, colorTable == null ? 0L : colorTable.getAddress(), useBitDepth);
    }

    private static native void _imaqWritePNGFile2(long var0, long var2, int var4, long var5, int var7);

    public static void imaqWriteTIFFFile(Image image, String fileName, TIFFFileOptions options, RGBValue colorTable) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        NIVision._imaqWriteTIFFFile(image.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), options == null ? 0L : options.getAddress(), colorTable == null ? 0L : colorTable.getAddress());
    }

    private static native void _imaqWriteTIFFFile(long var0, long var2, long var4, long var6);

    public static void imaqWriteVisionFile(Image image, String fileName, RGBValue colorTable) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        NIVision._imaqWriteVisionFile(image.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), colorTable.getAddress());
    }

    private static native void _imaqWriteVisionFile(long var0, long var2, long var4);

    public static CoordinateSystem imaqBuildCoordinateSystem(Point points, ReferenceMode mode, AxisOrientation orientation) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqBuildCoordinateSystem(points.getAddress(), mode.getValue(), orientation.getValue(), rv_addr + 0L);
        CoordinateSystem system = new CoordinateSystem(rv_buf, 0);
        system.read();
        return system;
    }

    private static native void _imaqBuildCoordinateSystem(long var0, int var2, int var3, long var4);

    public static BestCircle2 imaqFitCircle2(PointFloat[] points, FitCircleOptions options) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        long jn_rv = NIVision._imaqFitCircle2(NIVision.getByteBufferAddress(points_buf), numPoints, options.getAddress());
        return new BestCircle2(jn_rv, true);
    }

    private static native long _imaqFitCircle2(long var0, int var2, long var3);

    public static BestEllipse2 imaqFitEllipse2(PointFloat[] points, FitEllipseOptions options) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        long jn_rv = NIVision._imaqFitEllipse2(NIVision.getByteBufferAddress(points_buf), numPoints, options.getAddress());
        return new BestEllipse2(jn_rv, true);
    }

    private static native long _imaqFitEllipse2(long var0, int var2, long var3);

    public static BestLine imaqFitLine(PointFloat[] points, FitLineOptions options) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        long jn_rv = NIVision._imaqFitLine(NIVision.getByteBufferAddress(points_buf), numPoints, options.getAddress());
        return new BestLine(jn_rv, true);
    }

    private static native long _imaqFitLine(long var0, int var2, long var3);

    public static float imaqGetAngle(PointFloat start1, PointFloat end1, PointFloat start2, PointFloat end2) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetAngle(start1.getAddress(), end1.getAddress(), start2.getAddress(), end2.getAddress(), rv_addr + 0L);
        float angle = rv_buf.getFloat(0);
        return angle;
    }

    private static native void _imaqGetAngle(long var0, long var2, long var4, long var6, long var8);

    public static GetBisectingLineResult imaqGetBisectingLine(PointFloat start1, PointFloat end1, PointFloat start2, PointFloat end2) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetBisectingLine(start1.getAddress(), end1.getAddress(), start2.getAddress(), end2.getAddress(), rv_addr + 0L, rv_addr + 8L);
        GetBisectingLineResult rv = new GetBisectingLineResult(rv_buf);
        return rv;
    }

    private static native void _imaqGetBisectingLine(long var0, long var2, long var4, long var6, long var8, long var10);

    public static float imaqGetDistance(PointFloat point1, PointFloat point2) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetDistance(point1.getAddress(), point2.getAddress(), rv_addr + 0L);
        float distance = rv_buf.getFloat(0);
        return distance;
    }

    private static native void _imaqGetDistance(long var0, long var2, long var4);

    public static PointFloat imaqGetIntersection(PointFloat start1, PointFloat end1, PointFloat start2, PointFloat end2) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetIntersection(start1.getAddress(), end1.getAddress(), start2.getAddress(), end2.getAddress(), rv_addr + 0L);
        PointFloat intersection = new PointFloat(rv_buf, 0);
        intersection.read();
        return intersection;
    }

    private static native void _imaqGetIntersection(long var0, long var2, long var4, long var6, long var8);

    public static GetMidLineResult imaqGetMidLine(PointFloat refLineStart, PointFloat refLineEnd, PointFloat point) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetMidLine(refLineStart.getAddress(), refLineEnd.getAddress(), point.getAddress(), rv_addr + 0L, rv_addr + 8L);
        GetMidLineResult rv = new GetMidLineResult(rv_buf);
        return rv;
    }

    private static native void _imaqGetMidLine(long var0, long var2, long var4, long var6, long var8);

    public static GetPerpendicularLineResult imaqGetPerpendicularLine(PointFloat refLineStart, PointFloat refLineEnd, PointFloat point) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(24).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetPerpendicularLine(refLineStart.getAddress(), refLineEnd.getAddress(), point.getAddress(), rv_addr + 0L, rv_addr + 8L, rv_addr + 16L);
        GetPerpendicularLineResult rv = new GetPerpendicularLineResult(rv_buf);
        return rv;
    }

    private static native void _imaqGetPerpendicularLine(long var0, long var2, long var4, long var6, long var8, long var10);

    public static GetPointsOnContourResult imaqGetPointsOnContour(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqGetPointsOnContour(image.getAddress(), rv_addr + 0L);
        GetPointsOnContourResult rv = new GetPointsOnContourResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqGetPointsOnContour(long var0, long var2);

    public static GetPointsOnLineResult imaqGetPointsOnLine(Point start, Point end) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqGetPointsOnLine(start.getAddress(), end.getAddress(), rv_addr + 0L);
        GetPointsOnLineResult rv = new GetPointsOnLineResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqGetPointsOnLine(long var0, long var2, long var4);

    public static float imaqGetPolygonArea(PointFloat points, int numPoints) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetPolygonArea(points.getAddress(), numPoints, rv_addr + 0L);
        float area = rv_buf.getFloat(0);
        return area;
    }

    private static native void _imaqGetPolygonArea(long var0, int var2, long var3);

    public static InterpolatePointsResult imaqInterpolatePoints(Image image, Point[] points, InterpolationMethod method, int subpixel) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqInterpolatePoints(image.getAddress(), NIVision.getByteBufferAddress(points_buf), numPoints, method.getValue(), subpixel, rv_addr + 0L);
        InterpolatePointsResult rv = new InterpolatePointsResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqInterpolatePoints(long var0, long var2, int var4, int var5, int var6, long var7);

    public static void imaqFillBorder(Image image, BorderMethod method) {
        NIVision._imaqFillBorder(image.getAddress(), method.getValue());
    }

    private static native void _imaqFillBorder(long var0, int var2);

    public static int imaqGetBorderSize(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetBorderSize(image.getAddress(), rv_addr + 0L);
        int borderSize = rv_buf.getInt(0);
        return borderSize;
    }

    private static native void _imaqGetBorderSize(long var0, long var2);

    public static void imaqSetBorderSize(Image image, int size) {
        NIVision._imaqSetBorderSize(image.getAddress(), size);
    }

    private static native void _imaqSetBorderSize(long var0, int var2);

    public static void imaqArrayToImage(Image image, RawData array, int numCols, int numRows) {
        NIVision._imaqArrayToImage(image.getAddress(), array.getAddress(), numCols, numRows);
    }

    private static native void _imaqArrayToImage(long var0, long var2, int var4, int var5);

    public static Image imaqCreateImage(ImageType type, int borderSize) {
        long jn_rv = NIVision._imaqCreateImage(type.getValue(), borderSize);
        return new Image(jn_rv, true);
    }

    private static native long _imaqCreateImage(int var0, int var1);

    public static void imaqColorBCGTransform(Image dest, Image source, BCGOptions redOptions, BCGOptions greenOptions, BCGOptions blueOptions, Image mask) {
        NIVision._imaqColorBCGTransform(dest.getAddress(), source.getAddress(), redOptions == null ? 0L : redOptions.getAddress(), greenOptions == null ? 0L : greenOptions.getAddress(), blueOptions == null ? 0L : blueOptions.getAddress(), mask == null ? 0L : mask.getAddress());
    }

    private static native void _imaqColorBCGTransform(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void imaqColorEqualize(Image dest, Image source, int colorEqualization) {
        NIVision._imaqColorEqualize(dest.getAddress(), source.getAddress(), colorEqualization);
    }

    private static native void _imaqColorEqualize(long var0, long var2, int var4);

    public static ColorHistogramReport imaqColorHistogram2(Image image, int numClasses, ColorMode mode, CIEXYZValue whiteReference, Image mask) {
        long jn_rv = NIVision._imaqColorHistogram2(image.getAddress(), numClasses, mode.getValue(), whiteReference.getAddress(), mask == null ? 0L : mask.getAddress());
        return new ColorHistogramReport(jn_rv, true);
    }

    private static native long _imaqColorHistogram2(long var0, int var2, int var3, long var4, long var6);

    public static void imaqColorThreshold(Image dest, Image source, int replaceValue, ColorMode mode, Range plane1Range, Range plane2Range, Range plane3Range) {
        NIVision._imaqColorThreshold(dest.getAddress(), source.getAddress(), replaceValue, mode.getValue(), plane1Range == null ? 0L : plane1Range.getAddress(), plane2Range == null ? 0L : plane2Range.getAddress(), plane3Range == null ? 0L : plane3Range.getAddress());
    }

    private static native void _imaqColorThreshold(long var0, long var2, int var4, int var5, long var6, long var8, long var10);

    public static SupervisedColorSegmentationReport imaqSupervisedColorSegmentation(ClassifierSession session, Image labelImage, Image srcImage, ROI roi, ROILabel labelIn, int numLabelIn, int maxDistance, int minIdentificationScore, ColorSegmenationOptions segmentOptions) {
        long jn_rv = NIVision._imaqSupervisedColorSegmentation(session.getAddress(), labelImage.getAddress(), srcImage.getAddress(), roi.getAddress(), labelIn.getAddress(), numLabelIn, maxDistance, minIdentificationScore, segmentOptions.getAddress());
        return new SupervisedColorSegmentationReport(jn_rv, true);
    }

    private static native long _imaqSupervisedColorSegmentation(long var0, long var2, long var4, long var6, long var8, int var10, int var11, int var12, long var13);

    public static int imaqGetColorSegmentationMaxDistance(ClassifierSession session, ColorSegmenationOptions segmentOptions, SegmentationDistanceLevel distLevel) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetColorSegmentationMaxDistance(session.getAddress(), segmentOptions.getAddress(), distLevel.getValue(), rv_addr + 0L);
        int maxDistance = rv_buf.getInt(0);
        return maxDistance;
    }

    private static native void _imaqGetColorSegmentationMaxDistance(long var0, long var2, int var4, long var5);

    public static void imaqBCGTransform(Image dest, Image source, BCGOptions options, Image mask) {
        NIVision._imaqBCGTransform(dest.getAddress(), source.getAddress(), options.getAddress(), mask == null ? 0L : mask.getAddress());
    }

    private static native void _imaqBCGTransform(long var0, long var2, long var4, long var6);

    public static void imaqEqualize(Image dest, Image source, float min, float max, Image mask) {
        NIVision._imaqEqualize(dest.getAddress(), source.getAddress(), min, max, mask == null ? 0L : mask.getAddress());
    }

    private static native void _imaqEqualize(long var0, long var2, float var4, float var5, long var6);

    public static void imaqInverse(Image dest, Image source, Image mask) {
        NIVision._imaqInverse(dest.getAddress(), source.getAddress(), mask == null ? 0L : mask.getAddress());
    }

    private static native void _imaqInverse(long var0, long var2, long var4);

    public static void imaqMathTransform(Image dest, Image source, MathTransformMethod method, float rangeMin, float rangeMax, float power, Image mask) {
        NIVision._imaqMathTransform(dest.getAddress(), source.getAddress(), method.getValue(), rangeMin, rangeMax, power, mask == null ? 0L : mask.getAddress());
    }

    private static native void _imaqMathTransform(long var0, long var2, int var4, float var5, float var6, float var7, long var8);

    public static int imaqWatershedTransform(Image dest, Image source, int connectivity8) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqWatershedTransform(dest.getAddress(), source.getAddress(), connectivity8, rv_addr + 0L);
        int zoneCount = rv_buf.getInt(0);
        return zoneCount;
    }

    private static native void _imaqWatershedTransform(long var0, long var2, int var4, long var5);

    public static int imaqMulticoreOptions(MulticoreOperation operation) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqMulticoreOptions(operation.getValue(), rv_addr + 0L);
        int customNumCores = rv_buf.getInt(0);
        return customNumCores;
    }

    private static native void _imaqMulticoreOptions(int var0, long var1);

    public static MeterArc imaqGetMeterArc(int lightNeedle, MeterArcMode mode, ROI roi, PointFloat base, PointFloat start, PointFloat end) {
        long jn_rv = NIVision._imaqGetMeterArc(lightNeedle, mode.getValue(), roi.getAddress(), base.getAddress(), start.getAddress(), end.getAddress());
        return new MeterArc(jn_rv, true);
    }

    private static native long _imaqGetMeterArc(int var0, int var1, long var2, long var4, long var6, long var8);

    public static ReadMeterResult imaqReadMeter(Image image, MeterArc arcInfo) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqReadMeter(image.getAddress(), arcInfo.getAddress(), rv_addr + 0L, rv_addr + 8L);
        ReadMeterResult rv = new ReadMeterResult(rv_buf);
        return rv;
    }

    private static native void _imaqReadMeter(long var0, long var2, long var4, long var6);

    public static void imaqCopyCalibrationInfo2(Image dest, Image source, Point offset) {
        NIVision._imaqCopyCalibrationInfo2(dest.getAddress(), source.getAddress(), offset.getAddress());
    }

    private static native void _imaqCopyCalibrationInfo2(long var0, long var2, long var4);

    public static CalibrationInfo imaqGetCalibrationInfo2(Image image) {
        long jn_rv = NIVision._imaqGetCalibrationInfo2(image.getAddress());
        return new CalibrationInfo(jn_rv, true);
    }

    private static native long _imaqGetCalibrationInfo2(long var0);

    public static CalibrationInfo imaqGetCalibrationInfo3(Image image, int isGetErrorMap) {
        long jn_rv = NIVision._imaqGetCalibrationInfo3(image.getAddress(), isGetErrorMap);
        return new CalibrationInfo(jn_rv, true);
    }

    private static native long _imaqGetCalibrationInfo3(long var0, int var2);

    public static float imaqLearnCalibrationGrid(Image image, ROI roi, LearnCalibrationOptions options, GridDescriptor grid, CoordinateSystem system, RangeFloat range) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqLearnCalibrationGrid(image.getAddress(), roi.getAddress(), options.getAddress(), grid.getAddress(), system.getAddress(), range.getAddress(), rv_addr + 0L);
        float quality = rv_buf.getFloat(0);
        return quality;
    }

    private static native void _imaqLearnCalibrationGrid(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static float imaqLearnCalibrationPoints(Image image, CalibrationPoints points, ROI roi, LearnCalibrationOptions options, GridDescriptor grid, CoordinateSystem system) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqLearnCalibrationPoints(image.getAddress(), points.getAddress(), roi.getAddress(), options.getAddress(), grid.getAddress(), system.getAddress(), rv_addr + 0L);
        float quality = rv_buf.getFloat(0);
        return quality;
    }

    private static native void _imaqLearnCalibrationPoints(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static void imaqSetCoordinateSystem(Image image, CoordinateSystem system) {
        NIVision._imaqSetCoordinateSystem(image.getAddress(), system.getAddress());
    }

    private static native void _imaqSetCoordinateSystem(long var0, long var2);

    public static void imaqSetSimpleCalibration(Image image, ScalingMethod method, int learnTable, GridDescriptor grid, CoordinateSystem system) {
        NIVision._imaqSetSimpleCalibration(image.getAddress(), method.getValue(), learnTable, grid.getAddress(), system.getAddress());
    }

    private static native void _imaqSetSimpleCalibration(long var0, int var2, int var3, long var4, long var6);

    public static TransformReport imaqTransformPixelToRealWorld(Image image, PointFloat[] pixelCoordinates) {
        int numCoordinates = pixelCoordinates.length;
        ByteBuffer pixelCoordinates_buf = null;
        pixelCoordinates_buf = ByteBuffer.allocateDirect(pixelCoordinates.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < pixelCoordinates.length) {
            pixelCoordinates[i].setBuffer(pixelCoordinates_buf, off);
            pixelCoordinates[i].write();
            ++i;
            off += 8;
        }
        long jn_rv = NIVision._imaqTransformPixelToRealWorld(image.getAddress(), NIVision.getByteBufferAddress(pixelCoordinates_buf), numCoordinates);
        return new TransformReport(jn_rv, true);
    }

    private static native long _imaqTransformPixelToRealWorld(long var0, long var2, int var4);

    public static TransformReport imaqTransformRealWorldToPixel(Image image, PointFloat[] realWorldCoordinates) {
        int numCoordinates = realWorldCoordinates.length;
        ByteBuffer realWorldCoordinates_buf = null;
        realWorldCoordinates_buf = ByteBuffer.allocateDirect(realWorldCoordinates.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < realWorldCoordinates.length) {
            realWorldCoordinates[i].setBuffer(realWorldCoordinates_buf, off);
            realWorldCoordinates[i].write();
            ++i;
            off += 8;
        }
        long jn_rv = NIVision._imaqTransformRealWorldToPixel(image.getAddress(), NIVision.getByteBufferAddress(realWorldCoordinates_buf), numCoordinates);
        return new TransformReport(jn_rv, true);
    }

    private static native long _imaqTransformRealWorldToPixel(long var0, long var2, int var4);

    public static void imaqSetSimpleCalibration2(Image image, GridDescriptor gridDescriptor) {
        NIVision._imaqSetSimpleCalibration2(image.getAddress(), gridDescriptor.getAddress());
    }

    private static native void _imaqSetSimpleCalibration2(long var0, long var2);

    public static CoordinateSystem imaqCalibrationSetAxisInfo(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqCalibrationSetAxisInfo(image.getAddress(), rv_addr + 0L);
        CoordinateSystem axisInfo = new CoordinateSystem(rv_buf, 0);
        axisInfo.read();
        return axisInfo;
    }

    private static native void _imaqCalibrationSetAxisInfo(long var0, long var2);

    public static void imaqCalibrationGetThumbnailImage(Image templateImage, Image image, CalibrationThumbnailType type, int index) {
        NIVision._imaqCalibrationGetThumbnailImage(templateImage.getAddress(), image.getAddress(), type.getValue(), index);
    }

    private static native void _imaqCalibrationGetThumbnailImage(long var0, long var2, int var4, int var5);

    public static GetCalibrationInfoReport imaqCalibrationGetCalibrationInfo(Image image, int isGetErrorMap) {
        long jn_rv = NIVision._imaqCalibrationGetCalibrationInfo(image.getAddress(), isGetErrorMap);
        return new GetCalibrationInfoReport(jn_rv, true);
    }

    private static native long _imaqCalibrationGetCalibrationInfo(long var0, int var2);

    public static GetCameraParametersReport imaqCalibrationGetCameraParameters(Image templateImage) {
        long jn_rv = NIVision._imaqCalibrationGetCameraParameters(templateImage.getAddress());
        return new GetCameraParametersReport(jn_rv, true);
    }

    private static native long _imaqCalibrationGetCameraParameters(long var0);

    public static void imaqCalibrationCompactInformation(Image image) {
        NIVision._imaqCalibrationCompactInformation(image.getAddress());
    }

    private static native void _imaqCalibrationCompactInformation(long var0);

    public static void imaqExtractColorPlanes(Image image, ColorMode mode, Image plane1, Image plane2, Image plane3) {
        NIVision._imaqExtractColorPlanes(image.getAddress(), mode.getValue(), plane1 == null ? 0L : plane1.getAddress(), plane2 == null ? 0L : plane2.getAddress(), plane3 == null ? 0L : plane3.getAddress());
    }

    private static native void _imaqExtractColorPlanes(long var0, int var2, long var3, long var5, long var7);

    public static void imaqExtractComplexPlane(Image dest, Image source, ComplexPlane plane) {
        NIVision._imaqExtractComplexPlane(dest.getAddress(), source.getAddress(), plane.getValue());
    }

    private static native void _imaqExtractComplexPlane(long var0, long var2, int var4);

    public static void imaqReplaceColorPlanes(Image dest, Image source, ColorMode mode, Image plane1, Image plane2, Image plane3) {
        NIVision._imaqReplaceColorPlanes(dest.getAddress(), source.getAddress(), mode.getValue(), plane1 == null ? 0L : plane1.getAddress(), plane2 == null ? 0L : plane2.getAddress(), plane3 == null ? 0L : plane3.getAddress());
    }

    private static native void _imaqReplaceColorPlanes(long var0, long var2, int var4, long var5, long var7, long var9);

    public static void imaqReplaceComplexPlane(Image dest, Image source, Image newValues, ComplexPlane plane) {
        NIVision._imaqReplaceComplexPlane(dest.getAddress(), source.getAddress(), newValues.getAddress(), plane.getValue());
    }

    private static native void _imaqReplaceComplexPlane(long var0, long var2, long var4, int var6);

    public static ColorInformation imaqLearnColor(Image image, ROI roi, ColorSensitivity sensitivity, int saturation) {
        long jn_rv = NIVision._imaqLearnColor(image.getAddress(), roi == null ? 0L : roi.getAddress(), sensitivity.getValue(), saturation);
        return new ColorInformation(jn_rv, true);
    }

    private static native long _imaqLearnColor(long var0, long var2, int var4, int var5);

    public static MatchColorResult imaqMatchColor(Image image, ColorInformation info, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqMatchColor(image.getAddress(), info.getAddress(), roi == null ? 0L : roi.getAddress(), rv_addr + 0L);
        MatchColorResult rv = new MatchColorResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqMatchColor(long var0, long var2, long var4, long var6);

    public static void imaqAttenuate(Image dest, Image source, AttenuateMode highlow) {
        NIVision._imaqAttenuate(dest.getAddress(), source.getAddress(), highlow.getValue());
    }

    private static native void _imaqAttenuate(long var0, long var2, int var4);

    public static void imaqConjugate(Image dest, Image source) {
        NIVision._imaqConjugate(dest.getAddress(), source.getAddress());
    }

    private static native void _imaqConjugate(long var0, long var2);

    public static void imaqFFT(Image dest, Image source) {
        NIVision._imaqFFT(dest.getAddress(), source.getAddress());
    }

    private static native void _imaqFFT(long var0, long var2);

    public static void imaqFlipFrequencies(Image dest, Image source) {
        NIVision._imaqFlipFrequencies(dest.getAddress(), source.getAddress());
    }

    private static native void _imaqFlipFrequencies(long var0, long var2);

    public static void imaqInverseFFT(Image dest, Image source) {
        NIVision._imaqInverseFFT(dest.getAddress(), source.getAddress());
    }

    private static native void _imaqInverseFFT(long var0, long var2);

    public static void imaqTruncate(Image dest, Image source, TruncateMode highlow, float ratioToKeep) {
        NIVision._imaqTruncate(dest.getAddress(), source.getAddress(), highlow.getValue(), ratioToKeep);
    }

    private static native void _imaqTruncate(long var0, long var2, int var4, float var5);

    public static AIMGradeReport imaqGradeDataMatrixBarcodeAIM(Image image) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGradeDataMatrixBarcodeAIM(image.getAddress(), rv_addr + 0L);
        AIMGradeReport report = new AIMGradeReport(rv_buf, 0);
        report.read();
        return report;
    }

    private static native void _imaqGradeDataMatrixBarcodeAIM(long var0, long var2);

    public static BarcodeInfo imaqReadBarcode(Image image, BarcodeType type, ROI roi, int validate) {
        long jn_rv = NIVision._imaqReadBarcode(image.getAddress(), type.getValue(), roi == null ? 0L : roi.getAddress(), validate);
        return new BarcodeInfo(jn_rv, true);
    }

    private static native long _imaqReadBarcode(long var0, int var2, long var3, int var5);

    public static DataMatrixReport imaqReadDataMatrixBarcode2(Image image, ROI roi, DataMatrixGradingMode prepareForGrading, DataMatrixDescriptionOptions descriptionOptions, DataMatrixSizeOptions sizeOptions, DataMatrixSearchOptions searchOptions) {
        long jn_rv = NIVision._imaqReadDataMatrixBarcode2(image.getAddress(), roi.getAddress(), prepareForGrading.getValue(), descriptionOptions.getAddress(), sizeOptions.getAddress(), searchOptions.getAddress());
        return new DataMatrixReport(jn_rv, true);
    }

    private static native long _imaqReadDataMatrixBarcode2(long var0, long var2, int var4, long var5, long var7, long var9);

    public static ReadPDF417BarcodeResult imaqReadPDF417Barcode(Image image, ROI roi, Barcode2DSearchMode searchMode) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqReadPDF417Barcode(image.getAddress(), roi.getAddress(), searchMode.getValue(), rv_addr + 0L);
        ReadPDF417BarcodeResult rv = new ReadPDF417BarcodeResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqReadPDF417Barcode(long var0, long var2, int var4, long var5);

    public static QRCodeReport imaqReadQRCode(Image image, ROI roi, QRGradingMode reserved, QRCodeDescriptionOptions descriptionOptions, QRCodeSizeOptions sizeOptions, QRCodeSearchOptions searchOptions) {
        long jn_rv = NIVision._imaqReadQRCode(image.getAddress(), roi.getAddress(), reserved.getValue(), descriptionOptions.getAddress(), sizeOptions.getAddress(), searchOptions.getAddress());
        return new QRCodeReport(jn_rv, true);
    }

    private static native long _imaqReadQRCode(long var0, long var2, int var4, long var5, long var7, long var9);

    public static void imaqFindLCDSegments(ROI roi, Image image, LCDOptions options) {
        NIVision._imaqFindLCDSegments(roi.getAddress(), image.getAddress(), options == null ? 0L : options.getAddress());
    }

    private static native void _imaqFindLCDSegments(long var0, long var2, long var4);

    public static LCDReport imaqReadLCD(Image image, ROI roi, LCDOptions options) {
        long jn_rv = NIVision._imaqReadLCD(image.getAddress(), roi.getAddress(), options == null ? 0L : options.getAddress());
        return new LCDReport(jn_rv, true);
    }

    private static native long _imaqReadLCD(long var0, long var2, long var4);

    public static MatchShapeResult imaqMatchShape(Image dest, Image source, Image templateImage, int scaleInvariant, int connectivity8, double tolerance) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqMatchShape(dest.getAddress(), source.getAddress(), templateImage.getAddress(), scaleInvariant, connectivity8, tolerance, rv_addr + 0L);
        MatchShapeResult rv = new MatchShapeResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqMatchShape(long var0, long var2, long var4, int var6, int var7, double var8, long var10);

    public static int imaqAddAnnulusContour(ROI roi, Annulus annulus) {
        int jn_rv = NIVision._imaqAddAnnulusContour(roi.getAddress(), annulus.getAddress());
        return jn_rv;
    }

    private static native int _imaqAddAnnulusContour(long var0, long var2);

    public static int imaqAddClosedContour(ROI roi, Point[] points) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        int jn_rv = NIVision._imaqAddClosedContour(roi.getAddress(), NIVision.getByteBufferAddress(points_buf), numPoints);
        return jn_rv;
    }

    private static native int _imaqAddClosedContour(long var0, long var2, int var4);

    public static int imaqAddLineContour(ROI roi, Point start, Point end) {
        int jn_rv = NIVision._imaqAddLineContour(roi.getAddress(), start.getAddress(), end.getAddress());
        return jn_rv;
    }

    private static native int _imaqAddLineContour(long var0, long var2, long var4);

    public static int imaqAddOpenContour(ROI roi, Point[] points) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        int jn_rv = NIVision._imaqAddOpenContour(roi.getAddress(), NIVision.getByteBufferAddress(points_buf), numPoints);
        return jn_rv;
    }

    private static native int _imaqAddOpenContour(long var0, long var2, int var4);

    public static int imaqAddOvalContour(ROI roi, Rect boundingBox) {
        int jn_rv = NIVision._imaqAddOvalContour(roi.getAddress(), boundingBox.getAddress());
        return jn_rv;
    }

    private static native int _imaqAddOvalContour(long var0, long var2);

    public static int imaqAddPointContour(ROI roi, Point point) {
        int jn_rv = NIVision._imaqAddPointContour(roi.getAddress(), point.getAddress());
        return jn_rv;
    }

    private static native int _imaqAddPointContour(long var0, long var2);

    public static int imaqAddRectContour(ROI roi, Rect rect) {
        int jn_rv = NIVision._imaqAddRectContour(roi.getAddress(), rect.getAddress());
        return jn_rv;
    }

    private static native int _imaqAddRectContour(long var0, long var2);

    public static int imaqAddRotatedRectContour2(ROI roi, RotatedRect rect) {
        int jn_rv = NIVision._imaqAddRotatedRectContour2(roi.getAddress(), rect.getAddress());
        return jn_rv;
    }

    private static native int _imaqAddRotatedRectContour2(long var0, long var2);

    public static int imaqCopyContour(ROI destRoi, ROI sourceRoi, int id) {
        int jn_rv = NIVision._imaqCopyContour(destRoi.getAddress(), sourceRoi.getAddress(), id);
        return jn_rv;
    }

    private static native int _imaqCopyContour(long var0, long var2, int var4);

    public static int imaqGetContour(ROI roi, int index) {
        int jn_rv = NIVision._imaqGetContour(roi.getAddress(), index);
        return jn_rv;
    }

    private static native int _imaqGetContour(long var0, int var2);

    public static RGBValue imaqGetContourColor(ROI roi, int id) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetContourColor(roi.getAddress(), id, rv_addr + 0L);
        RGBValue contourColor = new RGBValue(rv_buf, 0);
        contourColor.read();
        return contourColor;
    }

    private static native void _imaqGetContourColor(long var0, int var2, long var3);

    public static void imaqGetContourCount(ROI roi) {
        NIVision._imaqGetContourCount(roi.getAddress());
    }

    private static native void _imaqGetContourCount(long var0);

    public static ContourInfo2 imaqGetContourInfo2(ROI roi, int id) {
        long jn_rv = NIVision._imaqGetContourInfo2(roi.getAddress(), id);
        return new ContourInfo2(jn_rv, true);
    }

    private static native long _imaqGetContourInfo2(long var0, int var2);

    public static void imaqMoveContour(ROI roi, int id, int deltaX, int deltaY) {
        NIVision._imaqMoveContour(roi.getAddress(), id, deltaX, deltaY);
    }

    private static native void _imaqMoveContour(long var0, int var2, int var3, int var4);

    public static void imaqRemoveContour(ROI roi, int id) {
        NIVision._imaqRemoveContour(roi.getAddress(), id);
    }

    private static native void _imaqRemoveContour(long var0, int var2);

    public static void imaqSetContourColor(ROI roi, int id, RGBValue color) {
        NIVision._imaqSetContourColor(roi.getAddress(), id, color.getAddress());
    }

    private static native void _imaqSetContourColor(long var0, int var2, long var3);

    public static ROI imaqCreateROI() {
        long jn_rv = NIVision._imaqCreateROI();
        return new ROI(jn_rv, true);
    }

    private static native long _imaqCreateROI();

    public static Rect imaqGetROIBoundingBox(ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetROIBoundingBox(roi.getAddress(), rv_addr + 0L);
        Rect boundingBox = new Rect(rv_buf, 0);
        boundingBox.read();
        return boundingBox;
    }

    private static native void _imaqGetROIBoundingBox(long var0, long var2);

    public static RGBValue imaqGetROIColor(ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetROIColor(roi.getAddress(), rv_addr + 0L);
        RGBValue roiColor = new RGBValue(rv_buf, 0);
        roiColor.read();
        return roiColor;
    }

    private static native void _imaqGetROIColor(long var0, long var2);

    public static void imaqSetROIColor(ROI roi, RGBValue color) {
        NIVision._imaqSetROIColor(roi.getAddress(), color.getAddress());
    }

    private static native void _imaqSetROIColor(long var0, long var2);

    public static PointFloat imaqCentroid(Image image, Image mask) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqCentroid(image.getAddress(), rv_addr + 0L, mask.getAddress());
        PointFloat centroid = new PointFloat(rv_buf, 0);
        centroid.read();
        return centroid;
    }

    private static native void _imaqCentroid(long var0, long var2, long var4);

    public static ExtractCurvesResult imaqExtractCurves(Image image, ROI roi, CurveOptions curveOptions) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqExtractCurves(image.getAddress(), roi.getAddress(), curveOptions.getAddress(), rv_addr + 0L);
        ExtractCurvesResult rv = new ExtractCurvesResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqExtractCurves(long var0, long var2, long var4, long var6);

    public static HistogramReport imaqHistogram(Image image, int numClasses, float min, float max, Image mask) {
        long jn_rv = NIVision._imaqHistogram(image.getAddress(), numClasses, min, max, mask == null ? 0L : mask.getAddress());
        return new HistogramReport(jn_rv, true);
    }

    private static native long _imaqHistogram(long var0, int var2, float var3, float var4, long var5);

    public static LinearAverages imaqLinearAverages2(Image image, LinearAveragesMode mode, Rect rect) {
        long jn_rv = NIVision._imaqLinearAverages2(image.getAddress(), mode.getValue(), rect.getAddress());
        return new LinearAverages(jn_rv, true);
    }

    private static native long _imaqLinearAverages2(long var0, int var2, long var3);

    public static LineProfile imaqLineProfile(Image image, Point start, Point end) {
        long jn_rv = NIVision._imaqLineProfile(image.getAddress(), start.getAddress(), end.getAddress());
        return new LineProfile(jn_rv, true);
    }

    private static native long _imaqLineProfile(long var0, long var2, long var4);

    public static QuantifyReport imaqQuantify(Image image, Image mask) {
        long jn_rv = NIVision._imaqQuantify(image.getAddress(), mask == null ? 0L : mask.getAddress());
        return new QuantifyReport(jn_rv, true);
    }

    private static native long _imaqQuantify(long var0, long var2);

    public static ThresholdData imaqAutoThreshold2(Image dest, Image source, int numClasses, ThresholdMethod method, Image mask) {
        long jn_rv = NIVision._imaqAutoThreshold2(dest.getAddress(), source.getAddress(), numClasses, method.getValue(), mask.getAddress());
        return new ThresholdData(jn_rv, true);
    }

    private static native long _imaqAutoThreshold2(long var0, long var2, int var4, int var5, long var6);

    public static void imaqLocalThreshold(Image dest, Image source, int windowWidth, int windowHeight, LocalThresholdMethod method, double deviationWeight, ObjectType type, float replaceValue) {
        NIVision._imaqLocalThreshold(dest.getAddress(), source.getAddress(), windowWidth, windowHeight, method.getValue(), deviationWeight, type.getValue(), replaceValue);
    }

    private static native void _imaqLocalThreshold(long var0, long var2, int var4, int var5, int var6, double var7, int var9, float var10);

    public static void imaqMagicWand(Image dest, Image source, Point coord, float tolerance, int connectivity8, float replaceValue) {
        NIVision._imaqMagicWand(dest.getAddress(), source.getAddress(), coord.getAddress(), tolerance, connectivity8, replaceValue);
    }

    private static native void _imaqMagicWand(long var0, long var2, long var4, float var6, int var7, float var8);

    public static void imaqMultithreshold(Image dest, Image source, ThresholdData[] ranges) {
        int numRanges = ranges.length;
        ByteBuffer ranges_buf = null;
        ranges_buf = ByteBuffer.allocateDirect(ranges.length * 16).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < ranges.length) {
            ranges[i].setBuffer(ranges_buf, off);
            ranges[i].write();
            ++i;
            off += 16;
        }
        NIVision._imaqMultithreshold(dest.getAddress(), source.getAddress(), NIVision.getByteBufferAddress(ranges_buf), numRanges);
    }

    private static native void _imaqMultithreshold(long var0, long var2, long var4, int var6);

    public static void imaqThreshold(Image dest, Image source, float rangeMin, float rangeMax, int useNewValue, float newValue) {
        NIVision._imaqThreshold(dest.getAddress(), source.getAddress(), rangeMin, rangeMax, useNewValue, newValue);
    }

    private static native void _imaqThreshold(long var0, long var2, float var4, float var5, int var6, float var7);

    public static DetectCirclesResult imaqDetectCircles(Image image, CircleDescriptor circleDescriptor, CurveOptions curveOptions, ShapeDetectionOptions shapeDetectionOptions, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqDetectCircles(image.getAddress(), circleDescriptor.getAddress(), curveOptions.getAddress(), shapeDetectionOptions.getAddress(), roi.getAddress(), rv_addr + 0L);
        DetectCirclesResult rv = new DetectCirclesResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqDetectCircles(long var0, long var2, long var4, long var6, long var8, long var10);

    public static DetectEllipsesResult imaqDetectEllipses(Image image, EllipseDescriptor ellipseDescriptor, CurveOptions curveOptions, ShapeDetectionOptions shapeDetectionOptions, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqDetectEllipses(image.getAddress(), ellipseDescriptor.getAddress(), curveOptions.getAddress(), shapeDetectionOptions.getAddress(), roi.getAddress(), rv_addr + 0L);
        DetectEllipsesResult rv = new DetectEllipsesResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqDetectEllipses(long var0, long var2, long var4, long var6, long var8, long var10);

    public static DetectLinesResult imaqDetectLines(Image image, LineDescriptor lineDescriptor, CurveOptions curveOptions, ShapeDetectionOptions shapeDetectionOptions, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqDetectLines(image.getAddress(), lineDescriptor.getAddress(), curveOptions.getAddress(), shapeDetectionOptions.getAddress(), roi.getAddress(), rv_addr + 0L);
        DetectLinesResult rv = new DetectLinesResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqDetectLines(long var0, long var2, long var4, long var6, long var8, long var10);

    public static DetectRectanglesResult imaqDetectRectangles(Image image, RectangleDescriptor rectangleDescriptor, CurveOptions curveOptions, ShapeDetectionOptions shapeDetectionOptions, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqDetectRectangles(image.getAddress(), rectangleDescriptor.getAddress(), curveOptions.getAddress(), shapeDetectionOptions.getAddress(), roi.getAddress(), rv_addr + 0L);
        DetectRectanglesResult rv = new DetectRectanglesResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqDetectRectangles(long var0, long var2, long var4, long var6, long var8, long var10);

    public static GetGeometricFeaturesFromCurvesResult imaqGetGeometricFeaturesFromCurves(Curve[] curves, FeatureType[] featureTypes) {
        int numCurves = curves.length;
        ByteBuffer curves_buf = null;
        curves_buf = ByteBuffer.allocateDirect(curves.length * 48).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < curves.length) {
            curves[i].setBuffer(curves_buf, off);
            curves[i].write();
            ++i;
            off += 48;
        }
        int numFeatureTypes = featureTypes.length;
        ByteBuffer featureTypes_buf = null;
        featureTypes_buf = ByteBuffer.allocateDirect(featureTypes.length * 4).order(ByteOrder.nativeOrder());
        int i2 = 0;
        int off2 = 0;
        while (i2 < featureTypes.length) {
            if (featureTypes != null) {
                featureTypes_buf.putInt(off2, featureTypes[i2].getValue());
            }
            ++i2;
            off2 += 4;
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqGetGeometricFeaturesFromCurves(NIVision.getByteBufferAddress(curves_buf), numCurves, NIVision.getByteBufferAddress(featureTypes_buf), numFeatureTypes, rv_addr + 0L);
        GetGeometricFeaturesFromCurvesResult rv = new GetGeometricFeaturesFromCurvesResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqGetGeometricFeaturesFromCurves(long var0, int var2, long var3, int var5, long var6);

    public static GetGeometricTemplateFeatureInfoResult imaqGetGeometricTemplateFeatureInfo(Image pattern) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqGetGeometricTemplateFeatureInfo(pattern.getAddress(), rv_addr + 0L);
        GetGeometricTemplateFeatureInfoResult rv = new GetGeometricTemplateFeatureInfoResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqGetGeometricTemplateFeatureInfo(long var0, long var2);

    public static void imaqLearnColorPattern(Image image, LearnColorPatternOptions options) {
        NIVision._imaqLearnColorPattern(image.getAddress(), options.getAddress());
    }

    private static native void _imaqLearnColorPattern(long var0, long var2);

    public static void imaqLearnGeometricPattern(Image image, PointFloat originOffset, CurveOptions curveOptions, LearnGeometricPatternAdvancedOptions advancedLearnOptions, Image mask) {
        NIVision._imaqLearnGeometricPattern(image.getAddress(), originOffset.getAddress(), curveOptions.getAddress(), advancedLearnOptions.getAddress(), mask.getAddress());
    }

    private static native void _imaqLearnGeometricPattern(long var0, long var2, long var4, long var6, long var8);

    public static LearnPatternAdvancedOptions imaqLearnPattern3(Image image, LearningMode learningMode, Image mask) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqLearnPattern3(image.getAddress(), learningMode.getValue(), rv_addr + 0L, mask.getAddress());
        LearnPatternAdvancedOptions advancedOptions = new LearnPatternAdvancedOptions(rv_buf, 0);
        advancedOptions.read();
        return advancedOptions;
    }

    private static native void _imaqLearnPattern3(long var0, int var2, long var3, long var5);

    public static MatchColorPatternResult imaqMatchColorPattern(Image image, Image pattern, MatchColorPatternOptions options, Rect searchRect) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqMatchColorPattern(image.getAddress(), pattern.getAddress(), options.getAddress(), searchRect.getAddress(), rv_addr + 0L);
        MatchColorPatternResult rv = new MatchColorPatternResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqMatchColorPattern(long var0, long var2, long var4, long var6, long var8);

    public static MatchGeometricPattern2Result imaqMatchGeometricPattern2(Image image, Image pattern, CurveOptions curveOptions, MatchGeometricPatternOptions matchOptions, MatchGeometricPatternAdvancedOptions2 advancedMatchOptions, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqMatchGeometricPattern2(image.getAddress(), pattern.getAddress(), curveOptions.getAddress(), matchOptions.getAddress(), advancedMatchOptions.getAddress(), roi.getAddress(), rv_addr + 0L);
        MatchGeometricPattern2Result rv = new MatchGeometricPattern2Result(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqMatchGeometricPattern2(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static MatchMultipleGeometricPatternsResult imaqMatchMultipleGeometricPatterns(Image image, MultipleGeometricPattern multiplePattern, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqMatchMultipleGeometricPatterns(image.getAddress(), multiplePattern.getAddress(), roi.getAddress(), rv_addr + 0L);
        MatchMultipleGeometricPatternsResult rv = new MatchMultipleGeometricPatternsResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqMatchMultipleGeometricPatterns(long var0, long var2, long var4, long var6);

    public static MultipleGeometricPattern imaqReadMultipleGeometricPatternFile(String fileName, String description) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        ByteBuffer description_buf = ByteBuffer.allocateDirect(256).order(ByteOrder.nativeOrder());
        if (description != null) {
            byte[] bytes;
            try {
                bytes = description.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = new byte[]{};
            }
            NIVision.putBytes(description_buf, bytes, 0, bytes.length);
            for (int i = bytes.length; i < 256; ++i) {
                description_buf.put(i, (byte)0);
            }
        }
        long jn_rv = NIVision._imaqReadMultipleGeometricPatternFile(fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), description == null ? 0L : NIVision.getByteBufferAddress(description_buf));
        return new MultipleGeometricPattern(jn_rv, true);
    }

    private static native long _imaqReadMultipleGeometricPatternFile(long var0, long var2);

    public static RefineMatchesResult imaqRefineMatches(Image image, Image pattern, PatternMatch[] candidatesIn) {
        int numCandidatesIn = candidatesIn.length;
        ByteBuffer candidatesIn_buf = null;
        candidatesIn_buf = ByteBuffer.allocateDirect(candidatesIn.length * 52).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < candidatesIn.length) {
            candidatesIn[i].setBuffer(candidatesIn_buf, off);
            candidatesIn[i].write();
            ++i;
            off += 52;
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(24).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqRefineMatches(image.getAddress(), pattern.getAddress(), NIVision.getByteBufferAddress(candidatesIn_buf), numCandidatesIn, rv_addr + 0L, rv_addr + 8L, rv_addr + 16L);
        RefineMatchesResult rv = new RefineMatchesResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqRefineMatches(long var0, long var2, long var4, int var6, long var7, long var9, long var11);

    public static void imaqSetMultipleGeometricPatternsOptions(MultipleGeometricPattern multiplePattern, String label, CurveOptions curveOptions, MatchGeometricPatternOptions matchOptions, MatchGeometricPatternAdvancedOptions2 advancedMatchOptions) {
        ByteBuffer label_buf = null;
        if (label != null) {
            byte[] label_bytes;
            try {
                label_bytes = label.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                label_bytes = new byte[]{};
            }
            label_buf = ByteBuffer.allocateDirect(label_bytes.length + 1);
            NIVision.putBytes(label_buf, label_bytes, 0, label_bytes.length).put(label_bytes.length, (byte)0);
        }
        NIVision._imaqSetMultipleGeometricPatternsOptions(multiplePattern.getAddress(), label == null ? 0L : NIVision.getByteBufferAddress(label_buf), curveOptions.getAddress(), matchOptions.getAddress(), advancedMatchOptions.getAddress());
    }

    private static native void _imaqSetMultipleGeometricPatternsOptions(long var0, long var2, long var4, long var6, long var8);

    public static void imaqWriteMultipleGeometricPatternFile(MultipleGeometricPattern multiplePattern, String fileName, String description) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        ByteBuffer description_buf = null;
        if (description != null) {
            byte[] description_bytes;
            try {
                description_bytes = description.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                description_bytes = new byte[]{};
            }
            description_buf = ByteBuffer.allocateDirect(description_bytes.length + 1);
            NIVision.putBytes(description_buf, description_bytes, 0, description_bytes.length).put(description_bytes.length, (byte)0);
        }
        NIVision._imaqWriteMultipleGeometricPatternFile(multiplePattern.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), description == null ? 0L : NIVision.getByteBufferAddress(description_buf));
    }

    private static native void _imaqWriteMultipleGeometricPatternFile(long var0, long var2, long var4);

    public static MatchGeometricPattern3Result imaqMatchGeometricPattern3(Image image, Image pattern, CurveOptions curveOptions, MatchGeometricPatternOptions matchOptions, MatchGeometricPatternAdvancedOptions3 advancedMatchOptions, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqMatchGeometricPattern3(image.getAddress(), pattern.getAddress(), curveOptions.getAddress(), matchOptions.getAddress(), advancedMatchOptions.getAddress(), roi.getAddress(), rv_addr + 0L);
        MatchGeometricPattern3Result rv = new MatchGeometricPattern3Result(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqMatchGeometricPattern3(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static void imaqLearnGeometricPattern2(Image image, PointFloat originOffset, double angleOffset, CurveOptions curveOptions, LearnGeometricPatternAdvancedOptions2 advancedLearnOptions, Image mask) {
        NIVision._imaqLearnGeometricPattern2(image.getAddress(), originOffset.getAddress(), angleOffset, curveOptions.getAddress(), advancedLearnOptions.getAddress(), mask.getAddress());
    }

    private static native void _imaqLearnGeometricPattern2(long var0, long var2, double var4, long var6, long var8, long var10);

    public static MatchPattern3Result imaqMatchPattern3(Image image, Image pattern, MatchPatternOptions options, MatchPatternAdvancedOptions advancedOptions, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqMatchPattern3(image.getAddress(), pattern.getAddress(), options == null ? 0L : options.getAddress(), advancedOptions.getAddress(), roi.getAddress(), rv_addr + 0L);
        MatchPattern3Result rv = new MatchPattern3Result(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqMatchPattern3(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void imaqClearOverlay(Image image, String group) {
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqClearOverlay(image.getAddress(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqClearOverlay(long var0, long var2);

    public static void imaqCopyOverlay(Image dest, Image source, String group) {
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqCopyOverlay(dest.getAddress(), source.getAddress(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqCopyOverlay(long var0, long var2, long var4);

    public static TransformBehaviors imaqGetOverlayProperties(Image image, String group) {
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetOverlayProperties(image.getAddress(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf), rv_addr + 0L);
        TransformBehaviors transformBehaviors = new TransformBehaviors(rv_buf, 0);
        transformBehaviors.read();
        return transformBehaviors;
    }

    private static native void _imaqGetOverlayProperties(long var0, long var2, long var4);

    public static void imaqMergeOverlay(Image dest, Image source, RGBValue[] palette, String group) {
        int numColors = palette.length;
        ByteBuffer palette_buf = null;
        palette_buf = ByteBuffer.allocateDirect(palette.length * 4).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < palette.length) {
            palette[i].setBuffer(palette_buf, off);
            palette[i].write();
            ++i;
            off += 4;
        }
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqMergeOverlay(dest.getAddress(), source.getAddress(), NIVision.getByteBufferAddress(palette_buf), numColors, group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqMergeOverlay(long var0, long var2, long var4, int var6, long var7);

    public static void imaqOverlayArc(Image image, ArcInfo arc, RGBValue color, DrawMode drawMode, String group) {
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqOverlayArc(image.getAddress(), arc.getAddress(), color.getAddress(), drawMode.getValue(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqOverlayArc(long var0, long var2, long var4, int var6, long var7);

    public static void imaqOverlayBitmap(Image image, Point destLoc, RGBValue bitmap, int numCols, int numRows, String group) {
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqOverlayBitmap(image.getAddress(), destLoc.getAddress(), bitmap.getAddress(), numCols, numRows, group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqOverlayBitmap(long var0, long var2, long var4, int var6, int var7, long var8);

    public static void imaqOverlayClosedContour(Image image, Point[] points, RGBValue color, DrawMode drawMode, String group) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqOverlayClosedContour(image.getAddress(), NIVision.getByteBufferAddress(points_buf), numPoints, color.getAddress(), drawMode.getValue(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqOverlayClosedContour(long var0, long var2, int var4, long var5, int var7, long var8);

    public static void imaqOverlayLine(Image image, Point start, Point end, RGBValue color, String group) {
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqOverlayLine(image.getAddress(), start.getAddress(), end.getAddress(), color.getAddress(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqOverlayLine(long var0, long var2, long var4, long var6, long var8);

    public static void imaqOverlayOpenContour(Image image, Point[] points, RGBValue color, String group) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqOverlayOpenContour(image.getAddress(), NIVision.getByteBufferAddress(points_buf), numPoints, color.getAddress(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqOverlayOpenContour(long var0, long var2, int var4, long var5, long var7);

    public static byte imaqOverlayOval(Image image, Rect boundingBox, RGBValue color, DrawMode drawMode) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqOverlayOval(image.getAddress(), boundingBox.getAddress(), color.getAddress(), drawMode.getValue(), rv_addr + 0L);
        byte group = rv_buf.get(0);
        return group;
    }

    private static native void _imaqOverlayOval(long var0, long var2, long var4, int var6, long var7);

    public static void imaqOverlayPoints(Image image, Point[] points, RGBValue[] colors, PointSymbol symbol, UserPointSymbol userSymbol, String group) {
        int numPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        int numColors = colors.length;
        ByteBuffer colors_buf = null;
        colors_buf = ByteBuffer.allocateDirect(colors.length * 4).order(ByteOrder.nativeOrder());
        int i2 = 0;
        int off2 = 0;
        while (i2 < colors.length) {
            colors[i2].setBuffer(colors_buf, off2);
            colors[i2].write();
            ++i2;
            off2 += 4;
        }
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqOverlayPoints(image.getAddress(), NIVision.getByteBufferAddress(points_buf), numPoints, NIVision.getByteBufferAddress(colors_buf), numColors, symbol.getValue(), userSymbol.getAddress(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqOverlayPoints(long var0, long var2, int var4, long var5, int var7, int var8, long var9, long var11);

    public static void imaqOverlayRect(Image image, Rect rect, RGBValue color, DrawMode drawMode, String group) {
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqOverlayRect(image.getAddress(), rect.getAddress(), color.getAddress(), drawMode.getValue(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqOverlayRect(long var0, long var2, long var4, int var6, long var7);

    public static void imaqOverlayROI(Image image, ROI roi, PointSymbol symbol, UserPointSymbol userSymbol, String group) {
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqOverlayROI(image.getAddress(), roi.getAddress(), symbol.getValue(), userSymbol.getAddress(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqOverlayROI(long var0, long var2, int var4, long var5, long var7);

    public static void imaqOverlayText(Image image, Point origin, String text, RGBValue color, OverlayTextOptions options, String group) {
        ByteBuffer text_buf = null;
        if (text != null) {
            byte[] text_bytes;
            try {
                text_bytes = text.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                text_bytes = new byte[]{};
            }
            text_buf = ByteBuffer.allocateDirect(text_bytes.length + 1);
            NIVision.putBytes(text_buf, text_bytes, 0, text_bytes.length).put(text_bytes.length, (byte)0);
        }
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        NIVision._imaqOverlayText(image.getAddress(), origin.getAddress(), text == null ? 0L : NIVision.getByteBufferAddress(text_buf), color.getAddress(), options.getAddress(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf));
    }

    private static native void _imaqOverlayText(long var0, long var2, long var4, long var6, long var8, long var10);

    public static TransformBehaviors imaqSetOverlayProperties(Image image, String group) {
        ByteBuffer group_buf = null;
        if (group != null) {
            byte[] group_bytes;
            try {
                group_bytes = group.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                group_bytes = new byte[]{};
            }
            group_buf = ByteBuffer.allocateDirect(group_bytes.length + 1);
            NIVision.putBytes(group_buf, group_bytes, 0, group_bytes.length).put(group_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqSetOverlayProperties(image.getAddress(), group == null ? 0L : NIVision.getByteBufferAddress(group_buf), rv_addr + 0L);
        TransformBehaviors transformBehaviors = new TransformBehaviors(rv_buf, 0);
        transformBehaviors.read();
        return transformBehaviors;
    }

    private static native void _imaqSetOverlayProperties(long var0, long var2, long var4);

    public static CharSet imaqCreateCharSet() {
        long jn_rv = NIVision._imaqCreateCharSet();
        return new CharSet(jn_rv, true);
    }

    private static native long _imaqCreateCharSet();

    public static void imaqDeleteChar(CharSet set, int index) {
        NIVision._imaqDeleteChar(set.getAddress(), index);
    }

    private static native void _imaqDeleteChar(long var0, int var2);

    public static void imaqGetCharCount(CharSet set) {
        NIVision._imaqGetCharCount(set.getAddress());
    }

    private static native void _imaqGetCharCount(long var0);

    public static CharInfo2 imaqGetCharInfo2(CharSet set, int index) {
        long jn_rv = NIVision._imaqGetCharInfo2(set.getAddress(), index);
        return new CharInfo2(jn_rv, true);
    }

    private static native long _imaqGetCharInfo2(long var0, int var2);

    public static ReadOCRFileResult imaqReadOCRFile(String fileName, CharSet set, String setDescription) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        ByteBuffer setDescription_buf = ByteBuffer.allocateDirect(256).order(ByteOrder.nativeOrder());
        if (setDescription != null) {
            byte[] bytes;
            try {
                bytes = setDescription.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = new byte[]{};
            }
            NIVision.putBytes(setDescription_buf, bytes, 0, bytes.length);
            for (int i = bytes.length; i < 256; ++i) {
                setDescription_buf.put(i, (byte)0);
            }
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(24).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqReadOCRFile(fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), set.getAddress(), setDescription == null ? 0L : NIVision.getByteBufferAddress(setDescription_buf), rv_addr + 0L, rv_addr + 8L, rv_addr + 16L);
        ReadOCRFileResult rv = new ReadOCRFileResult(rv_buf);
        return rv;
    }

    private static native void _imaqReadOCRFile(long var0, long var2, long var4, long var6, long var8, long var10);

    public static ReadTextReport3 imaqReadText3(Image image, CharSet set, ROI roi, ReadTextOptions readOptions, OCRProcessingOptions processingOptions, OCRSpacingOptions spacingOptions) {
        long jn_rv = NIVision._imaqReadText3(image.getAddress(), set.getAddress(), roi.getAddress(), readOptions.getAddress(), processingOptions.getAddress(), spacingOptions.getAddress());
        return new ReadTextReport3(jn_rv, true);
    }

    private static native long _imaqReadText3(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void imaqRenameChar(CharSet set, int index, String newCharValue) {
        ByteBuffer newCharValue_buf = null;
        if (newCharValue != null) {
            byte[] newCharValue_bytes;
            try {
                newCharValue_bytes = newCharValue.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                newCharValue_bytes = new byte[]{};
            }
            newCharValue_buf = ByteBuffer.allocateDirect(newCharValue_bytes.length + 1);
            NIVision.putBytes(newCharValue_buf, newCharValue_bytes, 0, newCharValue_bytes.length).put(newCharValue_bytes.length, (byte)0);
        }
        NIVision._imaqRenameChar(set.getAddress(), index, newCharValue == null ? 0L : NIVision.getByteBufferAddress(newCharValue_buf));
    }

    private static native void _imaqRenameChar(long var0, int var2, long var3);

    public static void imaqSetReferenceChar(CharSet set, int index, int isReferenceChar) {
        NIVision._imaqSetReferenceChar(set.getAddress(), index, isReferenceChar);
    }

    private static native void _imaqSetReferenceChar(long var0, int var2, int var3);

    public static void imaqTrainChars(Image image, CharSet set, int index, String charValue, ROI roi, OCRProcessingOptions processingOptions, OCRSpacingOptions spacingOptions) {
        ByteBuffer charValue_buf = null;
        if (charValue != null) {
            byte[] charValue_bytes;
            try {
                charValue_bytes = charValue.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                charValue_bytes = new byte[]{};
            }
            charValue_buf = ByteBuffer.allocateDirect(charValue_bytes.length + 1);
            NIVision.putBytes(charValue_buf, charValue_bytes, 0, charValue_bytes.length).put(charValue_bytes.length, (byte)0);
        }
        NIVision._imaqTrainChars(image.getAddress(), set.getAddress(), index, charValue == null ? 0L : NIVision.getByteBufferAddress(charValue_buf), roi.getAddress(), processingOptions.getAddress(), spacingOptions.getAddress());
    }

    private static native void _imaqTrainChars(long var0, long var2, int var4, long var5, long var7, long var9, long var11);

    public static VerifyTextResult imaqVerifyText(Image image, CharSet set, String expectedString, ROI roi) {
        ByteBuffer expectedString_buf = null;
        if (expectedString != null) {
            byte[] expectedString_bytes;
            try {
                expectedString_bytes = expectedString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                expectedString_bytes = new byte[]{};
            }
            expectedString_buf = ByteBuffer.allocateDirect(expectedString_bytes.length + 1);
            NIVision.putBytes(expectedString_buf, expectedString_bytes, 0, expectedString_bytes.length).put(expectedString_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqVerifyText(image.getAddress(), set.getAddress(), expectedString == null ? 0L : NIVision.getByteBufferAddress(expectedString_buf), roi.getAddress(), rv_addr + 0L);
        VerifyTextResult rv = new VerifyTextResult(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqVerifyText(long var0, long var2, long var4, long var6, long var8);

    public static void imaqWriteOCRFile(String fileName, CharSet set, String setDescription, ReadTextOptions readOptions, OCRProcessingOptions processingOptions, OCRSpacingOptions spacingOptions) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        ByteBuffer setDescription_buf = null;
        if (setDescription != null) {
            byte[] setDescription_bytes;
            try {
                setDescription_bytes = setDescription.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                setDescription_bytes = new byte[]{};
            }
            setDescription_buf = ByteBuffer.allocateDirect(setDescription_bytes.length + 1);
            NIVision.putBytes(setDescription_buf, setDescription_bytes, 0, setDescription_bytes.length).put(setDescription_bytes.length, (byte)0);
        }
        NIVision._imaqWriteOCRFile(fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), set.getAddress(), setDescription == null ? 0L : NIVision.getByteBufferAddress(setDescription_buf), readOptions.getAddress(), processingOptions.getAddress(), spacingOptions.getAddress());
    }

    private static native void _imaqWriteOCRFile(long var0, long var2, long var4, long var6, long var8, long var10);

    public static ExtractContourResult imaqExtractContour(Image image, ROI roi, ExtractContourDirection direction, ConnectionConstraint connectionConstraintParams, int numOfConstraints, ExtractContourSelection selection, Image contourImage) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqExtractContour(image.getAddress(), roi.getAddress(), direction.getValue(), rv_addr + 0L, connectionConstraintParams.getAddress(), numOfConstraints, selection.getValue(), contourImage.getAddress());
        ExtractContourResult rv = new ExtractContourResult(rv_buf);
        rv.val = new ExtractContourReport(jn_rv, true);
        return rv;
    }

    private static native long _imaqExtractContour(long var0, long var2, int var4, long var5, long var7, int var9, int var10, long var11);

    public static void imaqContourOverlay(Image image, Image contourImage, ContourOverlaySettings pointsSettings, ContourOverlaySettings eqnSettings, String groupName) {
        ByteBuffer groupName_buf = null;
        if (groupName != null) {
            byte[] groupName_bytes;
            try {
                groupName_bytes = groupName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                groupName_bytes = new byte[]{};
            }
            groupName_buf = ByteBuffer.allocateDirect(groupName_bytes.length + 1);
            NIVision.putBytes(groupName_buf, groupName_bytes, 0, groupName_bytes.length).put(groupName_bytes.length, (byte)0);
        }
        NIVision._imaqContourOverlay(image.getAddress(), contourImage.getAddress(), pointsSettings.getAddress(), eqnSettings.getAddress(), groupName == null ? 0L : NIVision.getByteBufferAddress(groupName_buf));
    }

    private static native void _imaqContourOverlay(long var0, long var2, long var4, long var6, long var8);

    public static ContourComputeCurvatureReport imaqContourComputeCurvature(Image contourImage, int kernel) {
        long jn_rv = NIVision._imaqContourComputeCurvature(contourImage.getAddress(), kernel);
        return new ContourComputeCurvatureReport(jn_rv, true);
    }

    private static native long _imaqContourComputeCurvature(long var0, int var2);

    public static CurvatureAnalysisReport imaqContourClassifyCurvature(Image contourImage, int kernel, RangeLabel[] curvatureClasses) {
        int numCurvatureClasses = curvatureClasses.length;
        ByteBuffer curvatureClasses_buf = null;
        curvatureClasses_buf = ByteBuffer.allocateDirect(curvatureClasses.length * 24).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < curvatureClasses.length) {
            curvatureClasses[i].setBuffer(curvatureClasses_buf, off);
            curvatureClasses[i].write();
            ++i;
            off += 24;
        }
        long jn_rv = NIVision._imaqContourClassifyCurvature(contourImage.getAddress(), kernel, NIVision.getByteBufferAddress(curvatureClasses_buf), numCurvatureClasses);
        return new CurvatureAnalysisReport(jn_rv, true);
    }

    private static native long _imaqContourClassifyCurvature(long var0, int var2, long var3, int var5);

    public static ComputeDistancesReport imaqContourComputeDistances(Image targetImage, Image templateImage, SetupMatchPatternData matchSetupData, int smoothingKernel) {
        long jn_rv = NIVision._imaqContourComputeDistances(targetImage.getAddress(), templateImage.getAddress(), matchSetupData.getAddress(), smoothingKernel);
        return new ComputeDistancesReport(jn_rv, true);
    }

    private static native long _imaqContourComputeDistances(long var0, long var2, long var4, int var6);

    public static ClassifyDistancesReport imaqContourClassifyDistances(Image targetImage, Image templateImage, SetupMatchPatternData matchSetupData, int smoothingKernel, RangeLabel[] distanceRanges) {
        int numDistanceRanges = distanceRanges.length;
        ByteBuffer distanceRanges_buf = null;
        distanceRanges_buf = ByteBuffer.allocateDirect(distanceRanges.length * 24).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < distanceRanges.length) {
            distanceRanges[i].setBuffer(distanceRanges_buf, off);
            distanceRanges[i].write();
            ++i;
            off += 24;
        }
        long jn_rv = NIVision._imaqContourClassifyDistances(targetImage.getAddress(), templateImage.getAddress(), matchSetupData.getAddress(), smoothingKernel, NIVision.getByteBufferAddress(distanceRanges_buf), numDistanceRanges);
        return new ClassifyDistancesReport(jn_rv, true);
    }

    private static native long _imaqContourClassifyDistances(long var0, long var2, long var4, int var6, long var7, int var9);

    public static ContourInfoReport imaqContourInfo(Image contourImage) {
        long jn_rv = NIVision._imaqContourInfo(contourImage.getAddress());
        return new ContourInfoReport(jn_rv, true);
    }

    private static native long _imaqContourInfo(long var0);

    public static ContourSetupMatchPatternResult imaqContourSetupMatchPattern(int enableSubPixelAccuracy, int useLearnCurveParameters, RangeSettingDouble[] rangeSettings) {
        int numRangeSettings = rangeSettings.length;
        ByteBuffer rangeSettings_buf = null;
        rangeSettings_buf = ByteBuffer.allocateDirect(rangeSettings.length * 24).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < rangeSettings.length) {
            rangeSettings[i].setBuffer(rangeSettings_buf, off);
            rangeSettings[i].write();
            ++i;
            off += 24;
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqContourSetupMatchPattern(rv_addr + 0L, enableSubPixelAccuracy, rv_addr + 8L, useLearnCurveParameters, NIVision.getByteBufferAddress(rangeSettings_buf), numRangeSettings);
        ContourSetupMatchPatternResult rv = new ContourSetupMatchPatternResult(rv_buf);
        rv.val = new SetupMatchPatternData(jn_rv, true);
        return rv;
    }

    private static native long _imaqContourSetupMatchPattern(long var0, int var2, long var3, int var5, long var6, int var8);

    public static SetupMatchPatternData imaqContourAdvancedSetupMatchPattern(GeometricAdvancedSetupDataOption[] geometricOptions) {
        int numGeometricOptions = geometricOptions.length;
        ByteBuffer geometricOptions_buf = null;
        geometricOptions_buf = ByteBuffer.allocateDirect(geometricOptions.length * 16).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < geometricOptions.length) {
            geometricOptions[i].setBuffer(geometricOptions_buf, off);
            geometricOptions[i].write();
            ++i;
            off += 16;
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqContourAdvancedSetupMatchPattern(rv_addr + 0L, NIVision.getByteBufferAddress(geometricOptions_buf), numGeometricOptions);
        SetupMatchPatternData matchSetupData = new SetupMatchPatternData(rv_buf, 0);
        matchSetupData.read();
        return matchSetupData;
    }

    private static native void _imaqContourAdvancedSetupMatchPattern(long var0, long var2, int var4);

    public static ContourFitLineReport imaqContourFitLine(Image image, double pixelRadius) {
        long jn_rv = NIVision._imaqContourFitLine(image.getAddress(), pixelRadius);
        return new ContourFitLineReport(jn_rv, true);
    }

    private static native long _imaqContourFitLine(long var0, double var2);

    public static PartialCircle imaqContourFitCircle(Image image, double pixelRadius, int rejectOutliers) {
        long jn_rv = NIVision._imaqContourFitCircle(image.getAddress(), pixelRadius, rejectOutliers);
        return new PartialCircle(jn_rv, true);
    }

    private static native long _imaqContourFitCircle(long var0, double var2, int var4);

    public static PartialEllipse imaqContourFitEllipse(Image image, double pixelRadius, int rejectOutliers) {
        long jn_rv = NIVision._imaqContourFitEllipse(image.getAddress(), pixelRadius, rejectOutliers);
        return new PartialEllipse(jn_rv, true);
    }

    private static native long _imaqContourFitEllipse(long var0, double var2, int var4);

    public static ContourFitSplineReport imaqContourFitSpline(Image image, int degree, int numberOfControlPoints) {
        long jn_rv = NIVision._imaqContourFitSpline(image.getAddress(), degree, numberOfControlPoints);
        return new ContourFitSplineReport(jn_rv, true);
    }

    private static native long _imaqContourFitSpline(long var0, int var2, int var3);

    public static ContourFitPolynomialReport imaqContourFitPolynomial(Image image, int order) {
        long jn_rv = NIVision._imaqContourFitPolynomial(image.getAddress(), order);
        return new ContourFitPolynomialReport(jn_rv, true);
    }

    private static native long _imaqContourFitPolynomial(long var0, int var2);

    public static FindCircularEdgeReport imaqFindCircularEdge2(Image image, ROI roi, CoordinateSystem baseSystem, CoordinateSystem newSystem, FindCircularEdgeOptions edgeOptions, CircleFitOptions circleFitOptions) {
        long jn_rv = NIVision._imaqFindCircularEdge2(image.getAddress(), roi.getAddress(), baseSystem.getAddress(), newSystem.getAddress(), edgeOptions.getAddress(), circleFitOptions.getAddress());
        return new FindCircularEdgeReport(jn_rv, true);
    }

    private static native long _imaqFindCircularEdge2(long var0, long var2, long var4, long var6, long var8, long var10);

    public static FindConcentricEdgeReport imaqFindConcentricEdge2(Image image, ROI roi, CoordinateSystem baseSystem, CoordinateSystem newSystem, FindConcentricEdgeOptions edgeOptions, ConcentricEdgeFitOptions concentricEdgeFitOptions) {
        long jn_rv = NIVision._imaqFindConcentricEdge2(image.getAddress(), roi.getAddress(), baseSystem.getAddress(), newSystem.getAddress(), edgeOptions.getAddress(), concentricEdgeFitOptions.getAddress());
        return new FindConcentricEdgeReport(jn_rv, true);
    }

    private static native long _imaqFindConcentricEdge2(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void imaqGrayMorphologyReconstruct(Image dstImage, Image srcImage, Image markerImage, PointFloat[] points, MorphologyReconstructOperation operation, StructuringElement structuringElement, ROI roi) {
        int numOfPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        NIVision._imaqGrayMorphologyReconstruct(dstImage.getAddress(), srcImage.getAddress(), markerImage.getAddress(), NIVision.getByteBufferAddress(points_buf), numOfPoints, operation.getValue(), structuringElement.getAddress(), roi.getAddress());
    }

    private static native void _imaqGrayMorphologyReconstruct(long var0, long var2, long var4, long var6, int var8, int var9, long var10, long var12);

    public static void imaqMorphologyReconstruct(Image dstImage, Image srcImage, Image markerImage, PointFloat[] points, MorphologyReconstructOperation operation, Connectivity connectivity, ROI roi) {
        int numOfPoints = points.length;
        ByteBuffer points_buf = null;
        points_buf = ByteBuffer.allocateDirect(points.length * 8).order(ByteOrder.nativeOrder());
        int i = 0;
        int off = 0;
        while (i < points.length) {
            points[i].setBuffer(points_buf, off);
            points[i].write();
            ++i;
            off += 8;
        }
        NIVision._imaqMorphologyReconstruct(dstImage.getAddress(), srcImage.getAddress(), markerImage.getAddress(), NIVision.getByteBufferAddress(points_buf), numOfPoints, operation.getValue(), connectivity.getValue(), roi.getAddress());
    }

    private static native void _imaqMorphologyReconstruct(long var0, long var2, long var4, long var6, int var8, int var9, int var10, long var11);

    public static void imaqDetectTextureDefect(ClassifierSession session, Image destImage, Image srcImage, ROI roi, int initialStepSize, int finalStepSize, short defectPixelValue, double minClassificationScore) {
        NIVision._imaqDetectTextureDefect(session.getAddress(), destImage.getAddress(), srcImage.getAddress(), roi.getAddress(), initialStepSize, finalStepSize, defectPixelValue, minClassificationScore);
    }

    private static native void _imaqDetectTextureDefect(long var0, long var2, long var4, long var6, int var8, int var9, short var10, double var11);

    public static MaskToROIResult imaqMaskToROI(Image mask) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqMaskToROI(mask.getAddress(), rv_addr + 0L);
        MaskToROIResult rv = new MaskToROIResult(rv_buf);
        rv.val = new ROI(jn_rv, true);
        return rv;
    }

    private static native long _imaqMaskToROI(long var0, long var2);

    public static ROIProfile imaqROIProfile(Image image, ROI roi) {
        long jn_rv = NIVision._imaqROIProfile(image.getAddress(), roi.getAddress());
        return new ROIProfile(jn_rv, true);
    }

    private static native long _imaqROIProfile(long var0, long var2);

    public static int imaqROIToMask(Image mask, ROI roi, int fillValue, Image imageModel) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqROIToMask(mask.getAddress(), roi.getAddress(), fillValue, imageModel == null ? 0L : imageModel.getAddress(), rv_addr + 0L);
        int inSpace = rv_buf.getInt(0);
        return inSpace;
    }

    private static native void _imaqROIToMask(long var0, long var2, int var4, long var5, long var7);

    public static void imaqTransformROI2(ROI roi, CoordinateSystem baseSystem, CoordinateSystem newSystem) {
        NIVision._imaqTransformROI2(roi.getAddress(), baseSystem.getAddress(), newSystem.getAddress());
    }

    private static native void _imaqTransformROI2(long var0, long var2, long var4);

    public static LabelToROIReport imaqLabelToROI(Image image, int[] labelsIn, int maxNumVectors, int isExternelEdges) {
        int numLabelsIn = labelsIn.length;
        ByteBuffer labelsIn_buf = null;
        labelsIn_buf = ByteBuffer.allocateDirect(labelsIn.length * 4).order(ByteOrder.nativeOrder());
        labelsIn_buf.asIntBuffer().put(labelsIn).rewind();
        long jn_rv = NIVision._imaqLabelToROI(image.getAddress(), NIVision.getByteBufferAddress(labelsIn_buf), numLabelsIn, maxNumVectors, isExternelEdges);
        return new LabelToROIReport(jn_rv, true);
    }

    private static native long _imaqLabelToROI(long var0, long var2, int var4, int var5, int var6);

    public static void imaqGrayMorphology(Image dest, Image source, MorphologyMethod method, StructuringElement structuringElement) {
        NIVision._imaqGrayMorphology(dest.getAddress(), source.getAddress(), method.getValue(), structuringElement == null ? 0L : structuringElement.getAddress());
    }

    private static native void _imaqGrayMorphology(long var0, long var2, int var4, long var5);

    public static void imaqAddClassifierSample(Image image, ClassifierSession session, ROI roi, String sampleClass, double[] featureVector) {
        ByteBuffer sampleClass_buf = null;
        if (sampleClass != null) {
            byte[] sampleClass_bytes;
            try {
                sampleClass_bytes = sampleClass.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                sampleClass_bytes = new byte[]{};
            }
            sampleClass_buf = ByteBuffer.allocateDirect(sampleClass_bytes.length + 1);
            NIVision.putBytes(sampleClass_buf, sampleClass_bytes, 0, sampleClass_bytes.length).put(sampleClass_bytes.length, (byte)0);
        }
        int vectorSize = featureVector.length;
        ByteBuffer featureVector_buf = null;
        featureVector_buf = ByteBuffer.allocateDirect(featureVector.length * 8).order(ByteOrder.nativeOrder());
        featureVector_buf.asDoubleBuffer().put(featureVector).rewind();
        NIVision._imaqAddClassifierSample(image.getAddress(), session.getAddress(), roi.getAddress(), sampleClass == null ? 0L : NIVision.getByteBufferAddress(sampleClass_buf), NIVision.getByteBufferAddress(featureVector_buf), vectorSize);
    }

    private static native void _imaqAddClassifierSample(long var0, long var2, long var4, long var6, long var8, int var10);

    public static ClassifierReportAdvanced imaqAdvanceClassify(Image image, ClassifierSession session, ROI roi, double[] featureVector) {
        int vectorSize = featureVector.length;
        ByteBuffer featureVector_buf = null;
        featureVector_buf = ByteBuffer.allocateDirect(featureVector.length * 8).order(ByteOrder.nativeOrder());
        featureVector_buf.asDoubleBuffer().put(featureVector).rewind();
        long jn_rv = NIVision._imaqAdvanceClassify(image.getAddress(), session.getAddress(), roi.getAddress(), NIVision.getByteBufferAddress(featureVector_buf), vectorSize);
        return new ClassifierReportAdvanced(jn_rv, true);
    }

    private static native long _imaqAdvanceClassify(long var0, long var2, long var4, long var6, int var8);

    public static ClassifierReport imaqClassify(Image image, ClassifierSession session, ROI roi, double[] featureVector) {
        int vectorSize = featureVector.length;
        ByteBuffer featureVector_buf = null;
        featureVector_buf = ByteBuffer.allocateDirect(featureVector.length * 8).order(ByteOrder.nativeOrder());
        featureVector_buf.asDoubleBuffer().put(featureVector).rewind();
        long jn_rv = NIVision._imaqClassify(image.getAddress(), session.getAddress(), roi.getAddress(), NIVision.getByteBufferAddress(featureVector_buf), vectorSize);
        return new ClassifierReport(jn_rv, true);
    }

    private static native long _imaqClassify(long var0, long var2, long var4, long var6, int var8);

    public static ClassifierSession imaqCreateClassifier(ClassifierType type) {
        long jn_rv = NIVision._imaqCreateClassifier(type.getValue());
        return new ClassifierSession(jn_rv, true);
    }

    private static native long _imaqCreateClassifier(int var0);

    public static void imaqDeleteClassifierSample(ClassifierSession session, int index) {
        NIVision._imaqDeleteClassifierSample(session.getAddress(), index);
    }

    private static native void _imaqDeleteClassifierSample(long var0, int var2);

    public static ClassifierAccuracyReport imaqGetClassifierAccuracy(ClassifierSession session) {
        long jn_rv = NIVision._imaqGetClassifierAccuracy(session.getAddress());
        return new ClassifierAccuracyReport(jn_rv, true);
    }

    private static native long _imaqGetClassifierAccuracy(long var0);

    public static GetClassifierSampleInfoResult imaqGetClassifierSampleInfo(ClassifierSession session, int index) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqGetClassifierSampleInfo(session.getAddress(), index, rv_addr + 0L);
        GetClassifierSampleInfoResult rv = new GetClassifierSampleInfoResult(rv_buf);
        rv.val = new ClassifierSampleInfo(jn_rv, true);
        return rv;
    }

    private static native long _imaqGetClassifierSampleInfo(long var0, int var2, long var3);

    public static ColorOptions imaqGetColorClassifierOptions(ClassifierSession session) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetColorClassifierOptions(session.getAddress(), rv_addr + 0L);
        ColorOptions options = new ColorOptions(rv_buf, 0);
        options.read();
        return options;
    }

    private static native void _imaqGetColorClassifierOptions(long var0, long var2);

    public static NearestNeighborOptions imaqGetNearestNeighborOptions(ClassifierSession session) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetNearestNeighborOptions(session.getAddress(), rv_addr + 0L);
        NearestNeighborOptions options = new NearestNeighborOptions(rv_buf, 0);
        options.read();
        return options;
    }

    private static native void _imaqGetNearestNeighborOptions(long var0, long var2);

    public static GetParticleClassifierOptions2Result imaqGetParticleClassifierOptions2(ClassifierSession session) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetParticleClassifierOptions2(session.getAddress(), rv_addr + 0L, rv_addr + 8L);
        GetParticleClassifierOptions2Result rv = new GetParticleClassifierOptions2Result(rv_buf);
        return rv;
    }

    private static native void _imaqGetParticleClassifierOptions2(long var0, long var2, long var4);

    public static ReadClassifierFileResult imaqReadClassifierFile(ClassifierSession session, String fileName, ReadClassifierFileMode mode, String description) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        ByteBuffer description_buf = ByteBuffer.allocateDirect(256).order(ByteOrder.nativeOrder());
        if (description != null) {
            byte[] bytes;
            try {
                bytes = description.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = new byte[]{};
            }
            NIVision.putBytes(description_buf, bytes, 0, bytes.length);
            for (int i = bytes.length; i < 256; ++i) {
                description_buf.put(i, (byte)0);
            }
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqReadClassifierFile(session.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), mode.getValue(), rv_addr + 0L, rv_addr + 8L, description == null ? 0L : NIVision.getByteBufferAddress(description_buf));
        ReadClassifierFileResult rv = new ReadClassifierFileResult(rv_buf);
        rv.val = new ClassifierSession(jn_rv, true);
        return rv;
    }

    private static native long _imaqReadClassifierFile(long var0, long var2, int var4, long var5, long var7, long var9);

    public static void imaqRelabelClassifierSample(ClassifierSession session, int index, String newClass) {
        ByteBuffer newClass_buf = null;
        if (newClass != null) {
            byte[] newClass_bytes;
            try {
                newClass_bytes = newClass.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                newClass_bytes = new byte[]{};
            }
            newClass_buf = ByteBuffer.allocateDirect(newClass_bytes.length + 1);
            NIVision.putBytes(newClass_buf, newClass_bytes, 0, newClass_bytes.length).put(newClass_bytes.length, (byte)0);
        }
        NIVision._imaqRelabelClassifierSample(session.getAddress(), index, newClass == null ? 0L : NIVision.getByteBufferAddress(newClass_buf));
    }

    private static native void _imaqRelabelClassifierSample(long var0, int var2, long var3);

    public static void imaqSetParticleClassifierOptions2(ClassifierSession session, ParticleClassifierPreprocessingOptions2 preprocessingOptions, ParticleClassifierOptions options) {
        NIVision._imaqSetParticleClassifierOptions2(session.getAddress(), preprocessingOptions.getAddress(), options.getAddress());
    }

    private static native void _imaqSetParticleClassifierOptions2(long var0, long var2, long var4);

    public static void imaqSetColorClassifierOptions(ClassifierSession session, ColorOptions options) {
        NIVision._imaqSetColorClassifierOptions(session.getAddress(), options.getAddress());
    }

    private static native void _imaqSetColorClassifierOptions(long var0, long var2);

    public static NearestNeighborTrainingReport imaqTrainNearestNeighborClassifier(ClassifierSession session, NearestNeighborOptions options) {
        long jn_rv = NIVision._imaqTrainNearestNeighborClassifier(session.getAddress(), options.getAddress());
        return new NearestNeighborTrainingReport(jn_rv, true);
    }

    private static native long _imaqTrainNearestNeighborClassifier(long var0, long var2);

    public static void imaqWriteClassifierFile(ClassifierSession session, String fileName, WriteClassifierFileMode mode, String description) {
        ByteBuffer fileName_buf = null;
        if (fileName != null) {
            byte[] fileName_bytes;
            try {
                fileName_bytes = fileName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                fileName_bytes = new byte[]{};
            }
            fileName_buf = ByteBuffer.allocateDirect(fileName_bytes.length + 1);
            NIVision.putBytes(fileName_buf, fileName_bytes, 0, fileName_bytes.length).put(fileName_bytes.length, (byte)0);
        }
        ByteBuffer description_buf = ByteBuffer.allocateDirect(256).order(ByteOrder.nativeOrder());
        if (description != null) {
            byte[] bytes;
            try {
                bytes = description.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = new byte[]{};
            }
            NIVision.putBytes(description_buf, bytes, 0, bytes.length);
            for (int i = bytes.length; i < 256; ++i) {
                description_buf.put(i, (byte)0);
            }
        }
        NIVision._imaqWriteClassifierFile(session.getAddress(), fileName == null ? 0L : NIVision.getByteBufferAddress(fileName_buf), mode.getValue(), description == null ? 0L : NIVision.getByteBufferAddress(description_buf));
    }

    private static native void _imaqWriteClassifierFile(long var0, long var2, int var4, long var5);

    public static ClampMax2Report imaqClampMax2(Image image, ROI roi, CoordinateSystem baseSystem, CoordinateSystem newSystem, CurveOptions curveSettings, ClampSettings clampSettings, ClampOverlaySettings clampOverlaySettings) {
        long jn_rv = NIVision._imaqClampMax2(image.getAddress(), roi.getAddress(), baseSystem.getAddress(), newSystem.getAddress(), curveSettings.getAddress(), clampSettings.getAddress(), clampOverlaySettings.getAddress());
        return new ClampMax2Report(jn_rv, true);
    }

    private static native long _imaqClampMax2(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static void imaqCompareGoldenTemplate(Image image, Image goldenTemplate, Image brightDefects, Image darkDefects, InspectionAlignment alignment, InspectionOptions options) {
        NIVision._imaqCompareGoldenTemplate(image.getAddress(), goldenTemplate.getAddress(), brightDefects.getAddress(), darkDefects.getAddress(), alignment.getAddress(), options.getAddress());
    }

    private static native void _imaqCompareGoldenTemplate(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void imaqLearnGoldenTemplate(Image goldenTemplate, PointFloat originOffset, Image mask) {
        NIVision._imaqLearnGoldenTemplate(goldenTemplate.getAddress(), originOffset.getAddress(), mask.getAddress());
    }

    private static native void _imaqLearnGoldenTemplate(long var0, long var2, long var4);

    public static GetParticleClassifierOptionsResult imaqGetParticleClassifierOptions(ClassifierSession session) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqGetParticleClassifierOptions(session.getAddress(), rv_addr + 0L, rv_addr + 8L);
        GetParticleClassifierOptionsResult rv = new GetParticleClassifierOptionsResult(rv_buf);
        return rv;
    }

    private static native void _imaqGetParticleClassifierOptions(long var0, long var2, long var4);

    public static int imaqParticleFilter3(Image dest, Image source, ParticleFilterCriteria2 criteria, int criteriaCount, ParticleFilterOptions options, ROI roi) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqParticleFilter3(dest.getAddress(), source.getAddress(), criteria.getAddress(), criteriaCount, options.getAddress(), roi.getAddress(), rv_addr + 0L);
        int numParticles = rv_buf.getInt(0);
        return numParticles;
    }

    private static native void _imaqParticleFilter3(long var0, long var2, long var4, int var6, long var7, long var9, long var11);

    public static LearnPatternAdvancedOptions imaqLearnPattern2(Image image, LearningMode learningMode) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._imaqLearnPattern2(image.getAddress(), learningMode.getValue(), rv_addr + 0L);
        LearnPatternAdvancedOptions advancedOptions = new LearnPatternAdvancedOptions(rv_buf, 0);
        advancedOptions.read();
        return advancedOptions;
    }

    private static native void _imaqLearnPattern2(long var0, int var2, long var3);

    public static void imaqDivide(Image dest, Image sourceA, Image sourceB) {
        NIVision._imaqDivide(dest.getAddress(), sourceA.getAddress(), sourceB.getAddress());
    }

    private static native void _imaqDivide(long var0, long var2, long var4);

    public static EdgeReport2 imaqEdgeTool3(Image image, ROI roi, EdgeProcess processType, EdgeOptions2 edgeOptions) {
        long jn_rv = NIVision._imaqEdgeTool3(image.getAddress(), roi.getAddress(), processType.getValue(), edgeOptions.getAddress());
        return new EdgeReport2(jn_rv, true);
    }

    private static native long _imaqEdgeTool3(long var0, long var2, int var4, long var5);

    public static ConcentricRakeReport imaqConcentricRake(Image image, ROI roi, ConcentricRakeDirection direction, EdgeProcess process, RakeOptions options) {
        long jn_rv = NIVision._imaqConcentricRake(image.getAddress(), roi.getAddress(), direction.getValue(), process.getValue(), options.getAddress());
        return new ConcentricRakeReport(jn_rv, true);
    }

    private static native long _imaqConcentricRake(long var0, long var2, int var4, int var5, long var6);

    public static SpokeReport imaqSpoke(Image image, ROI roi, SpokeDirection direction, EdgeProcess process, SpokeOptions options) {
        long jn_rv = NIVision._imaqSpoke(image.getAddress(), roi.getAddress(), direction.getValue(), process.getValue(), options.getAddress());
        return new SpokeReport(jn_rv, true);
    }

    private static native long _imaqSpoke(long var0, long var2, int var4, int var5, long var6);

    public static MatchPattern2Result imaqMatchPattern2(Image image, Image pattern, MatchPatternOptions options, MatchPatternAdvancedOptions advancedOptions, Rect searchRect) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        long jn_rv = NIVision._imaqMatchPattern2(image.getAddress(), pattern.getAddress(), options == null ? 0L : options.getAddress(), advancedOptions.getAddress(), searchRect.getAddress(), rv_addr + 0L);
        MatchPattern2Result rv = new MatchPattern2Result(rv_buf, jn_rv);
        return rv;
    }

    private static native long _imaqMatchPattern2(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void imaqSetParticleClassifierOptions(ClassifierSession session, ParticleClassifierPreprocessingOptions preprocessingOptions, ParticleClassifierOptions options) {
        NIVision._imaqSetParticleClassifierOptions(session.getAddress(), preprocessingOptions.getAddress(), options.getAddress());
    }

    private static native void _imaqSetParticleClassifierOptions(long var0, long var2, long var4);

    public static RakeReport imaqRake(Image image, ROI roi, RakeDirection direction, EdgeProcess process, RakeOptions options) {
        long jn_rv = NIVision._imaqRake(image.getAddress(), roi.getAddress(), direction.getValue(), process.getValue(), options.getAddress());
        return new RakeReport(jn_rv, true);
    }

    private static native long _imaqRake(long var0, long var2, int var4, int var5, long var6);

    public static void Priv_ReadJPEGString_C(Image image, byte[] string) {
        int stringLength = string.length;
        ByteBuffer string_buf = null;
        string_buf = ByteBuffer.allocateDirect(string.length);
        NIVision.putBytes(string_buf, string, 0, string.length);
        NIVision._Priv_ReadJPEGString_C(image.getAddress(), NIVision.getByteBufferAddress(string_buf), stringLength);
    }

    private static native void _Priv_ReadJPEGString_C(long var0, long var2, int var4);

    public static void IMAQdxSnap(int id, Image image) {
        NIVision._IMAQdxSnap(id, image.getAddress());
    }

    private static native void _IMAQdxSnap(int var0, long var1);

    public static void IMAQdxConfigureGrab(int id) {
        NIVision._IMAQdxConfigureGrab(id);
    }

    private static native void _IMAQdxConfigureGrab(int var0);

    public static int IMAQdxGrab(int id, Image image, int waitForNextBuffer) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGrab(id, image.getAddress(), waitForNextBuffer, rv_addr + 0L);
        int actualBufferNumber = rv_buf.getInt(0);
        return actualBufferNumber;
    }

    private static native void _IMAQdxGrab(int var0, long var1, int var3, long var4);

    public static void IMAQdxDiscoverEthernetCameras(String address, int timeout) {
        ByteBuffer address_buf = null;
        if (address != null) {
            byte[] address_bytes;
            try {
                address_bytes = address.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                address_bytes = new byte[]{};
            }
            address_buf = ByteBuffer.allocateDirect(address_bytes.length + 1);
            NIVision.putBytes(address_buf, address_bytes, 0, address_bytes.length).put(address_bytes.length, (byte)0);
        }
        NIVision._IMAQdxDiscoverEthernetCameras(address == null ? 0L : NIVision.getByteBufferAddress(address_buf), timeout);
    }

    private static native void _IMAQdxDiscoverEthernetCameras(long var0, int var2);

    public static void IMAQdxResetCamera(String name, int resetAll) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        NIVision._IMAQdxResetCamera(name == null ? 0L : NIVision.getByteBufferAddress(name_buf), resetAll);
    }

    private static native void _IMAQdxResetCamera(long var0, int var2);

    public static int IMAQdxOpenCamera(String name, IMAQdxCameraControlMode mode) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxOpenCamera(name == null ? 0L : NIVision.getByteBufferAddress(name_buf), mode.getValue(), rv_addr + 0L);
        int id = rv_buf.getInt(0);
        return id;
    }

    private static native void _IMAQdxOpenCamera(long var0, int var2, long var3);

    public static void IMAQdxCloseCamera(int id) {
        NIVision._IMAQdxCloseCamera(id);
    }

    private static native void _IMAQdxCloseCamera(int var0);

    public static void IMAQdxConfigureAcquisition(int id, int continuous, int bufferCount) {
        NIVision._IMAQdxConfigureAcquisition(id, continuous, bufferCount);
    }

    private static native void _IMAQdxConfigureAcquisition(int var0, int var1, int var2);

    public static void IMAQdxStartAcquisition(int id) {
        NIVision._IMAQdxStartAcquisition(id);
    }

    private static native void _IMAQdxStartAcquisition(int var0);

    public static int IMAQdxGetImage(int id, Image image, IMAQdxBufferNumberMode mode, int desiredBufferNumber) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetImage(id, image.getAddress(), mode.getValue(), desiredBufferNumber, rv_addr + 0L);
        int actualBufferNumber = rv_buf.getInt(0);
        return actualBufferNumber;
    }

    private static native void _IMAQdxGetImage(int var0, long var1, int var3, int var4, long var5);

    public static int IMAQdxGetImageData(int id, ByteBuffer buffer, IMAQdxBufferNumberMode mode, int desiredBufferNumber) {
        long buffer_addr = NIVision.getByteBufferAddress(buffer);
        int buffer_size = buffer.capacity();
        return NIVision._IMAQdxGetImageData(id, buffer_addr, buffer_size, mode.getValue(), desiredBufferNumber);
    }

    private static native int _IMAQdxGetImageData(int var0, long var1, int var3, int var4, int var5);

    public static void IMAQdxStopAcquisition(int id) {
        NIVision._IMAQdxStopAcquisition(id);
    }

    private static native void _IMAQdxStopAcquisition(int var0);

    public static void IMAQdxUnconfigureAcquisition(int id) {
        NIVision._IMAQdxUnconfigureAcquisition(id);
    }

    private static native void _IMAQdxUnconfigureAcquisition(int var0);

    public static dxEnumerateVideoModesResult IMAQdxEnumerateVideoModes(int id) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxEnumerateVideoModes(id, 0L, rv_addr + 0L, rv_addr + 8L);
        int count = rv_buf.getInt(0);
        ByteBuffer videoModeArray_buf = ByteBuffer.allocateDirect(count * 520).order(ByteOrder.nativeOrder());
        NIVision._IMAQdxEnumerateVideoModes(id, NIVision.getByteBufferAddress(videoModeArray_buf), rv_addr + 0L, rv_addr + 8L);
        dxEnumerateVideoModesResult rv = new dxEnumerateVideoModesResult(rv_buf, videoModeArray_buf);
        return rv;
    }

    private static native void _IMAQdxEnumerateVideoModes(int var0, long var1, long var3, long var5);

    public static IMAQdxAttributeType IMAQdxGetAttributeType(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeType(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        IMAQdxAttributeType type = IMAQdxAttributeType.fromValue(rv_buf.getInt(0));
        return type;
    }

    private static native void _IMAQdxGetAttributeType(int var0, long var1, long var3);

    public static int IMAQdxIsAttributeReadable(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxIsAttributeReadable(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        int readable = rv_buf.getInt(0);
        return readable;
    }

    private static native void _IMAQdxIsAttributeReadable(int var0, long var1, long var3);

    public static int IMAQdxIsAttributeWritable(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxIsAttributeWritable(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        int writable = rv_buf.getInt(0);
        return writable;
    }

    private static native void _IMAQdxIsAttributeWritable(int var0, long var1, long var3);

    public static void IMAQdxWriteRegister(int id, int offset, int value) {
        NIVision._IMAQdxWriteRegister(id, offset, value);
    }

    private static native void _IMAQdxWriteRegister(int var0, int var1, int var2);

    public static int IMAQdxReadRegister(int id, int offset) {
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxReadRegister(id, offset, rv_addr + 0L);
        int value = rv_buf.getInt(0);
        return value;
    }

    private static native void _IMAQdxReadRegister(int var0, int var1, long var2);

    public static void IMAQdxWriteAttributes(int id, String filename) {
        ByteBuffer filename_buf = null;
        if (filename != null) {
            byte[] filename_bytes;
            try {
                filename_bytes = filename.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                filename_bytes = new byte[]{};
            }
            filename_buf = ByteBuffer.allocateDirect(filename_bytes.length + 1);
            NIVision.putBytes(filename_buf, filename_bytes, 0, filename_bytes.length).put(filename_bytes.length, (byte)0);
        }
        NIVision._IMAQdxWriteAttributes(id, filename == null ? 0L : NIVision.getByteBufferAddress(filename_buf));
    }

    private static native void _IMAQdxWriteAttributes(int var0, long var1);

    public static void IMAQdxReadAttributes(int id, String filename) {
        ByteBuffer filename_buf = null;
        if (filename != null) {
            byte[] filename_bytes;
            try {
                filename_bytes = filename.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                filename_bytes = new byte[]{};
            }
            filename_buf = ByteBuffer.allocateDirect(filename_bytes.length + 1);
            NIVision.putBytes(filename_buf, filename_bytes, 0, filename_bytes.length).put(filename_bytes.length, (byte)0);
        }
        NIVision._IMAQdxReadAttributes(id, filename == null ? 0L : NIVision.getByteBufferAddress(filename_buf));
    }

    private static native void _IMAQdxReadAttributes(int var0, long var1);

    public static void IMAQdxResetEthernetCameraAddress(String name, String address, String subnet, String gateway, int timeout) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer address_buf = null;
        if (address != null) {
            byte[] address_bytes;
            try {
                address_bytes = address.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                address_bytes = new byte[]{};
            }
            address_buf = ByteBuffer.allocateDirect(address_bytes.length + 1);
            NIVision.putBytes(address_buf, address_bytes, 0, address_bytes.length).put(address_bytes.length, (byte)0);
        }
        ByteBuffer subnet_buf = null;
        if (subnet != null) {
            byte[] subnet_bytes;
            try {
                subnet_bytes = subnet.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                subnet_bytes = new byte[]{};
            }
            subnet_buf = ByteBuffer.allocateDirect(subnet_bytes.length + 1);
            NIVision.putBytes(subnet_buf, subnet_bytes, 0, subnet_bytes.length).put(subnet_bytes.length, (byte)0);
        }
        ByteBuffer gateway_buf = null;
        if (gateway != null) {
            byte[] gateway_bytes;
            try {
                gateway_bytes = gateway.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                gateway_bytes = new byte[]{};
            }
            gateway_buf = ByteBuffer.allocateDirect(gateway_bytes.length + 1);
            NIVision.putBytes(gateway_buf, gateway_bytes, 0, gateway_bytes.length).put(gateway_bytes.length, (byte)0);
        }
        NIVision._IMAQdxResetEthernetCameraAddress(name == null ? 0L : NIVision.getByteBufferAddress(name_buf), address == null ? 0L : NIVision.getByteBufferAddress(address_buf), subnet == null ? 0L : NIVision.getByteBufferAddress(subnet_buf), gateway == null ? 0L : NIVision.getByteBufferAddress(gateway_buf), timeout);
    }

    private static native void _IMAQdxResetEthernetCameraAddress(long var0, long var2, long var4, long var6, int var8);

    public static IMAQdxAttributeVisibility IMAQdxGetAttributeVisibility(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeVisibility(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        IMAQdxAttributeVisibility visibility = IMAQdxAttributeVisibility.fromValue(rv_buf.getInt(0));
        return visibility;
    }

    private static native void _IMAQdxGetAttributeVisibility(int var0, long var1, long var3);

    public static int IMAQdxGetAttributeU32(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeU32(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        int value = rv_buf.getInt(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeU32(int var0, long var1, long var3);

    public static long IMAQdxGetAttributeI64(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeI64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        long value = rv_buf.getLong(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeI64(int var0, long var1, long var3);

    public static double IMAQdxGetAttributeF64(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeF64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        double value = rv_buf.getDouble(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeF64(int var0, long var1, long var3);

    public static String IMAQdxGetAttributeString(int id, String name) {
        String value;
        int len;
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(512).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeString(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        byte[] bytes = new byte[512];
        NIVision.getBytes(rv_buf, bytes, 0, 512);
        for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
        }
        try {
            value = new String(bytes, 0, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            value = "";
        }
        return value;
    }

    private static native void _IMAQdxGetAttributeString(int var0, long var1, long var3);

    public static IMAQdxEnumItem IMAQdxGetAttributeEnum(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeEnum(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        IMAQdxEnumItem value = new IMAQdxEnumItem(rv_buf, 0);
        value.read();
        return value;
    }

    private static native void _IMAQdxGetAttributeEnum(int var0, long var1, long var3);

    public static int IMAQdxGetAttributeBool(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeBool(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        int value = rv_buf.getInt(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeBool(int var0, long var1, long var3);

    public static int IMAQdxGetAttributeMinimumU32(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeMinimumU32(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        int value = rv_buf.getInt(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeMinimumU32(int var0, long var1, long var3);

    public static long IMAQdxGetAttributeMinimumI64(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeMinimumI64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        long value = rv_buf.getLong(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeMinimumI64(int var0, long var1, long var3);

    public static double IMAQdxGetAttributeMinimumF64(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeMinimumF64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        double value = rv_buf.getDouble(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeMinimumF64(int var0, long var1, long var3);

    public static int IMAQdxGetAttributeMaximumU32(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeMaximumU32(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        int value = rv_buf.getInt(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeMaximumU32(int var0, long var1, long var3);

    public static long IMAQdxGetAttributeMaximumI64(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeMaximumI64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        long value = rv_buf.getLong(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeMaximumI64(int var0, long var1, long var3);

    public static double IMAQdxGetAttributeMaximumF64(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeMaximumF64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        double value = rv_buf.getDouble(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeMaximumF64(int var0, long var1, long var3);

    public static int IMAQdxGetAttributeIncrementU32(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeIncrementU32(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        int value = rv_buf.getInt(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeIncrementU32(int var0, long var1, long var3);

    public static long IMAQdxGetAttributeIncrementI64(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeIncrementI64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        long value = rv_buf.getLong(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeIncrementI64(int var0, long var1, long var3);

    public static double IMAQdxGetAttributeIncrementF64(int id, String name) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer rv_buf = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
        long rv_addr = NIVision.getByteBufferAddress(rv_buf);
        NIVision._IMAQdxGetAttributeIncrementF64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), rv_addr + 0L);
        double value = rv_buf.getDouble(0);
        return value;
    }

    private static native void _IMAQdxGetAttributeIncrementF64(int var0, long var1, long var3);

    public static void IMAQdxSetAttributeU32(int id, String name, int value) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        NIVision._IMAQdxSetAttributeU32(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), value);
    }

    private static native void _IMAQdxSetAttributeU32(int var0, long var1, int var3);

    public static void IMAQdxSetAttributeI64(int id, String name, long value) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        NIVision._IMAQdxSetAttributeI64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), value);
    }

    private static native void _IMAQdxSetAttributeI64(int var0, long var1, long var3);

    public static void IMAQdxSetAttributeF64(int id, String name, double value) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        NIVision._IMAQdxSetAttributeF64(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), value);
    }

    private static native void _IMAQdxSetAttributeF64(int var0, long var1, double var3);

    public static void IMAQdxSetAttributeString(int id, String name, String value) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        ByteBuffer value_buf = null;
        if (value != null) {
            byte[] value_bytes;
            try {
                value_bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                value_bytes = new byte[]{};
            }
            value_buf = ByteBuffer.allocateDirect(value_bytes.length + 1);
            NIVision.putBytes(value_buf, value_bytes, 0, value_bytes.length).put(value_bytes.length, (byte)0);
        }
        NIVision._IMAQdxSetAttributeString(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), value == null ? 0L : NIVision.getByteBufferAddress(value_buf));
    }

    private static native void _IMAQdxSetAttributeString(int var0, long var1, long var3);

    public static void IMAQdxSetAttributeEnum(int id, String name, IMAQdxEnumItem value) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        NIVision._IMAQdxSetAttributeEnum(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), value.getAddress());
    }

    private static native void _IMAQdxSetAttributeEnum(int var0, long var1, long var3);

    public static void IMAQdxSetAttributeBool(int id, String name, int value) {
        ByteBuffer name_buf = null;
        if (name != null) {
            byte[] name_bytes;
            try {
                name_bytes = name.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name_bytes = new byte[]{};
            }
            name_buf = ByteBuffer.allocateDirect(name_bytes.length + 1);
            NIVision.putBytes(name_buf, name_bytes, 0, name_bytes.length).put(name_bytes.length, (byte)0);
        }
        NIVision._IMAQdxSetAttributeBool(id, name == null ? 0L : NIVision.getByteBufferAddress(name_buf), value);
    }

    private static native void _IMAQdxSetAttributeBool(int var0, long var1, int var3);

    static {
        try {
            Class[] cArg = new Class[]{Long.TYPE, Integer.TYPE};
            constructDirectByteBuffer = Class.forName("java.nio.DirectByteBuffer").getDeclaredConstructor(cArg);
            constructDirectByteBuffer.setAccessible(true);
            bufferAddressField = Buffer.class.getDeclaredField("address");
            bufferAddressField.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        ANY_CHARACTER = new byte[]{0};
        ALPHABETIC = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 0};
        ALPHANUMERIC = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0};
        UPPERCASE_LETTERS = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0};
        LOWERCASE_LETTERS = new byte[]{97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 0};
        DECIMAL_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0};
        HEXADECIMAL_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 97, 98, 99, 100, 101, 102, 0};
        PATTERN = new byte[]{92, 120, 70, 70, 0};
        FORCE_SPACE = new byte[]{32, 0};
        NO_RECT = new Rect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        NO_ROTATED_RECT = new RotatedRect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, 0.0);
        NO_POINT = new Point(-1, -1);
        NO_POINT_FLOAT = new PointFloat(-1.0, -1.0);
        NO_OFFSET = new PointFloat(0.0, 0.0);
        RGB_TRANSPARENT = new RGBValue(0, 0, 0, 1);
        RGB_RED = new RGBValue(0, 0, 255, 0);
        RGB_BLUE = new RGBValue(255, 0, 0, 0);
        RGB_GREEN = new RGBValue(0, 255, 0, 0);
        RGB_YELLOW = new RGBValue(0, 255, 255, 0);
        RGB_WHITE = new RGBValue(255, 255, 255, 0);
        RGB_BLACK = new RGBValue(0, 0, 0, 0);
    }

    public static class dxEnumerateVideoModesResult {
        public IMAQdxEnumItem[] videoModeArray;
        public int currentMode;
        private ByteBuffer videoModeArray_buf;

        private dxEnumerateVideoModesResult(ByteBuffer rv_buf, ByteBuffer videoModeArray_buf) {
            this.videoModeArray_buf = videoModeArray_buf;
            int count = rv_buf.getInt(0);
            this.videoModeArray = new IMAQdxEnumItem[count];
            int i = 0;
            int off = 0;
            while (i < count) {
                this.videoModeArray[i] = new IMAQdxEnumItem(videoModeArray_buf, off);
                this.videoModeArray[i].read();
                ++i;
                off += 520;
            }
            this.currentMode = rv_buf.getInt(8);
        }
    }

    public static class IMAQdxEnumItem
    extends DisposedStruct {
        public int Value;
        public int Reserved;
        public String Name;

        private void init() {
        }

        public IMAQdxEnumItem() {
            super(520);
            this.init();
        }

        public IMAQdxEnumItem(int Value2, int Reserved, String Name) {
            super(520);
            this.Value = Value2;
            this.Reserved = Reserved;
            this.Name = Name;
        }

        protected IMAQdxEnumItem(ByteBuffer backing, int offset) {
            super(backing, offset, 520);
            this.init();
        }

        protected IMAQdxEnumItem(long nativeObj, boolean owned) {
            super(nativeObj, owned, 520);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 520);
        }

        @Override
        public void read() {
            int len;
            this.Value = this.backing.getInt(0);
            this.Reserved = this.backing.getInt(4);
            byte[] bytes = new byte[512];
            NIVision.getBytes(this.backing, bytes, 8, 512);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.Name = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.Name = "";
            }
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.Value);
            this.backing.putInt(4, this.Reserved);
            if (this.Name != null) {
                byte[] bytes;
                try {
                    bytes = this.Name.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 8, bytes.length);
                for (int i = bytes.length; i < 512; ++i) {
                    this.backing.put(i, (byte)0);
                }
            }
        }

        @Override
        public int size() {
            return 520;
        }
    }

    public static class IMAQdxAttributeInformation
    extends DisposedStruct {
        public IMAQdxAttributeType Type;
        public int Readable;
        public int Writable;
        public String Name;

        private void init() {
        }

        public IMAQdxAttributeInformation() {
            super(524);
            this.init();
        }

        public IMAQdxAttributeInformation(IMAQdxAttributeType Type2, int Readable, int Writable, String Name) {
            super(524);
            this.Type = Type2;
            this.Readable = Readable;
            this.Writable = Writable;
            this.Name = Name;
        }

        protected IMAQdxAttributeInformation(ByteBuffer backing, int offset) {
            super(backing, offset, 524);
            this.init();
        }

        protected IMAQdxAttributeInformation(long nativeObj, boolean owned) {
            super(nativeObj, owned, 524);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 524);
        }

        @Override
        public void read() {
            int len;
            this.Type = IMAQdxAttributeType.fromValue(this.backing.getInt(0));
            this.Readable = this.backing.getInt(4);
            this.Writable = this.backing.getInt(8);
            byte[] bytes = new byte[512];
            NIVision.getBytes(this.backing, bytes, 12, 512);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.Name = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.Name = "";
            }
        }

        @Override
        public void write() {
            if (this.Type != null) {
                this.backing.putInt(0, this.Type.getValue());
            }
            this.backing.putInt(4, this.Readable);
            this.backing.putInt(8, this.Writable);
            if (this.Name != null) {
                byte[] bytes;
                try {
                    bytes = this.Name.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 12, bytes.length);
                for (int i = bytes.length; i < 512; ++i) {
                    this.backing.put(i, (byte)0);
                }
            }
        }

        @Override
        public int size() {
            return 524;
        }
    }

    public static class IMAQdxCameraFile
    extends DisposedStruct {
        public int Type;
        public int Version;
        public String FileName;

        private void init() {
        }

        public IMAQdxCameraFile() {
            super(520);
            this.init();
        }

        public IMAQdxCameraFile(int Type2, int Version, String FileName) {
            super(520);
            this.Type = Type2;
            this.Version = Version;
            this.FileName = FileName;
        }

        protected IMAQdxCameraFile(ByteBuffer backing, int offset) {
            super(backing, offset, 520);
            this.init();
        }

        protected IMAQdxCameraFile(long nativeObj, boolean owned) {
            super(nativeObj, owned, 520);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 520);
        }

        @Override
        public void read() {
            int len;
            this.Type = this.backing.getInt(0);
            this.Version = this.backing.getInt(4);
            byte[] bytes = new byte[512];
            NIVision.getBytes(this.backing, bytes, 8, 512);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.FileName = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.FileName = "";
            }
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.Type);
            this.backing.putInt(4, this.Version);
            if (this.FileName != null) {
                byte[] bytes;
                try {
                    bytes = this.FileName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 8, bytes.length);
                for (int i = bytes.length; i < 512; ++i) {
                    this.backing.put(i, (byte)0);
                }
            }
        }

        @Override
        public int size() {
            return 520;
        }
    }

    public static class IMAQdxCameraInformation
    extends DisposedStruct {
        public int Type;
        public int Version;
        public int Flags;
        public int SerialNumberHi;
        public int SerialNumberLo;
        public IMAQdxBusType BusType;
        public String InterfaceName;
        public String VendorName;
        public String ModelName;
        public String CameraFileName;
        public String CameraAttributeURL;

        private void init() {
        }

        public IMAQdxCameraInformation() {
            super(2584);
            this.init();
        }

        public IMAQdxCameraInformation(int Type2, int Version, int Flags, int SerialNumberHi, int SerialNumberLo, IMAQdxBusType BusType, String InterfaceName, String VendorName, String ModelName, String CameraFileName, String CameraAttributeURL) {
            super(2584);
            this.Type = Type2;
            this.Version = Version;
            this.Flags = Flags;
            this.SerialNumberHi = SerialNumberHi;
            this.SerialNumberLo = SerialNumberLo;
            this.BusType = BusType;
            this.InterfaceName = InterfaceName;
            this.VendorName = VendorName;
            this.ModelName = ModelName;
            this.CameraFileName = CameraFileName;
            this.CameraAttributeURL = CameraAttributeURL;
        }

        protected IMAQdxCameraInformation(ByteBuffer backing, int offset) {
            super(backing, offset, 2584);
            this.init();
        }

        protected IMAQdxCameraInformation(long nativeObj, boolean owned) {
            super(nativeObj, owned, 2584);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 2584);
        }

        @Override
        public void read() {
            int len;
            this.Type = this.backing.getInt(0);
            this.Version = this.backing.getInt(4);
            this.Flags = this.backing.getInt(8);
            this.SerialNumberHi = this.backing.getInt(12);
            this.SerialNumberLo = this.backing.getInt(16);
            this.BusType = IMAQdxBusType.fromValue(this.backing.getInt(20));
            byte[] bytes = new byte[512];
            NIVision.getBytes(this.backing, bytes, 24, 512);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.InterfaceName = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.InterfaceName = "";
            }
            bytes = new byte[512];
            NIVision.getBytes(this.backing, bytes, 536, 512);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.VendorName = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.VendorName = "";
            }
            bytes = new byte[512];
            NIVision.getBytes(this.backing, bytes, 1048, 512);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.ModelName = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.ModelName = "";
            }
            bytes = new byte[512];
            NIVision.getBytes(this.backing, bytes, 1560, 512);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.CameraFileName = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.CameraFileName = "";
            }
            bytes = new byte[512];
            NIVision.getBytes(this.backing, bytes, 2072, 512);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.CameraAttributeURL = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.CameraAttributeURL = "";
            }
        }

        @Override
        public void write() {
            int i;
            byte[] bytes;
            this.backing.putInt(0, this.Type);
            this.backing.putInt(4, this.Version);
            this.backing.putInt(8, this.Flags);
            this.backing.putInt(12, this.SerialNumberHi);
            this.backing.putInt(16, this.SerialNumberLo);
            if (this.BusType != null) {
                this.backing.putInt(20, this.BusType.getValue());
            }
            if (this.InterfaceName != null) {
                try {
                    bytes = this.InterfaceName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 24, bytes.length);
                for (i = bytes.length; i < 512; ++i) {
                    this.backing.put(i, (byte)0);
                }
            }
            if (this.VendorName != null) {
                try {
                    bytes = this.VendorName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 536, bytes.length);
                for (i = bytes.length; i < 512; ++i) {
                    this.backing.put(i, (byte)0);
                }
            }
            if (this.ModelName != null) {
                try {
                    bytes = this.ModelName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 1048, bytes.length);
                for (i = bytes.length; i < 512; ++i) {
                    this.backing.put(i, (byte)0);
                }
            }
            if (this.CameraFileName != null) {
                try {
                    bytes = this.CameraFileName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 1560, bytes.length);
                for (i = bytes.length; i < 512; ++i) {
                    this.backing.put(i, (byte)0);
                }
            }
            if (this.CameraAttributeURL != null) {
                try {
                    bytes = this.CameraAttributeURL.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 2072, bytes.length);
                for (int i2 = bytes.length; i2 < 512; ++i2) {
                    this.backing.put(i2, (byte)0);
                }
            }
        }

        @Override
        public int size() {
            return 2584;
        }
    }

    public static enum IMAQdxUSBConnectionSpeed {
        USBConnectionSpeedLow(1),
        USBConnectionSpeedFull(2),
        USBConnectionSpeedHigh(4),
        USBConnectionSpeedSuper(8),
        USBConnectionSpeedGuard(-1);

        private final int value;

        private IMAQdxUSBConnectionSpeed(int value) {
            this.value = value;
        }

        public static IMAQdxUSBConnectionSpeed fromValue(int val) {
            for (IMAQdxUSBConnectionSpeed v : IMAQdxUSBConnectionSpeed.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxPixelSignedness {
        PixelSignednessUnsigned(0),
        PixelSignednessSigned(1),
        PixelSignednessHardware(2),
        PixelSignednessGuard(-1);

        private final int value;

        private IMAQdxPixelSignedness(int value) {
            this.value = value;
        }

        public static IMAQdxPixelSignedness fromValue(int val) {
            for (IMAQdxPixelSignedness v : IMAQdxPixelSignedness.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxStreamChannelMode {
        StreamChannelModeAutomatic(0),
        StreamChannelModeManual(1),
        StreamChannelModeGuard(-1);

        private final int value;

        private IMAQdxStreamChannelMode(int value) {
            this.value = value;
        }

        public static IMAQdxStreamChannelMode fromValue(int val) {
            for (IMAQdxStreamChannelMode v : IMAQdxStreamChannelMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxAttributeVisibility {
        AttributeVisibilitySimple(4096),
        AttributeVisibilityIntermediate(8192),
        AttributeVisibilityAdvanced(16384),
        AttributeVisibilityGuard(-1);

        private final int value;

        private IMAQdxAttributeVisibility(int value) {
            this.value = value;
        }

        public static IMAQdxAttributeVisibility fromValue(int val) {
            for (IMAQdxAttributeVisibility v : IMAQdxAttributeVisibility.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxLostPacketMode {
        LostPacketModeIgnore(0),
        LostPacketModeFail(1),
        LostPacketModeGuard(-1);

        private final int value;

        private IMAQdxLostPacketMode(int value) {
            this.value = value;
        }

        public static IMAQdxLostPacketMode fromValue(int val) {
            for (IMAQdxLostPacketMode v : IMAQdxLostPacketMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxIncompleteBufferMode {
        IncompleteBufferModeIgnore(0),
        IncompleteBufferModeFail(1),
        IncompleteBufferModeGuard(-1);

        private final int value;

        private IMAQdxIncompleteBufferMode(int value) {
            this.value = value;
        }

        public static IMAQdxIncompleteBufferMode fromValue(int val) {
            for (IMAQdxIncompleteBufferMode v : IMAQdxIncompleteBufferMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxOverwriteMode {
        OverwriteModeGetOldest(0),
        OverwriteModeFail(2),
        OverwriteModeGetNewest(3),
        OverwriteModeGuard(-1);

        private final int value;

        private IMAQdxOverwriteMode(int value) {
            this.value = value;
        }

        public static IMAQdxOverwriteMode fromValue(int val) {
            for (IMAQdxOverwriteMode v : IMAQdxOverwriteMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxInterfaceFileFlags {
        InterfaceFileFlagsConnected(1),
        InterfaceFileFlagsDirty(2),
        InterfaceFileFlagsGuard(-1);

        private final int value;

        private IMAQdxInterfaceFileFlags(int value) {
            this.value = value;
        }

        public static IMAQdxInterfaceFileFlags fromValue(int val) {
            for (IMAQdxInterfaceFileFlags v : IMAQdxInterfaceFileFlags.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxValueType {
        ValueTypeU32(0),
        ValueTypeI64(1),
        ValueTypeF64(2),
        ValueTypeString(3),
        ValueTypeEnumItem(4),
        ValueTypeBool(5),
        ValueTypeDisposableString(6),
        ValueTypeGuard(-1);

        private final int value;

        private IMAQdxValueType(int value) {
            this.value = value;
        }

        public static IMAQdxValueType fromValue(int val) {
            for (IMAQdxValueType v : IMAQdxValueType.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxAttributeType {
        AttributeTypeU32(0),
        AttributeTypeI64(1),
        AttributeTypeF64(2),
        AttributeTypeString(3),
        AttributeTypeEnum(4),
        AttributeTypeBool(5),
        AttributeTypeCommand(6),
        AttributeTypeBlob(7),
        AttributeTypeGuard(-1);

        private final int value;

        private IMAQdxAttributeType(int value) {
            this.value = value;
        }

        public static IMAQdxAttributeType fromValue(int val) {
            for (IMAQdxAttributeType v : IMAQdxAttributeType.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxDestinationMode {
        DestinationModeUnicast(0),
        DestinationModeBroadcast(1),
        DestinationModeMulticast(2),
        DestinationModeGuard(-1);

        private final int value;

        private IMAQdxDestinationMode(int value) {
            this.value = value;
        }

        public static IMAQdxDestinationMode fromValue(int val) {
            for (IMAQdxDestinationMode v : IMAQdxDestinationMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxOutputImageType {
        OutputImageTypeU8(0),
        OutputImageTypeI16(1),
        OutputImageTypeU16(7),
        OutputImageTypeRGB32(4),
        OutputImageTypeRGB64(6),
        OutputImageTypeAuto(Integer.MAX_VALUE),
        OutputImageTypeGuard(-1);

        private final int value;

        private IMAQdxOutputImageType(int value) {
            this.value = value;
        }

        public static IMAQdxOutputImageType fromValue(int val) {
            for (IMAQdxOutputImageType v : IMAQdxOutputImageType.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxBayerAlgorithm {
        BayerAlgorithmBilinear(0),
        BayerAlgorithmVNG(1),
        BayerAlgorithmGuard(-1);

        private final int value;

        private IMAQdxBayerAlgorithm(int value) {
            this.value = value;
        }

        public static IMAQdxBayerAlgorithm fromValue(int val) {
            for (IMAQdxBayerAlgorithm v : IMAQdxBayerAlgorithm.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxBayerPattern {
        BayerPatternNone(0),
        BayerPatternGB(1),
        BayerPatternGR(2),
        BayerPatternBG(3),
        BayerPatternRG(4),
        BayerPatternHardware(5),
        BayerPatternGuard(-1);

        private final int value;

        private IMAQdxBayerPattern(int value) {
            this.value = value;
        }

        public static IMAQdxBayerPattern fromValue(int val) {
            for (IMAQdxBayerPattern v : IMAQdxBayerPattern.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxPnpEvent {
        PnpEventCameraAttached(0),
        PnpEventCameraDetached(1),
        PnpEventBusReset(2),
        PnpEventGuard(-1);

        private final int value;

        private IMAQdxPnpEvent(int value) {
            this.value = value;
        }

        public static IMAQdxPnpEvent fromValue(int val) {
            for (IMAQdxPnpEvent v : IMAQdxPnpEvent.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxBufferNumberMode {
        BufferNumberModeNext(0),
        BufferNumberModeLast(1),
        BufferNumberModeBufferNumber(2),
        BufferNumberModeGuard(-1);

        private final int value;

        private IMAQdxBufferNumberMode(int value) {
            this.value = value;
        }

        public static IMAQdxBufferNumberMode fromValue(int val) {
            for (IMAQdxBufferNumberMode v : IMAQdxBufferNumberMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxCameraControlMode {
        CameraControlModeController(0),
        CameraControlModeListener(1),
        CameraControlModeGuard(-1);

        private final int value;

        private IMAQdxCameraControlMode(int value) {
            this.value = value;
        }

        public static IMAQdxCameraControlMode fromValue(int val) {
            for (IMAQdxCameraControlMode v : IMAQdxCameraControlMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IMAQdxBusType {
        BusTypeFireWire(825440564),
        BusTypeEthernet(1768977972),
        BusTypeSimulator(544434541),
        BusTypeDirectShow(1685284983),
        BusTypeIP(1230005101),
        BusTypeSmartCam2(1396924722),
        BusTypeUSB3Vision(1431519795),
        BusTypeUVC(1431716640),
        BusTypeGuard(-1);

        private final int value;

        private IMAQdxBusType(int value) {
            this.value = value;
        }

        public static IMAQdxBusType fromValue(int val) {
            for (IMAQdxBusType v : IMAQdxBusType.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class MatchPattern2Result {
        public PatternMatch[] array;
        private long array_addr;

        private MatchPattern2Result(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatches = rv_buf.getInt(0);
            this.array = new PatternMatch[array_numMatches];
            if (array_numMatches > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatches * 52);
                int i = 0;
                int off = 0;
                while (i < array_numMatches) {
                    this.array[i] = new PatternMatch(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 52;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class GetParticleClassifierOptionsResult {
        public ParticleClassifierPreprocessingOptions preprocessingOptions;
        public ParticleClassifierOptions options;

        private GetParticleClassifierOptionsResult(ByteBuffer rv_buf) {
            this.preprocessingOptions = new ParticleClassifierPreprocessingOptions(rv_buf, 0);
            this.preprocessingOptions.read();
            this.options = new ParticleClassifierOptions(rv_buf, 8);
            this.options.read();
        }
    }

    public static class ReadClassifierFileResult {
        public ClassifierType type;
        public ClassifierEngineType engine;
        public ClassifierSession val;

        private ReadClassifierFileResult(ByteBuffer rv_buf) {
            this.type = ClassifierType.fromValue(rv_buf.getInt(0));
            this.engine = ClassifierEngineType.fromValue(rv_buf.getInt(8));
        }
    }

    public static class GetParticleClassifierOptions2Result {
        public ParticleClassifierPreprocessingOptions2 preprocessingOptions;
        public ParticleClassifierOptions options;

        private GetParticleClassifierOptions2Result(ByteBuffer rv_buf) {
            this.preprocessingOptions = new ParticleClassifierPreprocessingOptions2(rv_buf, 0);
            this.preprocessingOptions.read();
            this.options = new ParticleClassifierOptions(rv_buf, 8);
            this.options.read();
        }
    }

    public static class GetClassifierSampleInfoResult {
        public int numSamples;
        public ClassifierSampleInfo val;

        private GetClassifierSampleInfoResult(ByteBuffer rv_buf) {
            this.numSamples = rv_buf.getInt(0);
        }
    }

    public static class MaskToROIResult {
        public int withinLimit;
        public ROI val;

        private MaskToROIResult(ByteBuffer rv_buf) {
            this.withinLimit = rv_buf.getInt(0);
        }
    }

    public static class ContourSetupMatchPatternResult {
        public MatchMode matchMode;
        public CurveParameters curveParams;
        public SetupMatchPatternData val;

        private ContourSetupMatchPatternResult(ByteBuffer rv_buf) {
            this.matchMode = new MatchMode(rv_buf, 0);
            this.matchMode.read();
            this.curveParams = new CurveParameters(rv_buf, 8);
            this.curveParams.read();
        }
    }

    public static class ExtractContourResult {
        public CurveParameters curveParams;
        public ExtractContourReport val;

        private ExtractContourResult(ByteBuffer rv_buf) {
            this.curveParams = new CurveParameters(rv_buf, 0);
            this.curveParams.read();
        }
    }

    public static class VerifyTextResult {
        public int[] array;
        private long array_addr;

        private VerifyTextResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numScores = rv_buf.getInt(0);
            this.array = new int[array_numScores];
            if (array_numScores > 0 && this.array_addr != 0L) {
                NIVision.newDirectByteBuffer(this.array_addr, array_numScores * 4).asIntBuffer().get(this.array);
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class ReadOCRFileResult {
        public ReadTextOptions readOptions;
        public OCRProcessingOptions processingOptions;
        public OCRSpacingOptions spacingOptions;

        private ReadOCRFileResult(ByteBuffer rv_buf) {
            this.readOptions = new ReadTextOptions(rv_buf, 0);
            this.readOptions.read();
            this.processingOptions = new OCRProcessingOptions(rv_buf, 8);
            this.processingOptions.read();
            this.spacingOptions = new OCRSpacingOptions(rv_buf, 16);
            this.spacingOptions.read();
        }
    }

    public static class MatchPattern3Result {
        public PatternMatch[] array;
        private long array_addr;

        private MatchPattern3Result(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatches = rv_buf.getInt(0);
            this.array = new PatternMatch[array_numMatches];
            if (array_numMatches > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatches * 52);
                int i = 0;
                int off = 0;
                while (i < array_numMatches) {
                    this.array[i] = new PatternMatch(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 52;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class MatchGeometricPattern3Result {
        public GeometricPatternMatch3[] array;
        private long array_addr;

        private MatchGeometricPattern3Result(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatches = rv_buf.getInt(0);
            this.array = new GeometricPatternMatch3[array_numMatches];
            if (array_numMatches > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatches * 116);
                int i = 0;
                int off = 0;
                while (i < array_numMatches) {
                    this.array[i] = new GeometricPatternMatch3(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 116;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class RefineMatchesResult {
        public MatchPatternOptions options;
        public MatchPatternAdvancedOptions advancedOptions;
        public PatternMatch[] array;
        private long array_addr;

        private RefineMatchesResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            this.options = new MatchPatternOptions(rv_buf, 0);
            this.options.read();
            this.advancedOptions = new MatchPatternAdvancedOptions(rv_buf, 8);
            this.advancedOptions.read();
            int array_numCandidatesOut = rv_buf.getInt(16);
            this.array = new PatternMatch[array_numCandidatesOut];
            if (array_numCandidatesOut > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numCandidatesOut * 52);
                int i = 0;
                int off = 0;
                while (i < array_numCandidatesOut) {
                    this.array[i] = new PatternMatch(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 52;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class MatchMultipleGeometricPatternsResult {
        public GeometricPatternMatch2[] array;
        private long array_addr;

        private MatchMultipleGeometricPatternsResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatches = rv_buf.getInt(0);
            this.array = new GeometricPatternMatch2[array_numMatches];
            if (array_numMatches > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatches * 380);
                int i = 0;
                int off = 0;
                while (i < array_numMatches) {
                    this.array[i] = new GeometricPatternMatch2(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 380;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class MatchGeometricPattern2Result {
        public GeometricPatternMatch2[] array;
        private long array_addr;

        private MatchGeometricPattern2Result(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatches = rv_buf.getInt(0);
            this.array = new GeometricPatternMatch2[array_numMatches];
            if (array_numMatches > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatches * 380);
                int i = 0;
                int off = 0;
                while (i < array_numMatches) {
                    this.array[i] = new GeometricPatternMatch2(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 380;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class MatchColorPatternResult {
        public PatternMatch[] array;
        private long array_addr;

        private MatchColorPatternResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatches = rv_buf.getInt(0);
            this.array = new PatternMatch[array_numMatches];
            if (array_numMatches > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatches * 52);
                int i = 0;
                int off = 0;
                while (i < array_numMatches) {
                    this.array[i] = new PatternMatch(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 52;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class GetGeometricTemplateFeatureInfoResult {
        public FeatureData[] array;
        private long array_addr;

        private GetGeometricTemplateFeatureInfoResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numFeatures = rv_buf.getInt(0);
            this.array = new FeatureData[array_numFeatures];
            if (array_numFeatures > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numFeatures * 16);
                int i = 0;
                int off = 0;
                while (i < array_numFeatures) {
                    this.array[i] = new FeatureData(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 16;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class GetGeometricFeaturesFromCurvesResult {
        public FeatureData[] array;
        private long array_addr;

        private GetGeometricFeaturesFromCurvesResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numFeatures = rv_buf.getInt(0);
            this.array = new FeatureData[array_numFeatures];
            if (array_numFeatures > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numFeatures * 16);
                int i = 0;
                int off = 0;
                while (i < array_numFeatures) {
                    this.array[i] = new FeatureData(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 16;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class DetectRectanglesResult {
        public RectangleMatch[] array;
        private long array_addr;

        private DetectRectanglesResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatchesReturned = rv_buf.getInt(0);
            this.array = new RectangleMatch[array_numMatchesReturned];
            if (array_numMatchesReturned > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatchesReturned * 64);
                int i = 0;
                int off = 0;
                while (i < array_numMatchesReturned) {
                    this.array[i] = new RectangleMatch(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 64;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class DetectLinesResult {
        public LineMatch[] array;
        private long array_addr;

        private DetectLinesResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatchesReturned = rv_buf.getInt(0);
            this.array = new LineMatch[array_numMatchesReturned];
            if (array_numMatchesReturned > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatchesReturned * 40);
                int i = 0;
                int off = 0;
                while (i < array_numMatchesReturned) {
                    this.array[i] = new LineMatch(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 40;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class DetectEllipsesResult {
        public EllipseMatch[] array;
        private long array_addr;

        private DetectEllipsesResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatchesReturned = rv_buf.getInt(0);
            this.array = new EllipseMatch[array_numMatchesReturned];
            if (array_numMatchesReturned > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatchesReturned * 40);
                int i = 0;
                int off = 0;
                while (i < array_numMatchesReturned) {
                    this.array[i] = new EllipseMatch(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 40;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class DetectCirclesResult {
        public CircleMatch[] array;
        private long array_addr;

        private DetectCirclesResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatchesReturned = rv_buf.getInt(0);
            this.array = new CircleMatch[array_numMatchesReturned];
            if (array_numMatchesReturned > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatchesReturned * 24);
                int i = 0;
                int off = 0;
                while (i < array_numMatchesReturned) {
                    this.array[i] = new CircleMatch(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 24;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class ExtractCurvesResult {
        public Curve[] array;
        private long array_addr;

        private ExtractCurvesResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numCurves = rv_buf.getInt(0);
            this.array = new Curve[array_numCurves];
            if (array_numCurves > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numCurves * 48);
                int i = 0;
                int off = 0;
                while (i < array_numCurves) {
                    this.array[i] = new Curve(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 48;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class MatchShapeResult {
        public ShapeReport[] array;
        private long array_addr;

        private MatchShapeResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numMatches = rv_buf.getInt(0);
            this.array = new ShapeReport[array_numMatches];
            if (array_numMatches > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numMatches * 40);
                int i = 0;
                int off = 0;
                while (i < array_numMatches) {
                    this.array[i] = new ShapeReport(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 40;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class ReadPDF417BarcodeResult {
        public Barcode2DInfo[] array;
        private long array_addr;

        private ReadPDF417BarcodeResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numBarcodes = rv_buf.getInt(0);
            this.array = new Barcode2DInfo[array_numBarcodes];
            if (array_numBarcodes > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numBarcodes * 64);
                int i = 0;
                int off = 0;
                while (i < array_numBarcodes) {
                    this.array[i] = new Barcode2DInfo(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 64;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class MatchColorResult {
        public int[] array;
        private long array_addr;

        private MatchColorResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numScores = rv_buf.getInt(0);
            this.array = new int[array_numScores];
            if (array_numScores > 0 && this.array_addr != 0L) {
                NIVision.newDirectByteBuffer(this.array_addr, array_numScores * 4).asIntBuffer().get(this.array);
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class ReadMeterResult {
        public double percentage;
        public PointFloat endOfNeedle;

        private ReadMeterResult(ByteBuffer rv_buf) {
            this.percentage = rv_buf.getDouble(0);
            this.endOfNeedle = new PointFloat(rv_buf, 8);
            this.endOfNeedle.read();
        }
    }

    public static class InterpolatePointsResult {
        public float[] array;
        private long array_addr;

        private InterpolatePointsResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_interpCount = rv_buf.getInt(0);
            this.array = new float[array_interpCount];
            if (array_interpCount > 0 && this.array_addr != 0L) {
                NIVision.newDirectByteBuffer(this.array_addr, array_interpCount * 4).asFloatBuffer().get(this.array);
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class GetPointsOnLineResult {
        public Point[] array;
        private long array_addr;

        private GetPointsOnLineResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numPoints = rv_buf.getInt(0);
            this.array = new Point[array_numPoints];
            if (array_numPoints > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numPoints * 8);
                int i = 0;
                int off = 0;
                while (i < array_numPoints) {
                    this.array[i] = new Point(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 8;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class GetPointsOnContourResult {
        public SegmentInfo[] array;
        private long array_addr;

        private GetPointsOnContourResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numSegments = rv_buf.getInt(0);
            this.array = new SegmentInfo[array_numSegments];
            if (array_numSegments > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numSegments * 24);
                int i = 0;
                int off = 0;
                while (i < array_numSegments) {
                    this.array[i] = new SegmentInfo(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 24;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class GetPerpendicularLineResult {
        public PointFloat perpLineStart;
        public PointFloat perpLineEnd;
        public double distance;

        private GetPerpendicularLineResult(ByteBuffer rv_buf) {
            this.perpLineStart = new PointFloat(rv_buf, 0);
            this.perpLineStart.read();
            this.perpLineEnd = new PointFloat(rv_buf, 8);
            this.perpLineEnd.read();
            this.distance = rv_buf.getDouble(16);
        }
    }

    public static class GetMidLineResult {
        public PointFloat midLineStart;
        public PointFloat midLineEnd;

        private GetMidLineResult(ByteBuffer rv_buf) {
            this.midLineStart = new PointFloat(rv_buf, 0);
            this.midLineStart.read();
            this.midLineEnd = new PointFloat(rv_buf, 8);
            this.midLineEnd.read();
        }
    }

    public static class GetBisectingLineResult {
        public PointFloat bisectStart;
        public PointFloat bisectEnd;

        private GetBisectingLineResult(ByteBuffer rv_buf) {
            this.bisectStart = new PointFloat(rv_buf, 0);
            this.bisectStart.read();
            this.bisectEnd = new PointFloat(rv_buf, 8);
            this.bisectEnd.read();
        }
    }

    public static class ReadVisionFileResult {
        public RGBValue colorTable;
        public int numColors;

        private ReadVisionFileResult(ByteBuffer rv_buf) {
            this.colorTable = new RGBValue(rv_buf, 0);
            this.colorTable.read();
            this.numColors = rv_buf.getInt(8);
        }
    }

    public static class GetFileInfoResult {
        public CalibrationUnit calibrationUnit;
        public float calibrationX;
        public float calibrationY;
        public int width;
        public int height;
        public ImageType imageType;

        private GetFileInfoResult(ByteBuffer rv_buf) {
            this.calibrationUnit = CalibrationUnit.fromValue(rv_buf.getInt(0));
            this.calibrationX = rv_buf.getFloat(8);
            this.calibrationY = rv_buf.getFloat(16);
            this.width = rv_buf.getInt(24);
            this.height = rv_buf.getInt(32);
            this.imageType = ImageType.fromValue(rv_buf.getInt(40));
        }
    }

    public static class GetImageSizeResult {
        public int width;
        public int height;

        private GetImageSizeResult(ByteBuffer rv_buf) {
            this.width = rv_buf.getInt(0);
            this.height = rv_buf.getInt(8);
        }
    }

    public static class EnumerateCustomKeysResult {
        public String[] array;
        private long array_addr;

        private EnumerateCustomKeysResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_size = rv_buf.getInt(0);
            this.array = new String[array_size];
            if (array_size > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_size * 4);
                int i = 0;
                int off = 0;
                while (i < array_size) {
                    long addr = NIVision.getPointer(bb, off);
                    if (addr == 0L) {
                        this.array[i] = null;
                    } else {
                        ByteBuffer bb2 = NIVision.newDirectByteBuffer(addr, 1000);
                        while (bb2.get() != 0) {
                        }
                        byte[] bytes = new byte[bb2.position() - 1];
                        bb2.rewind();
                        NIVision.getBytes(bb2, bytes, 0, bytes.length);
                        try {
                            this.array[i] = new String(bytes, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            this.array[i] = "";
                        }
                    }
                    ++i;
                    off += 4;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class Spoke2Result {
        public EdgeOptions2 edgeOptions;
        public SpokeReport2 val;

        private Spoke2Result(ByteBuffer rv_buf) {
            this.edgeOptions = new EdgeOptions2(rv_buf, 0);
            this.edgeOptions.read();
        }
    }

    public static class SimpleEdgeResult {
        public PointFloat[] array;
        private long array_addr;

        private SimpleEdgeResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numEdges = rv_buf.getInt(0);
            this.array = new PointFloat[array_numEdges];
            if (array_numEdges > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numEdges * 8);
                int i = 0;
                int off = 0;
                while (i < array_numEdges) {
                    this.array[i] = new PointFloat(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 8;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class Rake2Result {
        public EdgeOptions2 edgeOptions;
        public RakeReport2 val;

        private Rake2Result(ByteBuffer rv_buf) {
            this.edgeOptions = new EdgeOptions2(rv_buf, 0);
            this.edgeOptions.read();
        }
    }

    public static class FindTransformRects2Result {
        public CoordinateSystem baseSystem;
        public CoordinateSystem newSystem;
        public AxisReport axisReport;

        private FindTransformRects2Result(ByteBuffer rv_buf) {
            this.baseSystem = new CoordinateSystem(rv_buf, 0);
            this.baseSystem.read();
            this.newSystem = new CoordinateSystem(rv_buf, 8);
            this.newSystem.read();
            this.axisReport = new AxisReport(rv_buf, 16);
            this.axisReport.read();
        }
    }

    public static class FindTransformRect2Result {
        public CoordinateSystem baseSystem;
        public CoordinateSystem newSystem;
        public AxisReport axisReport;

        private FindTransformRect2Result(ByteBuffer rv_buf) {
            this.baseSystem = new CoordinateSystem(rv_buf, 0);
            this.baseSystem.read();
            this.newSystem = new CoordinateSystem(rv_buf, 8);
            this.newSystem.read();
            this.axisReport = new AxisReport(rv_buf, 16);
            this.axisReport.read();
        }
    }

    public static class EdgeTool4Result {
        public EdgeOptions2 edgeOptions;
        public EdgeReport2 val;

        private EdgeTool4Result(ByteBuffer rv_buf) {
            this.edgeOptions = new EdgeOptions2(rv_buf, 0);
            this.edgeOptions.read();
        }
    }

    public static class DetectExtremesResult {
        public ExtremeReport[] array;
        private long array_addr;

        private DetectExtremesResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numExtremes = rv_buf.getInt(0);
            this.array = new ExtremeReport[array_numExtremes];
            if (array_numExtremes > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numExtremes * 24);
                int i = 0;
                int off = 0;
                while (i < array_numExtremes) {
                    this.array[i] = new ExtremeReport(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 24;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class ConcentricRake2Result {
        public EdgeOptions2 edgeOptions;
        public ConcentricRakeReport2 val;

        private ConcentricRake2Result(ByteBuffer rv_buf) {
            this.edgeOptions = new EdgeOptions2(rv_buf, 0);
            this.edgeOptions.read();
        }
    }

    public static class CaliperToolResult {
        public CaliperReport[] array;
        private long array_addr;

        private CaliperToolResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numEdgePairs = rv_buf.getInt(0);
            this.array = new CaliperReport[array_numEdgePairs];
            if (array_numEdgePairs > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numEdgePairs * 32);
                int i = 0;
                int off = 0;
                while (i < array_numEdgePairs) {
                    this.array[i] = new CaliperReport(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 32;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class FindCirclesResult {
        public CircleReport[] array;
        private long array_addr;

        private FindCirclesResult(ByteBuffer rv_buf, long jn_rv) {
            this.array_addr = jn_rv;
            int array_numCircles = rv_buf.getInt(0);
            this.array = new CircleReport[array_numCircles];
            if (array_numCircles > 0 && this.array_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(this.array_addr, array_numCircles * 16);
                int i = 0;
                int off = 0;
                while (i < array_numCircles) {
                    this.array[i] = new CircleReport(bb, off);
                    this.array[i].read();
                    ++i;
                    off += 16;
                }
            }
        }

        protected void finalize() throws Throwable {
            NIVision.imaqDispose(this.array_addr);
            super.finalize();
        }
    }

    public static class SpokeOptions
    extends DisposedStruct {
        public int threshold;
        public int width;
        public int steepness;
        public double subsamplingRatio;
        public InterpolationMethod subpixelType;
        public int subpixelDivisions;

        private void init() {
        }

        public SpokeOptions() {
            super(32);
            this.init();
        }

        public SpokeOptions(int threshold, int width, int steepness, double subsamplingRatio, InterpolationMethod subpixelType, int subpixelDivisions) {
            super(32);
            this.threshold = threshold;
            this.width = width;
            this.steepness = steepness;
            this.subsamplingRatio = subsamplingRatio;
            this.subpixelType = subpixelType;
            this.subpixelDivisions = subpixelDivisions;
        }

        protected SpokeOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected SpokeOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.threshold = this.backing.getInt(0);
            this.width = this.backing.getInt(4);
            this.steepness = this.backing.getInt(8);
            this.subsamplingRatio = this.backing.getDouble(16);
            this.subpixelType = InterpolationMethod.fromValue(this.backing.getInt(24));
            this.subpixelDivisions = this.backing.getInt(28);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.threshold);
            this.backing.putInt(4, this.width);
            this.backing.putInt(8, this.steepness);
            this.backing.putDouble(16, this.subsamplingRatio);
            if (this.subpixelType != null) {
                this.backing.putInt(24, this.subpixelType.getValue());
            }
            this.backing.putInt(28, this.subpixelDivisions);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class ToolWindowOptions
    extends DisposedStruct {
        public int showSelectionTool;
        public int showZoomTool;
        public int showPointTool;
        public int showLineTool;
        public int showRectangleTool;
        public int showOvalTool;
        public int showPolygonTool;
        public int showClosedFreehandTool;
        public int showPolyLineTool;
        public int showFreehandTool;
        public int showAnnulusTool;
        public int showRotatedRectangleTool;
        public int showPanTool;
        public int showZoomOutTool;

        private void init() {
        }

        public ToolWindowOptions() {
            super(68);
            this.init();
        }

        public ToolWindowOptions(int showSelectionTool, int showZoomTool, int showPointTool, int showLineTool, int showRectangleTool, int showOvalTool, int showPolygonTool, int showClosedFreehandTool, int showPolyLineTool, int showFreehandTool, int showAnnulusTool, int showRotatedRectangleTool, int showPanTool, int showZoomOutTool) {
            super(68);
            this.showSelectionTool = showSelectionTool;
            this.showZoomTool = showZoomTool;
            this.showPointTool = showPointTool;
            this.showLineTool = showLineTool;
            this.showRectangleTool = showRectangleTool;
            this.showOvalTool = showOvalTool;
            this.showPolygonTool = showPolygonTool;
            this.showClosedFreehandTool = showClosedFreehandTool;
            this.showPolyLineTool = showPolyLineTool;
            this.showFreehandTool = showFreehandTool;
            this.showAnnulusTool = showAnnulusTool;
            this.showRotatedRectangleTool = showRotatedRectangleTool;
            this.showPanTool = showPanTool;
            this.showZoomOutTool = showZoomOutTool;
        }

        protected ToolWindowOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 68);
            this.init();
        }

        protected ToolWindowOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 68);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 68);
        }

        @Override
        public void read() {
            this.showSelectionTool = this.backing.getInt(0);
            this.showZoomTool = this.backing.getInt(4);
            this.showPointTool = this.backing.getInt(8);
            this.showLineTool = this.backing.getInt(12);
            this.showRectangleTool = this.backing.getInt(16);
            this.showOvalTool = this.backing.getInt(20);
            this.showPolygonTool = this.backing.getInt(24);
            this.showClosedFreehandTool = this.backing.getInt(28);
            this.showPolyLineTool = this.backing.getInt(32);
            this.showFreehandTool = this.backing.getInt(36);
            this.showAnnulusTool = this.backing.getInt(40);
            this.showRotatedRectangleTool = this.backing.getInt(44);
            this.showPanTool = this.backing.getInt(48);
            this.showZoomOutTool = this.backing.getInt(52);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.showSelectionTool);
            this.backing.putInt(4, this.showZoomTool);
            this.backing.putInt(8, this.showPointTool);
            this.backing.putInt(12, this.showLineTool);
            this.backing.putInt(16, this.showRectangleTool);
            this.backing.putInt(20, this.showOvalTool);
            this.backing.putInt(24, this.showPolygonTool);
            this.backing.putInt(28, this.showClosedFreehandTool);
            this.backing.putInt(32, this.showPolyLineTool);
            this.backing.putInt(36, this.showFreehandTool);
            this.backing.putInt(40, this.showAnnulusTool);
            this.backing.putInt(44, this.showRotatedRectangleTool);
            this.backing.putInt(48, this.showPanTool);
            this.backing.putInt(52, this.showZoomOutTool);
        }

        @Override
        public int size() {
            return 68;
        }
    }

    public static class ROIProfile
    extends DisposedStruct {
        public LineProfile report;
        public Point pixels;

        private void init() {
            this.report = new LineProfile(this.backing, 0);
        }

        public ROIProfile() {
            super(44);
            this.init();
        }

        public ROIProfile(LineProfile report, Point pixels) {
            super(44);
            this.report = report;
            this.pixels = pixels;
        }

        protected ROIProfile(ByteBuffer backing, int offset) {
            super(backing, offset, 44);
            this.init();
        }

        protected ROIProfile(long nativeObj, boolean owned) {
            super(nativeObj, owned, 44);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 44);
        }

        @Override
        public void read() {
            this.report.read();
            long pixels_addr = NIVision.getPointer(this.backing, 40);
            this.pixels = pixels_addr == 0L ? null : new Point(pixels_addr, false);
        }

        @Override
        public void write() {
            this.report.write();
            NIVision.putPointer(this.backing, 40, this.pixels);
        }

        @Override
        public int size() {
            return 44;
        }
    }

    public static class RotatedRect
    extends DisposedStruct {
        public int top;
        public int left;
        public int height;
        public int width;
        public double angle;

        private void init() {
        }

        public RotatedRect() {
            super(24);
            this.init();
        }

        public RotatedRect(int top, int left, int height, int width, double angle) {
            super(24);
            this.top = top;
            this.left = left;
            this.height = height;
            this.width = width;
            this.angle = angle;
        }

        protected RotatedRect(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected RotatedRect(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.top = this.backing.getInt(0);
            this.left = this.backing.getInt(4);
            this.height = this.backing.getInt(8);
            this.width = this.backing.getInt(12);
            this.angle = this.backing.getDouble(16);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.top);
            this.backing.putInt(4, this.left);
            this.backing.putInt(8, this.height);
            this.backing.putInt(12, this.width);
            this.backing.putDouble(16, this.angle);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class RotationAngleRange
    extends DisposedStruct {
        public float lower;
        public float upper;

        private void init() {
        }

        public RotationAngleRange() {
            super(8);
            this.init();
        }

        public RotationAngleRange(double lower, double upper) {
            super(8);
            this.lower = (float)lower;
            this.upper = (float)upper;
        }

        protected RotationAngleRange(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected RotationAngleRange(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.lower = this.backing.getFloat(0);
            this.upper = this.backing.getFloat(4);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.lower);
            this.backing.putFloat(4, this.upper);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class SegmentInfo
    extends DisposedStruct {
        public int numberOfPoints;
        public int isOpen;
        public double weight;
        public ContourPoint points;

        private void init() {
        }

        public SegmentInfo() {
            super(24);
            this.init();
        }

        public SegmentInfo(int numberOfPoints, int isOpen, double weight, ContourPoint points) {
            super(24);
            this.numberOfPoints = numberOfPoints;
            this.isOpen = isOpen;
            this.weight = weight;
            this.points = points;
        }

        protected SegmentInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected SegmentInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.numberOfPoints = this.backing.getInt(0);
            this.isOpen = this.backing.getInt(4);
            this.weight = this.backing.getDouble(8);
            long points_addr = NIVision.getPointer(this.backing, 16);
            this.points = points_addr == 0L ? null : new ContourPoint(points_addr, false);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.numberOfPoints);
            this.backing.putInt(4, this.isOpen);
            this.backing.putDouble(8, this.weight);
            NIVision.putPointer(this.backing, 16, this.points);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class SelectParticleCriteria
    extends DisposedStruct {
        public MeasurementValue parameter;
        public float lower;
        public float upper;

        private void init() {
        }

        public SelectParticleCriteria() {
            super(12);
            this.init();
        }

        public SelectParticleCriteria(MeasurementValue parameter, double lower, double upper) {
            super(12);
            this.parameter = parameter;
            this.lower = (float)lower;
            this.upper = (float)upper;
        }

        protected SelectParticleCriteria(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected SelectParticleCriteria(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.parameter = MeasurementValue.fromValue(this.backing.getInt(0));
            this.lower = this.backing.getFloat(4);
            this.upper = this.backing.getFloat(8);
        }

        @Override
        public void write() {
            if (this.parameter != null) {
                this.backing.putInt(0, this.parameter.getValue());
            }
            this.backing.putFloat(4, this.lower);
            this.backing.putFloat(8, this.upper);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class SimpleEdgeOptions
    extends DisposedStruct {
        public LevelType type;
        public int threshold;
        public int hysteresis;
        public EdgeProcess process;
        public int subpixel;

        private void init() {
        }

        public SimpleEdgeOptions() {
            super(20);
            this.init();
        }

        public SimpleEdgeOptions(LevelType type, int threshold, int hysteresis, EdgeProcess process, int subpixel) {
            super(20);
            this.type = type;
            this.threshold = threshold;
            this.hysteresis = hysteresis;
            this.process = process;
            this.subpixel = subpixel;
        }

        protected SimpleEdgeOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected SimpleEdgeOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.type = LevelType.fromValue(this.backing.getInt(0));
            this.threshold = this.backing.getInt(4);
            this.hysteresis = this.backing.getInt(8);
            this.process = EdgeProcess.fromValue(this.backing.getInt(12));
            this.subpixel = this.backing.getInt(16);
        }

        @Override
        public void write() {
            if (this.type != null) {
                this.backing.putInt(0, this.type.getValue());
            }
            this.backing.putInt(4, this.threshold);
            this.backing.putInt(8, this.hysteresis);
            if (this.process != null) {
                this.backing.putInt(12, this.process.getValue());
            }
            this.backing.putInt(16, this.subpixel);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class SpokeReport
    extends DisposedStruct {
        public LineFloat[] spokeLines;
        public PointFloat[] firstEdges;
        public PointFloat[] lastEdges;
        public EdgeLocationReport[] allEdges;
        public int[] linesWithEdges;
        private ByteBuffer spokeLines_buf;
        private ByteBuffer firstEdges_buf;
        private ByteBuffer lastEdges_buf;
        private ByteBuffer allEdges_buf;
        private ByteBuffer linesWithEdges_buf;

        private void init() {
            this.spokeLines = new LineFloat[0];
            this.firstEdges = new PointFloat[0];
            this.lastEdges = new PointFloat[0];
            this.allEdges = new EdgeLocationReport[0];
            this.linesWithEdges = new int[0];
        }

        public SpokeReport() {
            super(36);
            this.init();
        }

        public SpokeReport(LineFloat[] spokeLines, PointFloat[] firstEdges, PointFloat[] lastEdges, EdgeLocationReport[] allEdges, int[] linesWithEdges) {
            super(36);
            this.spokeLines = spokeLines;
            this.firstEdges = firstEdges;
            this.lastEdges = lastEdges;
            this.allEdges = allEdges;
            this.linesWithEdges = linesWithEdges;
        }

        protected SpokeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected SpokeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            int spokeLines_numSpokeLines = this.backing.getInt(4);
            long spokeLines_addr = NIVision.getPointer(this.backing, 0);
            this.spokeLines = new LineFloat[spokeLines_numSpokeLines];
            if (spokeLines_numSpokeLines > 0 && spokeLines_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(spokeLines_addr, spokeLines_numSpokeLines * 16);
                int i = 0;
                int off = 0;
                while (i < spokeLines_numSpokeLines) {
                    this.spokeLines[i] = new LineFloat(bb, off);
                    this.spokeLines[i].read();
                    ++i;
                    off += 16;
                }
            }
            int firstEdges_numFirstEdges = this.backing.getInt(12);
            long firstEdges_addr = NIVision.getPointer(this.backing, 8);
            this.firstEdges = new PointFloat[firstEdges_numFirstEdges];
            if (firstEdges_numFirstEdges > 0 && firstEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(firstEdges_addr, firstEdges_numFirstEdges * 8);
                int i = 0;
                int off = 0;
                while (i < firstEdges_numFirstEdges) {
                    this.firstEdges[i] = new PointFloat(bb, off);
                    this.firstEdges[i].read();
                    ++i;
                    off += 8;
                }
            }
            int lastEdges_numLastEdges = this.backing.getInt(20);
            long lastEdges_addr = NIVision.getPointer(this.backing, 16);
            this.lastEdges = new PointFloat[lastEdges_numLastEdges];
            if (lastEdges_numLastEdges > 0 && lastEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(lastEdges_addr, lastEdges_numLastEdges * 8);
                int i = 0;
                int off = 0;
                while (i < lastEdges_numLastEdges) {
                    this.lastEdges[i] = new PointFloat(bb, off);
                    this.lastEdges[i].read();
                    ++i;
                    off += 8;
                }
            }
            int allEdges_numLinesWithEdges = this.backing.getInt(32);
            long allEdges_addr = NIVision.getPointer(this.backing, 24);
            this.allEdges = new EdgeLocationReport[allEdges_numLinesWithEdges];
            if (allEdges_numLinesWithEdges > 0 && allEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(allEdges_addr, allEdges_numLinesWithEdges * 8);
                int i = 0;
                int off = 0;
                while (i < allEdges_numLinesWithEdges) {
                    this.allEdges[i] = new EdgeLocationReport(bb, off);
                    this.allEdges[i].read();
                    ++i;
                    off += 8;
                }
            }
            int linesWithEdges_numLinesWithEdges = this.backing.getInt(32);
            long linesWithEdges_addr = NIVision.getPointer(this.backing, 28);
            this.linesWithEdges = new int[linesWithEdges_numLinesWithEdges];
            if (linesWithEdges_numLinesWithEdges > 0 && linesWithEdges_addr != 0L) {
                NIVision.newDirectByteBuffer(linesWithEdges_addr, linesWithEdges_numLinesWithEdges * 4).asIntBuffer().get(this.linesWithEdges);
            }
        }

        @Override
        public void write() {
            this.spokeLines_buf = ByteBuffer.allocateDirect(this.spokeLines.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.spokeLines.length) {
                this.spokeLines[i].setBuffer(this.spokeLines_buf, off);
                this.spokeLines[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(4, this.spokeLines.length);
            NIVision.putPointer(this.backing, 0, this.spokeLines_buf);
            this.firstEdges_buf = ByteBuffer.allocateDirect(this.firstEdges.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.firstEdges.length) {
                this.firstEdges[i].setBuffer(this.firstEdges_buf, off);
                this.firstEdges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(12, this.firstEdges.length);
            NIVision.putPointer(this.backing, 8, this.firstEdges_buf);
            this.lastEdges_buf = ByteBuffer.allocateDirect(this.lastEdges.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.lastEdges.length) {
                this.lastEdges[i].setBuffer(this.lastEdges_buf, off);
                this.lastEdges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(20, this.lastEdges.length);
            NIVision.putPointer(this.backing, 16, this.lastEdges_buf);
            this.allEdges_buf = ByteBuffer.allocateDirect(this.allEdges.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.allEdges.length) {
                this.allEdges[i].setBuffer(this.allEdges_buf, off);
                this.allEdges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(32, this.allEdges.length);
            NIVision.putPointer(this.backing, 24, this.allEdges_buf);
            this.linesWithEdges_buf = ByteBuffer.allocateDirect(this.linesWithEdges.length * 4).order(ByteOrder.nativeOrder());
            this.linesWithEdges_buf.asIntBuffer().put(this.linesWithEdges).rewind();
            this.backing.putInt(32, this.linesWithEdges.length);
            NIVision.putPointer(this.backing, 28, this.linesWithEdges_buf);
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class StructuringElement
    extends DisposedStruct {
        public int matrixCols;
        public int matrixRows;
        public int hexa;

        private void init() {
        }

        public StructuringElement() {
            super(16);
            this.init();
        }

        public StructuringElement(int matrixCols, int matrixRows, int hexa) {
            super(16);
            this.matrixCols = matrixCols;
            this.matrixRows = matrixRows;
            this.hexa = hexa;
        }

        protected StructuringElement(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected StructuringElement(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.matrixCols = this.backing.getInt(0);
            this.matrixRows = this.backing.getInt(4);
            this.hexa = this.backing.getInt(8);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.matrixCols);
            this.backing.putInt(4, this.matrixRows);
            this.backing.putInt(8, this.hexa);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ThresholdData
    extends DisposedStruct {
        public float rangeMin;
        public float rangeMax;
        public float newValue;
        public int useNewValue;

        private void init() {
        }

        public ThresholdData() {
            super(16);
            this.init();
        }

        public ThresholdData(double rangeMin, double rangeMax, double newValue, int useNewValue) {
            super(16);
            this.rangeMin = (float)rangeMin;
            this.rangeMax = (float)rangeMax;
            this.newValue = (float)newValue;
            this.useNewValue = useNewValue;
        }

        protected ThresholdData(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ThresholdData(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.rangeMin = this.backing.getFloat(0);
            this.rangeMax = this.backing.getFloat(4);
            this.newValue = this.backing.getFloat(8);
            this.useNewValue = this.backing.getInt(12);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.rangeMin);
            this.backing.putFloat(4, this.rangeMax);
            this.backing.putFloat(8, this.newValue);
            this.backing.putInt(12, this.useNewValue);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class MeterArc
    extends DisposedStruct {
        public PointFloat needleBase;
        public PointFloat[] arcCoordPoints;
        public int needleColor;
        private ByteBuffer arcCoordPoints_buf;

        private void init() {
            this.needleBase = new PointFloat(this.backing, 0);
            this.arcCoordPoints = new PointFloat[0];
        }

        public MeterArc() {
            super(20);
            this.init();
        }

        public MeterArc(PointFloat needleBase, PointFloat[] arcCoordPoints, int needleColor) {
            super(20);
            this.needleBase = needleBase;
            this.arcCoordPoints = arcCoordPoints;
            this.needleColor = needleColor;
        }

        protected MeterArc(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected MeterArc(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.needleBase.read();
            int arcCoordPoints_numOfArcCoordPoints = this.backing.getInt(12);
            long arcCoordPoints_addr = NIVision.getPointer(this.backing, 8);
            this.arcCoordPoints = new PointFloat[arcCoordPoints_numOfArcCoordPoints];
            if (arcCoordPoints_numOfArcCoordPoints > 0 && arcCoordPoints_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(arcCoordPoints_addr, arcCoordPoints_numOfArcCoordPoints * 8);
                int i = 0;
                int off = 0;
                while (i < arcCoordPoints_numOfArcCoordPoints) {
                    this.arcCoordPoints[i] = new PointFloat(bb, off);
                    this.arcCoordPoints[i].read();
                    ++i;
                    off += 8;
                }
            }
            this.needleColor = this.backing.getInt(16);
        }

        @Override
        public void write() {
            this.needleBase.write();
            this.arcCoordPoints_buf = ByteBuffer.allocateDirect(this.arcCoordPoints.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.arcCoordPoints.length) {
                this.arcCoordPoints[i].setBuffer(this.arcCoordPoints_buf, off);
                this.arcCoordPoints[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(12, this.arcCoordPoints.length);
            NIVision.putPointer(this.backing, 8, this.arcCoordPoints_buf);
            this.backing.putInt(16, this.needleColor);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class ShapeReport
    extends DisposedStruct {
        public Rect coordinates;
        public Point centroid;
        public int size;
        public double score;

        private void init() {
            this.coordinates = new Rect(this.backing, 0);
            this.centroid = new Point(this.backing, 16);
        }

        public ShapeReport() {
            super(40);
            this.init();
        }

        public ShapeReport(Rect coordinates, Point centroid, int size, double score) {
            super(40);
            this.coordinates = coordinates;
            this.centroid = centroid;
            this.size = size;
            this.score = score;
        }

        protected ShapeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected ShapeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.coordinates.read();
            this.centroid.read();
            this.size = this.backing.getInt(24);
            this.score = this.backing.getDouble(32);
        }

        @Override
        public void write() {
            this.coordinates.write();
            this.centroid.write();
            this.backing.putInt(24, this.size);
            this.backing.putDouble(32, this.score);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class TransformReport
    extends DisposedStruct {
        public PointFloat[] points;
        public int[] validPoints;
        private ByteBuffer points_buf;
        private ByteBuffer validPoints_buf;

        private void init() {
            this.points = new PointFloat[0];
            this.validPoints = new int[0];
        }

        public TransformReport() {
            super(12);
            this.init();
        }

        public TransformReport(PointFloat[] points, int[] validPoints) {
            super(12);
            this.points = points;
            this.validPoints = validPoints;
        }

        protected TransformReport(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected TransformReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            int points_numPoints = this.backing.getInt(8);
            long points_addr = NIVision.getPointer(this.backing, 0);
            this.points = new PointFloat[points_numPoints];
            if (points_numPoints > 0 && points_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(points_addr, points_numPoints * 8);
                int i = 0;
                int off = 0;
                while (i < points_numPoints) {
                    this.points[i] = new PointFloat(bb, off);
                    this.points[i].read();
                    ++i;
                    off += 8;
                }
            }
            int validPoints_numPoints = this.backing.getInt(8);
            long validPoints_addr = NIVision.getPointer(this.backing, 4);
            this.validPoints = new int[validPoints_numPoints];
            if (validPoints_numPoints > 0 && validPoints_addr != 0L) {
                NIVision.newDirectByteBuffer(validPoints_addr, validPoints_numPoints * 4).asIntBuffer().get(this.validPoints);
            }
        }

        @Override
        public void write() {
            this.points_buf = ByteBuffer.allocateDirect(this.points.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.points.length) {
                this.points[i].setBuffer(this.points_buf, off);
                this.points[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(8, this.points.length);
            NIVision.putPointer(this.backing, 0, this.points_buf);
            this.validPoints_buf = ByteBuffer.allocateDirect(this.validPoints.length * 4).order(ByteOrder.nativeOrder());
            this.validPoints_buf.asIntBuffer().put(this.validPoints).rewind();
            this.backing.putInt(8, this.validPoints.length);
            NIVision.putPointer(this.backing, 4, this.validPoints_buf);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class RakeReport
    extends DisposedStruct {
        public LineFloat[] rakeLines;
        public PointFloat[] firstEdges;
        public PointFloat[] lastEdges;
        public EdgeLocationReport[] allEdges;
        public int[] linesWithEdges;
        private ByteBuffer rakeLines_buf;
        private ByteBuffer firstEdges_buf;
        private ByteBuffer lastEdges_buf;
        private ByteBuffer allEdges_buf;
        private ByteBuffer linesWithEdges_buf;

        private void init() {
            this.rakeLines = new LineFloat[0];
            this.firstEdges = new PointFloat[0];
            this.lastEdges = new PointFloat[0];
            this.allEdges = new EdgeLocationReport[0];
            this.linesWithEdges = new int[0];
        }

        public RakeReport() {
            super(36);
            this.init();
        }

        public RakeReport(LineFloat[] rakeLines, PointFloat[] firstEdges, PointFloat[] lastEdges, EdgeLocationReport[] allEdges, int[] linesWithEdges) {
            super(36);
            this.rakeLines = rakeLines;
            this.firstEdges = firstEdges;
            this.lastEdges = lastEdges;
            this.allEdges = allEdges;
            this.linesWithEdges = linesWithEdges;
        }

        protected RakeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected RakeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            int rakeLines_numRakeLines = this.backing.getInt(4);
            long rakeLines_addr = NIVision.getPointer(this.backing, 0);
            this.rakeLines = new LineFloat[rakeLines_numRakeLines];
            if (rakeLines_numRakeLines > 0 && rakeLines_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(rakeLines_addr, rakeLines_numRakeLines * 16);
                int i = 0;
                int off = 0;
                while (i < rakeLines_numRakeLines) {
                    this.rakeLines[i] = new LineFloat(bb, off);
                    this.rakeLines[i].read();
                    ++i;
                    off += 16;
                }
            }
            int firstEdges_numFirstEdges = this.backing.getInt(12);
            long firstEdges_addr = NIVision.getPointer(this.backing, 8);
            this.firstEdges = new PointFloat[firstEdges_numFirstEdges];
            if (firstEdges_numFirstEdges > 0 && firstEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(firstEdges_addr, firstEdges_numFirstEdges * 8);
                int i = 0;
                int off = 0;
                while (i < firstEdges_numFirstEdges) {
                    this.firstEdges[i] = new PointFloat(bb, off);
                    this.firstEdges[i].read();
                    ++i;
                    off += 8;
                }
            }
            int lastEdges_numLastEdges = this.backing.getInt(20);
            long lastEdges_addr = NIVision.getPointer(this.backing, 16);
            this.lastEdges = new PointFloat[lastEdges_numLastEdges];
            if (lastEdges_numLastEdges > 0 && lastEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(lastEdges_addr, lastEdges_numLastEdges * 8);
                int i = 0;
                int off = 0;
                while (i < lastEdges_numLastEdges) {
                    this.lastEdges[i] = new PointFloat(bb, off);
                    this.lastEdges[i].read();
                    ++i;
                    off += 8;
                }
            }
            int allEdges_numLinesWithEdges = this.backing.getInt(32);
            long allEdges_addr = NIVision.getPointer(this.backing, 24);
            this.allEdges = new EdgeLocationReport[allEdges_numLinesWithEdges];
            if (allEdges_numLinesWithEdges > 0 && allEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(allEdges_addr, allEdges_numLinesWithEdges * 8);
                int i = 0;
                int off = 0;
                while (i < allEdges_numLinesWithEdges) {
                    this.allEdges[i] = new EdgeLocationReport(bb, off);
                    this.allEdges[i].read();
                    ++i;
                    off += 8;
                }
            }
            int linesWithEdges_numLinesWithEdges = this.backing.getInt(32);
            long linesWithEdges_addr = NIVision.getPointer(this.backing, 28);
            this.linesWithEdges = new int[linesWithEdges_numLinesWithEdges];
            if (linesWithEdges_numLinesWithEdges > 0 && linesWithEdges_addr != 0L) {
                NIVision.newDirectByteBuffer(linesWithEdges_addr, linesWithEdges_numLinesWithEdges * 4).asIntBuffer().get(this.linesWithEdges);
            }
        }

        @Override
        public void write() {
            this.rakeLines_buf = ByteBuffer.allocateDirect(this.rakeLines.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.rakeLines.length) {
                this.rakeLines[i].setBuffer(this.rakeLines_buf, off);
                this.rakeLines[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(4, this.rakeLines.length);
            NIVision.putPointer(this.backing, 0, this.rakeLines_buf);
            this.firstEdges_buf = ByteBuffer.allocateDirect(this.firstEdges.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.firstEdges.length) {
                this.firstEdges[i].setBuffer(this.firstEdges_buf, off);
                this.firstEdges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(12, this.firstEdges.length);
            NIVision.putPointer(this.backing, 8, this.firstEdges_buf);
            this.lastEdges_buf = ByteBuffer.allocateDirect(this.lastEdges.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.lastEdges.length) {
                this.lastEdges[i].setBuffer(this.lastEdges_buf, off);
                this.lastEdges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(20, this.lastEdges.length);
            NIVision.putPointer(this.backing, 16, this.lastEdges_buf);
            this.allEdges_buf = ByteBuffer.allocateDirect(this.allEdges.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.allEdges.length) {
                this.allEdges[i].setBuffer(this.allEdges_buf, off);
                this.allEdges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(32, this.allEdges.length);
            NIVision.putPointer(this.backing, 24, this.allEdges_buf);
            this.linesWithEdges_buf = ByteBuffer.allocateDirect(this.linesWithEdges.length * 4).order(ByteOrder.nativeOrder());
            this.linesWithEdges_buf.asIntBuffer().put(this.linesWithEdges).rewind();
            this.backing.putInt(32, this.linesWithEdges.length);
            NIVision.putPointer(this.backing, 28, this.linesWithEdges_buf);
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class RakeOptions
    extends DisposedStruct {
        public int threshold;
        public int width;
        public int steepness;
        public int subsamplingRatio;
        public InterpolationMethod subpixelType;
        public int subpixelDivisions;

        private void init() {
        }

        public RakeOptions() {
            super(24);
            this.init();
        }

        public RakeOptions(int threshold, int width, int steepness, int subsamplingRatio, InterpolationMethod subpixelType, int subpixelDivisions) {
            super(24);
            this.threshold = threshold;
            this.width = width;
            this.steepness = steepness;
            this.subsamplingRatio = subsamplingRatio;
            this.subpixelType = subpixelType;
            this.subpixelDivisions = subpixelDivisions;
        }

        protected RakeOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected RakeOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.threshold = this.backing.getInt(0);
            this.width = this.backing.getInt(4);
            this.steepness = this.backing.getInt(8);
            this.subsamplingRatio = this.backing.getInt(12);
            this.subpixelType = InterpolationMethod.fromValue(this.backing.getInt(16));
            this.subpixelDivisions = this.backing.getInt(20);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.threshold);
            this.backing.putInt(4, this.width);
            this.backing.putInt(8, this.steepness);
            this.backing.putInt(12, this.subsamplingRatio);
            if (this.subpixelType != null) {
                this.backing.putInt(16, this.subpixelType.getValue());
            }
            this.backing.putInt(20, this.subpixelDivisions);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class QuantifyReport
    extends DisposedStruct {
        public QuantifyData global;
        public QuantifyData[] regions;
        private ByteBuffer regions_buf;

        private void init() {
            this.global = new QuantifyData(this.backing, 0);
            this.regions = new QuantifyData[0];
        }

        public QuantifyReport() {
            super(36);
            this.init();
        }

        public QuantifyReport(QuantifyData global, QuantifyData[] regions) {
            super(36);
            this.global = global;
            this.regions = regions;
        }

        protected QuantifyReport(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected QuantifyReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            this.global.read();
            int regions_regionCount = this.backing.getInt(32);
            long regions_addr = NIVision.getPointer(this.backing, 28);
            this.regions = new QuantifyData[regions_regionCount];
            if (regions_regionCount > 0 && regions_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(regions_addr, regions_regionCount * 28);
                int i = 0;
                int off = 0;
                while (i < regions_regionCount) {
                    this.regions[i] = new QuantifyData(bb, off);
                    this.regions[i].read();
                    ++i;
                    off += 28;
                }
            }
        }

        @Override
        public void write() {
            this.global.write();
            this.regions_buf = ByteBuffer.allocateDirect(this.regions.length * 28).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.regions.length) {
                this.regions[i].setBuffer(this.regions_buf, off);
                this.regions[i].write();
                ++i;
                off += 28;
            }
            this.backing.putInt(32, this.regions.length);
            NIVision.putPointer(this.backing, 28, this.regions_buf);
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class QuantifyData
    extends DisposedStruct {
        public float mean;
        public float stdDev;
        public float min;
        public float max;
        public float calibratedArea;
        public int pixelArea;
        public float relativeSize;

        private void init() {
        }

        public QuantifyData() {
            super(28);
            this.init();
        }

        public QuantifyData(double mean, double stdDev, double min, double max, double calibratedArea, int pixelArea, double relativeSize) {
            super(28);
            this.mean = (float)mean;
            this.stdDev = (float)stdDev;
            this.min = (float)min;
            this.max = (float)max;
            this.calibratedArea = (float)calibratedArea;
            this.pixelArea = pixelArea;
            this.relativeSize = (float)relativeSize;
        }

        protected QuantifyData(ByteBuffer backing, int offset) {
            super(backing, offset, 28);
            this.init();
        }

        protected QuantifyData(long nativeObj, boolean owned) {
            super(nativeObj, owned, 28);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 28);
        }

        @Override
        public void read() {
            this.mean = this.backing.getFloat(0);
            this.stdDev = this.backing.getFloat(4);
            this.min = this.backing.getFloat(8);
            this.max = this.backing.getFloat(12);
            this.calibratedArea = this.backing.getFloat(16);
            this.pixelArea = this.backing.getInt(20);
            this.relativeSize = this.backing.getFloat(24);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.mean);
            this.backing.putFloat(4, this.stdDev);
            this.backing.putFloat(8, this.min);
            this.backing.putFloat(12, this.max);
            this.backing.putFloat(16, this.calibratedArea);
            this.backing.putInt(20, this.pixelArea);
            this.backing.putFloat(24, this.relativeSize);
        }

        @Override
        public int size() {
            return 28;
        }
    }

    public static class PatternMatch
    extends DisposedStruct {
        public PointFloat position;
        public float rotation;
        public float scale;
        public float score;
        public PointFloat[] corner;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
            this.corner = new PointFloat[4];
            int i = 0;
            int off = 20;
            while (i < 4) {
                this.corner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public PatternMatch() {
            super(52);
            this.init();
        }

        public PatternMatch(PointFloat position, double rotation, double scale, double score, PointFloat[] corner) {
            super(52);
            this.position = position;
            this.rotation = (float)rotation;
            this.scale = (float)scale;
            this.score = (float)score;
            this.corner = corner;
        }

        protected PatternMatch(ByteBuffer backing, int offset) {
            super(backing, offset, 52);
            this.init();
        }

        protected PatternMatch(long nativeObj, boolean owned) {
            super(nativeObj, owned, 52);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 52);
        }

        @Override
        public void read() {
            this.position.read();
            this.rotation = this.backing.getFloat(8);
            this.scale = this.backing.getFloat(12);
            this.score = this.backing.getFloat(16);
            for (PointFloat it : this.corner) {
                it.read();
            }
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putFloat(8, this.rotation);
            this.backing.putFloat(12, this.scale);
            this.backing.putFloat(16, this.score);
            for (PointFloat it : this.corner) {
                it.write();
            }
        }

        @Override
        public int size() {
            return 52;
        }
    }

    public static class ParticleReport
    extends DisposedStruct {
        public int area;
        public float calibratedArea;
        public float perimeter;
        public int numHoles;
        public int areaOfHoles;
        public float perimeterOfHoles;
        public Rect boundingBox;
        public float sigmaX;
        public float sigmaY;
        public float sigmaXX;
        public float sigmaYY;
        public float sigmaXY;
        public int longestLength;
        public Point longestPoint;
        public int projectionX;
        public int projectionY;
        public int connect8;

        private void init() {
            this.boundingBox = new Rect(this.backing, 24);
            this.longestPoint = new Point(this.backing, 64);
        }

        public ParticleReport() {
            super(84);
            this.init();
        }

        public ParticleReport(int area, double calibratedArea, double perimeter, int numHoles, int areaOfHoles, double perimeterOfHoles, Rect boundingBox, double sigmaX, double sigmaY, double sigmaXX, double sigmaYY, double sigmaXY, int longestLength, Point longestPoint, int projectionX, int projectionY, int connect8) {
            super(84);
            this.area = area;
            this.calibratedArea = (float)calibratedArea;
            this.perimeter = (float)perimeter;
            this.numHoles = numHoles;
            this.areaOfHoles = areaOfHoles;
            this.perimeterOfHoles = (float)perimeterOfHoles;
            this.boundingBox = boundingBox;
            this.sigmaX = (float)sigmaX;
            this.sigmaY = (float)sigmaY;
            this.sigmaXX = (float)sigmaXX;
            this.sigmaYY = (float)sigmaYY;
            this.sigmaXY = (float)sigmaXY;
            this.longestLength = longestLength;
            this.longestPoint = longestPoint;
            this.projectionX = projectionX;
            this.projectionY = projectionY;
            this.connect8 = connect8;
        }

        protected ParticleReport(ByteBuffer backing, int offset) {
            super(backing, offset, 84);
            this.init();
        }

        protected ParticleReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 84);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 84);
        }

        @Override
        public void read() {
            this.area = this.backing.getInt(0);
            this.calibratedArea = this.backing.getFloat(4);
            this.perimeter = this.backing.getFloat(8);
            this.numHoles = this.backing.getInt(12);
            this.areaOfHoles = this.backing.getInt(16);
            this.perimeterOfHoles = this.backing.getFloat(20);
            this.boundingBox.read();
            this.sigmaX = this.backing.getFloat(40);
            this.sigmaY = this.backing.getFloat(44);
            this.sigmaXX = this.backing.getFloat(48);
            this.sigmaYY = this.backing.getFloat(52);
            this.sigmaXY = this.backing.getFloat(56);
            this.longestLength = this.backing.getInt(60);
            this.longestPoint.read();
            this.projectionX = this.backing.getInt(72);
            this.projectionY = this.backing.getInt(76);
            this.connect8 = this.backing.getInt(80);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.area);
            this.backing.putFloat(4, this.calibratedArea);
            this.backing.putFloat(8, this.perimeter);
            this.backing.putInt(12, this.numHoles);
            this.backing.putInt(16, this.areaOfHoles);
            this.backing.putFloat(20, this.perimeterOfHoles);
            this.boundingBox.write();
            this.backing.putFloat(40, this.sigmaX);
            this.backing.putFloat(44, this.sigmaY);
            this.backing.putFloat(48, this.sigmaXX);
            this.backing.putFloat(52, this.sigmaYY);
            this.backing.putFloat(56, this.sigmaXY);
            this.backing.putInt(60, this.longestLength);
            this.longestPoint.write();
            this.backing.putInt(72, this.projectionX);
            this.backing.putInt(76, this.projectionY);
            this.backing.putInt(80, this.connect8);
        }

        @Override
        public int size() {
            return 84;
        }
    }

    public static class ParticleFilterCriteria
    extends DisposedStruct {
        public MeasurementValue parameter;
        public float lower;
        public float upper;
        public int exclude;

        private void init() {
        }

        public ParticleFilterCriteria() {
            super(16);
            this.init();
        }

        public ParticleFilterCriteria(MeasurementValue parameter, double lower, double upper, int exclude) {
            super(16);
            this.parameter = parameter;
            this.lower = (float)lower;
            this.upper = (float)upper;
            this.exclude = exclude;
        }

        protected ParticleFilterCriteria(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ParticleFilterCriteria(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.parameter = MeasurementValue.fromValue(this.backing.getInt(0));
            this.lower = this.backing.getFloat(4);
            this.upper = this.backing.getFloat(8);
            this.exclude = this.backing.getInt(12);
        }

        @Override
        public void write() {
            if (this.parameter != null) {
                this.backing.putInt(0, this.parameter.getValue());
            }
            this.backing.putFloat(4, this.lower);
            this.backing.putFloat(8, this.upper);
            this.backing.putInt(12, this.exclude);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class OverlayTextOptions
    extends DisposedStruct {
        public String fontName;
        public int fontSize;
        public int bold;
        public int italic;
        public int underline;
        public int strikeout;
        public TextAlignment horizontalTextAlignment;
        public VerticalTextAlignment verticalTextAlignment;
        public RGBValue backgroundColor;
        public double angle;
        private ByteBuffer fontName_buf;

        private void init() {
            this.backgroundColor = new RGBValue(this.backing, 32);
        }

        public OverlayTextOptions() {
            super(48);
            this.init();
        }

        public OverlayTextOptions(String fontName, int fontSize, int bold, int italic, int underline, int strikeout, TextAlignment horizontalTextAlignment, VerticalTextAlignment verticalTextAlignment, RGBValue backgroundColor, double angle) {
            super(48);
            this.fontName = fontName;
            this.fontSize = fontSize;
            this.bold = bold;
            this.italic = italic;
            this.underline = underline;
            this.strikeout = strikeout;
            this.horizontalTextAlignment = horizontalTextAlignment;
            this.verticalTextAlignment = verticalTextAlignment;
            this.backgroundColor = backgroundColor;
            this.angle = angle;
        }

        protected OverlayTextOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 48);
            this.init();
        }

        protected OverlayTextOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 48);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 48);
        }

        @Override
        public void read() {
            long fontName_addr = NIVision.getPointer(this.backing, 0);
            if (fontName_addr == 0L) {
                this.fontName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(fontName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.fontName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.fontName = "";
                }
            }
            this.fontSize = this.backing.getInt(4);
            this.bold = this.backing.getInt(8);
            this.italic = this.backing.getInt(12);
            this.underline = this.backing.getInt(16);
            this.strikeout = this.backing.getInt(20);
            this.horizontalTextAlignment = TextAlignment.fromValue(this.backing.getInt(24));
            this.verticalTextAlignment = VerticalTextAlignment.fromValue(this.backing.getInt(28));
            this.backgroundColor.read();
            this.angle = this.backing.getDouble(40);
        }

        @Override
        public void write() {
            if (this.fontName != null) {
                byte[] fontName_bytes;
                try {
                    fontName_bytes = this.fontName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    fontName_bytes = new byte[]{};
                }
                this.fontName_buf = ByteBuffer.allocateDirect(fontName_bytes.length + 1);
                NIVision.putBytes(this.fontName_buf, fontName_bytes, 0, fontName_bytes.length).put(fontName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.fontName == null ? 0L : NIVision.getByteBufferAddress(this.fontName_buf));
            this.backing.putInt(4, this.fontSize);
            this.backing.putInt(8, this.bold);
            this.backing.putInt(12, this.italic);
            this.backing.putInt(16, this.underline);
            this.backing.putInt(20, this.strikeout);
            if (this.horizontalTextAlignment != null) {
                this.backing.putInt(24, this.horizontalTextAlignment.getValue());
            }
            if (this.verticalTextAlignment != null) {
                this.backing.putInt(28, this.verticalTextAlignment.getValue());
            }
            this.backgroundColor.write();
            this.backing.putDouble(40, this.angle);
        }

        @Override
        public int size() {
            return 48;
        }
    }

    public static class OpenContour
    extends DisposedStruct {
        public Point[] points;
        private ByteBuffer points_buf;

        private void init() {
            this.points = new Point[0];
        }

        public OpenContour() {
            super(8);
            this.init();
        }

        public OpenContour(Point[] points) {
            super(8);
            this.points = points;
        }

        protected OpenContour(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected OpenContour(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            int points_numPoints = this.backing.getInt(4);
            long points_addr = NIVision.getPointer(this.backing, 0);
            this.points = new Point[points_numPoints];
            if (points_numPoints > 0 && points_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(points_addr, points_numPoints * 8);
                int i = 0;
                int off = 0;
                while (i < points_numPoints) {
                    this.points[i] = new Point(bb, off);
                    this.points[i].read();
                    ++i;
                    off += 8;
                }
            }
        }

        @Override
        public void write() {
            this.points_buf = ByteBuffer.allocateDirect(this.points.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.points.length) {
                this.points[i].setBuffer(this.points_buf, off);
                this.points[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(4, this.points.length);
            NIVision.putPointer(this.backing, 0, this.points_buf);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class TIFFFileOptions
    extends DisposedStruct {
        public int rowsPerStrip;
        public PhotometricMode photoInterp;
        public TIFFCompressionType compressionType;

        private void init() {
        }

        public TIFFFileOptions() {
            super(12);
            this.init();
        }

        public TIFFFileOptions(int rowsPerStrip, PhotometricMode photoInterp, TIFFCompressionType compressionType) {
            super(12);
            this.rowsPerStrip = rowsPerStrip;
            this.photoInterp = photoInterp;
            this.compressionType = compressionType;
        }

        protected TIFFFileOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected TIFFFileOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.rowsPerStrip = this.backing.getInt(0);
            this.photoInterp = PhotometricMode.fromValue(this.backing.getInt(4));
            this.compressionType = TIFFCompressionType.fromValue(this.backing.getInt(8));
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.rowsPerStrip);
            if (this.photoInterp != null) {
                this.backing.putInt(4, this.photoInterp.getValue());
            }
            if (this.compressionType != null) {
                this.backing.putInt(8, this.compressionType.getValue());
            }
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class MatchPatternOptions
    extends DisposedStruct {
        public MatchingMode mode;
        public int minContrast;
        public int subpixelAccuracy;
        public RotationAngleRange[] angleRanges;
        public int numMatchesRequested;
        public int matchFactor;
        public float minMatchScore;
        private ByteBuffer angleRanges_buf;

        private void init() {
            this.angleRanges = new RotationAngleRange[0];
        }

        public MatchPatternOptions() {
            super(32);
            this.init();
        }

        public MatchPatternOptions(MatchingMode mode, int minContrast, int subpixelAccuracy, RotationAngleRange[] angleRanges, int numMatchesRequested, int matchFactor, double minMatchScore) {
            super(32);
            this.mode = mode;
            this.minContrast = minContrast;
            this.subpixelAccuracy = subpixelAccuracy;
            this.angleRanges = angleRanges;
            this.numMatchesRequested = numMatchesRequested;
            this.matchFactor = matchFactor;
            this.minMatchScore = (float)minMatchScore;
        }

        protected MatchPatternOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected MatchPatternOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.mode = MatchingMode.fromValue(this.backing.getInt(0));
            this.minContrast = this.backing.getInt(4);
            this.subpixelAccuracy = this.backing.getInt(8);
            int angleRanges_numRanges = this.backing.getInt(16);
            long angleRanges_addr = NIVision.getPointer(this.backing, 12);
            this.angleRanges = new RotationAngleRange[angleRanges_numRanges];
            if (angleRanges_numRanges > 0 && angleRanges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(angleRanges_addr, angleRanges_numRanges * 8);
                int i = 0;
                int off = 0;
                while (i < angleRanges_numRanges) {
                    this.angleRanges[i] = new RotationAngleRange(bb, off);
                    this.angleRanges[i].read();
                    ++i;
                    off += 8;
                }
            }
            this.numMatchesRequested = this.backing.getInt(20);
            this.matchFactor = this.backing.getInt(24);
            this.minMatchScore = this.backing.getFloat(28);
        }

        @Override
        public void write() {
            if (this.mode != null) {
                this.backing.putInt(0, this.mode.getValue());
            }
            this.backing.putInt(4, this.minContrast);
            this.backing.putInt(8, this.subpixelAccuracy);
            this.angleRanges_buf = ByteBuffer.allocateDirect(this.angleRanges.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.angleRanges.length) {
                this.angleRanges[i].setBuffer(this.angleRanges_buf, off);
                this.angleRanges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(16, this.angleRanges.length);
            NIVision.putPointer(this.backing, 12, this.angleRanges_buf);
            this.backing.putInt(20, this.numMatchesRequested);
            this.backing.putInt(24, this.matchFactor);
            this.backing.putFloat(28, this.minMatchScore);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class View3DOptions
    extends DisposedStruct {
        public int sizeReduction;
        public int maxHeight;
        public Direction3D direction;
        public float alpha;
        public float beta;
        public int border;
        public int background;
        public Plane3D plane;

        private void init() {
        }

        public View3DOptions() {
            super(32);
            this.init();
        }

        public View3DOptions(int sizeReduction, int maxHeight, Direction3D direction, double alpha, double beta, int border, int background, Plane3D plane) {
            super(32);
            this.sizeReduction = sizeReduction;
            this.maxHeight = maxHeight;
            this.direction = direction;
            this.alpha = (float)alpha;
            this.beta = (float)beta;
            this.border = border;
            this.background = background;
            this.plane = plane;
        }

        protected View3DOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected View3DOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.sizeReduction = this.backing.getInt(0);
            this.maxHeight = this.backing.getInt(4);
            this.direction = Direction3D.fromValue(this.backing.getInt(8));
            this.alpha = this.backing.getFloat(12);
            this.beta = this.backing.getFloat(16);
            this.border = this.backing.getInt(20);
            this.background = this.backing.getInt(24);
            this.plane = Plane3D.fromValue(this.backing.getInt(28));
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.sizeReduction);
            this.backing.putInt(4, this.maxHeight);
            if (this.direction != null) {
                this.backing.putInt(8, this.direction.getValue());
            }
            this.backing.putFloat(12, this.alpha);
            this.backing.putFloat(16, this.beta);
            this.backing.putInt(20, this.border);
            this.backing.putInt(24, this.background);
            if (this.plane != null) {
                this.backing.putInt(28, this.plane.getValue());
            }
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class UserPointSymbol
    extends DisposedStruct {
        public int cols;
        public int rows;

        private void init() {
        }

        public UserPointSymbol() {
            super(12);
            this.init();
        }

        public UserPointSymbol(int cols, int rows) {
            super(12);
            this.cols = cols;
            this.rows = rows;
        }

        protected UserPointSymbol(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected UserPointSymbol(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.cols = this.backing.getInt(0);
            this.rows = this.backing.getInt(4);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.cols);
            this.backing.putInt(4, this.rows);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class Range
    extends DisposedStruct {
        public int minValue;
        public int maxValue;

        private void init() {
        }

        public Range() {
            super(8);
            this.init();
        }

        public Range(int minValue, int maxValue) {
            super(8);
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        protected Range(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected Range(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.minValue = this.backing.getInt(0);
            this.maxValue = this.backing.getInt(4);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.minValue);
            this.backing.putInt(4, this.maxValue);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class CannyOptions
    extends DisposedStruct {
        public float sigma;
        public float upperThreshold;
        public float lowerThreshold;
        public int windowSize;

        private void init() {
        }

        public CannyOptions() {
            super(16);
            this.init();
        }

        public CannyOptions(double sigma, double upperThreshold, double lowerThreshold, int windowSize) {
            super(16);
            this.sigma = (float)sigma;
            this.upperThreshold = (float)upperThreshold;
            this.lowerThreshold = (float)lowerThreshold;
            this.windowSize = windowSize;
        }

        protected CannyOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected CannyOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.sigma = this.backing.getFloat(0);
            this.upperThreshold = this.backing.getFloat(4);
            this.lowerThreshold = this.backing.getFloat(8);
            this.windowSize = this.backing.getInt(12);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.sigma);
            this.backing.putFloat(4, this.upperThreshold);
            this.backing.putFloat(8, this.lowerThreshold);
            this.backing.putInt(12, this.windowSize);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class CoordinateTransform2
    extends DisposedStruct {
        public CoordinateSystem referenceSystem;
        public CoordinateSystem measurementSystem;

        private void init() {
            this.referenceSystem = new CoordinateSystem(this.backing, 0);
            this.measurementSystem = new CoordinateSystem(this.backing, 16);
        }

        public CoordinateTransform2() {
            super(32);
            this.init();
        }

        public CoordinateTransform2(CoordinateSystem referenceSystem, CoordinateSystem measurementSystem) {
            super(32);
            this.referenceSystem = referenceSystem;
            this.measurementSystem = measurementSystem;
        }

        protected CoordinateTransform2(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected CoordinateTransform2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.referenceSystem.read();
            this.measurementSystem.read();
        }

        @Override
        public void write() {
            this.referenceSystem.write();
            this.measurementSystem.write();
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class CoordinateTransform
    extends DisposedStruct {
        public Point initialOrigin;
        public float initialAngle;
        public Point finalOrigin;
        public float finalAngle;

        private void init() {
            this.initialOrigin = new Point(this.backing, 0);
            this.finalOrigin = new Point(this.backing, 12);
        }

        public CoordinateTransform() {
            super(24);
            this.init();
        }

        public CoordinateTransform(Point initialOrigin, double initialAngle, Point finalOrigin, double finalAngle) {
            super(24);
            this.initialOrigin = initialOrigin;
            this.initialAngle = (float)initialAngle;
            this.finalOrigin = finalOrigin;
            this.finalAngle = (float)finalAngle;
        }

        protected CoordinateTransform(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected CoordinateTransform(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.initialOrigin.read();
            this.initialAngle = this.backing.getFloat(8);
            this.finalOrigin.read();
            this.finalAngle = this.backing.getFloat(20);
        }

        @Override
        public void write() {
            this.initialOrigin.write();
            this.backing.putFloat(8, this.initialAngle);
            this.finalOrigin.write();
            this.backing.putFloat(20, this.finalAngle);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class ContourPoint
    extends DisposedStruct {
        public double x;
        public double y;
        public double curvature;
        public double xDisplacement;
        public double yDisplacement;

        private void init() {
        }

        public ContourPoint() {
            super(40);
            this.init();
        }

        public ContourPoint(double x, double y, double curvature, double xDisplacement, double yDisplacement) {
            super(40);
            this.x = x;
            this.y = y;
            this.curvature = curvature;
            this.xDisplacement = xDisplacement;
            this.yDisplacement = yDisplacement;
        }

        protected ContourPoint(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected ContourPoint(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.x = this.backing.getDouble(0);
            this.y = this.backing.getDouble(8);
            this.curvature = this.backing.getDouble(16);
            this.xDisplacement = this.backing.getDouble(24);
            this.yDisplacement = this.backing.getDouble(32);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.x);
            this.backing.putDouble(8, this.y);
            this.backing.putDouble(16, this.curvature);
            this.backing.putDouble(24, this.xDisplacement);
            this.backing.putDouble(32, this.yDisplacement);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class ContourInfo2
    extends DisposedStruct {
        public ContourType type;
        public RGBValue color;
        public Point point;
        public Line line;
        public Rect rect;
        public Rect ovalBoundingBox;
        public ClosedContour closedContour;
        public OpenContour openContour;
        public Annulus annulus;
        public RotatedRect rotatedRect;

        private void init() {
            this.color = new RGBValue(this.backing, 4);
        }

        public ContourInfo2() {
            super(12);
            this.init();
        }

        public ContourInfo2(ContourType type, RGBValue color) {
            super(12);
            this.type = type;
            this.color = color;
        }

        protected ContourInfo2(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected ContourInfo2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.type = ContourType.fromValue(this.backing.getInt(0));
            this.color.read();
            if (this.type == ContourType.POINT) {
                long point_addr = NIVision.getPointer(this.backing, 8);
                this.point = point_addr == 0L ? null : new Point(point_addr, false);
            }
            if (this.type == ContourType.LINE) {
                long line_addr = NIVision.getPointer(this.backing, 8);
                this.line = line_addr == 0L ? null : new Line(line_addr, false);
            }
            if (this.type == ContourType.RECT) {
                long rect_addr = NIVision.getPointer(this.backing, 8);
                this.rect = rect_addr == 0L ? null : new Rect(rect_addr, false);
            }
            if (this.type == ContourType.OVAL) {
                long ovalBoundingBox_addr = NIVision.getPointer(this.backing, 8);
                this.ovalBoundingBox = ovalBoundingBox_addr == 0L ? null : new Rect(ovalBoundingBox_addr, false);
            }
            if (this.type == ContourType.CLOSED_CONTOUR) {
                long closedContour_addr = NIVision.getPointer(this.backing, 8);
                this.closedContour = closedContour_addr == 0L ? null : new ClosedContour(closedContour_addr, false);
            }
            if (this.type == ContourType.OPEN_CONTOUR) {
                long openContour_addr = NIVision.getPointer(this.backing, 8);
                this.openContour = openContour_addr == 0L ? null : new OpenContour(openContour_addr, false);
            }
            if (this.type == ContourType.ANNULUS) {
                long annulus_addr = NIVision.getPointer(this.backing, 8);
                this.annulus = annulus_addr == 0L ? null : new Annulus(annulus_addr, false);
            }
            if (this.type == ContourType.ROTATED_RECT) {
                long rotatedRect_addr = NIVision.getPointer(this.backing, 8);
                this.rotatedRect = rotatedRect_addr == 0L ? null : new RotatedRect(rotatedRect_addr, false);
            }
        }

        @Override
        public void write() {
            if (this.type != null) {
                this.backing.putInt(0, this.type.getValue());
            }
            this.color.write();
            if (this.type == ContourType.POINT) {
                NIVision.putPointer(this.backing, 8, this.point);
            }
            if (this.type == ContourType.LINE) {
                NIVision.putPointer(this.backing, 8, this.line);
            }
            if (this.type == ContourType.RECT) {
                NIVision.putPointer(this.backing, 8, this.rect);
            }
            if (this.type == ContourType.OVAL) {
                NIVision.putPointer(this.backing, 8, this.ovalBoundingBox);
            }
            if (this.type == ContourType.CLOSED_CONTOUR) {
                NIVision.putPointer(this.backing, 8, this.closedContour);
            }
            if (this.type == ContourType.OPEN_CONTOUR) {
                NIVision.putPointer(this.backing, 8, this.openContour);
            }
            if (this.type == ContourType.ANNULUS) {
                NIVision.putPointer(this.backing, 8, this.annulus);
            }
            if (this.type == ContourType.ROTATED_RECT) {
                NIVision.putPointer(this.backing, 8, this.rotatedRect);
            }
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class ContourInfo
    extends DisposedStruct {
        public ContourType type;
        public Point[] points;
        public RGBValue contourColor;
        private ByteBuffer points_buf;

        private void init() {
            this.points = new Point[0];
            this.contourColor = new RGBValue(this.backing, 12);
        }

        public ContourInfo() {
            super(16);
            this.init();
        }

        public ContourInfo(ContourType type, Point[] points, RGBValue contourColor) {
            super(16);
            this.type = type;
            this.points = points;
            this.contourColor = contourColor;
        }

        protected ContourInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ContourInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.type = ContourType.fromValue(this.backing.getInt(0));
            int points_numPoints = this.backing.getInt(4);
            long points_addr = NIVision.getPointer(this.backing, 8);
            this.points = new Point[points_numPoints];
            if (points_numPoints > 0 && points_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(points_addr, points_numPoints * 8);
                int i = 0;
                int off = 0;
                while (i < points_numPoints) {
                    this.points[i] = new Point(bb, off);
                    this.points[i].read();
                    ++i;
                    off += 8;
                }
            }
            this.contourColor.read();
        }

        @Override
        public void write() {
            if (this.type != null) {
                this.backing.putInt(0, this.type.getValue());
            }
            this.points_buf = ByteBuffer.allocateDirect(this.points.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.points.length) {
                this.points[i].setBuffer(this.points_buf, off);
                this.points[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(4, this.points.length);
            NIVision.putPointer(this.backing, 8, this.points_buf);
            this.contourColor.write();
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ConstructROIOptions
    extends DisposedStruct {
        public int windowNumber;
        public String windowTitle;
        public PaletteType type;
        public RGBValue[] palette;
        private ByteBuffer windowTitle_buf;
        private ByteBuffer palette_buf;

        private void init() {
            this.palette = new RGBValue[0];
        }

        public ConstructROIOptions() {
            super(20);
            this.init();
        }

        public ConstructROIOptions(int windowNumber, String windowTitle, PaletteType type, RGBValue[] palette) {
            super(20);
            this.windowNumber = windowNumber;
            this.windowTitle = windowTitle;
            this.type = type;
            this.palette = palette;
        }

        protected ConstructROIOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected ConstructROIOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.windowNumber = this.backing.getInt(0);
            long windowTitle_addr = NIVision.getPointer(this.backing, 4);
            if (windowTitle_addr == 0L) {
                this.windowTitle = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(windowTitle_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.windowTitle = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.windowTitle = "";
                }
            }
            this.type = PaletteType.fromValue(this.backing.getInt(8));
            int palette_numColors = this.backing.getInt(16);
            long palette_addr = NIVision.getPointer(this.backing, 12);
            this.palette = new RGBValue[palette_numColors];
            if (palette_numColors > 0 && palette_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(palette_addr, palette_numColors * 4);
                int i = 0;
                int off = 0;
                while (i < palette_numColors) {
                    this.palette[i] = new RGBValue(bb, off);
                    this.palette[i].read();
                    ++i;
                    off += 4;
                }
            }
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.windowNumber);
            if (this.windowTitle != null) {
                byte[] windowTitle_bytes;
                try {
                    windowTitle_bytes = this.windowTitle.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    windowTitle_bytes = new byte[]{};
                }
                this.windowTitle_buf = ByteBuffer.allocateDirect(windowTitle_bytes.length + 1);
                NIVision.putBytes(this.windowTitle_buf, windowTitle_bytes, 0, windowTitle_bytes.length).put(windowTitle_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 4, this.windowTitle == null ? 0L : NIVision.getByteBufferAddress(this.windowTitle_buf));
            if (this.type != null) {
                this.backing.putInt(8, this.type.getValue());
            }
            this.palette_buf = ByteBuffer.allocateDirect(this.palette.length * 4).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.palette.length) {
                this.palette[i].setBuffer(this.palette_buf, off);
                this.palette[i].write();
                ++i;
                off += 4;
            }
            this.backing.putInt(16, this.palette.length);
            NIVision.putPointer(this.backing, 12, this.palette_buf);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class ConcentricRakeReport
    extends DisposedStruct {
        public ArcInfo[] rakeArcs;
        public PointFloat[] firstEdges;
        public PointFloat[] lastEdges;
        public EdgeLocationReport[] allEdges;
        public int[] linesWithEdges;
        private ByteBuffer rakeArcs_buf;
        private ByteBuffer firstEdges_buf;
        private ByteBuffer lastEdges_buf;
        private ByteBuffer allEdges_buf;
        private ByteBuffer linesWithEdges_buf;

        private void init() {
            this.rakeArcs = new ArcInfo[0];
            this.firstEdges = new PointFloat[0];
            this.lastEdges = new PointFloat[0];
            this.allEdges = new EdgeLocationReport[0];
            this.linesWithEdges = new int[0];
        }

        public ConcentricRakeReport() {
            super(36);
            this.init();
        }

        public ConcentricRakeReport(ArcInfo[] rakeArcs, PointFloat[] firstEdges, PointFloat[] lastEdges, EdgeLocationReport[] allEdges, int[] linesWithEdges) {
            super(36);
            this.rakeArcs = rakeArcs;
            this.firstEdges = firstEdges;
            this.lastEdges = lastEdges;
            this.allEdges = allEdges;
            this.linesWithEdges = linesWithEdges;
        }

        protected ConcentricRakeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected ConcentricRakeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            int rakeArcs_numArcs = this.backing.getInt(4);
            long rakeArcs_addr = NIVision.getPointer(this.backing, 0);
            this.rakeArcs = new ArcInfo[rakeArcs_numArcs];
            if (rakeArcs_numArcs > 0 && rakeArcs_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(rakeArcs_addr, rakeArcs_numArcs * 32);
                int i = 0;
                int off = 0;
                while (i < rakeArcs_numArcs) {
                    this.rakeArcs[i] = new ArcInfo(bb, off);
                    this.rakeArcs[i].read();
                    ++i;
                    off += 32;
                }
            }
            int firstEdges_numFirstEdges = this.backing.getInt(12);
            long firstEdges_addr = NIVision.getPointer(this.backing, 8);
            this.firstEdges = new PointFloat[firstEdges_numFirstEdges];
            if (firstEdges_numFirstEdges > 0 && firstEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(firstEdges_addr, firstEdges_numFirstEdges * 8);
                int i = 0;
                int off = 0;
                while (i < firstEdges_numFirstEdges) {
                    this.firstEdges[i] = new PointFloat(bb, off);
                    this.firstEdges[i].read();
                    ++i;
                    off += 8;
                }
            }
            int lastEdges_numLastEdges = this.backing.getInt(20);
            long lastEdges_addr = NIVision.getPointer(this.backing, 16);
            this.lastEdges = new PointFloat[lastEdges_numLastEdges];
            if (lastEdges_numLastEdges > 0 && lastEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(lastEdges_addr, lastEdges_numLastEdges * 8);
                int i = 0;
                int off = 0;
                while (i < lastEdges_numLastEdges) {
                    this.lastEdges[i] = new PointFloat(bb, off);
                    this.lastEdges[i].read();
                    ++i;
                    off += 8;
                }
            }
            int allEdges_numLinesWithEdges = this.backing.getInt(32);
            long allEdges_addr = NIVision.getPointer(this.backing, 24);
            this.allEdges = new EdgeLocationReport[allEdges_numLinesWithEdges];
            if (allEdges_numLinesWithEdges > 0 && allEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(allEdges_addr, allEdges_numLinesWithEdges * 8);
                int i = 0;
                int off = 0;
                while (i < allEdges_numLinesWithEdges) {
                    this.allEdges[i] = new EdgeLocationReport(bb, off);
                    this.allEdges[i].read();
                    ++i;
                    off += 8;
                }
            }
            int linesWithEdges_numLinesWithEdges = this.backing.getInt(32);
            long linesWithEdges_addr = NIVision.getPointer(this.backing, 28);
            this.linesWithEdges = new int[linesWithEdges_numLinesWithEdges];
            if (linesWithEdges_numLinesWithEdges > 0 && linesWithEdges_addr != 0L) {
                NIVision.newDirectByteBuffer(linesWithEdges_addr, linesWithEdges_numLinesWithEdges * 4).asIntBuffer().get(this.linesWithEdges);
            }
        }

        @Override
        public void write() {
            this.rakeArcs_buf = ByteBuffer.allocateDirect(this.rakeArcs.length * 32).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.rakeArcs.length) {
                this.rakeArcs[i].setBuffer(this.rakeArcs_buf, off);
                this.rakeArcs[i].write();
                ++i;
                off += 32;
            }
            this.backing.putInt(4, this.rakeArcs.length);
            NIVision.putPointer(this.backing, 0, this.rakeArcs_buf);
            this.firstEdges_buf = ByteBuffer.allocateDirect(this.firstEdges.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.firstEdges.length) {
                this.firstEdges[i].setBuffer(this.firstEdges_buf, off);
                this.firstEdges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(12, this.firstEdges.length);
            NIVision.putPointer(this.backing, 8, this.firstEdges_buf);
            this.lastEdges_buf = ByteBuffer.allocateDirect(this.lastEdges.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.lastEdges.length) {
                this.lastEdges[i].setBuffer(this.lastEdges_buf, off);
                this.lastEdges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(20, this.lastEdges.length);
            NIVision.putPointer(this.backing, 16, this.lastEdges_buf);
            this.allEdges_buf = ByteBuffer.allocateDirect(this.allEdges.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.allEdges.length) {
                this.allEdges[i].setBuffer(this.allEdges_buf, off);
                this.allEdges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(32, this.allEdges.length);
            NIVision.putPointer(this.backing, 24, this.allEdges_buf);
            this.linesWithEdges_buf = ByteBuffer.allocateDirect(this.linesWithEdges.length * 4).order(ByteOrder.nativeOrder());
            this.linesWithEdges_buf.asIntBuffer().put(this.linesWithEdges).rewind();
            this.backing.putInt(32, this.linesWithEdges.length);
            NIVision.putPointer(this.backing, 28, this.linesWithEdges_buf);
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class Complex
    extends DisposedStruct {
        public float r;
        public float i;

        private void init() {
        }

        public Complex() {
            super(8);
            this.init();
        }

        public Complex(double r, double i) {
            super(8);
            this.r = (float)r;
            this.i = (float)i;
        }

        protected Complex(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected Complex(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.r = this.backing.getFloat(0);
            this.i = this.backing.getFloat(4);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.r);
            this.backing.putFloat(4, this.i);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class ColorInformation
    extends DisposedStruct {
        public int saturation;
        public double[] info;
        private ByteBuffer info_buf;

        private void init() {
            this.info = new double[0];
        }

        public ColorInformation() {
            super(12);
            this.init();
        }

        public ColorInformation(int saturation, double[] info) {
            super(12);
            this.saturation = saturation;
            this.info = info;
        }

        protected ColorInformation(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected ColorInformation(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.saturation = this.backing.getInt(4);
            int info_infoCount = this.backing.getInt(0);
            long info_addr = NIVision.getPointer(this.backing, 8);
            this.info = new double[info_infoCount];
            if (info_infoCount > 0 && info_addr != 0L) {
                NIVision.newDirectByteBuffer(info_addr, info_infoCount * 8).asDoubleBuffer().get(this.info);
            }
        }

        @Override
        public void write() {
            this.backing.putInt(4, this.saturation);
            this.info_buf = ByteBuffer.allocateDirect(this.info.length * 8).order(ByteOrder.nativeOrder());
            this.info_buf.asDoubleBuffer().put(this.info).rewind();
            this.backing.putInt(0, this.info.length);
            NIVision.putPointer(this.backing, 8, this.info_buf);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class ColorHistogramReport
    extends DisposedStruct {
        public HistogramReport plane1;
        public HistogramReport plane2;
        public HistogramReport plane3;

        private void init() {
            this.plane1 = new HistogramReport(this.backing, 0);
            this.plane2 = new HistogramReport(this.backing, 36);
            this.plane3 = new HistogramReport(this.backing, 72);
        }

        public ColorHistogramReport() {
            super(108);
            this.init();
        }

        public ColorHistogramReport(HistogramReport plane1, HistogramReport plane2, HistogramReport plane3) {
            super(108);
            this.plane1 = plane1;
            this.plane2 = plane2;
            this.plane3 = plane3;
        }

        protected ColorHistogramReport(ByteBuffer backing, int offset) {
            super(backing, offset, 108);
            this.init();
        }

        protected ColorHistogramReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 108);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 108);
        }

        @Override
        public void read() {
            this.plane1.read();
            this.plane2.read();
            this.plane3.read();
        }

        @Override
        public void write() {
            this.plane1.write();
            this.plane2.write();
            this.plane3.write();
        }

        @Override
        public int size() {
            return 108;
        }
    }

    public static class ClosedContour
    extends DisposedStruct {
        public Point[] points;
        private ByteBuffer points_buf;

        private void init() {
            this.points = new Point[0];
        }

        public ClosedContour() {
            super(8);
            this.init();
        }

        public ClosedContour(Point[] points) {
            super(8);
            this.points = points;
        }

        protected ClosedContour(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected ClosedContour(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            int points_numPoints = this.backing.getInt(4);
            long points_addr = NIVision.getPointer(this.backing, 0);
            this.points = new Point[points_numPoints];
            if (points_numPoints > 0 && points_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(points_addr, points_numPoints * 8);
                int i = 0;
                int off = 0;
                while (i < points_numPoints) {
                    this.points[i] = new Point(bb, off);
                    this.points[i].read();
                    ++i;
                    off += 8;
                }
            }
        }

        @Override
        public void write() {
            this.points_buf = ByteBuffer.allocateDirect(this.points.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.points.length) {
                this.points[i].setBuffer(this.points_buf, off);
                this.points[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(4, this.points.length);
            NIVision.putPointer(this.backing, 0, this.points_buf);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class CircleReport
    extends DisposedStruct {
        public Point center;
        public int radius;
        public int area;

        private void init() {
            this.center = new Point(this.backing, 0);
        }

        public CircleReport() {
            super(16);
            this.init();
        }

        public CircleReport(Point center, int radius, int area) {
            super(16);
            this.center = center;
            this.radius = radius;
            this.area = area;
        }

        protected CircleReport(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected CircleReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.center.read();
            this.radius = this.backing.getInt(8);
            this.area = this.backing.getInt(12);
        }

        @Override
        public void write() {
            this.center.write();
            this.backing.putInt(8, this.radius);
            this.backing.putInt(12, this.area);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class DrawTextOptions
    extends DisposedStruct {
        public String fontName;
        public int fontSize;
        public int bold;
        public int italic;
        public int underline;
        public int strikeout;
        public TextAlignment textAlignment;
        public FontColor fontColor;

        private void init() {
        }

        public DrawTextOptions() {
            super(60);
            this.init();
        }

        public DrawTextOptions(String fontName, int fontSize, int bold, int italic, int underline, int strikeout, TextAlignment textAlignment, FontColor fontColor) {
            super(60);
            this.fontName = fontName;
            this.fontSize = fontSize;
            this.bold = bold;
            this.italic = italic;
            this.underline = underline;
            this.strikeout = strikeout;
            this.textAlignment = textAlignment;
            this.fontColor = fontColor;
        }

        protected DrawTextOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 60);
            this.init();
        }

        protected DrawTextOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 60);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 60);
        }

        @Override
        public void read() {
            int len;
            byte[] bytes = new byte[32];
            NIVision.getBytes(this.backing, bytes, 0, 32);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.fontName = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.fontName = "";
            }
            this.fontSize = this.backing.getInt(32);
            this.bold = this.backing.getInt(36);
            this.italic = this.backing.getInt(40);
            this.underline = this.backing.getInt(44);
            this.strikeout = this.backing.getInt(48);
            this.textAlignment = TextAlignment.fromValue(this.backing.getInt(52));
            this.fontColor = FontColor.fromValue(this.backing.getInt(56));
        }

        @Override
        public void write() {
            if (this.fontName != null) {
                byte[] bytes;
                try {
                    bytes = this.fontName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 0, bytes.length);
                for (int i = bytes.length; i < 32; ++i) {
                    this.backing.put(i, (byte)0);
                }
            }
            this.backing.putInt(32, this.fontSize);
            this.backing.putInt(36, this.bold);
            this.backing.putInt(40, this.italic);
            this.backing.putInt(44, this.underline);
            this.backing.putInt(48, this.strikeout);
            if (this.textAlignment != null) {
                this.backing.putInt(52, this.textAlignment.getValue());
            }
            if (this.fontColor != null) {
                this.backing.putInt(56, this.fontColor.getValue());
            }
        }

        @Override
        public int size() {
            return 60;
        }
    }

    public static class CaliperReport
    extends DisposedStruct {
        public float edge1Contrast;
        public PointFloat edge1Coord;
        public float edge2Contrast;
        public PointFloat edge2Coord;
        public float separation;

        private void init() {
            this.edge1Coord = new PointFloat(this.backing, 4);
            this.edge2Coord = new PointFloat(this.backing, 16);
        }

        public CaliperReport() {
            super(32);
            this.init();
        }

        public CaliperReport(double edge1Contrast, PointFloat edge1Coord, double edge2Contrast, PointFloat edge2Coord, double separation) {
            super(32);
            this.edge1Contrast = (float)edge1Contrast;
            this.edge1Coord = edge1Coord;
            this.edge2Contrast = (float)edge2Contrast;
            this.edge2Coord = edge2Coord;
            this.separation = (float)separation;
        }

        protected CaliperReport(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected CaliperReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.edge1Contrast = this.backing.getFloat(0);
            this.edge1Coord.read();
            this.edge2Contrast = this.backing.getFloat(12);
            this.edge2Coord.read();
            this.separation = this.backing.getFloat(24);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.edge1Contrast);
            this.edge1Coord.write();
            this.backing.putFloat(12, this.edge2Contrast);
            this.edge2Coord.write();
            this.backing.putFloat(24, this.separation);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class CaliperOptions
    extends DisposedStruct {
        public TwoEdgePolarityType polarity;
        public float separation;
        public float separationDeviation;

        private void init() {
        }

        public CaliperOptions() {
            super(12);
            this.init();
        }

        public CaliperOptions(TwoEdgePolarityType polarity, double separation, double separationDeviation) {
            super(12);
            this.polarity = polarity;
            this.separation = (float)separation;
            this.separationDeviation = (float)separationDeviation;
        }

        protected CaliperOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected CaliperOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.polarity = TwoEdgePolarityType.fromValue(this.backing.getInt(0));
            this.separation = this.backing.getFloat(4);
            this.separationDeviation = this.backing.getFloat(8);
        }

        @Override
        public void write() {
            if (this.polarity != null) {
                this.backing.putInt(0, this.polarity.getValue());
            }
            this.backing.putFloat(4, this.separation);
            this.backing.putFloat(8, this.separationDeviation);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class CalibrationPoints
    extends DisposedStruct {
        public PointFloat[] pixelCoordinates;
        public PointFloat[] realWorldCoordinates;
        private ByteBuffer pixelCoordinates_buf;
        private ByteBuffer realWorldCoordinates_buf;

        private void init() {
            this.pixelCoordinates = new PointFloat[0];
            this.realWorldCoordinates = new PointFloat[0];
        }

        public CalibrationPoints() {
            super(12);
            this.init();
        }

        public CalibrationPoints(PointFloat[] pixelCoordinates, PointFloat[] realWorldCoordinates) {
            super(12);
            this.pixelCoordinates = pixelCoordinates;
            this.realWorldCoordinates = realWorldCoordinates;
        }

        protected CalibrationPoints(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected CalibrationPoints(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            int pixelCoordinates_numCoordinates = this.backing.getInt(8);
            long pixelCoordinates_addr = NIVision.getPointer(this.backing, 0);
            this.pixelCoordinates = new PointFloat[pixelCoordinates_numCoordinates];
            if (pixelCoordinates_numCoordinates > 0 && pixelCoordinates_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(pixelCoordinates_addr, pixelCoordinates_numCoordinates * 8);
                int i = 0;
                int off = 0;
                while (i < pixelCoordinates_numCoordinates) {
                    this.pixelCoordinates[i] = new PointFloat(bb, off);
                    this.pixelCoordinates[i].read();
                    ++i;
                    off += 8;
                }
            }
            int realWorldCoordinates_numCoordinates = this.backing.getInt(8);
            long realWorldCoordinates_addr = NIVision.getPointer(this.backing, 4);
            this.realWorldCoordinates = new PointFloat[realWorldCoordinates_numCoordinates];
            if (realWorldCoordinates_numCoordinates > 0 && realWorldCoordinates_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(realWorldCoordinates_addr, realWorldCoordinates_numCoordinates * 8);
                int i = 0;
                int off = 0;
                while (i < realWorldCoordinates_numCoordinates) {
                    this.realWorldCoordinates[i] = new PointFloat(bb, off);
                    this.realWorldCoordinates[i].read();
                    ++i;
                    off += 8;
                }
            }
        }

        @Override
        public void write() {
            this.pixelCoordinates_buf = ByteBuffer.allocateDirect(this.pixelCoordinates.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.pixelCoordinates.length) {
                this.pixelCoordinates[i].setBuffer(this.pixelCoordinates_buf, off);
                this.pixelCoordinates[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(8, this.pixelCoordinates.length);
            NIVision.putPointer(this.backing, 0, this.pixelCoordinates_buf);
            this.realWorldCoordinates_buf = ByteBuffer.allocateDirect(this.realWorldCoordinates.length * 8).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.realWorldCoordinates.length) {
                this.realWorldCoordinates[i].setBuffer(this.realWorldCoordinates_buf, off);
                this.realWorldCoordinates[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(8, this.realWorldCoordinates.length);
            NIVision.putPointer(this.backing, 4, this.realWorldCoordinates_buf);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class CalibrationInfo
    extends DisposedStruct {
        public int mapColumns;
        public int mapRows;
        public ROI userRoi;
        public ROI calibrationRoi;
        public LearnCalibrationOptions options;
        public GridDescriptor grid;
        public CoordinateSystem system;
        public RangeFloat range;
        public float quality;

        private void init() {
            this.options = new LearnCalibrationOptions(this.backing, 20);
            this.grid = new GridDescriptor(this.backing, 40);
            this.system = new CoordinateSystem(this.backing, 52);
            this.range = new RangeFloat(this.backing, 68);
        }

        public CalibrationInfo() {
            super(80);
            this.init();
        }

        public CalibrationInfo(int mapColumns, int mapRows, ROI userRoi, ROI calibrationRoi, LearnCalibrationOptions options, GridDescriptor grid, CoordinateSystem system, RangeFloat range, double quality) {
            super(80);
            this.mapColumns = mapColumns;
            this.mapRows = mapRows;
            this.userRoi = userRoi;
            this.calibrationRoi = calibrationRoi;
            this.options = options;
            this.grid = grid;
            this.system = system;
            this.range = range;
            this.quality = (float)quality;
        }

        protected CalibrationInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 80);
            this.init();
        }

        protected CalibrationInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 80);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 80);
        }

        @Override
        public void read() {
            this.mapColumns = this.backing.getInt(4);
            this.mapRows = this.backing.getInt(8);
            long userRoi_addr = NIVision.getPointer(this.backing, 12);
            this.userRoi = userRoi_addr == 0L ? null : new ROI(userRoi_addr, false);
            long calibrationRoi_addr = NIVision.getPointer(this.backing, 16);
            this.calibrationRoi = calibrationRoi_addr == 0L ? null : new ROI(calibrationRoi_addr, false);
            this.options.read();
            this.grid.read();
            this.system.read();
            this.range.read();
            this.quality = this.backing.getFloat(76);
        }

        @Override
        public void write() {
            this.backing.putInt(4, this.mapColumns);
            this.backing.putInt(8, this.mapRows);
            NIVision.putPointer(this.backing, 12, this.userRoi);
            NIVision.putPointer(this.backing, 16, this.calibrationRoi);
            this.options.write();
            this.grid.write();
            this.system.write();
            this.range.write();
            this.backing.putFloat(76, this.quality);
        }

        @Override
        public int size() {
            return 80;
        }
    }

    public static class CoordinateSystem
    extends DisposedStruct {
        public PointFloat origin;
        public float angle;
        public AxisOrientation axisOrientation;

        private void init() {
            this.origin = new PointFloat(this.backing, 0);
        }

        public CoordinateSystem() {
            super(16);
            this.init();
        }

        public CoordinateSystem(PointFloat origin, double angle, AxisOrientation axisOrientation) {
            super(16);
            this.origin = origin;
            this.angle = (float)angle;
            this.axisOrientation = axisOrientation;
        }

        protected CoordinateSystem(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected CoordinateSystem(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.origin.read();
            this.angle = this.backing.getFloat(8);
            this.axisOrientation = AxisOrientation.fromValue(this.backing.getInt(12));
        }

        @Override
        public void write() {
            this.origin.write();
            this.backing.putFloat(8, this.angle);
            if (this.axisOrientation != null) {
                this.backing.putInt(12, this.axisOrientation.getValue());
            }
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class BrowserOptions
    extends DisposedStruct {
        public int width;
        public int height;
        public int imagesPerLine;
        public RGBValue backgroundColor;
        public int frameSize;
        public BrowserFrameStyle style;
        public float ratio;
        public RGBValue focusColor;

        private void init() {
            this.backgroundColor = new RGBValue(this.backing, 12);
            this.focusColor = new RGBValue(this.backing, 28);
        }

        public BrowserOptions() {
            super(32);
            this.init();
        }

        public BrowserOptions(int width, int height, int imagesPerLine, RGBValue backgroundColor, int frameSize, BrowserFrameStyle style, double ratio, RGBValue focusColor) {
            super(32);
            this.width = width;
            this.height = height;
            this.imagesPerLine = imagesPerLine;
            this.backgroundColor = backgroundColor;
            this.frameSize = frameSize;
            this.style = style;
            this.ratio = (float)ratio;
            this.focusColor = focusColor;
        }

        protected BrowserOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected BrowserOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.width = this.backing.getInt(0);
            this.height = this.backing.getInt(4);
            this.imagesPerLine = this.backing.getInt(8);
            this.backgroundColor.read();
            this.frameSize = this.backing.getInt(16);
            this.style = BrowserFrameStyle.fromValue(this.backing.getInt(20));
            this.ratio = this.backing.getFloat(24);
            this.focusColor.read();
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.width);
            this.backing.putInt(4, this.height);
            this.backing.putInt(8, this.imagesPerLine);
            this.backgroundColor.write();
            this.backing.putInt(16, this.frameSize);
            if (this.style != null) {
                this.backing.putInt(20, this.style.getValue());
            }
            this.backing.putFloat(24, this.ratio);
            this.focusColor.write();
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class BestLine
    extends DisposedStruct {
        public PointFloat start;
        public PointFloat end;
        public LineEquation equation;
        public int valid;
        public double error;
        public int[] pointsUsed;
        private ByteBuffer pointsUsed_buf;

        private void init() {
            this.start = new PointFloat(this.backing, 0);
            this.end = new PointFloat(this.backing, 8);
            this.equation = new LineEquation(this.backing, 16);
            this.pointsUsed = new int[0];
        }

        public BestLine() {
            super(64);
            this.init();
        }

        public BestLine(PointFloat start, PointFloat end, LineEquation equation, int valid, double error, int[] pointsUsed) {
            super(64);
            this.start = start;
            this.end = end;
            this.equation = equation;
            this.valid = valid;
            this.error = error;
            this.pointsUsed = pointsUsed;
        }

        protected BestLine(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected BestLine(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.start.read();
            this.end.read();
            this.equation.read();
            this.valid = this.backing.getInt(40);
            this.error = this.backing.getDouble(48);
            int pointsUsed_numPointsUsed = this.backing.getInt(60);
            long pointsUsed_addr = NIVision.getPointer(this.backing, 56);
            this.pointsUsed = new int[pointsUsed_numPointsUsed];
            if (pointsUsed_numPointsUsed > 0 && pointsUsed_addr != 0L) {
                NIVision.newDirectByteBuffer(pointsUsed_addr, pointsUsed_numPointsUsed * 4).asIntBuffer().get(this.pointsUsed);
            }
        }

        @Override
        public void write() {
            this.start.write();
            this.end.write();
            this.equation.write();
            this.backing.putInt(40, this.valid);
            this.backing.putDouble(48, this.error);
            this.pointsUsed_buf = ByteBuffer.allocateDirect(this.pointsUsed.length * 4).order(ByteOrder.nativeOrder());
            this.pointsUsed_buf.asIntBuffer().put(this.pointsUsed).rewind();
            this.backing.putInt(60, this.pointsUsed.length);
            NIVision.putPointer(this.backing, 56, this.pointsUsed_buf);
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class BestEllipse
    extends DisposedStruct {
        public PointFloat center;
        public PointFloat majorAxisStart;
        public PointFloat majorAxisEnd;
        public PointFloat minorAxisStart;
        public PointFloat minorAxisEnd;
        public double area;
        public double perimeter;

        private void init() {
            this.center = new PointFloat(this.backing, 0);
            this.majorAxisStart = new PointFloat(this.backing, 8);
            this.majorAxisEnd = new PointFloat(this.backing, 16);
            this.minorAxisStart = new PointFloat(this.backing, 24);
            this.minorAxisEnd = new PointFloat(this.backing, 32);
        }

        public BestEllipse() {
            super(56);
            this.init();
        }

        public BestEllipse(PointFloat center, PointFloat majorAxisStart, PointFloat majorAxisEnd, PointFloat minorAxisStart, PointFloat minorAxisEnd, double area, double perimeter) {
            super(56);
            this.center = center;
            this.majorAxisStart = majorAxisStart;
            this.majorAxisEnd = majorAxisEnd;
            this.minorAxisStart = minorAxisStart;
            this.minorAxisEnd = minorAxisEnd;
            this.area = area;
            this.perimeter = perimeter;
        }

        protected BestEllipse(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected BestEllipse(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            this.center.read();
            this.majorAxisStart.read();
            this.majorAxisEnd.read();
            this.minorAxisStart.read();
            this.minorAxisEnd.read();
            this.area = this.backing.getDouble(40);
            this.perimeter = this.backing.getDouble(48);
        }

        @Override
        public void write() {
            this.center.write();
            this.majorAxisStart.write();
            this.majorAxisEnd.write();
            this.minorAxisStart.write();
            this.minorAxisEnd.write();
            this.backing.putDouble(40, this.area);
            this.backing.putDouble(48, this.perimeter);
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class BestCircle
    extends DisposedStruct {
        public PointFloat center;
        public double radius;
        public double area;
        public double perimeter;
        public double error;

        private void init() {
            this.center = new PointFloat(this.backing, 0);
        }

        public BestCircle() {
            super(40);
            this.init();
        }

        public BestCircle(PointFloat center, double radius, double area, double perimeter, double error) {
            super(40);
            this.center = center;
            this.radius = radius;
            this.area = area;
            this.perimeter = perimeter;
            this.error = error;
        }

        protected BestCircle(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected BestCircle(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.center.read();
            this.radius = this.backing.getDouble(8);
            this.area = this.backing.getDouble(16);
            this.perimeter = this.backing.getDouble(24);
            this.error = this.backing.getDouble(32);
        }

        @Override
        public void write() {
            this.center.write();
            this.backing.putDouble(8, this.radius);
            this.backing.putDouble(16, this.area);
            this.backing.putDouble(24, this.perimeter);
            this.backing.putDouble(32, this.error);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class BCGOptions
    extends DisposedStruct {
        public float brightness;
        public float contrast;
        public float gamma;

        private void init() {
        }

        public BCGOptions() {
            super(12);
            this.init();
        }

        public BCGOptions(double brightness, double contrast, double gamma) {
            super(12);
            this.brightness = (float)brightness;
            this.contrast = (float)contrast;
            this.gamma = (float)gamma;
        }

        protected BCGOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected BCGOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.brightness = this.backing.getFloat(0);
            this.contrast = this.backing.getFloat(4);
            this.gamma = this.backing.getFloat(8);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.brightness);
            this.backing.putFloat(4, this.contrast);
            this.backing.putFloat(8, this.gamma);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class BarcodeInfo
    extends DisposedStruct {
        public String outputString;
        public int size;
        public byte outputChar1;
        public byte outputChar2;
        public double confidenceLevel;
        public BarcodeType type;
        private ByteBuffer outputString_buf;

        private void init() {
        }

        public BarcodeInfo() {
            super(32);
            this.init();
        }

        public BarcodeInfo(String outputString, int size, byte outputChar1, byte outputChar2, double confidenceLevel, BarcodeType type) {
            super(32);
            this.outputString = outputString;
            this.size = size;
            this.outputChar1 = outputChar1;
            this.outputChar2 = outputChar2;
            this.confidenceLevel = confidenceLevel;
            this.type = type;
        }

        protected BarcodeInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected BarcodeInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            long outputString_addr = NIVision.getPointer(this.backing, 0);
            if (outputString_addr == 0L) {
                this.outputString = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(outputString_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.outputString = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.outputString = "";
                }
            }
            this.size = this.backing.getInt(4);
            this.outputChar1 = this.backing.get(8);
            this.outputChar2 = this.backing.get(9);
            this.confidenceLevel = this.backing.getDouble(16);
            this.type = BarcodeType.fromValue(this.backing.getInt(24));
        }

        @Override
        public void write() {
            if (this.outputString != null) {
                byte[] outputString_bytes;
                try {
                    outputString_bytes = this.outputString.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    outputString_bytes = new byte[]{};
                }
                this.outputString_buf = ByteBuffer.allocateDirect(outputString_bytes.length + 1);
                NIVision.putBytes(this.outputString_buf, outputString_bytes, 0, outputString_bytes.length).put(outputString_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.outputString == null ? 0L : NIVision.getByteBufferAddress(this.outputString_buf));
            this.backing.putInt(4, this.size);
            this.backing.put(8, this.outputChar1);
            this.backing.put(9, this.outputChar2);
            this.backing.putDouble(16, this.confidenceLevel);
            if (this.type != null) {
                this.backing.putInt(24, this.type.getValue());
            }
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class AxisReport
    extends DisposedStruct {
        public PointFloat origin;
        public PointFloat mainAxisEnd;
        public PointFloat secondaryAxisEnd;

        private void init() {
            this.origin = new PointFloat(this.backing, 0);
            this.mainAxisEnd = new PointFloat(this.backing, 8);
            this.secondaryAxisEnd = new PointFloat(this.backing, 16);
        }

        public AxisReport() {
            super(24);
            this.init();
        }

        public AxisReport(PointFloat origin, PointFloat mainAxisEnd, PointFloat secondaryAxisEnd) {
            super(24);
            this.origin = origin;
            this.mainAxisEnd = mainAxisEnd;
            this.secondaryAxisEnd = secondaryAxisEnd;
        }

        protected AxisReport(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected AxisReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.origin.read();
            this.mainAxisEnd.read();
            this.secondaryAxisEnd.read();
        }

        @Override
        public void write() {
            this.origin.write();
            this.mainAxisEnd.write();
            this.secondaryAxisEnd.write();
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class ArcInfo
    extends DisposedStruct {
        public Rect boundingBox;
        public double startAngle;
        public double endAngle;

        private void init() {
            this.boundingBox = new Rect(this.backing, 0);
        }

        public ArcInfo() {
            super(32);
            this.init();
        }

        public ArcInfo(Rect boundingBox, double startAngle, double endAngle) {
            super(32);
            this.boundingBox = boundingBox;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        protected ArcInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected ArcInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.boundingBox.read();
            this.startAngle = this.backing.getDouble(16);
            this.endAngle = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.boundingBox.write();
            this.backing.putDouble(16, this.startAngle);
            this.backing.putDouble(24, this.endAngle);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class HistogramReport
    extends DisposedStruct {
        public int[] histogram;
        public float min;
        public float max;
        public float start;
        public float width;
        public float mean;
        public float stdDev;
        public int numPixels;
        private ByteBuffer histogram_buf;

        private void init() {
            this.histogram = new int[0];
        }

        public HistogramReport() {
            super(36);
            this.init();
        }

        public HistogramReport(int[] histogram, double min, double max, double start, double width, double mean, double stdDev, int numPixels) {
            super(36);
            this.histogram = histogram;
            this.min = (float)min;
            this.max = (float)max;
            this.start = (float)start;
            this.width = (float)width;
            this.mean = (float)mean;
            this.stdDev = (float)stdDev;
            this.numPixels = numPixels;
        }

        protected HistogramReport(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected HistogramReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            int histogram_histogramCount = this.backing.getInt(4);
            long histogram_addr = NIVision.getPointer(this.backing, 0);
            this.histogram = new int[histogram_histogramCount];
            if (histogram_histogramCount > 0 && histogram_addr != 0L) {
                NIVision.newDirectByteBuffer(histogram_addr, histogram_histogramCount * 4).asIntBuffer().get(this.histogram);
            }
            this.min = this.backing.getFloat(8);
            this.max = this.backing.getFloat(12);
            this.start = this.backing.getFloat(16);
            this.width = this.backing.getFloat(20);
            this.mean = this.backing.getFloat(24);
            this.stdDev = this.backing.getFloat(28);
            this.numPixels = this.backing.getInt(32);
        }

        @Override
        public void write() {
            this.histogram_buf = ByteBuffer.allocateDirect(this.histogram.length * 4).order(ByteOrder.nativeOrder());
            this.histogram_buf.asIntBuffer().put(this.histogram).rewind();
            this.backing.putInt(4, this.histogram.length);
            NIVision.putPointer(this.backing, 0, this.histogram_buf);
            this.backing.putFloat(8, this.min);
            this.backing.putFloat(12, this.max);
            this.backing.putFloat(16, this.start);
            this.backing.putFloat(20, this.width);
            this.backing.putFloat(24, this.mean);
            this.backing.putFloat(28, this.stdDev);
            this.backing.putInt(32, this.numPixels);
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class MatchColorPatternOptions
    extends DisposedStruct {
        public MatchingMode matchMode;
        public ImageFeatureMode featureMode;
        public int minContrast;
        public int subpixelAccuracy;
        public RotationAngleRange[] angleRanges;
        public double colorWeight;
        public ColorSensitivity sensitivity;
        public SearchStrategy strategy;
        public int numMatchesRequested;
        public float minMatchScore;
        private ByteBuffer angleRanges_buf;

        private void init() {
            this.angleRanges = new RotationAngleRange[0];
        }

        public MatchColorPatternOptions() {
            super(48);
            this.init();
        }

        public MatchColorPatternOptions(MatchingMode matchMode, ImageFeatureMode featureMode, int minContrast, int subpixelAccuracy, RotationAngleRange[] angleRanges, double colorWeight, ColorSensitivity sensitivity, SearchStrategy strategy, int numMatchesRequested, double minMatchScore) {
            super(48);
            this.matchMode = matchMode;
            this.featureMode = featureMode;
            this.minContrast = minContrast;
            this.subpixelAccuracy = subpixelAccuracy;
            this.angleRanges = angleRanges;
            this.colorWeight = colorWeight;
            this.sensitivity = sensitivity;
            this.strategy = strategy;
            this.numMatchesRequested = numMatchesRequested;
            this.minMatchScore = (float)minMatchScore;
        }

        protected MatchColorPatternOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 48);
            this.init();
        }

        protected MatchColorPatternOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 48);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 48);
        }

        @Override
        public void read() {
            this.matchMode = MatchingMode.fromValue(this.backing.getInt(0));
            this.featureMode = ImageFeatureMode.fromValue(this.backing.getInt(4));
            this.minContrast = this.backing.getInt(8);
            this.subpixelAccuracy = this.backing.getInt(12);
            int angleRanges_numRanges = this.backing.getInt(20);
            long angleRanges_addr = NIVision.getPointer(this.backing, 16);
            this.angleRanges = new RotationAngleRange[angleRanges_numRanges];
            if (angleRanges_numRanges > 0 && angleRanges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(angleRanges_addr, angleRanges_numRanges * 8);
                int i = 0;
                int off = 0;
                while (i < angleRanges_numRanges) {
                    this.angleRanges[i] = new RotationAngleRange(bb, off);
                    this.angleRanges[i].read();
                    ++i;
                    off += 8;
                }
            }
            this.colorWeight = this.backing.getDouble(24);
            this.sensitivity = ColorSensitivity.fromValue(this.backing.getInt(32));
            this.strategy = SearchStrategy.fromValue(this.backing.getInt(36));
            this.numMatchesRequested = this.backing.getInt(40);
            this.minMatchScore = this.backing.getFloat(44);
        }

        @Override
        public void write() {
            if (this.matchMode != null) {
                this.backing.putInt(0, this.matchMode.getValue());
            }
            if (this.featureMode != null) {
                this.backing.putInt(4, this.featureMode.getValue());
            }
            this.backing.putInt(8, this.minContrast);
            this.backing.putInt(12, this.subpixelAccuracy);
            this.angleRanges_buf = ByteBuffer.allocateDirect(this.angleRanges.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.angleRanges.length) {
                this.angleRanges[i].setBuffer(this.angleRanges_buf, off);
                this.angleRanges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(20, this.angleRanges.length);
            NIVision.putPointer(this.backing, 16, this.angleRanges_buf);
            this.backing.putDouble(24, this.colorWeight);
            if (this.sensitivity != null) {
                this.backing.putInt(32, this.sensitivity.getValue());
            }
            if (this.strategy != null) {
                this.backing.putInt(36, this.strategy.getValue());
            }
            this.backing.putInt(40, this.numMatchesRequested);
            this.backing.putFloat(44, this.minMatchScore);
        }

        @Override
        public int size() {
            return 48;
        }
    }

    public static class LineProfile
    extends DisposedStruct {
        public float[] profileData;
        public Rect boundingBox;
        public float min;
        public float max;
        public float mean;
        public float stdDev;
        private ByteBuffer profileData_buf;

        private void init() {
            this.profileData = new float[0];
            this.boundingBox = new Rect(this.backing, 4);
        }

        public LineProfile() {
            super(40);
            this.init();
        }

        public LineProfile(float[] profileData, Rect boundingBox, double min, double max, double mean, double stdDev) {
            super(40);
            this.profileData = profileData;
            this.boundingBox = boundingBox;
            this.min = (float)min;
            this.max = (float)max;
            this.mean = (float)mean;
            this.stdDev = (float)stdDev;
        }

        protected LineProfile(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected LineProfile(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            int profileData_dataCount = this.backing.getInt(36);
            long profileData_addr = NIVision.getPointer(this.backing, 0);
            this.profileData = new float[profileData_dataCount];
            if (profileData_dataCount > 0 && profileData_addr != 0L) {
                NIVision.newDirectByteBuffer(profileData_addr, profileData_dataCount * 4).asFloatBuffer().get(this.profileData);
            }
            this.boundingBox.read();
            this.min = this.backing.getFloat(20);
            this.max = this.backing.getFloat(24);
            this.mean = this.backing.getFloat(28);
            this.stdDev = this.backing.getFloat(32);
        }

        @Override
        public void write() {
            this.profileData_buf = ByteBuffer.allocateDirect(this.profileData.length * 4).order(ByteOrder.nativeOrder());
            this.profileData_buf.asFloatBuffer().put(this.profileData).rewind();
            this.backing.putInt(36, this.profileData.length);
            NIVision.putPointer(this.backing, 0, this.profileData_buf);
            this.boundingBox.write();
            this.backing.putFloat(20, this.min);
            this.backing.putFloat(24, this.max);
            this.backing.putFloat(28, this.mean);
            this.backing.putFloat(32, this.stdDev);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class LinearAverages
    extends DisposedStruct {
        public float[] columnAverages;
        public float[] rowAverages;
        public float[] risingDiagAverages;
        public float[] fallingDiagAverages;
        private ByteBuffer columnAverages_buf;
        private ByteBuffer rowAverages_buf;
        private ByteBuffer risingDiagAverages_buf;
        private ByteBuffer fallingDiagAverages_buf;

        private void init() {
            this.columnAverages = new float[0];
            this.rowAverages = new float[0];
            this.risingDiagAverages = new float[0];
            this.fallingDiagAverages = new float[0];
        }

        public LinearAverages() {
            super(32);
            this.init();
        }

        public LinearAverages(float[] columnAverages, float[] rowAverages, float[] risingDiagAverages, float[] fallingDiagAverages) {
            super(32);
            this.columnAverages = columnAverages;
            this.rowAverages = rowAverages;
            this.risingDiagAverages = risingDiagAverages;
            this.fallingDiagAverages = fallingDiagAverages;
        }

        protected LinearAverages(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected LinearAverages(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            int columnAverages_columnCount = this.backing.getInt(4);
            long columnAverages_addr = NIVision.getPointer(this.backing, 0);
            this.columnAverages = new float[columnAverages_columnCount];
            if (columnAverages_columnCount > 0 && columnAverages_addr != 0L) {
                NIVision.newDirectByteBuffer(columnAverages_addr, columnAverages_columnCount * 4).asFloatBuffer().get(this.columnAverages);
            }
            int rowAverages_rowCount = this.backing.getInt(12);
            long rowAverages_addr = NIVision.getPointer(this.backing, 8);
            this.rowAverages = new float[rowAverages_rowCount];
            if (rowAverages_rowCount > 0 && rowAverages_addr != 0L) {
                NIVision.newDirectByteBuffer(rowAverages_addr, rowAverages_rowCount * 4).asFloatBuffer().get(this.rowAverages);
            }
            int risingDiagAverages_risingDiagCount = this.backing.getInt(20);
            long risingDiagAverages_addr = NIVision.getPointer(this.backing, 16);
            this.risingDiagAverages = new float[risingDiagAverages_risingDiagCount];
            if (risingDiagAverages_risingDiagCount > 0 && risingDiagAverages_addr != 0L) {
                NIVision.newDirectByteBuffer(risingDiagAverages_addr, risingDiagAverages_risingDiagCount * 4).asFloatBuffer().get(this.risingDiagAverages);
            }
            int fallingDiagAverages_fallingDiagCount = this.backing.getInt(28);
            long fallingDiagAverages_addr = NIVision.getPointer(this.backing, 24);
            this.fallingDiagAverages = new float[fallingDiagAverages_fallingDiagCount];
            if (fallingDiagAverages_fallingDiagCount > 0 && fallingDiagAverages_addr != 0L) {
                NIVision.newDirectByteBuffer(fallingDiagAverages_addr, fallingDiagAverages_fallingDiagCount * 4).asFloatBuffer().get(this.fallingDiagAverages);
            }
        }

        @Override
        public void write() {
            this.columnAverages_buf = ByteBuffer.allocateDirect(this.columnAverages.length * 4).order(ByteOrder.nativeOrder());
            this.columnAverages_buf.asFloatBuffer().put(this.columnAverages).rewind();
            this.backing.putInt(4, this.columnAverages.length);
            NIVision.putPointer(this.backing, 0, this.columnAverages_buf);
            this.rowAverages_buf = ByteBuffer.allocateDirect(this.rowAverages.length * 4).order(ByteOrder.nativeOrder());
            this.rowAverages_buf.asFloatBuffer().put(this.rowAverages).rewind();
            this.backing.putInt(12, this.rowAverages.length);
            NIVision.putPointer(this.backing, 8, this.rowAverages_buf);
            this.risingDiagAverages_buf = ByteBuffer.allocateDirect(this.risingDiagAverages.length * 4).order(ByteOrder.nativeOrder());
            this.risingDiagAverages_buf.asFloatBuffer().put(this.risingDiagAverages).rewind();
            this.backing.putInt(20, this.risingDiagAverages.length);
            NIVision.putPointer(this.backing, 16, this.risingDiagAverages_buf);
            this.fallingDiagAverages_buf = ByteBuffer.allocateDirect(this.fallingDiagAverages.length * 4).order(ByteOrder.nativeOrder());
            this.fallingDiagAverages_buf.asFloatBuffer().put(this.fallingDiagAverages).rewind();
            this.backing.putInt(28, this.fallingDiagAverages.length);
            NIVision.putPointer(this.backing, 24, this.fallingDiagAverages_buf);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class Line
    extends DisposedStruct {
        public Point start;
        public Point end;

        private void init() {
            this.start = new Point(this.backing, 0);
            this.end = new Point(this.backing, 8);
        }

        public Line() {
            super(16);
            this.init();
        }

        public Line(Point start, Point end) {
            super(16);
            this.start = start;
            this.end = end;
        }

        protected Line(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected Line(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.start.read();
            this.end.read();
        }

        @Override
        public void write() {
            this.start.write();
            this.end.write();
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class LearnColorPatternOptions
    extends DisposedStruct {
        public LearningMode learnMode;
        public ImageFeatureMode featureMode;
        public int threshold;
        public ColorIgnoreMode ignoreMode;
        public ColorInformation[] colorsToIgnore;
        private ByteBuffer colorsToIgnore_buf;

        private void init() {
            this.colorsToIgnore = new ColorInformation[0];
        }

        public LearnColorPatternOptions() {
            super(24);
            this.init();
        }

        public LearnColorPatternOptions(LearningMode learnMode, ImageFeatureMode featureMode, int threshold, ColorIgnoreMode ignoreMode, ColorInformation[] colorsToIgnore) {
            super(24);
            this.learnMode = learnMode;
            this.featureMode = featureMode;
            this.threshold = threshold;
            this.ignoreMode = ignoreMode;
            this.colorsToIgnore = colorsToIgnore;
        }

        protected LearnColorPatternOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected LearnColorPatternOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.learnMode = LearningMode.fromValue(this.backing.getInt(0));
            this.featureMode = ImageFeatureMode.fromValue(this.backing.getInt(4));
            this.threshold = this.backing.getInt(8);
            this.ignoreMode = ColorIgnoreMode.fromValue(this.backing.getInt(12));
            int colorsToIgnore_numColorsToIgnore = this.backing.getInt(20);
            long colorsToIgnore_addr = NIVision.getPointer(this.backing, 16);
            this.colorsToIgnore = new ColorInformation[colorsToIgnore_numColorsToIgnore];
            if (colorsToIgnore_numColorsToIgnore > 0 && colorsToIgnore_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(colorsToIgnore_addr, colorsToIgnore_numColorsToIgnore * 12);
                int i = 0;
                int off = 0;
                while (i < colorsToIgnore_numColorsToIgnore) {
                    this.colorsToIgnore[i] = new ColorInformation(bb, off);
                    this.colorsToIgnore[i].read();
                    ++i;
                    off += 12;
                }
            }
        }

        @Override
        public void write() {
            if (this.learnMode != null) {
                this.backing.putInt(0, this.learnMode.getValue());
            }
            if (this.featureMode != null) {
                this.backing.putInt(4, this.featureMode.getValue());
            }
            this.backing.putInt(8, this.threshold);
            if (this.ignoreMode != null) {
                this.backing.putInt(12, this.ignoreMode.getValue());
            }
            this.colorsToIgnore_buf = ByteBuffer.allocateDirect(this.colorsToIgnore.length * 12).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.colorsToIgnore.length) {
                this.colorsToIgnore[i].setBuffer(this.colorsToIgnore_buf, off);
                this.colorsToIgnore[i].write();
                ++i;
                off += 12;
            }
            this.backing.putInt(20, this.colorsToIgnore.length);
            NIVision.putPointer(this.backing, 16, this.colorsToIgnore_buf);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class LearnCalibrationOptions
    extends DisposedStruct {
        public CalibrationMode mode;
        public ScalingMethod method;
        public CalibrationROI roi;
        public int learnMap;
        public int learnTable;

        private void init() {
        }

        public LearnCalibrationOptions() {
            super(20);
            this.init();
        }

        public LearnCalibrationOptions(CalibrationMode mode, ScalingMethod method, CalibrationROI roi, int learnMap, int learnTable) {
            super(20);
            this.mode = mode;
            this.method = method;
            this.roi = roi;
            this.learnMap = learnMap;
            this.learnTable = learnTable;
        }

        protected LearnCalibrationOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected LearnCalibrationOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.mode = CalibrationMode.fromValue(this.backing.getInt(0));
            this.method = ScalingMethod.fromValue(this.backing.getInt(4));
            this.roi = CalibrationROI.fromValue(this.backing.getInt(8));
            this.learnMap = this.backing.getInt(12);
            this.learnTable = this.backing.getInt(16);
        }

        @Override
        public void write() {
            if (this.mode != null) {
                this.backing.putInt(0, this.mode.getValue());
            }
            if (this.method != null) {
                this.backing.putInt(4, this.method.getValue());
            }
            if (this.roi != null) {
                this.backing.putInt(8, this.roi.getValue());
            }
            this.backing.putInt(12, this.learnMap);
            this.backing.putInt(16, this.learnTable);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class LCDSegments
    extends DisposedStruct {
        private void init() {
        }

        public LCDSegments() {
            super(4);
            this.init();
        }

        protected LCDSegments(ByteBuffer backing, int offset) {
            super(backing, offset, 4);
            this.init();
        }

        protected LCDSegments(long nativeObj, boolean owned) {
            super(nativeObj, owned, 4);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 4);
        }

        @Override
        public void read() {
        }

        @Override
        public void write() {
        }

        @Override
        public int size() {
            return 4;
        }
    }

    public static class LCDReport
    extends DisposedStruct {
        public String text;
        public LCDSegments[] segmentInfo;
        private ByteBuffer text_buf;
        private ByteBuffer segmentInfo_buf;

        private void init() {
            this.segmentInfo = new LCDSegments[0];
        }

        public LCDReport() {
            super(16);
            this.init();
        }

        public LCDReport(String text, LCDSegments[] segmentInfo) {
            super(16);
            this.text = text;
            this.segmentInfo = segmentInfo;
        }

        protected LCDReport(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected LCDReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            long text_addr = NIVision.getPointer(this.backing, 0);
            if (text_addr == 0L) {
                this.text = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(text_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.text = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.text = "";
                }
            }
            int segmentInfo_numCharacters = this.backing.getInt(8);
            long segmentInfo_addr = NIVision.getPointer(this.backing, 4);
            this.segmentInfo = new LCDSegments[segmentInfo_numCharacters];
            if (segmentInfo_numCharacters > 0 && segmentInfo_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(segmentInfo_addr, segmentInfo_numCharacters * 4);
                int i = 0;
                int off = 0;
                while (i < segmentInfo_numCharacters) {
                    this.segmentInfo[i] = new LCDSegments(bb, off);
                    this.segmentInfo[i].read();
                    ++i;
                    off += 4;
                }
            }
        }

        @Override
        public void write() {
            if (this.text != null) {
                byte[] text_bytes;
                try {
                    text_bytes = this.text.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    text_bytes = new byte[]{};
                }
                this.text_buf = ByteBuffer.allocateDirect(text_bytes.length + 1);
                NIVision.putBytes(this.text_buf, text_bytes, 0, text_bytes.length).put(text_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.text == null ? 0L : NIVision.getByteBufferAddress(this.text_buf));
            this.segmentInfo_buf = ByteBuffer.allocateDirect(this.segmentInfo.length * 4).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.segmentInfo.length) {
                this.segmentInfo[i].setBuffer(this.segmentInfo_buf, off);
                this.segmentInfo[i].write();
                ++i;
                off += 4;
            }
            this.backing.putInt(8, this.segmentInfo.length);
            NIVision.putPointer(this.backing, 4, this.segmentInfo_buf);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class LCDOptions
    extends DisposedStruct {
        public int litSegments;
        public float threshold;
        public int sign;
        public int decimalPoint;

        private void init() {
        }

        public LCDOptions() {
            super(16);
            this.init();
        }

        public LCDOptions(int litSegments, double threshold, int sign, int decimalPoint) {
            super(16);
            this.litSegments = litSegments;
            this.threshold = (float)threshold;
            this.sign = sign;
            this.decimalPoint = decimalPoint;
        }

        protected LCDOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected LCDOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.litSegments = this.backing.getInt(0);
            this.threshold = this.backing.getFloat(4);
            this.sign = this.backing.getInt(8);
            this.decimalPoint = this.backing.getInt(12);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.litSegments);
            this.backing.putFloat(4, this.threshold);
            this.backing.putInt(8, this.sign);
            this.backing.putInt(12, this.decimalPoint);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ImageInfo
    extends DisposedStruct {
        public CalibrationUnit imageUnit;
        public float stepX;
        public float stepY;
        public ImageType imageType;
        public int xRes;
        public int yRes;
        public int xOffset;
        public int yOffset;
        public int border;
        public int pixelsPerLine;

        private void init() {
        }

        public ImageInfo() {
            super(52);
            this.init();
        }

        public ImageInfo(CalibrationUnit imageUnit, double stepX, double stepY, ImageType imageType, int xRes, int yRes, int xOffset, int yOffset, int border, int pixelsPerLine) {
            super(52);
            this.imageUnit = imageUnit;
            this.stepX = (float)stepX;
            this.stepY = (float)stepY;
            this.imageType = imageType;
            this.xRes = xRes;
            this.yRes = yRes;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.border = border;
            this.pixelsPerLine = pixelsPerLine;
        }

        protected ImageInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 52);
            this.init();
        }

        protected ImageInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 52);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 52);
        }

        @Override
        public void read() {
            this.imageUnit = CalibrationUnit.fromValue(this.backing.getInt(0));
            this.stepX = this.backing.getFloat(4);
            this.stepY = this.backing.getFloat(8);
            this.imageType = ImageType.fromValue(this.backing.getInt(12));
            this.xRes = this.backing.getInt(16);
            this.yRes = this.backing.getInt(20);
            this.xOffset = this.backing.getInt(24);
            this.yOffset = this.backing.getInt(28);
            this.border = this.backing.getInt(32);
            this.pixelsPerLine = this.backing.getInt(36);
        }

        @Override
        public void write() {
            if (this.imageUnit != null) {
                this.backing.putInt(0, this.imageUnit.getValue());
            }
            this.backing.putFloat(4, this.stepX);
            this.backing.putFloat(8, this.stepY);
            if (this.imageType != null) {
                this.backing.putInt(12, this.imageType.getValue());
            }
            this.backing.putInt(16, this.xRes);
            this.backing.putInt(20, this.yRes);
            this.backing.putInt(24, this.xOffset);
            this.backing.putInt(28, this.yOffset);
            this.backing.putInt(32, this.border);
            this.backing.putInt(36, this.pixelsPerLine);
        }

        @Override
        public int size() {
            return 52;
        }
    }

    public static class DetectExtremesOptions
    extends DisposedStruct {
        public double threshold;
        public int width;

        private void init() {
        }

        public DetectExtremesOptions() {
            super(16);
            this.init();
        }

        public DetectExtremesOptions(double threshold, int width) {
            super(16);
            this.threshold = threshold;
            this.width = width;
        }

        protected DetectExtremesOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected DetectExtremesOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.threshold = this.backing.getDouble(0);
            this.width = this.backing.getInt(8);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.threshold);
            this.backing.putInt(8, this.width);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class DisplayMapping
    extends DisposedStruct {
        public MappingMethod method;
        public int minimumValue;
        public int maximumValue;
        public int shiftCount;

        private void init() {
        }

        public DisplayMapping() {
            super(16);
            this.init();
        }

        public DisplayMapping(MappingMethod method, int minimumValue, int maximumValue, int shiftCount) {
            super(16);
            this.method = method;
            this.minimumValue = minimumValue;
            this.maximumValue = maximumValue;
            this.shiftCount = shiftCount;
        }

        protected DisplayMapping(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected DisplayMapping(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.method = MappingMethod.fromValue(this.backing.getInt(0));
            this.minimumValue = this.backing.getInt(4);
            this.maximumValue = this.backing.getInt(8);
            this.shiftCount = this.backing.getInt(12);
        }

        @Override
        public void write() {
            if (this.method != null) {
                this.backing.putInt(0, this.method.getValue());
            }
            this.backing.putInt(4, this.minimumValue);
            this.backing.putInt(8, this.maximumValue);
            this.backing.putInt(12, this.shiftCount);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class FitLineOptions
    extends DisposedStruct {
        public float minScore;
        public float pixelRadius;
        public int numRefinements;

        private void init() {
        }

        public FitLineOptions() {
            super(12);
            this.init();
        }

        public FitLineOptions(double minScore, double pixelRadius, int numRefinements) {
            super(12);
            this.minScore = (float)minScore;
            this.pixelRadius = (float)pixelRadius;
            this.numRefinements = numRefinements;
        }

        protected FitLineOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected FitLineOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.minScore = this.backing.getFloat(0);
            this.pixelRadius = this.backing.getFloat(4);
            this.numRefinements = this.backing.getInt(8);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.minScore);
            this.backing.putFloat(4, this.pixelRadius);
            this.backing.putInt(8, this.numRefinements);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class ExtremeReport
    extends DisposedStruct {
        public double location;
        public double amplitude;
        public double secondDerivative;

        private void init() {
        }

        public ExtremeReport() {
            super(24);
            this.init();
        }

        public ExtremeReport(double location, double amplitude, double secondDerivative) {
            super(24);
            this.location = location;
            this.amplitude = amplitude;
            this.secondDerivative = secondDerivative;
        }

        protected ExtremeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected ExtremeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.location = this.backing.getDouble(0);
            this.amplitude = this.backing.getDouble(8);
            this.secondDerivative = this.backing.getDouble(16);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.location);
            this.backing.putDouble(8, this.amplitude);
            this.backing.putDouble(16, this.secondDerivative);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class EdgeReport
    extends DisposedStruct {
        public float location;
        public float contrast;
        public PolarityType polarity;
        public float reserved;
        public PointFloat coordinate;

        private void init() {
            this.coordinate = new PointFloat(this.backing, 20);
        }

        public EdgeReport() {
            super(32);
            this.init();
        }

        public EdgeReport(double location, double contrast, PolarityType polarity, double reserved, PointFloat coordinate) {
            super(32);
            this.location = (float)location;
            this.contrast = (float)contrast;
            this.polarity = polarity;
            this.reserved = (float)reserved;
            this.coordinate = coordinate;
        }

        protected EdgeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected EdgeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.location = this.backing.getFloat(0);
            this.contrast = this.backing.getFloat(4);
            this.polarity = PolarityType.fromValue(this.backing.getInt(8));
            this.reserved = this.backing.getFloat(16);
            this.coordinate.read();
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.location);
            this.backing.putFloat(4, this.contrast);
            if (this.polarity != null) {
                this.backing.putInt(8, this.polarity.getValue());
            }
            this.backing.putFloat(16, this.reserved);
            this.coordinate.write();
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class EdgeOptions
    extends DisposedStruct {
        public int threshold;
        public int width;
        public int steepness;
        public InterpolationMethod subpixelType;
        public int subpixelDivisions;

        private void init() {
        }

        public EdgeOptions() {
            super(20);
            this.init();
        }

        public EdgeOptions(int threshold, int width, int steepness, InterpolationMethod subpixelType, int subpixelDivisions) {
            super(20);
            this.threshold = threshold;
            this.width = width;
            this.steepness = steepness;
            this.subpixelType = subpixelType;
            this.subpixelDivisions = subpixelDivisions;
        }

        protected EdgeOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected EdgeOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.threshold = this.backing.getInt(0);
            this.width = this.backing.getInt(4);
            this.steepness = this.backing.getInt(8);
            this.subpixelType = InterpolationMethod.fromValue(this.backing.getInt(12));
            this.subpixelDivisions = this.backing.getInt(16);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.threshold);
            this.backing.putInt(4, this.width);
            this.backing.putInt(8, this.steepness);
            if (this.subpixelType != null) {
                this.backing.putInt(12, this.subpixelType.getValue());
            }
            this.backing.putInt(16, this.subpixelDivisions);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class EdgeLocationReport
    extends DisposedStruct {
        public PointFloat[] edges;
        private ByteBuffer edges_buf;

        private void init() {
            this.edges = new PointFloat[0];
        }

        public EdgeLocationReport() {
            super(8);
            this.init();
        }

        public EdgeLocationReport(PointFloat[] edges) {
            super(8);
            this.edges = edges;
        }

        protected EdgeLocationReport(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected EdgeLocationReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            int edges_numEdges = this.backing.getInt(4);
            long edges_addr = NIVision.getPointer(this.backing, 0);
            this.edges = new PointFloat[edges_numEdges];
            if (edges_numEdges > 0 && edges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(edges_addr, edges_numEdges * 8);
                int i = 0;
                int off = 0;
                while (i < edges_numEdges) {
                    this.edges[i] = new PointFloat(bb, off);
                    this.edges[i].read();
                    ++i;
                    off += 8;
                }
            }
        }

        @Override
        public void write() {
            this.edges_buf = ByteBuffer.allocateDirect(this.edges.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.edges.length) {
                this.edges[i].setBuffer(this.edges_buf, off);
                this.edges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(4, this.edges.length);
            NIVision.putPointer(this.backing, 0, this.edges_buf);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class Annulus
    extends DisposedStruct {
        public Point center;
        public int innerRadius;
        public int outerRadius;
        public double startAngle;
        public double endAngle;

        private void init() {
            this.center = new Point(this.backing, 0);
        }

        public Annulus() {
            super(32);
            this.init();
        }

        public Annulus(Point center, int innerRadius, int outerRadius, double startAngle, double endAngle) {
            super(32);
            this.center = center;
            this.innerRadius = innerRadius;
            this.outerRadius = outerRadius;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        protected Annulus(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected Annulus(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.center.read();
            this.innerRadius = this.backing.getInt(8);
            this.outerRadius = this.backing.getInt(12);
            this.startAngle = this.backing.getDouble(16);
            this.endAngle = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.center.write();
            this.backing.putInt(8, this.innerRadius);
            this.backing.putInt(12, this.outerRadius);
            this.backing.putDouble(16, this.startAngle);
            this.backing.putDouble(24, this.endAngle);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class Point
    extends DisposedStruct {
        public int x;
        public int y;

        private void init() {
        }

        public Point() {
            super(8);
            this.init();
        }

        public Point(int x, int y) {
            super(8);
            this.x = x;
            this.y = y;
        }

        protected Point(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected Point(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.x = this.backing.getInt(0);
            this.y = this.backing.getInt(4);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.x);
            this.backing.putInt(4, this.y);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class ReadTextReport
    extends DisposedStruct {
        public String readString;
        public CharReport[] characterReport;
        private ByteBuffer readString_buf;
        private ByteBuffer characterReport_buf;

        private void init() {
            this.characterReport = new CharReport[0];
        }

        public ReadTextReport() {
            super(12);
            this.init();
        }

        public ReadTextReport(String readString, CharReport[] characterReport) {
            super(12);
            this.readString = readString;
            this.characterReport = characterReport;
        }

        protected ReadTextReport(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected ReadTextReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            long readString_addr = NIVision.getPointer(this.backing, 0);
            if (readString_addr == 0L) {
                this.readString = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(readString_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.readString = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.readString = "";
                }
            }
            int characterReport_numCharacterReports = this.backing.getInt(8);
            long characterReport_addr = NIVision.getPointer(this.backing, 4);
            this.characterReport = new CharReport[characterReport_numCharacterReports];
            if (characterReport_numCharacterReports > 0 && characterReport_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(characterReport_addr, characterReport_numCharacterReports * 48);
                int i = 0;
                int off = 0;
                while (i < characterReport_numCharacterReports) {
                    this.characterReport[i] = new CharReport(bb, off);
                    this.characterReport[i].read();
                    ++i;
                    off += 48;
                }
            }
        }

        @Override
        public void write() {
            if (this.readString != null) {
                byte[] readString_bytes;
                try {
                    readString_bytes = this.readString.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    readString_bytes = new byte[]{};
                }
                this.readString_buf = ByteBuffer.allocateDirect(readString_bytes.length + 1);
                NIVision.putBytes(this.readString_buf, readString_bytes, 0, readString_bytes.length).put(readString_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.readString == null ? 0L : NIVision.getByteBufferAddress(this.readString_buf));
            this.characterReport_buf = ByteBuffer.allocateDirect(this.characterReport.length * 48).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.characterReport.length) {
                this.characterReport[i].setBuffer(this.characterReport_buf, off);
                this.characterReport[i].write();
                ++i;
                off += 48;
            }
            this.backing.putInt(8, this.characterReport.length);
            NIVision.putPointer(this.backing, 4, this.characterReport_buf);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class CharReport
    extends DisposedStruct {
        public String character;
        public PointFloat[] corner;
        public int reserved;
        public int lowThreshold;
        public int highThreshold;
        private ByteBuffer character_buf;

        private void init() {
            this.corner = new PointFloat[4];
            int i = 0;
            int off = 4;
            while (i < 4) {
                this.corner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public CharReport() {
            super(48);
            this.init();
        }

        public CharReport(String character, PointFloat[] corner, int reserved, int lowThreshold, int highThreshold) {
            super(48);
            this.character = character;
            this.corner = corner;
            this.reserved = reserved;
            this.lowThreshold = lowThreshold;
            this.highThreshold = highThreshold;
        }

        protected CharReport(ByteBuffer backing, int offset) {
            super(backing, offset, 48);
            this.init();
        }

        protected CharReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 48);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 48);
        }

        @Override
        public void read() {
            long character_addr = NIVision.getPointer(this.backing, 0);
            if (character_addr == 0L) {
                this.character = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(character_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.character = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.character = "";
                }
            }
            for (PointFloat it : this.corner) {
                it.read();
            }
            this.reserved = this.backing.getInt(36);
            this.lowThreshold = this.backing.getInt(40);
            this.highThreshold = this.backing.getInt(44);
        }

        @Override
        public void write() {
            if (this.character != null) {
                byte[] character_bytes;
                try {
                    character_bytes = this.character.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    character_bytes = new byte[]{};
                }
                this.character_buf = ByteBuffer.allocateDirect(character_bytes.length + 1);
                NIVision.putBytes(this.character_buf, character_bytes, 0, character_bytes.length).put(character_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.character == null ? 0L : NIVision.getByteBufferAddress(this.character_buf));
            for (PointFloat it : this.corner) {
                it.write();
            }
            this.backing.putInt(36, this.reserved);
            this.backing.putInt(40, this.lowThreshold);
            this.backing.putInt(44, this.highThreshold);
        }

        @Override
        public int size() {
            return 48;
        }
    }

    public static class Rect
    extends DisposedStruct {
        public int top;
        public int left;
        public int height;
        public int width;

        private void init() {
        }

        public Rect() {
            super(16);
            this.init();
        }

        public Rect(int top, int left, int height, int width) {
            super(16);
            this.top = top;
            this.left = left;
            this.height = height;
            this.width = width;
        }

        protected Rect(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected Rect(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.top = this.backing.getInt(0);
            this.left = this.backing.getInt(4);
            this.height = this.backing.getInt(8);
            this.width = this.backing.getInt(12);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.top);
            this.backing.putInt(4, this.left);
            this.backing.putInt(8, this.height);
            this.backing.putInt(12, this.width);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class CharInfo
    extends DisposedStruct {
        public String charValue;
        public Image charImage;
        public Image internalImage;
        private ByteBuffer charValue_buf;

        private void init() {
        }

        public CharInfo() {
            super(12);
            this.init();
        }

        public CharInfo(String charValue, Image charImage, Image internalImage) {
            super(12);
            this.charValue = charValue;
            this.charImage = charImage;
            this.internalImage = internalImage;
        }

        protected CharInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected CharInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            long charValue_addr = NIVision.getPointer(this.backing, 0);
            if (charValue_addr == 0L) {
                this.charValue = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(charValue_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.charValue = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.charValue = "";
                }
            }
            long charImage_addr = NIVision.getPointer(this.backing, 4);
            this.charImage = charImage_addr == 0L ? null : new Image(charImage_addr, false);
            long internalImage_addr = NIVision.getPointer(this.backing, 8);
            this.internalImage = internalImage_addr == 0L ? null : new Image(internalImage_addr, false);
        }

        @Override
        public void write() {
            if (this.charValue != null) {
                byte[] charValue_bytes;
                try {
                    charValue_bytes = this.charValue.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    charValue_bytes = new byte[]{};
                }
                this.charValue_buf = ByteBuffer.allocateDirect(charValue_bytes.length + 1);
                NIVision.putBytes(this.charValue_buf, charValue_bytes, 0, charValue_bytes.length).put(charValue_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.charValue == null ? 0L : NIVision.getByteBufferAddress(this.charValue_buf));
            NIVision.putPointer(this.backing, 4, this.charImage);
            NIVision.putPointer(this.backing, 8, this.internalImage);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class ReadTextOptions
    extends DisposedStruct {
        public String[] validChars;
        public byte substitutionChar;
        public ReadStrategy readStrategy;
        public int acceptanceLevel;
        public int aspectRatio;
        public ReadResolution readResolution;
        private ByteBuffer validChars_buf;
        private ByteBuffer[] validChars_bufs;

        private void init() {
            this.validChars = new String[0];
        }

        public ReadTextOptions() {
            super(65304);
            this.init();
        }

        public ReadTextOptions(String[] validChars, byte substitutionChar, ReadStrategy readStrategy, int acceptanceLevel, int aspectRatio, ReadResolution readResolution) {
            super(65304);
            this.validChars = validChars;
            this.substitutionChar = substitutionChar;
            this.readStrategy = readStrategy;
            this.acceptanceLevel = acceptanceLevel;
            this.aspectRatio = aspectRatio;
            this.readResolution = readResolution;
        }

        protected ReadTextOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 65304);
            this.init();
        }

        protected ReadTextOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 65304);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 65304);
        }

        @Override
        public void read() {
            int validChars_numValidChars = this.backing.getInt(65280);
            long validChars_addr = NIVision.getPointer(this.backing, 0);
            this.validChars = new String[validChars_numValidChars];
            if (validChars_numValidChars > 0 && validChars_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(validChars_addr, validChars_numValidChars * 4);
                int i = 0;
                int off = 0;
                while (i < validChars_numValidChars) {
                    long addr = NIVision.getPointer(bb, off);
                    if (addr == 0L) {
                        this.validChars[i] = null;
                    } else {
                        ByteBuffer bb2 = NIVision.newDirectByteBuffer(addr, 1000);
                        while (bb2.get() != 0) {
                        }
                        byte[] bytes = new byte[bb2.position() - 1];
                        bb2.rewind();
                        NIVision.getBytes(bb2, bytes, 0, bytes.length);
                        try {
                            this.validChars[i] = new String(bytes, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            this.validChars[i] = "";
                        }
                    }
                    ++i;
                    off += 4;
                }
            }
            this.substitutionChar = this.backing.get(65284);
            this.readStrategy = ReadStrategy.fromValue(this.backing.getInt(65288));
            this.acceptanceLevel = this.backing.getInt(65292);
            this.aspectRatio = this.backing.getInt(65296);
            this.readResolution = ReadResolution.fromValue(this.backing.getInt(65300));
        }

        @Override
        public void write() {
            this.validChars_buf = ByteBuffer.allocateDirect(this.validChars.length * 4).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.validChars.length) {
                if (this.validChars[i] == null) {
                    NIVision.putPointer(this.validChars_buf, off, 0L);
                } else {
                    byte[] bytes;
                    try {
                        bytes = this.validChars[i].getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        bytes = new byte[]{};
                    }
                    this.validChars_bufs[i] = ByteBuffer.allocateDirect(bytes.length + 1);
                    NIVision.putBytes(this.validChars_bufs[i], bytes, 0, bytes.length).put(bytes.length, (byte)0);
                    NIVision.putPointer(this.validChars_buf, off, NIVision.getByteBufferAddress(this.validChars_bufs[i]));
                }
                ++i;
                off += 4;
            }
            this.backing.putInt(65280, this.validChars.length);
            NIVision.putPointer(this.backing, 0, this.validChars_buf);
            this.backing.put(65284, this.substitutionChar);
            if (this.readStrategy != null) {
                this.backing.putInt(65288, this.readStrategy.getValue());
            }
            this.backing.putInt(65292, this.acceptanceLevel);
            this.backing.putInt(65296, this.aspectRatio);
            if (this.readResolution != null) {
                this.backing.putInt(65300, this.readResolution.getValue());
            }
        }

        @Override
        public int size() {
            return 65304;
        }
    }

    public static class OCRProcessingOptions
    extends DisposedStruct {
        public ThresholdMode mode;
        public int lowThreshold;
        public int highThreshold;
        public int blockCount;
        public int fastThreshold;
        public int biModalCalculation;
        public int darkCharacters;
        public int removeParticlesTouchingROI;
        public int erosionCount;

        private void init() {
        }

        public OCRProcessingOptions() {
            super(36);
            this.init();
        }

        public OCRProcessingOptions(ThresholdMode mode, int lowThreshold, int highThreshold, int blockCount, int fastThreshold, int biModalCalculation, int darkCharacters, int removeParticlesTouchingROI, int erosionCount) {
            super(36);
            this.mode = mode;
            this.lowThreshold = lowThreshold;
            this.highThreshold = highThreshold;
            this.blockCount = blockCount;
            this.fastThreshold = fastThreshold;
            this.biModalCalculation = biModalCalculation;
            this.darkCharacters = darkCharacters;
            this.removeParticlesTouchingROI = removeParticlesTouchingROI;
            this.erosionCount = erosionCount;
        }

        protected OCRProcessingOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected OCRProcessingOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            this.mode = ThresholdMode.fromValue(this.backing.getInt(0));
            this.lowThreshold = this.backing.getInt(4);
            this.highThreshold = this.backing.getInt(8);
            this.blockCount = this.backing.getInt(12);
            this.fastThreshold = this.backing.getInt(16);
            this.biModalCalculation = this.backing.getInt(20);
            this.darkCharacters = this.backing.getInt(24);
            this.removeParticlesTouchingROI = this.backing.getInt(28);
            this.erosionCount = this.backing.getInt(32);
        }

        @Override
        public void write() {
            if (this.mode != null) {
                this.backing.putInt(0, this.mode.getValue());
            }
            this.backing.putInt(4, this.lowThreshold);
            this.backing.putInt(8, this.highThreshold);
            this.backing.putInt(12, this.blockCount);
            this.backing.putInt(16, this.fastThreshold);
            this.backing.putInt(20, this.biModalCalculation);
            this.backing.putInt(24, this.darkCharacters);
            this.backing.putInt(28, this.removeParticlesTouchingROI);
            this.backing.putInt(32, this.erosionCount);
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class OCRSpacingOptions
    extends DisposedStruct {
        public int minCharSpacing;
        public int minCharSize;
        public int maxCharSize;
        public int maxHorizontalElementSpacing;
        public int maxVerticalElementSpacing;
        public int minBoundingRectWidth;
        public int maxBoundingRectWidth;
        public int minBoundingRectHeight;
        public int maxBoundingRectHeight;
        public int autoSplit;

        private void init() {
        }

        public OCRSpacingOptions() {
            super(40);
            this.init();
        }

        public OCRSpacingOptions(int minCharSpacing, int minCharSize, int maxCharSize, int maxHorizontalElementSpacing, int maxVerticalElementSpacing, int minBoundingRectWidth, int maxBoundingRectWidth, int minBoundingRectHeight, int maxBoundingRectHeight, int autoSplit) {
            super(40);
            this.minCharSpacing = minCharSpacing;
            this.minCharSize = minCharSize;
            this.maxCharSize = maxCharSize;
            this.maxHorizontalElementSpacing = maxHorizontalElementSpacing;
            this.maxVerticalElementSpacing = maxVerticalElementSpacing;
            this.minBoundingRectWidth = minBoundingRectWidth;
            this.maxBoundingRectWidth = maxBoundingRectWidth;
            this.minBoundingRectHeight = minBoundingRectHeight;
            this.maxBoundingRectHeight = maxBoundingRectHeight;
            this.autoSplit = autoSplit;
        }

        protected OCRSpacingOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected OCRSpacingOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.minCharSpacing = this.backing.getInt(0);
            this.minCharSize = this.backing.getInt(4);
            this.maxCharSize = this.backing.getInt(8);
            this.maxHorizontalElementSpacing = this.backing.getInt(12);
            this.maxVerticalElementSpacing = this.backing.getInt(16);
            this.minBoundingRectWidth = this.backing.getInt(20);
            this.maxBoundingRectWidth = this.backing.getInt(24);
            this.minBoundingRectHeight = this.backing.getInt(28);
            this.maxBoundingRectHeight = this.backing.getInt(32);
            this.autoSplit = this.backing.getInt(36);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.minCharSpacing);
            this.backing.putInt(4, this.minCharSize);
            this.backing.putInt(8, this.maxCharSize);
            this.backing.putInt(12, this.maxHorizontalElementSpacing);
            this.backing.putInt(16, this.maxVerticalElementSpacing);
            this.backing.putInt(20, this.minBoundingRectWidth);
            this.backing.putInt(24, this.maxBoundingRectWidth);
            this.backing.putInt(28, this.minBoundingRectHeight);
            this.backing.putInt(32, this.maxBoundingRectHeight);
            this.backing.putInt(36, this.autoSplit);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class BestCircle2
    extends DisposedStruct {
        public PointFloat center;
        public double radius;
        public double area;
        public double perimeter;
        public double error;
        public int valid;
        public int[] pointsUsed;
        private ByteBuffer pointsUsed_buf;

        private void init() {
            this.center = new PointFloat(this.backing, 0);
            this.pointsUsed = new int[0];
        }

        public BestCircle2() {
            super(56);
            this.init();
        }

        public BestCircle2(PointFloat center, double radius, double area, double perimeter, double error, int valid, int[] pointsUsed) {
            super(56);
            this.center = center;
            this.radius = radius;
            this.area = area;
            this.perimeter = perimeter;
            this.error = error;
            this.valid = valid;
            this.pointsUsed = pointsUsed;
        }

        protected BestCircle2(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected BestCircle2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            this.center.read();
            this.radius = this.backing.getDouble(8);
            this.area = this.backing.getDouble(16);
            this.perimeter = this.backing.getDouble(24);
            this.error = this.backing.getDouble(32);
            this.valid = this.backing.getInt(40);
            int pointsUsed_numPointsUsed = this.backing.getInt(48);
            long pointsUsed_addr = NIVision.getPointer(this.backing, 44);
            this.pointsUsed = new int[pointsUsed_numPointsUsed];
            if (pointsUsed_numPointsUsed > 0 && pointsUsed_addr != 0L) {
                NIVision.newDirectByteBuffer(pointsUsed_addr, pointsUsed_numPointsUsed * 4).asIntBuffer().get(this.pointsUsed);
            }
        }

        @Override
        public void write() {
            this.center.write();
            this.backing.putDouble(8, this.radius);
            this.backing.putDouble(16, this.area);
            this.backing.putDouble(24, this.perimeter);
            this.backing.putDouble(32, this.error);
            this.backing.putInt(40, this.valid);
            this.pointsUsed_buf = ByteBuffer.allocateDirect(this.pointsUsed.length * 4).order(ByteOrder.nativeOrder());
            this.pointsUsed_buf.asIntBuffer().put(this.pointsUsed).rewind();
            this.backing.putInt(48, this.pointsUsed.length);
            NIVision.putPointer(this.backing, 44, this.pointsUsed_buf);
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class ParticleFilterCriteria2
    extends DisposedStruct {
        public MeasurementType parameter;
        public float lower;
        public float upper;
        public int calibrated;
        public int exclude;

        private void init() {
        }

        public ParticleFilterCriteria2() {
            super(20);
            this.init();
        }

        public ParticleFilterCriteria2(MeasurementType parameter, double lower, double upper, int calibrated, int exclude) {
            super(20);
            this.parameter = parameter;
            this.lower = (float)lower;
            this.upper = (float)upper;
            this.calibrated = calibrated;
            this.exclude = exclude;
        }

        protected ParticleFilterCriteria2(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected ParticleFilterCriteria2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.parameter = MeasurementType.fromValue(this.backing.getInt(0));
            this.lower = this.backing.getFloat(4);
            this.upper = this.backing.getFloat(8);
            this.calibrated = this.backing.getInt(12);
            this.exclude = this.backing.getInt(16);
        }

        @Override
        public void write() {
            if (this.parameter != null) {
                this.backing.putInt(0, this.parameter.getValue());
            }
            this.backing.putFloat(4, this.lower);
            this.backing.putFloat(8, this.upper);
            this.backing.putInt(12, this.calibrated);
            this.backing.putInt(16, this.exclude);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class MatchPatternAdvancedOptions
    extends DisposedStruct {
        public int subpixelIterations;
        public double subpixelTolerance;
        public int initialMatchListLength;
        public int matchListReductionFactor;
        public int initialStepSize;
        public SearchStrategy searchStrategy;
        public int intermediateAngularAccuracy;

        private void init() {
        }

        public MatchPatternAdvancedOptions() {
            super(40);
            this.init();
        }

        public MatchPatternAdvancedOptions(int subpixelIterations, double subpixelTolerance, int initialMatchListLength, int matchListReductionFactor, int initialStepSize, SearchStrategy searchStrategy, int intermediateAngularAccuracy) {
            super(40);
            this.subpixelIterations = subpixelIterations;
            this.subpixelTolerance = subpixelTolerance;
            this.initialMatchListLength = initialMatchListLength;
            this.matchListReductionFactor = matchListReductionFactor;
            this.initialStepSize = initialStepSize;
            this.searchStrategy = searchStrategy;
            this.intermediateAngularAccuracy = intermediateAngularAccuracy;
        }

        protected MatchPatternAdvancedOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected MatchPatternAdvancedOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.subpixelIterations = this.backing.getInt(0);
            this.subpixelTolerance = this.backing.getDouble(8);
            this.initialMatchListLength = this.backing.getInt(16);
            this.matchListReductionFactor = this.backing.getInt(20);
            this.initialStepSize = this.backing.getInt(24);
            this.searchStrategy = SearchStrategy.fromValue(this.backing.getInt(28));
            this.intermediateAngularAccuracy = this.backing.getInt(32);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.subpixelIterations);
            this.backing.putDouble(8, this.subpixelTolerance);
            this.backing.putInt(16, this.initialMatchListLength);
            this.backing.putInt(20, this.matchListReductionFactor);
            this.backing.putInt(24, this.initialStepSize);
            if (this.searchStrategy != null) {
                this.backing.putInt(28, this.searchStrategy.getValue());
            }
            this.backing.putInt(32, this.intermediateAngularAccuracy);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class LearnPatternAdvancedRotationOptions
    extends DisposedStruct {
        public SearchStrategy searchStrategySupport;
        public int initialStepSize;
        public int initialSampleSize;
        public double initialSampleSizeFactor;
        public int initialAngularAccuracy;
        public int finalSampleSize;
        public double finalSampleSizeFactor;
        public int finalAngularAccuracy;
        public int subpixelSampleSize;
        public double subpixelSampleSizeFactor;

        private void init() {
        }

        public LearnPatternAdvancedRotationOptions() {
            super(56);
            this.init();
        }

        public LearnPatternAdvancedRotationOptions(SearchStrategy searchStrategySupport, int initialStepSize, int initialSampleSize, double initialSampleSizeFactor, int initialAngularAccuracy, int finalSampleSize, double finalSampleSizeFactor, int finalAngularAccuracy, int subpixelSampleSize, double subpixelSampleSizeFactor) {
            super(56);
            this.searchStrategySupport = searchStrategySupport;
            this.initialStepSize = initialStepSize;
            this.initialSampleSize = initialSampleSize;
            this.initialSampleSizeFactor = initialSampleSizeFactor;
            this.initialAngularAccuracy = initialAngularAccuracy;
            this.finalSampleSize = finalSampleSize;
            this.finalSampleSizeFactor = finalSampleSizeFactor;
            this.finalAngularAccuracy = finalAngularAccuracy;
            this.subpixelSampleSize = subpixelSampleSize;
            this.subpixelSampleSizeFactor = subpixelSampleSizeFactor;
        }

        protected LearnPatternAdvancedRotationOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected LearnPatternAdvancedRotationOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            this.searchStrategySupport = SearchStrategy.fromValue(this.backing.getInt(0));
            this.initialStepSize = this.backing.getInt(4);
            this.initialSampleSize = this.backing.getInt(8);
            this.initialSampleSizeFactor = this.backing.getDouble(16);
            this.initialAngularAccuracy = this.backing.getInt(24);
            this.finalSampleSize = this.backing.getInt(28);
            this.finalSampleSizeFactor = this.backing.getDouble(32);
            this.finalAngularAccuracy = this.backing.getInt(40);
            this.subpixelSampleSize = this.backing.getInt(44);
            this.subpixelSampleSizeFactor = this.backing.getDouble(48);
        }

        @Override
        public void write() {
            if (this.searchStrategySupport != null) {
                this.backing.putInt(0, this.searchStrategySupport.getValue());
            }
            this.backing.putInt(4, this.initialStepSize);
            this.backing.putInt(8, this.initialSampleSize);
            this.backing.putDouble(16, this.initialSampleSizeFactor);
            this.backing.putInt(24, this.initialAngularAccuracy);
            this.backing.putInt(28, this.finalSampleSize);
            this.backing.putDouble(32, this.finalSampleSizeFactor);
            this.backing.putInt(40, this.finalAngularAccuracy);
            this.backing.putInt(44, this.subpixelSampleSize);
            this.backing.putDouble(48, this.subpixelSampleSizeFactor);
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class LearnPatternAdvancedShiftOptions
    extends DisposedStruct {
        public int initialStepSize;
        public int initialSampleSize;
        public double initialSampleSizeFactor;
        public int finalSampleSize;
        public double finalSampleSizeFactor;
        public int subpixelSampleSize;
        public double subpixelSampleSizeFactor;

        private void init() {
        }

        public LearnPatternAdvancedShiftOptions() {
            super(48);
            this.init();
        }

        public LearnPatternAdvancedShiftOptions(int initialStepSize, int initialSampleSize, double initialSampleSizeFactor, int finalSampleSize, double finalSampleSizeFactor, int subpixelSampleSize, double subpixelSampleSizeFactor) {
            super(48);
            this.initialStepSize = initialStepSize;
            this.initialSampleSize = initialSampleSize;
            this.initialSampleSizeFactor = initialSampleSizeFactor;
            this.finalSampleSize = finalSampleSize;
            this.finalSampleSizeFactor = finalSampleSizeFactor;
            this.subpixelSampleSize = subpixelSampleSize;
            this.subpixelSampleSizeFactor = subpixelSampleSizeFactor;
        }

        protected LearnPatternAdvancedShiftOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 48);
            this.init();
        }

        protected LearnPatternAdvancedShiftOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 48);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 48);
        }

        @Override
        public void read() {
            this.initialStepSize = this.backing.getInt(0);
            this.initialSampleSize = this.backing.getInt(4);
            this.initialSampleSizeFactor = this.backing.getDouble(8);
            this.finalSampleSize = this.backing.getInt(16);
            this.finalSampleSizeFactor = this.backing.getDouble(24);
            this.subpixelSampleSize = this.backing.getInt(32);
            this.subpixelSampleSizeFactor = this.backing.getDouble(40);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.initialStepSize);
            this.backing.putInt(4, this.initialSampleSize);
            this.backing.putDouble(8, this.initialSampleSizeFactor);
            this.backing.putInt(16, this.finalSampleSize);
            this.backing.putDouble(24, this.finalSampleSizeFactor);
            this.backing.putInt(32, this.subpixelSampleSize);
            this.backing.putDouble(40, this.subpixelSampleSizeFactor);
        }

        @Override
        public int size() {
            return 48;
        }
    }

    public static class AVIInfo
    extends DisposedStruct {
        public int width;
        public int height;
        public ImageType imageType;
        public int numFrames;
        public int framesPerSecond;
        public String filterName;
        public int hasData;
        public int maxDataSize;
        private ByteBuffer filterName_buf;

        private void init() {
        }

        public AVIInfo() {
            super(32);
            this.init();
        }

        public AVIInfo(int width, int height, ImageType imageType, int numFrames, int framesPerSecond, String filterName, int hasData, int maxDataSize) {
            super(32);
            this.width = width;
            this.height = height;
            this.imageType = imageType;
            this.numFrames = numFrames;
            this.framesPerSecond = framesPerSecond;
            this.filterName = filterName;
            this.hasData = hasData;
            this.maxDataSize = maxDataSize;
        }

        protected AVIInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected AVIInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.width = this.backing.getInt(0);
            this.height = this.backing.getInt(4);
            this.imageType = ImageType.fromValue(this.backing.getInt(8));
            this.numFrames = this.backing.getInt(12);
            this.framesPerSecond = this.backing.getInt(16);
            long filterName_addr = NIVision.getPointer(this.backing, 20);
            if (filterName_addr == 0L) {
                this.filterName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(filterName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.filterName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.filterName = "";
                }
            }
            this.hasData = this.backing.getInt(24);
            this.maxDataSize = this.backing.getInt(28);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.width);
            this.backing.putInt(4, this.height);
            if (this.imageType != null) {
                this.backing.putInt(8, this.imageType.getValue());
            }
            this.backing.putInt(12, this.numFrames);
            this.backing.putInt(16, this.framesPerSecond);
            if (this.filterName != null) {
                byte[] filterName_bytes;
                try {
                    filterName_bytes = this.filterName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    filterName_bytes = new byte[]{};
                }
                this.filterName_buf = ByteBuffer.allocateDirect(filterName_bytes.length + 1);
                NIVision.putBytes(this.filterName_buf, filterName_bytes, 0, filterName_bytes.length).put(filterName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 20, this.filterName == null ? 0L : NIVision.getByteBufferAddress(this.filterName_buf));
            this.backing.putInt(24, this.hasData);
            this.backing.putInt(28, this.maxDataSize);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class LearnPatternAdvancedOptions
    extends DisposedStruct {
        public LearnPatternAdvancedShiftOptions shiftOptions;
        public LearnPatternAdvancedRotationOptions rotationOptions;

        private void init() {
        }

        public LearnPatternAdvancedOptions() {
            super(8);
            this.init();
        }

        public LearnPatternAdvancedOptions(LearnPatternAdvancedShiftOptions shiftOptions, LearnPatternAdvancedRotationOptions rotationOptions) {
            super(8);
            this.shiftOptions = shiftOptions;
            this.rotationOptions = rotationOptions;
        }

        protected LearnPatternAdvancedOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected LearnPatternAdvancedOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            long shiftOptions_addr = NIVision.getPointer(this.backing, 0);
            this.shiftOptions = shiftOptions_addr == 0L ? null : new LearnPatternAdvancedShiftOptions(shiftOptions_addr, false);
            long rotationOptions_addr = NIVision.getPointer(this.backing, 4);
            this.rotationOptions = rotationOptions_addr == 0L ? null : new LearnPatternAdvancedRotationOptions(rotationOptions_addr, false);
        }

        @Override
        public void write() {
            NIVision.putPointer(this.backing, 0, this.shiftOptions);
            NIVision.putPointer(this.backing, 4, this.rotationOptions);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class BestEllipse2
    extends DisposedStruct {
        public PointFloat center;
        public PointFloat majorAxisStart;
        public PointFloat majorAxisEnd;
        public PointFloat minorAxisStart;
        public PointFloat minorAxisEnd;
        public double area;
        public double perimeter;
        public double error;
        public int valid;
        public int[] pointsUsed;
        private ByteBuffer pointsUsed_buf;

        private void init() {
            this.center = new PointFloat(this.backing, 0);
            this.majorAxisStart = new PointFloat(this.backing, 8);
            this.majorAxisEnd = new PointFloat(this.backing, 16);
            this.minorAxisStart = new PointFloat(this.backing, 24);
            this.minorAxisEnd = new PointFloat(this.backing, 32);
            this.pointsUsed = new int[0];
        }

        public BestEllipse2() {
            super(80);
            this.init();
        }

        public BestEllipse2(PointFloat center, PointFloat majorAxisStart, PointFloat majorAxisEnd, PointFloat minorAxisStart, PointFloat minorAxisEnd, double area, double perimeter, double error, int valid, int[] pointsUsed) {
            super(80);
            this.center = center;
            this.majorAxisStart = majorAxisStart;
            this.majorAxisEnd = majorAxisEnd;
            this.minorAxisStart = minorAxisStart;
            this.minorAxisEnd = minorAxisEnd;
            this.area = area;
            this.perimeter = perimeter;
            this.error = error;
            this.valid = valid;
            this.pointsUsed = pointsUsed;
        }

        protected BestEllipse2(ByteBuffer backing, int offset) {
            super(backing, offset, 80);
            this.init();
        }

        protected BestEllipse2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 80);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 80);
        }

        @Override
        public void read() {
            this.center.read();
            this.majorAxisStart.read();
            this.majorAxisEnd.read();
            this.minorAxisStart.read();
            this.minorAxisEnd.read();
            this.area = this.backing.getDouble(40);
            this.perimeter = this.backing.getDouble(48);
            this.error = this.backing.getDouble(56);
            this.valid = this.backing.getInt(64);
            int pointsUsed_numPointsUsed = this.backing.getInt(72);
            long pointsUsed_addr = NIVision.getPointer(this.backing, 68);
            this.pointsUsed = new int[pointsUsed_numPointsUsed];
            if (pointsUsed_numPointsUsed > 0 && pointsUsed_addr != 0L) {
                NIVision.newDirectByteBuffer(pointsUsed_addr, pointsUsed_numPointsUsed * 4).asIntBuffer().get(this.pointsUsed);
            }
        }

        @Override
        public void write() {
            this.center.write();
            this.majorAxisStart.write();
            this.majorAxisEnd.write();
            this.minorAxisStart.write();
            this.minorAxisEnd.write();
            this.backing.putDouble(40, this.area);
            this.backing.putDouble(48, this.perimeter);
            this.backing.putDouble(56, this.error);
            this.backing.putInt(64, this.valid);
            this.pointsUsed_buf = ByteBuffer.allocateDirect(this.pointsUsed.length * 4).order(ByteOrder.nativeOrder());
            this.pointsUsed_buf.asIntBuffer().put(this.pointsUsed).rewind();
            this.backing.putInt(72, this.pointsUsed.length);
            NIVision.putPointer(this.backing, 68, this.pointsUsed_buf);
        }

        @Override
        public int size() {
            return 80;
        }
    }

    public static class CIEXYZValue
    extends DisposedStruct {
        public double Z;
        public double Y;
        public double X;
        public short alpha;

        private void init() {
        }

        public CIEXYZValue() {
            super(32);
            this.init();
        }

        public CIEXYZValue(double Z, double Y, double X, int alpha) {
            super(32);
            this.Z = Z;
            this.Y = Y;
            this.X = X;
            this.alpha = (short)alpha;
        }

        protected CIEXYZValue(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected CIEXYZValue(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.Z = this.backing.getDouble(0);
            this.Y = this.backing.getDouble(8);
            this.X = this.backing.getDouble(16);
            this.alpha = (short)(this.backing.get(24) & 0xFF);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.Z);
            this.backing.putDouble(8, this.Y);
            this.backing.putDouble(16, this.X);
            this.backing.put(24, (byte)(this.alpha & 0xFF));
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class CIELabValue
    extends DisposedStruct {
        public double b;
        public double a;
        public double L;
        public short alpha;

        private void init() {
        }

        public CIELabValue() {
            super(32);
            this.init();
        }

        public CIELabValue(double b, double a, double L, int alpha) {
            super(32);
            this.b = b;
            this.a = a;
            this.L = L;
            this.alpha = (short)alpha;
        }

        protected CIELabValue(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected CIELabValue(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.b = this.backing.getDouble(0);
            this.a = this.backing.getDouble(8);
            this.L = this.backing.getDouble(16);
            this.alpha = (short)(this.backing.get(24) & 0xFF);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.b);
            this.backing.putDouble(8, this.a);
            this.backing.putDouble(16, this.L);
            this.backing.put(24, (byte)(this.alpha & 0xFF));
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class HSIValue
    extends DisposedStruct {
        public short I;
        public short S;
        public short H;
        public short alpha;

        private void init() {
        }

        public HSIValue() {
            super(4);
            this.init();
        }

        public HSIValue(int I, int S, int H, int alpha) {
            super(4);
            this.I = (short)I;
            this.S = (short)S;
            this.H = (short)H;
            this.alpha = (short)alpha;
        }

        protected HSIValue(ByteBuffer backing, int offset) {
            super(backing, offset, 4);
            this.init();
        }

        protected HSIValue(long nativeObj, boolean owned) {
            super(nativeObj, owned, 4);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 4);
        }

        @Override
        public void read() {
            this.I = (short)(this.backing.get(0) & 0xFF);
            this.S = (short)(this.backing.get(1) & 0xFF);
            this.H = (short)(this.backing.get(2) & 0xFF);
            this.alpha = (short)(this.backing.get(3) & 0xFF);
        }

        @Override
        public void write() {
            this.backing.put(0, (byte)(this.I & 0xFF));
            this.backing.put(1, (byte)(this.S & 0xFF));
            this.backing.put(2, (byte)(this.H & 0xFF));
            this.backing.put(3, (byte)(this.alpha & 0xFF));
        }

        @Override
        public int size() {
            return 4;
        }
    }

    public static class HSVValue
    extends DisposedStruct {
        public short V;
        public short S;
        public short H;
        public short alpha;

        private void init() {
        }

        public HSVValue() {
            super(4);
            this.init();
        }

        public HSVValue(int V, int S, int H, int alpha) {
            super(4);
            this.V = (short)V;
            this.S = (short)S;
            this.H = (short)H;
            this.alpha = (short)alpha;
        }

        protected HSVValue(ByteBuffer backing, int offset) {
            super(backing, offset, 4);
            this.init();
        }

        protected HSVValue(long nativeObj, boolean owned) {
            super(nativeObj, owned, 4);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 4);
        }

        @Override
        public void read() {
            this.V = (short)(this.backing.get(0) & 0xFF);
            this.S = (short)(this.backing.get(1) & 0xFF);
            this.H = (short)(this.backing.get(2) & 0xFF);
            this.alpha = (short)(this.backing.get(3) & 0xFF);
        }

        @Override
        public void write() {
            this.backing.put(0, (byte)(this.V & 0xFF));
            this.backing.put(1, (byte)(this.S & 0xFF));
            this.backing.put(2, (byte)(this.H & 0xFF));
            this.backing.put(3, (byte)(this.alpha & 0xFF));
        }

        @Override
        public int size() {
            return 4;
        }
    }

    public static class HSLValue
    extends DisposedStruct {
        public short L;
        public short S;
        public short H;
        public short alpha;

        private void init() {
        }

        public HSLValue() {
            super(4);
            this.init();
        }

        public HSLValue(int L, int S, int H, int alpha) {
            super(4);
            this.L = (short)L;
            this.S = (short)S;
            this.H = (short)H;
            this.alpha = (short)alpha;
        }

        protected HSLValue(ByteBuffer backing, int offset) {
            super(backing, offset, 4);
            this.init();
        }

        protected HSLValue(long nativeObj, boolean owned) {
            super(nativeObj, owned, 4);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 4);
        }

        @Override
        public void read() {
            this.L = (short)(this.backing.get(0) & 0xFF);
            this.S = (short)(this.backing.get(1) & 0xFF);
            this.H = (short)(this.backing.get(2) & 0xFF);
            this.alpha = (short)(this.backing.get(3) & 0xFF);
        }

        @Override
        public void write() {
            this.backing.put(0, (byte)(this.L & 0xFF));
            this.backing.put(1, (byte)(this.S & 0xFF));
            this.backing.put(2, (byte)(this.H & 0xFF));
            this.backing.put(3, (byte)(this.alpha & 0xFF));
        }

        @Override
        public int size() {
            return 4;
        }
    }

    public static class ConstructROIOptions2
    extends DisposedStruct {
        public int windowNumber;
        public String windowTitle;
        public PaletteType type;
        public RGBValue[] palette;
        public int maxContours;
        private ByteBuffer windowTitle_buf;
        private ByteBuffer palette_buf;

        private void init() {
            this.palette = new RGBValue[0];
        }

        public ConstructROIOptions2() {
            super(24);
            this.init();
        }

        public ConstructROIOptions2(int windowNumber, String windowTitle, PaletteType type, RGBValue[] palette, int maxContours) {
            super(24);
            this.windowNumber = windowNumber;
            this.windowTitle = windowTitle;
            this.type = type;
            this.palette = palette;
            this.maxContours = maxContours;
        }

        protected ConstructROIOptions2(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected ConstructROIOptions2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.windowNumber = this.backing.getInt(0);
            long windowTitle_addr = NIVision.getPointer(this.backing, 4);
            if (windowTitle_addr == 0L) {
                this.windowTitle = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(windowTitle_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.windowTitle = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.windowTitle = "";
                }
            }
            this.type = PaletteType.fromValue(this.backing.getInt(8));
            int palette_numColors = this.backing.getInt(16);
            long palette_addr = NIVision.getPointer(this.backing, 12);
            this.palette = new RGBValue[palette_numColors];
            if (palette_numColors > 0 && palette_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(palette_addr, palette_numColors * 4);
                int i = 0;
                int off = 0;
                while (i < palette_numColors) {
                    this.palette[i] = new RGBValue(bb, off);
                    this.palette[i].read();
                    ++i;
                    off += 4;
                }
            }
            this.maxContours = this.backing.getInt(20);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.windowNumber);
            if (this.windowTitle != null) {
                byte[] windowTitle_bytes;
                try {
                    windowTitle_bytes = this.windowTitle.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    windowTitle_bytes = new byte[]{};
                }
                this.windowTitle_buf = ByteBuffer.allocateDirect(windowTitle_bytes.length + 1);
                NIVision.putBytes(this.windowTitle_buf, windowTitle_bytes, 0, windowTitle_bytes.length).put(windowTitle_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 4, this.windowTitle == null ? 0L : NIVision.getByteBufferAddress(this.windowTitle_buf));
            if (this.type != null) {
                this.backing.putInt(8, this.type.getValue());
            }
            this.palette_buf = ByteBuffer.allocateDirect(this.palette.length * 4).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.palette.length) {
                this.palette[i].setBuffer(this.palette_buf, off);
                this.palette[i].write();
                ++i;
                off += 4;
            }
            this.backing.putInt(16, this.palette.length);
            NIVision.putPointer(this.backing, 12, this.palette_buf);
            this.backing.putInt(20, this.maxContours);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class FitCircleOptions
    extends DisposedStruct {
        public int rejectOutliers;
        public double minScore;
        public double pixelRadius;
        public int maxIterations;

        private void init() {
        }

        public FitCircleOptions() {
            super(32);
            this.init();
        }

        public FitCircleOptions(int rejectOutliers, double minScore, double pixelRadius, int maxIterations) {
            super(32);
            this.rejectOutliers = rejectOutliers;
            this.minScore = minScore;
            this.pixelRadius = pixelRadius;
            this.maxIterations = maxIterations;
        }

        protected FitCircleOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected FitCircleOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.rejectOutliers = this.backing.getInt(0);
            this.minScore = this.backing.getDouble(8);
            this.pixelRadius = this.backing.getDouble(16);
            this.maxIterations = this.backing.getInt(24);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.rejectOutliers);
            this.backing.putDouble(8, this.minScore);
            this.backing.putDouble(16, this.pixelRadius);
            this.backing.putInt(24, this.maxIterations);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class FitEllipseOptions
    extends DisposedStruct {
        public int rejectOutliers;
        public double minScore;
        public double pixelRadius;
        public int maxIterations;

        private void init() {
        }

        public FitEllipseOptions() {
            super(32);
            this.init();
        }

        public FitEllipseOptions(int rejectOutliers, double minScore, double pixelRadius, int maxIterations) {
            super(32);
            this.rejectOutliers = rejectOutliers;
            this.minScore = minScore;
            this.pixelRadius = pixelRadius;
            this.maxIterations = maxIterations;
        }

        protected FitEllipseOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected FitEllipseOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.rejectOutliers = this.backing.getInt(0);
            this.minScore = this.backing.getDouble(8);
            this.pixelRadius = this.backing.getDouble(16);
            this.maxIterations = this.backing.getInt(24);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.rejectOutliers);
            this.backing.putDouble(8, this.minScore);
            this.backing.putDouble(16, this.pixelRadius);
            this.backing.putInt(24, this.maxIterations);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class LearnGeometricPatternAdvancedOptions
    extends DisposedStruct {
        public int minRectLength;
        public double minRectAspectRatio;
        public int minRadius;
        public int minLineLength;
        public double minFeatureStrength;
        public int maxFeaturesUsed;
        public int maxPixelDistanceFromLine;

        private void init() {
        }

        public LearnGeometricPatternAdvancedOptions() {
            super(40);
            this.init();
        }

        public LearnGeometricPatternAdvancedOptions(int minRectLength, double minRectAspectRatio, int minRadius, int minLineLength, double minFeatureStrength, int maxFeaturesUsed, int maxPixelDistanceFromLine) {
            super(40);
            this.minRectLength = minRectLength;
            this.minRectAspectRatio = minRectAspectRatio;
            this.minRadius = minRadius;
            this.minLineLength = minLineLength;
            this.minFeatureStrength = minFeatureStrength;
            this.maxFeaturesUsed = maxFeaturesUsed;
            this.maxPixelDistanceFromLine = maxPixelDistanceFromLine;
        }

        protected LearnGeometricPatternAdvancedOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected LearnGeometricPatternAdvancedOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.minRectLength = this.backing.getInt(0);
            this.minRectAspectRatio = this.backing.getDouble(8);
            this.minRadius = this.backing.getInt(16);
            this.minLineLength = this.backing.getInt(20);
            this.minFeatureStrength = this.backing.getDouble(24);
            this.maxFeaturesUsed = this.backing.getInt(32);
            this.maxPixelDistanceFromLine = this.backing.getInt(36);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.minRectLength);
            this.backing.putDouble(8, this.minRectAspectRatio);
            this.backing.putInt(16, this.minRadius);
            this.backing.putInt(20, this.minLineLength);
            this.backing.putDouble(24, this.minFeatureStrength);
            this.backing.putInt(32, this.maxFeaturesUsed);
            this.backing.putInt(36, this.maxPixelDistanceFromLine);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class MatchGeometricPatternOptions
    extends DisposedStruct {
        public int mode;
        public int subpixelAccuracy;
        public RangeFloat[] angleRanges;
        public RangeFloat scaleRange;
        public RangeFloat occlusionRange;
        public int numMatchesRequested;
        public float minMatchScore;
        private ByteBuffer angleRanges_buf;

        private void init() {
            this.angleRanges = new RangeFloat[0];
            this.scaleRange = new RangeFloat(this.backing, 16);
            this.occlusionRange = new RangeFloat(this.backing, 24);
        }

        public MatchGeometricPatternOptions() {
            super(40);
            this.init();
        }

        public MatchGeometricPatternOptions(int mode, int subpixelAccuracy, RangeFloat[] angleRanges, RangeFloat scaleRange, RangeFloat occlusionRange, int numMatchesRequested, double minMatchScore) {
            super(40);
            this.mode = mode;
            this.subpixelAccuracy = subpixelAccuracy;
            this.angleRanges = angleRanges;
            this.scaleRange = scaleRange;
            this.occlusionRange = occlusionRange;
            this.numMatchesRequested = numMatchesRequested;
            this.minMatchScore = (float)minMatchScore;
        }

        protected MatchGeometricPatternOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected MatchGeometricPatternOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.mode = this.backing.getInt(0);
            this.subpixelAccuracy = this.backing.getInt(4);
            int angleRanges_numAngleRanges = this.backing.getInt(12);
            long angleRanges_addr = NIVision.getPointer(this.backing, 8);
            this.angleRanges = new RangeFloat[angleRanges_numAngleRanges];
            if (angleRanges_numAngleRanges > 0 && angleRanges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(angleRanges_addr, angleRanges_numAngleRanges * 8);
                int i = 0;
                int off = 0;
                while (i < angleRanges_numAngleRanges) {
                    this.angleRanges[i] = new RangeFloat(bb, off);
                    this.angleRanges[i].read();
                    ++i;
                    off += 8;
                }
            }
            this.scaleRange.read();
            this.occlusionRange.read();
            this.numMatchesRequested = this.backing.getInt(32);
            this.minMatchScore = this.backing.getFloat(36);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.mode);
            this.backing.putInt(4, this.subpixelAccuracy);
            this.angleRanges_buf = ByteBuffer.allocateDirect(this.angleRanges.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.angleRanges.length) {
                this.angleRanges[i].setBuffer(this.angleRanges_buf, off);
                this.angleRanges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(12, this.angleRanges.length);
            NIVision.putPointer(this.backing, 8, this.angleRanges_buf);
            this.scaleRange.write();
            this.occlusionRange.write();
            this.backing.putInt(32, this.numMatchesRequested);
            this.backing.putFloat(36, this.minMatchScore);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class MatchGeometricPatternAdvancedOptions
    extends DisposedStruct {
        public int minFeaturesUsed;
        public int maxFeaturesUsed;
        public int subpixelIterations;
        public double subpixelTolerance;
        public int initialMatchListLength;
        public int matchTemplateCurveScore;
        public int correlationScore;
        public double minMatchSeparationDistance;
        public double minMatchSeparationAngle;
        public double minMatchSeparationScale;
        public double maxMatchOverlap;
        public int coarseResult;

        private void init() {
        }

        public MatchGeometricPatternAdvancedOptions() {
            super(80);
            this.init();
        }

        public MatchGeometricPatternAdvancedOptions(int minFeaturesUsed, int maxFeaturesUsed, int subpixelIterations, double subpixelTolerance, int initialMatchListLength, int matchTemplateCurveScore, int correlationScore, double minMatchSeparationDistance, double minMatchSeparationAngle, double minMatchSeparationScale, double maxMatchOverlap, int coarseResult) {
            super(80);
            this.minFeaturesUsed = minFeaturesUsed;
            this.maxFeaturesUsed = maxFeaturesUsed;
            this.subpixelIterations = subpixelIterations;
            this.subpixelTolerance = subpixelTolerance;
            this.initialMatchListLength = initialMatchListLength;
            this.matchTemplateCurveScore = matchTemplateCurveScore;
            this.correlationScore = correlationScore;
            this.minMatchSeparationDistance = minMatchSeparationDistance;
            this.minMatchSeparationAngle = minMatchSeparationAngle;
            this.minMatchSeparationScale = minMatchSeparationScale;
            this.maxMatchOverlap = maxMatchOverlap;
            this.coarseResult = coarseResult;
        }

        protected MatchGeometricPatternAdvancedOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 80);
            this.init();
        }

        protected MatchGeometricPatternAdvancedOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 80);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 80);
        }

        @Override
        public void read() {
            this.minFeaturesUsed = this.backing.getInt(0);
            this.maxFeaturesUsed = this.backing.getInt(4);
            this.subpixelIterations = this.backing.getInt(8);
            this.subpixelTolerance = this.backing.getDouble(16);
            this.initialMatchListLength = this.backing.getInt(24);
            this.matchTemplateCurveScore = this.backing.getInt(28);
            this.correlationScore = this.backing.getInt(32);
            this.minMatchSeparationDistance = this.backing.getDouble(40);
            this.minMatchSeparationAngle = this.backing.getDouble(48);
            this.minMatchSeparationScale = this.backing.getDouble(56);
            this.maxMatchOverlap = this.backing.getDouble(64);
            this.coarseResult = this.backing.getInt(72);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.minFeaturesUsed);
            this.backing.putInt(4, this.maxFeaturesUsed);
            this.backing.putInt(8, this.subpixelIterations);
            this.backing.putDouble(16, this.subpixelTolerance);
            this.backing.putInt(24, this.initialMatchListLength);
            this.backing.putInt(28, this.matchTemplateCurveScore);
            this.backing.putInt(32, this.correlationScore);
            this.backing.putDouble(40, this.minMatchSeparationDistance);
            this.backing.putDouble(48, this.minMatchSeparationAngle);
            this.backing.putDouble(56, this.minMatchSeparationScale);
            this.backing.putDouble(64, this.maxMatchOverlap);
            this.backing.putInt(72, this.coarseResult);
        }

        @Override
        public int size() {
            return 80;
        }
    }

    public static class GeometricPatternMatch
    extends DisposedStruct {
        public PointFloat position;
        public float rotation;
        public float scale;
        public float score;
        public PointFloat[] corner;
        public int inverse;
        public float occlusion;
        public float templateMatchCurveScore;
        public float matchTemplateCurveScore;
        public float correlationScore;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
            this.corner = new PointFloat[4];
            int i = 0;
            int off = 20;
            while (i < 4) {
                this.corner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public GeometricPatternMatch() {
            super(72);
            this.init();
        }

        public GeometricPatternMatch(PointFloat position, double rotation, double scale, double score, PointFloat[] corner, int inverse, double occlusion, double templateMatchCurveScore, double matchTemplateCurveScore, double correlationScore) {
            super(72);
            this.position = position;
            this.rotation = (float)rotation;
            this.scale = (float)scale;
            this.score = (float)score;
            this.corner = corner;
            this.inverse = inverse;
            this.occlusion = (float)occlusion;
            this.templateMatchCurveScore = (float)templateMatchCurveScore;
            this.matchTemplateCurveScore = (float)matchTemplateCurveScore;
            this.correlationScore = (float)correlationScore;
        }

        protected GeometricPatternMatch(ByteBuffer backing, int offset) {
            super(backing, offset, 72);
            this.init();
        }

        protected GeometricPatternMatch(long nativeObj, boolean owned) {
            super(nativeObj, owned, 72);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 72);
        }

        @Override
        public void read() {
            this.position.read();
            this.rotation = this.backing.getFloat(8);
            this.scale = this.backing.getFloat(12);
            this.score = this.backing.getFloat(16);
            for (PointFloat it : this.corner) {
                it.read();
            }
            this.inverse = this.backing.getInt(52);
            this.occlusion = this.backing.getFloat(56);
            this.templateMatchCurveScore = this.backing.getFloat(60);
            this.matchTemplateCurveScore = this.backing.getFloat(64);
            this.correlationScore = this.backing.getFloat(68);
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putFloat(8, this.rotation);
            this.backing.putFloat(12, this.scale);
            this.backing.putFloat(16, this.score);
            for (PointFloat it : this.corner) {
                it.write();
            }
            this.backing.putInt(52, this.inverse);
            this.backing.putFloat(56, this.occlusion);
            this.backing.putFloat(60, this.templateMatchCurveScore);
            this.backing.putFloat(64, this.matchTemplateCurveScore);
            this.backing.putFloat(68, this.correlationScore);
        }

        @Override
        public int size() {
            return 72;
        }
    }

    public static class RGBU64Value
    extends DisposedStruct {
        public int B;
        public int G;
        public int R;
        public int alpha;

        private void init() {
        }

        public RGBU64Value() {
            super(8);
            this.init();
        }

        public RGBU64Value(int B, int G, int R, int alpha) {
            super(8);
            this.B = B;
            this.G = G;
            this.R = R;
            this.alpha = alpha;
        }

        protected RGBU64Value(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected RGBU64Value(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.B = this.backing.getShort(0) & 0xFFFF;
            this.G = this.backing.getShort(2) & 0xFFFF;
            this.R = this.backing.getShort(4) & 0xFFFF;
            this.alpha = this.backing.getShort(6) & 0xFFFF;
        }

        @Override
        public void write() {
            this.backing.putShort(0, (short)(this.B & 0xFFFF));
            this.backing.putShort(2, (short)(this.G & 0xFFFF));
            this.backing.putShort(4, (short)(this.R & 0xFFFF));
            this.backing.putShort(6, (short)(this.alpha & 0xFFFF));
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class ParticleClassifierOptions
    extends DisposedStruct {
        public float scaleDependence;
        public float mirrorDependence;

        private void init() {
        }

        public ParticleClassifierOptions() {
            super(8);
            this.init();
        }

        public ParticleClassifierOptions(double scaleDependence, double mirrorDependence) {
            super(8);
            this.scaleDependence = (float)scaleDependence;
            this.mirrorDependence = (float)mirrorDependence;
        }

        protected ParticleClassifierOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected ParticleClassifierOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.scaleDependence = this.backing.getFloat(0);
            this.mirrorDependence = this.backing.getFloat(4);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.scaleDependence);
            this.backing.putFloat(4, this.mirrorDependence);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class NearestNeighborOptions
    extends DisposedStruct {
        public NearestNeighborMethod method;
        public NearestNeighborMetric metric;
        public int k;

        private void init() {
        }

        public NearestNeighborOptions() {
            super(12);
            this.init();
        }

        public NearestNeighborOptions(NearestNeighborMethod method, NearestNeighborMetric metric, int k) {
            super(12);
            this.method = method;
            this.metric = metric;
            this.k = k;
        }

        protected NearestNeighborOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected NearestNeighborOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.method = NearestNeighborMethod.fromValue(this.backing.getInt(0));
            this.metric = NearestNeighborMetric.fromValue(this.backing.getInt(4));
            this.k = this.backing.getInt(8);
        }

        @Override
        public void write() {
            if (this.method != null) {
                this.backing.putInt(0, this.method.getValue());
            }
            if (this.metric != null) {
                this.backing.putInt(4, this.metric.getValue());
            }
            this.backing.putInt(8, this.k);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class ClassifierReport
    extends DisposedStruct {
        public String bestClassName;
        public float classificationScore;
        public float identificationScore;
        public ClassScore[] allScores;
        private ByteBuffer bestClassName_buf;
        private ByteBuffer allScores_buf;

        private void init() {
            this.allScores = new ClassScore[0];
        }

        public ClassifierReport() {
            super(20);
            this.init();
        }

        public ClassifierReport(String bestClassName, double classificationScore, double identificationScore, ClassScore[] allScores) {
            super(20);
            this.bestClassName = bestClassName;
            this.classificationScore = (float)classificationScore;
            this.identificationScore = (float)identificationScore;
            this.allScores = allScores;
        }

        protected ClassifierReport(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected ClassifierReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            long bestClassName_addr = NIVision.getPointer(this.backing, 0);
            if (bestClassName_addr == 0L) {
                this.bestClassName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(bestClassName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.bestClassName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.bestClassName = "";
                }
            }
            this.classificationScore = this.backing.getFloat(4);
            this.identificationScore = this.backing.getFloat(8);
            int allScores_allScoresSize = this.backing.getInt(16);
            long allScores_addr = NIVision.getPointer(this.backing, 12);
            this.allScores = new ClassScore[allScores_allScoresSize];
            if (allScores_allScoresSize > 0 && allScores_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(allScores_addr, allScores_allScoresSize * 8);
                int i = 0;
                int off = 0;
                while (i < allScores_allScoresSize) {
                    this.allScores[i] = new ClassScore(bb, off);
                    this.allScores[i].read();
                    ++i;
                    off += 8;
                }
            }
        }

        @Override
        public void write() {
            if (this.bestClassName != null) {
                byte[] bestClassName_bytes;
                try {
                    bestClassName_bytes = this.bestClassName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bestClassName_bytes = new byte[]{};
                }
                this.bestClassName_buf = ByteBuffer.allocateDirect(bestClassName_bytes.length + 1);
                NIVision.putBytes(this.bestClassName_buf, bestClassName_bytes, 0, bestClassName_bytes.length).put(bestClassName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.bestClassName == null ? 0L : NIVision.getByteBufferAddress(this.bestClassName_buf));
            this.backing.putFloat(4, this.classificationScore);
            this.backing.putFloat(8, this.identificationScore);
            this.allScores_buf = ByteBuffer.allocateDirect(this.allScores.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.allScores.length) {
                this.allScores[i].setBuffer(this.allScores_buf, off);
                this.allScores[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(16, this.allScores.length);
            NIVision.putPointer(this.backing, 12, this.allScores_buf);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class ClassScore
    extends DisposedStruct {
        public String className;
        public float distance;
        private ByteBuffer className_buf;

        private void init() {
        }

        public ClassScore() {
            super(8);
            this.init();
        }

        public ClassScore(String className, double distance) {
            super(8);
            this.className = className;
            this.distance = (float)distance;
        }

        protected ClassScore(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected ClassScore(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            long className_addr = NIVision.getPointer(this.backing, 0);
            if (className_addr == 0L) {
                this.className = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(className_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.className = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.className = "";
                }
            }
            this.distance = this.backing.getFloat(4);
        }

        @Override
        public void write() {
            if (this.className != null) {
                byte[] className_bytes;
                try {
                    className_bytes = this.className.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    className_bytes = new byte[]{};
                }
                this.className_buf = ByteBuffer.allocateDirect(className_bytes.length + 1);
                NIVision.putBytes(this.className_buf, className_bytes, 0, className_bytes.length).put(className_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.className == null ? 0L : NIVision.getByteBufferAddress(this.className_buf));
            this.backing.putFloat(4, this.distance);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class ClassifierSampleInfo
    extends DisposedStruct {
        public String className;
        public double[] featureVector;
        public Image thumbnail;
        private ByteBuffer className_buf;
        private ByteBuffer featureVector_buf;

        private void init() {
            this.featureVector = new double[0];
        }

        public ClassifierSampleInfo() {
            super(16);
            this.init();
        }

        public ClassifierSampleInfo(String className, double[] featureVector, Image thumbnail) {
            super(16);
            this.className = className;
            this.featureVector = featureVector;
            this.thumbnail = thumbnail;
        }

        protected ClassifierSampleInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ClassifierSampleInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            long thumbnail_addr;
            long className_addr = NIVision.getPointer(this.backing, 0);
            if (className_addr == 0L) {
                this.className = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(className_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.className = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.className = "";
                }
            }
            int featureVector_featureVectorSize = this.backing.getInt(8);
            long featureVector_addr = NIVision.getPointer(this.backing, 4);
            this.featureVector = new double[featureVector_featureVectorSize];
            if (featureVector_featureVectorSize > 0 && featureVector_addr != 0L) {
                NIVision.newDirectByteBuffer(featureVector_addr, featureVector_featureVectorSize * 8).asDoubleBuffer().get(this.featureVector);
            }
            this.thumbnail = (thumbnail_addr = NIVision.getPointer(this.backing, 12)) == 0L ? null : new Image(thumbnail_addr, false);
        }

        @Override
        public void write() {
            if (this.className != null) {
                byte[] className_bytes;
                try {
                    className_bytes = this.className.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    className_bytes = new byte[]{};
                }
                this.className_buf = ByteBuffer.allocateDirect(className_bytes.length + 1);
                NIVision.putBytes(this.className_buf, className_bytes, 0, className_bytes.length).put(className_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.className == null ? 0L : NIVision.getByteBufferAddress(this.className_buf));
            this.featureVector_buf = ByteBuffer.allocateDirect(this.featureVector.length * 8).order(ByteOrder.nativeOrder());
            this.featureVector_buf.asDoubleBuffer().put(this.featureVector).rewind();
            this.backing.putInt(8, this.featureVector.length);
            NIVision.putPointer(this.backing, 4, this.featureVector_buf);
            NIVision.putPointer(this.backing, 12, this.thumbnail);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ParticleClassifierPreprocessingOptions
    extends DisposedStruct {
        public int manualThreshold;
        public RangeFloat manualThresholdRange;
        public ThresholdMethod autoThresholdMethod;
        public RangeFloat limits;
        public ParticleType particleType;
        public int rejectBorder;
        public int numErosions;

        private void init() {
            this.manualThresholdRange = new RangeFloat(this.backing, 4);
            this.limits = new RangeFloat(this.backing, 16);
        }

        public ParticleClassifierPreprocessingOptions() {
            super(36);
            this.init();
        }

        public ParticleClassifierPreprocessingOptions(int manualThreshold, RangeFloat manualThresholdRange, ThresholdMethod autoThresholdMethod, RangeFloat limits, ParticleType particleType, int rejectBorder, int numErosions) {
            super(36);
            this.manualThreshold = manualThreshold;
            this.manualThresholdRange = manualThresholdRange;
            this.autoThresholdMethod = autoThresholdMethod;
            this.limits = limits;
            this.particleType = particleType;
            this.rejectBorder = rejectBorder;
            this.numErosions = numErosions;
        }

        protected ParticleClassifierPreprocessingOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected ParticleClassifierPreprocessingOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            this.manualThreshold = this.backing.getInt(0);
            this.manualThresholdRange.read();
            this.autoThresholdMethod = ThresholdMethod.fromValue(this.backing.getInt(12));
            this.limits.read();
            this.particleType = ParticleType.fromValue(this.backing.getInt(24));
            this.rejectBorder = this.backing.getInt(28);
            this.numErosions = this.backing.getInt(32);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.manualThreshold);
            this.manualThresholdRange.write();
            if (this.autoThresholdMethod != null) {
                this.backing.putInt(12, this.autoThresholdMethod.getValue());
            }
            this.limits.write();
            if (this.particleType != null) {
                this.backing.putInt(24, this.particleType.getValue());
            }
            this.backing.putInt(28, this.rejectBorder);
            this.backing.putInt(32, this.numErosions);
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class NearestNeighborTrainingReport
    extends DisposedStruct {
        public NearestNeighborClassResult[] allScores;
        private ByteBuffer allScores_buf;

        private void init() {
            this.allScores = new NearestNeighborClassResult[0];
        }

        public NearestNeighborTrainingReport() {
            super(12);
            this.init();
        }

        public NearestNeighborTrainingReport(NearestNeighborClassResult[] allScores) {
            super(12);
            this.allScores = allScores;
        }

        protected NearestNeighborTrainingReport(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected NearestNeighborTrainingReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            int allScores_allScoresSize = this.backing.getInt(8);
            long allScores_addr = NIVision.getPointer(this.backing, 4);
            this.allScores = new NearestNeighborClassResult[allScores_allScoresSize];
            if (allScores_allScoresSize > 0 && allScores_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(allScores_addr, allScores_allScoresSize * 12);
                int i = 0;
                int off = 0;
                while (i < allScores_allScoresSize) {
                    this.allScores[i] = new NearestNeighborClassResult(bb, off);
                    this.allScores[i].read();
                    ++i;
                    off += 12;
                }
            }
        }

        @Override
        public void write() {
            this.allScores_buf = ByteBuffer.allocateDirect(this.allScores.length * 12).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.allScores.length) {
                this.allScores[i].setBuffer(this.allScores_buf, off);
                this.allScores[i].write();
                ++i;
                off += 12;
            }
            this.backing.putInt(8, this.allScores.length);
            NIVision.putPointer(this.backing, 4, this.allScores_buf);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class NearestNeighborClassResult
    extends DisposedStruct {
        public String className;
        public float standardDeviation;
        public int count;
        private ByteBuffer className_buf;

        private void init() {
        }

        public NearestNeighborClassResult() {
            super(12);
            this.init();
        }

        public NearestNeighborClassResult(String className, double standardDeviation, int count) {
            super(12);
            this.className = className;
            this.standardDeviation = (float)standardDeviation;
            this.count = count;
        }

        protected NearestNeighborClassResult(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected NearestNeighborClassResult(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            long className_addr = NIVision.getPointer(this.backing, 0);
            if (className_addr == 0L) {
                this.className = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(className_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.className = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.className = "";
                }
            }
            this.standardDeviation = this.backing.getFloat(4);
            this.count = this.backing.getInt(8);
        }

        @Override
        public void write() {
            if (this.className != null) {
                byte[] className_bytes;
                try {
                    className_bytes = this.className.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    className_bytes = new byte[]{};
                }
                this.className_buf = ByteBuffer.allocateDirect(className_bytes.length + 1);
                NIVision.putBytes(this.className_buf, className_bytes, 0, className_bytes.length).put(className_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.className == null ? 0L : NIVision.getByteBufferAddress(this.className_buf));
            this.backing.putFloat(4, this.standardDeviation);
            this.backing.putInt(8, this.count);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class ClassifierAccuracyReport
    extends DisposedStruct {
        public float accuracy;
        public String[] classNames;
        public double[] classAccuracy;
        public double[] classPredictiveValue;
        private ByteBuffer classNames_buf;
        private ByteBuffer[] classNames_bufs;
        private ByteBuffer classAccuracy_buf;
        private ByteBuffer classPredictiveValue_buf;

        private void init() {
            this.classNames = new String[0];
            this.classAccuracy = new double[0];
            this.classPredictiveValue = new double[0];
        }

        public ClassifierAccuracyReport() {
            super(24);
            this.init();
        }

        public ClassifierAccuracyReport(double accuracy, String[] classNames, double[] classAccuracy, double[] classPredictiveValue) {
            super(24);
            this.accuracy = (float)accuracy;
            this.classNames = classNames;
            this.classAccuracy = classAccuracy;
            this.classPredictiveValue = classPredictiveValue;
        }

        protected ClassifierAccuracyReport(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected ClassifierAccuracyReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.accuracy = this.backing.getFloat(4);
            int classNames_size = this.backing.getInt(0);
            long classNames_addr = NIVision.getPointer(this.backing, 8);
            this.classNames = new String[classNames_size];
            if (classNames_size > 0 && classNames_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(classNames_addr, classNames_size * 4);
                int i = 0;
                int off = 0;
                while (i < classNames_size) {
                    long addr = NIVision.getPointer(bb, off);
                    if (addr == 0L) {
                        this.classNames[i] = null;
                    } else {
                        ByteBuffer bb2 = NIVision.newDirectByteBuffer(addr, 1000);
                        while (bb2.get() != 0) {
                        }
                        byte[] bytes = new byte[bb2.position() - 1];
                        bb2.rewind();
                        NIVision.getBytes(bb2, bytes, 0, bytes.length);
                        try {
                            this.classNames[i] = new String(bytes, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            this.classNames[i] = "";
                        }
                    }
                    ++i;
                    off += 4;
                }
            }
            int classAccuracy_size = this.backing.getInt(0);
            long classAccuracy_addr = NIVision.getPointer(this.backing, 12);
            this.classAccuracy = new double[classAccuracy_size];
            if (classAccuracy_size > 0 && classAccuracy_addr != 0L) {
                NIVision.newDirectByteBuffer(classAccuracy_addr, classAccuracy_size * 8).asDoubleBuffer().get(this.classAccuracy);
            }
            int classPredictiveValue_size = this.backing.getInt(0);
            long classPredictiveValue_addr = NIVision.getPointer(this.backing, 16);
            this.classPredictiveValue = new double[classPredictiveValue_size];
            if (classPredictiveValue_size > 0 && classPredictiveValue_addr != 0L) {
                NIVision.newDirectByteBuffer(classPredictiveValue_addr, classPredictiveValue_size * 8).asDoubleBuffer().get(this.classPredictiveValue);
            }
        }

        @Override
        public void write() {
            this.backing.putFloat(4, this.accuracy);
            this.classNames_buf = ByteBuffer.allocateDirect(this.classNames.length * 4).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.classNames.length) {
                if (this.classNames[i] == null) {
                    NIVision.putPointer(this.classNames_buf, off, 0L);
                } else {
                    byte[] bytes;
                    try {
                        bytes = this.classNames[i].getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        bytes = new byte[]{};
                    }
                    this.classNames_bufs[i] = ByteBuffer.allocateDirect(bytes.length + 1);
                    NIVision.putBytes(this.classNames_bufs[i], bytes, 0, bytes.length).put(bytes.length, (byte)0);
                    NIVision.putPointer(this.classNames_buf, off, NIVision.getByteBufferAddress(this.classNames_bufs[i]));
                }
                ++i;
                off += 4;
            }
            this.backing.putInt(0, this.classNames.length);
            NIVision.putPointer(this.backing, 8, this.classNames_buf);
            this.classAccuracy_buf = ByteBuffer.allocateDirect(this.classAccuracy.length * 8).order(ByteOrder.nativeOrder());
            this.classAccuracy_buf.asDoubleBuffer().put(this.classAccuracy).rewind();
            this.backing.putInt(0, this.classAccuracy.length);
            NIVision.putPointer(this.backing, 12, this.classAccuracy_buf);
            this.classPredictiveValue_buf = ByteBuffer.allocateDirect(this.classPredictiveValue.length * 8).order(ByteOrder.nativeOrder());
            this.classPredictiveValue_buf.asDoubleBuffer().put(this.classPredictiveValue).rewind();
            this.backing.putInt(0, this.classPredictiveValue.length);
            NIVision.putPointer(this.backing, 16, this.classPredictiveValue_buf);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class DataMatrixOptions
    extends DisposedStruct {
        public Barcode2DSearchMode searchMode;
        public Barcode2DContrast contrast;
        public Barcode2DCellShape cellShape;
        public Barcode2DShape barcodeShape;
        public DataMatrixSubtype subtype;

        private void init() {
        }

        public DataMatrixOptions() {
            super(20);
            this.init();
        }

        public DataMatrixOptions(Barcode2DSearchMode searchMode, Barcode2DContrast contrast, Barcode2DCellShape cellShape, Barcode2DShape barcodeShape, DataMatrixSubtype subtype) {
            super(20);
            this.searchMode = searchMode;
            this.contrast = contrast;
            this.cellShape = cellShape;
            this.barcodeShape = barcodeShape;
            this.subtype = subtype;
        }

        protected DataMatrixOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected DataMatrixOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.searchMode = Barcode2DSearchMode.fromValue(this.backing.getInt(0));
            this.contrast = Barcode2DContrast.fromValue(this.backing.getInt(4));
            this.cellShape = Barcode2DCellShape.fromValue(this.backing.getInt(8));
            this.barcodeShape = Barcode2DShape.fromValue(this.backing.getInt(12));
            this.subtype = DataMatrixSubtype.fromValue(this.backing.getInt(16));
        }

        @Override
        public void write() {
            if (this.searchMode != null) {
                this.backing.putInt(0, this.searchMode.getValue());
            }
            if (this.contrast != null) {
                this.backing.putInt(4, this.contrast.getValue());
            }
            if (this.cellShape != null) {
                this.backing.putInt(8, this.cellShape.getValue());
            }
            if (this.barcodeShape != null) {
                this.backing.putInt(12, this.barcodeShape.getValue());
            }
            if (this.subtype != null) {
                this.backing.putInt(16, this.subtype.getValue());
            }
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class Barcode2DInfo
    extends DisposedStruct {
        public Barcode2DType type;
        public int binary;
        public byte[] data;
        public PointFloat[] boundingBox;
        public int numErrorsCorrected;
        public int numErasuresCorrected;
        public int rows;
        public int columns;
        private ByteBuffer data_buf;

        private void init() {
            this.data = new byte[0];
            this.boundingBox = new PointFloat[4];
            int i = 0;
            int off = 16;
            while (i < 4) {
                this.boundingBox[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public Barcode2DInfo() {
            super(64);
            this.init();
        }

        public Barcode2DInfo(Barcode2DType type, int binary, byte[] data, PointFloat[] boundingBox, int numErrorsCorrected, int numErasuresCorrected, int rows, int columns) {
            super(64);
            this.type = type;
            this.binary = binary;
            this.data = data;
            this.boundingBox = boundingBox;
            this.numErrorsCorrected = numErrorsCorrected;
            this.numErasuresCorrected = numErasuresCorrected;
            this.rows = rows;
            this.columns = columns;
        }

        protected Barcode2DInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected Barcode2DInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.type = Barcode2DType.fromValue(this.backing.getInt(0));
            this.binary = this.backing.getInt(4);
            int data_dataLength = this.backing.getInt(12);
            long data_addr = NIVision.getPointer(this.backing, 8);
            this.data = new byte[data_dataLength];
            if (data_dataLength > 0 && data_addr != 0L) {
                NIVision.getBytes(NIVision.newDirectByteBuffer(data_addr, data_dataLength), this.data, 0, data_dataLength);
            }
            for (PointFloat it : this.boundingBox) {
                it.read();
            }
            this.numErrorsCorrected = this.backing.getInt(48);
            this.numErasuresCorrected = this.backing.getInt(52);
            this.rows = this.backing.getInt(56);
            this.columns = this.backing.getInt(60);
        }

        @Override
        public void write() {
            if (this.type != null) {
                this.backing.putInt(0, this.type.getValue());
            }
            this.backing.putInt(4, this.binary);
            this.data_buf = ByteBuffer.allocateDirect(this.data.length);
            NIVision.putBytes(this.data_buf, this.data, 0, this.data.length);
            this.backing.putInt(12, this.data.length);
            NIVision.putPointer(this.backing, 8, this.data_buf);
            for (PointFloat it : this.boundingBox) {
                it.write();
            }
            this.backing.putInt(48, this.numErrorsCorrected);
            this.backing.putInt(52, this.numErasuresCorrected);
            this.backing.putInt(56, this.rows);
            this.backing.putInt(60, this.columns);
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class CurveOptions
    extends DisposedStruct {
        public ExtractionMode extractionMode;
        public int threshold;
        public EdgeFilterSize filterSize;
        public int minLength;
        public int rowStepSize;
        public int columnStepSize;
        public int maxEndPointGap;
        public int onlyClosed;
        public int subpixelAccuracy;

        private void init() {
        }

        public CurveOptions() {
            super(36);
            this.init();
        }

        public CurveOptions(ExtractionMode extractionMode, int threshold, EdgeFilterSize filterSize, int minLength, int rowStepSize, int columnStepSize, int maxEndPointGap, int onlyClosed, int subpixelAccuracy) {
            super(36);
            this.extractionMode = extractionMode;
            this.threshold = threshold;
            this.filterSize = filterSize;
            this.minLength = minLength;
            this.rowStepSize = rowStepSize;
            this.columnStepSize = columnStepSize;
            this.maxEndPointGap = maxEndPointGap;
            this.onlyClosed = onlyClosed;
            this.subpixelAccuracy = subpixelAccuracy;
        }

        protected CurveOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected CurveOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            this.extractionMode = ExtractionMode.fromValue(this.backing.getInt(0));
            this.threshold = this.backing.getInt(4);
            this.filterSize = EdgeFilterSize.fromValue(this.backing.getInt(8));
            this.minLength = this.backing.getInt(12);
            this.rowStepSize = this.backing.getInt(16);
            this.columnStepSize = this.backing.getInt(20);
            this.maxEndPointGap = this.backing.getInt(24);
            this.onlyClosed = this.backing.getInt(28);
            this.subpixelAccuracy = this.backing.getInt(32);
        }

        @Override
        public void write() {
            if (this.extractionMode != null) {
                this.backing.putInt(0, this.extractionMode.getValue());
            }
            this.backing.putInt(4, this.threshold);
            if (this.filterSize != null) {
                this.backing.putInt(8, this.filterSize.getValue());
            }
            this.backing.putInt(12, this.minLength);
            this.backing.putInt(16, this.rowStepSize);
            this.backing.putInt(20, this.columnStepSize);
            this.backing.putInt(24, this.maxEndPointGap);
            this.backing.putInt(28, this.onlyClosed);
            this.backing.putInt(32, this.subpixelAccuracy);
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class Curve
    extends DisposedStruct {
        public PointFloat[] points;
        public int closed;
        public double curveLength;
        public double minEdgeStrength;
        public double maxEdgeStrength;
        public double averageEdgeStrength;
        private ByteBuffer points_buf;

        private void init() {
            this.points = new PointFloat[0];
        }

        public Curve() {
            super(48);
            this.init();
        }

        public Curve(PointFloat[] points, int closed, double curveLength, double minEdgeStrength, double maxEdgeStrength, double averageEdgeStrength) {
            super(48);
            this.points = points;
            this.closed = closed;
            this.curveLength = curveLength;
            this.minEdgeStrength = minEdgeStrength;
            this.maxEdgeStrength = maxEdgeStrength;
            this.averageEdgeStrength = averageEdgeStrength;
        }

        protected Curve(ByteBuffer backing, int offset) {
            super(backing, offset, 48);
            this.init();
        }

        protected Curve(long nativeObj, boolean owned) {
            super(nativeObj, owned, 48);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 48);
        }

        @Override
        public void read() {
            int points_numPoints = this.backing.getInt(4);
            long points_addr = NIVision.getPointer(this.backing, 0);
            this.points = new PointFloat[points_numPoints];
            if (points_numPoints > 0 && points_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(points_addr, points_numPoints * 8);
                int i = 0;
                int off = 0;
                while (i < points_numPoints) {
                    this.points[i] = new PointFloat(bb, off);
                    this.points[i].read();
                    ++i;
                    off += 8;
                }
            }
            this.closed = this.backing.getInt(8);
            this.curveLength = this.backing.getDouble(16);
            this.minEdgeStrength = this.backing.getDouble(24);
            this.maxEdgeStrength = this.backing.getDouble(32);
            this.averageEdgeStrength = this.backing.getDouble(40);
        }

        @Override
        public void write() {
            this.points_buf = ByteBuffer.allocateDirect(this.points.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.points.length) {
                this.points[i].setBuffer(this.points_buf, off);
                this.points[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(4, this.points.length);
            NIVision.putPointer(this.backing, 0, this.points_buf);
            this.backing.putInt(8, this.closed);
            this.backing.putDouble(16, this.curveLength);
            this.backing.putDouble(24, this.minEdgeStrength);
            this.backing.putDouble(32, this.maxEdgeStrength);
            this.backing.putDouble(40, this.averageEdgeStrength);
        }

        @Override
        public int size() {
            return 48;
        }
    }

    public static class ShapeDetectionOptions
    extends DisposedStruct {
        public int mode;
        public RangeFloat[] angleRanges;
        public RangeFloat scaleRange;
        public double minMatchScore;
        private ByteBuffer angleRanges_buf;

        private void init() {
            this.angleRanges = new RangeFloat[0];
            this.scaleRange = new RangeFloat(this.backing, 12);
        }

        public ShapeDetectionOptions() {
            super(32);
            this.init();
        }

        public ShapeDetectionOptions(int mode, RangeFloat[] angleRanges, RangeFloat scaleRange, double minMatchScore) {
            super(32);
            this.mode = mode;
            this.angleRanges = angleRanges;
            this.scaleRange = scaleRange;
            this.minMatchScore = minMatchScore;
        }

        protected ShapeDetectionOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected ShapeDetectionOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.mode = this.backing.getInt(0);
            int angleRanges_numAngleRanges = this.backing.getInt(8);
            long angleRanges_addr = NIVision.getPointer(this.backing, 4);
            this.angleRanges = new RangeFloat[angleRanges_numAngleRanges];
            if (angleRanges_numAngleRanges > 0 && angleRanges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(angleRanges_addr, angleRanges_numAngleRanges * 8);
                int i = 0;
                int off = 0;
                while (i < angleRanges_numAngleRanges) {
                    this.angleRanges[i] = new RangeFloat(bb, off);
                    this.angleRanges[i].read();
                    ++i;
                    off += 8;
                }
            }
            this.scaleRange.read();
            this.minMatchScore = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.mode);
            this.angleRanges_buf = ByteBuffer.allocateDirect(this.angleRanges.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.angleRanges.length) {
                this.angleRanges[i].setBuffer(this.angleRanges_buf, off);
                this.angleRanges[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(8, this.angleRanges.length);
            NIVision.putPointer(this.backing, 4, this.angleRanges_buf);
            this.scaleRange.write();
            this.backing.putDouble(24, this.minMatchScore);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class CircleDescriptor
    extends DisposedStruct {
        public double minRadius;
        public double maxRadius;

        private void init() {
        }

        public CircleDescriptor() {
            super(16);
            this.init();
        }

        public CircleDescriptor(double minRadius, double maxRadius) {
            super(16);
            this.minRadius = minRadius;
            this.maxRadius = maxRadius;
        }

        protected CircleDescriptor(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected CircleDescriptor(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.minRadius = this.backing.getDouble(0);
            this.maxRadius = this.backing.getDouble(8);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.minRadius);
            this.backing.putDouble(8, this.maxRadius);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class CircleMatch
    extends DisposedStruct {
        public PointFloat position;
        public double radius;
        public double score;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
        }

        public CircleMatch() {
            super(24);
            this.init();
        }

        public CircleMatch(PointFloat position, double radius, double score) {
            super(24);
            this.position = position;
            this.radius = radius;
            this.score = score;
        }

        protected CircleMatch(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected CircleMatch(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.position.read();
            this.radius = this.backing.getDouble(8);
            this.score = this.backing.getDouble(16);
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putDouble(8, this.radius);
            this.backing.putDouble(16, this.score);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class EllipseMatch
    extends DisposedStruct {
        public PointFloat position;
        public double rotation;
        public double majorRadius;
        public double minorRadius;
        public double score;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
        }

        public EllipseMatch() {
            super(40);
            this.init();
        }

        public EllipseMatch(PointFloat position, double rotation, double majorRadius, double minorRadius, double score) {
            super(40);
            this.position = position;
            this.rotation = rotation;
            this.majorRadius = majorRadius;
            this.minorRadius = minorRadius;
            this.score = score;
        }

        protected EllipseMatch(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected EllipseMatch(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.position.read();
            this.rotation = this.backing.getDouble(8);
            this.majorRadius = this.backing.getDouble(16);
            this.minorRadius = this.backing.getDouble(24);
            this.score = this.backing.getDouble(32);
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putDouble(8, this.rotation);
            this.backing.putDouble(16, this.majorRadius);
            this.backing.putDouble(24, this.minorRadius);
            this.backing.putDouble(32, this.score);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class EllipseDescriptor
    extends DisposedStruct {
        public double minMajorRadius;
        public double maxMajorRadius;
        public double minMinorRadius;
        public double maxMinorRadius;

        private void init() {
        }

        public EllipseDescriptor() {
            super(32);
            this.init();
        }

        public EllipseDescriptor(double minMajorRadius, double maxMajorRadius, double minMinorRadius, double maxMinorRadius) {
            super(32);
            this.minMajorRadius = minMajorRadius;
            this.maxMajorRadius = maxMajorRadius;
            this.minMinorRadius = minMinorRadius;
            this.maxMinorRadius = maxMinorRadius;
        }

        protected EllipseDescriptor(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected EllipseDescriptor(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.minMajorRadius = this.backing.getDouble(0);
            this.maxMajorRadius = this.backing.getDouble(8);
            this.minMinorRadius = this.backing.getDouble(16);
            this.maxMinorRadius = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.minMajorRadius);
            this.backing.putDouble(8, this.maxMajorRadius);
            this.backing.putDouble(16, this.minMinorRadius);
            this.backing.putDouble(24, this.maxMinorRadius);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class RectangleMatch
    extends DisposedStruct {
        public PointFloat[] corner;
        public double rotation;
        public double width;
        public double height;
        public double score;

        private void init() {
            this.corner = new PointFloat[4];
            int i = 0;
            int off = 0;
            while (i < 4) {
                this.corner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public RectangleMatch() {
            super(64);
            this.init();
        }

        public RectangleMatch(PointFloat[] corner, double rotation, double width, double height, double score) {
            super(64);
            this.corner = corner;
            this.rotation = rotation;
            this.width = width;
            this.height = height;
            this.score = score;
        }

        protected RectangleMatch(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected RectangleMatch(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            for (PointFloat it : this.corner) {
                it.read();
            }
            this.rotation = this.backing.getDouble(32);
            this.width = this.backing.getDouble(40);
            this.height = this.backing.getDouble(48);
            this.score = this.backing.getDouble(56);
        }

        @Override
        public void write() {
            for (PointFloat it : this.corner) {
                it.write();
            }
            this.backing.putDouble(32, this.rotation);
            this.backing.putDouble(40, this.width);
            this.backing.putDouble(48, this.height);
            this.backing.putDouble(56, this.score);
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class RectangleDescriptor
    extends DisposedStruct {
        public double minWidth;
        public double maxWidth;
        public double minHeight;
        public double maxHeight;

        private void init() {
        }

        public RectangleDescriptor() {
            super(32);
            this.init();
        }

        public RectangleDescriptor(double minWidth, double maxWidth, double minHeight, double maxHeight) {
            super(32);
            this.minWidth = minWidth;
            this.maxWidth = maxWidth;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        protected RectangleDescriptor(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected RectangleDescriptor(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.minWidth = this.backing.getDouble(0);
            this.maxWidth = this.backing.getDouble(8);
            this.minHeight = this.backing.getDouble(16);
            this.maxHeight = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.minWidth);
            this.backing.putDouble(8, this.maxWidth);
            this.backing.putDouble(16, this.minHeight);
            this.backing.putDouble(24, this.maxHeight);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class LineDescriptor
    extends DisposedStruct {
        public double minLength;
        public double maxLength;

        private void init() {
        }

        public LineDescriptor() {
            super(16);
            this.init();
        }

        public LineDescriptor(double minLength, double maxLength) {
            super(16);
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        protected LineDescriptor(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected LineDescriptor(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.minLength = this.backing.getDouble(0);
            this.maxLength = this.backing.getDouble(8);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.minLength);
            this.backing.putDouble(8, this.maxLength);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class LineMatch
    extends DisposedStruct {
        public PointFloat startPoint;
        public PointFloat endPoint;
        public double length;
        public double rotation;
        public double score;

        private void init() {
            this.startPoint = new PointFloat(this.backing, 0);
            this.endPoint = new PointFloat(this.backing, 8);
        }

        public LineMatch() {
            super(40);
            this.init();
        }

        public LineMatch(PointFloat startPoint, PointFloat endPoint, double length, double rotation, double score) {
            super(40);
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.length = length;
            this.rotation = rotation;
            this.score = score;
        }

        protected LineMatch(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected LineMatch(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.startPoint.read();
            this.endPoint.read();
            this.length = this.backing.getDouble(16);
            this.rotation = this.backing.getDouble(24);
            this.score = this.backing.getDouble(32);
        }

        @Override
        public void write() {
            this.startPoint.write();
            this.endPoint.write();
            this.backing.putDouble(16, this.length);
            this.backing.putDouble(24, this.rotation);
            this.backing.putDouble(32, this.score);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class ClosedCurveFeature
    extends DisposedStruct {
        public PointFloat position;
        public double arcLength;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
        }

        public ClosedCurveFeature() {
            super(16);
            this.init();
        }

        public ClosedCurveFeature(PointFloat position, double arcLength) {
            super(16);
            this.position = position;
            this.arcLength = arcLength;
        }

        protected ClosedCurveFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ClosedCurveFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.position.read();
            this.arcLength = this.backing.getDouble(8);
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putDouble(8, this.arcLength);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class GeometricPatternMatch2
    extends DisposedStruct {
        public PointFloat position;
        public float rotation;
        public float scale;
        public float score;
        public PointFloat[] corner;
        public int inverse;
        public float occlusion;
        public float templateMatchCurveScore;
        public float matchTemplateCurveScore;
        public float correlationScore;
        public String label;
        public FeatureData[] featureData;
        public PointFloat calibratedPosition;
        public float calibratedRotation;
        public PointFloat[] calibratedCorner;
        private ByteBuffer featureData_buf;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
            this.corner = new PointFloat[4];
            int i = 0;
            int off = 20;
            while (i < 4) {
                this.corner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
            this.featureData = new FeatureData[0];
            this.calibratedPosition = new PointFloat(this.backing, 336);
            this.calibratedCorner = new PointFloat[4];
            i = 0;
            off = 348;
            while (i < 4) {
                this.calibratedCorner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public GeometricPatternMatch2() {
            super(380);
            this.init();
        }

        public GeometricPatternMatch2(PointFloat position, double rotation, double scale, double score, PointFloat[] corner, int inverse, double occlusion, double templateMatchCurveScore, double matchTemplateCurveScore, double correlationScore, String label, FeatureData[] featureData, PointFloat calibratedPosition, double calibratedRotation, PointFloat[] calibratedCorner) {
            super(380);
            this.position = position;
            this.rotation = (float)rotation;
            this.scale = (float)scale;
            this.score = (float)score;
            this.corner = corner;
            this.inverse = inverse;
            this.occlusion = (float)occlusion;
            this.templateMatchCurveScore = (float)templateMatchCurveScore;
            this.matchTemplateCurveScore = (float)matchTemplateCurveScore;
            this.correlationScore = (float)correlationScore;
            this.label = label;
            this.featureData = featureData;
            this.calibratedPosition = calibratedPosition;
            this.calibratedRotation = (float)calibratedRotation;
            this.calibratedCorner = calibratedCorner;
        }

        protected GeometricPatternMatch2(ByteBuffer backing, int offset) {
            super(backing, offset, 380);
            this.init();
        }

        protected GeometricPatternMatch2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 380);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 380);
        }

        @Override
        public void read() {
            int len;
            this.position.read();
            this.rotation = this.backing.getFloat(8);
            this.scale = this.backing.getFloat(12);
            this.score = this.backing.getFloat(16);
            for (PointFloat it : this.corner) {
                it.read();
            }
            this.inverse = this.backing.getInt(52);
            this.occlusion = this.backing.getFloat(56);
            this.templateMatchCurveScore = this.backing.getFloat(60);
            this.matchTemplateCurveScore = this.backing.getFloat(64);
            this.correlationScore = this.backing.getFloat(68);
            byte[] bytes = new byte[256];
            NIVision.getBytes(this.backing, bytes, 72, 256);
            for (len = 0; len < bytes.length && bytes[len] != 0; ++len) {
            }
            try {
                this.label = new String(bytes, 0, len, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.label = "";
            }
            int featureData_numFeatureData = this.backing.getInt(332);
            long featureData_addr = NIVision.getPointer(this.backing, 328);
            this.featureData = new FeatureData[featureData_numFeatureData];
            if (featureData_numFeatureData > 0 && featureData_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(featureData_addr, featureData_numFeatureData * 16);
                int i = 0;
                int off = 0;
                while (i < featureData_numFeatureData) {
                    this.featureData[i] = new FeatureData(bb, off);
                    this.featureData[i].read();
                    ++i;
                    off += 16;
                }
            }
            this.calibratedPosition.read();
            this.calibratedRotation = this.backing.getFloat(344);
            for (PointFloat it : this.calibratedCorner) {
                it.read();
            }
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putFloat(8, this.rotation);
            this.backing.putFloat(12, this.scale);
            this.backing.putFloat(16, this.score);
            for (PointFloat it : this.corner) {
                it.write();
            }
            this.backing.putInt(52, this.inverse);
            this.backing.putFloat(56, this.occlusion);
            this.backing.putFloat(60, this.templateMatchCurveScore);
            this.backing.putFloat(64, this.matchTemplateCurveScore);
            this.backing.putFloat(68, this.correlationScore);
            if (this.label != null) {
                byte[] bytes;
                try {
                    bytes = this.label.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                NIVision.putBytes(this.backing, bytes, 72, bytes.length);
                for (int i = bytes.length; i < 256; ++i) {
                    this.backing.put(i, (byte)0);
                }
            }
            this.featureData_buf = ByteBuffer.allocateDirect(this.featureData.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.featureData.length) {
                this.featureData[i].setBuffer(this.featureData_buf, off);
                this.featureData[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(332, this.featureData.length);
            NIVision.putPointer(this.backing, 328, this.featureData_buf);
            this.calibratedPosition.write();
            this.backing.putFloat(344, this.calibratedRotation);
            for (PointFloat it : this.calibratedCorner) {
                it.write();
            }
        }

        @Override
        public int size() {
            return 380;
        }
    }

    public static class FeatureData
    extends DisposedStruct {
        public FeatureType type;
        public PointFloat[] contourPoints;
        public CircleFeature circle;
        public EllipseFeature ellipse;
        public ConstCurveFeature constCurve;
        public RectangleFeature rectangle;
        public LegFeature leg;
        public CornerFeature corner;
        public ParallelLinePairFeature parallelLinePair;
        public PairOfParallelLinePairsFeature pairOfParallelLinePairs;
        public LineFeature line;
        public ClosedCurveFeature closedCurve;
        private ByteBuffer contourPoints_buf;

        private void init() {
            this.contourPoints = new PointFloat[0];
        }

        public FeatureData() {
            super(16);
            this.init();
        }

        public FeatureData(FeatureType type, PointFloat[] contourPoints) {
            super(16);
            this.type = type;
            this.contourPoints = contourPoints;
        }

        protected FeatureData(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected FeatureData(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.type = FeatureType.fromValue(this.backing.getInt(0));
            int contourPoints_numContourPoints = this.backing.getInt(8);
            long contourPoints_addr = NIVision.getPointer(this.backing, 4);
            this.contourPoints = new PointFloat[contourPoints_numContourPoints];
            if (contourPoints_numContourPoints > 0 && contourPoints_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(contourPoints_addr, contourPoints_numContourPoints * 8);
                int i = 0;
                int off = 0;
                while (i < contourPoints_numContourPoints) {
                    this.contourPoints[i] = new PointFloat(bb, off);
                    this.contourPoints[i].read();
                    ++i;
                    off += 8;
                }
            }
            if (this.type == FeatureType.CIRCLE_FEATURE) {
                long circle_addr = NIVision.getPointer(this.backing, 12);
                this.circle = circle_addr == 0L ? null : new CircleFeature(circle_addr, false);
            }
            if (this.type == FeatureType.ELLIPSE_FEATURE) {
                long ellipse_addr = NIVision.getPointer(this.backing, 12);
                this.ellipse = ellipse_addr == 0L ? null : new EllipseFeature(ellipse_addr, false);
            }
            if (this.type == FeatureType.CONST_CURVE_FEATURE) {
                long constCurve_addr = NIVision.getPointer(this.backing, 12);
                this.constCurve = constCurve_addr == 0L ? null : new ConstCurveFeature(constCurve_addr, false);
            }
            if (this.type == FeatureType.RECTANGLE_FEATURE) {
                long rectangle_addr = NIVision.getPointer(this.backing, 12);
                this.rectangle = rectangle_addr == 0L ? null : new RectangleFeature(rectangle_addr, false);
            }
            if (this.type == FeatureType.LEG_FEATURE) {
                long leg_addr = NIVision.getPointer(this.backing, 12);
                this.leg = leg_addr == 0L ? null : new LegFeature(leg_addr, false);
            }
            if (this.type == FeatureType.CORNER_FEATURE) {
                long corner_addr = NIVision.getPointer(this.backing, 12);
                this.corner = corner_addr == 0L ? null : new CornerFeature(corner_addr, false);
            }
            if (this.type == FeatureType.PARALLEL_LINE_PAIR_FEATURE) {
                long parallelLinePair_addr = NIVision.getPointer(this.backing, 12);
                this.parallelLinePair = parallelLinePair_addr == 0L ? null : new ParallelLinePairFeature(parallelLinePair_addr, false);
            }
            if (this.type == FeatureType.PAIR_OF_PARALLEL_LINE_PAIRS_FEATURE) {
                long pairOfParallelLinePairs_addr = NIVision.getPointer(this.backing, 12);
                this.pairOfParallelLinePairs = pairOfParallelLinePairs_addr == 0L ? null : new PairOfParallelLinePairsFeature(pairOfParallelLinePairs_addr, false);
            }
            if (this.type == FeatureType.LINE_FEATURE) {
                long line_addr = NIVision.getPointer(this.backing, 12);
                this.line = line_addr == 0L ? null : new LineFeature(line_addr, false);
            }
            if (this.type == FeatureType.CLOSED_CURVE_FEATURE) {
                long closedCurve_addr = NIVision.getPointer(this.backing, 12);
                this.closedCurve = closedCurve_addr == 0L ? null : new ClosedCurveFeature(closedCurve_addr, false);
            }
        }

        @Override
        public void write() {
            if (this.type != null) {
                this.backing.putInt(0, this.type.getValue());
            }
            this.contourPoints_buf = ByteBuffer.allocateDirect(this.contourPoints.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.contourPoints.length) {
                this.contourPoints[i].setBuffer(this.contourPoints_buf, off);
                this.contourPoints[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(8, this.contourPoints.length);
            NIVision.putPointer(this.backing, 4, this.contourPoints_buf);
            if (this.type == FeatureType.CIRCLE_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.circle);
            }
            if (this.type == FeatureType.ELLIPSE_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.ellipse);
            }
            if (this.type == FeatureType.CONST_CURVE_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.constCurve);
            }
            if (this.type == FeatureType.RECTANGLE_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.rectangle);
            }
            if (this.type == FeatureType.LEG_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.leg);
            }
            if (this.type == FeatureType.CORNER_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.corner);
            }
            if (this.type == FeatureType.PARALLEL_LINE_PAIR_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.parallelLinePair);
            }
            if (this.type == FeatureType.PAIR_OF_PARALLEL_LINE_PAIRS_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.pairOfParallelLinePairs);
            }
            if (this.type == FeatureType.LINE_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.line);
            }
            if (this.type == FeatureType.CLOSED_CURVE_FEATURE) {
                NIVision.putPointer(this.backing, 12, this.closedCurve);
            }
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class PairOfParallelLinePairsFeature
    extends DisposedStruct {
        public ParallelLinePairFeature firstParallelLinePair;
        public ParallelLinePairFeature secondParallelLinePair;
        public double rotation;
        public double distance;

        private void init() {
            this.firstParallelLinePair = new ParallelLinePairFeature(this.backing, 0);
            this.secondParallelLinePair = new ParallelLinePairFeature(this.backing, 48);
        }

        public PairOfParallelLinePairsFeature() {
            super(112);
            this.init();
        }

        public PairOfParallelLinePairsFeature(ParallelLinePairFeature firstParallelLinePair, ParallelLinePairFeature secondParallelLinePair, double rotation, double distance) {
            super(112);
            this.firstParallelLinePair = firstParallelLinePair;
            this.secondParallelLinePair = secondParallelLinePair;
            this.rotation = rotation;
            this.distance = distance;
        }

        protected PairOfParallelLinePairsFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 112);
            this.init();
        }

        protected PairOfParallelLinePairsFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 112);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 112);
        }

        @Override
        public void read() {
            this.firstParallelLinePair.read();
            this.secondParallelLinePair.read();
            this.rotation = this.backing.getDouble(96);
            this.distance = this.backing.getDouble(104);
        }

        @Override
        public void write() {
            this.firstParallelLinePair.write();
            this.secondParallelLinePair.write();
            this.backing.putDouble(96, this.rotation);
            this.backing.putDouble(104, this.distance);
        }

        @Override
        public int size() {
            return 112;
        }
    }

    public static class ParallelLinePairFeature
    extends DisposedStruct {
        public PointFloat firstStartPoint;
        public PointFloat firstEndPoint;
        public PointFloat secondStartPoint;
        public PointFloat secondEndPoint;
        public double rotation;
        public double distance;

        private void init() {
            this.firstStartPoint = new PointFloat(this.backing, 0);
            this.firstEndPoint = new PointFloat(this.backing, 8);
            this.secondStartPoint = new PointFloat(this.backing, 16);
            this.secondEndPoint = new PointFloat(this.backing, 24);
        }

        public ParallelLinePairFeature() {
            super(48);
            this.init();
        }

        public ParallelLinePairFeature(PointFloat firstStartPoint, PointFloat firstEndPoint, PointFloat secondStartPoint, PointFloat secondEndPoint, double rotation, double distance) {
            super(48);
            this.firstStartPoint = firstStartPoint;
            this.firstEndPoint = firstEndPoint;
            this.secondStartPoint = secondStartPoint;
            this.secondEndPoint = secondEndPoint;
            this.rotation = rotation;
            this.distance = distance;
        }

        protected ParallelLinePairFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 48);
            this.init();
        }

        protected ParallelLinePairFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 48);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 48);
        }

        @Override
        public void read() {
            this.firstStartPoint.read();
            this.firstEndPoint.read();
            this.secondStartPoint.read();
            this.secondEndPoint.read();
            this.rotation = this.backing.getDouble(32);
            this.distance = this.backing.getDouble(40);
        }

        @Override
        public void write() {
            this.firstStartPoint.write();
            this.firstEndPoint.write();
            this.secondStartPoint.write();
            this.secondEndPoint.write();
            this.backing.putDouble(32, this.rotation);
            this.backing.putDouble(40, this.distance);
        }

        @Override
        public int size() {
            return 48;
        }
    }

    public static class LineFeature
    extends DisposedStruct {
        public PointFloat startPoint;
        public PointFloat endPoint;
        public double length;
        public double rotation;

        private void init() {
            this.startPoint = new PointFloat(this.backing, 0);
            this.endPoint = new PointFloat(this.backing, 8);
        }

        public LineFeature() {
            super(32);
            this.init();
        }

        public LineFeature(PointFloat startPoint, PointFloat endPoint, double length, double rotation) {
            super(32);
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.length = length;
            this.rotation = rotation;
        }

        protected LineFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected LineFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.startPoint.read();
            this.endPoint.read();
            this.length = this.backing.getDouble(16);
            this.rotation = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.startPoint.write();
            this.endPoint.write();
            this.backing.putDouble(16, this.length);
            this.backing.putDouble(24, this.rotation);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class CornerFeature
    extends DisposedStruct {
        public PointFloat position;
        public double rotation;
        public double enclosedAngle;
        public int isVirtual;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
        }

        public CornerFeature() {
            super(32);
            this.init();
        }

        public CornerFeature(PointFloat position, double rotation, double enclosedAngle, int isVirtual) {
            super(32);
            this.position = position;
            this.rotation = rotation;
            this.enclosedAngle = enclosedAngle;
            this.isVirtual = isVirtual;
        }

        protected CornerFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected CornerFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.position.read();
            this.rotation = this.backing.getDouble(8);
            this.enclosedAngle = this.backing.getDouble(16);
            this.isVirtual = this.backing.getInt(24);
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putDouble(8, this.rotation);
            this.backing.putDouble(16, this.enclosedAngle);
            this.backing.putInt(24, this.isVirtual);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class LegFeature
    extends DisposedStruct {
        public PointFloat position;
        public PointFloat[] corner;
        public double rotation;
        public double width;
        public double height;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
            this.corner = new PointFloat[4];
            int i = 0;
            int off = 8;
            while (i < 4) {
                this.corner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public LegFeature() {
            super(64);
            this.init();
        }

        public LegFeature(PointFloat position, PointFloat[] corner, double rotation, double width, double height) {
            super(64);
            this.position = position;
            this.corner = corner;
            this.rotation = rotation;
            this.width = width;
            this.height = height;
        }

        protected LegFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected LegFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.position.read();
            for (PointFloat it : this.corner) {
                it.read();
            }
            this.rotation = this.backing.getDouble(40);
            this.width = this.backing.getDouble(48);
            this.height = this.backing.getDouble(56);
        }

        @Override
        public void write() {
            this.position.write();
            for (PointFloat it : this.corner) {
                it.write();
            }
            this.backing.putDouble(40, this.rotation);
            this.backing.putDouble(48, this.width);
            this.backing.putDouble(56, this.height);
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class RectangleFeature
    extends DisposedStruct {
        public PointFloat position;
        public PointFloat[] corner;
        public double rotation;
        public double width;
        public double height;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
            this.corner = new PointFloat[4];
            int i = 0;
            int off = 8;
            while (i < 4) {
                this.corner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public RectangleFeature() {
            super(64);
            this.init();
        }

        public RectangleFeature(PointFloat position, PointFloat[] corner, double rotation, double width, double height) {
            super(64);
            this.position = position;
            this.corner = corner;
            this.rotation = rotation;
            this.width = width;
            this.height = height;
        }

        protected RectangleFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected RectangleFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.position.read();
            for (PointFloat it : this.corner) {
                it.read();
            }
            this.rotation = this.backing.getDouble(40);
            this.width = this.backing.getDouble(48);
            this.height = this.backing.getDouble(56);
        }

        @Override
        public void write() {
            this.position.write();
            for (PointFloat it : this.corner) {
                it.write();
            }
            this.backing.putDouble(40, this.rotation);
            this.backing.putDouble(48, this.width);
            this.backing.putDouble(56, this.height);
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class ConstCurveFeature
    extends DisposedStruct {
        public PointFloat position;
        public double radius;
        public double startAngle;
        public double endAngle;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
        }

        public ConstCurveFeature() {
            super(32);
            this.init();
        }

        public ConstCurveFeature(PointFloat position, double radius, double startAngle, double endAngle) {
            super(32);
            this.position = position;
            this.radius = radius;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        protected ConstCurveFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected ConstCurveFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.position.read();
            this.radius = this.backing.getDouble(8);
            this.startAngle = this.backing.getDouble(16);
            this.endAngle = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putDouble(8, this.radius);
            this.backing.putDouble(16, this.startAngle);
            this.backing.putDouble(24, this.endAngle);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class CircleFeature
    extends DisposedStruct {
        public PointFloat position;
        public double radius;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
        }

        public CircleFeature() {
            super(16);
            this.init();
        }

        public CircleFeature(PointFloat position, double radius) {
            super(16);
            this.position = position;
            this.radius = radius;
        }

        protected CircleFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected CircleFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.position.read();
            this.radius = this.backing.getDouble(8);
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putDouble(8, this.radius);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class EllipseFeature
    extends DisposedStruct {
        public PointFloat position;
        public double rotation;
        public double minorRadius;
        public double majorRadius;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
        }

        public EllipseFeature() {
            super(32);
            this.init();
        }

        public EllipseFeature(PointFloat position, double rotation, double minorRadius, double majorRadius) {
            super(32);
            this.position = position;
            this.rotation = rotation;
            this.minorRadius = minorRadius;
            this.majorRadius = majorRadius;
        }

        protected EllipseFeature(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected EllipseFeature(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.position.read();
            this.rotation = this.backing.getDouble(8);
            this.minorRadius = this.backing.getDouble(16);
            this.majorRadius = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putDouble(8, this.rotation);
            this.backing.putDouble(16, this.minorRadius);
            this.backing.putDouble(24, this.majorRadius);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class ReadTextReport2
    extends DisposedStruct {
        public String readString;
        public CharReport2[] characterReport;
        private ByteBuffer readString_buf;
        private ByteBuffer characterReport_buf;

        private void init() {
            this.characterReport = new CharReport2[0];
        }

        public ReadTextReport2() {
            super(12);
            this.init();
        }

        public ReadTextReport2(String readString, CharReport2[] characterReport) {
            super(12);
            this.readString = readString;
            this.characterReport = characterReport;
        }

        protected ReadTextReport2(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected ReadTextReport2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            long readString_addr = NIVision.getPointer(this.backing, 0);
            if (readString_addr == 0L) {
                this.readString = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(readString_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.readString = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.readString = "";
                }
            }
            int characterReport_numCharacterReports = this.backing.getInt(8);
            long characterReport_addr = NIVision.getPointer(this.backing, 4);
            this.characterReport = new CharReport2[characterReport_numCharacterReports];
            if (characterReport_numCharacterReports > 0 && characterReport_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(characterReport_addr, characterReport_numCharacterReports * 56);
                int i = 0;
                int off = 0;
                while (i < characterReport_numCharacterReports) {
                    this.characterReport[i] = new CharReport2(bb, off);
                    this.characterReport[i].read();
                    ++i;
                    off += 56;
                }
            }
        }

        @Override
        public void write() {
            if (this.readString != null) {
                byte[] readString_bytes;
                try {
                    readString_bytes = this.readString.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    readString_bytes = new byte[]{};
                }
                this.readString_buf = ByteBuffer.allocateDirect(readString_bytes.length + 1);
                NIVision.putBytes(this.readString_buf, readString_bytes, 0, readString_bytes.length).put(readString_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.readString == null ? 0L : NIVision.getByteBufferAddress(this.readString_buf));
            this.characterReport_buf = ByteBuffer.allocateDirect(this.characterReport.length * 56).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.characterReport.length) {
                this.characterReport[i].setBuffer(this.characterReport_buf, off);
                this.characterReport[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(8, this.characterReport.length);
            NIVision.putPointer(this.backing, 4, this.characterReport_buf);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class CharInfo2
    extends DisposedStruct {
        public String charValue;
        public Image charImage;
        public Image internalImage;
        public int isReferenceChar;
        private ByteBuffer charValue_buf;

        private void init() {
        }

        public CharInfo2() {
            super(16);
            this.init();
        }

        public CharInfo2(String charValue, Image charImage, Image internalImage, int isReferenceChar) {
            super(16);
            this.charValue = charValue;
            this.charImage = charImage;
            this.internalImage = internalImage;
            this.isReferenceChar = isReferenceChar;
        }

        protected CharInfo2(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected CharInfo2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            long charValue_addr = NIVision.getPointer(this.backing, 0);
            if (charValue_addr == 0L) {
                this.charValue = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(charValue_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.charValue = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.charValue = "";
                }
            }
            long charImage_addr = NIVision.getPointer(this.backing, 4);
            this.charImage = charImage_addr == 0L ? null : new Image(charImage_addr, false);
            long internalImage_addr = NIVision.getPointer(this.backing, 8);
            this.internalImage = internalImage_addr == 0L ? null : new Image(internalImage_addr, false);
            this.isReferenceChar = this.backing.getInt(12);
        }

        @Override
        public void write() {
            if (this.charValue != null) {
                byte[] charValue_bytes;
                try {
                    charValue_bytes = this.charValue.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    charValue_bytes = new byte[]{};
                }
                this.charValue_buf = ByteBuffer.allocateDirect(charValue_bytes.length + 1);
                NIVision.putBytes(this.charValue_buf, charValue_bytes, 0, charValue_bytes.length).put(charValue_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.charValue == null ? 0L : NIVision.getByteBufferAddress(this.charValue_buf));
            NIVision.putPointer(this.backing, 4, this.charImage);
            NIVision.putPointer(this.backing, 8, this.internalImage);
            this.backing.putInt(12, this.isReferenceChar);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class CharReport2
    extends DisposedStruct {
        public String character;
        public PointFloat[] corner;
        public int lowThreshold;
        public int highThreshold;
        public int classificationScore;
        public int verificationScore;
        public int verified;
        private ByteBuffer character_buf;

        private void init() {
            this.corner = new PointFloat[4];
            int i = 0;
            int off = 4;
            while (i < 4) {
                this.corner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public CharReport2() {
            super(56);
            this.init();
        }

        public CharReport2(String character, PointFloat[] corner, int lowThreshold, int highThreshold, int classificationScore, int verificationScore, int verified) {
            super(56);
            this.character = character;
            this.corner = corner;
            this.lowThreshold = lowThreshold;
            this.highThreshold = highThreshold;
            this.classificationScore = classificationScore;
            this.verificationScore = verificationScore;
            this.verified = verified;
        }

        protected CharReport2(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected CharReport2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            long character_addr = NIVision.getPointer(this.backing, 0);
            if (character_addr == 0L) {
                this.character = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(character_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.character = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.character = "";
                }
            }
            for (PointFloat it : this.corner) {
                it.read();
            }
            this.lowThreshold = this.backing.getInt(36);
            this.highThreshold = this.backing.getInt(40);
            this.classificationScore = this.backing.getInt(44);
            this.verificationScore = this.backing.getInt(48);
            this.verified = this.backing.getInt(52);
        }

        @Override
        public void write() {
            if (this.character != null) {
                byte[] character_bytes;
                try {
                    character_bytes = this.character.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    character_bytes = new byte[]{};
                }
                this.character_buf = ByteBuffer.allocateDirect(character_bytes.length + 1);
                NIVision.putBytes(this.character_buf, character_bytes, 0, character_bytes.length).put(character_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.character == null ? 0L : NIVision.getByteBufferAddress(this.character_buf));
            for (PointFloat it : this.corner) {
                it.write();
            }
            this.backing.putInt(36, this.lowThreshold);
            this.backing.putInt(40, this.highThreshold);
            this.backing.putInt(44, this.classificationScore);
            this.backing.putInt(48, this.verificationScore);
            this.backing.putInt(52, this.verified);
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class InspectionOptions
    extends DisposedStruct {
        public RegistrationMethod registrationMethod;
        public NormalizationMethod normalizationMethod;
        public int edgeThicknessToIgnore;
        public float brightThreshold;
        public float darkThreshold;
        public int binary;

        private void init() {
        }

        public InspectionOptions() {
            super(24);
            this.init();
        }

        public InspectionOptions(RegistrationMethod registrationMethod, NormalizationMethod normalizationMethod, int edgeThicknessToIgnore, double brightThreshold, double darkThreshold, int binary) {
            super(24);
            this.registrationMethod = registrationMethod;
            this.normalizationMethod = normalizationMethod;
            this.edgeThicknessToIgnore = edgeThicknessToIgnore;
            this.brightThreshold = (float)brightThreshold;
            this.darkThreshold = (float)darkThreshold;
            this.binary = binary;
        }

        protected InspectionOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected InspectionOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.registrationMethod = RegistrationMethod.fromValue(this.backing.getInt(0));
            this.normalizationMethod = NormalizationMethod.fromValue(this.backing.getInt(4));
            this.edgeThicknessToIgnore = this.backing.getInt(8);
            this.brightThreshold = this.backing.getFloat(12);
            this.darkThreshold = this.backing.getFloat(16);
            this.binary = this.backing.getInt(20);
        }

        @Override
        public void write() {
            if (this.registrationMethod != null) {
                this.backing.putInt(0, this.registrationMethod.getValue());
            }
            if (this.normalizationMethod != null) {
                this.backing.putInt(4, this.normalizationMethod.getValue());
            }
            this.backing.putInt(8, this.edgeThicknessToIgnore);
            this.backing.putFloat(12, this.brightThreshold);
            this.backing.putFloat(16, this.darkThreshold);
            this.backing.putInt(20, this.binary);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class InspectionAlignment
    extends DisposedStruct {
        public PointFloat position;
        public float rotation;
        public float scale;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
        }

        public InspectionAlignment() {
            super(16);
            this.init();
        }

        public InspectionAlignment(PointFloat position, double rotation, double scale) {
            super(16);
            this.position = position;
            this.rotation = (float)rotation;
            this.scale = (float)scale;
        }

        protected InspectionAlignment(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected InspectionAlignment(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.position.read();
            this.rotation = this.backing.getFloat(8);
            this.scale = this.backing.getFloat(12);
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putFloat(8, this.rotation);
            this.backing.putFloat(12, this.scale);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class MatchGeometricPatternAdvancedOptions2
    extends DisposedStruct {
        public int minFeaturesUsed;
        public int maxFeaturesUsed;
        public int subpixelIterations;
        public double subpixelTolerance;
        public int initialMatchListLength;
        public float matchTemplateCurveScore;
        public int correlationScore;
        public double minMatchSeparationDistance;
        public double minMatchSeparationAngle;
        public double minMatchSeparationScale;
        public double maxMatchOverlap;
        public int coarseResult;
        public int smoothContours;
        public int enableCalibrationSupport;

        private void init() {
        }

        public MatchGeometricPatternAdvancedOptions2() {
            super(88);
            this.init();
        }

        public MatchGeometricPatternAdvancedOptions2(int minFeaturesUsed, int maxFeaturesUsed, int subpixelIterations, double subpixelTolerance, int initialMatchListLength, double matchTemplateCurveScore, int correlationScore, double minMatchSeparationDistance, double minMatchSeparationAngle, double minMatchSeparationScale, double maxMatchOverlap, int coarseResult, int smoothContours, int enableCalibrationSupport) {
            super(88);
            this.minFeaturesUsed = minFeaturesUsed;
            this.maxFeaturesUsed = maxFeaturesUsed;
            this.subpixelIterations = subpixelIterations;
            this.subpixelTolerance = subpixelTolerance;
            this.initialMatchListLength = initialMatchListLength;
            this.matchTemplateCurveScore = (float)matchTemplateCurveScore;
            this.correlationScore = correlationScore;
            this.minMatchSeparationDistance = minMatchSeparationDistance;
            this.minMatchSeparationAngle = minMatchSeparationAngle;
            this.minMatchSeparationScale = minMatchSeparationScale;
            this.maxMatchOverlap = maxMatchOverlap;
            this.coarseResult = coarseResult;
            this.smoothContours = smoothContours;
            this.enableCalibrationSupport = enableCalibrationSupport;
        }

        protected MatchGeometricPatternAdvancedOptions2(ByteBuffer backing, int offset) {
            super(backing, offset, 88);
            this.init();
        }

        protected MatchGeometricPatternAdvancedOptions2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 88);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 88);
        }

        @Override
        public void read() {
            this.minFeaturesUsed = this.backing.getInt(0);
            this.maxFeaturesUsed = this.backing.getInt(4);
            this.subpixelIterations = this.backing.getInt(8);
            this.subpixelTolerance = this.backing.getDouble(16);
            this.initialMatchListLength = this.backing.getInt(24);
            this.matchTemplateCurveScore = this.backing.getFloat(28);
            this.correlationScore = this.backing.getInt(32);
            this.minMatchSeparationDistance = this.backing.getDouble(40);
            this.minMatchSeparationAngle = this.backing.getDouble(48);
            this.minMatchSeparationScale = this.backing.getDouble(56);
            this.maxMatchOverlap = this.backing.getDouble(64);
            this.coarseResult = this.backing.getInt(72);
            this.smoothContours = this.backing.getInt(76);
            this.enableCalibrationSupport = this.backing.getInt(80);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.minFeaturesUsed);
            this.backing.putInt(4, this.maxFeaturesUsed);
            this.backing.putInt(8, this.subpixelIterations);
            this.backing.putDouble(16, this.subpixelTolerance);
            this.backing.putInt(24, this.initialMatchListLength);
            this.backing.putFloat(28, this.matchTemplateCurveScore);
            this.backing.putInt(32, this.correlationScore);
            this.backing.putDouble(40, this.minMatchSeparationDistance);
            this.backing.putDouble(48, this.minMatchSeparationAngle);
            this.backing.putDouble(56, this.minMatchSeparationScale);
            this.backing.putDouble(64, this.maxMatchOverlap);
            this.backing.putInt(72, this.coarseResult);
            this.backing.putInt(76, this.smoothContours);
            this.backing.putInt(80, this.enableCalibrationSupport);
        }

        @Override
        public int size() {
            return 88;
        }
    }

    public static class JPEG2000FileAdvancedOptions
    extends DisposedStruct {
        public WaveletTransformMode waveletMode;
        public int useMultiComponentTransform;
        public int maxWaveletTransformLevel;
        public float quantizationStepSize;

        private void init() {
        }

        public JPEG2000FileAdvancedOptions() {
            super(16);
            this.init();
        }

        public JPEG2000FileAdvancedOptions(WaveletTransformMode waveletMode, int useMultiComponentTransform, int maxWaveletTransformLevel, double quantizationStepSize) {
            super(16);
            this.waveletMode = waveletMode;
            this.useMultiComponentTransform = useMultiComponentTransform;
            this.maxWaveletTransformLevel = maxWaveletTransformLevel;
            this.quantizationStepSize = (float)quantizationStepSize;
        }

        protected JPEG2000FileAdvancedOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected JPEG2000FileAdvancedOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.waveletMode = WaveletTransformMode.fromValue(this.backing.getInt(0));
            this.useMultiComponentTransform = this.backing.getInt(4);
            this.maxWaveletTransformLevel = this.backing.getInt(8);
            this.quantizationStepSize = this.backing.getFloat(12);
        }

        @Override
        public void write() {
            if (this.waveletMode != null) {
                this.backing.putInt(0, this.waveletMode.getValue());
            }
            this.backing.putInt(4, this.useMultiComponentTransform);
            this.backing.putInt(8, this.maxWaveletTransformLevel);
            this.backing.putFloat(12, this.quantizationStepSize);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class DataMatrixReport
    extends DisposedStruct {
        public int found;
        public int binary;
        public byte[] data;
        public PointFloat[] boundingBox;
        public int numErrorsCorrected;
        public int numErasuresCorrected;
        public float aspectRatio;
        public int rows;
        public int columns;
        public DataMatrixECC ecc;
        public DataMatrixPolarity polarity;
        public DataMatrixCellFillMode cellFill;
        public float borderIntegrity;
        public int mirrored;
        public int minimumEdgeStrength;
        public DataMatrixDemodulationMode demodulationMode;
        public DataMatrixCellSampleSize cellSampleSize;
        public DataMatrixCellFilterMode cellFilterMode;
        public int iterations;
        private ByteBuffer data_buf;

        private void init() {
            this.data = new byte[0];
            this.boundingBox = new PointFloat[4];
            int i = 0;
            int off = 16;
            while (i < 4) {
                this.boundingBox[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public DataMatrixReport() {
            super(144);
            this.init();
        }

        public DataMatrixReport(int found, int binary, byte[] data, PointFloat[] boundingBox, int numErrorsCorrected, int numErasuresCorrected, double aspectRatio, int rows, int columns, DataMatrixECC ecc, DataMatrixPolarity polarity, DataMatrixCellFillMode cellFill, double borderIntegrity, int mirrored, int minimumEdgeStrength, DataMatrixDemodulationMode demodulationMode, DataMatrixCellSampleSize cellSampleSize, DataMatrixCellFilterMode cellFilterMode, int iterations) {
            super(144);
            this.found = found;
            this.binary = binary;
            this.data = data;
            this.boundingBox = boundingBox;
            this.numErrorsCorrected = numErrorsCorrected;
            this.numErasuresCorrected = numErasuresCorrected;
            this.aspectRatio = (float)aspectRatio;
            this.rows = rows;
            this.columns = columns;
            this.ecc = ecc;
            this.polarity = polarity;
            this.cellFill = cellFill;
            this.borderIntegrity = (float)borderIntegrity;
            this.mirrored = mirrored;
            this.minimumEdgeStrength = minimumEdgeStrength;
            this.demodulationMode = demodulationMode;
            this.cellSampleSize = cellSampleSize;
            this.cellFilterMode = cellFilterMode;
            this.iterations = iterations;
        }

        protected DataMatrixReport(ByteBuffer backing, int offset) {
            super(backing, offset, 144);
            this.init();
        }

        protected DataMatrixReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 144);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 144);
        }

        @Override
        public void read() {
            this.found = this.backing.getInt(0);
            this.binary = this.backing.getInt(4);
            int data_dataLength = this.backing.getInt(12);
            long data_addr = NIVision.getPointer(this.backing, 8);
            this.data = new byte[data_dataLength];
            if (data_dataLength > 0 && data_addr != 0L) {
                NIVision.getBytes(NIVision.newDirectByteBuffer(data_addr, data_dataLength), this.data, 0, data_dataLength);
            }
            for (PointFloat it : this.boundingBox) {
                it.read();
            }
            this.numErrorsCorrected = this.backing.getInt(48);
            this.numErasuresCorrected = this.backing.getInt(52);
            this.aspectRatio = this.backing.getFloat(56);
            this.rows = this.backing.getInt(60);
            this.columns = this.backing.getInt(64);
            this.ecc = DataMatrixECC.fromValue(this.backing.getInt(72));
            this.polarity = DataMatrixPolarity.fromValue(this.backing.getInt(80));
            this.cellFill = DataMatrixCellFillMode.fromValue(this.backing.getInt(88));
            this.borderIntegrity = this.backing.getFloat(96);
            this.mirrored = this.backing.getInt(100);
            this.minimumEdgeStrength = this.backing.getInt(104);
            this.demodulationMode = DataMatrixDemodulationMode.fromValue(this.backing.getInt(112));
            this.cellSampleSize = DataMatrixCellSampleSize.fromValue(this.backing.getInt(120));
            this.cellFilterMode = DataMatrixCellFilterMode.fromValue(this.backing.getInt(128));
            this.iterations = this.backing.getInt(136);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.found);
            this.backing.putInt(4, this.binary);
            this.data_buf = ByteBuffer.allocateDirect(this.data.length);
            NIVision.putBytes(this.data_buf, this.data, 0, this.data.length);
            this.backing.putInt(12, this.data.length);
            NIVision.putPointer(this.backing, 8, this.data_buf);
            for (PointFloat it : this.boundingBox) {
                it.write();
            }
            this.backing.putInt(48, this.numErrorsCorrected);
            this.backing.putInt(52, this.numErasuresCorrected);
            this.backing.putFloat(56, this.aspectRatio);
            this.backing.putInt(60, this.rows);
            this.backing.putInt(64, this.columns);
            if (this.ecc != null) {
                this.backing.putInt(72, this.ecc.getValue());
            }
            if (this.polarity != null) {
                this.backing.putInt(80, this.polarity.getValue());
            }
            if (this.cellFill != null) {
                this.backing.putInt(88, this.cellFill.getValue());
            }
            this.backing.putFloat(96, this.borderIntegrity);
            this.backing.putInt(100, this.mirrored);
            this.backing.putInt(104, this.minimumEdgeStrength);
            if (this.demodulationMode != null) {
                this.backing.putInt(112, this.demodulationMode.getValue());
            }
            if (this.cellSampleSize != null) {
                this.backing.putInt(120, this.cellSampleSize.getValue());
            }
            if (this.cellFilterMode != null) {
                this.backing.putInt(128, this.cellFilterMode.getValue());
            }
            this.backing.putInt(136, this.iterations);
        }

        @Override
        public int size() {
            return 144;
        }
    }

    public static class DataMatrixSearchOptions
    extends DisposedStruct {
        public DataMatrixRotationMode rotationMode;
        public int skipLocation;
        public int edgeThreshold;
        public DataMatrixDemodulationMode demodulationMode;
        public DataMatrixCellSampleSize cellSampleSize;
        public DataMatrixCellFilterMode cellFilterMode;
        public int skewDegreesAllowed;
        public int maxIterations;
        public int initialSearchVectorWidth;

        private void init() {
        }

        public DataMatrixSearchOptions() {
            super(56);
            this.init();
        }

        public DataMatrixSearchOptions(DataMatrixRotationMode rotationMode, int skipLocation, int edgeThreshold, DataMatrixDemodulationMode demodulationMode, DataMatrixCellSampleSize cellSampleSize, DataMatrixCellFilterMode cellFilterMode, int skewDegreesAllowed, int maxIterations, int initialSearchVectorWidth) {
            super(56);
            this.rotationMode = rotationMode;
            this.skipLocation = skipLocation;
            this.edgeThreshold = edgeThreshold;
            this.demodulationMode = demodulationMode;
            this.cellSampleSize = cellSampleSize;
            this.cellFilterMode = cellFilterMode;
            this.skewDegreesAllowed = skewDegreesAllowed;
            this.maxIterations = maxIterations;
            this.initialSearchVectorWidth = initialSearchVectorWidth;
        }

        protected DataMatrixSearchOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected DataMatrixSearchOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            this.rotationMode = DataMatrixRotationMode.fromValue(this.backing.getInt(0));
            this.skipLocation = this.backing.getInt(4);
            this.edgeThreshold = this.backing.getInt(8);
            this.demodulationMode = DataMatrixDemodulationMode.fromValue(this.backing.getInt(16));
            this.cellSampleSize = DataMatrixCellSampleSize.fromValue(this.backing.getInt(24));
            this.cellFilterMode = DataMatrixCellFilterMode.fromValue(this.backing.getInt(32));
            this.skewDegreesAllowed = this.backing.getInt(40);
            this.maxIterations = this.backing.getInt(44);
            this.initialSearchVectorWidth = this.backing.getInt(48);
        }

        @Override
        public void write() {
            if (this.rotationMode != null) {
                this.backing.putInt(0, this.rotationMode.getValue());
            }
            this.backing.putInt(4, this.skipLocation);
            this.backing.putInt(8, this.edgeThreshold);
            if (this.demodulationMode != null) {
                this.backing.putInt(16, this.demodulationMode.getValue());
            }
            if (this.cellSampleSize != null) {
                this.backing.putInt(24, this.cellSampleSize.getValue());
            }
            if (this.cellFilterMode != null) {
                this.backing.putInt(32, this.cellFilterMode.getValue());
            }
            this.backing.putInt(40, this.skewDegreesAllowed);
            this.backing.putInt(44, this.maxIterations);
            this.backing.putInt(48, this.initialSearchVectorWidth);
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class DataMatrixDescriptionOptions
    extends DisposedStruct {
        public float aspectRatio;
        public int rows;
        public int columns;
        public int rectangle;
        public DataMatrixECC ecc;
        public DataMatrixPolarity polarity;
        public DataMatrixCellFillMode cellFill;
        public float minBorderIntegrity;
        public DataMatrixMirrorMode mirrorMode;

        private void init() {
        }

        public DataMatrixDescriptionOptions() {
            super(56);
            this.init();
        }

        public DataMatrixDescriptionOptions(double aspectRatio, int rows, int columns, int rectangle, DataMatrixECC ecc, DataMatrixPolarity polarity, DataMatrixCellFillMode cellFill, double minBorderIntegrity, DataMatrixMirrorMode mirrorMode) {
            super(56);
            this.aspectRatio = (float)aspectRatio;
            this.rows = rows;
            this.columns = columns;
            this.rectangle = rectangle;
            this.ecc = ecc;
            this.polarity = polarity;
            this.cellFill = cellFill;
            this.minBorderIntegrity = (float)minBorderIntegrity;
            this.mirrorMode = mirrorMode;
        }

        protected DataMatrixDescriptionOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected DataMatrixDescriptionOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            this.aspectRatio = this.backing.getFloat(0);
            this.rows = this.backing.getInt(4);
            this.columns = this.backing.getInt(8);
            this.rectangle = this.backing.getInt(12);
            this.ecc = DataMatrixECC.fromValue(this.backing.getInt(16));
            this.polarity = DataMatrixPolarity.fromValue(this.backing.getInt(24));
            this.cellFill = DataMatrixCellFillMode.fromValue(this.backing.getInt(32));
            this.minBorderIntegrity = this.backing.getFloat(40);
            this.mirrorMode = DataMatrixMirrorMode.fromValue(this.backing.getInt(48));
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.aspectRatio);
            this.backing.putInt(4, this.rows);
            this.backing.putInt(8, this.columns);
            this.backing.putInt(12, this.rectangle);
            if (this.ecc != null) {
                this.backing.putInt(16, this.ecc.getValue());
            }
            if (this.polarity != null) {
                this.backing.putInt(24, this.polarity.getValue());
            }
            if (this.cellFill != null) {
                this.backing.putInt(32, this.cellFill.getValue());
            }
            this.backing.putFloat(40, this.minBorderIntegrity);
            if (this.mirrorMode != null) {
                this.backing.putInt(48, this.mirrorMode.getValue());
            }
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class DataMatrixSizeOptions
    extends DisposedStruct {
        public int minSize;
        public int maxSize;
        public int quietZoneWidth;

        private void init() {
        }

        public DataMatrixSizeOptions() {
            super(12);
            this.init();
        }

        public DataMatrixSizeOptions(int minSize, int maxSize, int quietZoneWidth) {
            super(12);
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.quietZoneWidth = quietZoneWidth;
        }

        protected DataMatrixSizeOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected DataMatrixSizeOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.minSize = this.backing.getInt(0);
            this.maxSize = this.backing.getInt(4);
            this.quietZoneWidth = this.backing.getInt(8);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.minSize);
            this.backing.putInt(4, this.maxSize);
            this.backing.putInt(8, this.quietZoneWidth);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class AIMGradeReport
    extends DisposedStruct {
        public AIMGrade overallGrade;
        public AIMGrade decodingGrade;
        public AIMGrade symbolContrastGrade;
        public float symbolContrast;
        public AIMGrade printGrowthGrade;
        public float printGrowth;
        public AIMGrade axialNonuniformityGrade;
        public float axialNonuniformity;
        public AIMGrade unusedErrorCorrectionGrade;
        public float unusedErrorCorrection;

        private void init() {
        }

        public AIMGradeReport() {
            super(40);
            this.init();
        }

        public AIMGradeReport(AIMGrade overallGrade, AIMGrade decodingGrade, AIMGrade symbolContrastGrade, double symbolContrast, AIMGrade printGrowthGrade, double printGrowth, AIMGrade axialNonuniformityGrade, double axialNonuniformity, AIMGrade unusedErrorCorrectionGrade, double unusedErrorCorrection) {
            super(40);
            this.overallGrade = overallGrade;
            this.decodingGrade = decodingGrade;
            this.symbolContrastGrade = symbolContrastGrade;
            this.symbolContrast = (float)symbolContrast;
            this.printGrowthGrade = printGrowthGrade;
            this.printGrowth = (float)printGrowth;
            this.axialNonuniformityGrade = axialNonuniformityGrade;
            this.axialNonuniformity = (float)axialNonuniformity;
            this.unusedErrorCorrectionGrade = unusedErrorCorrectionGrade;
            this.unusedErrorCorrection = (float)unusedErrorCorrection;
        }

        protected AIMGradeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected AIMGradeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.overallGrade = AIMGrade.fromValue(this.backing.getInt(0));
            this.decodingGrade = AIMGrade.fromValue(this.backing.getInt(4));
            this.symbolContrastGrade = AIMGrade.fromValue(this.backing.getInt(8));
            this.symbolContrast = this.backing.getFloat(12);
            this.printGrowthGrade = AIMGrade.fromValue(this.backing.getInt(16));
            this.printGrowth = this.backing.getFloat(20);
            this.axialNonuniformityGrade = AIMGrade.fromValue(this.backing.getInt(24));
            this.axialNonuniformity = this.backing.getFloat(28);
            this.unusedErrorCorrectionGrade = AIMGrade.fromValue(this.backing.getInt(32));
            this.unusedErrorCorrection = this.backing.getFloat(36);
        }

        @Override
        public void write() {
            if (this.overallGrade != null) {
                this.backing.putInt(0, this.overallGrade.getValue());
            }
            if (this.decodingGrade != null) {
                this.backing.putInt(4, this.decodingGrade.getValue());
            }
            if (this.symbolContrastGrade != null) {
                this.backing.putInt(8, this.symbolContrastGrade.getValue());
            }
            this.backing.putFloat(12, this.symbolContrast);
            if (this.printGrowthGrade != null) {
                this.backing.putInt(16, this.printGrowthGrade.getValue());
            }
            this.backing.putFloat(20, this.printGrowth);
            if (this.axialNonuniformityGrade != null) {
                this.backing.putInt(24, this.axialNonuniformityGrade.getValue());
            }
            this.backing.putFloat(28, this.axialNonuniformity);
            if (this.unusedErrorCorrectionGrade != null) {
                this.backing.putInt(32, this.unusedErrorCorrectionGrade.getValue());
            }
            this.backing.putFloat(36, this.unusedErrorCorrection);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class QRCodeReport
    extends DisposedStruct {
        public int found;
        public byte[] data;
        public PointFloat[] boundingBox;
        public QRCodeDataToken[] tokenizedData;
        public int numErrorsCorrected;
        public int dimensions;
        public int version;
        public QRModelType modelType;
        public QRStreamMode streamMode;
        public QRPolarities matrixPolarity;
        public int mirrored;
        public int positionInAppendStream;
        public int sizeOfAppendStream;
        public int firstEAN128ApplicationID;
        public int firstECIDesignator;
        public int appendStreamIdentifier;
        public int minimumEdgeStrength;
        public QRDemodulationMode demodulationMode;
        public QRCellSampleSize cellSampleSize;
        public QRCellFilterMode cellFilterMode;
        private ByteBuffer data_buf;
        private ByteBuffer tokenizedData_buf;

        private void init() {
            this.data = new byte[0];
            this.boundingBox = new PointFloat[4];
            int i = 0;
            int off = 12;
            while (i < 4) {
                this.boundingBox[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
            this.tokenizedData = new QRCodeDataToken[0];
        }

        public QRCodeReport() {
            super(136);
            this.init();
        }

        public QRCodeReport(int found, byte[] data, PointFloat[] boundingBox, QRCodeDataToken[] tokenizedData, int numErrorsCorrected, int dimensions, int version, QRModelType modelType, QRStreamMode streamMode, QRPolarities matrixPolarity, int mirrored, int positionInAppendStream, int sizeOfAppendStream, int firstEAN128ApplicationID, int firstECIDesignator, int appendStreamIdentifier, int minimumEdgeStrength, QRDemodulationMode demodulationMode, QRCellSampleSize cellSampleSize, QRCellFilterMode cellFilterMode) {
            super(136);
            this.found = found;
            this.data = data;
            this.boundingBox = boundingBox;
            this.tokenizedData = tokenizedData;
            this.numErrorsCorrected = numErrorsCorrected;
            this.dimensions = dimensions;
            this.version = version;
            this.modelType = modelType;
            this.streamMode = streamMode;
            this.matrixPolarity = matrixPolarity;
            this.mirrored = mirrored;
            this.positionInAppendStream = positionInAppendStream;
            this.sizeOfAppendStream = sizeOfAppendStream;
            this.firstEAN128ApplicationID = firstEAN128ApplicationID;
            this.firstECIDesignator = firstECIDesignator;
            this.appendStreamIdentifier = appendStreamIdentifier;
            this.minimumEdgeStrength = minimumEdgeStrength;
            this.demodulationMode = demodulationMode;
            this.cellSampleSize = cellSampleSize;
            this.cellFilterMode = cellFilterMode;
        }

        protected QRCodeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 136);
            this.init();
        }

        protected QRCodeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 136);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 136);
        }

        @Override
        public void read() {
            this.found = this.backing.getInt(0);
            int data_dataLength = this.backing.getInt(8);
            long data_addr = NIVision.getPointer(this.backing, 4);
            this.data = new byte[data_dataLength];
            if (data_dataLength > 0 && data_addr != 0L) {
                NIVision.getBytes(NIVision.newDirectByteBuffer(data_addr, data_dataLength), this.data, 0, data_dataLength);
            }
            for (PointFloat it : this.boundingBox) {
                it.read();
            }
            int tokenizedData_sizeOfTokenizedData = this.backing.getInt(48);
            long tokenizedData_addr = NIVision.getPointer(this.backing, 44);
            this.tokenizedData = new QRCodeDataToken[tokenizedData_sizeOfTokenizedData];
            if (tokenizedData_sizeOfTokenizedData > 0 && tokenizedData_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(tokenizedData_addr, tokenizedData_sizeOfTokenizedData * 16);
                int i = 0;
                int off = 0;
                while (i < tokenizedData_sizeOfTokenizedData) {
                    this.tokenizedData[i] = new QRCodeDataToken(bb, off);
                    this.tokenizedData[i].read();
                    ++i;
                    off += 16;
                }
            }
            this.numErrorsCorrected = this.backing.getInt(52);
            this.dimensions = this.backing.getInt(56);
            this.version = this.backing.getInt(60);
            this.modelType = QRModelType.fromValue(this.backing.getInt(64));
            this.streamMode = QRStreamMode.fromValue(this.backing.getInt(68));
            this.matrixPolarity = QRPolarities.fromValue(this.backing.getInt(72));
            this.mirrored = this.backing.getInt(80);
            this.positionInAppendStream = this.backing.getInt(84);
            this.sizeOfAppendStream = this.backing.getInt(88);
            this.firstEAN128ApplicationID = this.backing.getInt(92);
            this.firstECIDesignator = this.backing.getInt(96);
            this.appendStreamIdentifier = this.backing.getInt(100);
            this.minimumEdgeStrength = this.backing.getInt(104);
            this.demodulationMode = QRDemodulationMode.fromValue(this.backing.getInt(112));
            this.cellSampleSize = QRCellSampleSize.fromValue(this.backing.getInt(120));
            this.cellFilterMode = QRCellFilterMode.fromValue(this.backing.getInt(128));
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.found);
            this.data_buf = ByteBuffer.allocateDirect(this.data.length);
            NIVision.putBytes(this.data_buf, this.data, 0, this.data.length);
            this.backing.putInt(8, this.data.length);
            NIVision.putPointer(this.backing, 4, this.data_buf);
            for (PointFloat it : this.boundingBox) {
                it.write();
            }
            this.tokenizedData_buf = ByteBuffer.allocateDirect(this.tokenizedData.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.tokenizedData.length) {
                this.tokenizedData[i].setBuffer(this.tokenizedData_buf, off);
                this.tokenizedData[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(48, this.tokenizedData.length);
            NIVision.putPointer(this.backing, 44, this.tokenizedData_buf);
            this.backing.putInt(52, this.numErrorsCorrected);
            this.backing.putInt(56, this.dimensions);
            this.backing.putInt(60, this.version);
            if (this.modelType != null) {
                this.backing.putInt(64, this.modelType.getValue());
            }
            if (this.streamMode != null) {
                this.backing.putInt(68, this.streamMode.getValue());
            }
            if (this.matrixPolarity != null) {
                this.backing.putInt(72, this.matrixPolarity.getValue());
            }
            this.backing.putInt(80, this.mirrored);
            this.backing.putInt(84, this.positionInAppendStream);
            this.backing.putInt(88, this.sizeOfAppendStream);
            this.backing.putInt(92, this.firstEAN128ApplicationID);
            this.backing.putInt(96, this.firstECIDesignator);
            this.backing.putInt(100, this.appendStreamIdentifier);
            this.backing.putInt(104, this.minimumEdgeStrength);
            if (this.demodulationMode != null) {
                this.backing.putInt(112, this.demodulationMode.getValue());
            }
            if (this.cellSampleSize != null) {
                this.backing.putInt(120, this.cellSampleSize.getValue());
            }
            if (this.cellFilterMode != null) {
                this.backing.putInt(128, this.cellFilterMode.getValue());
            }
        }

        @Override
        public int size() {
            return 136;
        }
    }

    public static class QRCodeDescriptionOptions
    extends DisposedStruct {
        public QRDimensions dimensions;
        public QRPolarities polarity;
        public QRMirrorMode mirror;
        public QRModelType modelType;

        private void init() {
        }

        public QRCodeDescriptionOptions() {
            super(32);
            this.init();
        }

        public QRCodeDescriptionOptions(QRDimensions dimensions, QRPolarities polarity, QRMirrorMode mirror, QRModelType modelType) {
            super(32);
            this.dimensions = dimensions;
            this.polarity = polarity;
            this.mirror = mirror;
            this.modelType = modelType;
        }

        protected QRCodeDescriptionOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected QRCodeDescriptionOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.dimensions = QRDimensions.fromValue(this.backing.getInt(0));
            this.polarity = QRPolarities.fromValue(this.backing.getInt(8));
            this.mirror = QRMirrorMode.fromValue(this.backing.getInt(16));
            this.modelType = QRModelType.fromValue(this.backing.getInt(24));
        }

        @Override
        public void write() {
            if (this.dimensions != null) {
                this.backing.putInt(0, this.dimensions.getValue());
            }
            if (this.polarity != null) {
                this.backing.putInt(8, this.polarity.getValue());
            }
            if (this.mirror != null) {
                this.backing.putInt(16, this.mirror.getValue());
            }
            if (this.modelType != null) {
                this.backing.putInt(24, this.modelType.getValue());
            }
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class QRCodeSizeOptions
    extends DisposedStruct {
        public int minSize;
        public int maxSize;

        private void init() {
        }

        public QRCodeSizeOptions() {
            super(8);
            this.init();
        }

        public QRCodeSizeOptions(int minSize, int maxSize) {
            super(8);
            this.minSize = minSize;
            this.maxSize = maxSize;
        }

        protected QRCodeSizeOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected QRCodeSizeOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.minSize = this.backing.getInt(0);
            this.maxSize = this.backing.getInt(4);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.minSize);
            this.backing.putInt(4, this.maxSize);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class QRCodeSearchOptions
    extends DisposedStruct {
        public QRRotationMode rotationMode;
        public int skipLocation;
        public int edgeThreshold;
        public QRDemodulationMode demodulationMode;
        public QRCellSampleSize cellSampleSize;
        public QRCellFilterMode cellFilterMode;
        public int skewDegreesAllowed;

        private void init() {
        }

        public QRCodeSearchOptions() {
            super(48);
            this.init();
        }

        public QRCodeSearchOptions(QRRotationMode rotationMode, int skipLocation, int edgeThreshold, QRDemodulationMode demodulationMode, QRCellSampleSize cellSampleSize, QRCellFilterMode cellFilterMode, int skewDegreesAllowed) {
            super(48);
            this.rotationMode = rotationMode;
            this.skipLocation = skipLocation;
            this.edgeThreshold = edgeThreshold;
            this.demodulationMode = demodulationMode;
            this.cellSampleSize = cellSampleSize;
            this.cellFilterMode = cellFilterMode;
            this.skewDegreesAllowed = skewDegreesAllowed;
        }

        protected QRCodeSearchOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 48);
            this.init();
        }

        protected QRCodeSearchOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 48);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 48);
        }

        @Override
        public void read() {
            this.rotationMode = QRRotationMode.fromValue(this.backing.getInt(0));
            this.skipLocation = this.backing.getInt(4);
            this.edgeThreshold = this.backing.getInt(8);
            this.demodulationMode = QRDemodulationMode.fromValue(this.backing.getInt(16));
            this.cellSampleSize = QRCellSampleSize.fromValue(this.backing.getInt(24));
            this.cellFilterMode = QRCellFilterMode.fromValue(this.backing.getInt(32));
            this.skewDegreesAllowed = this.backing.getInt(40);
        }

        @Override
        public void write() {
            if (this.rotationMode != null) {
                this.backing.putInt(0, this.rotationMode.getValue());
            }
            this.backing.putInt(4, this.skipLocation);
            this.backing.putInt(8, this.edgeThreshold);
            if (this.demodulationMode != null) {
                this.backing.putInt(16, this.demodulationMode.getValue());
            }
            if (this.cellSampleSize != null) {
                this.backing.putInt(24, this.cellSampleSize.getValue());
            }
            if (this.cellFilterMode != null) {
                this.backing.putInt(32, this.cellFilterMode.getValue());
            }
            this.backing.putInt(40, this.skewDegreesAllowed);
        }

        @Override
        public int size() {
            return 48;
        }
    }

    public static class StraightEdge
    extends DisposedStruct {
        public LineFloat straightEdgeCoordinates;
        public LineFloat calibratedStraightEdgeCoordinates;
        public double angle;
        public double calibratedAngle;
        public double score;
        public double straightness;
        public double averageSignalToNoiseRatio;
        public int calibrationValid;
        public EdgeInfo[] usedEdges;
        private ByteBuffer usedEdges_buf;

        private void init() {
            this.straightEdgeCoordinates = new LineFloat(this.backing, 0);
            this.calibratedStraightEdgeCoordinates = new LineFloat(this.backing, 16);
            this.usedEdges = new EdgeInfo[0];
        }

        public StraightEdge() {
            super(88);
            this.init();
        }

        public StraightEdge(LineFloat straightEdgeCoordinates, LineFloat calibratedStraightEdgeCoordinates, double angle, double calibratedAngle, double score, double straightness, double averageSignalToNoiseRatio, int calibrationValid, EdgeInfo[] usedEdges) {
            super(88);
            this.straightEdgeCoordinates = straightEdgeCoordinates;
            this.calibratedStraightEdgeCoordinates = calibratedStraightEdgeCoordinates;
            this.angle = angle;
            this.calibratedAngle = calibratedAngle;
            this.score = score;
            this.straightness = straightness;
            this.averageSignalToNoiseRatio = averageSignalToNoiseRatio;
            this.calibrationValid = calibrationValid;
            this.usedEdges = usedEdges;
        }

        protected StraightEdge(ByteBuffer backing, int offset) {
            super(backing, offset, 88);
            this.init();
        }

        protected StraightEdge(long nativeObj, boolean owned) {
            super(nativeObj, owned, 88);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 88);
        }

        @Override
        public void read() {
            this.straightEdgeCoordinates.read();
            this.calibratedStraightEdgeCoordinates.read();
            this.angle = this.backing.getDouble(32);
            this.calibratedAngle = this.backing.getDouble(40);
            this.score = this.backing.getDouble(48);
            this.straightness = this.backing.getDouble(56);
            this.averageSignalToNoiseRatio = this.backing.getDouble(64);
            this.calibrationValid = this.backing.getInt(72);
            int usedEdges_numUsedEdges = this.backing.getInt(80);
            long usedEdges_addr = NIVision.getPointer(this.backing, 76);
            this.usedEdges = new EdgeInfo[usedEdges_numUsedEdges];
            if (usedEdges_numUsedEdges > 0 && usedEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(usedEdges_addr, usedEdges_numUsedEdges * 56);
                int i = 0;
                int off = 0;
                while (i < usedEdges_numUsedEdges) {
                    this.usedEdges[i] = new EdgeInfo(bb, off);
                    this.usedEdges[i].read();
                    ++i;
                    off += 56;
                }
            }
        }

        @Override
        public void write() {
            this.straightEdgeCoordinates.write();
            this.calibratedStraightEdgeCoordinates.write();
            this.backing.putDouble(32, this.angle);
            this.backing.putDouble(40, this.calibratedAngle);
            this.backing.putDouble(48, this.score);
            this.backing.putDouble(56, this.straightness);
            this.backing.putDouble(64, this.averageSignalToNoiseRatio);
            this.backing.putInt(72, this.calibrationValid);
            this.usedEdges_buf = ByteBuffer.allocateDirect(this.usedEdges.length * 56).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.usedEdges.length) {
                this.usedEdges[i].setBuffer(this.usedEdges_buf, off);
                this.usedEdges[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(80, this.usedEdges.length);
            NIVision.putPointer(this.backing, 76, this.usedEdges_buf);
        }

        @Override
        public int size() {
            return 88;
        }
    }

    public static class StraightEdgeOptions
    extends DisposedStruct {
        public int numLines;
        public StraightEdgeSearchMode searchMode;
        public double minScore;
        public double maxScore;
        public double orientation;
        public double angleRange;
        public double angleTolerance;
        public int stepSize;
        public double minSignalToNoiseRatio;
        public double minCoverage;
        public int houghIterations;

        private void init() {
        }

        public StraightEdgeOptions() {
            super(80);
            this.init();
        }

        public StraightEdgeOptions(int numLines, StraightEdgeSearchMode searchMode, double minScore, double maxScore, double orientation, double angleRange, double angleTolerance, int stepSize, double minSignalToNoiseRatio, double minCoverage, int houghIterations) {
            super(80);
            this.numLines = numLines;
            this.searchMode = searchMode;
            this.minScore = minScore;
            this.maxScore = maxScore;
            this.orientation = orientation;
            this.angleRange = angleRange;
            this.angleTolerance = angleTolerance;
            this.stepSize = stepSize;
            this.minSignalToNoiseRatio = minSignalToNoiseRatio;
            this.minCoverage = minCoverage;
            this.houghIterations = houghIterations;
        }

        protected StraightEdgeOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 80);
            this.init();
        }

        protected StraightEdgeOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 80);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 80);
        }

        @Override
        public void read() {
            this.numLines = this.backing.getInt(0);
            this.searchMode = StraightEdgeSearchMode.fromValue(this.backing.getInt(4));
            this.minScore = this.backing.getDouble(8);
            this.maxScore = this.backing.getDouble(16);
            this.orientation = this.backing.getDouble(24);
            this.angleRange = this.backing.getDouble(32);
            this.angleTolerance = this.backing.getDouble(40);
            this.stepSize = this.backing.getInt(48);
            this.minSignalToNoiseRatio = this.backing.getDouble(56);
            this.minCoverage = this.backing.getDouble(64);
            this.houghIterations = this.backing.getInt(72);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.numLines);
            if (this.searchMode != null) {
                this.backing.putInt(4, this.searchMode.getValue());
            }
            this.backing.putDouble(8, this.minScore);
            this.backing.putDouble(16, this.maxScore);
            this.backing.putDouble(24, this.orientation);
            this.backing.putDouble(32, this.angleRange);
            this.backing.putDouble(40, this.angleTolerance);
            this.backing.putInt(48, this.stepSize);
            this.backing.putDouble(56, this.minSignalToNoiseRatio);
            this.backing.putDouble(64, this.minCoverage);
            this.backing.putInt(72, this.houghIterations);
        }

        @Override
        public int size() {
            return 80;
        }
    }

    public static class StraightEdgeReport2
    extends DisposedStruct {
        public StraightEdge[] straightEdges;
        public SearchLineInfo[] searchLines;
        private ByteBuffer straightEdges_buf;
        private ByteBuffer searchLines_buf;

        private void init() {
            this.straightEdges = new StraightEdge[0];
            this.searchLines = new SearchLineInfo[0];
        }

        public StraightEdgeReport2() {
            super(16);
            this.init();
        }

        public StraightEdgeReport2(StraightEdge[] straightEdges, SearchLineInfo[] searchLines) {
            super(16);
            this.straightEdges = straightEdges;
            this.searchLines = searchLines;
        }

        protected StraightEdgeReport2(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected StraightEdgeReport2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            int straightEdges_numStraightEdges = this.backing.getInt(4);
            long straightEdges_addr = NIVision.getPointer(this.backing, 0);
            this.straightEdges = new StraightEdge[straightEdges_numStraightEdges];
            if (straightEdges_numStraightEdges > 0 && straightEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(straightEdges_addr, straightEdges_numStraightEdges * 88);
                int i = 0;
                int off = 0;
                while (i < straightEdges_numStraightEdges) {
                    this.straightEdges[i] = new StraightEdge(bb, off);
                    this.straightEdges[i].read();
                    ++i;
                    off += 88;
                }
            }
            int searchLines_numSearchLines = this.backing.getInt(12);
            long searchLines_addr = NIVision.getPointer(this.backing, 8);
            this.searchLines = new SearchLineInfo[searchLines_numSearchLines];
            if (searchLines_numSearchLines > 0 && searchLines_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(searchLines_addr, searchLines_numSearchLines * 36);
                int i = 0;
                int off = 0;
                while (i < searchLines_numSearchLines) {
                    this.searchLines[i] = new SearchLineInfo(bb, off);
                    this.searchLines[i].read();
                    ++i;
                    off += 36;
                }
            }
        }

        @Override
        public void write() {
            this.straightEdges_buf = ByteBuffer.allocateDirect(this.straightEdges.length * 88).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.straightEdges.length) {
                this.straightEdges[i].setBuffer(this.straightEdges_buf, off);
                this.straightEdges[i].write();
                ++i;
                off += 88;
            }
            this.backing.putInt(4, this.straightEdges.length);
            NIVision.putPointer(this.backing, 0, this.straightEdges_buf);
            this.searchLines_buf = ByteBuffer.allocateDirect(this.searchLines.length * 36).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.searchLines.length) {
                this.searchLines[i].setBuffer(this.searchLines_buf, off);
                this.searchLines[i].write();
                ++i;
                off += 36;
            }
            this.backing.putInt(12, this.searchLines.length);
            NIVision.putPointer(this.backing, 8, this.searchLines_buf);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ParticleFilterOptions
    extends DisposedStruct {
        public int rejectMatches;
        public int rejectBorder;
        public int connectivity8;

        private void init() {
        }

        public ParticleFilterOptions() {
            super(12);
            this.init();
        }

        public ParticleFilterOptions(int rejectMatches, int rejectBorder, int connectivity8) {
            super(12);
            this.rejectMatches = rejectMatches;
            this.rejectBorder = rejectBorder;
            this.connectivity8 = connectivity8;
        }

        protected ParticleFilterOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected ParticleFilterOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.rejectMatches = this.backing.getInt(0);
            this.rejectBorder = this.backing.getInt(4);
            this.connectivity8 = this.backing.getInt(8);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.rejectMatches);
            this.backing.putInt(4, this.rejectBorder);
            this.backing.putInt(8, this.connectivity8);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class QRCodeDataToken
    extends DisposedStruct {
        public QRStreamMode mode;
        public int modeData;
        public byte[] data;
        private ByteBuffer data_buf;

        private void init() {
            this.data = new byte[0];
        }

        public QRCodeDataToken() {
            super(16);
            this.init();
        }

        public QRCodeDataToken(QRStreamMode mode, int modeData, byte[] data) {
            super(16);
            this.mode = mode;
            this.modeData = modeData;
            this.data = data;
        }

        protected QRCodeDataToken(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected QRCodeDataToken(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.mode = QRStreamMode.fromValue(this.backing.getInt(0));
            this.modeData = this.backing.getInt(4);
            int data_dataLength = this.backing.getInt(12);
            long data_addr = NIVision.getPointer(this.backing, 8);
            this.data = new byte[data_dataLength];
            if (data_dataLength > 0 && data_addr != 0L) {
                NIVision.getBytes(NIVision.newDirectByteBuffer(data_addr, data_dataLength), this.data, 0, data_dataLength);
            }
        }

        @Override
        public void write() {
            if (this.mode != null) {
                this.backing.putInt(0, this.mode.getValue());
            }
            this.backing.putInt(4, this.modeData);
            this.data_buf = ByteBuffer.allocateDirect(this.data.length);
            NIVision.putBytes(this.data_buf, this.data, 0, this.data.length);
            this.backing.putInt(12, this.data.length);
            NIVision.putPointer(this.backing, 8, this.data_buf);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class TransformBehaviors
    extends DisposedStruct {
        public GroupBehavior ShiftBehavior;
        public GroupBehavior ScaleBehavior;
        public GroupBehavior RotateBehavior;
        public GroupBehavior SymmetryBehavior;

        private void init() {
        }

        public TransformBehaviors() {
            super(16);
            this.init();
        }

        public TransformBehaviors(GroupBehavior ShiftBehavior, GroupBehavior ScaleBehavior, GroupBehavior RotateBehavior, GroupBehavior SymmetryBehavior) {
            super(16);
            this.ShiftBehavior = ShiftBehavior;
            this.ScaleBehavior = ScaleBehavior;
            this.RotateBehavior = RotateBehavior;
            this.SymmetryBehavior = SymmetryBehavior;
        }

        protected TransformBehaviors(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected TransformBehaviors(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.ShiftBehavior = GroupBehavior.fromValue(this.backing.getInt(0));
            this.ScaleBehavior = GroupBehavior.fromValue(this.backing.getInt(4));
            this.RotateBehavior = GroupBehavior.fromValue(this.backing.getInt(8));
            this.SymmetryBehavior = GroupBehavior.fromValue(this.backing.getInt(12));
        }

        @Override
        public void write() {
            if (this.ShiftBehavior != null) {
                this.backing.putInt(0, this.ShiftBehavior.getValue());
            }
            if (this.ScaleBehavior != null) {
                this.backing.putInt(4, this.ScaleBehavior.getValue());
            }
            if (this.RotateBehavior != null) {
                this.backing.putInt(8, this.RotateBehavior.getValue());
            }
            if (this.SymmetryBehavior != null) {
                this.backing.putInt(12, this.SymmetryBehavior.getValue());
            }
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class RakeReport2
    extends DisposedStruct {
        public EdgeInfo[] firstEdges;
        public EdgeInfo[] lastEdges;
        public SearchLineInfo[] searchLines;
        private ByteBuffer firstEdges_buf;
        private ByteBuffer lastEdges_buf;
        private ByteBuffer searchLines_buf;

        private void init() {
            this.firstEdges = new EdgeInfo[0];
            this.lastEdges = new EdgeInfo[0];
            this.searchLines = new SearchLineInfo[0];
        }

        public RakeReport2() {
            super(24);
            this.init();
        }

        public RakeReport2(EdgeInfo[] firstEdges, EdgeInfo[] lastEdges, SearchLineInfo[] searchLines) {
            super(24);
            this.firstEdges = firstEdges;
            this.lastEdges = lastEdges;
            this.searchLines = searchLines;
        }

        protected RakeReport2(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected RakeReport2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            int firstEdges_numFirstEdges = this.backing.getInt(4);
            long firstEdges_addr = NIVision.getPointer(this.backing, 0);
            this.firstEdges = new EdgeInfo[firstEdges_numFirstEdges];
            if (firstEdges_numFirstEdges > 0 && firstEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(firstEdges_addr, firstEdges_numFirstEdges * 56);
                int i = 0;
                int off = 0;
                while (i < firstEdges_numFirstEdges) {
                    this.firstEdges[i] = new EdgeInfo(bb, off);
                    this.firstEdges[i].read();
                    ++i;
                    off += 56;
                }
            }
            int lastEdges_numLastEdges = this.backing.getInt(12);
            long lastEdges_addr = NIVision.getPointer(this.backing, 8);
            this.lastEdges = new EdgeInfo[lastEdges_numLastEdges];
            if (lastEdges_numLastEdges > 0 && lastEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(lastEdges_addr, lastEdges_numLastEdges * 56);
                int i = 0;
                int off = 0;
                while (i < lastEdges_numLastEdges) {
                    this.lastEdges[i] = new EdgeInfo(bb, off);
                    this.lastEdges[i].read();
                    ++i;
                    off += 56;
                }
            }
            int searchLines_numSearchLines = this.backing.getInt(20);
            long searchLines_addr = NIVision.getPointer(this.backing, 16);
            this.searchLines = new SearchLineInfo[searchLines_numSearchLines];
            if (searchLines_numSearchLines > 0 && searchLines_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(searchLines_addr, searchLines_numSearchLines * 36);
                int i = 0;
                int off = 0;
                while (i < searchLines_numSearchLines) {
                    this.searchLines[i] = new SearchLineInfo(bb, off);
                    this.searchLines[i].read();
                    ++i;
                    off += 36;
                }
            }
        }

        @Override
        public void write() {
            this.firstEdges_buf = ByteBuffer.allocateDirect(this.firstEdges.length * 56).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.firstEdges.length) {
                this.firstEdges[i].setBuffer(this.firstEdges_buf, off);
                this.firstEdges[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(4, this.firstEdges.length);
            NIVision.putPointer(this.backing, 0, this.firstEdges_buf);
            this.lastEdges_buf = ByteBuffer.allocateDirect(this.lastEdges.length * 56).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.lastEdges.length) {
                this.lastEdges[i].setBuffer(this.lastEdges_buf, off);
                this.lastEdges[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(12, this.lastEdges.length);
            NIVision.putPointer(this.backing, 8, this.lastEdges_buf);
            this.searchLines_buf = ByteBuffer.allocateDirect(this.searchLines.length * 36).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.searchLines.length) {
                this.searchLines[i].setBuffer(this.searchLines_buf, off);
                this.searchLines[i].write();
                ++i;
                off += 36;
            }
            this.backing.putInt(20, this.searchLines.length);
            NIVision.putPointer(this.backing, 16, this.searchLines_buf);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class SearchLineInfo
    extends DisposedStruct {
        public LineFloat lineCoordinates;
        public EdgeReport2 edgeReport;

        private void init() {
            this.lineCoordinates = new LineFloat(this.backing, 0);
            this.edgeReport = new EdgeReport2(this.backing, 16);
        }

        public SearchLineInfo() {
            super(36);
            this.init();
        }

        public SearchLineInfo(LineFloat lineCoordinates, EdgeReport2 edgeReport) {
            super(36);
            this.lineCoordinates = lineCoordinates;
            this.edgeReport = edgeReport;
        }

        protected SearchLineInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected SearchLineInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            this.lineCoordinates.read();
            this.edgeReport.read();
        }

        @Override
        public void write() {
            this.lineCoordinates.write();
            this.edgeReport.write();
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class EdgeInfo
    extends DisposedStruct {
        public PointFloat position;
        public PointFloat calibratedPosition;
        public double distance;
        public double calibratedDistance;
        public double magnitude;
        public double noisePeak;
        public int rising;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
            this.calibratedPosition = new PointFloat(this.backing, 8);
        }

        public EdgeInfo() {
            super(56);
            this.init();
        }

        public EdgeInfo(PointFloat position, PointFloat calibratedPosition, double distance, double calibratedDistance, double magnitude, double noisePeak, int rising) {
            super(56);
            this.position = position;
            this.calibratedPosition = calibratedPosition;
            this.distance = distance;
            this.calibratedDistance = calibratedDistance;
            this.magnitude = magnitude;
            this.noisePeak = noisePeak;
            this.rising = rising;
        }

        protected EdgeInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected EdgeInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            this.position.read();
            this.calibratedPosition.read();
            this.distance = this.backing.getDouble(16);
            this.calibratedDistance = this.backing.getDouble(24);
            this.magnitude = this.backing.getDouble(32);
            this.noisePeak = this.backing.getDouble(40);
            this.rising = this.backing.getInt(48);
        }

        @Override
        public void write() {
            this.position.write();
            this.calibratedPosition.write();
            this.backing.putDouble(16, this.distance);
            this.backing.putDouble(24, this.calibratedDistance);
            this.backing.putDouble(32, this.magnitude);
            this.backing.putDouble(40, this.noisePeak);
            this.backing.putInt(48, this.rising);
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class SpokeReport2
    extends DisposedStruct {
        public EdgeInfo[] firstEdges;
        public EdgeInfo[] lastEdges;
        public SearchLineInfo[] searchLines;
        private ByteBuffer firstEdges_buf;
        private ByteBuffer lastEdges_buf;
        private ByteBuffer searchLines_buf;

        private void init() {
            this.firstEdges = new EdgeInfo[0];
            this.lastEdges = new EdgeInfo[0];
            this.searchLines = new SearchLineInfo[0];
        }

        public SpokeReport2() {
            super(24);
            this.init();
        }

        public SpokeReport2(EdgeInfo[] firstEdges, EdgeInfo[] lastEdges, SearchLineInfo[] searchLines) {
            super(24);
            this.firstEdges = firstEdges;
            this.lastEdges = lastEdges;
            this.searchLines = searchLines;
        }

        protected SpokeReport2(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected SpokeReport2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            int firstEdges_numFirstEdges = this.backing.getInt(4);
            long firstEdges_addr = NIVision.getPointer(this.backing, 0);
            this.firstEdges = new EdgeInfo[firstEdges_numFirstEdges];
            if (firstEdges_numFirstEdges > 0 && firstEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(firstEdges_addr, firstEdges_numFirstEdges * 56);
                int i = 0;
                int off = 0;
                while (i < firstEdges_numFirstEdges) {
                    this.firstEdges[i] = new EdgeInfo(bb, off);
                    this.firstEdges[i].read();
                    ++i;
                    off += 56;
                }
            }
            int lastEdges_numLastEdges = this.backing.getInt(12);
            long lastEdges_addr = NIVision.getPointer(this.backing, 8);
            this.lastEdges = new EdgeInfo[lastEdges_numLastEdges];
            if (lastEdges_numLastEdges > 0 && lastEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(lastEdges_addr, lastEdges_numLastEdges * 56);
                int i = 0;
                int off = 0;
                while (i < lastEdges_numLastEdges) {
                    this.lastEdges[i] = new EdgeInfo(bb, off);
                    this.lastEdges[i].read();
                    ++i;
                    off += 56;
                }
            }
            int searchLines_numSearchLines = this.backing.getInt(20);
            long searchLines_addr = NIVision.getPointer(this.backing, 16);
            this.searchLines = new SearchLineInfo[searchLines_numSearchLines];
            if (searchLines_numSearchLines > 0 && searchLines_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(searchLines_addr, searchLines_numSearchLines * 36);
                int i = 0;
                int off = 0;
                while (i < searchLines_numSearchLines) {
                    this.searchLines[i] = new SearchLineInfo(bb, off);
                    this.searchLines[i].read();
                    ++i;
                    off += 36;
                }
            }
        }

        @Override
        public void write() {
            this.firstEdges_buf = ByteBuffer.allocateDirect(this.firstEdges.length * 56).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.firstEdges.length) {
                this.firstEdges[i].setBuffer(this.firstEdges_buf, off);
                this.firstEdges[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(4, this.firstEdges.length);
            NIVision.putPointer(this.backing, 0, this.firstEdges_buf);
            this.lastEdges_buf = ByteBuffer.allocateDirect(this.lastEdges.length * 56).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.lastEdges.length) {
                this.lastEdges[i].setBuffer(this.lastEdges_buf, off);
                this.lastEdges[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(12, this.lastEdges.length);
            NIVision.putPointer(this.backing, 8, this.lastEdges_buf);
            this.searchLines_buf = ByteBuffer.allocateDirect(this.searchLines.length * 36).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.searchLines.length) {
                this.searchLines[i].setBuffer(this.searchLines_buf, off);
                this.searchLines[i].write();
                ++i;
                off += 36;
            }
            this.backing.putInt(20, this.searchLines.length);
            NIVision.putPointer(this.backing, 16, this.searchLines_buf);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class ConcentricRakeReport2
    extends DisposedStruct {
        public EdgeInfo[] firstEdges;
        public EdgeInfo[] lastEdges;
        public SearchArcInfo[] searchArcs;
        private ByteBuffer firstEdges_buf;
        private ByteBuffer lastEdges_buf;
        private ByteBuffer searchArcs_buf;

        private void init() {
            this.firstEdges = new EdgeInfo[0];
            this.lastEdges = new EdgeInfo[0];
            this.searchArcs = new SearchArcInfo[0];
        }

        public ConcentricRakeReport2() {
            super(24);
            this.init();
        }

        public ConcentricRakeReport2(EdgeInfo[] firstEdges, EdgeInfo[] lastEdges, SearchArcInfo[] searchArcs) {
            super(24);
            this.firstEdges = firstEdges;
            this.lastEdges = lastEdges;
            this.searchArcs = searchArcs;
        }

        protected ConcentricRakeReport2(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected ConcentricRakeReport2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            int firstEdges_numFirstEdges = this.backing.getInt(4);
            long firstEdges_addr = NIVision.getPointer(this.backing, 0);
            this.firstEdges = new EdgeInfo[firstEdges_numFirstEdges];
            if (firstEdges_numFirstEdges > 0 && firstEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(firstEdges_addr, firstEdges_numFirstEdges * 56);
                int i = 0;
                int off = 0;
                while (i < firstEdges_numFirstEdges) {
                    this.firstEdges[i] = new EdgeInfo(bb, off);
                    this.firstEdges[i].read();
                    ++i;
                    off += 56;
                }
            }
            int lastEdges_numLastEdges = this.backing.getInt(12);
            long lastEdges_addr = NIVision.getPointer(this.backing, 8);
            this.lastEdges = new EdgeInfo[lastEdges_numLastEdges];
            if (lastEdges_numLastEdges > 0 && lastEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(lastEdges_addr, lastEdges_numLastEdges * 56);
                int i = 0;
                int off = 0;
                while (i < lastEdges_numLastEdges) {
                    this.lastEdges[i] = new EdgeInfo(bb, off);
                    this.lastEdges[i].read();
                    ++i;
                    off += 56;
                }
            }
            int searchArcs_numSearchArcs = this.backing.getInt(20);
            long searchArcs_addr = NIVision.getPointer(this.backing, 16);
            this.searchArcs = new SearchArcInfo[searchArcs_numSearchArcs];
            if (searchArcs_numSearchArcs > 0 && searchArcs_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(searchArcs_addr, searchArcs_numSearchArcs * 56);
                int i = 0;
                int off = 0;
                while (i < searchArcs_numSearchArcs) {
                    this.searchArcs[i] = new SearchArcInfo(bb, off);
                    this.searchArcs[i].read();
                    ++i;
                    off += 56;
                }
            }
        }

        @Override
        public void write() {
            this.firstEdges_buf = ByteBuffer.allocateDirect(this.firstEdges.length * 56).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.firstEdges.length) {
                this.firstEdges[i].setBuffer(this.firstEdges_buf, off);
                this.firstEdges[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(4, this.firstEdges.length);
            NIVision.putPointer(this.backing, 0, this.firstEdges_buf);
            this.lastEdges_buf = ByteBuffer.allocateDirect(this.lastEdges.length * 56).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.lastEdges.length) {
                this.lastEdges[i].setBuffer(this.lastEdges_buf, off);
                this.lastEdges[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(12, this.lastEdges.length);
            NIVision.putPointer(this.backing, 8, this.lastEdges_buf);
            this.searchArcs_buf = ByteBuffer.allocateDirect(this.searchArcs.length * 56).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.searchArcs.length) {
                this.searchArcs[i].setBuffer(this.searchArcs_buf, off);
                this.searchArcs[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(20, this.searchArcs.length);
            NIVision.putPointer(this.backing, 16, this.searchArcs_buf);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class SearchArcInfo
    extends DisposedStruct {
        public ArcInfo2 arcCoordinates;
        public EdgeReport2 edgeReport;

        private void init() {
            this.arcCoordinates = new ArcInfo2(this.backing, 0);
            this.edgeReport = new EdgeReport2(this.backing, 32);
        }

        public SearchArcInfo() {
            super(56);
            this.init();
        }

        public SearchArcInfo(ArcInfo2 arcCoordinates, EdgeReport2 edgeReport) {
            super(56);
            this.arcCoordinates = arcCoordinates;
            this.edgeReport = edgeReport;
        }

        protected SearchArcInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected SearchArcInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            this.arcCoordinates.read();
            this.edgeReport.read();
        }

        @Override
        public void write() {
            this.arcCoordinates.write();
            this.edgeReport.write();
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class EdgeReport2
    extends DisposedStruct {
        public EdgeInfo[] edges;
        public double[] gradientInfo;
        public int calibrationValid;
        private ByteBuffer edges_buf;
        private ByteBuffer gradientInfo_buf;

        private void init() {
            this.edges = new EdgeInfo[0];
            this.gradientInfo = new double[0];
        }

        public EdgeReport2() {
            super(20);
            this.init();
        }

        public EdgeReport2(EdgeInfo[] edges, double[] gradientInfo, int calibrationValid) {
            super(20);
            this.edges = edges;
            this.gradientInfo = gradientInfo;
            this.calibrationValid = calibrationValid;
        }

        protected EdgeReport2(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected EdgeReport2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            int edges_numEdges = this.backing.getInt(4);
            long edges_addr = NIVision.getPointer(this.backing, 0);
            this.edges = new EdgeInfo[edges_numEdges];
            if (edges_numEdges > 0 && edges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(edges_addr, edges_numEdges * 56);
                int i = 0;
                int off = 0;
                while (i < edges_numEdges) {
                    this.edges[i] = new EdgeInfo(bb, off);
                    this.edges[i].read();
                    ++i;
                    off += 56;
                }
            }
            int gradientInfo_numGradientInfo = this.backing.getInt(12);
            long gradientInfo_addr = NIVision.getPointer(this.backing, 8);
            this.gradientInfo = new double[gradientInfo_numGradientInfo];
            if (gradientInfo_numGradientInfo > 0 && gradientInfo_addr != 0L) {
                NIVision.newDirectByteBuffer(gradientInfo_addr, gradientInfo_numGradientInfo * 8).asDoubleBuffer().get(this.gradientInfo);
            }
            this.calibrationValid = this.backing.getInt(16);
        }

        @Override
        public void write() {
            this.edges_buf = ByteBuffer.allocateDirect(this.edges.length * 56).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.edges.length) {
                this.edges[i].setBuffer(this.edges_buf, off);
                this.edges[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(4, this.edges.length);
            NIVision.putPointer(this.backing, 0, this.edges_buf);
            this.gradientInfo_buf = ByteBuffer.allocateDirect(this.gradientInfo.length * 8).order(ByteOrder.nativeOrder());
            this.gradientInfo_buf.asDoubleBuffer().put(this.gradientInfo).rewind();
            this.backing.putInt(12, this.gradientInfo.length);
            NIVision.putPointer(this.backing, 8, this.gradientInfo_buf);
            this.backing.putInt(16, this.calibrationValid);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class ArcInfo2
    extends DisposedStruct {
        public PointFloat center;
        public double radius;
        public double startAngle;
        public double endAngle;

        private void init() {
            this.center = new PointFloat(this.backing, 0);
        }

        public ArcInfo2() {
            super(32);
            this.init();
        }

        public ArcInfo2(PointFloat center, double radius, double startAngle, double endAngle) {
            super(32);
            this.center = center;
            this.radius = radius;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        protected ArcInfo2(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected ArcInfo2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.center.read();
            this.radius = this.backing.getDouble(8);
            this.startAngle = this.backing.getDouble(16);
            this.endAngle = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.center.write();
            this.backing.putDouble(8, this.radius);
            this.backing.putDouble(16, this.startAngle);
            this.backing.putDouble(24, this.endAngle);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class CharReport3
    extends DisposedStruct {
        public String character;
        public int classificationScore;
        public int verificationScore;
        public int verified;
        public int lowThreshold;
        public int highThreshold;
        public CharacterStatistics characterStats;
        private ByteBuffer character_buf;

        private void init() {
            this.characterStats = new CharacterStatistics(this.backing, 24);
        }

        public CharReport3() {
            super(44);
            this.init();
        }

        public CharReport3(String character, int classificationScore, int verificationScore, int verified, int lowThreshold, int highThreshold, CharacterStatistics characterStats) {
            super(44);
            this.character = character;
            this.classificationScore = classificationScore;
            this.verificationScore = verificationScore;
            this.verified = verified;
            this.lowThreshold = lowThreshold;
            this.highThreshold = highThreshold;
            this.characterStats = characterStats;
        }

        protected CharReport3(ByteBuffer backing, int offset) {
            super(backing, offset, 44);
            this.init();
        }

        protected CharReport3(long nativeObj, boolean owned) {
            super(nativeObj, owned, 44);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 44);
        }

        @Override
        public void read() {
            long character_addr = NIVision.getPointer(this.backing, 0);
            if (character_addr == 0L) {
                this.character = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(character_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.character = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.character = "";
                }
            }
            this.classificationScore = this.backing.getInt(4);
            this.verificationScore = this.backing.getInt(8);
            this.verified = this.backing.getInt(12);
            this.lowThreshold = this.backing.getInt(16);
            this.highThreshold = this.backing.getInt(20);
            this.characterStats.read();
        }

        @Override
        public void write() {
            if (this.character != null) {
                byte[] character_bytes;
                try {
                    character_bytes = this.character.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    character_bytes = new byte[]{};
                }
                this.character_buf = ByteBuffer.allocateDirect(character_bytes.length + 1);
                NIVision.putBytes(this.character_buf, character_bytes, 0, character_bytes.length).put(character_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.character == null ? 0L : NIVision.getByteBufferAddress(this.character_buf));
            this.backing.putInt(4, this.classificationScore);
            this.backing.putInt(8, this.verificationScore);
            this.backing.putInt(12, this.verified);
            this.backing.putInt(16, this.lowThreshold);
            this.backing.putInt(20, this.highThreshold);
            this.characterStats.write();
        }

        @Override
        public int size() {
            return 44;
        }
    }

    public static class CharacterStatistics
    extends DisposedStruct {
        public int left;
        public int top;
        public int width;
        public int height;
        public int characterSize;

        private void init() {
        }

        public CharacterStatistics() {
            super(20);
            this.init();
        }

        public CharacterStatistics(int left, int top, int width, int height, int characterSize) {
            super(20);
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.characterSize = characterSize;
        }

        protected CharacterStatistics(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected CharacterStatistics(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.left = this.backing.getInt(0);
            this.top = this.backing.getInt(4);
            this.width = this.backing.getInt(8);
            this.height = this.backing.getInt(12);
            this.characterSize = this.backing.getInt(16);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.left);
            this.backing.putInt(4, this.top);
            this.backing.putInt(8, this.width);
            this.backing.putInt(12, this.height);
            this.backing.putInt(16, this.characterSize);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class ReadTextReport3
    extends DisposedStruct {
        public String readString;
        public CharReport3[] characterReport;
        public ROI roiBoundingCharacters;
        private ByteBuffer readString_buf;
        private ByteBuffer characterReport_buf;

        private void init() {
            this.characterReport = new CharReport3[0];
        }

        public ReadTextReport3() {
            super(16);
            this.init();
        }

        public ReadTextReport3(String readString, CharReport3[] characterReport, ROI roiBoundingCharacters) {
            super(16);
            this.readString = readString;
            this.characterReport = characterReport;
            this.roiBoundingCharacters = roiBoundingCharacters;
        }

        protected ReadTextReport3(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ReadTextReport3(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            long roiBoundingCharacters_addr;
            long readString_addr = NIVision.getPointer(this.backing, 0);
            if (readString_addr == 0L) {
                this.readString = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(readString_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.readString = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.readString = "";
                }
            }
            int characterReport_numCharacterReports = this.backing.getInt(8);
            long characterReport_addr = NIVision.getPointer(this.backing, 4);
            this.characterReport = new CharReport3[characterReport_numCharacterReports];
            if (characterReport_numCharacterReports > 0 && characterReport_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(characterReport_addr, characterReport_numCharacterReports * 44);
                int i = 0;
                int off = 0;
                while (i < characterReport_numCharacterReports) {
                    this.characterReport[i] = new CharReport3(bb, off);
                    this.characterReport[i].read();
                    ++i;
                    off += 44;
                }
            }
            this.roiBoundingCharacters = (roiBoundingCharacters_addr = NIVision.getPointer(this.backing, 12)) == 0L ? null : new ROI(roiBoundingCharacters_addr, false);
        }

        @Override
        public void write() {
            if (this.readString != null) {
                byte[] readString_bytes;
                try {
                    readString_bytes = this.readString.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    readString_bytes = new byte[]{};
                }
                this.readString_buf = ByteBuffer.allocateDirect(readString_bytes.length + 1);
                NIVision.putBytes(this.readString_buf, readString_bytes, 0, readString_bytes.length).put(readString_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.readString == null ? 0L : NIVision.getByteBufferAddress(this.readString_buf));
            this.characterReport_buf = ByteBuffer.allocateDirect(this.characterReport.length * 44).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.characterReport.length) {
                this.characterReport[i].setBuffer(this.characterReport_buf, off);
                this.characterReport[i].write();
                ++i;
                off += 44;
            }
            this.backing.putInt(8, this.characterReport.length);
            NIVision.putPointer(this.backing, 4, this.characterReport_buf);
            NIVision.putPointer(this.backing, 12, this.roiBoundingCharacters);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class FindTransformRectsOptions2
    extends DisposedStruct {
        public FindReferenceDirection direction;
        public int showSearchArea;
        public int showSearchLines;
        public int showEdgesFound;
        public int showResult;
        public RGBValue searchAreaColor;
        public RGBValue searchLinesColor;
        public RGBValue searchEdgesColor;
        public RGBValue resultColor;
        public String overlayGroupName;
        public EdgeOptions2 primaryEdgeOptions;
        public EdgeOptions2 secondaryEdgeOptions;
        private ByteBuffer overlayGroupName_buf;

        private void init() {
            this.searchAreaColor = new RGBValue(this.backing, 20);
            this.searchLinesColor = new RGBValue(this.backing, 24);
            this.searchEdgesColor = new RGBValue(this.backing, 28);
            this.resultColor = new RGBValue(this.backing, 32);
            this.primaryEdgeOptions = new EdgeOptions2(this.backing, 40);
            this.secondaryEdgeOptions = new EdgeOptions2(this.backing, 64);
        }

        public FindTransformRectsOptions2() {
            super(88);
            this.init();
        }

        public FindTransformRectsOptions2(FindReferenceDirection direction, int showSearchArea, int showSearchLines, int showEdgesFound, int showResult, RGBValue searchAreaColor, RGBValue searchLinesColor, RGBValue searchEdgesColor, RGBValue resultColor, String overlayGroupName, EdgeOptions2 primaryEdgeOptions, EdgeOptions2 secondaryEdgeOptions) {
            super(88);
            this.direction = direction;
            this.showSearchArea = showSearchArea;
            this.showSearchLines = showSearchLines;
            this.showEdgesFound = showEdgesFound;
            this.showResult = showResult;
            this.searchAreaColor = searchAreaColor;
            this.searchLinesColor = searchLinesColor;
            this.searchEdgesColor = searchEdgesColor;
            this.resultColor = resultColor;
            this.overlayGroupName = overlayGroupName;
            this.primaryEdgeOptions = primaryEdgeOptions;
            this.secondaryEdgeOptions = secondaryEdgeOptions;
        }

        protected FindTransformRectsOptions2(ByteBuffer backing, int offset) {
            super(backing, offset, 88);
            this.init();
        }

        protected FindTransformRectsOptions2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 88);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 88);
        }

        @Override
        public void read() {
            this.direction = FindReferenceDirection.fromValue(this.backing.getInt(0));
            this.showSearchArea = this.backing.getInt(4);
            this.showSearchLines = this.backing.getInt(8);
            this.showEdgesFound = this.backing.getInt(12);
            this.showResult = this.backing.getInt(16);
            this.searchAreaColor.read();
            this.searchLinesColor.read();
            this.searchEdgesColor.read();
            this.resultColor.read();
            long overlayGroupName_addr = NIVision.getPointer(this.backing, 36);
            if (overlayGroupName_addr == 0L) {
                this.overlayGroupName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(overlayGroupName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.overlayGroupName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.overlayGroupName = "";
                }
            }
            this.primaryEdgeOptions.read();
            this.secondaryEdgeOptions.read();
        }

        @Override
        public void write() {
            if (this.direction != null) {
                this.backing.putInt(0, this.direction.getValue());
            }
            this.backing.putInt(4, this.showSearchArea);
            this.backing.putInt(8, this.showSearchLines);
            this.backing.putInt(12, this.showEdgesFound);
            this.backing.putInt(16, this.showResult);
            this.searchAreaColor.write();
            this.searchLinesColor.write();
            this.searchEdgesColor.write();
            this.resultColor.write();
            if (this.overlayGroupName != null) {
                byte[] overlayGroupName_bytes;
                try {
                    overlayGroupName_bytes = this.overlayGroupName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    overlayGroupName_bytes = new byte[]{};
                }
                this.overlayGroupName_buf = ByteBuffer.allocateDirect(overlayGroupName_bytes.length + 1);
                NIVision.putBytes(this.overlayGroupName_buf, overlayGroupName_bytes, 0, overlayGroupName_bytes.length).put(overlayGroupName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 36, this.overlayGroupName == null ? 0L : NIVision.getByteBufferAddress(this.overlayGroupName_buf));
            this.primaryEdgeOptions.write();
            this.secondaryEdgeOptions.write();
        }

        @Override
        public int size() {
            return 88;
        }
    }

    public static class FindTransformRectOptions2
    extends DisposedStruct {
        public FindReferenceDirection direction;
        public int showSearchArea;
        public int showSearchLines;
        public int showEdgesFound;
        public int showResult;
        public RGBValue searchAreaColor;
        public RGBValue searchLinesColor;
        public RGBValue searchEdgesColor;
        public RGBValue resultColor;
        public String overlayGroupName;
        public EdgeOptions2 edgeOptions;
        private ByteBuffer overlayGroupName_buf;

        private void init() {
            this.searchAreaColor = new RGBValue(this.backing, 20);
            this.searchLinesColor = new RGBValue(this.backing, 24);
            this.searchEdgesColor = new RGBValue(this.backing, 28);
            this.resultColor = new RGBValue(this.backing, 32);
            this.edgeOptions = new EdgeOptions2(this.backing, 40);
        }

        public FindTransformRectOptions2() {
            super(64);
            this.init();
        }

        public FindTransformRectOptions2(FindReferenceDirection direction, int showSearchArea, int showSearchLines, int showEdgesFound, int showResult, RGBValue searchAreaColor, RGBValue searchLinesColor, RGBValue searchEdgesColor, RGBValue resultColor, String overlayGroupName, EdgeOptions2 edgeOptions) {
            super(64);
            this.direction = direction;
            this.showSearchArea = showSearchArea;
            this.showSearchLines = showSearchLines;
            this.showEdgesFound = showEdgesFound;
            this.showResult = showResult;
            this.searchAreaColor = searchAreaColor;
            this.searchLinesColor = searchLinesColor;
            this.searchEdgesColor = searchEdgesColor;
            this.resultColor = resultColor;
            this.overlayGroupName = overlayGroupName;
            this.edgeOptions = edgeOptions;
        }

        protected FindTransformRectOptions2(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected FindTransformRectOptions2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.direction = FindReferenceDirection.fromValue(this.backing.getInt(0));
            this.showSearchArea = this.backing.getInt(4);
            this.showSearchLines = this.backing.getInt(8);
            this.showEdgesFound = this.backing.getInt(12);
            this.showResult = this.backing.getInt(16);
            this.searchAreaColor.read();
            this.searchLinesColor.read();
            this.searchEdgesColor.read();
            this.resultColor.read();
            long overlayGroupName_addr = NIVision.getPointer(this.backing, 36);
            if (overlayGroupName_addr == 0L) {
                this.overlayGroupName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(overlayGroupName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.overlayGroupName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.overlayGroupName = "";
                }
            }
            this.edgeOptions.read();
        }

        @Override
        public void write() {
            if (this.direction != null) {
                this.backing.putInt(0, this.direction.getValue());
            }
            this.backing.putInt(4, this.showSearchArea);
            this.backing.putInt(8, this.showSearchLines);
            this.backing.putInt(12, this.showEdgesFound);
            this.backing.putInt(16, this.showResult);
            this.searchAreaColor.write();
            this.searchLinesColor.write();
            this.searchEdgesColor.write();
            this.resultColor.write();
            if (this.overlayGroupName != null) {
                byte[] overlayGroupName_bytes;
                try {
                    overlayGroupName_bytes = this.overlayGroupName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    overlayGroupName_bytes = new byte[]{};
                }
                this.overlayGroupName_buf = ByteBuffer.allocateDirect(overlayGroupName_bytes.length + 1);
                NIVision.putBytes(this.overlayGroupName_buf, overlayGroupName_bytes, 0, overlayGroupName_bytes.length).put(overlayGroupName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 36, this.overlayGroupName == null ? 0L : NIVision.getByteBufferAddress(this.overlayGroupName_buf));
            this.edgeOptions.write();
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class FindEdgeReport
    extends DisposedStruct {
        public StraightEdge[] straightEdges;
        private ByteBuffer straightEdges_buf;

        private void init() {
            this.straightEdges = new StraightEdge[0];
        }

        public FindEdgeReport() {
            super(8);
            this.init();
        }

        public FindEdgeReport(StraightEdge[] straightEdges) {
            super(8);
            this.straightEdges = straightEdges;
        }

        protected FindEdgeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected FindEdgeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            int straightEdges_numStraightEdges = this.backing.getInt(4);
            long straightEdges_addr = NIVision.getPointer(this.backing, 0);
            this.straightEdges = new StraightEdge[straightEdges_numStraightEdges];
            if (straightEdges_numStraightEdges > 0 && straightEdges_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(straightEdges_addr, straightEdges_numStraightEdges * 88);
                int i = 0;
                int off = 0;
                while (i < straightEdges_numStraightEdges) {
                    this.straightEdges[i] = new StraightEdge(bb, off);
                    this.straightEdges[i].read();
                    ++i;
                    off += 88;
                }
            }
        }

        @Override
        public void write() {
            this.straightEdges_buf = ByteBuffer.allocateDirect(this.straightEdges.length * 88).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.straightEdges.length) {
                this.straightEdges[i].setBuffer(this.straightEdges_buf, off);
                this.straightEdges[i].write();
                ++i;
                off += 88;
            }
            this.backing.putInt(4, this.straightEdges.length);
            NIVision.putPointer(this.backing, 0, this.straightEdges_buf);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class FindEdgeOptions2
    extends DisposedStruct {
        public RakeDirection direction;
        public int showSearchArea;
        public int showSearchLines;
        public int showEdgesFound;
        public int showResult;
        public RGBValue searchAreaColor;
        public RGBValue searchLinesColor;
        public RGBValue searchEdgesColor;
        public RGBValue resultColor;
        public String overlayGroupName;
        public EdgeOptions2 edgeOptions;
        private ByteBuffer overlayGroupName_buf;

        private void init() {
            this.searchAreaColor = new RGBValue(this.backing, 20);
            this.searchLinesColor = new RGBValue(this.backing, 24);
            this.searchEdgesColor = new RGBValue(this.backing, 28);
            this.resultColor = new RGBValue(this.backing, 32);
            this.edgeOptions = new EdgeOptions2(this.backing, 40);
        }

        public FindEdgeOptions2() {
            super(64);
            this.init();
        }

        public FindEdgeOptions2(RakeDirection direction, int showSearchArea, int showSearchLines, int showEdgesFound, int showResult, RGBValue searchAreaColor, RGBValue searchLinesColor, RGBValue searchEdgesColor, RGBValue resultColor, String overlayGroupName, EdgeOptions2 edgeOptions) {
            super(64);
            this.direction = direction;
            this.showSearchArea = showSearchArea;
            this.showSearchLines = showSearchLines;
            this.showEdgesFound = showEdgesFound;
            this.showResult = showResult;
            this.searchAreaColor = searchAreaColor;
            this.searchLinesColor = searchLinesColor;
            this.searchEdgesColor = searchEdgesColor;
            this.resultColor = resultColor;
            this.overlayGroupName = overlayGroupName;
            this.edgeOptions = edgeOptions;
        }

        protected FindEdgeOptions2(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected FindEdgeOptions2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.direction = RakeDirection.fromValue(this.backing.getInt(0));
            this.showSearchArea = this.backing.getInt(4);
            this.showSearchLines = this.backing.getInt(8);
            this.showEdgesFound = this.backing.getInt(12);
            this.showResult = this.backing.getInt(16);
            this.searchAreaColor.read();
            this.searchLinesColor.read();
            this.searchEdgesColor.read();
            this.resultColor.read();
            long overlayGroupName_addr = NIVision.getPointer(this.backing, 36);
            if (overlayGroupName_addr == 0L) {
                this.overlayGroupName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(overlayGroupName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.overlayGroupName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.overlayGroupName = "";
                }
            }
            this.edgeOptions.read();
        }

        @Override
        public void write() {
            if (this.direction != null) {
                this.backing.putInt(0, this.direction.getValue());
            }
            this.backing.putInt(4, this.showSearchArea);
            this.backing.putInt(8, this.showSearchLines);
            this.backing.putInt(12, this.showEdgesFound);
            this.backing.putInt(16, this.showResult);
            this.searchAreaColor.write();
            this.searchLinesColor.write();
            this.searchEdgesColor.write();
            this.resultColor.write();
            if (this.overlayGroupName != null) {
                byte[] overlayGroupName_bytes;
                try {
                    overlayGroupName_bytes = this.overlayGroupName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    overlayGroupName_bytes = new byte[]{};
                }
                this.overlayGroupName_buf = ByteBuffer.allocateDirect(overlayGroupName_bytes.length + 1);
                NIVision.putBytes(this.overlayGroupName_buf, overlayGroupName_bytes, 0, overlayGroupName_bytes.length).put(overlayGroupName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 36, this.overlayGroupName == null ? 0L : NIVision.getByteBufferAddress(this.overlayGroupName_buf));
            this.edgeOptions.write();
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class ParticleFilterOptions2
    extends DisposedStruct {
        public int rejectMatches;
        public int rejectBorder;
        public int fillHoles;
        public int connectivity8;

        private void init() {
        }

        public ParticleFilterOptions2() {
            super(16);
            this.init();
        }

        public ParticleFilterOptions2(int rejectMatches, int rejectBorder, int fillHoles, int connectivity8) {
            super(16);
            this.rejectMatches = rejectMatches;
            this.rejectBorder = rejectBorder;
            this.fillHoles = fillHoles;
            this.connectivity8 = connectivity8;
        }

        protected ParticleFilterOptions2(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ParticleFilterOptions2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.rejectMatches = this.backing.getInt(0);
            this.rejectBorder = this.backing.getInt(4);
            this.fillHoles = this.backing.getInt(8);
            this.connectivity8 = this.backing.getInt(12);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.rejectMatches);
            this.backing.putInt(4, this.rejectBorder);
            this.backing.putInt(8, this.fillHoles);
            this.backing.putInt(12, this.connectivity8);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class LearnGeometricPatternAdvancedOptions2
    extends DisposedStruct {
        public double minScaleFactor;
        public double maxScaleFactor;
        public double minRotationAngleValue;
        public double maxRotationAngleValue;
        public int imageSamplingFactor;

        private void init() {
        }

        public LearnGeometricPatternAdvancedOptions2() {
            super(40);
            this.init();
        }

        public LearnGeometricPatternAdvancedOptions2(double minScaleFactor, double maxScaleFactor, double minRotationAngleValue, double maxRotationAngleValue, int imageSamplingFactor) {
            super(40);
            this.minScaleFactor = minScaleFactor;
            this.maxScaleFactor = maxScaleFactor;
            this.minRotationAngleValue = minRotationAngleValue;
            this.maxRotationAngleValue = maxRotationAngleValue;
            this.imageSamplingFactor = imageSamplingFactor;
        }

        protected LearnGeometricPatternAdvancedOptions2(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected LearnGeometricPatternAdvancedOptions2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.minScaleFactor = this.backing.getDouble(0);
            this.maxScaleFactor = this.backing.getDouble(8);
            this.minRotationAngleValue = this.backing.getDouble(16);
            this.maxRotationAngleValue = this.backing.getDouble(24);
            this.imageSamplingFactor = this.backing.getInt(32);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.minScaleFactor);
            this.backing.putDouble(8, this.maxScaleFactor);
            this.backing.putDouble(16, this.minRotationAngleValue);
            this.backing.putDouble(24, this.maxRotationAngleValue);
            this.backing.putInt(32, this.imageSamplingFactor);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class ClassifierReportAdvanced
    extends DisposedStruct {
        public String bestClassName;
        public float classificationScore;
        public float identificationScore;
        public ClassScore[] allScores;
        public SampleScore[] sampleScores;
        private ByteBuffer bestClassName_buf;
        private ByteBuffer allScores_buf;
        private ByteBuffer sampleScores_buf;

        private void init() {
            this.allScores = new ClassScore[0];
            this.sampleScores = new SampleScore[0];
        }

        public ClassifierReportAdvanced() {
            super(28);
            this.init();
        }

        public ClassifierReportAdvanced(String bestClassName, double classificationScore, double identificationScore, ClassScore[] allScores, SampleScore[] sampleScores) {
            super(28);
            this.bestClassName = bestClassName;
            this.classificationScore = (float)classificationScore;
            this.identificationScore = (float)identificationScore;
            this.allScores = allScores;
            this.sampleScores = sampleScores;
        }

        protected ClassifierReportAdvanced(ByteBuffer backing, int offset) {
            super(backing, offset, 28);
            this.init();
        }

        protected ClassifierReportAdvanced(long nativeObj, boolean owned) {
            super(nativeObj, owned, 28);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 28);
        }

        @Override
        public void read() {
            long bestClassName_addr = NIVision.getPointer(this.backing, 0);
            if (bestClassName_addr == 0L) {
                this.bestClassName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(bestClassName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.bestClassName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.bestClassName = "";
                }
            }
            this.classificationScore = this.backing.getFloat(4);
            this.identificationScore = this.backing.getFloat(8);
            int allScores_allScoresSize = this.backing.getInt(16);
            long allScores_addr = NIVision.getPointer(this.backing, 12);
            this.allScores = new ClassScore[allScores_allScoresSize];
            if (allScores_allScoresSize > 0 && allScores_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(allScores_addr, allScores_allScoresSize * 8);
                int i = 0;
                int off = 0;
                while (i < allScores_allScoresSize) {
                    this.allScores[i] = new ClassScore(bb, off);
                    this.allScores[i].read();
                    ++i;
                    off += 8;
                }
            }
            int sampleScores_sampleScoresSize = this.backing.getInt(24);
            long sampleScores_addr = NIVision.getPointer(this.backing, 20);
            this.sampleScores = new SampleScore[sampleScores_sampleScoresSize];
            if (sampleScores_sampleScoresSize > 0 && sampleScores_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(sampleScores_addr, sampleScores_sampleScoresSize * 12);
                int i = 0;
                int off = 0;
                while (i < sampleScores_sampleScoresSize) {
                    this.sampleScores[i] = new SampleScore(bb, off);
                    this.sampleScores[i].read();
                    ++i;
                    off += 12;
                }
            }
        }

        @Override
        public void write() {
            if (this.bestClassName != null) {
                byte[] bestClassName_bytes;
                try {
                    bestClassName_bytes = this.bestClassName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bestClassName_bytes = new byte[]{};
                }
                this.bestClassName_buf = ByteBuffer.allocateDirect(bestClassName_bytes.length + 1);
                NIVision.putBytes(this.bestClassName_buf, bestClassName_bytes, 0, bestClassName_bytes.length).put(bestClassName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.bestClassName == null ? 0L : NIVision.getByteBufferAddress(this.bestClassName_buf));
            this.backing.putFloat(4, this.classificationScore);
            this.backing.putFloat(8, this.identificationScore);
            this.allScores_buf = ByteBuffer.allocateDirect(this.allScores.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.allScores.length) {
                this.allScores[i].setBuffer(this.allScores_buf, off);
                this.allScores[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(16, this.allScores.length);
            NIVision.putPointer(this.backing, 12, this.allScores_buf);
            this.sampleScores_buf = ByteBuffer.allocateDirect(this.sampleScores.length * 12).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.sampleScores.length) {
                this.sampleScores[i].setBuffer(this.sampleScores_buf, off);
                this.sampleScores[i].write();
                ++i;
                off += 12;
            }
            this.backing.putInt(24, this.sampleScores.length);
            NIVision.putPointer(this.backing, 20, this.sampleScores_buf);
        }

        @Override
        public int size() {
            return 28;
        }
    }

    public static class SampleScore
    extends DisposedStruct {
        public String className;
        public float distance;
        public int index;
        private ByteBuffer className_buf;

        private void init() {
        }

        public SampleScore() {
            super(12);
            this.init();
        }

        public SampleScore(String className, double distance, int index) {
            super(12);
            this.className = className;
            this.distance = (float)distance;
            this.index = index;
        }

        protected SampleScore(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected SampleScore(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            long className_addr = NIVision.getPointer(this.backing, 0);
            if (className_addr == 0L) {
                this.className = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(className_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.className = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.className = "";
                }
            }
            this.distance = this.backing.getFloat(4);
            this.index = this.backing.getInt(8);
        }

        @Override
        public void write() {
            if (this.className != null) {
                byte[] className_bytes;
                try {
                    className_bytes = this.className.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    className_bytes = new byte[]{};
                }
                this.className_buf = ByteBuffer.allocateDirect(className_bytes.length + 1);
                NIVision.putBytes(this.className_buf, className_bytes, 0, className_bytes.length).put(className_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.className == null ? 0L : NIVision.getByteBufferAddress(this.className_buf));
            this.backing.putFloat(4, this.distance);
            this.backing.putInt(8, this.index);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class ColorOptions
    extends DisposedStruct {
        public ColorClassificationResolution colorClassificationResolution;
        public int useLuminance;
        public ColorMode colorMode;

        private void init() {
        }

        public ColorOptions() {
            super(12);
            this.init();
        }

        public ColorOptions(ColorClassificationResolution colorClassificationResolution, int useLuminance, ColorMode colorMode) {
            super(12);
            this.colorClassificationResolution = colorClassificationResolution;
            this.useLuminance = useLuminance;
            this.colorMode = colorMode;
        }

        protected ColorOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected ColorOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.colorClassificationResolution = ColorClassificationResolution.fromValue(this.backing.getInt(0));
            this.useLuminance = this.backing.getInt(4);
            this.colorMode = ColorMode.fromValue(this.backing.getInt(8));
        }

        @Override
        public void write() {
            if (this.colorClassificationResolution != null) {
                this.backing.putInt(0, this.colorClassificationResolution.getValue());
            }
            this.backing.putInt(4, this.useLuminance);
            if (this.colorMode != null) {
                this.backing.putInt(8, this.colorMode.getValue());
            }
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class MatchGeometricPatternAdvancedOptions3
    extends DisposedStruct {
        public int subpixelIterations;
        public double subpixelTolerance;
        public int initialMatchListLength;
        public int targetTemplateCurveScore;
        public int correlationScore;
        public double minMatchSeparationDistance;
        public double minMatchSeparationAngle;
        public double minMatchSeparationScale;
        public double maxMatchOverlap;
        public int coarseResult;
        public int enableCalibrationSupport;
        public ContrastMode enableContrastReversal;
        public GeometricMatchingSearchStrategy matchStrategy;
        public int refineMatchFactor;
        public int subpixelMatchFactor;

        private void init() {
        }

        public MatchGeometricPatternAdvancedOptions3() {
            super(88);
            this.init();
        }

        public MatchGeometricPatternAdvancedOptions3(int subpixelIterations, double subpixelTolerance, int initialMatchListLength, int targetTemplateCurveScore, int correlationScore, double minMatchSeparationDistance, double minMatchSeparationAngle, double minMatchSeparationScale, double maxMatchOverlap, int coarseResult, int enableCalibrationSupport, ContrastMode enableContrastReversal, GeometricMatchingSearchStrategy matchStrategy, int refineMatchFactor, int subpixelMatchFactor) {
            super(88);
            this.subpixelIterations = subpixelIterations;
            this.subpixelTolerance = subpixelTolerance;
            this.initialMatchListLength = initialMatchListLength;
            this.targetTemplateCurveScore = targetTemplateCurveScore;
            this.correlationScore = correlationScore;
            this.minMatchSeparationDistance = minMatchSeparationDistance;
            this.minMatchSeparationAngle = minMatchSeparationAngle;
            this.minMatchSeparationScale = minMatchSeparationScale;
            this.maxMatchOverlap = maxMatchOverlap;
            this.coarseResult = coarseResult;
            this.enableCalibrationSupport = enableCalibrationSupport;
            this.enableContrastReversal = enableContrastReversal;
            this.matchStrategy = matchStrategy;
            this.refineMatchFactor = refineMatchFactor;
            this.subpixelMatchFactor = subpixelMatchFactor;
        }

        protected MatchGeometricPatternAdvancedOptions3(ByteBuffer backing, int offset) {
            super(backing, offset, 88);
            this.init();
        }

        protected MatchGeometricPatternAdvancedOptions3(long nativeObj, boolean owned) {
            super(nativeObj, owned, 88);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 88);
        }

        @Override
        public void read() {
            this.subpixelIterations = this.backing.getInt(0);
            this.subpixelTolerance = this.backing.getDouble(8);
            this.initialMatchListLength = this.backing.getInt(16);
            this.targetTemplateCurveScore = this.backing.getInt(20);
            this.correlationScore = this.backing.getInt(24);
            this.minMatchSeparationDistance = this.backing.getDouble(32);
            this.minMatchSeparationAngle = this.backing.getDouble(40);
            this.minMatchSeparationScale = this.backing.getDouble(48);
            this.maxMatchOverlap = this.backing.getDouble(56);
            this.coarseResult = this.backing.getInt(64);
            this.enableCalibrationSupport = this.backing.getInt(68);
            this.enableContrastReversal = ContrastMode.fromValue(this.backing.getInt(72));
            this.matchStrategy = GeometricMatchingSearchStrategy.fromValue(this.backing.getInt(76));
            this.refineMatchFactor = this.backing.getInt(80);
            this.subpixelMatchFactor = this.backing.getInt(84);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.subpixelIterations);
            this.backing.putDouble(8, this.subpixelTolerance);
            this.backing.putInt(16, this.initialMatchListLength);
            this.backing.putInt(20, this.targetTemplateCurveScore);
            this.backing.putInt(24, this.correlationScore);
            this.backing.putDouble(32, this.minMatchSeparationDistance);
            this.backing.putDouble(40, this.minMatchSeparationAngle);
            this.backing.putDouble(48, this.minMatchSeparationScale);
            this.backing.putDouble(56, this.maxMatchOverlap);
            this.backing.putInt(64, this.coarseResult);
            this.backing.putInt(68, this.enableCalibrationSupport);
            if (this.enableContrastReversal != null) {
                this.backing.putInt(72, this.enableContrastReversal.getValue());
            }
            if (this.matchStrategy != null) {
                this.backing.putInt(76, this.matchStrategy.getValue());
            }
            this.backing.putInt(80, this.refineMatchFactor);
            this.backing.putInt(84, this.subpixelMatchFactor);
        }

        @Override
        public int size() {
            return 88;
        }
    }

    public static class GeometricPatternMatch3
    extends DisposedStruct {
        public PointFloat position;
        public float rotation;
        public float scale;
        public float score;
        public PointFloat[] corner;
        public int inverse;
        public float occlusion;
        public float templateMatchCurveScore;
        public float matchTemplateCurveScore;
        public float correlationScore;
        public PointFloat calibratedPosition;
        public float calibratedRotation;
        public PointFloat[] calibratedCorner;

        private void init() {
            this.position = new PointFloat(this.backing, 0);
            this.corner = new PointFloat[4];
            int i = 0;
            int off = 20;
            while (i < 4) {
                this.corner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
            this.calibratedPosition = new PointFloat(this.backing, 72);
            this.calibratedCorner = new PointFloat[4];
            i = 0;
            off = 84;
            while (i < 4) {
                this.calibratedCorner[i] = new PointFloat(this.backing, off);
                ++i;
                off += 8;
            }
        }

        public GeometricPatternMatch3() {
            super(116);
            this.init();
        }

        public GeometricPatternMatch3(PointFloat position, double rotation, double scale, double score, PointFloat[] corner, int inverse, double occlusion, double templateMatchCurveScore, double matchTemplateCurveScore, double correlationScore, PointFloat calibratedPosition, double calibratedRotation, PointFloat[] calibratedCorner) {
            super(116);
            this.position = position;
            this.rotation = (float)rotation;
            this.scale = (float)scale;
            this.score = (float)score;
            this.corner = corner;
            this.inverse = inverse;
            this.occlusion = (float)occlusion;
            this.templateMatchCurveScore = (float)templateMatchCurveScore;
            this.matchTemplateCurveScore = (float)matchTemplateCurveScore;
            this.correlationScore = (float)correlationScore;
            this.calibratedPosition = calibratedPosition;
            this.calibratedRotation = (float)calibratedRotation;
            this.calibratedCorner = calibratedCorner;
        }

        protected GeometricPatternMatch3(ByteBuffer backing, int offset) {
            super(backing, offset, 116);
            this.init();
        }

        protected GeometricPatternMatch3(long nativeObj, boolean owned) {
            super(nativeObj, owned, 116);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 116);
        }

        @Override
        public void read() {
            this.position.read();
            this.rotation = this.backing.getFloat(8);
            this.scale = this.backing.getFloat(12);
            this.score = this.backing.getFloat(16);
            for (PointFloat it : this.corner) {
                it.read();
            }
            this.inverse = this.backing.getInt(52);
            this.occlusion = this.backing.getFloat(56);
            this.templateMatchCurveScore = this.backing.getFloat(60);
            this.matchTemplateCurveScore = this.backing.getFloat(64);
            this.correlationScore = this.backing.getFloat(68);
            this.calibratedPosition.read();
            this.calibratedRotation = this.backing.getFloat(80);
            for (PointFloat it : this.calibratedCorner) {
                it.read();
            }
        }

        @Override
        public void write() {
            this.position.write();
            this.backing.putFloat(8, this.rotation);
            this.backing.putFloat(12, this.scale);
            this.backing.putFloat(16, this.score);
            for (PointFloat it : this.corner) {
                it.write();
            }
            this.backing.putInt(52, this.inverse);
            this.backing.putFloat(56, this.occlusion);
            this.backing.putFloat(60, this.templateMatchCurveScore);
            this.backing.putFloat(64, this.matchTemplateCurveScore);
            this.backing.putFloat(68, this.correlationScore);
            this.calibratedPosition.write();
            this.backing.putFloat(80, this.calibratedRotation);
            for (PointFloat it : this.calibratedCorner) {
                it.write();
            }
        }

        @Override
        public int size() {
            return 116;
        }
    }

    public static class MeasureParticlesReport
    extends DisposedStruct {
        public int numParticles;
        public int numMeasurements;

        private void init() {
        }

        public MeasureParticlesReport() {
            super(16);
            this.init();
        }

        public MeasureParticlesReport(int numParticles, int numMeasurements) {
            super(16);
            this.numParticles = numParticles;
            this.numMeasurements = numMeasurements;
        }

        protected MeasureParticlesReport(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected MeasureParticlesReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.numParticles = this.backing.getInt(8);
            this.numMeasurements = this.backing.getInt(12);
        }

        @Override
        public void write() {
            this.backing.putInt(8, this.numParticles);
            this.backing.putInt(12, this.numMeasurements);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ParticleClassifierPreprocessingOptions2
    extends DisposedStruct {
        public ParticleClassifierThresholdType thresholdType;
        public RangeFloat manualThresholdRange;
        public ParticleClassifierAutoThresholdOptions autoThresholdOptions;
        public ParticleClassifierLocalThresholdOptions localThresholdOptions;
        public int rejectBorder;
        public int numErosions;

        private void init() {
            this.manualThresholdRange = new RangeFloat(this.backing, 4);
            this.autoThresholdOptions = new ParticleClassifierAutoThresholdOptions(this.backing, 12);
            this.localThresholdOptions = new ParticleClassifierLocalThresholdOptions(this.backing, 32);
        }

        public ParticleClassifierPreprocessingOptions2() {
            super(64);
            this.init();
        }

        public ParticleClassifierPreprocessingOptions2(ParticleClassifierThresholdType thresholdType, RangeFloat manualThresholdRange, ParticleClassifierAutoThresholdOptions autoThresholdOptions, ParticleClassifierLocalThresholdOptions localThresholdOptions, int rejectBorder, int numErosions) {
            super(64);
            this.thresholdType = thresholdType;
            this.manualThresholdRange = manualThresholdRange;
            this.autoThresholdOptions = autoThresholdOptions;
            this.localThresholdOptions = localThresholdOptions;
            this.rejectBorder = rejectBorder;
            this.numErosions = numErosions;
        }

        protected ParticleClassifierPreprocessingOptions2(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected ParticleClassifierPreprocessingOptions2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.thresholdType = ParticleClassifierThresholdType.fromValue(this.backing.getInt(0));
            this.manualThresholdRange.read();
            this.autoThresholdOptions.read();
            this.localThresholdOptions.read();
            this.rejectBorder = this.backing.getInt(56);
            this.numErosions = this.backing.getInt(60);
        }

        @Override
        public void write() {
            if (this.thresholdType != null) {
                this.backing.putInt(0, this.thresholdType.getValue());
            }
            this.manualThresholdRange.write();
            this.autoThresholdOptions.write();
            this.localThresholdOptions.write();
            this.backing.putInt(56, this.rejectBorder);
            this.backing.putInt(60, this.numErosions);
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class ParticleClassifierAutoThresholdOptions
    extends DisposedStruct {
        public ThresholdMethod method;
        public ParticleType particleType;
        public RangeFloat limits;

        private void init() {
            this.limits = new RangeFloat(this.backing, 8);
        }

        public ParticleClassifierAutoThresholdOptions() {
            super(16);
            this.init();
        }

        public ParticleClassifierAutoThresholdOptions(ThresholdMethod method, ParticleType particleType, RangeFloat limits) {
            super(16);
            this.method = method;
            this.particleType = particleType;
            this.limits = limits;
        }

        protected ParticleClassifierAutoThresholdOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ParticleClassifierAutoThresholdOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.method = ThresholdMethod.fromValue(this.backing.getInt(0));
            this.particleType = ParticleType.fromValue(this.backing.getInt(4));
            this.limits.read();
        }

        @Override
        public void write() {
            if (this.method != null) {
                this.backing.putInt(0, this.method.getValue());
            }
            if (this.particleType != null) {
                this.backing.putInt(4, this.particleType.getValue());
            }
            this.limits.write();
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class RangeFloat
    extends DisposedStruct {
        public float minValue;
        public float maxValue;

        private void init() {
        }

        public RangeFloat() {
            super(8);
            this.init();
        }

        public RangeFloat(double minValue, double maxValue) {
            super(8);
            this.minValue = (float)minValue;
            this.maxValue = (float)maxValue;
        }

        protected RangeFloat(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected RangeFloat(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.minValue = this.backing.getFloat(0);
            this.maxValue = this.backing.getFloat(4);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.minValue);
            this.backing.putFloat(4, this.maxValue);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class ParticleClassifierLocalThresholdOptions
    extends DisposedStruct {
        public LocalThresholdMethod method;
        public ParticleType particleType;
        public int windowWidth;
        public int windowHeight;
        public double deviationWeight;

        private void init() {
        }

        public ParticleClassifierLocalThresholdOptions() {
            super(24);
            this.init();
        }

        public ParticleClassifierLocalThresholdOptions(LocalThresholdMethod method, ParticleType particleType, int windowWidth, int windowHeight, double deviationWeight) {
            super(24);
            this.method = method;
            this.particleType = particleType;
            this.windowWidth = windowWidth;
            this.windowHeight = windowHeight;
            this.deviationWeight = deviationWeight;
        }

        protected ParticleClassifierLocalThresholdOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected ParticleClassifierLocalThresholdOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.method = LocalThresholdMethod.fromValue(this.backing.getInt(0));
            this.particleType = ParticleType.fromValue(this.backing.getInt(4));
            this.windowWidth = this.backing.getInt(8);
            this.windowHeight = this.backing.getInt(12);
            this.deviationWeight = this.backing.getDouble(16);
        }

        @Override
        public void write() {
            if (this.method != null) {
                this.backing.putInt(0, this.method.getValue());
            }
            if (this.particleType != null) {
                this.backing.putInt(4, this.particleType.getValue());
            }
            this.backing.putInt(8, this.windowWidth);
            this.backing.putInt(12, this.windowHeight);
            this.backing.putDouble(16, this.deviationWeight);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class CooccurrenceOptions
    extends DisposedStruct {
        public int level;
        public DisplacementVector displacement;

        private void init() {
            this.displacement = new DisplacementVector(this.backing, 4);
        }

        public CooccurrenceOptions() {
            super(12);
            this.init();
        }

        public CooccurrenceOptions(int level, DisplacementVector displacement) {
            super(12);
            this.level = level;
            this.displacement = displacement;
        }

        protected CooccurrenceOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected CooccurrenceOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.level = this.backing.getInt(0);
            this.displacement.read();
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.level);
            this.displacement.write();
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class WaveletOptions
    extends DisposedStruct {
        public WaveletType typeOfWavelet;
        public float minEnergy;

        private void init() {
        }

        public WaveletOptions() {
            super(8);
            this.init();
        }

        public WaveletOptions(WaveletType typeOfWavelet, double minEnergy) {
            super(8);
            this.typeOfWavelet = typeOfWavelet;
            this.minEnergy = (float)minEnergy;
        }

        protected WaveletOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected WaveletOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.typeOfWavelet = WaveletType.fromValue(this.backing.getInt(0));
            this.minEnergy = this.backing.getFloat(4);
        }

        @Override
        public void write() {
            if (this.typeOfWavelet != null) {
                this.backing.putInt(0, this.typeOfWavelet.getValue());
            }
            this.backing.putFloat(4, this.minEnergy);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class DisplacementVector
    extends DisposedStruct {
        public int x;
        public int y;

        private void init() {
        }

        public DisplacementVector() {
            super(8);
            this.init();
        }

        public DisplacementVector(int x, int y) {
            super(8);
            this.x = x;
            this.y = y;
        }

        protected DisplacementVector(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected DisplacementVector(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.x = this.backing.getInt(0);
            this.y = this.backing.getInt(4);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.x);
            this.backing.putInt(4, this.y);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class WindowSize
    extends DisposedStruct {
        public int x;
        public int y;
        public int stepSize;

        private void init() {
        }

        public WindowSize() {
            super(12);
            this.init();
        }

        public WindowSize(int x, int y, int stepSize) {
            super(12);
            this.x = x;
            this.y = y;
            this.stepSize = stepSize;
        }

        protected WindowSize(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected WindowSize(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.x = this.backing.getInt(0);
            this.y = this.backing.getInt(4);
            this.stepSize = this.backing.getInt(8);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.x);
            this.backing.putInt(4, this.y);
            this.backing.putInt(8, this.stepSize);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class FindCircularEdgeReport
    extends DisposedStruct {
        public PointFloat centerCalibrated;
        public double radiusCalibrated;
        public PointFloat center;
        public double radius;
        public double roundness;
        public double avgStrength;
        public double avgSNR;
        public int circleFound;

        private void init() {
            this.centerCalibrated = new PointFloat(this.backing, 0);
            this.center = new PointFloat(this.backing, 16);
        }

        public FindCircularEdgeReport() {
            super(64);
            this.init();
        }

        public FindCircularEdgeReport(PointFloat centerCalibrated, double radiusCalibrated, PointFloat center, double radius, double roundness, double avgStrength, double avgSNR, int circleFound) {
            super(64);
            this.centerCalibrated = centerCalibrated;
            this.radiusCalibrated = radiusCalibrated;
            this.center = center;
            this.radius = radius;
            this.roundness = roundness;
            this.avgStrength = avgStrength;
            this.avgSNR = avgSNR;
            this.circleFound = circleFound;
        }

        protected FindCircularEdgeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected FindCircularEdgeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.centerCalibrated.read();
            this.radiusCalibrated = this.backing.getDouble(8);
            this.center.read();
            this.radius = this.backing.getDouble(24);
            this.roundness = this.backing.getDouble(32);
            this.avgStrength = this.backing.getDouble(40);
            this.avgSNR = this.backing.getDouble(48);
            this.circleFound = this.backing.getInt(56);
        }

        @Override
        public void write() {
            this.centerCalibrated.write();
            this.backing.putDouble(8, this.radiusCalibrated);
            this.center.write();
            this.backing.putDouble(24, this.radius);
            this.backing.putDouble(32, this.roundness);
            this.backing.putDouble(40, this.avgStrength);
            this.backing.putDouble(48, this.avgSNR);
            this.backing.putInt(56, this.circleFound);
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class FindConcentricEdgeReport
    extends DisposedStruct {
        public PointFloat startPt;
        public PointFloat endPt;
        public PointFloat startPtCalibrated;
        public PointFloat endPtCalibrated;
        public double angle;
        public double angleCalibrated;
        public double straightness;
        public double avgStrength;
        public double avgSNR;
        public int lineFound;

        private void init() {
            this.startPt = new PointFloat(this.backing, 0);
            this.endPt = new PointFloat(this.backing, 8);
            this.startPtCalibrated = new PointFloat(this.backing, 16);
            this.endPtCalibrated = new PointFloat(this.backing, 24);
        }

        public FindConcentricEdgeReport() {
            super(80);
            this.init();
        }

        public FindConcentricEdgeReport(PointFloat startPt, PointFloat endPt, PointFloat startPtCalibrated, PointFloat endPtCalibrated, double angle, double angleCalibrated, double straightness, double avgStrength, double avgSNR, int lineFound) {
            super(80);
            this.startPt = startPt;
            this.endPt = endPt;
            this.startPtCalibrated = startPtCalibrated;
            this.endPtCalibrated = endPtCalibrated;
            this.angle = angle;
            this.angleCalibrated = angleCalibrated;
            this.straightness = straightness;
            this.avgStrength = avgStrength;
            this.avgSNR = avgSNR;
            this.lineFound = lineFound;
        }

        protected FindConcentricEdgeReport(ByteBuffer backing, int offset) {
            super(backing, offset, 80);
            this.init();
        }

        protected FindConcentricEdgeReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 80);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 80);
        }

        @Override
        public void read() {
            this.startPt.read();
            this.endPt.read();
            this.startPtCalibrated.read();
            this.endPtCalibrated.read();
            this.angle = this.backing.getDouble(32);
            this.angleCalibrated = this.backing.getDouble(40);
            this.straightness = this.backing.getDouble(48);
            this.avgStrength = this.backing.getDouble(56);
            this.avgSNR = this.backing.getDouble(64);
            this.lineFound = this.backing.getInt(72);
        }

        @Override
        public void write() {
            this.startPt.write();
            this.endPt.write();
            this.startPtCalibrated.write();
            this.endPtCalibrated.write();
            this.backing.putDouble(32, this.angle);
            this.backing.putDouble(40, this.angleCalibrated);
            this.backing.putDouble(48, this.straightness);
            this.backing.putDouble(56, this.avgStrength);
            this.backing.putDouble(64, this.avgSNR);
            this.backing.putInt(72, this.lineFound);
        }

        @Override
        public int size() {
            return 80;
        }
    }

    public static class ConcentricEdgeFitOptions
    extends DisposedStruct {
        public int maxRadius;
        public double stepSize;
        public RakeProcessType processType;

        private void init() {
        }

        public ConcentricEdgeFitOptions() {
            super(24);
            this.init();
        }

        public ConcentricEdgeFitOptions(int maxRadius, double stepSize, RakeProcessType processType) {
            super(24);
            this.maxRadius = maxRadius;
            this.stepSize = stepSize;
            this.processType = processType;
        }

        protected ConcentricEdgeFitOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected ConcentricEdgeFitOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.maxRadius = this.backing.getInt(0);
            this.stepSize = this.backing.getDouble(8);
            this.processType = RakeProcessType.fromValue(this.backing.getInt(16));
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.maxRadius);
            this.backing.putDouble(8, this.stepSize);
            if (this.processType != null) {
                this.backing.putInt(16, this.processType.getValue());
            }
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class FindConcentricEdgeOptions
    extends DisposedStruct {
        public ConcentricRakeDirection direction;
        public int showSearchArea;
        public int showSearchLines;
        public int showEdgesFound;
        public int showResult;
        public RGBValue searchAreaColor;
        public RGBValue searchLinesColor;
        public RGBValue searchEdgesColor;
        public RGBValue resultColor;
        public String overlayGroupName;
        public EdgeOptions2 edgeOptions;
        private ByteBuffer overlayGroupName_buf;

        private void init() {
            this.searchAreaColor = new RGBValue(this.backing, 20);
            this.searchLinesColor = new RGBValue(this.backing, 24);
            this.searchEdgesColor = new RGBValue(this.backing, 28);
            this.resultColor = new RGBValue(this.backing, 32);
            this.edgeOptions = new EdgeOptions2(this.backing, 40);
        }

        public FindConcentricEdgeOptions() {
            super(64);
            this.init();
        }

        public FindConcentricEdgeOptions(ConcentricRakeDirection direction, int showSearchArea, int showSearchLines, int showEdgesFound, int showResult, RGBValue searchAreaColor, RGBValue searchLinesColor, RGBValue searchEdgesColor, RGBValue resultColor, String overlayGroupName, EdgeOptions2 edgeOptions) {
            super(64);
            this.direction = direction;
            this.showSearchArea = showSearchArea;
            this.showSearchLines = showSearchLines;
            this.showEdgesFound = showEdgesFound;
            this.showResult = showResult;
            this.searchAreaColor = searchAreaColor;
            this.searchLinesColor = searchLinesColor;
            this.searchEdgesColor = searchEdgesColor;
            this.resultColor = resultColor;
            this.overlayGroupName = overlayGroupName;
            this.edgeOptions = edgeOptions;
        }

        protected FindConcentricEdgeOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected FindConcentricEdgeOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.direction = ConcentricRakeDirection.fromValue(this.backing.getInt(0));
            this.showSearchArea = this.backing.getInt(4);
            this.showSearchLines = this.backing.getInt(8);
            this.showEdgesFound = this.backing.getInt(12);
            this.showResult = this.backing.getInt(16);
            this.searchAreaColor.read();
            this.searchLinesColor.read();
            this.searchEdgesColor.read();
            this.resultColor.read();
            long overlayGroupName_addr = NIVision.getPointer(this.backing, 36);
            if (overlayGroupName_addr == 0L) {
                this.overlayGroupName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(overlayGroupName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.overlayGroupName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.overlayGroupName = "";
                }
            }
            this.edgeOptions.read();
        }

        @Override
        public void write() {
            if (this.direction != null) {
                this.backing.putInt(0, this.direction.getValue());
            }
            this.backing.putInt(4, this.showSearchArea);
            this.backing.putInt(8, this.showSearchLines);
            this.backing.putInt(12, this.showEdgesFound);
            this.backing.putInt(16, this.showResult);
            this.searchAreaColor.write();
            this.searchLinesColor.write();
            this.searchEdgesColor.write();
            this.resultColor.write();
            if (this.overlayGroupName != null) {
                byte[] overlayGroupName_bytes;
                try {
                    overlayGroupName_bytes = this.overlayGroupName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    overlayGroupName_bytes = new byte[]{};
                }
                this.overlayGroupName_buf = ByteBuffer.allocateDirect(overlayGroupName_bytes.length + 1);
                NIVision.putBytes(this.overlayGroupName_buf, overlayGroupName_bytes, 0, overlayGroupName_bytes.length).put(overlayGroupName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 36, this.overlayGroupName == null ? 0L : NIVision.getByteBufferAddress(this.overlayGroupName_buf));
            this.edgeOptions.write();
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class FindCircularEdgeOptions
    extends DisposedStruct {
        public SpokeDirection direction;
        public int showSearchArea;
        public int showSearchLines;
        public int showEdgesFound;
        public int showResult;
        public RGBValue searchAreaColor;
        public RGBValue searchLinesColor;
        public RGBValue searchEdgesColor;
        public RGBValue resultColor;
        public String overlayGroupName;
        public EdgeOptions2 edgeOptions;
        private ByteBuffer overlayGroupName_buf;

        private void init() {
            this.searchAreaColor = new RGBValue(this.backing, 20);
            this.searchLinesColor = new RGBValue(this.backing, 24);
            this.searchEdgesColor = new RGBValue(this.backing, 28);
            this.resultColor = new RGBValue(this.backing, 32);
            this.edgeOptions = new EdgeOptions2(this.backing, 40);
        }

        public FindCircularEdgeOptions() {
            super(64);
            this.init();
        }

        public FindCircularEdgeOptions(SpokeDirection direction, int showSearchArea, int showSearchLines, int showEdgesFound, int showResult, RGBValue searchAreaColor, RGBValue searchLinesColor, RGBValue searchEdgesColor, RGBValue resultColor, String overlayGroupName, EdgeOptions2 edgeOptions) {
            super(64);
            this.direction = direction;
            this.showSearchArea = showSearchArea;
            this.showSearchLines = showSearchLines;
            this.showEdgesFound = showEdgesFound;
            this.showResult = showResult;
            this.searchAreaColor = searchAreaColor;
            this.searchLinesColor = searchLinesColor;
            this.searchEdgesColor = searchEdgesColor;
            this.resultColor = resultColor;
            this.overlayGroupName = overlayGroupName;
            this.edgeOptions = edgeOptions;
        }

        protected FindCircularEdgeOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected FindCircularEdgeOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.direction = SpokeDirection.fromValue(this.backing.getInt(0));
            this.showSearchArea = this.backing.getInt(4);
            this.showSearchLines = this.backing.getInt(8);
            this.showEdgesFound = this.backing.getInt(12);
            this.showResult = this.backing.getInt(16);
            this.searchAreaColor.read();
            this.searchLinesColor.read();
            this.searchEdgesColor.read();
            this.resultColor.read();
            long overlayGroupName_addr = NIVision.getPointer(this.backing, 36);
            if (overlayGroupName_addr == 0L) {
                this.overlayGroupName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(overlayGroupName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.overlayGroupName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.overlayGroupName = "";
                }
            }
            this.edgeOptions.read();
        }

        @Override
        public void write() {
            if (this.direction != null) {
                this.backing.putInt(0, this.direction.getValue());
            }
            this.backing.putInt(4, this.showSearchArea);
            this.backing.putInt(8, this.showSearchLines);
            this.backing.putInt(12, this.showEdgesFound);
            this.backing.putInt(16, this.showResult);
            this.searchAreaColor.write();
            this.searchLinesColor.write();
            this.searchEdgesColor.write();
            this.resultColor.write();
            if (this.overlayGroupName != null) {
                byte[] overlayGroupName_bytes;
                try {
                    overlayGroupName_bytes = this.overlayGroupName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    overlayGroupName_bytes = new byte[]{};
                }
                this.overlayGroupName_buf = ByteBuffer.allocateDirect(overlayGroupName_bytes.length + 1);
                NIVision.putBytes(this.overlayGroupName_buf, overlayGroupName_bytes, 0, overlayGroupName_bytes.length).put(overlayGroupName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 36, this.overlayGroupName == null ? 0L : NIVision.getByteBufferAddress(this.overlayGroupName_buf));
            this.edgeOptions.write();
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class EdgeOptions2
    extends DisposedStruct {
        public EdgePolaritySearchMode polarity;
        public int kernelSize;
        public int width;
        public float minThreshold;
        public InterpolationMethod interpolationType;
        public ColumnProcessingMode columnProcessingMode;

        private void init() {
        }

        public EdgeOptions2() {
            super(24);
            this.init();
        }

        public EdgeOptions2(EdgePolaritySearchMode polarity, int kernelSize, int width, double minThreshold, InterpolationMethod interpolationType, ColumnProcessingMode columnProcessingMode) {
            super(24);
            this.polarity = polarity;
            this.kernelSize = kernelSize;
            this.width = width;
            this.minThreshold = (float)minThreshold;
            this.interpolationType = interpolationType;
            this.columnProcessingMode = columnProcessingMode;
        }

        protected EdgeOptions2(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected EdgeOptions2(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.polarity = EdgePolaritySearchMode.fromValue(this.backing.getInt(0));
            this.kernelSize = this.backing.getInt(4);
            this.width = this.backing.getInt(8);
            this.minThreshold = this.backing.getFloat(12);
            this.interpolationType = InterpolationMethod.fromValue(this.backing.getInt(16));
            this.columnProcessingMode = ColumnProcessingMode.fromValue(this.backing.getInt(20));
        }

        @Override
        public void write() {
            if (this.polarity != null) {
                this.backing.putInt(0, this.polarity.getValue());
            }
            this.backing.putInt(4, this.kernelSize);
            this.backing.putInt(8, this.width);
            this.backing.putFloat(12, this.minThreshold);
            if (this.interpolationType != null) {
                this.backing.putInt(16, this.interpolationType.getValue());
            }
            if (this.columnProcessingMode != null) {
                this.backing.putInt(20, this.columnProcessingMode.getValue());
            }
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class CircleFitOptions
    extends DisposedStruct {
        public int maxRadius;
        public double stepSize;
        public RakeProcessType processType;

        private void init() {
        }

        public CircleFitOptions() {
            super(24);
            this.init();
        }

        public CircleFitOptions(int maxRadius, double stepSize, RakeProcessType processType) {
            super(24);
            this.maxRadius = maxRadius;
            this.stepSize = stepSize;
            this.processType = processType;
        }

        protected CircleFitOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected CircleFitOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.maxRadius = this.backing.getInt(0);
            this.stepSize = this.backing.getDouble(8);
            this.processType = RakeProcessType.fromValue(this.backing.getInt(16));
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.maxRadius);
            this.backing.putDouble(8, this.stepSize);
            if (this.processType != null) {
                this.backing.putInt(16, this.processType.getValue());
            }
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class WaveletBandsReport
    extends DisposedStruct {
        public float LHLBand;
        public int rows;
        public int cols;

        private void init() {
        }

        public WaveletBandsReport() {
            super(40);
            this.init();
        }

        public WaveletBandsReport(double LHLBand, int rows, int cols) {
            super(40);
            this.LHLBand = (float)LHLBand;
            this.rows = rows;
            this.cols = cols;
        }

        protected WaveletBandsReport(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected WaveletBandsReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.LHLBand = this.backing.getFloat(24);
            this.rows = this.backing.getInt(32);
            this.cols = this.backing.getInt(36);
        }

        @Override
        public void write() {
            this.backing.putFloat(24, this.LHLBand);
            this.backing.putInt(32, this.rows);
            this.backing.putInt(36, this.cols);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class ExtractTextureFeaturesReport
    extends DisposedStruct {
        public int[] waveletBands;
        public int textureFeaturesRows;
        public int textureFeaturesCols;
        private ByteBuffer waveletBands_buf;

        private void init() {
            this.waveletBands = new int[0];
        }

        public ExtractTextureFeaturesReport() {
            super(20);
            this.init();
        }

        public ExtractTextureFeaturesReport(int[] waveletBands, int textureFeaturesRows, int textureFeaturesCols) {
            super(20);
            this.waveletBands = waveletBands;
            this.textureFeaturesRows = textureFeaturesRows;
            this.textureFeaturesCols = textureFeaturesCols;
        }

        protected ExtractTextureFeaturesReport(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected ExtractTextureFeaturesReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            int waveletBands_numWaveletBands = this.backing.getInt(4);
            long waveletBands_addr = NIVision.getPointer(this.backing, 0);
            this.waveletBands = new int[waveletBands_numWaveletBands];
            if (waveletBands_numWaveletBands > 0 && waveletBands_addr != 0L) {
                NIVision.newDirectByteBuffer(waveletBands_addr, waveletBands_numWaveletBands * 4).asIntBuffer().get(this.waveletBands);
            }
            this.textureFeaturesRows = this.backing.getInt(12);
            this.textureFeaturesCols = this.backing.getInt(16);
        }

        @Override
        public void write() {
            this.waveletBands_buf = ByteBuffer.allocateDirect(this.waveletBands.length * 4).order(ByteOrder.nativeOrder());
            this.waveletBands_buf.asIntBuffer().put(this.waveletBands).rewind();
            this.backing.putInt(4, this.waveletBands.length);
            NIVision.putPointer(this.backing, 0, this.waveletBands_buf);
            this.backing.putInt(12, this.textureFeaturesRows);
            this.backing.putInt(16, this.textureFeaturesCols);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class ConnectionConstraint
    extends DisposedStruct {
        public ConnectionConstraintType constraintType;
        public RangeDouble range;

        private void init() {
            this.range = new RangeDouble(this.backing, 8);
        }

        public ConnectionConstraint() {
            super(24);
            this.init();
        }

        public ConnectionConstraint(ConnectionConstraintType constraintType, RangeDouble range) {
            super(24);
            this.constraintType = constraintType;
            this.range = range;
        }

        protected ConnectionConstraint(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected ConnectionConstraint(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.constraintType = ConnectionConstraintType.fromValue(this.backing.getInt(0));
            this.range.read();
        }

        @Override
        public void write() {
            if (this.constraintType != null) {
                this.backing.putInt(0, this.constraintType.getValue());
            }
            this.range.write();
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class ExtractContourReport
    extends DisposedStruct {
        public PointDouble[] contourPoints;
        public PointDouble[] sourcePoints;
        private ByteBuffer contourPoints_buf;
        private ByteBuffer sourcePoints_buf;

        private void init() {
            this.contourPoints = new PointDouble[0];
            this.sourcePoints = new PointDouble[0];
        }

        public ExtractContourReport() {
            super(16);
            this.init();
        }

        public ExtractContourReport(PointDouble[] contourPoints, PointDouble[] sourcePoints) {
            super(16);
            this.contourPoints = contourPoints;
            this.sourcePoints = sourcePoints;
        }

        protected ExtractContourReport(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ExtractContourReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            int contourPoints_numContourPoints = this.backing.getInt(4);
            long contourPoints_addr = NIVision.getPointer(this.backing, 0);
            this.contourPoints = new PointDouble[contourPoints_numContourPoints];
            if (contourPoints_numContourPoints > 0 && contourPoints_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(contourPoints_addr, contourPoints_numContourPoints * 16);
                int i = 0;
                int off = 0;
                while (i < contourPoints_numContourPoints) {
                    this.contourPoints[i] = new PointDouble(bb, off);
                    this.contourPoints[i].read();
                    ++i;
                    off += 16;
                }
            }
            int sourcePoints_numSourcePoints = this.backing.getInt(12);
            long sourcePoints_addr = NIVision.getPointer(this.backing, 8);
            this.sourcePoints = new PointDouble[sourcePoints_numSourcePoints];
            if (sourcePoints_numSourcePoints > 0 && sourcePoints_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(sourcePoints_addr, sourcePoints_numSourcePoints * 16);
                int i = 0;
                int off = 0;
                while (i < sourcePoints_numSourcePoints) {
                    this.sourcePoints[i] = new PointDouble(bb, off);
                    this.sourcePoints[i].read();
                    ++i;
                    off += 16;
                }
            }
        }

        @Override
        public void write() {
            this.contourPoints_buf = ByteBuffer.allocateDirect(this.contourPoints.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.contourPoints.length) {
                this.contourPoints[i].setBuffer(this.contourPoints_buf, off);
                this.contourPoints[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(4, this.contourPoints.length);
            NIVision.putPointer(this.backing, 0, this.contourPoints_buf);
            this.sourcePoints_buf = ByteBuffer.allocateDirect(this.sourcePoints.length * 16).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.sourcePoints.length) {
                this.sourcePoints[i].setBuffer(this.sourcePoints_buf, off);
                this.sourcePoints[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(12, this.sourcePoints.length);
            NIVision.putPointer(this.backing, 8, this.sourcePoints_buf);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class CurveParameters
    extends DisposedStruct {
        public ExtractionMode extractionMode;
        public int threshold;
        public EdgeFilterSize filterSize;
        public int minLength;
        public int searchStep;
        public int maxEndPointGap;
        public int subpixel;

        private void init() {
        }

        public CurveParameters() {
            super(28);
            this.init();
        }

        public CurveParameters(ExtractionMode extractionMode, int threshold, EdgeFilterSize filterSize, int minLength, int searchStep, int maxEndPointGap, int subpixel) {
            super(28);
            this.extractionMode = extractionMode;
            this.threshold = threshold;
            this.filterSize = filterSize;
            this.minLength = minLength;
            this.searchStep = searchStep;
            this.maxEndPointGap = maxEndPointGap;
            this.subpixel = subpixel;
        }

        protected CurveParameters(ByteBuffer backing, int offset) {
            super(backing, offset, 28);
            this.init();
        }

        protected CurveParameters(long nativeObj, boolean owned) {
            super(nativeObj, owned, 28);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 28);
        }

        @Override
        public void read() {
            this.extractionMode = ExtractionMode.fromValue(this.backing.getInt(0));
            this.threshold = this.backing.getInt(4);
            this.filterSize = EdgeFilterSize.fromValue(this.backing.getInt(8));
            this.minLength = this.backing.getInt(12);
            this.searchStep = this.backing.getInt(16);
            this.maxEndPointGap = this.backing.getInt(20);
            this.subpixel = this.backing.getInt(24);
        }

        @Override
        public void write() {
            if (this.extractionMode != null) {
                this.backing.putInt(0, this.extractionMode.getValue());
            }
            this.backing.putInt(4, this.threshold);
            if (this.filterSize != null) {
                this.backing.putInt(8, this.filterSize.getValue());
            }
            this.backing.putInt(12, this.minLength);
            this.backing.putInt(16, this.searchStep);
            this.backing.putInt(20, this.maxEndPointGap);
            this.backing.putInt(24, this.subpixel);
        }

        @Override
        public int size() {
            return 28;
        }
    }

    public static class ContourOverlaySettings
    extends DisposedStruct {
        public int overlay;
        public RGBValue color;
        public int width;
        public int maintainWidth;

        private void init() {
            this.color = new RGBValue(this.backing, 4);
        }

        public ContourOverlaySettings() {
            super(16);
            this.init();
        }

        public ContourOverlaySettings(int overlay, RGBValue color, int width, int maintainWidth) {
            super(16);
            this.overlay = overlay;
            this.color = color;
            this.width = width;
            this.maintainWidth = maintainWidth;
        }

        protected ContourOverlaySettings(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ContourOverlaySettings(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.overlay = this.backing.getInt(0);
            this.color.read();
            this.width = this.backing.getInt(8);
            this.maintainWidth = this.backing.getInt(12);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.overlay);
            this.color.write();
            this.backing.putInt(8, this.width);
            this.backing.putInt(12, this.maintainWidth);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ContourComputeCurvatureReport
    extends DisposedStruct {
        public double[] curvaturePixel;
        public double[] curvatureReal;
        private ByteBuffer curvaturePixel_buf;
        private ByteBuffer curvatureReal_buf;

        private void init() {
            this.curvaturePixel = new double[0];
            this.curvatureReal = new double[0];
        }

        public ContourComputeCurvatureReport() {
            super(16);
            this.init();
        }

        public ContourComputeCurvatureReport(double[] curvaturePixel, double[] curvatureReal) {
            super(16);
            this.curvaturePixel = curvaturePixel;
            this.curvatureReal = curvatureReal;
        }

        protected ContourComputeCurvatureReport(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ContourComputeCurvatureReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            int curvaturePixel_numCurvaturePixel = this.backing.getInt(4);
            long curvaturePixel_addr = NIVision.getPointer(this.backing, 0);
            this.curvaturePixel = new double[curvaturePixel_numCurvaturePixel];
            if (curvaturePixel_numCurvaturePixel > 0 && curvaturePixel_addr != 0L) {
                NIVision.newDirectByteBuffer(curvaturePixel_addr, curvaturePixel_numCurvaturePixel * 8).asDoubleBuffer().get(this.curvaturePixel);
            }
            int curvatureReal_numCurvatureReal = this.backing.getInt(12);
            long curvatureReal_addr = NIVision.getPointer(this.backing, 8);
            this.curvatureReal = new double[curvatureReal_numCurvatureReal];
            if (curvatureReal_numCurvatureReal > 0 && curvatureReal_addr != 0L) {
                NIVision.newDirectByteBuffer(curvatureReal_addr, curvatureReal_numCurvatureReal * 8).asDoubleBuffer().get(this.curvatureReal);
            }
        }

        @Override
        public void write() {
            this.curvaturePixel_buf = ByteBuffer.allocateDirect(this.curvaturePixel.length * 8).order(ByteOrder.nativeOrder());
            this.curvaturePixel_buf.asDoubleBuffer().put(this.curvaturePixel).rewind();
            this.backing.putInt(4, this.curvaturePixel.length);
            NIVision.putPointer(this.backing, 0, this.curvaturePixel_buf);
            this.curvatureReal_buf = ByteBuffer.allocateDirect(this.curvatureReal.length * 8).order(ByteOrder.nativeOrder());
            this.curvatureReal_buf.asDoubleBuffer().put(this.curvatureReal).rewind();
            this.backing.putInt(12, this.curvatureReal.length);
            NIVision.putPointer(this.backing, 8, this.curvatureReal_buf);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ClassifyDistancesReport
    extends DisposedStruct {
        public ClassifiedDisparity[] classifiedDistances;
        private ByteBuffer classifiedDistances_buf;

        private void init() {
            this.classifiedDistances = new ClassifiedDisparity[0];
        }

        public ClassifyDistancesReport() {
            super(8);
            this.init();
        }

        public ClassifyDistancesReport(ClassifiedDisparity[] classifiedDistances) {
            super(8);
            this.classifiedDistances = classifiedDistances;
        }

        protected ClassifyDistancesReport(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected ClassifyDistancesReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            int classifiedDistances_numClassifiedDistances = this.backing.getInt(4);
            long classifiedDistances_addr = NIVision.getPointer(this.backing, 0);
            this.classifiedDistances = new ClassifiedDisparity[classifiedDistances_numClassifiedDistances];
            if (classifiedDistances_numClassifiedDistances > 0 && classifiedDistances_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(classifiedDistances_addr, classifiedDistances_numClassifiedDistances * 56);
                int i = 0;
                int off = 0;
                while (i < classifiedDistances_numClassifiedDistances) {
                    this.classifiedDistances[i] = new ClassifiedDisparity(bb, off);
                    this.classifiedDistances[i].read();
                    ++i;
                    off += 56;
                }
            }
        }

        @Override
        public void write() {
            this.classifiedDistances_buf = ByteBuffer.allocateDirect(this.classifiedDistances.length * 56).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.classifiedDistances.length) {
                this.classifiedDistances[i].setBuffer(this.classifiedDistances_buf, off);
                this.classifiedDistances[i].write();
                ++i;
                off += 56;
            }
            this.backing.putInt(4, this.classifiedDistances.length);
            NIVision.putPointer(this.backing, 0, this.classifiedDistances_buf);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class ClassifiedDisparity
    extends DisposedStruct {
        public double length;
        public double lengthReal;
        public double maxDistance;
        public double maxDistanceReal;
        public int label;
        public PointDouble[] templateSubsection;
        public PointDouble[] targetSubsection;
        private ByteBuffer templateSubsection_buf;
        private ByteBuffer targetSubsection_buf;

        private void init() {
            this.templateSubsection = new PointDouble[0];
            this.targetSubsection = new PointDouble[0];
        }

        public ClassifiedDisparity() {
            super(56);
            this.init();
        }

        public ClassifiedDisparity(double length, double lengthReal, double maxDistance, double maxDistanceReal, int label, PointDouble[] templateSubsection, PointDouble[] targetSubsection) {
            super(56);
            this.length = length;
            this.lengthReal = lengthReal;
            this.maxDistance = maxDistance;
            this.maxDistanceReal = maxDistanceReal;
            this.label = label;
            this.templateSubsection = templateSubsection;
            this.targetSubsection = targetSubsection;
        }

        protected ClassifiedDisparity(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected ClassifiedDisparity(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            this.length = this.backing.getDouble(0);
            this.lengthReal = this.backing.getDouble(8);
            this.maxDistance = this.backing.getDouble(16);
            this.maxDistanceReal = this.backing.getDouble(24);
            this.label = this.backing.getInt(32);
            int templateSubsection_numTemplateSubsection = this.backing.getInt(40);
            long templateSubsection_addr = NIVision.getPointer(this.backing, 36);
            this.templateSubsection = new PointDouble[templateSubsection_numTemplateSubsection];
            if (templateSubsection_numTemplateSubsection > 0 && templateSubsection_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(templateSubsection_addr, templateSubsection_numTemplateSubsection * 16);
                int i = 0;
                int off = 0;
                while (i < templateSubsection_numTemplateSubsection) {
                    this.templateSubsection[i] = new PointDouble(bb, off);
                    this.templateSubsection[i].read();
                    ++i;
                    off += 16;
                }
            }
            int targetSubsection_numTargetSubsection = this.backing.getInt(48);
            long targetSubsection_addr = NIVision.getPointer(this.backing, 44);
            this.targetSubsection = new PointDouble[targetSubsection_numTargetSubsection];
            if (targetSubsection_numTargetSubsection > 0 && targetSubsection_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(targetSubsection_addr, targetSubsection_numTargetSubsection * 16);
                int i = 0;
                int off = 0;
                while (i < targetSubsection_numTargetSubsection) {
                    this.targetSubsection[i] = new PointDouble(bb, off);
                    this.targetSubsection[i].read();
                    ++i;
                    off += 16;
                }
            }
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.length);
            this.backing.putDouble(8, this.lengthReal);
            this.backing.putDouble(16, this.maxDistance);
            this.backing.putDouble(24, this.maxDistanceReal);
            this.backing.putInt(32, this.label);
            this.templateSubsection_buf = ByteBuffer.allocateDirect(this.templateSubsection.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.templateSubsection.length) {
                this.templateSubsection[i].setBuffer(this.templateSubsection_buf, off);
                this.templateSubsection[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(40, this.templateSubsection.length);
            NIVision.putPointer(this.backing, 36, this.templateSubsection_buf);
            this.targetSubsection_buf = ByteBuffer.allocateDirect(this.targetSubsection.length * 16).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.targetSubsection.length) {
                this.targetSubsection[i].setBuffer(this.targetSubsection_buf, off);
                this.targetSubsection[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(48, this.targetSubsection.length);
            NIVision.putPointer(this.backing, 44, this.targetSubsection_buf);
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class MatchMode
    extends DisposedStruct {
        public int rotation;
        public int scale;
        public int occlusion;

        private void init() {
        }

        public MatchMode() {
            super(12);
            this.init();
        }

        public MatchMode(int rotation, int scale, int occlusion) {
            super(12);
            this.rotation = rotation;
            this.scale = scale;
            this.occlusion = occlusion;
        }

        protected MatchMode(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected MatchMode(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.rotation = this.backing.getInt(0);
            this.scale = this.backing.getInt(4);
            this.occlusion = this.backing.getInt(8);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.rotation);
            this.backing.putInt(4, this.scale);
            this.backing.putInt(8, this.occlusion);
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class ComputeDistancesReport
    extends DisposedStruct {
        public Disparity[] distances;
        public Disparity[] distancesReal;
        private ByteBuffer distances_buf;
        private ByteBuffer distancesReal_buf;

        private void init() {
            this.distances = new Disparity[0];
            this.distancesReal = new Disparity[0];
        }

        public ComputeDistancesReport() {
            super(16);
            this.init();
        }

        public ComputeDistancesReport(Disparity[] distances, Disparity[] distancesReal) {
            super(16);
            this.distances = distances;
            this.distancesReal = distancesReal;
        }

        protected ComputeDistancesReport(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ComputeDistancesReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            int distances_numDistances = this.backing.getInt(4);
            long distances_addr = NIVision.getPointer(this.backing, 0);
            this.distances = new Disparity[distances_numDistances];
            if (distances_numDistances > 0 && distances_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(distances_addr, distances_numDistances * 40);
                int i = 0;
                int off = 0;
                while (i < distances_numDistances) {
                    this.distances[i] = new Disparity(bb, off);
                    this.distances[i].read();
                    ++i;
                    off += 40;
                }
            }
            int distancesReal_numDistancesReal = this.backing.getInt(12);
            long distancesReal_addr = NIVision.getPointer(this.backing, 8);
            this.distancesReal = new Disparity[distancesReal_numDistancesReal];
            if (distancesReal_numDistancesReal > 0 && distancesReal_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(distancesReal_addr, distancesReal_numDistancesReal * 40);
                int i = 0;
                int off = 0;
                while (i < distancesReal_numDistancesReal) {
                    this.distancesReal[i] = new Disparity(bb, off);
                    this.distancesReal[i].read();
                    ++i;
                    off += 40;
                }
            }
        }

        @Override
        public void write() {
            this.distances_buf = ByteBuffer.allocateDirect(this.distances.length * 40).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.distances.length) {
                this.distances[i].setBuffer(this.distances_buf, off);
                this.distances[i].write();
                ++i;
                off += 40;
            }
            this.backing.putInt(4, this.distances.length);
            NIVision.putPointer(this.backing, 0, this.distances_buf);
            this.distancesReal_buf = ByteBuffer.allocateDirect(this.distancesReal.length * 40).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.distancesReal.length) {
                this.distancesReal[i].setBuffer(this.distancesReal_buf, off);
                this.distancesReal[i].write();
                ++i;
                off += 40;
            }
            this.backing.putInt(12, this.distancesReal.length);
            NIVision.putPointer(this.backing, 8, this.distancesReal_buf);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class Disparity
    extends DisposedStruct {
        public PointDouble current;
        public PointDouble reference;
        public double distance;

        private void init() {
            this.current = new PointDouble(this.backing, 0);
            this.reference = new PointDouble(this.backing, 16);
        }

        public Disparity() {
            super(40);
            this.init();
        }

        public Disparity(PointDouble current, PointDouble reference, double distance) {
            super(40);
            this.current = current;
            this.reference = reference;
            this.distance = distance;
        }

        protected Disparity(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected Disparity(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.current.read();
            this.reference.read();
            this.distance = this.backing.getDouble(32);
        }

        @Override
        public void write() {
            this.current.write();
            this.reference.write();
            this.backing.putDouble(32, this.distance);
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class CurvatureAnalysisReport
    extends DisposedStruct {
        public ClassifiedCurve[] curves;
        private ByteBuffer curves_buf;

        private void init() {
            this.curves = new ClassifiedCurve[0];
        }

        public CurvatureAnalysisReport() {
            super(8);
            this.init();
        }

        public CurvatureAnalysisReport(ClassifiedCurve[] curves) {
            super(8);
            this.curves = curves;
        }

        protected CurvatureAnalysisReport(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected CurvatureAnalysisReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            int curves_numCurves = this.backing.getInt(4);
            long curves_addr = NIVision.getPointer(this.backing, 0);
            this.curves = new ClassifiedCurve[curves_numCurves];
            if (curves_numCurves > 0 && curves_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(curves_addr, curves_numCurves * 48);
                int i = 0;
                int off = 0;
                while (i < curves_numCurves) {
                    this.curves[i] = new ClassifiedCurve(bb, off);
                    this.curves[i].read();
                    ++i;
                    off += 48;
                }
            }
        }

        @Override
        public void write() {
            this.curves_buf = ByteBuffer.allocateDirect(this.curves.length * 48).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.curves.length) {
                this.curves[i].setBuffer(this.curves_buf, off);
                this.curves[i].write();
                ++i;
                off += 48;
            }
            this.backing.putInt(4, this.curves.length);
            NIVision.putPointer(this.backing, 0, this.curves_buf);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class RangeLabel
    extends DisposedStruct {
        public RangeDouble range;
        public int label;

        private void init() {
            this.range = new RangeDouble(this.backing, 0);
        }

        public RangeLabel() {
            super(24);
            this.init();
        }

        public RangeLabel(RangeDouble range, int label) {
            super(24);
            this.range = range;
            this.label = label;
        }

        protected RangeLabel(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected RangeLabel(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.range.read();
            this.label = this.backing.getInt(16);
        }

        @Override
        public void write() {
            this.range.write();
            this.backing.putInt(16, this.label);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class RangeDouble
    extends DisposedStruct {
        public double minValue;
        public double maxValue;

        private void init() {
        }

        public RangeDouble() {
            super(16);
            this.init();
        }

        public RangeDouble(double minValue, double maxValue) {
            super(16);
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        protected RangeDouble(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected RangeDouble(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.minValue = this.backing.getDouble(0);
            this.maxValue = this.backing.getDouble(8);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.minValue);
            this.backing.putDouble(8, this.maxValue);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ClassifiedCurve
    extends DisposedStruct {
        public double length;
        public double lengthReal;
        public double maxCurvature;
        public double maxCurvatureReal;
        public int label;
        public PointDouble[] curvePoints;
        private ByteBuffer curvePoints_buf;

        private void init() {
            this.curvePoints = new PointDouble[0];
        }

        public ClassifiedCurve() {
            super(48);
            this.init();
        }

        public ClassifiedCurve(double length, double lengthReal, double maxCurvature, double maxCurvatureReal, int label, PointDouble[] curvePoints) {
            super(48);
            this.length = length;
            this.lengthReal = lengthReal;
            this.maxCurvature = maxCurvature;
            this.maxCurvatureReal = maxCurvatureReal;
            this.label = label;
            this.curvePoints = curvePoints;
        }

        protected ClassifiedCurve(ByteBuffer backing, int offset) {
            super(backing, offset, 48);
            this.init();
        }

        protected ClassifiedCurve(long nativeObj, boolean owned) {
            super(nativeObj, owned, 48);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 48);
        }

        @Override
        public void read() {
            this.length = this.backing.getDouble(0);
            this.lengthReal = this.backing.getDouble(8);
            this.maxCurvature = this.backing.getDouble(16);
            this.maxCurvatureReal = this.backing.getDouble(24);
            this.label = this.backing.getInt(32);
            int curvePoints_numCurvePoints = this.backing.getInt(40);
            long curvePoints_addr = NIVision.getPointer(this.backing, 36);
            this.curvePoints = new PointDouble[curvePoints_numCurvePoints];
            if (curvePoints_numCurvePoints > 0 && curvePoints_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(curvePoints_addr, curvePoints_numCurvePoints * 16);
                int i = 0;
                int off = 0;
                while (i < curvePoints_numCurvePoints) {
                    this.curvePoints[i] = new PointDouble(bb, off);
                    this.curvePoints[i].read();
                    ++i;
                    off += 16;
                }
            }
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.length);
            this.backing.putDouble(8, this.lengthReal);
            this.backing.putDouble(16, this.maxCurvature);
            this.backing.putDouble(24, this.maxCurvatureReal);
            this.backing.putInt(32, this.label);
            this.curvePoints_buf = ByteBuffer.allocateDirect(this.curvePoints.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.curvePoints.length) {
                this.curvePoints[i].setBuffer(this.curvePoints_buf, off);
                this.curvePoints[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(40, this.curvePoints.length);
            NIVision.putPointer(this.backing, 36, this.curvePoints_buf);
        }

        @Override
        public int size() {
            return 48;
        }
    }

    public static class ColorSegmenationOptions
    extends DisposedStruct {
        public int windowX;
        public int windowY;
        public int stepSize;
        public int minParticleArea;
        public int maxParticleArea;
        public short isFineSegment;

        private void init() {
        }

        public ColorSegmenationOptions() {
            super(24);
            this.init();
        }

        public ColorSegmenationOptions(int windowX, int windowY, int stepSize, int minParticleArea, int maxParticleArea, int isFineSegment) {
            super(24);
            this.windowX = windowX;
            this.windowY = windowY;
            this.stepSize = stepSize;
            this.minParticleArea = minParticleArea;
            this.maxParticleArea = maxParticleArea;
            this.isFineSegment = (short)isFineSegment;
        }

        protected ColorSegmenationOptions(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected ColorSegmenationOptions(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.windowX = this.backing.getInt(0);
            this.windowY = this.backing.getInt(4);
            this.stepSize = this.backing.getInt(8);
            this.minParticleArea = this.backing.getInt(12);
            this.maxParticleArea = this.backing.getInt(16);
            this.isFineSegment = this.backing.getShort(20);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.windowX);
            this.backing.putInt(4, this.windowY);
            this.backing.putInt(8, this.stepSize);
            this.backing.putInt(12, this.minParticleArea);
            this.backing.putInt(16, this.maxParticleArea);
            this.backing.putShort(20, this.isFineSegment);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class LabelToROIReport
    extends DisposedStruct {
        public ROI[] roiArray;
        public int[] labelsOutArray;
        public int[] isTooManyVectorsArray;
        private ByteBuffer roiArray_buf;
        private ByteBuffer labelsOutArray_buf;
        private ByteBuffer isTooManyVectorsArray_buf;

        private void init() {
            this.roiArray = new ROI[0];
            this.labelsOutArray = new int[0];
            this.isTooManyVectorsArray = new int[0];
        }

        public LabelToROIReport() {
            super(24);
            this.init();
        }

        public LabelToROIReport(ROI[] roiArray, int[] labelsOutArray, int[] isTooManyVectorsArray) {
            super(24);
            this.roiArray = roiArray;
            this.labelsOutArray = labelsOutArray;
            this.isTooManyVectorsArray = isTooManyVectorsArray;
        }

        protected LabelToROIReport(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected LabelToROIReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            int roiArray_numOfROIs = this.backing.getInt(4);
            long roiArray_addr = NIVision.getPointer(this.backing, 0);
            this.roiArray = new ROI[roiArray_numOfROIs];
            if (roiArray_numOfROIs > 0 && roiArray_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(roiArray_addr, roiArray_numOfROIs * 4);
                int i = 0;
                int off = 0;
                while (i < roiArray_numOfROIs) {
                    this.roiArray[i] = new ROI(NIVision.getPointer(bb, off), false);
                    ++i;
                    off += 4;
                }
            }
            int labelsOutArray_numOfLabels = this.backing.getInt(12);
            long labelsOutArray_addr = NIVision.getPointer(this.backing, 8);
            this.labelsOutArray = new int[labelsOutArray_numOfLabels];
            if (labelsOutArray_numOfLabels > 0 && labelsOutArray_addr != 0L) {
                NIVision.newDirectByteBuffer(labelsOutArray_addr, labelsOutArray_numOfLabels * 4).asIntBuffer().get(this.labelsOutArray);
            }
            int isTooManyVectorsArray_isTooManyVectorsArraySize = this.backing.getInt(20);
            long isTooManyVectorsArray_addr = NIVision.getPointer(this.backing, 16);
            this.isTooManyVectorsArray = new int[isTooManyVectorsArray_isTooManyVectorsArraySize];
            if (isTooManyVectorsArray_isTooManyVectorsArraySize > 0 && isTooManyVectorsArray_addr != 0L) {
                NIVision.newDirectByteBuffer(isTooManyVectorsArray_addr, isTooManyVectorsArray_isTooManyVectorsArraySize * 4).asIntBuffer().get(this.isTooManyVectorsArray);
            }
        }

        @Override
        public void write() {
            this.roiArray_buf = ByteBuffer.allocateDirect(this.roiArray.length * 4).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.roiArray.length) {
                NIVision.putPointer(this.roiArray_buf, off, this.roiArray[i]);
                ++i;
                off += 4;
            }
            this.backing.putInt(4, this.roiArray.length);
            NIVision.putPointer(this.backing, 0, this.roiArray_buf);
            this.labelsOutArray_buf = ByteBuffer.allocateDirect(this.labelsOutArray.length * 4).order(ByteOrder.nativeOrder());
            this.labelsOutArray_buf.asIntBuffer().put(this.labelsOutArray).rewind();
            this.backing.putInt(12, this.labelsOutArray.length);
            NIVision.putPointer(this.backing, 8, this.labelsOutArray_buf);
            this.isTooManyVectorsArray_buf = ByteBuffer.allocateDirect(this.isTooManyVectorsArray.length * 4).order(ByteOrder.nativeOrder());
            this.isTooManyVectorsArray_buf.asIntBuffer().put(this.isTooManyVectorsArray).rewind();
            this.backing.putInt(20, this.isTooManyVectorsArray.length);
            NIVision.putPointer(this.backing, 16, this.isTooManyVectorsArray_buf);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class SupervisedColorSegmentationReport
    extends DisposedStruct {
        public ROILabel[] labelOut;
        private ByteBuffer labelOut_buf;

        private void init() {
            this.labelOut = new ROILabel[0];
        }

        public SupervisedColorSegmentationReport() {
            super(8);
            this.init();
        }

        public SupervisedColorSegmentationReport(ROILabel[] labelOut) {
            super(8);
            this.labelOut = labelOut;
        }

        protected SupervisedColorSegmentationReport(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected SupervisedColorSegmentationReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            int labelOut_numLabelOut = this.backing.getInt(4);
            long labelOut_addr = NIVision.getPointer(this.backing, 0);
            this.labelOut = new ROILabel[labelOut_numLabelOut];
            if (labelOut_numLabelOut > 0 && labelOut_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(labelOut_addr, labelOut_numLabelOut * 8);
                int i = 0;
                int off = 0;
                while (i < labelOut_numLabelOut) {
                    this.labelOut[i] = new ROILabel(bb, off);
                    this.labelOut[i].read();
                    ++i;
                    off += 8;
                }
            }
        }

        @Override
        public void write() {
            this.labelOut_buf = ByteBuffer.allocateDirect(this.labelOut.length * 8).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.labelOut.length) {
                this.labelOut[i].setBuffer(this.labelOut_buf, off);
                this.labelOut[i].write();
                ++i;
                off += 8;
            }
            this.backing.putInt(4, this.labelOut.length);
            NIVision.putPointer(this.backing, 0, this.labelOut_buf);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class ROILabel
    extends DisposedStruct {
        public String className;
        public int label;
        private ByteBuffer className_buf;

        private void init() {
        }

        public ROILabel() {
            super(8);
            this.init();
        }

        public ROILabel(String className, int label) {
            super(8);
            this.className = className;
            this.label = label;
        }

        protected ROILabel(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected ROILabel(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            long className_addr = NIVision.getPointer(this.backing, 0);
            if (className_addr == 0L) {
                this.className = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(className_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.className = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.className = "";
                }
            }
            this.label = this.backing.getInt(4);
        }

        @Override
        public void write() {
            if (this.className != null) {
                byte[] className_bytes;
                try {
                    className_bytes = this.className.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    className_bytes = new byte[]{};
                }
                this.className_buf = ByteBuffer.allocateDirect(className_bytes.length + 1);
                NIVision.putBytes(this.className_buf, className_bytes, 0, className_bytes.length).put(className_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 0, this.className == null ? 0L : NIVision.getByteBufferAddress(this.className_buf));
            this.backing.putInt(4, this.label);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class ContourInfoReport
    extends DisposedStruct {
        public PointDouble[] pointsPixel;
        public PointDouble[] pointsReal;
        public double[] curvaturePixel;
        public double[] curvatureReal;
        public double length;
        public double lengthReal;
        public int hasEquation;
        private ByteBuffer pointsPixel_buf;
        private ByteBuffer pointsReal_buf;
        private ByteBuffer curvaturePixel_buf;
        private ByteBuffer curvatureReal_buf;

        private void init() {
            this.pointsPixel = new PointDouble[0];
            this.pointsReal = new PointDouble[0];
            this.curvaturePixel = new double[0];
            this.curvatureReal = new double[0];
        }

        public ContourInfoReport() {
            super(56);
            this.init();
        }

        public ContourInfoReport(PointDouble[] pointsPixel, PointDouble[] pointsReal, double[] curvaturePixel, double[] curvatureReal, double length, double lengthReal, int hasEquation) {
            super(56);
            this.pointsPixel = pointsPixel;
            this.pointsReal = pointsReal;
            this.curvaturePixel = curvaturePixel;
            this.curvatureReal = curvatureReal;
            this.length = length;
            this.lengthReal = lengthReal;
            this.hasEquation = hasEquation;
        }

        protected ContourInfoReport(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected ContourInfoReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            int pointsPixel_numPointsPixel = this.backing.getInt(4);
            long pointsPixel_addr = NIVision.getPointer(this.backing, 0);
            this.pointsPixel = new PointDouble[pointsPixel_numPointsPixel];
            if (pointsPixel_numPointsPixel > 0 && pointsPixel_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(pointsPixel_addr, pointsPixel_numPointsPixel * 16);
                int i = 0;
                int off = 0;
                while (i < pointsPixel_numPointsPixel) {
                    this.pointsPixel[i] = new PointDouble(bb, off);
                    this.pointsPixel[i].read();
                    ++i;
                    off += 16;
                }
            }
            int pointsReal_numPointsReal = this.backing.getInt(12);
            long pointsReal_addr = NIVision.getPointer(this.backing, 8);
            this.pointsReal = new PointDouble[pointsReal_numPointsReal];
            if (pointsReal_numPointsReal > 0 && pointsReal_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(pointsReal_addr, pointsReal_numPointsReal * 16);
                int i = 0;
                int off = 0;
                while (i < pointsReal_numPointsReal) {
                    this.pointsReal[i] = new PointDouble(bb, off);
                    this.pointsReal[i].read();
                    ++i;
                    off += 16;
                }
            }
            int curvaturePixel_numCurvaturePixel = this.backing.getInt(20);
            long curvaturePixel_addr = NIVision.getPointer(this.backing, 16);
            this.curvaturePixel = new double[curvaturePixel_numCurvaturePixel];
            if (curvaturePixel_numCurvaturePixel > 0 && curvaturePixel_addr != 0L) {
                NIVision.newDirectByteBuffer(curvaturePixel_addr, curvaturePixel_numCurvaturePixel * 8).asDoubleBuffer().get(this.curvaturePixel);
            }
            int curvatureReal_numCurvatureReal = this.backing.getInt(28);
            long curvatureReal_addr = NIVision.getPointer(this.backing, 24);
            this.curvatureReal = new double[curvatureReal_numCurvatureReal];
            if (curvatureReal_numCurvatureReal > 0 && curvatureReal_addr != 0L) {
                NIVision.newDirectByteBuffer(curvatureReal_addr, curvatureReal_numCurvatureReal * 8).asDoubleBuffer().get(this.curvatureReal);
            }
            this.length = this.backing.getDouble(32);
            this.lengthReal = this.backing.getDouble(40);
            this.hasEquation = this.backing.getInt(48);
        }

        @Override
        public void write() {
            this.pointsPixel_buf = ByteBuffer.allocateDirect(this.pointsPixel.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.pointsPixel.length) {
                this.pointsPixel[i].setBuffer(this.pointsPixel_buf, off);
                this.pointsPixel[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(4, this.pointsPixel.length);
            NIVision.putPointer(this.backing, 0, this.pointsPixel_buf);
            this.pointsReal_buf = ByteBuffer.allocateDirect(this.pointsReal.length * 16).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.pointsReal.length) {
                this.pointsReal[i].setBuffer(this.pointsReal_buf, off);
                this.pointsReal[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(12, this.pointsReal.length);
            NIVision.putPointer(this.backing, 8, this.pointsReal_buf);
            this.curvaturePixel_buf = ByteBuffer.allocateDirect(this.curvaturePixel.length * 8).order(ByteOrder.nativeOrder());
            this.curvaturePixel_buf.asDoubleBuffer().put(this.curvaturePixel).rewind();
            this.backing.putInt(20, this.curvaturePixel.length);
            NIVision.putPointer(this.backing, 16, this.curvaturePixel_buf);
            this.curvatureReal_buf = ByteBuffer.allocateDirect(this.curvatureReal.length * 8).order(ByteOrder.nativeOrder());
            this.curvatureReal_buf.asDoubleBuffer().put(this.curvatureReal).rewind();
            this.backing.putInt(28, this.curvatureReal.length);
            NIVision.putPointer(this.backing, 24, this.curvatureReal_buf);
            this.backing.putDouble(32, this.length);
            this.backing.putDouble(40, this.lengthReal);
            this.backing.putInt(48, this.hasEquation);
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class GeometricAdvancedSetupDataOption
    extends DisposedStruct {
        public GeometricSetupDataItem type;
        public double value;

        private void init() {
        }

        public GeometricAdvancedSetupDataOption() {
            super(16);
            this.init();
        }

        public GeometricAdvancedSetupDataOption(GeometricSetupDataItem type, double value) {
            super(16);
            this.type = type;
            this.value = value;
        }

        protected GeometricAdvancedSetupDataOption(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected GeometricAdvancedSetupDataOption(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.type = GeometricSetupDataItem.fromValue(this.backing.getInt(0));
            this.value = this.backing.getDouble(8);
        }

        @Override
        public void write() {
            if (this.type != null) {
                this.backing.putInt(0, this.type.getValue());
            }
            this.backing.putDouble(8, this.value);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class RangeSettingDouble
    extends DisposedStruct {
        public SettingType settingType;
        public double min;
        public double max;

        private void init() {
        }

        public RangeSettingDouble() {
            super(24);
            this.init();
        }

        public RangeSettingDouble(SettingType settingType, double min, double max) {
            super(24);
            this.settingType = settingType;
            this.min = min;
            this.max = max;
        }

        protected RangeSettingDouble(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected RangeSettingDouble(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.settingType = SettingType.fromValue(this.backing.getInt(0));
            this.min = this.backing.getDouble(8);
            this.max = this.backing.getDouble(16);
        }

        @Override
        public void write() {
            if (this.settingType != null) {
                this.backing.putInt(0, this.settingType.getValue());
            }
            this.backing.putDouble(8, this.min);
            this.backing.putDouble(16, this.max);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class SetupMatchPatternData
    extends DisposedStruct {
        public byte[] matchSetupData;
        private ByteBuffer matchSetupData_buf;

        private void init() {
            this.matchSetupData = new byte[0];
        }

        public SetupMatchPatternData() {
            super(8);
            this.init();
        }

        public SetupMatchPatternData(byte[] matchSetupData) {
            super(8);
            this.matchSetupData = matchSetupData;
        }

        protected SetupMatchPatternData(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected SetupMatchPatternData(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            int matchSetupData_numMatchSetupData = this.backing.getInt(4);
            long matchSetupData_addr = NIVision.getPointer(this.backing, 0);
            this.matchSetupData = new byte[matchSetupData_numMatchSetupData];
            if (matchSetupData_numMatchSetupData > 0 && matchSetupData_addr != 0L) {
                NIVision.getBytes(NIVision.newDirectByteBuffer(matchSetupData_addr, matchSetupData_numMatchSetupData), this.matchSetupData, 0, matchSetupData_numMatchSetupData);
            }
        }

        @Override
        public void write() {
            this.matchSetupData_buf = ByteBuffer.allocateDirect(this.matchSetupData.length);
            NIVision.putBytes(this.matchSetupData_buf, this.matchSetupData, 0, this.matchSetupData.length);
            this.backing.putInt(4, this.matchSetupData.length);
            NIVision.putPointer(this.backing, 0, this.matchSetupData_buf);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class PartialEllipse
    extends DisposedStruct {
        public PointFloat center;
        public double angle;
        public double majorRadius;
        public double minorRadius;
        public double startAngle;
        public double endAngle;

        private void init() {
            this.center = new PointFloat(this.backing, 0);
        }

        public PartialEllipse() {
            super(48);
            this.init();
        }

        public PartialEllipse(PointFloat center, double angle, double majorRadius, double minorRadius, double startAngle, double endAngle) {
            super(48);
            this.center = center;
            this.angle = angle;
            this.majorRadius = majorRadius;
            this.minorRadius = minorRadius;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        protected PartialEllipse(ByteBuffer backing, int offset) {
            super(backing, offset, 48);
            this.init();
        }

        protected PartialEllipse(long nativeObj, boolean owned) {
            super(nativeObj, owned, 48);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 48);
        }

        @Override
        public void read() {
            this.center.read();
            this.angle = this.backing.getDouble(8);
            this.majorRadius = this.backing.getDouble(16);
            this.minorRadius = this.backing.getDouble(24);
            this.startAngle = this.backing.getDouble(32);
            this.endAngle = this.backing.getDouble(40);
        }

        @Override
        public void write() {
            this.center.write();
            this.backing.putDouble(8, this.angle);
            this.backing.putDouble(16, this.majorRadius);
            this.backing.putDouble(24, this.minorRadius);
            this.backing.putDouble(32, this.startAngle);
            this.backing.putDouble(40, this.endAngle);
        }

        @Override
        public int size() {
            return 48;
        }
    }

    public static class PartialCircle
    extends DisposedStruct {
        public PointFloat center;
        public double radius;
        public double startAngle;
        public double endAngle;

        private void init() {
            this.center = new PointFloat(this.backing, 0);
        }

        public PartialCircle() {
            super(32);
            this.init();
        }

        public PartialCircle(PointFloat center, double radius, double startAngle, double endAngle) {
            super(32);
            this.center = center;
            this.radius = radius;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        protected PartialCircle(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected PartialCircle(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.center.read();
            this.radius = this.backing.getDouble(8);
            this.startAngle = this.backing.getDouble(16);
            this.endAngle = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.center.write();
            this.backing.putDouble(8, this.radius);
            this.backing.putDouble(16, this.startAngle);
            this.backing.putDouble(24, this.endAngle);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class ContourFitPolynomialReport
    extends DisposedStruct {
        public PointDouble[] bestFit;
        public double[] polynomialCoefficients;
        private ByteBuffer bestFit_buf;
        private ByteBuffer polynomialCoefficients_buf;

        private void init() {
            this.bestFit = new PointDouble[0];
            this.polynomialCoefficients = new double[0];
        }

        public ContourFitPolynomialReport() {
            super(16);
            this.init();
        }

        public ContourFitPolynomialReport(PointDouble[] bestFit, double[] polynomialCoefficients) {
            super(16);
            this.bestFit = bestFit;
            this.polynomialCoefficients = polynomialCoefficients;
        }

        protected ContourFitPolynomialReport(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ContourFitPolynomialReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            int bestFit_numberOfPoints = this.backing.getInt(4);
            long bestFit_addr = NIVision.getPointer(this.backing, 0);
            this.bestFit = new PointDouble[bestFit_numberOfPoints];
            if (bestFit_numberOfPoints > 0 && bestFit_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(bestFit_addr, bestFit_numberOfPoints * 16);
                int i = 0;
                int off = 0;
                while (i < bestFit_numberOfPoints) {
                    this.bestFit[i] = new PointDouble(bb, off);
                    this.bestFit[i].read();
                    ++i;
                    off += 16;
                }
            }
            int polynomialCoefficients_numberOfCoefficients = this.backing.getInt(12);
            long polynomialCoefficients_addr = NIVision.getPointer(this.backing, 8);
            this.polynomialCoefficients = new double[polynomialCoefficients_numberOfCoefficients];
            if (polynomialCoefficients_numberOfCoefficients > 0 && polynomialCoefficients_addr != 0L) {
                NIVision.newDirectByteBuffer(polynomialCoefficients_addr, polynomialCoefficients_numberOfCoefficients * 8).asDoubleBuffer().get(this.polynomialCoefficients);
            }
        }

        @Override
        public void write() {
            this.bestFit_buf = ByteBuffer.allocateDirect(this.bestFit.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.bestFit.length) {
                this.bestFit[i].setBuffer(this.bestFit_buf, off);
                this.bestFit[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(4, this.bestFit.length);
            NIVision.putPointer(this.backing, 0, this.bestFit_buf);
            this.polynomialCoefficients_buf = ByteBuffer.allocateDirect(this.polynomialCoefficients.length * 8).order(ByteOrder.nativeOrder());
            this.polynomialCoefficients_buf.asDoubleBuffer().put(this.polynomialCoefficients).rewind();
            this.backing.putInt(12, this.polynomialCoefficients.length);
            NIVision.putPointer(this.backing, 8, this.polynomialCoefficients_buf);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ContourFitLineReport
    extends DisposedStruct {
        public LineFloat lineSegment;
        public LineEquation lineEquation;

        private void init() {
            this.lineSegment = new LineFloat(this.backing, 0);
            this.lineEquation = new LineEquation(this.backing, 16);
        }

        public ContourFitLineReport() {
            super(40);
            this.init();
        }

        public ContourFitLineReport(LineFloat lineSegment, LineEquation lineEquation) {
            super(40);
            this.lineSegment = lineSegment;
            this.lineEquation = lineEquation;
        }

        protected ContourFitLineReport(ByteBuffer backing, int offset) {
            super(backing, offset, 40);
            this.init();
        }

        protected ContourFitLineReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 40);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 40);
        }

        @Override
        public void read() {
            this.lineSegment.read();
            this.lineEquation.read();
        }

        @Override
        public void write() {
            this.lineSegment.write();
            this.lineEquation.write();
        }

        @Override
        public int size() {
            return 40;
        }
    }

    public static class LineEquation
    extends DisposedStruct {
        public double a;
        public double b;
        public double c;

        private void init() {
        }

        public LineEquation() {
            super(24);
            this.init();
        }

        public LineEquation(double a, double b, double c) {
            super(24);
            this.a = a;
            this.b = b;
            this.c = c;
        }

        protected LineEquation(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected LineEquation(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.a = this.backing.getDouble(0);
            this.b = this.backing.getDouble(8);
            this.c = this.backing.getDouble(16);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.a);
            this.backing.putDouble(8, this.b);
            this.backing.putDouble(16, this.c);
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class LineFloat
    extends DisposedStruct {
        public PointFloat start;
        public PointFloat end;

        private void init() {
            this.start = new PointFloat(this.backing, 0);
            this.end = new PointFloat(this.backing, 8);
        }

        public LineFloat() {
            super(16);
            this.init();
        }

        public LineFloat(PointFloat start, PointFloat end) {
            super(16);
            this.start = start;
            this.end = end;
        }

        protected LineFloat(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected LineFloat(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.start.read();
            this.end.read();
        }

        @Override
        public void write() {
            this.start.write();
            this.end.write();
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ContourFitSplineReport
    extends DisposedStruct {
        public PointDouble[] points;
        private ByteBuffer points_buf;

        private void init() {
            this.points = new PointDouble[0];
        }

        public ContourFitSplineReport() {
            super(8);
            this.init();
        }

        public ContourFitSplineReport(PointDouble[] points) {
            super(8);
            this.points = points;
        }

        protected ContourFitSplineReport(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected ContourFitSplineReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            int points_numberOfPoints = this.backing.getInt(4);
            long points_addr = NIVision.getPointer(this.backing, 0);
            this.points = new PointDouble[points_numberOfPoints];
            if (points_numberOfPoints > 0 && points_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(points_addr, points_numberOfPoints * 16);
                int i = 0;
                int off = 0;
                while (i < points_numberOfPoints) {
                    this.points[i] = new PointDouble(bb, off);
                    this.points[i].read();
                    ++i;
                    off += 16;
                }
            }
        }

        @Override
        public void write() {
            this.points_buf = ByteBuffer.allocateDirect(this.points.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.points.length) {
                this.points[i].setBuffer(this.points_buf, off);
                this.points[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(4, this.points.length);
            NIVision.putPointer(this.backing, 0, this.points_buf);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class ClampMax2Report
    extends DisposedStruct {
        public ClampResults clampResults;
        public ClampPoints clampPoints;
        public int calibrationValid;

        private void init() {
            this.clampResults = new ClampResults(this.backing, 0);
            this.clampPoints = new ClampPoints(this.backing, 32);
        }

        public ClampMax2Report() {
            super(104);
            this.init();
        }

        public ClampMax2Report(ClampResults clampResults, ClampPoints clampPoints, int calibrationValid) {
            super(104);
            this.clampResults = clampResults;
            this.clampPoints = clampPoints;
            this.calibrationValid = calibrationValid;
        }

        protected ClampMax2Report(ByteBuffer backing, int offset) {
            super(backing, offset, 104);
            this.init();
        }

        protected ClampMax2Report(long nativeObj, boolean owned) {
            super(nativeObj, owned, 104);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 104);
        }

        @Override
        public void read() {
            this.clampResults.read();
            this.clampPoints.read();
            this.calibrationValid = this.backing.getInt(96);
        }

        @Override
        public void write() {
            this.clampResults.write();
            this.clampPoints.write();
            this.backing.putInt(96, this.calibrationValid);
        }

        @Override
        public int size() {
            return 104;
        }
    }

    public static class ClampOverlaySettings
    extends DisposedStruct {
        public int showSearchArea;
        public int showCurves;
        public int showClampLocation;
        public int showResult;
        public RGBValue searchAreaColor;
        public RGBValue curvesColor;
        public RGBValue clampLocationsColor;
        public RGBValue resultColor;
        public String overlayGroupName;
        private ByteBuffer overlayGroupName_buf;

        private void init() {
            this.searchAreaColor = new RGBValue(this.backing, 16);
            this.curvesColor = new RGBValue(this.backing, 20);
            this.clampLocationsColor = new RGBValue(this.backing, 24);
            this.resultColor = new RGBValue(this.backing, 28);
        }

        public ClampOverlaySettings() {
            super(36);
            this.init();
        }

        public ClampOverlaySettings(int showSearchArea, int showCurves, int showClampLocation, int showResult, RGBValue searchAreaColor, RGBValue curvesColor, RGBValue clampLocationsColor, RGBValue resultColor, String overlayGroupName) {
            super(36);
            this.showSearchArea = showSearchArea;
            this.showCurves = showCurves;
            this.showClampLocation = showClampLocation;
            this.showResult = showResult;
            this.searchAreaColor = searchAreaColor;
            this.curvesColor = curvesColor;
            this.clampLocationsColor = clampLocationsColor;
            this.resultColor = resultColor;
            this.overlayGroupName = overlayGroupName;
        }

        protected ClampOverlaySettings(ByteBuffer backing, int offset) {
            super(backing, offset, 36);
            this.init();
        }

        protected ClampOverlaySettings(long nativeObj, boolean owned) {
            super(nativeObj, owned, 36);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 36);
        }

        @Override
        public void read() {
            this.showSearchArea = this.backing.getInt(0);
            this.showCurves = this.backing.getInt(4);
            this.showClampLocation = this.backing.getInt(8);
            this.showResult = this.backing.getInt(12);
            this.searchAreaColor.read();
            this.curvesColor.read();
            this.clampLocationsColor.read();
            this.resultColor.read();
            long overlayGroupName_addr = NIVision.getPointer(this.backing, 32);
            if (overlayGroupName_addr == 0L) {
                this.overlayGroupName = null;
            } else {
                ByteBuffer bb = NIVision.newDirectByteBuffer(overlayGroupName_addr, 1000);
                while (bb.get() != 0) {
                }
                byte[] bytes = new byte[bb.position() - 1];
                NIVision.getBytes(bb, bytes, 0, bytes.length);
                try {
                    this.overlayGroupName = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.overlayGroupName = "";
                }
            }
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.showSearchArea);
            this.backing.putInt(4, this.showCurves);
            this.backing.putInt(8, this.showClampLocation);
            this.backing.putInt(12, this.showResult);
            this.searchAreaColor.write();
            this.curvesColor.write();
            this.clampLocationsColor.write();
            this.resultColor.write();
            if (this.overlayGroupName != null) {
                byte[] overlayGroupName_bytes;
                try {
                    overlayGroupName_bytes = this.overlayGroupName.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    overlayGroupName_bytes = new byte[]{};
                }
                this.overlayGroupName_buf = ByteBuffer.allocateDirect(overlayGroupName_bytes.length + 1);
                NIVision.putBytes(this.overlayGroupName_buf, overlayGroupName_bytes, 0, overlayGroupName_bytes.length).put(overlayGroupName_bytes.length, (byte)0);
            }
            NIVision.putPointer(this.backing, 32, this.overlayGroupName == null ? 0L : NIVision.getByteBufferAddress(this.overlayGroupName_buf));
        }

        @Override
        public int size() {
            return 36;
        }
    }

    public static class RGBValue
    extends DisposedStruct {
        public short B;
        public short G;
        public short R;
        public short alpha;

        private void init() {
        }

        public RGBValue() {
            super(4);
            this.init();
        }

        public RGBValue(int B, int G, int R, int alpha) {
            super(4);
            this.B = (short)B;
            this.G = (short)G;
            this.R = (short)R;
            this.alpha = (short)alpha;
        }

        protected RGBValue(ByteBuffer backing, int offset) {
            super(backing, offset, 4);
            this.init();
        }

        protected RGBValue(long nativeObj, boolean owned) {
            super(nativeObj, owned, 4);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 4);
        }

        @Override
        public void read() {
            this.B = (short)(this.backing.get(0) & 0xFF);
            this.G = (short)(this.backing.get(1) & 0xFF);
            this.R = (short)(this.backing.get(2) & 0xFF);
            this.alpha = (short)(this.backing.get(3) & 0xFF);
        }

        @Override
        public void write() {
            this.backing.put(0, (byte)(this.B & 0xFF));
            this.backing.put(1, (byte)(this.G & 0xFF));
            this.backing.put(2, (byte)(this.R & 0xFF));
            this.backing.put(3, (byte)(this.alpha & 0xFF));
        }

        @Override
        public int size() {
            return 4;
        }
    }

    public static class ClampPoints
    extends DisposedStruct {
        public PointDoublePair pixel;
        public PointDoublePair realWorld;

        private void init() {
            this.pixel = new PointDoublePair(this.backing, 0);
            this.realWorld = new PointDoublePair(this.backing, 32);
        }

        public ClampPoints() {
            super(64);
            this.init();
        }

        public ClampPoints(PointDoublePair pixel, PointDoublePair realWorld) {
            super(64);
            this.pixel = pixel;
            this.realWorld = realWorld;
        }

        protected ClampPoints(ByteBuffer backing, int offset) {
            super(backing, offset, 64);
            this.init();
        }

        protected ClampPoints(long nativeObj, boolean owned) {
            super(nativeObj, owned, 64);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 64);
        }

        @Override
        public void read() {
            this.pixel.read();
            this.realWorld.read();
        }

        @Override
        public void write() {
            this.pixel.write();
            this.realWorld.write();
        }

        @Override
        public int size() {
            return 64;
        }
    }

    public static class ClampResults
    extends DisposedStruct {
        public double distancePix;
        public double distanceRealWorld;
        public double angleAbs;
        public double angleRelative;

        private void init() {
        }

        public ClampResults() {
            super(32);
            this.init();
        }

        public ClampResults(double distancePix, double distanceRealWorld, double angleAbs, double angleRelative) {
            super(32);
            this.distancePix = distancePix;
            this.distanceRealWorld = distanceRealWorld;
            this.angleAbs = angleAbs;
            this.angleRelative = angleRelative;
        }

        protected ClampResults(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected ClampResults(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.distancePix = this.backing.getDouble(0);
            this.distanceRealWorld = this.backing.getDouble(8);
            this.angleAbs = this.backing.getDouble(16);
            this.angleRelative = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.distancePix);
            this.backing.putDouble(8, this.distanceRealWorld);
            this.backing.putDouble(16, this.angleAbs);
            this.backing.putDouble(24, this.angleRelative);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class PointDoublePair
    extends DisposedStruct {
        public PointDouble start;
        public PointDouble end;

        private void init() {
            this.start = new PointDouble(this.backing, 0);
            this.end = new PointDouble(this.backing, 16);
        }

        public PointDoublePair() {
            super(32);
            this.init();
        }

        public PointDoublePair(PointDouble start, PointDouble end) {
            super(32);
            this.start = start;
            this.end = end;
        }

        protected PointDoublePair(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected PointDoublePair(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.start.read();
            this.end.read();
        }

        @Override
        public void write() {
            this.start.write();
            this.end.write();
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class PointDouble
    extends DisposedStruct {
        public double x;
        public double y;

        private void init() {
        }

        public PointDouble() {
            super(16);
            this.init();
        }

        public PointDouble(double x, double y) {
            super(16);
            this.x = x;
            this.y = y;
        }

        protected PointDouble(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected PointDouble(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.x = this.backing.getDouble(0);
            this.y = this.backing.getDouble(8);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.x);
            this.backing.putDouble(8, this.y);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class ClampSettings
    extends DisposedStruct {
        public double angleRange;
        public EdgePolarity edgePolarity;

        private void init() {
            this.edgePolarity = new EdgePolarity(this.backing, 8);
        }

        public ClampSettings() {
            super(16);
            this.init();
        }

        public ClampSettings(double angleRange, EdgePolarity edgePolarity) {
            super(16);
            this.angleRange = angleRange;
            this.edgePolarity = edgePolarity;
        }

        protected ClampSettings(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected ClampSettings(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.angleRange = this.backing.getDouble(0);
            this.edgePolarity.read();
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.angleRange);
            this.edgePolarity.write();
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class EdgePolarity
    extends DisposedStruct {
        public EdgePolaritySearchMode start;
        public EdgePolaritySearchMode end;

        private void init() {
        }

        public EdgePolarity() {
            super(8);
            this.init();
        }

        public EdgePolarity(EdgePolaritySearchMode start, EdgePolaritySearchMode end) {
            super(8);
            this.start = start;
            this.end = end;
        }

        protected EdgePolarity(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected EdgePolarity(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.start = EdgePolaritySearchMode.fromValue(this.backing.getInt(0));
            this.end = EdgePolaritySearchMode.fromValue(this.backing.getInt(4));
        }

        @Override
        public void write() {
            if (this.start != null) {
                this.backing.putInt(0, this.start.getValue());
            }
            if (this.end != null) {
                this.backing.putInt(4, this.end.getValue());
            }
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class GetCalibrationInfoReport
    extends DisposedStruct {
        public ROI userRoi;
        public ROI calibrationRoi;
        public CalibrationAxisInfo axisInfo;
        public CalibrationLearnSetupInfo learnSetupInfo;
        public GridDescriptor gridDescriptor;
        public int errorMapRows;
        public int errorMapCols;
        public ErrorStatistics errorStatistics;

        private void init() {
            this.axisInfo = new CalibrationAxisInfo(this.backing, 8);
            this.learnSetupInfo = new CalibrationLearnSetupInfo(this.backing, 24);
            this.gridDescriptor = new GridDescriptor(this.backing, 44);
            this.errorStatistics = new ErrorStatistics(this.backing, 72);
        }

        public GetCalibrationInfoReport() {
            super(104);
            this.init();
        }

        public GetCalibrationInfoReport(ROI userRoi, ROI calibrationRoi, CalibrationAxisInfo axisInfo, CalibrationLearnSetupInfo learnSetupInfo, GridDescriptor gridDescriptor, int errorMapRows, int errorMapCols, ErrorStatistics errorStatistics) {
            super(104);
            this.userRoi = userRoi;
            this.calibrationRoi = calibrationRoi;
            this.axisInfo = axisInfo;
            this.learnSetupInfo = learnSetupInfo;
            this.gridDescriptor = gridDescriptor;
            this.errorMapRows = errorMapRows;
            this.errorMapCols = errorMapCols;
            this.errorStatistics = errorStatistics;
        }

        protected GetCalibrationInfoReport(ByteBuffer backing, int offset) {
            super(backing, offset, 104);
            this.init();
        }

        protected GetCalibrationInfoReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 104);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 104);
        }

        @Override
        public void read() {
            long userRoi_addr = NIVision.getPointer(this.backing, 0);
            this.userRoi = userRoi_addr == 0L ? null : new ROI(userRoi_addr, false);
            long calibrationRoi_addr = NIVision.getPointer(this.backing, 4);
            this.calibrationRoi = calibrationRoi_addr == 0L ? null : new ROI(calibrationRoi_addr, false);
            this.axisInfo.read();
            this.learnSetupInfo.read();
            this.gridDescriptor.read();
            this.errorMapRows = this.backing.getInt(60);
            this.errorMapCols = this.backing.getInt(64);
            this.errorStatistics.read();
        }

        @Override
        public void write() {
            NIVision.putPointer(this.backing, 0, this.userRoi);
            NIVision.putPointer(this.backing, 4, this.calibrationRoi);
            this.axisInfo.write();
            this.learnSetupInfo.write();
            this.gridDescriptor.write();
            this.backing.putInt(60, this.errorMapRows);
            this.backing.putInt(64, this.errorMapCols);
            this.errorStatistics.write();
        }

        @Override
        public int size() {
            return 104;
        }
    }

    public static class ErrorStatistics
    extends DisposedStruct {
        public double mean;
        public double maximum;
        public double standardDeviation;
        public double distortion;

        private void init() {
        }

        public ErrorStatistics() {
            super(32);
            this.init();
        }

        public ErrorStatistics(double mean, double maximum, double standardDeviation, double distortion) {
            super(32);
            this.mean = mean;
            this.maximum = maximum;
            this.standardDeviation = standardDeviation;
            this.distortion = distortion;
        }

        protected ErrorStatistics(ByteBuffer backing, int offset) {
            super(backing, offset, 32);
            this.init();
        }

        protected ErrorStatistics(long nativeObj, boolean owned) {
            super(nativeObj, owned, 32);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 32);
        }

        @Override
        public void read() {
            this.mean = this.backing.getDouble(0);
            this.maximum = this.backing.getDouble(8);
            this.standardDeviation = this.backing.getDouble(16);
            this.distortion = this.backing.getDouble(24);
        }

        @Override
        public void write() {
            this.backing.putDouble(0, this.mean);
            this.backing.putDouble(8, this.maximum);
            this.backing.putDouble(16, this.standardDeviation);
            this.backing.putDouble(24, this.distortion);
        }

        @Override
        public int size() {
            return 32;
        }
    }

    public static class GridDescriptor
    extends DisposedStruct {
        public float xStep;
        public float yStep;
        public CalibrationUnit unit;

        private void init() {
        }

        public GridDescriptor() {
            super(12);
            this.init();
        }

        public GridDescriptor(double xStep, double yStep, CalibrationUnit unit) {
            super(12);
            this.xStep = (float)xStep;
            this.yStep = (float)yStep;
            this.unit = unit;
        }

        protected GridDescriptor(ByteBuffer backing, int offset) {
            super(backing, offset, 12);
            this.init();
        }

        protected GridDescriptor(long nativeObj, boolean owned) {
            super(nativeObj, owned, 12);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 12);
        }

        @Override
        public void read() {
            this.xStep = this.backing.getFloat(0);
            this.yStep = this.backing.getFloat(4);
            this.unit = CalibrationUnit.fromValue(this.backing.getInt(8));
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.xStep);
            this.backing.putFloat(4, this.yStep);
            if (this.unit != null) {
                this.backing.putInt(8, this.unit.getValue());
            }
        }

        @Override
        public int size() {
            return 12;
        }
    }

    public static class CalibrationLearnSetupInfo
    extends DisposedStruct {
        public CalibrationMode2 calibrationMethod;
        public DistortionModel distortionModel;
        public ScalingMethod scaleMode;
        public CalibrationROI roiMode;
        public byte learnCorrectionTable;

        private void init() {
        }

        public CalibrationLearnSetupInfo() {
            super(20);
            this.init();
        }

        public CalibrationLearnSetupInfo(CalibrationMode2 calibrationMethod, DistortionModel distortionModel, ScalingMethod scaleMode, CalibrationROI roiMode, byte learnCorrectionTable) {
            super(20);
            this.calibrationMethod = calibrationMethod;
            this.distortionModel = distortionModel;
            this.scaleMode = scaleMode;
            this.roiMode = roiMode;
            this.learnCorrectionTable = learnCorrectionTable;
        }

        protected CalibrationLearnSetupInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected CalibrationLearnSetupInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.calibrationMethod = CalibrationMode2.fromValue(this.backing.getInt(0));
            this.distortionModel = DistortionModel.fromValue(this.backing.getInt(4));
            this.scaleMode = ScalingMethod.fromValue(this.backing.getInt(8));
            this.roiMode = CalibrationROI.fromValue(this.backing.getInt(12));
            this.learnCorrectionTable = this.backing.get(16);
        }

        @Override
        public void write() {
            if (this.calibrationMethod != null) {
                this.backing.putInt(0, this.calibrationMethod.getValue());
            }
            if (this.distortionModel != null) {
                this.backing.putInt(4, this.distortionModel.getValue());
            }
            if (this.scaleMode != null) {
                this.backing.putInt(8, this.scaleMode.getValue());
            }
            if (this.roiMode != null) {
                this.backing.putInt(12, this.roiMode.getValue());
            }
            this.backing.put(16, this.learnCorrectionTable);
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class CalibrationAxisInfo
    extends DisposedStruct {
        public PointFloat center;
        public float rotationAngle;
        public AxisOrientation axisDirection;

        private void init() {
            this.center = new PointFloat(this.backing, 0);
        }

        public CalibrationAxisInfo() {
            super(16);
            this.init();
        }

        public CalibrationAxisInfo(PointFloat center, double rotationAngle, AxisOrientation axisDirection) {
            super(16);
            this.center = center;
            this.rotationAngle = (float)rotationAngle;
            this.axisDirection = axisDirection;
        }

        protected CalibrationAxisInfo(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected CalibrationAxisInfo(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            this.center.read();
            this.rotationAngle = this.backing.getFloat(8);
            this.axisDirection = AxisOrientation.fromValue(this.backing.getInt(12));
        }

        @Override
        public void write() {
            this.center.write();
            this.backing.putFloat(8, this.rotationAngle);
            if (this.axisDirection != null) {
                this.backing.putInt(12, this.axisDirection.getValue());
            }
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class GetCameraParametersReport
    extends DisposedStruct {
        public int projectionMatrixRows;
        public int projectionMatrixCols;
        public DistortionModelParams distortion;
        public InternalParameters internalParams;

        private void init() {
            this.distortion = new DistortionModelParams(this.backing, 12);
            this.internalParams = new InternalParameters(this.backing, 36);
        }

        public GetCameraParametersReport() {
            super(56);
            this.init();
        }

        public GetCameraParametersReport(int projectionMatrixRows, int projectionMatrixCols, DistortionModelParams distortion, InternalParameters internalParams) {
            super(56);
            this.projectionMatrixRows = projectionMatrixRows;
            this.projectionMatrixCols = projectionMatrixCols;
            this.distortion = distortion;
            this.internalParams = internalParams;
        }

        protected GetCameraParametersReport(ByteBuffer backing, int offset) {
            super(backing, offset, 56);
            this.init();
        }

        protected GetCameraParametersReport(long nativeObj, boolean owned) {
            super(nativeObj, owned, 56);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 56);
        }

        @Override
        public void read() {
            this.projectionMatrixRows = this.backing.getInt(4);
            this.projectionMatrixCols = this.backing.getInt(8);
            this.distortion.read();
            this.internalParams.read();
        }

        @Override
        public void write() {
            this.backing.putInt(4, this.projectionMatrixRows);
            this.backing.putInt(8, this.projectionMatrixCols);
            this.distortion.write();
            this.internalParams.write();
        }

        @Override
        public int size() {
            return 56;
        }
    }

    public static class CalibrationReferencePoints
    extends DisposedStruct {
        public PointDouble[] pixelCoords;
        public PointDouble[] realCoords;
        public CalibrationUnit units;
        public ImageSize imageSize;
        private ByteBuffer pixelCoords_buf;
        private ByteBuffer realCoords_buf;

        private void init() {
            this.pixelCoords = new PointDouble[0];
            this.realCoords = new PointDouble[0];
            this.imageSize = new ImageSize(this.backing, 20);
        }

        public CalibrationReferencePoints() {
            super(28);
            this.init();
        }

        public CalibrationReferencePoints(PointDouble[] pixelCoords, PointDouble[] realCoords, CalibrationUnit units, ImageSize imageSize) {
            super(28);
            this.pixelCoords = pixelCoords;
            this.realCoords = realCoords;
            this.units = units;
            this.imageSize = imageSize;
        }

        protected CalibrationReferencePoints(ByteBuffer backing, int offset) {
            super(backing, offset, 28);
            this.init();
        }

        protected CalibrationReferencePoints(long nativeObj, boolean owned) {
            super(nativeObj, owned, 28);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 28);
        }

        @Override
        public void read() {
            int pixelCoords_numPixelCoords = this.backing.getInt(4);
            long pixelCoords_addr = NIVision.getPointer(this.backing, 0);
            this.pixelCoords = new PointDouble[pixelCoords_numPixelCoords];
            if (pixelCoords_numPixelCoords > 0 && pixelCoords_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(pixelCoords_addr, pixelCoords_numPixelCoords * 16);
                int i = 0;
                int off = 0;
                while (i < pixelCoords_numPixelCoords) {
                    this.pixelCoords[i] = new PointDouble(bb, off);
                    this.pixelCoords[i].read();
                    ++i;
                    off += 16;
                }
            }
            int realCoords_numRealCoords = this.backing.getInt(12);
            long realCoords_addr = NIVision.getPointer(this.backing, 8);
            this.realCoords = new PointDouble[realCoords_numRealCoords];
            if (realCoords_numRealCoords > 0 && realCoords_addr != 0L) {
                ByteBuffer bb = NIVision.newDirectByteBuffer(realCoords_addr, realCoords_numRealCoords * 16);
                int i = 0;
                int off = 0;
                while (i < realCoords_numRealCoords) {
                    this.realCoords[i] = new PointDouble(bb, off);
                    this.realCoords[i].read();
                    ++i;
                    off += 16;
                }
            }
            this.units = CalibrationUnit.fromValue(this.backing.getInt(16));
            this.imageSize.read();
        }

        @Override
        public void write() {
            this.pixelCoords_buf = ByteBuffer.allocateDirect(this.pixelCoords.length * 16).order(ByteOrder.nativeOrder());
            int i = 0;
            int off = 0;
            while (i < this.pixelCoords.length) {
                this.pixelCoords[i].setBuffer(this.pixelCoords_buf, off);
                this.pixelCoords[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(4, this.pixelCoords.length);
            NIVision.putPointer(this.backing, 0, this.pixelCoords_buf);
            this.realCoords_buf = ByteBuffer.allocateDirect(this.realCoords.length * 16).order(ByteOrder.nativeOrder());
            i = 0;
            off = 0;
            while (i < this.realCoords.length) {
                this.realCoords[i].setBuffer(this.realCoords_buf, off);
                this.realCoords[i].write();
                ++i;
                off += 16;
            }
            this.backing.putInt(12, this.realCoords.length);
            NIVision.putPointer(this.backing, 8, this.realCoords_buf);
            if (this.units != null) {
                this.backing.putInt(16, this.units.getValue());
            }
            this.imageSize.write();
        }

        @Override
        public int size() {
            return 28;
        }
    }

    public static class ImageSize
    extends DisposedStruct {
        public int xRes;
        public int yRes;

        private void init() {
        }

        public ImageSize() {
            super(8);
            this.init();
        }

        public ImageSize(int xRes, int yRes) {
            super(8);
            this.xRes = xRes;
            this.yRes = yRes;
        }

        protected ImageSize(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected ImageSize(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.xRes = this.backing.getInt(0);
            this.yRes = this.backing.getInt(4);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.xRes);
            this.backing.putInt(4, this.yRes);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class MaxGridSize
    extends DisposedStruct {
        public int xMax;
        public int yMax;

        private void init() {
        }

        public MaxGridSize() {
            super(8);
            this.init();
        }

        public MaxGridSize(int xMax, int yMax) {
            super(8);
            this.xMax = xMax;
            this.yMax = yMax;
        }

        protected MaxGridSize(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected MaxGridSize(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.xMax = this.backing.getInt(0);
            this.yMax = this.backing.getInt(4);
        }

        @Override
        public void write() {
            this.backing.putInt(0, this.xMax);
            this.backing.putInt(4, this.yMax);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class InternalParameters
    extends DisposedStruct {
        public byte isInsufficientData;
        public FocalLength focalLength;
        public PointFloat opticalCenter;

        private void init() {
            this.focalLength = new FocalLength(this.backing, 4);
            this.opticalCenter = new PointFloat(this.backing, 12);
        }

        public InternalParameters() {
            super(20);
            this.init();
        }

        public InternalParameters(byte isInsufficientData, FocalLength focalLength, PointFloat opticalCenter) {
            super(20);
            this.isInsufficientData = isInsufficientData;
            this.focalLength = focalLength;
            this.opticalCenter = opticalCenter;
        }

        protected InternalParameters(ByteBuffer backing, int offset) {
            super(backing, offset, 20);
            this.init();
        }

        protected InternalParameters(long nativeObj, boolean owned) {
            super(nativeObj, owned, 20);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 20);
        }

        @Override
        public void read() {
            this.isInsufficientData = this.backing.get(0);
            this.focalLength.read();
            this.opticalCenter.read();
        }

        @Override
        public void write() {
            this.backing.put(0, this.isInsufficientData);
            this.focalLength.write();
            this.opticalCenter.write();
        }

        @Override
        public int size() {
            return 20;
        }
    }

    public static class PointFloat
    extends DisposedStruct {
        public float x;
        public float y;

        private void init() {
        }

        public PointFloat() {
            super(8);
            this.init();
        }

        public PointFloat(double x, double y) {
            super(8);
            this.x = (float)x;
            this.y = (float)y;
        }

        protected PointFloat(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected PointFloat(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.x = this.backing.getFloat(0);
            this.y = this.backing.getFloat(4);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.x);
            this.backing.putFloat(4, this.y);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class DistortionModelParams
    extends DisposedStruct {
        public DistortionModel distortionModel;
        public PolyModel polyModel;
        public DivisionModel divisionModel;

        private void init() {
            this.polyModel = new PolyModel(this.backing, 4);
            this.divisionModel = new DivisionModel(this.backing, 20);
        }

        public DistortionModelParams() {
            super(24);
            this.init();
        }

        public DistortionModelParams(DistortionModel distortionModel, PolyModel polyModel, DivisionModel divisionModel) {
            super(24);
            this.distortionModel = distortionModel;
            this.polyModel = polyModel;
            this.divisionModel = divisionModel;
        }

        protected DistortionModelParams(ByteBuffer backing, int offset) {
            super(backing, offset, 24);
            this.init();
        }

        protected DistortionModelParams(long nativeObj, boolean owned) {
            super(nativeObj, owned, 24);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 24);
        }

        @Override
        public void read() {
            this.distortionModel = DistortionModel.fromValue(this.backing.getInt(0));
            this.polyModel.read();
            this.divisionModel.read();
        }

        @Override
        public void write() {
            if (this.distortionModel != null) {
                this.backing.putInt(0, this.distortionModel.getValue());
            }
            this.polyModel.write();
            this.divisionModel.write();
        }

        @Override
        public int size() {
            return 24;
        }
    }

    public static class PolyModel
    extends DisposedStruct {
        public float[] kCoeffs;
        public float p1;
        public float p2;
        private ByteBuffer kCoeffs_buf;

        private void init() {
            this.kCoeffs = new float[0];
        }

        public PolyModel() {
            super(16);
            this.init();
        }

        public PolyModel(float[] kCoeffs, double p1, double p2) {
            super(16);
            this.kCoeffs = kCoeffs;
            this.p1 = (float)p1;
            this.p2 = (float)p2;
        }

        protected PolyModel(ByteBuffer backing, int offset) {
            super(backing, offset, 16);
            this.init();
        }

        protected PolyModel(long nativeObj, boolean owned) {
            super(nativeObj, owned, 16);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 16);
        }

        @Override
        public void read() {
            int kCoeffs_numKCoeffs = this.backing.getInt(4);
            long kCoeffs_addr = NIVision.getPointer(this.backing, 0);
            this.kCoeffs = new float[kCoeffs_numKCoeffs];
            if (kCoeffs_numKCoeffs > 0 && kCoeffs_addr != 0L) {
                NIVision.newDirectByteBuffer(kCoeffs_addr, kCoeffs_numKCoeffs * 4).asFloatBuffer().get(this.kCoeffs);
            }
            this.p1 = this.backing.getFloat(8);
            this.p2 = this.backing.getFloat(12);
        }

        @Override
        public void write() {
            this.kCoeffs_buf = ByteBuffer.allocateDirect(this.kCoeffs.length * 4).order(ByteOrder.nativeOrder());
            this.kCoeffs_buf.asFloatBuffer().put(this.kCoeffs).rewind();
            this.backing.putInt(4, this.kCoeffs.length);
            NIVision.putPointer(this.backing, 0, this.kCoeffs_buf);
            this.backing.putFloat(8, this.p1);
            this.backing.putFloat(12, this.p2);
        }

        @Override
        public int size() {
            return 16;
        }
    }

    public static class FocalLength
    extends DisposedStruct {
        public float fx;
        public float fy;

        private void init() {
        }

        public FocalLength() {
            super(8);
            this.init();
        }

        public FocalLength(double fx, double fy) {
            super(8);
            this.fx = (float)fx;
            this.fy = (float)fy;
        }

        protected FocalLength(ByteBuffer backing, int offset) {
            super(backing, offset, 8);
            this.init();
        }

        protected FocalLength(long nativeObj, boolean owned) {
            super(nativeObj, owned, 8);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 8);
        }

        @Override
        public void read() {
            this.fx = this.backing.getFloat(0);
            this.fy = this.backing.getFloat(4);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.fx);
            this.backing.putFloat(4, this.fy);
        }

        @Override
        public int size() {
            return 8;
        }
    }

    public static class DivisionModel
    extends DisposedStruct {
        public float kappa;

        private void init() {
        }

        public DivisionModel() {
            super(4);
            this.init();
        }

        public DivisionModel(double kappa) {
            super(4);
            this.kappa = (float)kappa;
        }

        protected DivisionModel(ByteBuffer backing, int offset) {
            super(backing, offset, 4);
            this.init();
        }

        protected DivisionModel(long nativeObj, boolean owned) {
            super(nativeObj, owned, 4);
            this.init();
        }

        protected void setBuffer(ByteBuffer backing, int offset) {
            super.setBuffer(backing, offset, 4);
        }

        @Override
        public void read() {
            this.kappa = this.backing.getFloat(0);
        }

        @Override
        public void write() {
            this.backing.putFloat(0, this.kappa);
        }

        @Override
        public int size() {
            return 4;
        }
    }

    public static enum DataMatrixCellSampleSize {
        AUTO_DETECT_CELL_SAMPLE_SIZE(-2),
        C1x1(1),
        C2x2(2),
        C3x3(3),
        C4x4(4),
        C5x5(5),
        C6x6(6),
        C7x7(7);

        private final int value;

        private DataMatrixCellSampleSize(int value) {
            this.value = value;
        }

        public static DataMatrixCellSampleSize fromValue(int val) {
            for (DataMatrixCellSampleSize v : DataMatrixCellSampleSize.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FlattenType {
        FLATTEN_IMAGE(0),
        FLATTEN_IMAGE_AND_VISION_INFO(1);

        private final int value;

        private FlattenType(int value) {
            this.value = value;
        }

        public static FlattenType fromValue(int val) {
            try {
                return FlattenType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CompressionType {
        COMPRESSION_NONE(0),
        COMPRESSION_JPEG(1),
        COMPRESSION_PACKED_BINARY(2);

        private final int value;

        private CompressionType(int value) {
            this.value = value;
        }

        public static CompressionType fromValue(int val) {
            try {
                return CompressionType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LinearAveragesMode {
        COLUMN_AVERAGES(1),
        ROW_AVERAGES(2),
        RISING_DIAGONAL_AVERAGES(4),
        FALLING_DIAGONAL_AVERAGES(8),
        ALL_LINEAR_AVERAGES(15);

        private final int value;

        private LinearAveragesMode(int value) {
            this.value = value;
        }

        public static LinearAveragesMode fromValue(int val) {
            for (LinearAveragesMode v : LinearAveragesMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum RegistrationMethod {
        REGISTRATION_NONE(0),
        REGISTRATION_PERSPECTIVE(1);

        private final int value;

        private RegistrationMethod(int value) {
            this.value = value;
        }

        public static RegistrationMethod fromValue(int val) {
            try {
                return RegistrationMethod.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum NormalizationMethod {
        NORMALIZATION_NONE(0),
        NORMALIZATION_HISTOGRAM_MATCHING(1),
        NORMALIZATION_AVERAGE_MATCHING(2);

        private final int value;

        private NormalizationMethod(int value) {
            this.value = value;
        }

        public static NormalizationMethod fromValue(int val) {
            try {
                return NormalizationMethod.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum WaveletTransformMode {
        WAVELET_TRANSFORM_INTEGER(0),
        WAVELET_TRANSFORM_FLOATING_POINT(1);

        private final int value;

        private WaveletTransformMode(int value) {
            this.value = value;
        }

        public static WaveletTransformMode fromValue(int val) {
            try {
                return WaveletTransformMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DataMatrixGradingMode {
        NO_GRADING(0),
        PREPARE_FOR_AIM(1);

        private final int value;

        private DataMatrixGradingMode(int value) {
            this.value = value;
        }

        public static DataMatrixGradingMode fromValue(int val) {
            try {
                return DataMatrixGradingMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CalibrationMode2 {
        PERSPECTIVE_MODE(0),
        MICROPLANE_MODE(1),
        SIMPLE_CALIBRATION_MODE(2),
        CORRECTED_IMAGE_MODE(3),
        NO_CALIBRATION_MODE(4);

        private final int value;

        private CalibrationMode2(int value) {
            this.value = value;
        }

        public static CalibrationMode2 fromValue(int val) {
            try {
                return CalibrationMode2.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DataMatrixMirrorMode {
        AUTO_DETECT_MIRROR(-2),
        APPEARS_NORMAL(0),
        APPEARS_MIRRORED(1);

        private final int value;

        private DataMatrixMirrorMode(int value) {
            this.value = value;
        }

        public static DataMatrixMirrorMode fromValue(int val) {
            for (DataMatrixMirrorMode v : DataMatrixMirrorMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum WindowBackgroundHatchStyle {
        HATCH_STYLE_HORIZONTAL(0),
        HATCH_STYLE_VERTICAL(1),
        HATCH_STYLE_FORWARD_DIAGONAL(2),
        HATCH_STYLE_BACKWARD_DIAGONAL(3),
        HATCH_STYLE_CROSS(4),
        HATCH_STYLE_CROSS_HATCH(5);

        private final int value;

        private WindowBackgroundHatchStyle(int value) {
            this.value = value;
        }

        public static WindowBackgroundHatchStyle fromValue(int val) {
            try {
                return WindowBackgroundHatchStyle.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DataMatrixCellFilterMode {
        AUTO_DETECT_CELL_FILTER_MODE(-2),
        AVERAGE_FILTER(0),
        MEDIAN_FILTER(1),
        CENTRAL_AVERAGE_FILTER(2),
        HIGH_AVERAGE_FILTER(3),
        LOW_AVERAGE_FILTER(4),
        VERY_HIGH_AVERAGE_FILTER(5),
        VERY_LOW_AVERAGE_FILTER(6),
        ALL_CELL_FILTERS(8);

        private final int value;

        private DataMatrixCellFilterMode(int value) {
            this.value = value;
        }

        public static DataMatrixCellFilterMode fromValue(int val) {
            for (DataMatrixCellFilterMode v : DataMatrixCellFilterMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DataMatrixPolarity {
        AUTO_DETECT_POLARITY(-2),
        BLACK_DATA_ON_WHITE_BACKGROUND(0),
        WHITE_DATA_ON_BLACK_BACKGROUND(1);

        private final int value;

        private DataMatrixPolarity(int value) {
            this.value = value;
        }

        public static DataMatrixPolarity fromValue(int val) {
            for (DataMatrixPolarity v : DataMatrixPolarity.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DataMatrixECC {
        AUTO_DETECT_ECC(-2),
        ECC_000(0),
        ECC_050(50),
        ECC_080(80),
        ECC_100(100),
        ECC_140(140),
        ECC_000_140(190),
        ECC_200(200);

        private final int value;

        private DataMatrixECC(int value) {
            this.value = value;
        }

        public static DataMatrixECC fromValue(int val) {
            for (DataMatrixECC v : DataMatrixECC.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DataMatrixDemodulationMode {
        AUTO_DETECT_DEMODULATION_MODE(-2),
        HISTOGRAM(0),
        LOCAL_CONTRAST(1),
        COMBINED(2),
        ALL_DEMODULATION_MODES(3);

        private final int value;

        private DataMatrixDemodulationMode(int value) {
            this.value = value;
        }

        public static DataMatrixDemodulationMode fromValue(int val) {
            for (DataMatrixDemodulationMode v : DataMatrixDemodulationMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DataMatrixCellFillMode {
        AUTO_DETECT_CELL_FILL_MODE(-2),
        LOW_FILL(0),
        NORMAL_FILL(1);

        private final int value;

        private DataMatrixCellFillMode(int value) {
            this.value = value;
        }

        public static DataMatrixCellFillMode fromValue(int val) {
            for (DataMatrixCellFillMode v : DataMatrixCellFillMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum AIMGrade {
        AIM_GRADE_F(0),
        AIM_GRADE_D(1),
        AIM_GRADE_C(2),
        AIM_GRADE_B(3),
        AIM_GRADE_A(4);

        private final int value;

        private AIMGrade(int value) {
            this.value = value;
        }

        public static AIMGrade fromValue(int val) {
            try {
                return AIMGrade.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DataMatrixRotationMode {
        UNLIMITED_ROTATION(0),
        C0_DEGREES(1),
        C90_DEGREES(2),
        C180_DEGREES(3),
        C270_DEGREES(4);

        private final int value;

        private DataMatrixRotationMode(int value) {
            this.value = value;
        }

        public static DataMatrixRotationMode fromValue(int val) {
            try {
                return DataMatrixRotationMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Barcode2DShape {
        SQUARE_BARCODE_2D(0),
        RECTANGULAR_BARCODE_2D(1);

        private final int value;

        private Barcode2DShape(int value) {
            this.value = value;
        }

        public static Barcode2DShape fromValue(int val) {
            try {
                return Barcode2DShape.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum WriteClassifierFileMode {
        CLASSIFIER_WRITE_ALL(0),
        CLASSIFIER_WRITE_CLASSIFY_ONLY(1);

        private final int value;

        private WriteClassifierFileMode(int value) {
            this.value = value;
        }

        public static WriteClassifierFileMode fromValue(int val) {
            try {
                return WriteClassifierFileMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ReadClassifierFileMode {
        CLASSIFIER_READ_ALL(0),
        CLASSIFIER_READ_SAMPLES(1),
        CLASSIFIER_READ_PROPERTIES(2);

        private final int value;

        private ReadClassifierFileMode(int value) {
            this.value = value;
        }

        public static ReadClassifierFileMode fromValue(int val) {
            try {
                return ReadClassifierFileMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum VisionInfoType2 {
        VISIONINFO_CALIBRATION(1),
        VISIONINFO_OVERLAY(2),
        VISIONINFO_GRAYTEMPLATE(4),
        VISIONINFO_COLORTEMPLATE(8),
        VISIONINFO_GEOMETRICTEMPLATE(16),
        VISIONINFO_CUSTOMDATA(32),
        VISIONINFO_GOLDENTEMPLATE(64),
        VISIONINFO_GEOMETRICTEMPLATE2(128),
        VISIONINFO_ALL(-1);

        private final int value;

        private VisionInfoType2(int value) {
            this.value = value;
        }

        public static VisionInfoType2 fromValue(int val) {
            for (VisionInfoType2 v : VisionInfoType2.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ParticleType {
        PARTICLE_BRIGHT(0),
        PARTICLE_DARK(1);

        private final int value;

        private ParticleType(int value) {
            this.value = value;
        }

        public static ParticleType fromValue(int val) {
            try {
                return ParticleType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ClassifierType {
        CLASSIFIER_CUSTOM(0),
        CLASSIFIER_PARTICLE(1),
        CLASSIFIER_COLOR(2),
        CLASSIFIER_TEXTURE(3);

        private final int value;

        private ClassifierType(int value) {
            this.value = value;
        }

        public static ClassifierType fromValue(int val) {
            try {
                return ClassifierType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ClassifierEngineType {
        ENGINE_NONE(0),
        ENGINE_NEAREST_NEIGHBOR(1),
        ENGINE_SUPPORT_VECTOR_MACHINE(2);

        private final int value;

        private ClassifierEngineType(int value) {
            this.value = value;
        }

        public static ClassifierEngineType fromValue(int val) {
            try {
                return ClassifierEngineType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Barcode2DType {
        PDF417(0),
        DATA_MATRIX_ECC_000(1),
        DATA_MATRIX_ECC_050(2),
        DATA_MATRIX_ECC_080(3),
        DATA_MATRIX_ECC_100(4),
        DATA_MATRIX_ECC_140(5),
        DATA_MATRIX_ECC_200(6);

        private final int value;

        private Barcode2DType(int value) {
            this.value = value;
        }

        public static Barcode2DType fromValue(int val) {
            try {
                return Barcode2DType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LocalThresholdMethod {
        NIBLACK(0),
        BACKGROUND_CORRECTION(1);

        private final int value;

        private LocalThresholdMethod(int value) {
            this.value = value;
        }

        public static LocalThresholdMethod fromValue(int val) {
            try {
                return LocalThresholdMethod.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Barcode2DCellShape {
        SQUARE_CELLS(0),
        ROUND_CELLS(1);

        private final int value;

        private Barcode2DCellShape(int value) {
            this.value = value;
        }

        public static Barcode2DCellShape fromValue(int val) {
            try {
                return Barcode2DCellShape.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FeatureType {
        NOT_FOUND_FEATURE(0),
        CIRCLE_FEATURE(1),
        ELLIPSE_FEATURE(2),
        CONST_CURVE_FEATURE(3),
        RECTANGLE_FEATURE(4),
        LEG_FEATURE(5),
        CORNER_FEATURE(6),
        PARALLEL_LINE_PAIR_FEATURE(7),
        PAIR_OF_PARALLEL_LINE_PAIRS_FEATURE(8),
        LINE_FEATURE(9),
        CLOSED_CURVE_FEATURE(10);

        private final int value;

        private FeatureType(int value) {
            this.value = value;
        }

        public static FeatureType fromValue(int val) {
            try {
                return FeatureType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DataMatrixSubtype {
        ALL_DATA_MATRIX_SUBTYPES(0),
        DATA_MATRIX_SUBTYPES_ECC_000_ECC_140(1),
        DATA_MATRIX_SUBTYPE_ECC_200(2);

        private final int value;

        private DataMatrixSubtype(int value) {
            this.value = value;
        }

        public static DataMatrixSubtype fromValue(int val) {
            try {
                return DataMatrixSubtype.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Barcode2DSearchMode {
        SEARCH_MULTIPLE(0),
        SEARCH_SINGLE_CONSERVATIVE(1),
        SEARCH_SINGLE_AGGRESSIVE(2);

        private final int value;

        private Barcode2DSearchMode(int value) {
            this.value = value;
        }

        public static Barcode2DSearchMode fromValue(int val) {
            try {
                return Barcode2DSearchMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum EdgeFilterSize {
        FINE(0),
        NORMAL(1),
        CONTOUR_TRACING(2);

        private final int value;

        private EdgeFilterSize(int value) {
            this.value = value;
        }

        public static EdgeFilterSize fromValue(int val) {
            try {
                return EdgeFilterSize.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ExtractionMode {
        NORMAL_IMAGE(0),
        UNIFORM_REGIONS(1);

        private final int value;

        private ExtractionMode(int value) {
            this.value = value;
        }

        public static ExtractionMode fromValue(int val) {
            try {
                return ExtractionMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum WindowBackgroundFillStyle {
        FILL_STYLE_SOLID(0),
        FILL_STYLE_HATCH(2),
        FILL_STYLE_DEFAULT(3);

        private final int value;

        private WindowBackgroundFillStyle(int value) {
            this.value = value;
        }

        public static WindowBackgroundFillStyle fromValue(int val) {
            for (WindowBackgroundFillStyle v : WindowBackgroundFillStyle.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRModelType {
        QR_MODELTYPE_AUTO_DETECT(0),
        QR_MODELTYPE_MICRO(1),
        QR_MODELTYPE_MODEL1(2),
        QR_MODELTYPE_MODEL2(3);

        private final int value;

        private QRModelType(int value) {
            this.value = value;
        }

        public static QRModelType fromValue(int val) {
            try {
                return QRModelType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Barcode2DContrast {
        ALL_BARCODE_2D_CONTRASTS(0),
        BLACK_ON_WHITE_BARCODE_2D(1),
        WHITE_ON_BLACK_BARCODE_2D(2);

        private final int value;

        private Barcode2DContrast(int value) {
            this.value = value;
        }

        public static Barcode2DContrast fromValue(int val) {
            try {
                return Barcode2DContrast.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ConnectionConstraintType {
        DISTANCE_CONSTRAINT(0),
        ANGLE_CONSTRAINT(1),
        CONNECTIVITY_CONSTRAINT(2),
        GRADIENT_CONSTRAINT(3),
        NUM_CONNECTION_CONSTRAINT_TYPES(4);

        private final int value;

        private ConnectionConstraintType(int value) {
            this.value = value;
        }

        public static ConnectionConstraintType fromValue(int val) {
            try {
                return ConnectionConstraintType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ColorClassificationResolution {
        CLASSIFIER_LOW_RESOLUTION(0),
        CLASSIFIER_MEDIUM_RESOLUTION(1),
        CLASSIFIER_HIGH_RESOLUTION(2);

        private final int value;

        private ColorClassificationResolution(int value) {
            this.value = value;
        }

        public static ColorClassificationResolution fromValue(int val) {
            try {
                return ColorClassificationResolution.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum GeometricMatchingSearchStrategy {
        GEOMETRIC_MATCHING_CONSERVATIVE(0),
        GEOMETRIC_MATCHING_BALANCED(1),
        GEOMETRIC_MATCHING_AGGRESSIVE(2);

        private final int value;

        private GeometricMatchingSearchStrategy(int value) {
            this.value = value;
        }

        public static GeometricMatchingSearchStrategy fromValue(int val) {
            try {
                return GeometricMatchingSearchStrategy.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum MeasureParticlesCalibrationMode {
        CALIBRATION_MODE_PIXEL(0),
        CALIBRATION_MODE_CALIBRATED(1),
        CALIBRATION_MODE_BOTH(2);

        private final int value;

        private MeasureParticlesCalibrationMode(int value) {
            this.value = value;
        }

        public static MeasureParticlesCalibrationMode fromValue(int val) {
            try {
                return MeasureParticlesCalibrationMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ParticleClassifierThresholdType {
        THRESHOLD_MANUAL(0),
        THRESHOLD_AUTO(1),
        THRESHOLD_LOCAL(2);

        private final int value;

        private ParticleClassifierThresholdType(int value) {
            this.value = value;
        }

        public static ParticleClassifierThresholdType fromValue(int val) {
            try {
                return ParticleClassifierThresholdType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum WaveletType {
        DB02(0),
        DB03(1),
        DB04(2),
        DB05(3),
        DB06(4),
        DB07(5),
        DB08(6),
        DB09(7),
        DB10(8),
        DB11(9),
        DB12(10),
        DB13(11),
        DB14(12),
        HAAR(13),
        BIOR1_3(14),
        BIOR1_5(15),
        BIOR2_2(16),
        BIOR2_4(17),
        BIOR2_6(18),
        BIOR2_8(19),
        BIOR3_1(20),
        BIOR3_3(21),
        BIOR3_5(22),
        BIOR3_7(23),
        BIOR3_9(24),
        BIOR4_4(25),
        COIF1(26),
        COIF2(27),
        COIF3(28),
        COIF4(29),
        COIF5(30),
        SYM2(31),
        SYM3(32),
        SYM4(33),
        SYM5(34),
        SYM6(35),
        SYM7(36),
        SYM8(37),
        BIOR5_5(38),
        BIOR6_8(39);

        private final int value;

        private WaveletType(int value) {
            this.value = value;
        }

        public static WaveletType fromValue(int val) {
            try {
                return WaveletType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum MorphologyReconstructOperation {
        DILATE_RECONSTRUCT(0),
        ERODE_RECONSTRUCT(1);

        private final int value;

        private MorphologyReconstructOperation(int value) {
            this.value = value;
        }

        public static MorphologyReconstructOperation fromValue(int val) {
            try {
                return MorphologyReconstructOperation.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Connectivity {
        FOUR_CONNECTED(0),
        EIGHT_CONNECTED(1);

        private final int value;

        private Connectivity(int value) {
            this.value = value;
        }

        public static Connectivity fromValue(int val) {
            try {
                return Connectivity.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum EdgePolaritySearchMode {
        SEARCH_FOR_ALL_EDGES(0),
        SEARCH_FOR_RISING_EDGES(1),
        SEARCH_FOR_FALLING_EDGES(2);

        private final int value;

        private EdgePolaritySearchMode(int value) {
            this.value = value;
        }

        public static EdgePolaritySearchMode fromValue(int val) {
            try {
                return EdgePolaritySearchMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ExtractContourDirection {
        RECT_LEFT_RIGHT(0),
        RECT_RIGHT_LEFT(1),
        RECT_TOP_BOTTOM(2),
        RECT_BOTTOM_TOP(3),
        ANNULUS_INNER_OUTER(4),
        ANNULUS_OUTER_INNER(5),
        ANNULUS_START_STOP(6),
        ANNULUS_STOP_START(7);

        private final int value;

        private ExtractContourDirection(int value) {
            this.value = value;
        }

        public static ExtractContourDirection fromValue(int val) {
            try {
                return ExtractContourDirection.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FindTransformMode {
        FIND_REFERENCE(0),
        UPDATE_TRANSFORM(1);

        private final int value;

        private FindTransformMode(int value) {
            this.value = value;
        }

        public static FindTransformMode fromValue(int val) {
            try {
                return FindTransformMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ExtractContourSelection {
        CLOSEST(0),
        LONGEST(1),
        STRONGEST(2);

        private final int value;

        private ExtractContourSelection(int value) {
            this.value = value;
        }

        public static ExtractContourSelection fromValue(int val) {
            try {
                return ExtractContourSelection.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum SegmentationDistanceLevel {
        SEGMENTATION_LEVEL_CONSERVATIVE(0),
        SEGMENTATION_LEVEL_AGGRESSIVE(1);

        private final int value;

        private SegmentationDistanceLevel(int value) {
            this.value = value;
        }

        public static SegmentationDistanceLevel fromValue(int val) {
            try {
                return SegmentationDistanceLevel.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum SettingType {
        ROTATION_ANGLE_RANGE(0),
        SCALE_RANGE(1),
        OCCLUSION_RANGE(2);

        private final int value;

        private SettingType(int value) {
            this.value = value;
        }

        public static SettingType fromValue(int val) {
            try {
                return SettingType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CalibrationThumbnailType {
        CAMARA_MODEL_TYPE(0),
        PERSPECTIVE_TYPE(1),
        MICRO_PLANE_TYPE(2);

        private final int value;

        private CalibrationThumbnailType(int value) {
            this.value = value;
        }

        public static CalibrationThumbnailType fromValue(int val) {
            try {
                return CalibrationThumbnailType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DistortionModel {
        POLYNOMIAL_MODEL(0),
        DIVISION_MODEL(1),
        NO_DISTORTION_MODEL(-1);

        private final int value;

        private DistortionModel(int value) {
            this.value = value;
        }

        public static DistortionModel fromValue(int val) {
            for (DistortionModel v : DistortionModel.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum GeometricSetupDataItem {
        CURVE_EXTRACTION_MODE(0),
        CURVE_EDGE_THRSHOLD(1),
        CURVE_EDGE_FILTER(2),
        MINIMUM_CURVE_LENGTH(3),
        CURVE_ROW_SEARCH_STEP_SIZE(4),
        CURVE_COL_SEARCH_STEP_SIZE(5),
        CURVE_MAX_END_POINT_GAP(6),
        EXTRACT_CLOSED_CURVES(7),
        ENABLE_SUBPIXEL_CURVE_EXTRACTION(8),
        ENABLE_CORRELATION_SCORE(9),
        ENABLE_SUBPIXEL_ACCURACY(10),
        SUBPIXEL_ITERATIONS(11),
        SUBPIXEL_TOLERANCE(12),
        INITIAL_MATCH_LIST_LENGTH(13),
        ENABLE_TARGET_TEMPLATE_CURVESCORE(14),
        MINIMUM_MATCH_SEPARATION_DISTANCE(15),
        MINIMUM_MATCH_SEPARATION_ANGLE(16),
        MINIMUM_MATCH_SEPARATION_SCALE(17),
        MAXIMUM_MATCH_OVERLAP(18),
        ENABLE_COARSE_RESULT(19),
        ENABLE_CALIBRATION_SUPPORT(20),
        ENABLE_CONTRAST_REVERSAL(21),
        SEARCH_STRATEGY(22),
        REFINEMENT_MATCH_FACTOR(23),
        SUBPIXEL_MATCH_FACTOR(24),
        MAX_REFINEMENT_ITERATIONS(25);

        private final int value;

        private GeometricSetupDataItem(int value) {
            this.value = value;
        }

        public static GeometricSetupDataItem fromValue(int val) {
            try {
                return GeometricSetupDataItem.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum RakeProcessType {
        GET_FIRST_EDGES(0),
        GET_FIRST_AND_LAST_EDGES(1),
        GET_ALL_EDGES(2),
        GET_BEST_EDGES(3);

        private final int value;

        private RakeProcessType(int value) {
            this.value = value;
        }

        public static RakeProcessType fromValue(int val) {
            try {
                return RakeProcessType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRCellSampleSize {
        QR_CELL_SAMPLE_SIZE_AUTO_DETECT(-2),
        QR_CELL_SAMPLE_SIZE1X1(1),
        QR_CELL_SAMPLE_SIZE2X2(2),
        QR_CELL_SAMPLE_SIZE3X3(3),
        QR_CELL_SAMPLE_SIZE4X4(4),
        QR_CELL_SAMPLE_SIZE5X5(5),
        QR_CELL_SAMPLE_SIZE6X6(6),
        QR_CELL_SAMPLE_SIZE7X7(7);

        private final int value;

        private QRCellSampleSize(int value) {
            this.value = value;
        }

        public static QRCellSampleSize fromValue(int val) {
            for (QRCellSampleSize v : QRCellSampleSize.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ParticleClassifierType {
        PARTICLE_LARGEST(0),
        PARTICLE_ALL(1);

        private final int value;

        private ParticleClassifierType(int value) {
            this.value = value;
        }

        public static ParticleClassifierType fromValue(int val) {
            try {
                return ParticleClassifierType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRStreamMode {
        QR_MODE_NUMERIC(0),
        QR_MODE_ALPHANUMERIC(1),
        QR_MODE_RAW_BYTE(2),
        QR_MODE_EAN128_TOKEN(3),
        QR_MODE_EAN128_DATA(4),
        QR_MODE_ECI(5),
        QR_MODE_KANJI(6);

        private final int value;

        private QRStreamMode(int value) {
            this.value = value;
        }

        public static QRStreamMode fromValue(int val) {
            try {
                return QRStreamMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum SearchDirection {
        SEARCH_DIRECTION_LEFT_TO_RIGHT(0),
        SEARCH_DIRECTION_RIGHT_TO_LEFT(1),
        SEARCH_DIRECTION_TOP_TO_BOTTOM(2),
        SEARCH_DIRECTION_BOTTOM_TO_TOP(3);

        private final int value;

        private SearchDirection(int value) {
            this.value = value;
        }

        public static SearchDirection fromValue(int val) {
            try {
                return SearchDirection.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum StraightEdgeSearchMode {
        USE_FIRST_RAKE_EDGES(0),
        USE_BEST_RAKE_EDGES(1),
        USE_BEST_HOUGH_LINE(2),
        USE_FIRST_PROJECTION_EDGE(3),
        USE_BEST_PROJECTION_EDGE(4);

        private final int value;

        private StraightEdgeSearchMode(int value) {
            this.value = value;
        }

        public static StraightEdgeSearchMode fromValue(int val) {
            try {
                return StraightEdgeSearchMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRGradingMode {
        QR_NO_GRADING(0);

        private final int value;

        private QRGradingMode(int value) {
            this.value = value;
        }

        public static QRGradingMode fromValue(int val) {
            try {
                return QRGradingMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRRotationMode {
        QR_ROTATION_MODE_UNLIMITED(0),
        QR_ROTATION_MODE_0_DEGREES(1),
        QR_ROTATION_MODE_90_DEGREES(2),
        QR_ROTATION_MODE_180_DEGREES(3),
        QR_ROTATION_MODE_270_DEGREES(4);

        private final int value;

        private QRRotationMode(int value) {
            this.value = value;
        }

        public static QRRotationMode fromValue(int val) {
            try {
                return QRRotationMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRPolarities {
        QR_POLARITY_AUTO_DETECT(-2),
        QR_POLARITY_BLACK_ON_WHITE(0),
        QR_POLARITY_WHITE_ON_BLACK(1);

        private final int value;

        private QRPolarities(int value) {
            this.value = value;
        }

        public static QRPolarities fromValue(int val) {
            for (QRPolarities v : QRPolarities.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ContrastMode {
        ORIGINAL_CONTRAST(0),
        REVERSED_CONTRAST(1),
        BOTH_CONTRASTS(2);

        private final int value;

        private ContrastMode(int value) {
            this.value = value;
        }

        public static ContrastMode fromValue(int val) {
            try {
                return ContrastMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRDemodulationMode {
        QR_DEMODULATION_MODE_AUTO_DETECT(-2),
        QR_DEMODULATION_MODE_HISTOGRAM(0),
        QR_DEMODULATION_MODE_LOCAL_CONTRAST(1),
        QR_DEMODULATION_MODE_COMBINED(2),
        QR_DEMODULATION_MODE_ALL(3);

        private final int value;

        private QRDemodulationMode(int value) {
            this.value = value;
        }

        public static QRDemodulationMode fromValue(int val) {
            for (QRDemodulationMode v : QRDemodulationMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum RoundingMode {
        ROUNDING_MODE_OPTIMIZE(0),
        ROUNDING_MODE_TRUNCATE(1);

        private final int value;

        private RoundingMode(int value) {
            this.value = value;
        }

        public static RoundingMode fromValue(int val) {
            try {
                return RoundingMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRCellFilterMode {
        QR_CELL_FILTER_MODE_AUTO_DETECT(-2),
        QR_CELL_FILTER_MODE_AVERAGE(0),
        QR_CELL_FILTER_MODE_MEDIAN(1),
        QR_CELL_FILTER_MODE_CENTRAL_AVERAGE(2),
        QR_CELL_FILTER_MODE_HIGH_AVERAGE(3),
        QR_CELL_FILTER_MODE_LOW_AVERAGE(4),
        QR_CELL_FILTER_MODE_VERY_HIGH_AVERAGE(5),
        QR_CELL_FILTER_MODE_VERY_LOW_AVERAGE(6),
        QR_CELL_FILTER_MODE_ALL(8);

        private final int value;

        private QRCellFilterMode(int value) {
            this.value = value;
        }

        public static QRCellFilterMode fromValue(int val) {
            for (QRCellFilterMode v : QRCellFilterMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRDimensions {
        QR_DIMENSIONS_AUTO_DETECT(0),
        QR_DIMENSIONS_11x11(11),
        QR_DIMENSIONS_13x13(13),
        QR_DIMENSIONS_15x15(15),
        QR_DIMENSIONS_17x17(17),
        QR_DIMENSIONS_21x21(21),
        QR_DIMENSIONS_25x25(25),
        QR_DIMENSIONS_29x29(29),
        QR_DIMENSIONS_33x33(33),
        QR_DIMENSIONS_37x37(37),
        QR_DIMENSIONS_41x41(41),
        QR_DIMENSIONS_45x45(45),
        QR_DIMENSIONS_49x49(49),
        QR_DIMENSIONS_53x53(53),
        QR_DIMENSIONS_57x57(57),
        QR_DIMENSIONS_61x61(61),
        QR_DIMENSIONS_65x65(65),
        QR_DIMENSIONS_69x69(69),
        QR_DIMENSIONS_73x73(73),
        QR_DIMENSIONS_77x77(77),
        QR_DIMENSIONS_81x81(81),
        QR_DIMENSIONS_85x85(85),
        QR_DIMENSIONS_89x89(89),
        QR_DIMENSIONS_93x93(93),
        QR_DIMENSIONS_97x97(97),
        QR_DIMENSIONS_101x101(101),
        QR_DIMENSIONS_105x105(105),
        QR_DIMENSIONS_109x109(109),
        QR_DIMENSIONS_113x113(113),
        QR_DIMENSIONS_117x117(117),
        QR_DIMENSIONS_121x121(121),
        QR_DIMENSIONS_125x125(125),
        QR_DIMENSIONS_129x129(129),
        QR_DIMENSIONS_133x133(133),
        QR_DIMENSIONS_137x137(137),
        QR_DIMENSIONS_141x141(141),
        QR_DIMENSIONS_145x145(145),
        QR_DIMENSIONS_149x149(149),
        QR_DIMENSIONS_153x153(153),
        QR_DIMENSIONS_157x157(157),
        QR_DIMENSIONS_161x161(161),
        QR_DIMENSIONS_165x165(165),
        QR_DIMENSIONS_169x169(169),
        QR_DIMENSIONS_173x173(173),
        QR_DIMENSIONS_177x177(177);

        private final int value;

        private QRDimensions(int value) {
            this.value = value;
        }

        public static QRDimensions fromValue(int val) {
            for (QRDimensions v : QRDimensions.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum GroupBehavior {
        GROUP_CLEAR(0),
        GROUP_KEEP(1),
        GROUP_TRANSFORM(2);

        private final int value;

        private GroupBehavior(int value) {
            this.value = value;
        }

        public static GroupBehavior fromValue(int val) {
            try {
                return GroupBehavior.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum MulticoreOperation {
        GET_CORES(0),
        SET_CORES(1),
        USE_MAX_AVAILABLE(2);

        private final int value;

        private MulticoreOperation(int value) {
            this.value = value;
        }

        public static MulticoreOperation fromValue(int val) {
            try {
                return MulticoreOperation.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FindReferenceDirection {
        LEFT_TO_RIGHT_DIRECT(0),
        LEFT_TO_RIGHT_INDIRECT(1),
        TOP_TO_BOTTOM_DIRECT(2),
        TOP_TO_BOTTOM_INDIRECT(3),
        RIGHT_TO_LEFT_DIRECT(4),
        RIGHT_TO_LEFT_INDIRECT(5),
        BOTTOM_TO_TOP_DIRECT(6),
        BOTTOM_TO_TOP_INDIRECT(7);

        private final int value;

        private FindReferenceDirection(int value) {
            this.value = value;
        }

        public static FindReferenceDirection fromValue(int val) {
            try {
                return FindReferenceDirection.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ColumnProcessingMode {
        AVERAGE_COLUMNS(0),
        MEDIAN_COLUMNS(1);

        private final int value;

        private ColumnProcessingMode(int value) {
            this.value = value;
        }

        public static ColumnProcessingMode fromValue(int val) {
            try {
                return ColumnProcessingMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum QRMirrorMode {
        QR_MIRROR_MODE_AUTO_DETECT(-2),
        QR_MIRROR_MODE_MIRRORED(1),
        QR_MIRROR_MODE_NORMAL(0);

        private final int value;

        private QRMirrorMode(int value) {
            this.value = value;
        }

        public static QRMirrorMode fromValue(int val) {
            for (QRMirrorMode v : QRMirrorMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum NearestNeighborMethod {
        MINIMUM_MEAN_DISTANCE(0),
        K_NEAREST_NEIGHBOR(1),
        NEAREST_PROTOTYPE(2);

        private final int value;

        private NearestNeighborMethod(int value) {
            this.value = value;
        }

        public static NearestNeighborMethod fromValue(int val) {
            try {
                return NearestNeighborMethod.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ButtonLabel {
        BUTTON_OK(0),
        BUTTON_SAVE(1),
        BUTTON_SELECT(2),
        BUTTON_LOAD(3);

        private final int value;

        private ButtonLabel(int value) {
            this.value = value;
        }

        public static ButtonLabel fromValue(int val) {
            try {
                return ButtonLabel.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum GeometricMatchingMode {
        GEOMETRIC_MATCH_SHIFT_INVARIANT(0),
        GEOMETRIC_MATCH_ROTATION_INVARIANT(1),
        GEOMETRIC_MATCH_SCALE_INVARIANT(2),
        GEOMETRIC_MATCH_OCCLUSION_INVARIANT(4);

        private final int value;

        private GeometricMatchingMode(int value) {
            this.value = value;
        }

        public static GeometricMatchingMode fromValue(int val) {
            for (GeometricMatchingMode v : GeometricMatchingMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum MeasurementType {
        MT_CENTER_OF_MASS_X(0),
        MT_CENTER_OF_MASS_Y(1),
        MT_FIRST_PIXEL_X(2),
        MT_FIRST_PIXEL_Y(3),
        MT_BOUNDING_RECT_LEFT(4),
        MT_BOUNDING_RECT_TOP(5),
        MT_BOUNDING_RECT_RIGHT(6),
        MT_BOUNDING_RECT_BOTTOM(7),
        MT_MAX_FERET_DIAMETER_START_X(8),
        MT_MAX_FERET_DIAMETER_START_Y(9),
        MT_MAX_FERET_DIAMETER_END_X(10),
        MT_MAX_FERET_DIAMETER_END_Y(11),
        MT_MAX_HORIZ_SEGMENT_LENGTH_LEFT(12),
        MT_MAX_HORIZ_SEGMENT_LENGTH_RIGHT(13),
        MT_MAX_HORIZ_SEGMENT_LENGTH_ROW(14),
        MT_BOUNDING_RECT_WIDTH(16),
        MT_BOUNDING_RECT_HEIGHT(17),
        MT_BOUNDING_RECT_DIAGONAL(18),
        MT_PERIMETER(19),
        MT_CONVEX_HULL_PERIMETER(20),
        MT_HOLES_PERIMETER(21),
        MT_MAX_FERET_DIAMETER(22),
        MT_EQUIVALENT_ELLIPSE_MAJOR_AXIS(23),
        MT_EQUIVALENT_ELLIPSE_MINOR_AXIS(24),
        MT_EQUIVALENT_ELLIPSE_MINOR_AXIS_FERET(25),
        MT_EQUIVALENT_RECT_LONG_SIDE(26),
        MT_EQUIVALENT_RECT_SHORT_SIDE(27),
        MT_EQUIVALENT_RECT_DIAGONAL(28),
        MT_EQUIVALENT_RECT_SHORT_SIDE_FERET(29),
        MT_AVERAGE_HORIZ_SEGMENT_LENGTH(30),
        MT_AVERAGE_VERT_SEGMENT_LENGTH(31),
        MT_HYDRAULIC_RADIUS(32),
        MT_WADDEL_DISK_DIAMETER(33),
        MT_AREA(35),
        MT_HOLES_AREA(36),
        MT_PARTICLE_AND_HOLES_AREA(37),
        MT_CONVEX_HULL_AREA(38),
        MT_IMAGE_AREA(39),
        MT_NUMBER_OF_HOLES(41),
        MT_NUMBER_OF_HORIZ_SEGMENTS(42),
        MT_NUMBER_OF_VERT_SEGMENTS(43),
        MT_ORIENTATION(45),
        MT_MAX_FERET_DIAMETER_ORIENTATION(46),
        MT_AREA_BY_IMAGE_AREA(48),
        MT_AREA_BY_PARTICLE_AND_HOLES_AREA(49),
        MT_RATIO_OF_EQUIVALENT_ELLIPSE_AXES(50),
        MT_RATIO_OF_EQUIVALENT_RECT_SIDES(51),
        MT_ELONGATION_FACTOR(53),
        MT_COMPACTNESS_FACTOR(54),
        MT_HEYWOOD_CIRCULARITY_FACTOR(55),
        MT_TYPE_FACTOR(56),
        MT_SUM_X(58),
        MT_SUM_Y(59),
        MT_SUM_XX(60),
        MT_SUM_XY(61),
        MT_SUM_YY(62),
        MT_SUM_XXX(63),
        MT_SUM_XXY(64),
        MT_SUM_XYY(65),
        MT_SUM_YYY(66),
        MT_MOMENT_OF_INERTIA_XX(68),
        MT_MOMENT_OF_INERTIA_XY(69),
        MT_MOMENT_OF_INERTIA_YY(70),
        MT_MOMENT_OF_INERTIA_XXX(71),
        MT_MOMENT_OF_INERTIA_XXY(72),
        MT_MOMENT_OF_INERTIA_XYY(73),
        MT_MOMENT_OF_INERTIA_YYY(74),
        MT_NORM_MOMENT_OF_INERTIA_XX(75),
        MT_NORM_MOMENT_OF_INERTIA_XY(76),
        MT_NORM_MOMENT_OF_INERTIA_YY(77),
        MT_NORM_MOMENT_OF_INERTIA_XXX(78),
        MT_NORM_MOMENT_OF_INERTIA_XXY(79),
        MT_NORM_MOMENT_OF_INERTIA_XYY(80),
        MT_NORM_MOMENT_OF_INERTIA_YYY(81),
        MT_HU_MOMENT_1(82),
        MT_HU_MOMENT_2(83),
        MT_HU_MOMENT_3(84),
        MT_HU_MOMENT_4(85),
        MT_HU_MOMENT_5(86),
        MT_HU_MOMENT_6(87),
        MT_HU_MOMENT_7(88);

        private final int value;

        private MeasurementType(int value) {
            this.value = value;
        }

        public static MeasurementType fromValue(int val) {
            for (MeasurementType v : MeasurementType.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ReadStrategy {
        READ_AGGRESSIVE(0),
        READ_CONSERVATIVE(1);

        private final int value;

        private ReadStrategy(int value) {
            this.value = value;
        }

        public static ReadStrategy fromValue(int val) {
            try {
                return ReadStrategy.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ThresholdMode {
        FIXED_RANGE(0),
        COMPUTED_UNIFORM(1),
        COMPUTED_LINEAR(2),
        COMPUTED_NONLINEAR(3);

        private final int value;

        private ThresholdMode(int value) {
            this.value = value;
        }

        public static ThresholdMode fromValue(int val) {
            try {
                return ThresholdMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ReadResolution {
        LOW_RESOLUTION(0),
        MEDIUM_RESOLUTION(1),
        HIGH_RESOLUTION(2);

        private final int value;

        private ReadResolution(int value) {
            this.value = value;
        }

        public static ReadResolution fromValue(int val) {
            try {
                return ReadResolution.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum NearestNeighborMetric {
        METRIC_MAXIMUM(0),
        METRIC_SUM(1),
        METRIC_EUCLIDEAN(2);

        private final int value;

        private NearestNeighborMetric(int value) {
            this.value = value;
        }

        public static NearestNeighborMetric fromValue(int val) {
            try {
                return NearestNeighborMetric.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DrawMode {
        DRAW_VALUE(0),
        DRAW_INVERT(2),
        PAINT_VALUE(1),
        PAINT_INVERT(3),
        HIGHLIGHT_VALUE(4);

        private final int value;

        private DrawMode(int value) {
            this.value = value;
        }

        public static DrawMode fromValue(int val) {
            for (DrawMode v : DrawMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum EdgeProcess {
        FIRST(0),
        FIRST_AND_LAST(1),
        ALL(2),
        BEST(3);

        private final int value;

        private EdgeProcess(int value) {
            this.value = value;
        }

        public static EdgeProcess fromValue(int val) {
            try {
                return EdgeProcess.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FlipAxis {
        HORIZONTAL_AXIS(0),
        VERTICAL_AXIS(1),
        CENTER_AXIS(2),
        DIAG_L_TO_R_AXIS(3),
        DIAG_R_TO_L_AXIS(4);

        private final int value;

        private FlipAxis(int value) {
            this.value = value;
        }

        public static FlipAxis fromValue(int val) {
            try {
                return FlipAxis.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FontColor {
        WHITE(0),
        BLACK(1),
        INVERT(2),
        BLACK_ON_WHITE(3),
        WHITE_ON_BLACK(4);

        private final int value;

        private FontColor(int value) {
            this.value = value;
        }

        public static FontColor fromValue(int val) {
            try {
                return FontColor.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ImageFeatureMode {
        COLOR_AND_SHAPE_FEATURES(0),
        COLOR_FEATURES(1),
        SHAPE_FEATURES(2);

        private final int value;

        private ImageFeatureMode(int value) {
            this.value = value;
        }

        public static ImageFeatureMode fromValue(int val) {
            try {
                return ImageFeatureMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ImageType {
        IMAGE_U8(0),
        IMAGE_U16(7),
        IMAGE_I16(1),
        IMAGE_SGL(2),
        IMAGE_COMPLEX(3),
        IMAGE_RGB(4),
        IMAGE_HSL(5),
        IMAGE_RGB_U64(6);

        private final int value;

        private ImageType(int value) {
            this.value = value;
        }

        public static ImageType fromValue(int val) {
            for (ImageType v : ImageType.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum InterpolationMethod {
        ZERO_ORDER(0),
        BILINEAR(1),
        QUADRATIC(2),
        CUBIC_SPLINE(3),
        BILINEAR_FIXED(4);

        private final int value;

        private InterpolationMethod(int value) {
            this.value = value;
        }

        public static InterpolationMethod fromValue(int val) {
            try {
                return InterpolationMethod.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum KernelFamily {
        GRADIENT_FAMILY(0),
        LAPLACIAN_FAMILY(1),
        SMOOTHING_FAMILY(2),
        GAUSSIAN_FAMILY(3);

        private final int value;

        private KernelFamily(int value) {
            this.value = value;
        }

        public static KernelFamily fromValue(int val) {
            try {
                return KernelFamily.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LearningMode {
        LEARN_ALL(0),
        LEARN_SHIFT_INFORMATION(1),
        LEARN_ROTATION_INFORMATION(2);

        private final int value;

        private LearningMode(int value) {
            this.value = value;
        }

        public static LearningMode fromValue(int val) {
            try {
                return LearningMode.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Direction3D {
        C3D_NW(0),
        C3D_SW(1),
        C3D_SE(2),
        C3D_NE(3);

        private final int value;

        private Direction3D(int value) {
            this.value = value;
        }

        public static Direction3D fromValue(int val) {
            try {
                return Direction3D.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LineGaugeMethod {
        EDGE_TO_EDGE(0),
        EDGE_TO_POINT(1),
        POINT_TO_EDGE(2),
        POINT_TO_POINT(3);

        private final int value;

        private LineGaugeMethod(int value) {
            this.value = value;
        }

        public static LineGaugeMethod fromValue(int val) {
            try {
                return LineGaugeMethod.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ComparisonFunction {
        CLEAR_LESS(0),
        CLEAR_LESS_OR_EQUAL(1),
        CLEAR_EQUAL(2),
        CLEAR_GREATER_OR_EQUAL(3),
        CLEAR_GREATER(4);

        private final int value;

        private ComparisonFunction(int value) {
            this.value = value;
        }

        public static ComparisonFunction fromValue(int val) {
            try {
                return ComparisonFunction.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum MappingMethod {
        FULL_DYNAMIC(0),
        DOWNSHIFT(1),
        RANGE(2),
        C90_PCT_DYNAMIC(3),
        PERCENT_RANGE(4),
        DEFAULT_MAPPING(10),
        MOST_SIGNIFICANT(11),
        FULL_DYNAMIC_ALWAYS(12),
        DOWNSHIFT_ALWAYS(13),
        RANGE_ALWAYS(14),
        C90_PCT_DYNAMIC_ALWAYS(15),
        PERCENT_RANGE_ALWAYS(16);

        private final int value;

        private MappingMethod(int value) {
            this.value = value;
        }

        public static MappingMethod fromValue(int val) {
            for (MappingMethod v : MappingMethod.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum MatchingMode {
        MATCH_SHIFT_INVARIANT(1),
        MATCH_ROTATION_INVARIANT(2);

        private final int value;

        private MatchingMode(int value) {
            this.value = value;
        }

        public static MatchingMode fromValue(int val) {
            for (MatchingMode v : MatchingMode.values()) {
                if (v.value != val) continue;
                return v;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LevelType {
        ABSOLUTE(0),
        RELATIVE(1);

        private final int value;

        private LevelType(int value) {
            this.value = value;
        }

        public static LevelType fromValue(int val) {
            try {
                return LevelType.values()[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ColorIgnoreMode {
        IGNORE_NONE(0),
        IGNORE_BLACK(1),
        IGNORE_WHITE(2),
        IGNORE_BLACK_AND_WHITE(3);

        private final int value;

        private ColorIgnoreMode(int value) {
            this.value = value;
        }

        public static ColorI