/*
 * Decompiled with CFR 0.152.
 */
package com.kauailabs.navx.frc;

import java.util.Arrays;

class OffsetTracker {
    float[] value_history;
    int next_value_history_index;
    int history_len;
    double value_offset;

    public OffsetTracker(int history_length) {
        this.history_len = history_length;
        this.value_history = new float[this.history_len];
        Arrays.fill(this.value_history, 0.0f);
        this.next_value_history_index = 0;
        this.value_offset = 0.0;
    }

    public void updateHistory(float curr_value) {
        if (this.next_value_history_index >= this.history_len) {
            this.next_value_history_index = 0;
        }
        this.value_history[this.next_value_history_index] = curr_value;
        ++this.next_value_history_index;
    }

    public double getAverageFromHistory() {
        double value_history_sum = 0.0;
        for (int i = 0; i < this.history_len; ++i) {
            value_history_sum += (double)this.value_history[i];
        }
        double value_history_avg = value_history_sum / (double)this.history_len;
        return value_history_avg;
    }

    public void setOffset() {
        this.value_offset = this.getAverageFromHistory();
    }

    public double getOffset() {
        return this.value_offset;
    }

    public double applyOffset(double value) {
        float offseted_value = (float)(value - this.value_offset);
        if (offseted_value < -180.0f) {
            offseted_value += 360.0f;
        }
        if (offseted_value > 180.0f) {
            offseted_value -= 360.0f;
        }
        return offseted_value;
    }
}

