/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables.ConnectionInfo;
import edu.wpi.first.wpilibj.networktables.EntryInfo;
import edu.wpi.first.wpilibj.networktables.PersistentException;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class NetworkTablesJNI {
    static boolean libraryLoaded = false;
    static File jniLibrary = null;

    public static native boolean containsKey(String var0);

    public static native int getType(String var0);

    public static native boolean putBoolean(String var0, boolean var1);

    public static native boolean putDouble(String var0, double var1);

    public static native boolean putString(String var0, String var1);

    public static native boolean putRaw(String var0, byte[] var1);

    public static native boolean putRaw(String var0, ByteBuffer var1, int var2);

    public static native boolean putBooleanArray(String var0, boolean[] var1);

    public static native boolean putDoubleArray(String var0, double[] var1);

    public static native boolean putStringArray(String var0, String[] var1);

    public static native void forcePutBoolean(String var0, boolean var1);

    public static native void forcePutDouble(String var0, double var1);

    public static native void forcePutString(String var0, String var1);

    public static native void forcePutRaw(String var0, byte[] var1);

    public static native void forcePutRaw(String var0, ByteBuffer var1, int var2);

    public static native void forcePutBooleanArray(String var0, boolean[] var1);

    public static native void forcePutDoubleArray(String var0, double[] var1);

    public static native void forcePutStringArray(String var0, String[] var1);

    public static native Object getValue(String var0) throws TableKeyNotDefinedException;

    public static native boolean getBoolean(String var0) throws TableKeyNotDefinedException;

    public static native double getDouble(String var0) throws TableKeyNotDefinedException;

    public static native String getString(String var0) throws TableKeyNotDefinedException;

    public static native byte[] getRaw(String var0) throws TableKeyNotDefinedException;

    public static native boolean[] getBooleanArray(String var0) throws TableKeyNotDefinedException;

    public static native double[] getDoubleArray(String var0) throws TableKeyNotDefinedException;

    public static native String[] getStringArray(String var0) throws TableKeyNotDefinedException;

    public static native Object getValue(String var0, Object var1);

    public static native boolean getBoolean(String var0, boolean var1);

    public static native double getDouble(String var0, double var1);

    public static native String getString(String var0, String var1);

    public static native byte[] getRaw(String var0, byte[] var1);

    public static native boolean[] getBooleanArray(String var0, boolean[] var1);

    public static native double[] getDoubleArray(String var0, double[] var1);

    public static native String[] getStringArray(String var0, String[] var1);

    public static native void setEntryFlags(String var0, int var1);

    public static native int getEntryFlags(String var0);

    public static native void deleteEntry(String var0);

    public static native void deleteAllEntries();

    public static native EntryInfo[] getEntries(String var0, int var1);

    public static native void flush();

    public static native int addEntryListener(String var0, EntryListenerFunction var1, int var2);

    public static native void removeEntryListener(int var0);

    public static native int addConnectionListener(ConnectionListenerFunction var0, boolean var1);

    public static native void removeConnectionListener(int var0);

    public static native byte[] getRpc(String var0) throws TableKeyNotDefinedException;

    public static native byte[] getRpc(String var0, byte[] var1);

    public static native int callRpc(String var0, byte[] var1);

    public static native int callRpc(String var0, ByteBuffer var1, int var2);

    public static native void setNetworkIdentity(String var0);

    public static native void startServer(String var0, String var1, int var2);

    public static native void stopServer();

    public static native void startClient(String var0, int var1);

    public static native void stopClient();

    public static native void setUpdateRate(double var0);

    public static native ConnectionInfo[] getConnections();

    public static native void savePersistent(String var0) throws PersistentException;

    public static native String[] loadPersistent(String var0) throws PersistentException;

    public static native long now();

    public static native void setLogger(LoggerFunction var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (!libraryLoaded) {
            block9: {
                try {
                    String osname = System.getProperty("os.name");
                    String resname = osname.startsWith("Windows") ? "/Windows/" + System.getProperty("os.arch") + "/" : "/" + osname + "/" + System.getProperty("os.arch") + "/";
                    System.out.println("platform: " + resname);
                    resname = osname.startsWith("Windows") ? resname + "ntcore.dll" : (osname.startsWith("Mac") ? resname + "libntcore.dylib" : resname + "libntcore.so");
                    InputStream is = NetworkTablesJNI.class.getResourceAsStream(resname);
                    if (is != null) {
                        jniLibrary = System.getProperty("os.name").startsWith("Windows") ? File.createTempFile("NetworkTablesJNI", ".dll") : (System.getProperty("os.name").startsWith("Mac") ? File.createTempFile("libNetworkTablesJNI", ".dylib") : File.createTempFile("libNetworkTablesJNI", ".so"));
                        jniLibrary.deleteOnExit();
                        FileOutputStream os = new FileOutputStream(jniLibrary);
                        byte[] buffer = new byte[1024];
                        try {
                            int readBytes;
                            while ((readBytes = is.read(buffer)) != -1) {
                                ((OutputStream)os).write(buffer, 0, readBytes);
                            }
                        }
                        finally {
                            ((OutputStream)os).close();
                            is.close();
                        }
                        System.load(jniLibrary.getAbsolutePath());
                        break block9;
                    }
                    System.loadLibrary("ntcore");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
            libraryLoaded = true;
        }
    }

    public static interface LoggerFunction {
        public void apply(int var1, String var2, int var3, String var4);
    }

    public static interface ConnectionListenerFunction {
        public void apply(int var1, boolean var2, ConnectionInfo var3);
    }

    public static interface EntryListenerFunction {
        public void apply(int var1, String var2, Object var3, int var4);
    }
}

