/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import com.ni.vision.NIVision;
import edu.wpi.first.wpilibj.image.BinaryImage;
import edu.wpi.first.wpilibj.image.NIVisionException;

public class ParticleAnalysisReport {
    public final int imageHeight;
    public final int imageWidth;
    public final int center_mass_x;
    public final int center_mass_y;
    public final double center_mass_x_normalized;
    public final double center_mass_y_normalized;
    public final double particleArea;
    public final int boundingRectLeft;
    public final int boundingRectTop;
    public final int boundingRectWidth;
    public final int boundingRectHeight;
    public final double particleToImagePercent;
    public final double particleQuality;

    ParticleAnalysisReport(BinaryImage image, int index) throws NIVisionException {
        this.imageHeight = image.getHeight();
        this.imageWidth = image.getWidth();
        this.center_mass_x = (int)NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_CENTER_OF_MASS_X);
        this.center_mass_y = (int)NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_CENTER_OF_MASS_Y);
        this.center_mass_x_normalized = 2.0 * (double)this.center_mass_x / (double)this.imageWidth - 1.0;
        this.center_mass_y_normalized = 2.0 * (double)this.center_mass_y / (double)this.imageHeight - 1.0;
        this.particleArea = NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_AREA);
        this.boundingRectLeft = (int)NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_BOUNDING_RECT_LEFT);
        this.boundingRectTop = (int)NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_BOUNDING_RECT_TOP);
        this.boundingRectWidth = (int)NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_BOUNDING_RECT_WIDTH);
        this.boundingRectHeight = (int)NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_BOUNDING_RECT_HEIGHT);
        this.particleToImagePercent = NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_AREA_BY_IMAGE_AREA);
        this.particleQuality = NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_AREA_BY_PARTICLE_AND_HOLES_AREA);
    }

    static double getParticleToImagePercent(BinaryImage image, int index) throws NIVisionException {
        return NIVision.imaqMeasureParticle(image.image, index, 0, NIVision.MeasurementType.MT_AREA_BY_IMAGE_AREA);
    }

    public String toString() {
        return "Particle Report: \n    Image Height    : " + this.imageHeight + "\n" + "    Image Width     : " + this.imageWidth + "\n" + "    Center of mass  : ( " + this.center_mass_x + " , " + this.center_mass_y + " )\n" + "      normalized    : ( " + this.center_mass_x_normalized + " , " + this.center_mass_y_normalized + " )\n" + "    Area            : " + this.particleArea + "\n" + "      percent       : " + this.particleToImagePercent + "\n" + "    Bounding Rect   : ( " + this.boundingRectLeft + " , " + this.boundingRectTop + " ) " + this.boundingRectWidth + "*" + this.boundingRectHeight + "\n" + "    Quality         : " + this.particleQuality + "\n";
    }
}

