/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import com.ni.vision.NIVision;
import edu.wpi.first.wpilibj.image.BinaryImage;
import edu.wpi.first.wpilibj.image.ImageBase;
import edu.wpi.first.wpilibj.image.MonoImage;
import edu.wpi.first.wpilibj.image.NIVisionException;

public abstract class ColorImage
extends ImageBase {
    ColorImage(NIVision.ImageType type) throws NIVisionException {
        super(type);
    }

    ColorImage(ColorImage sourceImage) {
        super(sourceImage);
    }

    private BinaryImage threshold(NIVision.ColorMode colorMode, int low1, int high1, int low2, int high2, int low3, int high3) throws NIVisionException {
        BinaryImage res = new BinaryImage();
        NIVision.Range range1 = new NIVision.Range(low1, high1);
        NIVision.Range range2 = new NIVision.Range(low2, high2);
        NIVision.Range range3 = new NIVision.Range(low3, high3);
        NIVision.imaqColorThreshold(res.image, this.image, 1, colorMode, range1, range2, range3);
        res.free();
        range1.free();
        range2.free();
        range3.free();
        return res;
    }

    public BinaryImage thresholdRGB(int redLow, int redHigh, int greenLow, int greenHigh, int blueLow, int blueHigh) throws NIVisionException {
        return this.threshold(NIVision.ColorMode.RGB, redLow, redHigh, greenLow, greenHigh, blueLow, blueHigh);
    }

    public BinaryImage thresholdHSL(int hueLow, int hueHigh, int saturationLow, int saturationHigh, int luminenceLow, int luminenceHigh) throws NIVisionException {
        return this.threshold(NIVision.ColorMode.HSL, hueLow, hueHigh, saturationLow, saturationHigh, luminenceLow, luminenceHigh);
    }

    public BinaryImage thresholdHSV(int hueLow, int hueHigh, int saturationLow, int saturationHigh, int valueLow, int valueHigh) throws NIVisionException {
        return this.threshold(NIVision.ColorMode.HSV, hueLow, hueHigh, saturationLow, saturationHigh, valueLow, valueHigh);
    }

    public BinaryImage thresholdHSI(int hueLow, int hueHigh, int saturationLow, int saturationHigh, int intansityLow, int intensityHigh) throws NIVisionException {
        return this.threshold(NIVision.ColorMode.HSI, hueLow, hueHigh, saturationLow, saturationHigh, intansityLow, intensityHigh);
    }

    MonoImage extractFirstColorPlane(NIVision.ColorMode mode) throws NIVisionException {
        MonoImage result = new MonoImage();
        NIVision.imaqExtractColorPlanes(this.image, mode, result.image, null, null);
        result.free();
        return result;
    }

    MonoImage extractSecondColorPlane(NIVision.ColorMode mode) throws NIVisionException {
        MonoImage result = new MonoImage();
        NIVision.imaqExtractColorPlanes(this.image, mode, null, result.image, null);
        result.free();
        return result;
    }

    MonoImage extractThirdColorPlane(NIVision.ColorMode mode) throws NIVisionException {
        MonoImage result = new MonoImage();
        NIVision.imaqExtractColorPlanes(this.image, mode, null, null, result.image);
        result.free();
        return result;
    }

    public MonoImage getRedPlane() throws NIVisionException {
        return this.extractFirstColorPlane(NIVision.ColorMode.RGB);
    }

    public MonoImage getGreenPlane() throws NIVisionException {
        return this.extractSecondColorPlane(NIVision.ColorMode.RGB);
    }

    public MonoImage getBluePlane() throws NIVisionException {
        return this.extractThirdColorPlane(NIVision.ColorMode.RGB);
    }

    public MonoImage getHSLHuePlane() throws NIVisionException {
        return this.extractFirstColorPlane(NIVision.ColorMode.HSL);
    }

    public MonoImage getHSVHuePlane() throws NIVisionException {
        return this.extractFirstColorPlane(NIVision.ColorMode.HSV);
    }

    public MonoImage getHSIHuePlane() throws NIVisionException {
        return this.extractFirstColorPlane(NIVision.ColorMode.HSI);
    }

    public MonoImage getHSLSaturationPlane() throws NIVisionException {
        return this.extractSecondColorPlane(NIVision.ColorMode.HSL);
    }

    public MonoImage getHSVSaturationPlane() throws NIVisionException {
        return this.extractSecondColorPlane(NIVision.ColorMode.HSV);
    }

    public MonoImage getHSISaturationPlane() throws NIVisionException {
        return this.extractSecondColorPlane(NIVision.ColorMode.HSI);
    }

    public MonoImage getLuminancePlane() throws NIVisionException {
        return this.extractThirdColorPlane(NIVision.ColorMode.HSL);
    }

    public MonoImage getValuePlane() throws NIVisionException {
        return this.extractThirdColorPlane(NIVision.ColorMode.HSV);
    }

    public MonoImage getIntensityPlane() throws NIVisionException {
        return this.extractThirdColorPlane(NIVision.ColorMode.HSI);
    }

    ColorImage replaceFirstColorPlane(NIVision.ColorMode mode, MonoImage plane) throws NIVisionException {
        NIVision.imaqReplaceColorPlanes(this.image, this.image, mode, plane.image, null, null);
        return this;
    }

    ColorImage replaceSecondColorPlane(NIVision.ColorMode mode, MonoImage plane) throws NIVisionException {
        NIVision.imaqReplaceColorPlanes(this.image, this.image, mode, null, plane.image, null);
        return this;
    }

    ColorImage replaceThirdColorPlane(NIVision.ColorMode mode, MonoImage plane) throws NIVisionException {
        NIVision.imaqReplaceColorPlanes(this.image, this.image, mode, null, null, plane.image);
        return this;
    }

    public ColorImage replaceRedPlane(MonoImage plane) throws NIVisionException {
        return this.replaceFirstColorPlane(NIVision.ColorMode.RGB, plane);
    }

    public ColorImage replaceGreenPlane(MonoImage plane) throws NIVisionException {
        return this.replaceSecondColorPlane(NIVision.ColorMode.RGB, plane);
    }

    public ColorImage replaceBluePlane(MonoImage plane) throws NIVisionException {
        return this.replaceThirdColorPlane(NIVision.ColorMode.RGB, plane);
    }

    public ColorImage replaceHSLHuePlane(MonoImage plane) throws NIVisionException {
        return this.replaceFirstColorPlane(NIVision.ColorMode.HSL, plane);
    }

    public ColorImage replaceHSVHuePlane(MonoImage plane) throws NIVisionException {
        return this.replaceFirstColorPlane(NIVision.ColorMode.HSV, plane);
    }

    public ColorImage replaceHSIHuePlane(MonoImage plane) throws NIVisionException {
        return this.replaceFirstColorPlane(NIVision.ColorMode.HSI, plane);
    }

    public ColorImage replaceHSLSaturationPlane(MonoImage plane) throws NIVisionException {
        return this.replaceSecondColorPlane(NIVision.ColorMode.HSL, plane);
    }

    public ColorImage replaceHSVSaturationPlane(MonoImage plane) throws NIVisionException {
        return this.replaceSecondColorPlane(NIVision.ColorMode.HSV, plane);
    }

    public ColorImage replaceHSISaturationPlane(MonoImage plane) throws NIVisionException {
        return this.replaceSecondColorPlane(NIVision.ColorMode.HSI, plane);
    }

    public ColorImage replaceLuminancePlane(MonoImage plane) throws NIVisionException {
        return this.replaceThirdColorPlane(NIVision.ColorMode.HSL, plane);
    }

    public ColorImage replaceValuePlane(MonoImage plane) throws NIVisionException {
        return this.replaceThirdColorPlane(NIVision.ColorMode.HSV, plane);
    }

    public ColorImage replaceIntensityPlane(MonoImage plane) throws NIVisionException {
        return this.replaceThirdColorPlane(NIVision.ColorMode.HSI, plane);
    }

    public ColorImage colorEqualize() throws NIVisionException {
        NIVision.imaqColorEqualize(this.image, this.image, 1);
        return this;
    }

    public ColorImage luminanceEqualize() throws NIVisionException {
        NIVision.imaqColorEqualize(this.image, this.image, 0);
        return this;
    }
}

