/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import com.ni.vision.NIVision;
import edu.wpi.first.wpilibj.image.MonoImage;
import edu.wpi.first.wpilibj.image.NIVisionException;
import edu.wpi.first.wpilibj.image.ParticleAnalysisReport;
import edu.wpi.first.wpilibj.util.SortedVector;

public class BinaryImage
extends MonoImage {
    private int numParticles = -1;

    BinaryImage() throws NIVisionException {
    }

    BinaryImage(BinaryImage sourceImage) {
        super(sourceImage);
    }

    public int getNumberParticles() throws NIVisionException {
        if (this.numParticles < 0) {
            this.numParticles = NIVision.imaqCountParticles(this.image, 1);
        }
        return this.numParticles;
    }

    public ParticleAnalysisReport getParticleAnalysisReport(int index) throws NIVisionException {
        if (index >= this.getNumberParticles()) {
            throw new IndexOutOfBoundsException();
        }
        return new ParticleAnalysisReport(this, index);
    }

    public ParticleAnalysisReport[] getOrderedParticleAnalysisReports(int size) throws NIVisionException {
        if (size > this.getNumberParticles()) {
            size = this.getNumberParticles();
        }
        Object[] reports = new ParticleSizeReport[size];
        SortedVector sorter = new SortedVector(new SortedVector.Comparator(){

            @Override
            public int compare(Object object1, Object object2) {
                ParticleSizeReport p1 = (ParticleSizeReport)object1;
                ParticleSizeReport p2 = (ParticleSizeReport)object2;
                if (p1.size < p2.size) {
                    return -1;
                }
                if (p1.size > p2.size) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < this.getNumberParticles(); ++i) {
            sorter.addElement(new ParticleSizeReport(i));
        }
        sorter.setSize(size);
        sorter.copyInto(reports);
        ParticleAnalysisReport[] finalReports = new ParticleAnalysisReport[reports.length];
        for (int i = 0; i < finalReports.length; ++i) {
            finalReports[i] = ((ParticleSizeReport)reports[i]).getParticleAnalysisReport();
        }
        return finalReports;
    }

    public ParticleAnalysisReport[] getOrderedParticleAnalysisReports() throws NIVisionException {
        return this.getOrderedParticleAnalysisReports(this.getNumberParticles());
    }

    @Override
    public void write(String fileName) throws NIVisionException {
        NIVision.RGBValue colorTable = new NIVision.RGBValue(0, 0, 255, 0);
        try {
            NIVision.imaqWriteFile(this.image, fileName, colorTable);
        }
        finally {
            colorTable.free();
        }
    }

    public BinaryImage removeSmallObjects(boolean connectivity8, int erosions) throws NIVisionException {
        BinaryImage result = new BinaryImage();
        NIVision.imaqSizeFilter(result.image, this.image, connectivity8 ? 1 : 0, erosions, NIVision.SizeType.KEEP_LARGE, null);
        result.free();
        return result;
    }

    public BinaryImage removeLargeObjects(boolean connectivity8, int erosions) throws NIVisionException {
        BinaryImage result = new BinaryImage();
        NIVision.imaqSizeFilter(result.image, this.image, connectivity8 ? 1 : 0, erosions, NIVision.SizeType.KEEP_SMALL, null);
        return result;
    }

    public BinaryImage convexHull(boolean connectivity8) throws NIVisionException {
        BinaryImage result = new BinaryImage();
        NIVision.imaqConvexHull(result.image, this.image, connectivity8 ? 1 : 0);
        return result;
    }

    public BinaryImage particleFilter(NIVision.ParticleFilterCriteria2[] criteria) throws NIVisionException {
        BinaryImage result = new BinaryImage();
        NIVision.ParticleFilterOptions2 options = new NIVision.ParticleFilterOptions2(0, 0, 0, 1);
        NIVision.imaqParticleFilter4(result.image, this.image, criteria, options, null);
        options.free();
        return result;
    }

    private class ParticleSizeReport {
        final int index;
        final double size;

        public ParticleSizeReport(int index) throws NIVisionException {
            if (index >= BinaryImage.this.getNumberParticles() || index < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.index = index;
            this.size = ParticleAnalysisReport.getParticleToImagePercent(BinaryImage.this, index);
        }

        public ParticleAnalysisReport getParticleAnalysisReport() throws NIVisionException {
            return new ParticleAnalysisReport(BinaryImage.this, this.index);
        }
    }
}

