/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.PIDController;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.tables.ITable;

public abstract class PIDSubsystem
extends Subsystem
implements Sendable {
    private PIDController controller;
    private PIDOutput output = new PIDOutput(){

        @Override
        public void pidWrite(double output) {
            PIDSubsystem.this.usePIDOutput(output);
        }
    };
    private PIDSource source = new PIDSource(){

        @Override
        public void setPIDSourceType(PIDSourceType pidSource) {
        }

        @Override
        public PIDSourceType getPIDSourceType() {
            return PIDSourceType.kDisplacement;
        }

        @Override
        public double pidGet() {
            return PIDSubsystem.this.returnPIDInput();
        }
    };

    public PIDSubsystem(String name, double p, double i, double d) {
        super(name);
        this.controller = new PIDController(p, i, d, this.source, this.output);
    }

    public PIDSubsystem(String name, double p, double i, double d, double f) {
        super(name);
        this.controller = new PIDController(p, i, d, f, this.source, this.output);
    }

    public PIDSubsystem(String name, double p, double i, double d, double f, double period) {
        super(name);
        this.controller = new PIDController(p, i, d, f, this.source, this.output, period);
    }

    public PIDSubsystem(double p, double i, double d) {
        this.controller = new PIDController(p, i, d, this.source, this.output);
    }

    public PIDSubsystem(double p, double i, double d, double period, double f) {
        this.controller = new PIDController(p, i, d, f, this.source, this.output, period);
    }

    public PIDSubsystem(double p, double i, double d, double period) {
        this.controller = new PIDController(p, i, d, this.source, this.output, period);
    }

    public PIDController getPIDController() {
        return this.controller;
    }

    public void setSetpointRelative(double deltaSetpoint) {
        this.setSetpoint(this.getPosition() + deltaSetpoint);
    }

    public void setSetpoint(double setpoint) {
        this.controller.setSetpoint(setpoint);
    }

    public double getSetpoint() {
        return this.controller.getSetpoint();
    }

    public double getPosition() {
        return this.returnPIDInput();
    }

    public void setInputRange(double minimumInput, double maximumInput) {
        this.controller.setInputRange(minimumInput, maximumInput);
    }

    public void setOutputRange(double minimumOutput, double maximumOutput) {
        this.controller.setOutputRange(minimumOutput, maximumOutput);
    }

    public void setAbsoluteTolerance(double t) {
        this.controller.setAbsoluteTolerance(t);
    }

    public void setPercentTolerance(double p) {
        this.controller.setPercentTolerance(p);
    }

    public boolean onTarget() {
        return this.controller.onTarget();
    }

    protected abstract double returnPIDInput();

    protected abstract void usePIDOutput(double var1);

    public void enable() {
        this.controller.enable();
    }

    public void disable() {
        this.controller.disable();
    }

    @Override
    public String getSmartDashboardType() {
        return "PIDSubsystem";
    }

    @Override
    public void initTable(ITable table) {
        this.controller.initTable(table);
        super.initTable(table);
    }
}

