/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.PIDController;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.tables.ITable;

public abstract class PIDCommand
extends Command
implements Sendable {
    private PIDController controller;
    private PIDOutput output = new PIDOutput(){

        @Override
        public void pidWrite(double output) {
            PIDCommand.this.usePIDOutput(output);
        }
    };
    private PIDSource source = new PIDSource(){

        @Override
        public void setPIDSourceType(PIDSourceType pidSource) {
        }

        @Override
        public PIDSourceType getPIDSourceType() {
            return PIDSourceType.kDisplacement;
        }

        @Override
        public double pidGet() {
            return PIDCommand.this.returnPIDInput();
        }
    };

    public PIDCommand(String name, double p, double i, double d) {
        super(name);
        this.controller = new PIDController(p, i, d, this.source, this.output);
    }

    public PIDCommand(String name, double p, double i, double d, double period) {
        super(name);
        this.controller = new PIDController(p, i, d, this.source, this.output, period);
    }

    public PIDCommand(double p, double i, double d) {
        this.controller = new PIDController(p, i, d, this.source, this.output);
    }

    public PIDCommand(double p, double i, double d, double period) {
        this.controller = new PIDController(p, i, d, this.source, this.output, period);
    }

    protected PIDController getPIDController() {
        return this.controller;
    }

    @Override
    void _initialize() {
        this.controller.enable();
    }

    @Override
    void _end() {
        this.controller.disable();
    }

    @Override
    void _interrupted() {
        this._end();
    }

    public void setSetpointRelative(double deltaSetpoint) {
        this.setSetpoint(this.getSetpoint() + deltaSetpoint);
    }

    protected void setSetpoint(double setpoint) {
        this.controller.setSetpoint(setpoint);
    }

    protected double getSetpoint() {
        return this.controller.getSetpoint();
    }

    protected double getPosition() {
        return this.returnPIDInput();
    }

    protected void setInputRange(double minimumInput, double maximumInput) {
        this.controller.setInputRange(minimumInput, maximumInput);
    }

    protected abstract double returnPIDInput();

    protected abstract void usePIDOutput(double var1);

    @Override
    public String getSmartDashboardType() {
        return "PIDCommand";
    }

    @Override
    public void initTable(ITable table) {
        this.controller.initTable(table);
        super.initTable(table);
    }
}

