/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PWM;
import edu.wpi.first.wpilibj.SafePWM;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;

public class Victor
extends SafePWM
implements SpeedController {
    private boolean isInverted = false;

    private void initVictor() {
        this.setBounds(2.027, 1.525, 1.507, 1.49, 1.026);
        this.setPeriodMultiplier(PWM.PeriodMultiplier.k2X);
        this.setRaw(this.m_centerPwm);
        this.setZeroLatch();
        LiveWindow.addActuator("Victor", this.getChannel(), (LiveWindowSendable)this);
        UsageReporting.report(38, this.getChannel());
    }

    public Victor(int channel) {
        super(channel);
        this.initVictor();
    }

    @Override
    public void set(double speed, byte syncGroup) {
        this.setSpeed(this.isInverted ? -speed : speed);
        this.Feed();
    }

    @Override
    public void set(double speed) {
        this.setSpeed(this.isInverted ? -speed : speed);
        this.Feed();
    }

    @Override
    public void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
    }

    @Override
    public boolean getInverted() {
        return this.isInverted;
    }

    @Override
    public double get() {
        return this.getSpeed();
    }

    @Override
    public void pidWrite(double output) {
        this.set(output);
    }
}

