/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PWM;
import edu.wpi.first.wpilibj.SafePWM;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;

public class TalonSRX
extends SafePWM
implements SpeedController {
    private boolean isInverted = false;

    protected void initTalonSRX() {
        this.setBounds(2.004, 1.52, 1.5, 1.48, 0.997);
        this.setPeriodMultiplier(PWM.PeriodMultiplier.k1X);
        this.setRaw(this.m_centerPwm);
        this.setZeroLatch();
        LiveWindow.addActuator("TalonSRX", this.getChannel(), (LiveWindowSendable)this);
        UsageReporting.report(51, this.getChannel());
    }

    public TalonSRX(int channel) {
        super(channel);
        this.initTalonSRX();
    }

    @Override
    public void set(double speed, byte syncGroup) {
        this.setSpeed(this.isInverted ? -speed : speed);
        this.Feed();
    }

    @Override
    public void set(double speed) {
        this.setSpeed(this.isInverted ? -speed : speed);
        this.Feed();
    }

    @Override
    public void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
    }

    @Override
    public boolean getInverted() {
        return this.isInverted;
    }

    @Override
    public double get() {
        return this.getSpeed();
    }

    @Override
    public void pidWrite(double output) {
        this.set(output);
    }
}

