/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.SolenoidJNI;

public abstract class SolenoidBase
extends SensorBase {
    private long[] m_ports;
    protected int m_moduleNumber;
    protected static Resource m_allocated = new Resource(504);

    public SolenoidBase(int moduleNumber) {
        this.m_moduleNumber = moduleNumber;
        this.m_ports = new long[8];
        for (int i = 0; i < 8; ++i) {
            long port = SolenoidJNI.getPortWithModule((byte)moduleNumber, (byte)i);
            this.m_ports[i] = SolenoidJNI.initializeSolenoidPort(port);
        }
    }

    @Override
    public void free() {
        for (int i = 0; i < this.m_ports.length; ++i) {
            SolenoidJNI.freeSolenoidPort(this.m_ports[i]);
            this.m_ports[i] = 0L;
        }
    }

    protected synchronized void set(int value, int mask) {
        for (int i = 0; i < 8; ++i) {
            int local_mask = 1 << i;
            if ((mask & local_mask) == 0) continue;
            SolenoidJNI.setSolenoid(this.m_ports[i], (value & local_mask) != 0);
        }
    }

    public byte getAll() {
        return SolenoidJNI.getAllSolenoids(this.m_ports[0]);
    }

    public byte getPCMSolenoidBlackList() {
        return (byte)SolenoidJNI.getPCMSolenoidBlackList(this.m_ports[0]);
    }

    public boolean getPCMSolenoidVoltageStickyFault() {
        return SolenoidJNI.getPCMSolenoidVoltageStickyFault(this.m_ports[0]);
    }

    public boolean getPCMSolenoidVoltageFault() {
        return SolenoidJNI.getPCMSolenoidVoltageFault(this.m_ports[0]);
    }

    public void clearAllPCMStickyFaults() {
        SolenoidJNI.clearAllPCMStickyFaults(this.m_ports[0]);
    }
}

