/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.HLUsageReporting;
import edu.wpi.first.wpilibj.RobotState;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.FRCNetworkCommunicationsLibrary;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.internal.HardwareHLUsageReporting;
import edu.wpi.first.wpilibj.internal.HardwareTimer;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.Manifest;

public abstract class RobotBase {
    public static final int ROBOT_TASK_PRIORITY = 101;
    protected final DriverStation m_ds;

    protected RobotBase() {
        NetworkTable.setNetworkIdentity("Robot");
        NetworkTable.setPersistentFilename("/home/lvuser/networktables.ini");
        NetworkTable.setServerMode();
        this.m_ds = DriverStation.getInstance();
        NetworkTable.getTable("");
        NetworkTable.getTable("LiveWindow").getSubTable("~STATUS~").putBoolean("LW Enabled", false);
    }

    public void free() {
    }

    public static boolean isSimulation() {
        return false;
    }

    public static boolean isReal() {
        return true;
    }

    public boolean isDisabled() {
        return this.m_ds.isDisabled();
    }

    public boolean isEnabled() {
        return this.m_ds.isEnabled();
    }

    public boolean isAutonomous() {
        return this.m_ds.isAutonomous();
    }

    public boolean isTest() {
        return this.m_ds.isTest();
    }

    public boolean isOperatorControl() {
        return this.m_ds.isOperatorControl();
    }

    public boolean isNewDataAvailable() {
        return this.m_ds.isNewControlData();
    }

    public abstract void startCompetition();

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String propVal = System.getProperty(name);
        if (propVal == null) {
            return defaultValue;
        }
        if (propVal.equalsIgnoreCase("false")) {
            return false;
        }
        if (propVal.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalStateException(propVal);
    }

    public static void initializeHardwareConfiguration() {
        FRCNetworkCommunicationsLibrary.FRCNetworkCommunicationReserve();
        Timer.SetImplementation(new HardwareTimer());
        HLUsageReporting.SetImplementation(new HardwareHLUsageReporting());
        RobotState.SetImplementation(DriverStation.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RobotBase robot;
        RobotBase.initializeHardwareConfiguration();
        UsageReporting.report(2, 3);
        String robotName = "";
        Enumeration<URL> resources = null;
        try {
            resources = RobotBase.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (resources != null && resources.hasMoreElements()) {
            try {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                robotName = manifest.getMainAttributes().getValue("Robot-Class");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            robot = (RobotBase)Class.forName(robotName).newInstance();
        }
        catch (Throwable t) {
            DriverStation.reportError("ERROR Unhandled exception instantiating robot " + robotName + " " + t.toString() + " at " + Arrays.toString(t.getStackTrace()), false);
            System.err.println("WARNING: Robots don't quit!");
            System.err.println("ERROR: Could not instantiate robot " + robotName + "!");
            System.exit(1);
            return;
        }
        File file = null;
        FileOutputStream output = null;
        try {
            file = new File("/tmp/frc_versions/FRC_Lib_Version.ini");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            output = new FileOutputStream(file);
            output.write("2016 Java Beta5.0".getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ex) {}
            }
        }
        boolean errorOnExit = false;
        try {
            robot.startCompetition();
        }
        catch (Throwable t) {
            DriverStation.reportError("ERROR Unhandled exception: " + t.toString() + " at " + Arrays.toString(t.getStackTrace()), false);
            errorOnExit = true;
        }
        finally {
            System.err.println("WARNING: Robots don't quit!");
            if (errorOnExit) {
                System.err.println("---> The startCompetition() method (or methods called by it) should have handled the exception above.");
            } else {
                System.err.println("---> Unexpected return from startCompetition() method.");
            }
        }
        System.exit(1);
    }
}

