/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.hal.RelayJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class Relay
extends SensorBase
implements MotorSafety,
LiveWindowSendable {
    private MotorSafetyHelper m_safetyHelper;
    private final int m_channel;
    private long m_port;
    private Direction m_direction;
    private static Resource relayChannels = new Resource(8);
    private ITable m_table;
    private ITableListener m_table_listener;

    private void initRelay() {
        SensorBase.checkRelayChannel(this.m_channel);
        try {
            if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                relayChannels.allocate(this.m_channel * 2);
                UsageReporting.report(30, this.m_channel);
            }
            if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kReverse) {
                relayChannels.allocate(this.m_channel * 2 + 1);
                UsageReporting.report(30, this.m_channel + 128);
            }
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Relay channel " + this.m_channel + " is already allocated");
        }
        this.m_port = DIOJNI.initializeDigitalPort(DIOJNI.getPort((byte)this.m_channel));
        this.m_safetyHelper = new MotorSafetyHelper(this);
        this.m_safetyHelper.setSafetyEnabled(false);
        LiveWindow.addActuator("Relay", this.m_channel, (LiveWindowSendable)this);
    }

    public Relay(int channel, Direction direction) {
        if (direction == null) {
            throw new NullPointerException("Null Direction was given");
        }
        this.m_channel = channel;
        this.m_direction = direction;
        this.initRelay();
        this.set(Value.kOff);
    }

    public Relay(int channel) {
        this(channel, Direction.kBoth);
    }

    @Override
    public void free() {
        if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
            relayChannels.free(this.m_channel * 2);
        }
        if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kReverse) {
            relayChannels.free(this.m_channel * 2 + 1);
        }
        RelayJNI.setRelayForward(this.m_port, false);
        RelayJNI.setRelayReverse(this.m_port, false);
        DIOJNI.freeDIO(this.m_port);
        DIOJNI.freeDigitalPort(this.m_port);
        this.m_port = 0L;
    }

    public void set(Value value) {
        switch (value) {
            case kOff: {
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    RelayJNI.setRelayForward(this.m_port, false);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                RelayJNI.setRelayReverse(this.m_port, false);
                break;
            }
            case kOn: {
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    RelayJNI.setRelayForward(this.m_port, true);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                RelayJNI.setRelayReverse(this.m_port, true);
                break;
            }
            case kForward: {
                if (this.m_direction == Direction.kReverse) {
                    throw new InvalidValueException("A relay configured for reverse cannot be set to forward");
                }
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    RelayJNI.setRelayForward(this.m_port, true);
                }
                if (this.m_direction != Direction.kBoth) break;
                RelayJNI.setRelayReverse(this.m_port, false);
                break;
            }
            case kReverse: {
                if (this.m_direction == Direction.kForward) {
                    throw new InvalidValueException("A relay configured for forward cannot be set to reverse");
                }
                if (this.m_direction == Direction.kBoth) {
                    RelayJNI.setRelayForward(this.m_port, false);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                RelayJNI.setRelayReverse(this.m_port, true);
                break;
            }
        }
    }

    public Value get() {
        if (RelayJNI.getRelayForward(this.m_port)) {
            if (RelayJNI.getRelayReverse(this.m_port)) {
                return Value.kOn;
            }
            if (this.m_direction == Direction.kForward) {
                return Value.kOn;
            }
            return Value.kForward;
        }
        if (RelayJNI.getRelayReverse(this.m_port)) {
            if (this.m_direction == Direction.kReverse) {
                return Value.kOn;
            }
            return Value.kReverse;
        }
        return Value.kOff;
    }

    public int getChannel() {
        return this.m_channel;
    }

    @Override
    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    @Override
    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    @Override
    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    @Override
    public void stopMotor() {
        this.set(Value.kOff);
    }

    @Override
    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    @Override
    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    @Override
    public String getDescription() {
        return "Relay ID " + this.getChannel();
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new NullPointerException("Null Direction was given");
        }
        if (this.m_direction == direction) {
            return;
        }
        this.free();
        this.m_direction = direction;
        this.initRelay();
    }

    @Override
    public String getSmartDashboardType() {
        return "Relay";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            if (this.get() == Value.kOn) {
                this.m_table.putString("Value", "On");
            } else if (this.get() == Value.kForward) {
                this.m_table.putString("Value", "Forward");
            } else if (this.get() == Value.kReverse) {
                this.m_table.putString("Value", "Reverse");
            } else {
                this.m_table.putString("Value", "Off");
            }
        }
    }

    @Override
    public void startLiveWindowMode() {
        this.m_table_listener = new ITableListener(){

            @Override
            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                String val = (String)value;
                if (val.equals("Off")) {
                    Relay.this.set(Value.kOff);
                } else if (val.equals("On")) {
                    Relay.this.set(Value.kOn);
                } else if (val.equals("Forward")) {
                    Relay.this.set(Value.kForward);
                } else if (val.equals("Reverse")) {
                    Relay.this.set(Value.kReverse);
                }
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.m_table.removeTableListener(this.m_table_listener);
    }

    public static enum Direction {
        kBoth(0),
        kForward(1),
        kReverse(2);

        public final int value;

        private Direction(int value) {
            this.value = value;
        }
    }

    public static enum Value {
        kOff(0),
        kOn(1),
        kForward(2),
        kReverse(3);

        public final int value;

        private Value(int value) {
            this.value = value;
        }
    }

    public class InvalidValueException
    extends RuntimeException {
        public InvalidValueException(String message) {
            super(message);
        }
    }
}

