/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.hal.PWMJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.util.AllocationException;

public class PWM
extends SensorBase
implements LiveWindowSendable {
    private int m_channel;
    private long m_port;
    protected static final double kDefaultPwmPeriod = 5.05;
    protected static final double kDefaultPwmCenter = 1.5;
    protected static final int kDefaultPwmStepsDown = 1000;
    public static final int kPwmDisabled = 0;
    boolean m_eliminateDeadband;
    int m_maxPwm;
    int m_deadbandMaxPwm;
    int m_centerPwm;
    int m_deadbandMinPwm;
    int m_minPwm;
    private ITable m_table;
    private ITableListener m_table_listener;

    private void initPWM(int channel) {
        PWM.checkPWMChannel(channel);
        this.m_channel = channel;
        this.m_port = DIOJNI.initializeDigitalPort(DIOJNI.getPort((byte)this.m_channel));
        if (!PWMJNI.allocatePWMChannel(this.m_port)) {
            throw new AllocationException("PWM channel " + channel + " is already allocated");
        }
        PWMJNI.setPWM(this.m_port, (short)0);
        this.m_eliminateDeadband = false;
        UsageReporting.report(29, channel);
    }

    public PWM(int channel) {
        this.initPWM(channel);
    }

    @Override
    public void free() {
        if (this.m_port == 0L) {
            return;
        }
        PWMJNI.setPWM(this.m_port, (short)0);
        PWMJNI.freePWMChannel(this.m_port);
        PWMJNI.freeDIO(this.m_port);
        DIOJNI.freeDigitalPort(this.m_port);
        this.m_port = 0L;
    }

    public void enableDeadbandElimination(boolean eliminateDeadband) {
        this.m_eliminateDeadband = eliminateDeadband;
    }

    public void setBounds(int max, int deadbandMax, int center, int deadbandMin, int min) {
        this.m_maxPwm = max;
        this.m_deadbandMaxPwm = deadbandMax;
        this.m_centerPwm = center;
        this.m_deadbandMinPwm = deadbandMin;
        this.m_minPwm = min;
    }

    protected void setBounds(double max, double deadbandMax, double center, double deadbandMin, double min) {
        double loopTime = (double)DIOJNI.getLoopTiming() / 40000.0;
        this.m_maxPwm = (int)((max - 1.5) / loopTime + 1000.0 - 1.0);
        this.m_deadbandMaxPwm = (int)((deadbandMax - 1.5) / loopTime + 1000.0 - 1.0);
        this.m_centerPwm = (int)((center - 1.5) / loopTime + 1000.0 - 1.0);
        this.m_deadbandMinPwm = (int)((deadbandMin - 1.5) / loopTime + 1000.0 - 1.0);
        this.m_minPwm = (int)((min - 1.5) / loopTime + 1000.0 - 1.0);
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void setPosition(double pos) {
        if (pos < 0.0) {
            pos = 0.0;
        } else if (pos > 1.0) {
            pos = 1.0;
        }
        int rawValue = (int)(pos * (double)this.getFullRangeScaleFactor() + (double)this.getMinNegativePwm());
        this.setRaw(rawValue);
    }

    public double getPosition() {
        int value = this.getRaw();
        if (value < this.getMinNegativePwm()) {
            return 0.0;
        }
        if (value > this.getMaxPositivePwm()) {
            return 1.0;
        }
        return (double)(value - this.getMinNegativePwm()) / (double)this.getFullRangeScaleFactor();
    }

    final void setSpeed(double speed) {
        if (speed < -1.0) {
            speed = -1.0;
        } else if (speed > 1.0) {
            speed = 1.0;
        }
        int rawValue = speed == 0.0 ? this.getCenterPwm() : (speed > 0.0 ? (int)(speed * (double)this.getPositiveScaleFactor() + (double)this.getMinPositivePwm() + 0.5) : (int)(speed * (double)this.getNegativeScaleFactor() + (double)this.getMaxNegativePwm() + 0.5));
        this.setRaw(rawValue);
    }

    public double getSpeed() {
        int value = this.getRaw();
        if (value > this.getMaxPositivePwm()) {
            return 1.0;
        }
        if (value < this.getMinNegativePwm()) {
            return -1.0;
        }
        if (value > this.getMinPositivePwm()) {
            return (double)(value - this.getMinPositivePwm()) / (double)this.getPositiveScaleFactor();
        }
        if (value < this.getMaxNegativePwm()) {
            return (double)(value - this.getMaxNegativePwm()) / (double)this.getNegativeScaleFactor();
        }
        return 0.0;
    }

    public void setRaw(int value) {
        PWMJNI.setPWM(this.m_port, (short)value);
    }

    public int getRaw() {
        return PWMJNI.getPWM(this.m_port);
    }

    public void setPeriodMultiplier(PeriodMultiplier mult) {
        switch (mult.value) {
            case 4: {
                PWMJNI.setPWMPeriodScale(this.m_port, 3);
                break;
            }
            case 2: {
                PWMJNI.setPWMPeriodScale(this.m_port, 1);
                break;
            }
            case 1: {
                PWMJNI.setPWMPeriodScale(this.m_port, 0);
                break;
            }
        }
    }

    protected void setZeroLatch() {
        PWMJNI.latchPWMZero(this.m_port);
    }

    private int getMaxPositivePwm() {
        return this.m_maxPwm;
    }

    private int getMinPositivePwm() {
        return this.m_eliminateDeadband ? this.m_deadbandMaxPwm : this.m_centerPwm + 1;
    }

    private int getCenterPwm() {
        return this.m_centerPwm;
    }

    private int getMaxNegativePwm() {
        return this.m_eliminateDeadband ? this.m_deadbandMinPwm : this.m_centerPwm - 1;
    }

    private int getMinNegativePwm() {
        return this.m_minPwm;
    }

    private int getPositiveScaleFactor() {
        return this.getMaxPositivePwm() - this.getMinPositivePwm();
    }

    private int getNegativeScaleFactor() {
        return this.getMaxNegativePwm() - this.getMinNegativePwm();
    }

    private int getFullRangeScaleFactor() {
        return this.getMaxPositivePwm() - this.getMinNegativePwm();
    }

    @Override
    public String getSmartDashboardType() {
        return "Speed Controller";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getSpeed());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
        this.setSpeed(0.0);
        this.m_table_listener = new ITableListener(){

            @Override
            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                PWM.this.setSpeed((Double)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.setSpeed(0.0);
        this.m_table.removeTableListener(this.m_table_listener);
    }

    public static class PeriodMultiplier {
        public final int value;
        static final int k1X_val = 1;
        static final int k2X_val = 2;
        static final int k4X_val = 4;
        public static final PeriodMultiplier k1X = new PeriodMultiplier(1);
        public static final PeriodMultiplier k2X = new PeriodMultiplier(2);
        public static final PeriodMultiplier k4X = new PeriodMultiplier(4);

        private PeriodMultiplier(int value) {
            this.value = value;
        }
    }
}

