/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.RobotState;
import edu.wpi.first.wpilibj.Timer;

public class MotorSafetyHelper {
    double m_expiration;
    boolean m_enabled;
    double m_stopTime;
    MotorSafety m_safeObject;
    MotorSafetyHelper m_nextHelper;
    static MotorSafetyHelper m_headHelper = null;

    public MotorSafetyHelper(MotorSafety safeObject) {
        this.m_safeObject = safeObject;
        this.m_enabled = false;
        this.m_expiration = 0.1;
        this.m_stopTime = Timer.getFPGATimestamp();
        this.m_nextHelper = m_headHelper;
        m_headHelper = this;
    }

    public void feed() {
        this.m_stopTime = Timer.getFPGATimestamp() + this.m_expiration;
    }

    public void setExpiration(double expirationTime) {
        this.m_expiration = expirationTime;
    }

    public double getExpiration() {
        return this.m_expiration;
    }

    public boolean isAlive() {
        return !this.m_enabled || this.m_stopTime > Timer.getFPGATimestamp();
    }

    public void check() {
        if (!this.m_enabled || RobotState.isDisabled() || RobotState.isTest()) {
            return;
        }
        if (this.m_stopTime < Timer.getFPGATimestamp()) {
            System.err.println(this.m_safeObject.getDescription() + "... Output not updated often enough.");
            this.m_safeObject.stopMotor();
        }
    }

    public void setSafetyEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public boolean isSafetyEnabled() {
        return this.m_enabled;
    }

    public static void checkMotors() {
        MotorSafetyHelper msh = m_headHelper;
        while (msh != null) {
            msh.check();
            msh = msh.m_nextHelper;
        }
    }
}

