/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.communication.FRCNetworkCommunicationsLibrary;
import edu.wpi.first.wpilibj.communication.UsageReporting;

public class Joystick
extends GenericHID {
    static final byte kDefaultXAxis = 0;
    static final byte kDefaultYAxis = 1;
    static final byte kDefaultZAxis = 2;
    static final byte kDefaultTwistAxis = 2;
    static final byte kDefaultThrottleAxis = 3;
    static final int kDefaultTriggerButton = 1;
    static final int kDefaultTopButton = 2;
    private DriverStation m_ds = DriverStation.getInstance();
    private final int m_port;
    private final byte[] m_axes;
    private final byte[] m_buttons;
    private int m_outputs;
    private short m_leftRumble;
    private short m_rightRumble;

    public Joystick(int port) {
        this(port, AxisType.kNumAxis.value, ButtonType.kNumButton.value);
        this.m_axes[AxisType.kX.value] = 0;
        this.m_axes[AxisType.kY.value] = 1;
        this.m_axes[AxisType.kZ.value] = 2;
        this.m_axes[AxisType.kTwist.value] = 2;
        this.m_axes[AxisType.kThrottle.value] = 3;
        this.m_buttons[ButtonType.kTrigger.value] = 1;
        this.m_buttons[ButtonType.kTop.value] = 2;
        UsageReporting.report(24, port);
    }

    protected Joystick(int port, int numAxisTypes, int numButtonTypes) {
        this.m_axes = new byte[numAxisTypes];
        this.m_buttons = new byte[numButtonTypes];
        this.m_port = port;
    }

    @Override
    public double getX(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[AxisType.kX.value]);
    }

    @Override
    public double getY(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[AxisType.kY.value]);
    }

    @Override
    public double getZ(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[AxisType.kZ.value]);
    }

    @Override
    public double getTwist() {
        return this.getRawAxis(this.m_axes[AxisType.kTwist.value]);
    }

    @Override
    public double getThrottle() {
        return this.getRawAxis(this.m_axes[AxisType.kThrottle.value]);
    }

    @Override
    public double getRawAxis(int axis) {
        return this.m_ds.getStickAxis(this.m_port, axis);
    }

    public double getAxis(AxisType axis) {
        switch (axis.value) {
            case 0: {
                return this.getX();
            }
            case 1: {
                return this.getY();
            }
            case 2: {
                return this.getZ();
            }
            case 3: {
                return this.getTwist();
            }
            case 4: {
                return this.getThrottle();
            }
        }
        return 0.0;
    }

    public int getAxisCount() {
        return this.m_ds.getStickAxisCount(this.m_port);
    }

    @Override
    public boolean getTrigger(GenericHID.Hand hand) {
        return this.getRawButton(this.m_buttons[ButtonType.kTrigger.value]);
    }

    @Override
    public boolean getTop(GenericHID.Hand hand) {
        return this.getRawButton(this.m_buttons[ButtonType.kTop.value]);
    }

    @Override
    public boolean getBumper(GenericHID.Hand hand) {
        return false;
    }

    @Override
    public boolean getRawButton(int button) {
        return this.m_ds.getStickButton(this.m_port, (byte)button);
    }

    public int getButtonCount() {
        return this.m_ds.getStickButtonCount(this.m_port);
    }

    @Override
    public int getPOV(int pov) {
        return this.m_ds.getStickPOV(this.m_port, pov);
    }

    public int getPOVCount() {
        return this.m_ds.getStickPOVCount(this.m_port);
    }

    public boolean getButton(ButtonType button) {
        switch (button.value) {
            case 0: {
                return this.getTrigger();
            }
            case 1: {
                return this.getTop();
            }
        }
        return false;
    }

    public double getMagnitude() {
        return Math.sqrt(Math.pow(this.getX(), 2.0) + Math.pow(this.getY(), 2.0));
    }

    public double getDirectionRadians() {
        return Math.atan2(this.getX(), -this.getY());
    }

    public double getDirectionDegrees() {
        return Math.toDegrees(this.getDirectionRadians());
    }

    public int getAxisChannel(AxisType axis) {
        return this.m_axes[axis.value];
    }

    public void setAxisChannel(AxisType axis, int channel) {
        this.m_axes[axis.value] = (byte)channel;
    }

    public boolean getIsXbox() {
        return this.m_ds.getJoystickIsXbox(this.m_port);
    }

    public int getType() {
        return this.m_ds.getJoystickType(this.m_port);
    }

    public String getName() {
        return this.m_ds.getJoystickName(this.m_port);
    }

    public void setRumble(RumbleType type, float value) {
        if (value < 0.0f) {
            value = 0.0f;
        } else if (value > 1.0f) {
            value = 1.0f;
        }
        if (type.value == 0) {
            this.m_leftRumble = (short)(value * 65535.0f);
        } else {
            this.m_rightRumble = (short)(value * 65535.0f);
        }
        FRCNetworkCommunicationsLibrary.HALSetJoystickOutputs((byte)this.m_port, this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    public void setOutput(int outputNumber, boolean value) {
        this.m_outputs = this.m_outputs & ~(1 << outputNumber - 1) | (value ? 1 : 0) << outputNumber - 1;
        FRCNetworkCommunicationsLibrary.HALSetJoystickOutputs((byte)this.m_port, this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    public void setOutputs(int value) {
        this.m_outputs = value;
        FRCNetworkCommunicationsLibrary.HALSetJoystickOutputs((byte)this.m_port, this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    public static class RumbleType {
        public final int value;
        static final int kLeftRumble_val = 0;
        static final int kRightRumble_val = 1;
        public static final RumbleType kLeftRumble = new RumbleType(0);
        public static final RumbleType kRightRumble = new RumbleType(1);

        private RumbleType(int value) {
            this.value = value;
        }
    }

    public static class ButtonType {
        public final int value;
        static final int kTrigger_val = 0;
        static final int kTop_val = 1;
        static final int kNumButton_val = 2;
        public static final ButtonType kTrigger = new ButtonType(0);
        public static final ButtonType kTop = new ButtonType(1);
        public static final ButtonType kNumButton = new ButtonType(2);

        private ButtonType(int value) {
            this.value = value;
        }
    }

    public static class AxisType {
        public final int value;
        static final int kX_val = 0;
        static final int kY_val = 1;
        static final int kZ_val = 2;
        static final int kTwist_val = 3;
        static final int kThrottle_val = 4;
        static final int kNumAxis_val = 5;
        public static final AxisType kX = new AxisType(0);
        public static final AxisType kY = new AxisType(1);
        public static final AxisType kZ = new AxisType(2);
        public static final AxisType kTwist = new AxisType(3);
        public static final AxisType kThrottle = new AxisType(4);
        public static final AxisType kNumAxis = new AxisType(5);

        private AxisType(int value) {
            this.value = value;
        }
    }
}

