/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.InterruptHandlerFunction;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.InterruptJNI;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public abstract class InterruptableSensorBase
extends SensorBase {
    protected long m_interrupt = 0L;
    protected boolean m_isSynchronousInterrupt = false;
    protected int m_interruptIndex;
    protected static Resource interrupts = new Resource(8);

    abstract boolean getAnalogTriggerForRouting();

    abstract int getChannelForRouting();

    abstract byte getModuleForRouting();

    public void requestInterrupts(InterruptHandlerFunction<?> handler) {
        if (this.m_interrupt != 0L) {
            throw new AllocationException("The interrupt has already been allocated");
        }
        this.allocateInterrupts(false);
        assert (this.m_interrupt != 0L);
        InterruptJNI.requestInterrupts(this.m_interrupt, this.getModuleForRouting(), this.getChannelForRouting(), this.getAnalogTriggerForRouting());
        this.setUpSourceEdge(true, false);
        InterruptJNI.attachInterruptHandler(this.m_interrupt, handler.function, handler.overridableParameter());
    }

    public void requestInterrupts() {
        if (this.m_interrupt != 0L) {
            throw new AllocationException("The interrupt has already been allocated");
        }
        this.allocateInterrupts(true);
        assert (this.m_interrupt != 0L);
        InterruptJNI.requestInterrupts(this.m_interrupt, this.getModuleForRouting(), this.getChannelForRouting(), this.getAnalogTriggerForRouting());
        this.setUpSourceEdge(true, false);
    }

    protected void allocateInterrupts(boolean watcher) {
        try {
            this.m_interruptIndex = interrupts.allocate();
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("No interrupts are left to be allocated");
        }
        this.m_isSynchronousInterrupt = watcher;
        this.m_interrupt = InterruptJNI.initializeInterrupts(this.m_interruptIndex, watcher);
    }

    public void cancelInterrupts() {
        if (this.m_interrupt == 0L) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        InterruptJNI.cleanInterrupts(this.m_interrupt);
        this.m_interrupt = 0L;
        interrupts.free(this.m_interruptIndex);
    }

    public WaitResult waitForInterrupt(double timeout, boolean ignorePrevious) {
        if (this.m_interrupt == 0L) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        int result = InterruptJNI.waitForInterrupt(this.m_interrupt, timeout, ignorePrevious);
        return WaitResult.valueOf(result);
    }

    public WaitResult waitForInterrupt(double timeout) {
        return this.waitForInterrupt(timeout, true);
    }

    public void enableInterrupts() {
        if (this.m_interrupt == 0L) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        if (this.m_isSynchronousInterrupt) {
            throw new IllegalStateException("You do not need to enable synchronous interrupts");
        }
        InterruptJNI.enableInterrupts(this.m_interrupt);
    }

    public void disableInterrupts() {
        if (this.m_interrupt == 0L) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        if (this.m_isSynchronousInterrupt) {
            throw new IllegalStateException("You can not disable synchronous interrupts");
        }
        InterruptJNI.disableInterrupts(this.m_interrupt);
    }

    public double readRisingTimestamp() {
        if (this.m_interrupt == 0L) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        return InterruptJNI.readRisingTimestamp(this.m_interrupt);
    }

    public double readFallingTimestamp() {
        if (this.m_interrupt == 0L) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        return InterruptJNI.readFallingTimestamp(this.m_interrupt);
    }

    public void setUpSourceEdge(boolean risingEdge, boolean fallingEdge) {
        if (this.m_interrupt == 0L) {
            throw new IllegalArgumentException("You must call RequestInterrupts before setUpSourceEdge");
        }
        InterruptJNI.setInterruptUpSourceEdge(this.m_interrupt, risingEdge, fallingEdge);
    }

    public static enum WaitResult {
        kTimeout(0),
        kRisingEdge(1),
        kFallingEdge(256),
        kBoth(257);

        public final int value;

        public static WaitResult valueOf(int value) {
            for (WaitResult mode : WaitResult.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private WaitResult(int value) {
            this.value = value;
        }
    }
}

